/*	
 *	util.h
 *
 *	WDMfoCXhCoėp[`
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Aug 03 21:57:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __UTIL_H__
#define __UTIL_H__

/****************************************************************************
 *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <wdm.h>	/* This module defines the WDM types, constants, and functions that are exposed to device drivers. */
#include <usbdi.h>	/* Structures common to the USBD and USB device drivers. */
#include <usbdlib.h>	/* Services exported by USBD. */
#include <ntddser.h>	/* This is the include file that defines all constants and types for accessing the Serial device. */

/****************************************************************************
 *
 ****************************************************************************/

LARGE_INTEGER* relative_timeout(LARGE_INTEGER* timeout, int msec);
const char* pnp_minor_function_name(int code);
const char* serial_ioctl_name(int code);
NTSTATUS complete_request(IRP* irp, NTSTATUS status, int information);
NTSTATUS call_driver(DEVICE_OBJECT* device_object, IRP* irp);
NTSTATUS call_usbd(DEVICE_OBJECT* usbd, URB* urb);
NTSTATUS wait_for_terminate_thread(HANDLE thread_handle);
KEY_VALUE_FULL_INFORMATION* query_value_key(HANDLE key_handle, PCWSTR value_name);
NTSTATUS set_value_key(HANDLE key_handle, PCWSTR value_name, int type, const void* data, int data_size);
PKTHREAD create_thread(void (*start_routine)(void*), void* start_context);
void delete_thread(PKTHREAD thread_object);
void* register_serialcomm(DEVICE_OBJECT* physical_device_object, const wchar_t* device_name);
void unregister_serialcomm(void* serialcomm);
USB_CONFIGURATION_DESCRIPTOR* get_configuration_descriptor(DEVICE_OBJECT* usbd, int i_configuration);
int set_configuration(DEVICE_OBJECT* usbd, USBD_PIPE_INFORMATION pipes[/*max_pipes*/], int max_pipes);
void unset_configuration(DEVICE_OBJECT* usbd);

/****************************************************************************
 *
 ****************************************************************************/

#endif /*__UTIL_H__*/
