/*	
 *	tx.c
 *
 *	PceCom - P/ECE USBVA|[gfoCXhCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Aug 03 21:57:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *
 ****************************************************************************/

static void tx_process_thread_routine(void* context);
static void tx_polling_thread_routine(void* context);

/****************************************************************************
 *
 ****************************************************************************/

/* L[̒ɂIRPɑ΂āÃLZ[`ݒ肵܂B
 */
static void
tx_cancel_from_queue_routine(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	/* IRPL[菜܂B */
	IoSetCancelRoutine(irp, NULL);
	RemoveEntryList(&irp->Tail.Overlay.ListEntry);

	/* IoCancelIrp()lXsbN܂B */
	IoReleaseCancelSpinLock(irp->CancelIrql);

	/* IRP܂B */
	complete_request(irp, STATUS_CANCELLED, 0);
}

/* ݂IRPɑ΂āÃLZ[`ݒ肵܂B
 */
static void
tx_cancel_current_irp_routine(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	ASSERT(device_extension->tx_current_irp == irp);

	/* IoCancelIrp()lXsbN܂B */
	IoReleaseCancelSpinLock(irp->CancelIrql);

	/* MXbhirp->Cancel𔻒fāAIRP܂B */
	KeSetEvent(&device_extension->tx_event_to_process, IO_NO_INCREMENT, FALSE);
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
tx_init(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	NTSTATUS status;

	KdPrint(("tx_init\n"));

	/* Cxg܂B */
	KeInitializeEvent(&device_extension->tx_event_to_process, SynchronizationEvent, FALSE);
	KeInitializeEvent(&device_extension->tx_event_to_polling, SynchronizationEvent, FALSE);

	/* Mobt@mۂ܂B */
	status = tx_resize(device_object, device_extension->tx_pipe.MaximumTransferSize);
	if(!NT_SUCCESS(status)) {
		KdPrint(("ExAllocatePool failed\n"));
		goto L_EXIT;
	}

	/* IRPL[܂B */
	InitializeListHead(&device_extension->tx_queue);
	ASSERT(device_extension->tx_queue.Flink);

	/* MXbhJn܂B */
	device_extension->tx_process_thread = create_thread(tx_process_thread_routine, device_object);
	if(!device_extension->tx_process_thread) {
		KdPrint(("create_thread failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}

	/* M|[OXbhJn܂B */
	device_extension->tx_polling_thread = create_thread(tx_polling_thread_routine, device_object);
	if(!device_extension->tx_polling_thread) {
		KdPrint(("create_thread failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}

L_EXIT:

	if(!NT_SUCCESS(status)) {
		tx_exit(device_object);
	}

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

void
tx_exit(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	KdPrint(("tx_exit\n"));

	///* cĂIRPׂĊ܂B */
	//if(device_extension->tx_queue.Flink) {
	//	tx_abort(device_object);
	//}
	//svH

	/* M|[OXbhI܂B */
	if(device_extension->tx_polling_thread) {
		delete_thread(device_extension->tx_polling_thread);
		device_extension->tx_polling_thread = NULL;
	}

	/* MXbhI܂B */
	if(device_extension->tx_process_thread) {
		delete_thread(device_extension->tx_process_thread);
		device_extension->tx_process_thread = NULL;
	}

	/* Mobt@J܂B */
	if(device_extension->tx_buffer) {
		ExFreePool(device_extension->tx_buffer);
		device_extension->tx_buffer = NULL;
	}
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_tx(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

#ifndef QUIET
	KdPrint(("dispatch_tx\n"));
#endif /*QUIET*/

	/* IRPL[֒ǉuԂɏLȂ̂ŁAɃ}[NĂ܂B(K{!!) */
	IoMarkIrpPending(irp);

ENTER_CS;
	/* IRPL[֒ǉ܂B */
	IoSetCancelRoutine(irp, tx_cancel_from_queue_routine);
	InsertTailList(&device_extension->tx_queue, &irp->Tail.Overlay.ListEntry);
LEAVE_CS;

	/* IRPL[oĒ~Ă(mȂ)AMXbhN܂B */
	KeSetEvent(&device_extension->tx_event_to_process, IO_NO_INCREMENT, FALSE);

	return STATUS_PENDING;
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
tx_resize(DEVICE_OBJECT* device_object, int capacity)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	NTSTATUS status = STATUS_SUCCESS;
	//
	void* new_buffer;

	KdPrint(("tx_resize\n"));

ENTER_CS;

	/* w肳ꂽobt@TCỸ݂obt@TCY傫΁Aobt@g܂B
	 * ݂̃obt@TCY΁A܂BSerial IOCTL̎dlłB
	 */
	if(capacity > device_extension->tx_capacity) {
		new_buffer = ExAllocatePool(NonPagedPool, capacity); /* DISPATCH_LEVELłANonPagedPool̊mۂ͉\ */
		if(new_buffer) {
			if(device_extension->tx_buffer) {
				memcpy(new_buffer, device_extension->tx_buffer, device_extension->tx_length);
				ExFreePool(device_extension->tx_buffer);
			}
			device_extension->tx_buffer = new_buffer;
			device_extension->tx_capacity = capacity;
		} else {
			KdPrint(("ExAllocatePool failed\n"));
			status = STATUS_UNSUCCESSFUL;
		}
	}

LEAVE_CS;

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

void
tx_abort(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	LIST_ENTRY irp_list;
	LIST_ENTRY* list_entry;
	IRP* irp;

	KdPrint(("tx_abort\n"));

	InitializeListHead(&irp_list);

ENTER_CS;

	/* IRPL[̒IRPSĎo܂B */
	while(!IsListEmpty(&device_extension->tx_queue)) {
		list_entry = RemoveHeadList(&device_extension->tx_queue);
		irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
		IoSetCancelRoutine(irp, NULL);
		InsertTailList(&irp_list, list_entry);
	}

	/* ݂IRP΁ALZv܂B */
	if(device_extension->tx_current_irp) {
		device_extension->tx_current_irp->Cancel = TRUE;
		KeSetEvent(&device_extension->tx_event_to_process, IO_NO_INCREMENT, FALSE);
	}

LEAVE_CS;

	/* IRPL[oIRPׂĊ܂B */
	while(!IsListEmpty(&irp_list)) {
		list_entry = RemoveHeadList(&irp_list);
		irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
		complete_request(irp, STATUS_CANCELLED, 0);
	}
}

/****************************************************************************
 *
 ****************************************************************************/

static
void tx_process_thread_routine(void* context)
{
	DEVICE_OBJECT* device_object = context;
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	KTIMER timeout_timer; /* v~ */
	//
	NTSTATUS status;
	LIST_ENTRY* list_entry;
	IRP* irp;
	IO_STACK_LOCATION* stack_location;
	unsigned char* buffer;
	int length;
	int copy_length;
	int total_length;
	int timeout_msec;
	LARGE_INTEGER timeout;
	//
	void* wait_objects[3];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	KdPrint(("tx_process_thread_routine start\n"));

	/* ^CAEg^C}܂B */
	KeInitializeTimer(&timeout_timer);

	for(;;) {
		/* L[玟IRPo܂B */
		wait_objects[0] = &device_extension->terminate_event;
		wait_objects[1] = &device_extension->tx_event_to_process;
		for(;;) {
ENTER_CS;
			if(!IsListEmpty(&device_extension->tx_queue)) {
				list_entry = RemoveHeadList(&device_extension->tx_queue);
				irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
				IoSetCancelRoutine(irp, tx_cancel_current_irp_routine);
				device_extension->tx_current_irp = irp;
			} else {
				irp = NULL;
			}
LEAVE_CS;
			if(irp) {
				break;
			}
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
				goto L_EXIT;
			}
		}
		stack_location = IoGetCurrentIrpStackLocation(irp);
		buffer = irp->AssociatedIrp.SystemBuffer;
		length = stack_location->Parameters.Write.Length;
		if(length <= 0) {
ENTER_CS;
			IoSetCancelRoutine(irp, NULL);
			device_extension->tx_current_irp = NULL;
LEAVE_CS;
			complete_request(irp, STATUS_SUCCESS, 0);
			continue; /* IRP */
		}
		total_length = 0;

		/* ^CAEgvZ܂B */
ENTER_CS;
		if(!device_extension->timeouts.WriteTotalTimeoutMultiplier &&
		   !device_extension->timeouts.WriteTotalTimeoutConstant) {
			timeout_msec = -1; /* ^CAEgȂ */
		} else {
			timeout_msec = device_extension->timeouts.WriteTotalTimeoutMultiplier * length
				     + device_extension->timeouts.WriteTotalTimeoutConstant;
			if(timeout_msec <= 0) { /* I[o[t[΍ */
				timeout_msec = INT_MAX;
			}
		}
LEAVE_CS;
		if(timeout_msec >= 0) {
			relative_timeout(&timeout, timeout_msec);
			KeSetTimer(&timeout_timer, timeout, NULL); /* Õ^C}쒆Ȃ΁AÖق̒~ɍĊJ܂ */
		} else {
			KeCancelTimer(&timeout_timer);
		}

		/* oIRP܂B */
		wait_objects[0] = &device_extension->terminate_event;
		wait_objects[1] = &device_extension->tx_event_to_process;
		wait_objects[2] = &timeout_timer;
		for(;;) {
			if(irp->Cancel) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->tx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				break; /* IRP */
			}
			/*--------------------------------------------------------------------------------------------------*/

ENTER_CS;
			/* Mobt@̋󂫃TCYƁANGXgobt@̗LTCŶARs[TCYƂ܂B */
			copy_length = device_extension->tx_capacity - device_extension->tx_length;
			if(copy_length > length) {
				copy_length = length;
			}

			/* NGXgobt@瑗Mobt@փRs[܂B */
			memcpy(&device_extension->tx_buffer[device_extension->tx_length], buffer, copy_length);
			device_extension->tx_length += copy_length;
LEAVE_CS;

			/* ̑Mobt@oĒ~Ă(mȂ)AM|[OXbhN܂B */
			KeSetEvent(&device_extension->tx_event_to_polling, IO_NO_INCREMENT, FALSE);

			/* Rs[ANGXgobt@̃|C^ƃTCY𒲐AvRs[TCY𑝂₵܂B */
			buffer += copy_length;
			length -= copy_length;
			total_length += copy_length;

			/* NGXgobt@Ŝ𑗐MAIRP܂B */
			if(!length) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->tx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_SUCCESS, total_length);
				break; /* IRP */
			}

			/*--------------------------------------------------------------------------------------------------*/
			status = KeWaitForMultipleObjects(3, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->tx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->tx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				goto L_EXIT;
			}
			if(status == 2/*Timeout*/) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->tx_current_irp = NULL;
LEAVE_CS;
				//------------------------------------------------------------------------------------------------
				//if(total_length) {
				//	complete_request(irp, STATUS_SUCCESS, total_length); /* 1oCgȏ㑗Mă^CAEg */
				//} else {
				//	complete_request(irp, STATUS_TIMEOUT, 0);            /* 1oCgMɃ^CAEg */
				//}
				//------------------------------------------------------------------------------------------------
				complete_request(irp, STATUS_SUCCESS, total_length);
				//------------------------------------------------------------------------------------------------

				break; /* IRP */
			}
		}
	}

L_EXIT:

	/* ^CAEg^C}mɒ~܂B */
	KeCancelTimer(&timeout_timer);

	KdPrint(("tx_process_thread_routine exit\n"));
	PsTerminateSystemThread(STATUS_SUCCESS);
}

/****************************************************************************
 *
 ****************************************************************************/

/* IRP̃LZcwMicrosoft WDM vO~Oxp.237`239Q */
static NTSTATUS
urb_completion_routine(DEVICE_OBJECT* device_object, IRP* irp, void* context)
{
	KEVENT* event = context;
	KeSetEvent(event, IO_NO_INCREMENT, FALSE);
	return STATUS_MORE_PROCESSING_REQUIRED;
}

static
void tx_polling_thread_routine(void* context)
{
	DEVICE_OBJECT* device_object = context;
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	unsigned char* buffer/*[MaximumTransferSize]*/ = NULL;
	int comm_event;
	//
	NTSTATUS status;
	int length;
	URB urb;
	//
	void* wait_objects[3];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	KdPrint(("tx_polling_thread_routine start\n"));

	/* ꎞobt@mۂ܂B */
	buffer = ExAllocatePool(NonPagedPool, device_extension->tx_pipe.MaximumTransferSize);
	if(!buffer) {
		KdPrint(("ExAllocatePool failed\n"));
		goto L_EXIT;
	}

	for(;;) {
		/* ɁÃgXt@ŔCxgǉ܂B */
		comm_event = 0;

ENTER_CS;
		ASSERT((device_extension->tx_length >= 0) && (device_extension->tx_length <= device_extension->tx_capacity));

		/* MTCY肵܂B */
		length = device_extension->tx_length;				/* Mobt@̗LTCY */
		if(length > (int)device_extension->tx_pipe.MaximumTransferSize) {
			length = device_extension->tx_pipe.MaximumTransferSize;	/* ő]TCYƂ */
		}
		if(length) {
			/* Mobt@ꎞobt@փRs[܂B */
			memcpy(buffer, device_extension->tx_buffer, length);
			memmove(device_extension->tx_buffer, &device_extension->tx_buffer[length], device_extension->tx_length - length);
			device_extension->tx_length -= length;
		}
LEAVE_CS;

		/* Mf[^... */
		if(length) {
			/* MIRP(URB)쐬܂B */
			UsbBuildInterruptOrBulkTransferRequest(
				&urb,							/* Urb */
				sizeof(struct _URB_BULK_OR_INTERRUPT_TRANSFER),		/* Length */
				device_extension->tx_pipe.PipeHandle,			/* PipeHandle */
				buffer,							/* TransferBuffer */
				NULL,							/* TransferBufferMDL */
				length,							/* TransferBufferLength */
				USBD_SHORT_TRANSFER_OK | USBD_TRANSFER_DIRECTION_OUT,	/* TransferFlags */
				NULL);							/* Link */
			status = exec_transfer(device_object, &urb);
			if(!NT_SUCCESS(status)) {
				KdPrint(("Transfer failed\n"));
				goto L_EXIT;
			}

			/* ۂɑMTCY擾܂B */
			length = urb.UrbBulkOrInterruptTransfer.TransferBufferLength;

			/* MꍇAMTCYő]TCYȉȂ΁ASxőMłĂ͂łB
			 * * VAʐMȂǂ̃f[^؂̖ʐMł́AvȃTCYł̑ML蓾܂B
			 *   AUSB̏ꍇ́AgXt@Pʂł̃f[^̋؂肪ӖĂ̂ŁA
			 *   oXhCoɑMTCY炵āAM𐬌邱Ƃ͗L蓾Ȃ͂łB
			 * * cƎv̂łǁAm؂ĂȂ̂ŁAÔ߃t[rhł`FbN邱Ƃɂ܂(^^;
			 */
			if(length != urb.UrbBulkOrInterruptTransfer.TransferBufferLength) {
				KdPrint(("Write length error\n"));
				goto L_EXIT;
			}

			/* Mobt@̋󂫂҂Ē~Ă(mȂ)AMXbhN܂B */
			KeSetEvent(&device_extension->tx_event_to_process, IO_NO_INCREMENT, FALSE);

			/* ̃gXt@ŔCxgo܂B */
			if(!device_extension->tx_length) {
				comm_event |= SERIAL_EV_TXEMPTY;			/* Mobt@ɂȂ */
			}

		/* Mf[^... */
		} else {

			/* IʒmCxgA܂́AMobt@̕ω҂܂B */
			wait_objects[0] = &device_extension->terminate_event;
			wait_objects[1] = &device_extension->tx_event_to_polling;
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
				goto L_EXIT;
			}
		}

		/* ̃gXt@ŔCxgɉāAWaitOnMask IRP܂B */
		assert_comm_event(device_object, comm_event);
	}

L_EXIT:

	/* ꎞobt@J܂B */
	if(buffer) {
		ExFreePool(buffer);
	}

	KdPrint(("tx_polling_thread_routine exit\n"));
	PsTerminateSystemThread(STATUS_SUCCESS);
}
