/*	
 *	rx.c
 *
 *	PceCom - P/ECE USBVA|[gfoCXhCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Aug 03 21:57:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *
 ****************************************************************************/

static void rx_process_thread_routine(void* context);
static void rx_polling_thread_routine(void* context);

/****************************************************************************
 *
 ****************************************************************************/

/* L[̒ɂIRPɑ΂āÃLZ[`ݒ肵܂B
 */
static void
rx_cancel_from_queue_routine(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	/* IRPL[菜܂B */
	IoSetCancelRoutine(irp, NULL);
	RemoveEntryList(&irp->Tail.Overlay.ListEntry);

	/* IoCancelIrp()lXsbN܂B */
	IoReleaseCancelSpinLock(irp->CancelIrql);

	/* IRP܂B */
	complete_request(irp, STATUS_CANCELLED, 0);
}

/* ݂IRPɑ΂āÃLZ[`ݒ肵܂B
 */
static void
rx_cancel_current_irp_routine(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	ASSERT(device_extension->rx_current_irp == irp);

	/* IoCancelIrp()lXsbN܂B */
	IoReleaseCancelSpinLock(irp->CancelIrql);

	/* MXbhirp->Cancel𔻒fāAIRP܂B */
	KeSetEvent(&device_extension->rx_event_to_process, IO_NO_INCREMENT, FALSE);
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
rx_init(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	NTSTATUS status;

	KdPrint(("rx_init\n"));

	/* Cxg܂B */
	KeInitializeEvent(&device_extension->rx_event_to_process, SynchronizationEvent, FALSE);
	KeInitializeEvent(&device_extension->rx_event_to_polling, SynchronizationEvent, FALSE);

	/* Mobt@mۂ܂B */
	status = rx_resize(device_object, device_extension->rx_pipe.MaximumTransferSize);
	if(!NT_SUCCESS(status)) {
		KdPrint(("ExAllocatePool failed\n"));
		goto L_EXIT;
	}

	/* IRPL[܂B */
	InitializeListHead(&device_extension->rx_queue);
	ASSERT(device_extension->rx_queue.Flink);

	/* MXbhJn܂B */
	device_extension->rx_process_thread = create_thread(rx_process_thread_routine, device_object);
	if(!device_extension->rx_process_thread) {
		KdPrint(("create_thread failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}

	/* M|[OXbhJn܂B */
	device_extension->rx_polling_thread = create_thread(rx_polling_thread_routine, device_object);
	if(!device_extension->rx_polling_thread) {
		KdPrint(("create_thread failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}

L_EXIT:

	if(!NT_SUCCESS(status)) {
		rx_exit(device_object);
	}

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

void
rx_exit(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	KdPrint(("rx_exit\n"));

	///* cĂIRPׂĊ܂B */
	//if(device_extension->rx_queue.Flink) {
	//	rx_abort(device_object);
	//}
	//svH

	/* M|[OXbhI܂B */
	if(device_extension->rx_polling_thread) {
		delete_thread(device_extension->rx_polling_thread);
		device_extension->rx_polling_thread = NULL;
	}

	/* MXbhI܂B */
	if(device_extension->rx_process_thread) {
		delete_thread(device_extension->rx_process_thread);
		device_extension->rx_process_thread = NULL;
	}

	/* Mobt@J܂B */
	if(device_extension->rx_buffer) {
		ExFreePool(device_extension->rx_buffer);
		device_extension->rx_buffer = NULL;
	}
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_rx(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

#ifndef QUIET
	KdPrint(("dispatch_rx\n"));
#endif /*QUIET*/

	/* IRPL[֒ǉuԂɏLȂ̂ŁAɃ}[NĂ܂B(K{!!) */
	IoMarkIrpPending(irp);

ENTER_CS;
	/* IRPL[֒ǉ܂B */
	IoSetCancelRoutine(irp, rx_cancel_from_queue_routine);
	InsertTailList(&device_extension->rx_queue, &irp->Tail.Overlay.ListEntry);
LEAVE_CS;

	/* IRPL[oĒ~Ă(mȂ)AMXbhN܂B */
	KeSetEvent(&device_extension->rx_event_to_process, IO_NO_INCREMENT, FALSE);

	return STATUS_PENDING;
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
rx_resize(DEVICE_OBJECT* device_object, int capacity)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	NTSTATUS status = STATUS_SUCCESS;
	//
	void* new_buffer;

	KdPrint(("rx_resize\n"));

ENTER_CS;

	/* w肳ꂽobt@TCỸ݂obt@TCY傫΁Aobt@g܂B
	 * ݂̃obt@TCY΁A܂BSerial IOCTL̎dlłB
	 */
	if(capacity > device_extension->rx_capacity) {
		new_buffer = ExAllocatePool(NonPagedPool, capacity); /* DISPATCH_LEVELłANonPagedPool̊mۂ͉\ */
		if(new_buffer) {
			if(device_extension->rx_buffer) {
				memcpy(new_buffer, device_extension->rx_buffer, device_extension->rx_length);
				ExFreePool(device_extension->rx_buffer);
			}
			device_extension->rx_buffer = new_buffer;
			device_extension->rx_capacity = capacity;
		} else {
			KdPrint(("ExAllocatePool failed\n"));
			status = STATUS_UNSUCCESSFUL;
		}
	}

LEAVE_CS;

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

void
rx_abort(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	LIST_ENTRY irp_list;
	LIST_ENTRY* list_entry;
	IRP* irp;

	KdPrint(("rx_abort\n"));

	InitializeListHead(&irp_list);

ENTER_CS;

	/* IRPL[̒IRPSĎo܂B */
	while(!IsListEmpty(&device_extension->rx_queue)) {
		list_entry = RemoveHeadList(&device_extension->rx_queue);
		irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
		IoSetCancelRoutine(irp, NULL);
		InsertTailList(&irp_list, list_entry);
	}

	/* ݂IRP΁ALZv܂B */
	if(device_extension->rx_current_irp) {
		device_extension->rx_current_irp->Cancel = TRUE;
		KeSetEvent(&device_extension->rx_event_to_process, IO_NO_INCREMENT, FALSE);
	}

LEAVE_CS;

	/* IRPL[oIRPׂĊ܂B */
	while(!IsListEmpty(&irp_list)) {
		list_entry = RemoveHeadList(&irp_list);
		irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
		complete_request(irp, STATUS_CANCELLED, 0);
	}
}

/****************************************************************************
 *
 ****************************************************************************/

static
void rx_process_thread_routine(void* context)
{
	DEVICE_OBJECT* device_object = context;
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	KTIMER timeout_timer; /* v~ */
	//
	NTSTATUS status;
	LIST_ENTRY* list_entry;
	IRP* irp;
	IO_STACK_LOCATION* stack_location;
	unsigned char* buffer;
	int length;
	int copy_length;
	int total_length;
	int timeout_msec;
	LARGE_INTEGER timeout;
	//
	void* wait_objects[3];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	KdPrint(("rx_process_thread_routine start\n"));

	/* ^CAEg^C}܂B */
	KeInitializeTimer(&timeout_timer);

	for(;;) {
		/* L[玟IRPo܂B */
		wait_objects[0] = &device_extension->terminate_event;
		wait_objects[1] = &device_extension->rx_event_to_process;
		for(;;) {
ENTER_CS;
			if(!IsListEmpty(&device_extension->rx_queue)) {
				list_entry = RemoveHeadList(&device_extension->rx_queue);
				irp = CONTAINING_RECORD(list_entry, IRP, Tail.Overlay.ListEntry);
				IoSetCancelRoutine(irp, rx_cancel_current_irp_routine);
				device_extension->rx_current_irp = irp;
			} else {
				irp = NULL;
			}
LEAVE_CS;
			if(irp) {
				break;
			}
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
				goto L_EXIT;
			}
		}
		stack_location = IoGetCurrentIrpStackLocation(irp);
		buffer = irp->AssociatedIrp.SystemBuffer;
		length = stack_location->Parameters.Read.Length;
		if(length <= 0) {
ENTER_CS;
			IoSetCancelRoutine(irp, NULL);
			device_extension->rx_current_irp = NULL;
LEAVE_CS;
			complete_request(irp, STATUS_SUCCESS, 0);
			continue; /* IRP */
		}
		total_length = 0;

		/* ^CAEgvZ܂B(TODO: ReadIntervalTimeoutlĂȂ) */
ENTER_CS;
		if(!device_extension->timeouts.ReadTotalTimeoutMultiplier &&
		   !device_extension->timeouts.ReadTotalTimeoutConstant) {
			if(device_extension->timeouts.ReadIntervalTimeout == -1) {
				timeout_msec =  0; /* ubNȂ */
			} else {
				timeout_msec = -1; /* ^CAEgȂ */
			}
		} else {
			timeout_msec = device_extension->timeouts.ReadTotalTimeoutMultiplier * length
				     + device_extension->timeouts.ReadTotalTimeoutConstant;
			if(timeout_msec <= 0) { /* I[o[t[΍ */
				timeout_msec = INT_MAX;
			}
		}
LEAVE_CS;
		if(timeout_msec >= 0) {
			relative_timeout(&timeout, timeout_msec);
			KeSetTimer(&timeout_timer, timeout, NULL); /* Õ^C}쒆Ȃ΁AÖق̒~ɍĊJ܂ */
		} else {
			KeCancelTimer(&timeout_timer);
		}

		/* oIRP܂B */
		wait_objects[0] = &device_extension->terminate_event;
		wait_objects[1] = &device_extension->rx_event_to_process;
		wait_objects[2] = &timeout_timer;
		for(;;) {
			if(irp->Cancel) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				break; /* IRP */
			}
			/*--------------------------------------------------------------------------------------------------*/

ENTER_CS;
			/* Mobt@̗LTCYƁANGXgobt@̋󂫃TCŶARs[TCYƂ܂B */
			copy_length = device_extension->rx_length;
			if(copy_length > length) {
				copy_length = length;
			}

			/* Mobt@烊NGXgobt@փRs[܂B */
			memcpy(buffer, device_extension->rx_buffer, copy_length);
			memmove(device_extension->rx_buffer, &device_extension->rx_buffer[copy_length], device_extension->rx_length - copy_length);
			device_extension->rx_length -= copy_length;
LEAVE_CS;

			/* Mobt@̋󂫂҂Ē~Ă(mȂ)AM|[OXbhN܂B */
			KeSetEvent(&device_extension->rx_event_to_polling, IO_NO_INCREMENT, FALSE);

			/* Rs[ANGXgobt@̃|C^ƃTCY𒲐AvRs[TCY𑝂₵܂B */
			buffer += copy_length;
			length -= copy_length;
			total_length += copy_length;

#if 0
			/* NGXgobt@ŜɎMAIRP܂B */
			if(!length) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_SUCCESS, total_length);
				break; /* IRP */
			}
#else
			/* 1oCgłMAIRP𑦊܂B(TODO: ReadIntervalTimeoutlĂȂ) */
			if(total_length) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_SUCCESS, total_length);
				break; /* IRP */
			}
#endif

			/*--------------------------------------------------------------------------------------------------*/
			status = KeWaitForMultipleObjects(3, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				complete_request(irp, STATUS_CANCELLED, 0);
				goto L_EXIT;
			}
			if(status == 2/*Timeout*/) {
ENTER_CS;
				IoSetCancelRoutine(irp, NULL);
				device_extension->rx_current_irp = NULL;
LEAVE_CS;
				//------------------------------------------------------------------------------------------------
				//if(total_length) {
				//	complete_request(irp, STATUS_SUCCESS, total_length); /* 1oCgȏMă^CAEg */
				//} else {
				//	complete_request(irp, STATUS_TIMEOUT, 0);            /* 1oCgMɃ^CAEg */
				//}
				//------------------------------------------------------------------------------------------------
				//Read/Write^CAEg̖߂ĺASTATUS_TIMEOUTł͂ȂASTATUS_SUCCESS݂łB
				//STATUS_TIMEOUTԂƁAWindows XPSLIPڑrŎ~܂āAOSIłȂȂ܂B
				//STATUS_TIMEOUT͂܂ŁAKeWaitSingleObject/MultipleObjects̖߂lƂĎglłāA
				//hCoI/O}l[Wɑ΂ĕԂprɂ͎gȂlȂ̂܂B
				//------------------------------------------------------------------------------------------------
				complete_request(irp, STATUS_SUCCESS, total_length);
				//------------------------------------------------------------------------------------------------

				break; /* IRP */
			}
		}
	}

L_EXIT:

	/* ^CAEg^C}mɒ~܂B */
	KeCancelTimer(&timeout_timer);

	KdPrint(("rx_process_thread_routine exit\n"));
	PsTerminateSystemThread(STATUS_SUCCESS);
}

/****************************************************************************
 *
 ****************************************************************************/

static
void rx_polling_thread_routine(void* context)
{
	DEVICE_OBJECT* device_object = context;
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	unsigned char* buffer/*[MaximumTransferSize]*/ = NULL;
	int comm_event;
	//
	NTSTATUS status;
	int length;
	URB urb;
	//
	void* wait_objects[3];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	KdPrint(("rx_polling_thread_routine start\n"));

	/* ꎞobt@mۂ܂B */
	buffer = ExAllocatePool(NonPagedPool, device_extension->rx_pipe.MaximumTransferSize);
	if(!buffer) {
		KdPrint(("ExAllocatePool failed\n"));
		goto L_EXIT;
	}

	for(;;) {
		/* ɁÃgXt@ŔCxgǉ܂B */
		comm_event = 0;

ENTER_CS;
		ASSERT((device_extension->rx_length >= 0) && (device_extension->rx_length <= device_extension->rx_capacity));

		/* Mobt@̋󂫂𒲂ׂāAMTCY肵܂B
		 * * Mobt@TCY̓pPbgTCY̔{łȂ΂ȂƂɒӂĂ!!
		 *   ̃gXt@͕̃gUNVō\܂AX̃gUNVɒڂƂɁA
		 *   zXg̎Mobt@TCYfoCX̑Mf[^TCYĂĂ͂܂B
		 *   zXg̎Mobt@TCYsƁAUSBDւ̎MvsAȂ肷݂łB
		 */
		length = device_extension->rx_capacity - device_extension->rx_length;	/* Mobt@̋󂫃TCY */
		if(length > (int)device_extension->rx_pipe.MaximumTransferSize) {
			length = device_extension->rx_pipe.MaximumTransferSize;		/* ő]TCYƂ */
		}
		length &= ~(device_extension->rx_pipe.MaximumPacketSize - 1);		/* pPbgTCY̔{Ƃ */
LEAVE_CS;

		/* Mobt@ɋ󂫂... */
		if(length) {
			/*{{̊ԂɁAMobt@ǂݏoČ邱Ƃ͂ĂA邱Ƃ͖͂łB*/

			/* ]s܂B */
			UsbBuildInterruptOrBulkTransferRequest(
				&urb,							/* Urb */
				sizeof(struct _URB_BULK_OR_INTERRUPT_TRANSFER),		/* Length */
				device_extension->rx_pipe.PipeHandle,			/* PipeHandle */
				buffer,							/* TransferBuffer */
				NULL,							/* TransferBufferMDL */
				length,							/* TransferBufferLength */
				USBD_SHORT_TRANSFER_OK | USBD_TRANSFER_DIRECTION_IN,	/* TransferFlags */
				NULL);							/* Link */
			status = exec_transfer(device_object, &urb);
			if(!NT_SUCCESS(status)) {
				KdPrint(("Transfer failed\n"));
				goto L_EXIT;
			}

			/*}}̊ԂɁAMobt@ǂݏoČ邱Ƃ͂ĂA邱Ƃ͖͂łB*/

			/* ۂɎMTCY擾܂B */
			length = urb.UrbBulkOrInterruptTransfer.TransferBufferLength;

			/* Mf[^... */
			if(length) {
ENTER_CS;
				/* ꎞobt@Mobt@փRs[܂B */
				ASSERT(device_extension->rx_length + length <= device_extension->rx_capacity);
				memcpy(&device_extension->rx_buffer[device_extension->rx_length], buffer, length);
				device_extension->rx_length += length;
LEAVE_CS;
				/* ̎Mobt@oĒ~Ă(mȂ)AMXbhN܂B */
				KeSetEvent(&device_extension->rx_event_to_process, IO_NO_INCREMENT, FALSE);

				/* ̃gXt@ŔCxgo܂B */
				comm_event |= SERIAL_EV_RXCHAR;				/* Cӂ̃LN^M */
				if(memchr(buffer, device_extension->chars.EventChar, length)) {
					comm_event |= SERIAL_EV_RXFLAG;			/* CxgLN^M */
				}
			}

		/* Mobt@ɋ󂫂... */
		} else {

			/* IʒmCxgA܂́AMobt@̕ω҂܂B */
			wait_objects[0] = &device_extension->terminate_event;
			wait_objects[1] = &device_extension->rx_event_to_polling;
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				goto L_EXIT;
			}
			if(status == 0/*Terminate*/) {
				goto L_EXIT;
			}
		}

		/* ̃gXt@ŔCxgɉāAWaitOnMask IRP܂B */
		assert_comm_event(device_object, comm_event);
	}

L_EXIT:

	/* ꎞobt@J܂B */
	if(buffer) {
		ExFreePool(buffer);
	}

	KdPrint(("rx_polling_thread_routine exit\n"));
	PsTerminateSystemThread(STATUS_SUCCESS);
}
