/*	
 *	clipz8c.c
 *
 *	P/ECE Z80 Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 10 19:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

//Z80CPU z80cpu; -> framz8ca.s
unsigned char z80mem[0x10000];

/****************************************************************************
 *	֐
 ****************************************************************************/

void
z80cpu_error()
{
	Z80CPU* cpu = &z80cpu;

	die("z80cpu_error(%04x)", cpu->pc);
}

void
z80cpu_check_pending()
{
	Z80CPU* cpu = &z80cpu;

	/* 荞݋֎~ȂΉ܂B */
	if(!cpu->iff1) {
		return;
	}

	/* 荞ݗvۗĂȂΉ܂B */
	if(!cpu->pending) {
		return;
	}

	/* 荞ݗvۗ̕NA܂B */
	cpu->pending = 0;

	/* }XN\荞݂֎~܂B */
	cpu->iff1 = 0;
	cpu->iff2 = 0; /* dl */

	/* 荞ݔɂAHALT܂B */
	cpu->halt = 0;

	/* 荞݂s܂B */
	z80mem[--cpu->sp] = HIBYTE(cpu->pc);
	z80mem[--cpu->sp] = LOBYTE(cpu->pc);
	switch(cpu->im) {
	case 0: /* IM 0 */
		switch(cpu->pending_no) {
		case 0xc7: cpu->pc = 0x00; break; /* RST 00H */
		case 0xcf: cpu->pc = 0x08; break; /* RST 08H */
		case 0xd7: cpu->pc = 0x10; break; /* RST 10H */
		case 0xdf: cpu->pc = 0x18; break; /* RST 18H */
		case 0xe7: cpu->pc = 0x20; break; /* RST 20H */
		case 0xef: cpu->pc = 0x28; break; /* RST 28H */
		case 0xf7: cpu->pc = 0x30; break; /* RST 30H */
		case 0xff: cpu->pc = 0x38; break; /* RST 38H */
		default:   DIE();
		}
		break;
	case 1: /* IM 1 */
		cpu->pc = 0x38;
		break;
	//case 2: /* IM 2 */
	//	TODO: Ή
	default:
		DIE();
	}
}

/* KINnhłB
 * z80cpu_reset()ɂāAINnhw肳Ȃ(NULL)ꍇɗp܂B
 * I/OڑAvAbvƉ肵āAɑSrbg1Ԃ܂B
 */
static int
z80cpu_internal_in(int addr)
{
	return -1;
}

/* KOUTnhłB
 * z80cpu_reset()ɂāAOUTnhw肳Ȃ(NULL)ꍇɗp܂B
 * ܂B
 */
static void
z80cpu_internal_out(int addr, int data)
{
	/** no job **/
}

/****************************************************************************
 *	TODO: ܂AZuĂȂ (AZu)
 ****************************************************************************/

extern const unsigned char z80cpu_parity[/*256*/]; /* -> clipz8ca.s */
#define PARITY(n)	(z80cpu_parity[(n)])
#define A		(((unsigned char*)&z80cpu.af)[1])
#define F		(((unsigned char*)&z80cpu.af)[0])
#define HL		(z80cpu.hl)
#define READ(a)		(z80mem[(a)])
#define WRITE(a, n)	do { z80mem[(a)] = (n); } while(0)
/* ȉ̃R[h́Aт̂clipz80i.c藬p܂B */

/*	ZiLOG Z80 Family CPU User Manual (um0080.pdf) 167y[WADAA߂̏e[u
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|                |        |Hex Value In|        |Hex Value In|Number  |       |    
 *	|                |C Before|Upper Digit |H Before|Lower Digit |Added to|C After|    
 *	|Operation       |DAA     |(bit 7-4)   |DAA     |(bit 3-0)   |Byte    |DAA    |    
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|ADD/ADC/INC     |0       |0-9         |0       |0-9         |00      |0      |( 1)
 *	|ADD/ADC/INC     |0       |0-8         |0       |A-F         |06      |0      |( 2)
 *	|ADD/ADC/INC     |0       |0-9         |1       |0-3         |06      |0      |( 3)
 *	|ADD/ADC/INC     |0       |A-F         |0       |0-9         |60      |1      |( 4)
 *	|ADD/ADC/INC     |0       |9-F         |0       |A-F         |66      |1      |( 5)
 *	|ADD/ADC/INC     |0       |A-F         |1       |0-3         |66      |1      |( 6)
 *	|ADD/ADC/INC     |1       |0-2         |0       |0-9         |60      |1      |( 7)
 *	|ADD/ADC/INC     |1       |0-2         |0       |A-F         |66      |1      |( 8)
 *	|ADD/ADC/INC     |1       |0-3         |1       |0-3         |66      |1      |( 9)
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|SUB/SBC/DEC/NEG |0       |0-9         |0       |0-9         |00      |0      |(10)
 *	|SUB/SBC/DEC/NEG |0       |0-8         |1       |6-F         |FA      |0      |(11)
 *	|SUB/SBC/DEC/NEG |1       |7-F         |0       |0-9         |A0      |1      |(12)
 *	|SUB/SBC/DEC/NEG |1       |6-7         |1       |6-F         |9A      |1      |(13)
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *
 *	TODO:	DAAF(H)ݒsłB݂̎ł͏F(H)=0ƂĂ܂B
 *		F(H)DAÂ߂ɎĝŁADAAF(H)gʂ͂ȂƎv܂A
 *		A_vZɖ肪悤ł΁A܂^ĂB
 */
//Z80FN_("DAA"           ,DAA             ) {
void z80cpu_daa() {
	unsigned char hi = A >> 4;
	unsigned char lo = A & 0xf;
	//
	unsigned char n;
	unsigned char c;
	//
	//if(!F & 2) { /* ADD/ADC/INC */
	//2005/01/04 Naoyuki Sawa C
	if(!(F & 2)) { /* ADD/ADC/INC */
		if(!(F & 1)) {
			if(!(F & 0x10)) {
				if(lo <= 9) {
					if(hi <= 9) {
						n = 0x00, c = 0;	/*( 1)*/
					} else {
						n = 0x60, c = 1;	/*( 4)*/
					}
				} else {
					if(hi <= 8) {
						n = 0x06, c = 0;	/*( 2)*/
					} else {
						n = 0x66, c = 1;	/*( 5)*/
					}
				}
			} else {
				if(hi <= 9) {
					n = 0x06, c = 0;		/*( 3)*/
				} else {
					n = 0x66, c = 1;		/*( 6)*/
				}
			}
		} else {
			if(!(F & 0x10)) {
				if(lo <= 9) {
					n = 0x60, c = 1;		/*( 7)*/
				} else {
					n = 0x66, c = 1;		/*( 8)*/
				}
			} else {
				n = 0x66, c = 1;			/*( 9)*/
			}
		}
	} else { /* SUB/SBC/DEC/NEG */
		if(!(F & 1)) {
			if(!(F & 0x10)) {
				n = 0x00, c = 0;			/*(10)*/
			} else {
				n = 0xfa, c = 0;			/*(11)*/
			}
		} else {
			if(!(F & 0x10)) {
				n = 0xa0, c = 1;			/*(12)*/
			} else {
				n = 0x9a, c = 1;			/*(13)*/
			}
		}
	}
	//
	A += n;
	F = (A & 0xa8) |	/* F(S,Y,X) */
	    (!A << 6) |		/* F(Z) */
	    PARITY(A) |		/* F(P) */
	    (F & 2) |		/* F(N) */
	    c;			/* F(C) */
}

//Z80FN_("RLD"           ,RLD             ) {
void z80cpu_rld() {
	unsigned char tmp = READ(HL);
	WRITE(HL, (A & 0xf) | (tmp << 4));
	A = (A & 0xf0) | (tmp >> 4);
	F = (A & 0xa8) | (!A << 6) | PARITY(A) | (F & 1);
}

//Z80FN_("RRD"           ,RRD             ) {
void z80cpu_rrd() {
	unsigned char tmp = READ(HL);
	WRITE(HL, (A << 4) | (tmp >> 4));
	A = (A & 0xf0) | (tmp & 0xf);
	F = (A & 0xa8) | (!A << 6) | PARITY(A) | (F & 1);
}

#undef PARITY
#undef A
#undef F
#undef HL
#undef READ
#undef WRITE

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
z80cpu_reset(Z80CPUIN* in, Z80CPUOUT* out)
{
	Z80CPU* cpu = &z80cpu;

	/* ܂ANA܂B */
	memset(cpu, 0, sizeof(Z80CPU));

	/* INAOUTnhi[܂B */
	cpu->in = in ? in : z80cpu_internal_in;
	cpu->out = out ? out : z80cpu_internal_out;
}

void
z80cpu_int(int no)
{
	Z80CPU* cpu = &z80cpu;

	/* 񊄂荞ݗvۗĂ܂B */
	cpu->pending = 1;
	cpu->pending_no = no;

	/* 荞݋Ȃ΁AɎ󂯕t܂B */
	z80cpu_check_pending();
}

void
z80cpu_nmi()
{
	Z80CPU* cpu = &z80cpu;

	/* }XN\荞݂̋Ԃޔ܂B */
	cpu->iff2 = cpu->iff1;

	/* }XN\荞݂֎~܂B */
	cpu->iff1 = 0;

	/* 荞ݔɂAHALT܂B */
	cpu->halt = 0;

	/* 荞݂s܂B */
	z80mem[--cpu->sp] = HIBYTE(cpu->pc);
	z80mem[--cpu->sp] = LOBYTE(cpu->pc);
	cpu->pc = 0x66;
}

