/*	
 *	clipz80i.c
 *
 *	P/ECE Z80 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 26 12:30:00 JST 2003 Naoyuki Sawa
 *	- ߂̈ꕔɑΉ܂B
 *	  pɂɎĝ́A悻Jo[łĂƎv܂B
 *	* Thu Nov 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- DAA/RLD/RRD߂܂B
 *	* Sat Dec 06 07:00:00 JST 2003 Naoyuki Sawa
 *	- DAA߂C܂B
 *	  ܂łaylet̎𗘗pĒĂ܂A
 *	  Xy[XCx[_[p[gII̓_vZɖ肪߁A
 *	  ZiLOG Z80 Family CPU User Manual (um0080.pdf) ɏ]Ď܂B
 *	* Tue Jan 04 20:52:00 JST 2005 Naoyuki Sawa
 *	- DAA߂C܂B
 *	  NtÕ["!(F&2)"ƂׂƂ낪"!F&2"ɂȂĂ܂B
 *	  ̃Q[ŃXRAvZԈĂ̂܂B
 *	* Fri Jan 07 20:52:00 JST 2005 Naoyuki Sawa
 *	- "LD A,R"ɂARbit6-0CNg悤ɂ܂B
 *	  Rω邱ƂɈˑvÔ߂́AȈՂȑΏłB
 *	  (: SG-1000Ń`bvt^[B~낵lgقɓ^C~O)
 *	* Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
 *	- "JP cc"͏/sɂ炸ǉTCNłB
 *	  ܂ŊԈ+7TCNĂ܂Ă̂C܂B
 */
#include "clip.h"
#include "clipz80i.h"	/*Z80G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/* ߂܂B
 */
Z80FN_("ERROR", ERROR)
{
	DIE();
}

/****************************************************************************
 *	8-Bit Load Group
 ****************************************************************************/

Z80FN_("LD A,n"        ,LD_A_n          ) { A = arg1; }
Z80FN_("LD A,A"        ,LD_A_A          ) { A = A; }
Z80FN_("LD A,B"        ,LD_A_B          ) { A = B; }
Z80FN_("LD A,C"        ,LD_A_C          ) { A = C; }
Z80FN_("LD A,D"        ,LD_A_D          ) { A = D; }
Z80FN_("LD A,E"        ,LD_A_E          ) { A = E; }
Z80FN_("LD A,H"        ,LD_A_H          ) { A = H; }
Z80FN_("LD A,L"        ,LD_A_L          ) { A = L; }
Z80FN_("LD A,IXH"      ,LD_A_IXH        ) { A = IXH; }
Z80FN_("LD A,IXL"      ,LD_A_IXL        ) { A = IXL; }
Z80FN_("LD A,IYH"      ,LD_A_IYH        ) { A = IYH; }
Z80FN_("LD A,IYL"      ,LD_A_IYL        ) { A = IYL; }
Z80FN_("LD B,n"        ,LD_B_n          ) { B = arg1; }
Z80FN_("LD B,A"        ,LD_B_A          ) { B = A; }
Z80FN_("LD B,B"        ,LD_B_B          ) { B = B; }
Z80FN_("LD B,C"        ,LD_B_C          ) { B = C; }
Z80FN_("LD B,D"        ,LD_B_D          ) { B = D; }
Z80FN_("LD B,E"        ,LD_B_E          ) { B = E; }
Z80FN_("LD B,H"        ,LD_B_H          ) { B = H; }
Z80FN_("LD B,L"        ,LD_B_L          ) { B = L; }
Z80FN_("LD B,IXH"      ,LD_B_IXH        ) { B = IXH; }
Z80FN_("LD B,IXL"      ,LD_B_IXL        ) { B = IXL; }
Z80FN_("LD B,IYH"      ,LD_B_IYH        ) { B = IYH; }
Z80FN_("LD B,IYL"      ,LD_B_IYL        ) { B = IYL; }
Z80FN_("LD C,n"        ,LD_C_n          ) { C = arg1; }
Z80FN_("LD C,A"        ,LD_C_A          ) { C = A; }
Z80FN_("LD C,B"        ,LD_C_B          ) { C = B; }
Z80FN_("LD C,C"        ,LD_C_C          ) { C = C; }
Z80FN_("LD C,D"        ,LD_C_D          ) { C = D; }
Z80FN_("LD C,E"        ,LD_C_E          ) { C = E; }
Z80FN_("LD C,H"        ,LD_C_H          ) { C = H; }
Z80FN_("LD C,L"        ,LD_C_L          ) { C = L; }
Z80FN_("LD C,IXH"      ,LD_C_IXH        ) { C = IXH; }
Z80FN_("LD C,IXL"      ,LD_C_IXL        ) { C = IXL; }
Z80FN_("LD C,IYH"      ,LD_C_IYH        ) { C = IYH; }
Z80FN_("LD C,IYL"      ,LD_C_IYL        ) { C = IYL; }
Z80FN_("LD D,n"        ,LD_D_n          ) { D = arg1; }
Z80FN_("LD D,A"        ,LD_D_A          ) { D = A; }
Z80FN_("LD D,B"        ,LD_D_B          ) { D = B; }
Z80FN_("LD D,C"        ,LD_D_C          ) { D = C; }
Z80FN_("LD D,D"        ,LD_D_D          ) { D = D; }
Z80FN_("LD D,E"        ,LD_D_E          ) { D = E; }
Z80FN_("LD D,H"        ,LD_D_H          ) { D = H; }
Z80FN_("LD D,L"        ,LD_D_L          ) { D = L; }
Z80FN_("LD D,IXH"      ,LD_D_IXH        ) { D = IXH; }
Z80FN_("LD D,IXL"      ,LD_D_IXL        ) { D = IXL; }
Z80FN_("LD D,IYH"      ,LD_D_IYH        ) { D = IYH; }
Z80FN_("LD D,IYL"      ,LD_D_IYL        ) { D = IYL; }
Z80FN_("LD E,n"        ,LD_E_n          ) { E = arg1; }
Z80FN_("LD E,A"        ,LD_E_A          ) { E = A; }
Z80FN_("LD E,B"        ,LD_E_B          ) { E = B; }
Z80FN_("LD E,C"        ,LD_E_C          ) { E = C; }
Z80FN_("LD E,D"        ,LD_E_D          ) { E = D; }
Z80FN_("LD E,E"        ,LD_E_E          ) { E = E; }
Z80FN_("LD E,H"        ,LD_E_H          ) { E = H; }
Z80FN_("LD E,L"        ,LD_E_L          ) { E = L; }
Z80FN_("LD E,IXH"      ,LD_E_IXH        ) { E = IXH; }
Z80FN_("LD E,IXL"      ,LD_E_IXL        ) { E = IXL; }
Z80FN_("LD E,IYH"      ,LD_E_IYH        ) { E = IYH; }
Z80FN_("LD E,IYL"      ,LD_E_IYL        ) { E = IYL; }
Z80FN_("LD H,n"        ,LD_H_n          ) { H = arg1; }
Z80FN_("LD H,A"        ,LD_H_A          ) { H = A; }
Z80FN_("LD H,B"        ,LD_H_B          ) { H = B; }
Z80FN_("LD H,C"        ,LD_H_C          ) { H = C; }
Z80FN_("LD H,D"        ,LD_H_D          ) { H = D; }
Z80FN_("LD H,E"        ,LD_H_E          ) { H = E; }
Z80FN_("LD H,H"        ,LD_H_H          ) { H = H; }
Z80FN_("LD H,L"        ,LD_H_L          ) { H = L; }
Z80FN_("LD L,n"        ,LD_L_n          ) { L = arg1; }
Z80FN_("LD L,A"        ,LD_L_A          ) { L = A; }
Z80FN_("LD L,B"        ,LD_L_B          ) { L = B; }
Z80FN_("LD L,C"        ,LD_L_C          ) { L = C; }
Z80FN_("LD L,D"        ,LD_L_D          ) { L = D; }
Z80FN_("LD L,E"        ,LD_L_E          ) { L = E; }
Z80FN_("LD L,H"        ,LD_L_H          ) { L = H; }
Z80FN_("LD L,L"        ,LD_L_L          ) { L = L; }
Z80FN_("LD IXH,n"      ,LD_IXH_n        ) { IXH = arg1; }
Z80FN_("LD IXH,A"      ,LD_IXH_A        ) { IXH = A; }
Z80FN_("LD IXH,B"      ,LD_IXH_B        ) { IXH = B; }
Z80FN_("LD IXH,C"      ,LD_IXH_C        ) { IXH = C; }
Z80FN_("LD IXH,D"      ,LD_IXH_D        ) { IXH = D; }
Z80FN_("LD IXH,E"      ,LD_IXH_E        ) { IXH = E; }
Z80FN_("LD IXH,IXH"    ,LD_IXH_IXH      ) { IXH = IXH; }
Z80FN_("LD IXH,IXL"    ,LD_IXH_IXL      ) { IXH = IXL; }
Z80FN_("LD IXL,n"      ,LD_IXL_n        ) { IXL = arg1; }
Z80FN_("LD IXL,A"      ,LD_IXL_A        ) { IXL = A; }
Z80FN_("LD IXL,B"      ,LD_IXL_B        ) { IXL = B; }
Z80FN_("LD IXL,C"      ,LD_IXL_C        ) { IXL = C; }
Z80FN_("LD IXL,D"      ,LD_IXL_D        ) { IXL = D; }
Z80FN_("LD IXL,E"      ,LD_IXL_E        ) { IXL = E; }
Z80FN_("LD IXL,IXH"    ,LD_IXL_IXH      ) { IXL = IXH; }
Z80FN_("LD IXL,IXL"    ,LD_IXL_IXL      ) { IXL = IXL; }
Z80FN_("LD IYH,n"      ,LD_IYH_n        ) { IYH = arg1; }
Z80FN_("LD IYH,A"      ,LD_IYH_A        ) { IYH = A; }
Z80FN_("LD IYH,B"      ,LD_IYH_B        ) { IYH = B; }
Z80FN_("LD IYH,C"      ,LD_IYH_C        ) { IYH = C; }
Z80FN_("LD IYH,D"      ,LD_IYH_D        ) { IYH = D; }
Z80FN_("LD IYH,E"      ,LD_IYH_E        ) { IYH = E; }
Z80FN_("LD IYH,IYH"    ,LD_IYH_IYH      ) { IYH = IYH; }
Z80FN_("LD IYH,IYL"    ,LD_IYH_IYL      ) { IYH = IYL; }
Z80FN_("LD IYL,n"      ,LD_IYL_n        ) { IYL = arg1; }
Z80FN_("LD IYL,A"      ,LD_IYL_A        ) { IYL = A; }
Z80FN_("LD IYL,B"      ,LD_IYL_B        ) { IYL = B; }
Z80FN_("LD IYL,C"      ,LD_IYL_C        ) { IYL = C; }
Z80FN_("LD IYL,D"      ,LD_IYL_D        ) { IYL = D; }
Z80FN_("LD IYL,E"      ,LD_IYL_E        ) { IYL = E; }
Z80FN_("LD IYL,IYH"    ,LD_IYL_IYH      ) { IYL = IYH; }
Z80FN_("LD IYL,IYL"    ,LD_IYL_IYL      ) { IYL = IYL; }

#ifndef Z80_ASM

Z80FN_("LD A,(lm)"     ,LD_A_IlmI       ) { A = READ(arg12); }
Z80FN_("LD A,(BC)"     ,LD_A_IBCI       ) { A = READ(BC); }
Z80FN_("LD A,(DE)"     ,LD_A_IDEI       ) { A = READ(DE); }
Z80FN_("LD A,(HL)"     ,LD_A_IHLI       ) { A = READ(HL); }
Z80FN_("LD B,(HL)"     ,LD_B_IHLI       ) { B = READ(HL); }
Z80FN_("LD C,(HL)"     ,LD_C_IHLI       ) { C = READ(HL); }
Z80FN_("LD D,(HL)"     ,LD_D_IHLI       ) { D = READ(HL); }
Z80FN_("LD E,(HL)"     ,LD_E_IHLI       ) { E = READ(HL); }
Z80FN_("LD H,(HL)"     ,LD_H_IHLI       ) { H = READ(HL); }
Z80FN_("LD L,(HL)"     ,LD_L_IHLI       ) { L = READ(HL); }
Z80FN_("LD A,(IX+d)"   ,LD_A_IIX_dI     ) { A = READ(IX_d); }
Z80FN_("LD B,(IX+d)"   ,LD_B_IIX_dI     ) { B = READ(IX_d); }
Z80FN_("LD C,(IX+d)"   ,LD_C_IIX_dI     ) { C = READ(IX_d); }
Z80FN_("LD D,(IX+d)"   ,LD_D_IIX_dI     ) { D = READ(IX_d); }
Z80FN_("LD E,(IX+d)"   ,LD_E_IIX_dI     ) { E = READ(IX_d); }
Z80FN_("LD H,(IX+d)"   ,LD_H_IIX_dI     ) { H = READ(IX_d); }
Z80FN_("LD L,(IX+d)"   ,LD_L_IIX_dI     ) { L = READ(IX_d); }
Z80FN_("LD A,(IY+d)"   ,LD_A_IIY_dI     ) { A = READ(IY_d); }
Z80FN_("LD B,(IY+d)"   ,LD_B_IIY_dI     ) { B = READ(IY_d); }
Z80FN_("LD C,(IY+d)"   ,LD_C_IIY_dI     ) { C = READ(IY_d); }
Z80FN_("LD D,(IY+d)"   ,LD_D_IIY_dI     ) { D = READ(IY_d); }
Z80FN_("LD E,(IY+d)"   ,LD_E_IIY_dI     ) { E = READ(IY_d); }
Z80FN_("LD H,(IY+d)"   ,LD_H_IIY_dI     ) { H = READ(IY_d); }
Z80FN_("LD L,(IY+d)"   ,LD_L_IIY_dI     ) { L = READ(IY_d); }

Z80FN_("LD (lm),A"     ,LD_IlmI_A       ) { WRITE(arg12, A); }
Z80FN_("LD (HL),n"     ,LD_IHLI_n       ) { WRITE(HL, arg1); }
Z80FN_("LD (BC),A"     ,LD_IBCI_A       ) { WRITE(BC, A); }
Z80FN_("LD (DE),A"     ,LD_IDEI_A       ) { WRITE(DE, A); }
Z80FN_("LD (HL),A"     ,LD_IHLI_A       ) { WRITE(HL, A); }
Z80FN_("LD (HL),B"     ,LD_IHLI_B       ) { WRITE(HL, B); }
Z80FN_("LD (HL),C"     ,LD_IHLI_C       ) { WRITE(HL, C); }
Z80FN_("LD (HL),D"     ,LD_IHLI_D       ) { WRITE(HL, D); }
Z80FN_("LD (HL),E"     ,LD_IHLI_E       ) { WRITE(HL, E); }
Z80FN_("LD (HL),H"     ,LD_IHLI_H       ) { WRITE(HL, H); }
Z80FN_("LD (HL),L"     ,LD_IHLI_L       ) { WRITE(HL, L); }
Z80FN_("LD (IX+d),n"   ,LD_IIX_dI_n     ) { WRITE(IX_d, arg2); }
Z80FN_("LD (IY+d),n"   ,LD_IIY_dI_n     ) { WRITE(IY_d, arg2); }
Z80FN_("LD (IX+d),A"   ,LD_IIX_dI_A     ) { WRITE(IX_d, A); }
Z80FN_("LD (IX+d),B"   ,LD_IIX_dI_B     ) { WRITE(IX_d, B); }
Z80FN_("LD (IX+d),C"   ,LD_IIX_dI_C     ) { WRITE(IX_d, C); }
Z80FN_("LD (IX+d),D"   ,LD_IIX_dI_D     ) { WRITE(IX_d, D); }
Z80FN_("LD (IX+d),E"   ,LD_IIX_dI_E     ) { WRITE(IX_d, E); }
Z80FN_("LD (IX+d),H"   ,LD_IIX_dI_H     ) { WRITE(IX_d, H); }
Z80FN_("LD (IX+d),L"   ,LD_IIX_dI_L     ) { WRITE(IX_d, L); }
Z80FN_("LD (IY+d),A"   ,LD_IIY_dI_A     ) { WRITE(IY_d, A); }
Z80FN_("LD (IY+d),B"   ,LD_IIY_dI_B     ) { WRITE(IY_d, B); }
Z80FN_("LD (IY+d),C"   ,LD_IIY_dI_C     ) { WRITE(IY_d, C); }
Z80FN_("LD (IY+d),D"   ,LD_IIY_dI_D     ) { WRITE(IY_d, D); }
Z80FN_("LD (IY+d),E"   ,LD_IIY_dI_E     ) { WRITE(IY_d, E); }
Z80FN_("LD (IY+d),H"   ,LD_IIY_dI_H     ) { WRITE(IY_d, H); }
Z80FN_("LD (IY+d),L"   ,LD_IIY_dI_L     ) { WRITE(IY_d, L); }

#endif /*Z80_ASM*/

Z80FN_("LD A,I"        ,LD_A_I          ) { A = I; F = (A & 0xa8) | (!A << 6) | (IFF2 << 2) | (F & 1); }
Z80FN_("LD A,R"        ,LD_A_R          ) { A = R; F = (A & 0xa8) | (!A << 6) | (IFF2 << 2) | (F & 1); R = ((R + 1) & 0x7f) | (R & 0x80/*bit7͈ێ*/); }
Z80FN_("LD I,A"        ,LD_I_A          ) { I = A; }
Z80FN_("LD R,A"        ,LD_R_A          ) { R = A; }

/****************************************************************************
 *	16-Bit Load Group
 ****************************************************************************/

#ifndef Z80_ASM

Z80FN_("LD SP,HL"      ,LD_SP_HL        ) { SP = HL; }
Z80FN_("LD SP,IX"      ,LD_SP_IX        ) { SP = IX; }
Z80FN_("LD SP,IY"      ,LD_SP_IY        ) { SP = IY; }

Z80FN_("LD BC,lm"      ,LD_BC_lm        ) { BC = arg12; }
Z80FN_("LD DE,lm"      ,LD_DE_lm        ) { DE = arg12; }
Z80FN_("LD HL,lm"      ,LD_HL_lm        ) { HL = arg12; }
Z80FN_("LD SP,lm"      ,LD_SP_lm        ) { SP = arg12; }
Z80FN_("LD IX,lm"      ,LD_IX_lm        ) { IX = arg12; }
Z80FN_("LD IY,lm"      ,LD_IY_lm        ) { IY = arg12; }

Z80FN_("LD BC,(lm)"    ,LD_BC_IlmI      ) { BC = READ16(arg12); }
Z80FN_("LD DE,(lm)"    ,LD_DE_IlmI      ) { DE = READ16(arg12); }
Z80FN_("LD HL,(lm)"    ,LD_HL_IlmI      ) { HL = READ16(arg12); }
Z80FN_("LD SP,(lm)"    ,LD_SP_IlmI      ) { SP = READ16(arg12); }
Z80FN_("LD IX,(lm)"    ,LD_IX_IlmI      ) { IX = READ16(arg12); }
Z80FN_("LD IY,(lm)"    ,LD_IY_IlmI      ) { IY = READ16(arg12); }

Z80FN_("LD (lm),BC"    ,LD_IlmI_BC      ) { WRITE16(arg12, BC); }
Z80FN_("LD (lm),DE"    ,LD_IlmI_DE      ) { WRITE16(arg12, DE); }
Z80FN_("LD (lm),HL"    ,LD_IlmI_HL      ) { WRITE16(arg12, HL); }
Z80FN_("LD (lm),SP"    ,LD_IlmI_SP      ) { WRITE16(arg12, SP); }
Z80FN_("LD (lm),IX"    ,LD_IlmI_IX      ) { WRITE16(arg12, IX); }
Z80FN_("LD (lm),IY"    ,LD_IlmI_IY      ) { WRITE16(arg12, IY); }

Z80FN_("POP AF"        ,POP_AF          ) { POP(AF); }
Z80FN_("POP BC"        ,POP_BC          ) { POP(BC); }
Z80FN_("POP DE"        ,POP_DE          ) { POP(DE); }
Z80FN_("POP HL"        ,POP_HL          ) { POP(HL); }
Z80FN_("POP IX"        ,POP_IX          ) { POP(IX); }
Z80FN_("POP IY"        ,POP_IY          ) { POP(IY); }

Z80FN_("PUSH AF"       ,PUSH_AF         ) { PUSH(AF); }
Z80FN_("PUSH BC"       ,PUSH_BC         ) { PUSH(BC); }
Z80FN_("PUSH DE"       ,PUSH_DE         ) { PUSH(DE); }
Z80FN_("PUSH HL"       ,PUSH_HL         ) { PUSH(HL); }
Z80FN_("PUSH IX"       ,PUSH_IX         ) { PUSH(IX); }
Z80FN_("PUSH IY"       ,PUSH_IY         ) { PUSH(IY); }

#endif /*Z80_ASM*/

/****************************************************************************
 *	Exchange, Block Transfer, and Search Group
 ****************************************************************************/

Z80FN_("EX (SP),HL"    ,EX_ISPI_HL      ) { unsigned short tmp = HL; HL = READ16(SP); WRITE16(SP, tmp); }
Z80FN_("EX (SP),IX"    ,EX_ISPI_IX      ) { unsigned short tmp = IX; IX = READ16(SP); WRITE16(SP, tmp); }
Z80FN_("EX (SP),IY"    ,EX_ISPI_IY      ) { unsigned short tmp = IY; IY = READ16(SP); WRITE16(SP, tmp); }
Z80FN_("EX AF,AF'"     ,EX_AF_AF2       ) { EX(AF, AF2); }
Z80FN_("EX DE,HL"      ,EX_DE_HL        ) { EX(DE, HL); }
Z80FN_("EXX"           ,EXX             ) { EX(BC, BC2); EX(DE, DE2); EX(HL, HL2); }

Z80FN_("LDI"           ,LDI             ) { unsigned char tmp = READ(HL++); WRITE(DE++, tmp); BC--; F = (F & 0xc1) | (tmp & 0x28) | ((BC != 0) << 2); } /* tOvmF */
Z80FN_("LDIR"          ,LDIR            ) { z80op_LDI(z80, code, arg1, arg2); if(F & 4) { PC -= 2; CYCLE -= 5; } }
Z80FN_("LDD"           ,LDD             ) { unsigned char tmp = READ(HL--); WRITE(DE--, tmp); BC--; F = (F & 0xc1) | (tmp & 0x28) | ((BC != 0) << 2); } /* tOvmF */
Z80FN_("LDDR"          ,LDDR            ) { z80op_LDD(z80, code, arg1, arg2); if(F & 4) { PC -= 2; CYCLE -= 5; } }

Z80FN_("CPI"           ,CPI             ) { unsigned char c = F & 1; CP(READ(HL++)); BC--; F = (F & 0xfa) | (BC != 0) << 2 | c; } /* tOvmF */
Z80FN_("CPIR"          ,CPIR            ) { z80op_CPI(z80, code, arg1, arg2); if((F & 0x44) == 4) { PC -= 2; CYCLE -= 5; } }
Z80FN_("CPD"           ,CPD             ) { unsigned char c = F & 1; CP(READ(HL--)); BC--; F = (F & 0xfa) | (BC != 0) << 2 | c; } /* tOvmF */
Z80FN_("CPDR"          ,CPDR            ) { z80op_CPD(z80, code, arg1, arg2); if((F & 0x44) == 4) { PC -= 2; CYCLE -= 5; } }

/****************************************************************************
 *	8-Bit Arithmetic Group
 ****************************************************************************/

#ifndef Z80_ASM

Z80FN_("ADD A,n"       ,ADD_A_n         ) { ADD8(arg1); }
Z80FN_("ADD A,A"       ,ADD_A_A         ) { ADD8(A); }
Z80FN_("ADD A,B"       ,ADD_A_B         ) { ADD8(B); }
Z80FN_("ADD A,C"       ,ADD_A_C         ) { ADD8(C); }
Z80FN_("ADD A,D"       ,ADD_A_D         ) { ADD8(D); }
Z80FN_("ADD A,E"       ,ADD_A_E         ) { ADD8(E); }
Z80FN_("ADD A,H"       ,ADD_A_H         ) { ADD8(H); }
Z80FN_("ADD A,L"       ,ADD_A_L         ) { ADD8(L); }
Z80FN_("ADD A,IXH"     ,ADD_A_IXH       ) { ADD8(IXH); }
Z80FN_("ADD A,IXL"     ,ADD_A_IXL       ) { ADD8(IXL); }
Z80FN_("ADD A,IYH"     ,ADD_A_IYH       ) { ADD8(IYH); }
Z80FN_("ADD A,IYL"     ,ADD_A_IYL       ) { ADD8(IYL); }
Z80FN_("ADD A,(HL)"    ,ADD_A_IHLI      ) { ADD8(READ(HL)); }
Z80FN_("ADD A,(IX+d)"  ,ADD_A_IIX_dI    ) { ADD8(READ(IX_d)); }
Z80FN_("ADD A,(IY+d)"  ,ADD_A_IIY_dI    ) { ADD8(READ(IY_d)); }

Z80FN_("ADC A,n"       ,ADC_A_n         ) { ADC8(arg1); }
Z80FN_("ADC A,A"       ,ADC_A_A         ) { ADC8(A); }
Z80FN_("ADC A,B"       ,ADC_A_B         ) { ADC8(B); }
Z80FN_("ADC A,C"       ,ADC_A_C         ) { ADC8(C); }
Z80FN_("ADC A,D"       ,ADC_A_D         ) { ADC8(D); }
Z80FN_("ADC A,E"       ,ADC_A_E         ) { ADC8(E); }
Z80FN_("ADC A,H"       ,ADC_A_H         ) { ADC8(H); }
Z80FN_("ADC A,L"       ,ADC_A_L         ) { ADC8(L); }
Z80FN_("ADC A,IXH"     ,ADC_A_IXH       ) { ADC8(IXH); }
Z80FN_("ADC A,IXL"     ,ADC_A_IXL       ) { ADC8(IXL); }
Z80FN_("ADC A,IYH"     ,ADC_A_IYH       ) { ADC8(IYH); }
Z80FN_("ADC A,IYL"     ,ADC_A_IYL       ) { ADC8(IYL); }
Z80FN_("ADC A,(HL)"    ,ADC_A_IHLI      ) { ADC8(READ(HL)); }
Z80FN_("ADC A,(IX+d)"  ,ADC_A_IIX_dI    ) { ADC8(READ(IX_d)); }
Z80FN_("ADC A,(IY+d)"  ,ADC_A_IIY_dI    ) { ADC8(READ(IY_d)); }

Z80FN_("SUB n"         ,SUB_n           ) { SUB8(arg1); }
Z80FN_("SUB A"         ,SUB_A           ) { SUB8(A); }
Z80FN_("SUB B"         ,SUB_B           ) { SUB8(B); }
Z80FN_("SUB C"         ,SUB_C           ) { SUB8(C); }
Z80FN_("SUB D"         ,SUB_D           ) { SUB8(D); }
Z80FN_("SUB E"         ,SUB_E           ) { SUB8(E); }
Z80FN_("SUB H"         ,SUB_H           ) { SUB8(H); }
Z80FN_("SUB L"         ,SUB_L           ) { SUB8(L); }
Z80FN_("SUB IXH"       ,SUB_IXH         ) { SUB8(IXH); }
Z80FN_("SUB IXL"       ,SUB_IXL         ) { SUB8(IXL); }
Z80FN_("SUB IYH"       ,SUB_IYH         ) { SUB8(IYH); }
Z80FN_("SUB IYL"       ,SUB_IYL         ) { SUB8(IYL); }
Z80FN_("SUB (HL)"      ,SUB_IHLI        ) { SUB8(READ(HL)); }
Z80FN_("SUB (IX+d)"    ,SUB_IIX_dI      ) { SUB8(READ(IX_d)); }
Z80FN_("SUB (IY+d)"    ,SUB_IIY_dI      ) { SUB8(READ(IY_d)); }

Z80FN_("SBC A,n"       ,SBC_A_n         ) { SBC8(arg1); }
Z80FN_("SBC A,A"       ,SBC_A_A         ) { SBC8(A); }
Z80FN_("SBC A,B"       ,SBC_A_B         ) { SBC8(B); }
Z80FN_("SBC A,C"       ,SBC_A_C         ) { SBC8(C); }
Z80FN_("SBC A,D"       ,SBC_A_D         ) { SBC8(D); }
Z80FN_("SBC A,E"       ,SBC_A_E         ) { SBC8(E); }
Z80FN_("SBC A,H"       ,SBC_A_H         ) { SBC8(H); }
Z80FN_("SBC A,L"       ,SBC_A_L         ) { SBC8(L); }
Z80FN_("SBC A,IXH"     ,SBC_A_IXH       ) { SBC8(IXH); }
Z80FN_("SBC A,IXL"     ,SBC_A_IXL       ) { SBC8(IXL); }
Z80FN_("SBC A,IYH"     ,SBC_A_IYH       ) { SBC8(IYH); }
Z80FN_("SBC A,IYL"     ,SBC_A_IYL       ) { SBC8(IYL); }
Z80FN_("SBC A,(HL)"    ,SBC_A_IHLI      ) { SBC8(READ(HL)); }
Z80FN_("SBC A,(IX+d)"  ,SBC_A_IIX_dI    ) { SBC8(READ(IX_d)); }
Z80FN_("SBC A,(IY+d)"  ,SBC_A_IIY_dI    ) { SBC8(READ(IY_d)); }

Z80FN_("AND n"         ,AND_n           ) { AND(arg1); }
Z80FN_("AND A"         ,AND_A           ) { AND(A); }
Z80FN_("AND B"         ,AND_B           ) { AND(B); }
Z80FN_("AND C"         ,AND_C           ) { AND(C); }
Z80FN_("AND D"         ,AND_D           ) { AND(D); }
Z80FN_("AND E"         ,AND_E           ) { AND(E); }
Z80FN_("AND H"         ,AND_H           ) { AND(H); }
Z80FN_("AND L"         ,AND_L           ) { AND(L); }
Z80FN_("AND IXH"       ,AND_IXH         ) { AND(IXH); }
Z80FN_("AND IXL"       ,AND_IXL         ) { AND(IXL); }
Z80FN_("AND IYH"       ,AND_IYH         ) { AND(IYH); }
Z80FN_("AND IYL"       ,AND_IYL         ) { AND(IYL); }
Z80FN_("AND (HL)"      ,AND_IHLI        ) { AND(READ(HL)); }
Z80FN_("AND (IX+d)"    ,AND_IIX_dI      ) { AND(READ(IX_d)); }
Z80FN_("AND (IY+d)"    ,AND_IIY_dI      ) { AND(READ(IY_d)); }

Z80FN_("OR n"          ,OR_n            ) { OR(arg1); }
Z80FN_("OR A"          ,OR_A            ) { OR(A); }
Z80FN_("OR B"          ,OR_B            ) { OR(B); }
Z80FN_("OR C"          ,OR_C            ) { OR(C); }
Z80FN_("OR D"          ,OR_D            ) { OR(D); }
Z80FN_("OR E"          ,OR_E            ) { OR(E); }
Z80FN_("OR H"          ,OR_H            ) { OR(H); }
Z80FN_("OR L"          ,OR_L            ) { OR(L); }
Z80FN_("OR IXH"        ,OR_IXH          ) { OR(IXH); }
Z80FN_("OR IXL"        ,OR_IXL          ) { OR(IXL); }
Z80FN_("OR IYH"        ,OR_IYH          ) { OR(IYH); }
Z80FN_("OR IYL"        ,OR_IYL          ) { OR(IYL); }
Z80FN_("OR (HL)"       ,OR_IHLI         ) { OR(READ(HL)); }
Z80FN_("OR (IX+d)"     ,OR_IIX_dI       ) { OR(READ(IX_d)); }
Z80FN_("OR (IY+d)"     ,OR_IIY_dI       ) { OR(READ(IY_d)); }

Z80FN_("XOR n"         ,XOR_n           ) { XOR(arg1); }
Z80FN_("XOR A"         ,XOR_A           ) { XOR(A); }
Z80FN_("XOR B"         ,XOR_B           ) { XOR(B); }
Z80FN_("XOR C"         ,XOR_C           ) { XOR(C); }
Z80FN_("XOR D"         ,XOR_D           ) { XOR(D); }
Z80FN_("XOR E"         ,XOR_E           ) { XOR(E); }
Z80FN_("XOR H"         ,XOR_H           ) { XOR(H); }
Z80FN_("XOR L"         ,XOR_L           ) { XOR(L); }
Z80FN_("XOR IXH"       ,XOR_IXH         ) { XOR(IXH); }
Z80FN_("XOR IXL"       ,XOR_IXL         ) { XOR(IXL); }
Z80FN_("XOR IYH"       ,XOR_IYH         ) { XOR(IYH); }
Z80FN_("XOR IYL"       ,XOR_IYL         ) { XOR(IYL); }
Z80FN_("XOR (HL)"      ,XOR_IHLI        ) { XOR(READ(HL)); }
Z80FN_("XOR (IX+d)"    ,XOR_IIX_dI      ) { XOR(READ(IX_d)); }
Z80FN_("XOR (IY+d)"    ,XOR_IIY_dI      ) { XOR(READ(IY_d)); }

Z80FN_("CP n"          ,CP_n            ) { CP(arg1); }
Z80FN_("CP A"          ,CP_A            ) { CP(A); }
Z80FN_("CP B"          ,CP_B            ) { CP(B); }
Z80FN_("CP C"          ,CP_C            ) { CP(C); }
Z80FN_("CP D"          ,CP_D            ) { CP(D); }
Z80FN_("CP E"          ,CP_E            ) { CP(E); }
Z80FN_("CP H"          ,CP_H            ) { CP(H); }
Z80FN_("CP L"          ,CP_L            ) { CP(L); }
Z80FN_("CP IXH"        ,CP_IXH          ) { CP(IXH); }
Z80FN_("CP IXL"        ,CP_IXL          ) { CP(IXL); }
Z80FN_("CP IYH"        ,CP_IYH          ) { CP(IYH); }
Z80FN_("CP IYL"        ,CP_IYL          ) { CP(IYL); }
Z80FN_("CP (HL)"       ,CP_IHLI         ) { CP(READ(HL)); }
Z80FN_("CP (IX+d)"     ,CP_IIX_dI       ) { CP(READ(IX_d)); }
Z80FN_("CP (IY+d)"     ,CP_IIY_dI       ) { CP(READ(IY_d)); }

Z80FN_("INC A"         ,INC_A           ) { INC8(A); }
Z80FN_("INC B"         ,INC_B           ) { INC8(B); }
Z80FN_("INC C"         ,INC_C           ) { INC8(C); }
Z80FN_("INC D"         ,INC_D           ) { INC8(D); }
Z80FN_("INC E"         ,INC_E           ) { INC8(E); }
Z80FN_("INC H"         ,INC_H           ) { INC8(H); }
Z80FN_("INC L"         ,INC_L           ) { INC8(L); }
Z80FN_("INC IXH"       ,INC_IXH         ) { INC8(IXH); }
Z80FN_("INC IXL"       ,INC_IXL         ) { INC8(IXL); }
Z80FN_("INC IYH"       ,INC_IYH         ) { INC8(IYH); }
Z80FN_("INC IYL"       ,INC_IYL         ) { INC8(IYL); }
Z80FN_("INC (HL)"      ,INC_IHLI        ) { unsigned char tmp = READ(HL); INC8(tmp); WRITE(HL, tmp); }
Z80FN_("INC (IX+d)"    ,INC_IIX_dI      ) { unsigned char tmp = READ(IX_d); INC8(tmp); WRITE(IX_d, tmp); }
Z80FN_("INC (IY+d)"    ,INC_IIY_dI      ) { unsigned char tmp = READ(IY_d); INC8(tmp); WRITE(IY_d, tmp); }

Z80FN_("DEC A"         ,DEC_A           ) { DEC8(A); }
Z80FN_("DEC B"         ,DEC_B           ) { DEC8(B); }
Z80FN_("DEC C"         ,DEC_C           ) { DEC8(C); }
Z80FN_("DEC D"         ,DEC_D           ) { DEC8(D); }
Z80FN_("DEC E"         ,DEC_E           ) { DEC8(E); }
Z80FN_("DEC H"         ,DEC_H           ) { DEC8(H); }
Z80FN_("DEC L"         ,DEC_L           ) { DEC8(L); }
Z80FN_("DEC IXH"       ,DEC_IXH         ) { DEC8(IXH); }
Z80FN_("DEC IXL"       ,DEC_IXL         ) { DEC8(IXL); }
Z80FN_("DEC IYH"       ,DEC_IYH         ) { DEC8(IYH); }
Z80FN_("DEC IYL"       ,DEC_IYL         ) { DEC8(IYL); }
Z80FN_("DEC (HL)"      ,DEC_IHLI        ) { unsigned char tmp = READ(HL); DEC8(tmp); WRITE(HL, tmp); }
Z80FN_("DEC (IX+d)"    ,DEC_IIX_dI      ) { unsigned char tmp = READ(IX_d); DEC8(tmp); WRITE(IX_d, tmp); }
Z80FN_("DEC (IY+d)"    ,DEC_IIY_dI      ) { unsigned char tmp = READ(IY_d); DEC8(tmp); WRITE(IY_d, tmp); }

#endif /*Z80_ASM*/

/****************************************************************************
 *	General-Purpose Arithmetic and CPU Control Group
 ****************************************************************************/

/*	ZiLOG Z80 Family CPU User Manual (um0080.pdf) 167y[WADAA߂̏e[u
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|                |        |Hex Value In|        |Hex Value In|Number  |       |    
 *	|                |C Before|Upper Digit |H Before|Lower Digit |Added to|C After|    
 *	|Operation       |DAA     |(bit 7-4)   |DAA     |(bit 3-0)   |Byte    |DAA    |    
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|ADD/ADC/INC     |0       |0-9         |0       |0-9         |00      |0      |( 1)
 *	|ADD/ADC/INC     |0       |0-8         |0       |A-F         |06      |0      |( 2)
 *	|ADD/ADC/INC     |0       |0-9         |1       |0-3         |06      |0      |( 3)
 *	|ADD/ADC/INC     |0       |A-F         |0       |0-9         |60      |1      |( 4)
 *	|ADD/ADC/INC     |0       |9-F         |0       |A-F         |66      |1      |( 5)
 *	|ADD/ADC/INC     |0       |A-F         |1       |0-3         |66      |1      |( 6)
 *	|ADD/ADC/INC     |1       |0-2         |0       |0-9         |60      |1      |( 7)
 *	|ADD/ADC/INC     |1       |0-2         |0       |A-F         |66      |1      |( 8)
 *	|ADD/ADC/INC     |1       |0-3         |1       |0-3         |66      |1      |( 9)
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *	|SUB/SBC/DEC/NEG |0       |0-9         |0       |0-9         |00      |0      |(10)
 *	|SUB/SBC/DEC/NEG |0       |0-8         |1       |6-F         |FA      |0      |(11)
 *	|SUB/SBC/DEC/NEG |1       |7-F         |0       |0-9         |A0      |1      |(12)
 *	|SUB/SBC/DEC/NEG |1       |6-7         |1       |6-F         |9A      |1      |(13)
 *	+----------------+--------+------------+--------+------------+--------+-------+    
 *
 *	TODO:	DAAF(H)ݒsłB݂̎ł͏F(H)=0ƂĂ܂B
 *		F(H)DAÂ߂ɎĝŁADAAF(H)gʂ͂ȂƎv܂A
 *		A_vZɖ肪悤ł΁A܂^ĂB
 */
Z80FN_("DAA"           ,DAA             ) {
	unsigned char hi = A >> 4;
	unsigned char lo = A & 0xf;
	//
	unsigned char n;
	unsigned char c;
	//
	//if(!F & 2) { /* ADD/ADC/INC */
	//2005/01/04 Naoyuki Sawa C
	if(!(F & 2)) { /* ADD/ADC/INC */
		if(!(F & 1)) {
			if(!(F & 0x10)) {
				if(lo <= 9) {
					if(hi <= 9) {
						n = 0x00, c = 0;	/*( 1)*/
					} else {
						n = 0x60, c = 1;	/*( 4)*/
					}
				} else {
					if(hi <= 8) {
						n = 0x06, c = 0;	/*( 2)*/
					} else {
						n = 0x66, c = 1;	/*( 5)*/
					}
				}
			} else {
				if(hi <= 9) {
					n = 0x06, c = 0;		/*( 3)*/
				} else {
					n = 0x66, c = 1;		/*( 6)*/
				}
			}
		} else {
			if(!(F & 0x10)) {
				if(lo <= 9) {
					n = 0x60, c = 1;		/*( 7)*/
				} else {
					n = 0x66, c = 1;		/*( 8)*/
				}
			} else {
				n = 0x66, c = 1;			/*( 9)*/
			}
		}
	} else { /* SUB/SBC/DEC/NEG */
		if(!(F & 1)) {
			if(!(F & 0x10)) {
				n = 0x00, c = 0;			/*(10)*/
			} else {
				n = 0xfa, c = 0;			/*(11)*/
			}
		} else {
			if(!(F & 0x10)) {
				n = 0xa0, c = 1;			/*(12)*/
			} else {
				n = 0x9a, c = 1;			/*(13)*/
			}
		}
	}
	//
	A += n;
	F = (A & 0xa8) |	/* F(S,Y,X) */
	    (!A << 6) |		/* F(Z) */
	    PARITY(A) |		/* F(P) */
	    (F & 2) |		/* F(N) */
	    c;			/* F(C) */
}
Z80FN_("CPL"           ,CPL             ) { A = ~A; F = (F & 0xc5) | (A & 0x28) | 0x12; }
Z80FN_("NEG"           ,NEG             ) { A = -A; F = ((A & 0xa8) | 2) | (!A << 6) | (((A & 0xf) != 0) << 4 ) | ((A == 0x80) << 2) | (A != 0); }
Z80FN_("CCF"           ,CCF             ) { F = (F & 0xc4) | (A & 0x28) | ((F & 1) << 4) | ((F & 1) ^ 1); }
Z80FN_("SCF"           ,SCF             ) { F = (F & 0xc4) | (A & 0x28) | 1; }
Z80FN_("NOP"           ,NOP             ) { /* nop */ }
Z80FN_("HALT"          ,HALT            ) { HALT = 1; }
Z80FN_("DI"            ,DI              ) { IFF1 = IFF2 = 0; }
Z80FN_("EI"            ,EI              ) { IFF1 = IFF2 = 1; } /* IFF101֕ω\܂Ał͕ۗINTv󂯕t܂!! RETIŎ󂯕t܂B(dl) */
Z80FN_("IM 0"          ,IM_0            ) { IM = 0; }
Z80FN_("IM 1"          ,IM_1            ) { IM = 2; /*v!!1͌*/}
Z80FN_("IM 2"          ,IM_2            ) { IM = 3; /*v!!1͌*/}

/****************************************************************************
 *	16-Bit Arithmetic Group
 ****************************************************************************/

#ifndef Z80_ASM

Z80FN_("ADD HL,BC"     ,ADD_HL_BC       ) { ADD16(HL, BC); }
Z80FN_("ADD HL,DE"     ,ADD_HL_DE       ) { ADD16(HL, DE); }
Z80FN_("ADD HL,HL"     ,ADD_HL_HL       ) { ADD16(HL, HL); }
Z80FN_("ADD HL,SP"     ,ADD_HL_SP       ) { ADD16(HL, SP); }
Z80FN_("ADD IX,BC"     ,ADD_IX_BC       ) { ADD16(IX, BC); }
Z80FN_("ADD IX,DE"     ,ADD_IX_DE       ) { ADD16(IX, DE); }
Z80FN_("ADD IX,IX"     ,ADD_IX_IX       ) { ADD16(IX, IX); }
Z80FN_("ADD IX,SP"     ,ADD_IX_SP       ) { ADD16(IX, SP); }
Z80FN_("ADD IY,BC"     ,ADD_IY_BC       ) { ADD16(IY, BC); }
Z80FN_("ADD IY,DE"     ,ADD_IY_DE       ) { ADD16(IY, DE); }
Z80FN_("ADD IY,IY"     ,ADD_IY_IY       ) { ADD16(IY, IY); }
Z80FN_("ADD IY,SP"     ,ADD_IY_SP       ) { ADD16(IY, SP); }

Z80FN_("ADC HL,BC"     ,ADC_HL_BC       ) { ADC16(HL, BC); }
Z80FN_("ADC HL,DE"     ,ADC_HL_DE       ) { ADC16(HL, DE); }
Z80FN_("ADC HL,HL"     ,ADC_HL_HL       ) { ADC16(HL, HL); }
Z80FN_("ADC HL,SP"     ,ADC_HL_SP       ) { ADC16(HL, SP); }

Z80FN_("SBC HL,BC"     ,SBC_HL_BC       ) { SBC16(HL, BC); }
Z80FN_("SBC HL,DE"     ,SBC_HL_DE       ) { SBC16(HL, DE); }
Z80FN_("SBC HL,HL"     ,SBC_HL_HL       ) { SBC16(HL, HL); }
Z80FN_("SBC HL,SP"     ,SBC_HL_SP       ) { SBC16(HL, SP); }

#endif /*Z80_ASM*/

Z80FN_("INC BC"        ,INC_BC          ) { BC++; }
Z80FN_("INC DE"        ,INC_DE          ) { DE++; }
Z80FN_("INC HL"        ,INC_HL          ) { HL++; }
Z80FN_("INC SP"        ,INC_SP          ) { SP++; }
Z80FN_("INC IX"        ,INC_IX          ) { IX++; }
Z80FN_("INC IY"        ,INC_IY          ) { IY++; }

Z80FN_("DEC BC"        ,DEC_BC          ) { BC--; }
Z80FN_("DEC DE"        ,DEC_DE          ) { DE--; }
Z80FN_("DEC HL"        ,DEC_HL          ) { HL--; }
Z80FN_("DEC SP"        ,DEC_SP          ) { SP--; }
Z80FN_("DEC IX"        ,DEC_IX          ) { IX--; }
Z80FN_("DEC IY"        ,DEC_IY          ) { IY--; }

/****************************************************************************
 *	Rotate and Shift Group
 ****************************************************************************/

Z80FN_("RLA"           ,RLA             ) { unsigned char tmp = (A << 1) | (F &  1); F = (F & 0xc4) | (tmp & 0x28) | (A >> 7); A = tmp; }
Z80FN_("RLCA"          ,RLCA            ) { unsigned char tmp = (A << 1) | (A >> 7); F = (F & 0xc4) | (tmp & 0x28) | (A >> 7); A = tmp; }
Z80FN_("RRA"           ,RRA             ) { unsigned char tmp = (A >> 1) | (F << 7); F = (F & 0xc4) | (tmp & 0x28) | (A & 1); A = tmp; }
Z80FN_("RRCA"          ,RRCA            ) { unsigned char tmp = (A >> 1) | (A << 7); F = (F & 0xc4) | (tmp & 0x28) | (A & 1); A = tmp; }

#ifndef Z80_ASM

Z80FN_("RL A"          ,RL_A            ) { RL(A); }
Z80FN_("RL B"          ,RL_B            ) { RL(B); }
Z80FN_("RL C"          ,RL_C            ) { RL(C); }
Z80FN_("RL D"          ,RL_D            ) { RL(D); }
Z80FN_("RL E"          ,RL_E            ) { RL(E); }
Z80FN_("RL H"          ,RL_H            ) { RL(H); }
Z80FN_("RL L"          ,RL_L            ) { RL(L); }
Z80FN_("RL (HL)"       ,RL_IHLI         ) { unsigned char tmp = READ(HL); RL(tmp); WRITE(HL, tmp); }
Z80FN_("RL (IX+d)"     ,RL_IIX_dI       ) { unsigned char tmp = READ(IX_d); RL(tmp); WRITE(IX_d, tmp); }
Z80FN_("RL (IY+d)"     ,RL_IIY_dI       ) { unsigned char tmp = READ(IY_d); RL(tmp); WRITE(IY_d, tmp); }

Z80FN_("RLC A"         ,RLC_A           ) { RLC(A); }
Z80FN_("RLC B"         ,RLC_B           ) { RLC(B); }
Z80FN_("RLC C"         ,RLC_C           ) { RLC(C); }
Z80FN_("RLC D"         ,RLC_D           ) { RLC(D); }
Z80FN_("RLC E"         ,RLC_E           ) { RLC(E); }
Z80FN_("RLC H"         ,RLC_H           ) { RLC(H); }
Z80FN_("RLC L"         ,RLC_L           ) { RLC(L); }
Z80FN_("RLC (HL)"      ,RLC_IHLI        ) { unsigned char tmp = READ(HL); RLC(tmp); WRITE(HL, tmp); }
Z80FN_("RLC (IX+d)"    ,RLC_IIX_dI      ) { unsigned char tmp = READ(IX_d); RLC(tmp); WRITE(IX_d, tmp); }
Z80FN_("RLC (IY+d)"    ,RLC_IIY_dI      ) { unsigned char tmp = READ(IY_d); RLC(tmp); WRITE(IY_d, tmp); }

Z80FN_("RR A"          ,RR_A            ) { RR(A); }
Z80FN_("RR B"          ,RR_B            ) { RR(B); }
Z80FN_("RR C"          ,RR_C            ) { RR(C); }
Z80FN_("RR D"          ,RR_D            ) { RR(D); }
Z80FN_("RR E"          ,RR_E            ) { RR(E); }
Z80FN_("RR H"          ,RR_H            ) { RR(H); }
Z80FN_("RR L"          ,RR_L            ) { RR(L); }
Z80FN_("RR (HL)"       ,RR_IHLI         ) { unsigned char tmp = READ(HL); RR(tmp); WRITE(HL, tmp); }
Z80FN_("RR (IX+d)"     ,RR_IIX_dI       ) { unsigned char tmp = READ(IX_d); RR(tmp); WRITE(IX_d, tmp); }
Z80FN_("RR (IY+d)"     ,RR_IIY_dI       ) { unsigned char tmp = READ(IY_d); RR(tmp); WRITE(IY_d, tmp); }

Z80FN_("RRC A"         ,RRC_A           ) { RRC(A); }
Z80FN_("RRC B"         ,RRC_B           ) { RRC(B); }
Z80FN_("RRC C"         ,RRC_C           ) { RRC(C); }
Z80FN_("RRC D"         ,RRC_D           ) { RRC(D); }
Z80FN_("RRC E"         ,RRC_E           ) { RRC(E); }
Z80FN_("RRC H"         ,RRC_H           ) { RRC(H); }
Z80FN_("RRC L"         ,RRC_L           ) { RRC(L); }
Z80FN_("RRC (HL)"      ,RRC_IHLI        ) { unsigned char tmp = READ(HL); RRC(tmp); WRITE(HL, tmp); }
Z80FN_("RRC (IX+d)"    ,RRC_IIX_dI      ) { unsigned char tmp = READ(IX_d); RRC(tmp); WRITE(IX_d, tmp); }
Z80FN_("RRC (IY+d)"    ,RRC_IIY_dI      ) { unsigned char tmp = READ(IY_d); RRC(tmp); WRITE(IY_d, tmp); }

Z80FN_("SLA A"         ,SLA_A           ) { SLA(A); }
Z80FN_("SLA B"         ,SLA_B           ) { SLA(B); }
Z80FN_("SLA C"         ,SLA_C           ) { SLA(C); }
Z80FN_("SLA D"         ,SLA_D           ) { SLA(D); }
Z80FN_("SLA E"         ,SLA_E           ) { SLA(E); }
Z80FN_("SLA H"         ,SLA_H           ) { SLA(H); }
Z80FN_("SLA L"         ,SLA_L           ) { SLA(L); }
Z80FN_("SLA (HL)"      ,SLA_IHLI        ) { unsigned char tmp = READ(HL); SLA(tmp); WRITE(HL, tmp); }
Z80FN_("SLA (IX+d)"    ,SLA_IIX_dI      ) { unsigned char tmp = READ(IX_d); SLA(tmp); WRITE(IX_d, tmp); }
Z80FN_("SLA (IY+d)"    ,SLA_IIY_dI      ) { unsigned char tmp = READ(IY_d); SLA(tmp); WRITE(IY_d, tmp); }

Z80FN_("SRA A"         ,SRA_A           ) { SRA(A); }
Z80FN_("SRA B"         ,SRA_B           ) { SRA(B); }
Z80FN_("SRA C"         ,SRA_C           ) { SRA(C); }
Z80FN_("SRA D"         ,SRA_D           ) { SRA(D); }
Z80FN_("SRA E"         ,SRA_E           ) { SRA(E); }
Z80FN_("SRA H"         ,SRA_H           ) { SRA(H); }
Z80FN_("SRA L"         ,SRA_L           ) { SRA(L); }
Z80FN_("SRA (HL)"      ,SRA_IHLI        ) { unsigned char tmp = READ(HL); SRA(tmp); WRITE(HL, tmp); }
Z80FN_("SRA (IX+d)"    ,SRA_IIX_dI      ) { unsigned char tmp = READ(IX_d); SRA(tmp); WRITE(IX_d, tmp); }
Z80FN_("SRA (IY+d)"    ,SRA_IIY_dI      ) { unsigned char tmp = READ(IY_d); SRA(tmp); WRITE(IY_d, tmp); }

Z80FN_("SRL A"         ,SRL_A           ) { SRL(A); }
Z80FN_("SRL B"         ,SRL_B           ) { SRL(B); }
Z80FN_("SRL C"         ,SRL_C           ) { SRL(C); }
Z80FN_("SRL D"         ,SRL_D           ) { SRL(D); }
Z80FN_("SRL E"         ,SRL_E           ) { SRL(E); }
Z80FN_("SRL H"         ,SRL_H           ) { SRL(H); }
Z80FN_("SRL L"         ,SRL_L           ) { SRL(L); }
Z80FN_("SRL (HL)"      ,SRL_IHLI        ) { unsigned char tmp = READ(HL); SRL(tmp); WRITE(HL, tmp); }
Z80FN_("SRL (IX+d)"    ,SRL_IIX_dI      ) { unsigned char tmp = READ(IX_d); SRL(tmp); WRITE(IX_d, tmp); }
Z80FN_("SRL (IY+d)"    ,SRL_IIY_dI      ) { unsigned char tmp = READ(IY_d); SRL(tmp); WRITE(IY_d, tmp); }

#endif /*Z80_ASM*/

Z80FN_("RLD"           ,RLD             ) {
	unsigned char tmp = READ(HL);
	WRITE(HL, (A & 0xf) | (tmp << 4));
	A = (A & 0xf0) | (tmp >> 4);
	F = (A & 0xa8) | (!A << 6) | PARITY(A) | (F & 1);
}
Z80FN_("RRD"           ,RRD             ) {
	unsigned char tmp = READ(HL);
	WRITE(HL, (A << 4) | (tmp >> 4));
	A = (A & 0xf0) | (tmp & 0xf);
	F = (A & 0xa8) | (!A << 6) | PARITY(A) | (F & 1);
}

/****************************************************************************
 *	Bit Set, Reset, and Test Group
 ****************************************************************************/

Z80FN_("BIT 0,A"       ,BIT_0_A         ) { BIT(0, A); }
Z80FN_("BIT 0,B"       ,BIT_0_B         ) { BIT(0, B); }
Z80FN_("BIT 0,C"       ,BIT_0_C         ) { BIT(0, C); }
Z80FN_("BIT 0,D"       ,BIT_0_D         ) { BIT(0, D); }
Z80FN_("BIT 0,E"       ,BIT_0_E         ) { BIT(0, E); }
Z80FN_("BIT 0,H"       ,BIT_0_H         ) { BIT(0, H); }
Z80FN_("BIT 0,L"       ,BIT_0_L         ) { BIT(0, L); }
Z80FN_("BIT 0,(HL)"    ,BIT_0_IHLI      ) { BIT(0, READ(HL)); }
Z80FN_("BIT 0,(IX+d)"  ,BIT_0_IIX_dI    ) { BIT(0, READ(IX_d)); }
Z80FN_("BIT 0,(IY+d)"  ,BIT_0_IIY_dI    ) { BIT(0, READ(IY_d)); }
Z80FN_("BIT 1,A"       ,BIT_1_A         ) { BIT(1, A); }
Z80FN_("BIT 1,B"       ,BIT_1_B         ) { BIT(1, B); }
Z80FN_("BIT 1,C"       ,BIT_1_C         ) { BIT(1, C); }
Z80FN_("BIT 1,D"       ,BIT_1_D         ) { BIT(1, D); }
Z80FN_("BIT 1,E"       ,BIT_1_E         ) { BIT(1, E); }
Z80FN_("BIT 1,H"       ,BIT_1_H         ) { BIT(1, H); }
Z80FN_("BIT 1,L"       ,BIT_1_L         ) { BIT(1, L); }
Z80FN_("BIT 1,(HL)"    ,BIT_1_IHLI      ) { BIT(1, READ(HL)); }
Z80FN_("BIT 1,(IX+d)"  ,BIT_1_IIX_dI    ) { BIT(1, READ(IX_d)); }
Z80FN_("BIT 1,(IY+d)"  ,BIT_1_IIY_dI    ) { BIT(1, READ(IY_d)); }
Z80FN_("BIT 2,A"       ,BIT_2_A         ) { BIT(2, A); }
Z80FN_("BIT 2,B"       ,BIT_2_B         ) { BIT(2, B); }
Z80FN_("BIT 2,C"       ,BIT_2_C         ) { BIT(2, C); }
Z80FN_("BIT 2,D"       ,BIT_2_D         ) { BIT(2, D); }
Z80FN_("BIT 2,E"       ,BIT_2_E         ) { BIT(2, E); }
Z80FN_("BIT 2,H"       ,BIT_2_H         ) { BIT(2, H); }
Z80FN_("BIT 2,L"       ,BIT_2_L         ) { BIT(2, L); }
Z80FN_("BIT 2,(HL)"    ,BIT_2_IHLI      ) { BIT(2, READ(HL)); }
Z80FN_("BIT 2,(IX+d)"  ,BIT_2_IIX_dI    ) { BIT(2, READ(IX_d)); }
Z80FN_("BIT 2,(IY+d)"  ,BIT_2_IIY_dI    ) { BIT(2, READ(IY_d)); }
Z80FN_("BIT 3,A"       ,BIT_3_A         ) { BIT(3, A); }
Z80FN_("BIT 3,B"       ,BIT_3_B         ) { BIT(3, B); }
Z80FN_("BIT 3,C"       ,BIT_3_C         ) { BIT(3, C); }
Z80FN_("BIT 3,D"       ,BIT_3_D         ) { BIT(3, D); }
Z80FN_("BIT 3,E"       ,BIT_3_E         ) { BIT(3, E); }
Z80FN_("BIT 3,H"       ,BIT_3_H         ) { BIT(3, H); }
Z80FN_("BIT 3,L"       ,BIT_3_L         ) { BIT(3, L); }
Z80FN_("BIT 3,(HL)"    ,BIT_3_IHLI      ) { BIT(3, READ(HL)); }
Z80FN_("BIT 3,(IX+d)"  ,BIT_3_IIX_dI    ) { BIT(3, READ(IX_d)); }
Z80FN_("BIT 3,(IY+d)"  ,BIT_3_IIY_dI    ) { BIT(3, READ(IY_d)); }
Z80FN_("BIT 4,A"       ,BIT_4_A         ) { BIT(4, A); }
Z80FN_("BIT 4,B"       ,BIT_4_B         ) { BIT(4, B); }
Z80FN_("BIT 4,C"       ,BIT_4_C         ) { BIT(4, C); }
Z80FN_("BIT 4,D"       ,BIT_4_D         ) { BIT(4, D); }
Z80FN_("BIT 4,E"       ,BIT_4_E         ) { BIT(4, E); }
Z80FN_("BIT 4,H"       ,BIT_4_H         ) { BIT(4, H); }
Z80FN_("BIT 4,L"       ,BIT_4_L         ) { BIT(4, L); }
Z80FN_("BIT 4,(HL)"    ,BIT_4_IHLI      ) { BIT(4, READ(HL)); }
Z80FN_("BIT 4,(IX+d)"  ,BIT_4_IIX_dI    ) { BIT(4, READ(IX_d)); }
Z80FN_("BIT 4,(IY+d)"  ,BIT_4_IIY_dI    ) { BIT(4, READ(IY_d)); }
Z80FN_("BIT 5,A"       ,BIT_5_A         ) { BIT(5, A); }
Z80FN_("BIT 5,B"       ,BIT_5_B         ) { BIT(5, B); }
Z80FN_("BIT 5,C"       ,BIT_5_C         ) { BIT(5, C); }
Z80FN_("BIT 5,D"       ,BIT_5_D         ) { BIT(5, D); }
Z80FN_("BIT 5,E"       ,BIT_5_E         ) { BIT(5, E); }
Z80FN_("BIT 5,H"       ,BIT_5_H         ) { BIT(5, H); }
Z80FN_("BIT 5,L"       ,BIT_5_L         ) { BIT(5, L); }
Z80FN_("BIT 5,(HL)"    ,BIT_5_IHLI      ) { BIT(5, READ(HL)); }
Z80FN_("BIT 5,(IX+d)"  ,BIT_5_IIX_dI    ) { BIT(5, READ(IX_d)); }
Z80FN_("BIT 5,(IY+d)"  ,BIT_5_IIY_dI    ) { BIT(5, READ(IY_d)); }
Z80FN_("BIT 6,A"       ,BIT_6_A         ) { BIT(6, A); }
Z80FN_("BIT 6,B"       ,BIT_6_B         ) { BIT(6, B); }
Z80FN_("BIT 6,C"       ,BIT_6_C         ) { BIT(6, C); }
Z80FN_("BIT 6,D"       ,BIT_6_D         ) { BIT(6, D); }
Z80FN_("BIT 6,E"       ,BIT_6_E         ) { BIT(6, E); }
Z80FN_("BIT 6,H"       ,BIT_6_H         ) { BIT(6, H); }
Z80FN_("BIT 6,L"       ,BIT_6_L         ) { BIT(6, L); }
Z80FN_("BIT 6,(HL)"    ,BIT_6_IHLI      ) { BIT(6, READ(HL)); }
Z80FN_("BIT 6,(IX+d)"  ,BIT_6_IIX_dI    ) { BIT(6, READ(IX_d)); }
Z80FN_("BIT 6,(IY+d)"  ,BIT_6_IIY_dI    ) { BIT(6, READ(IY_d)); }
Z80FN_("BIT 7,A"       ,BIT_7_A         ) { BIT(7, A); }
Z80FN_("BIT 7,B"       ,BIT_7_B         ) { BIT(7, B); }
Z80FN_("BIT 7,C"       ,BIT_7_C         ) { BIT(7, C); }
Z80FN_("BIT 7,D"       ,BIT_7_D         ) { BIT(7, D); }
Z80FN_("BIT 7,E"       ,BIT_7_E         ) { BIT(7, E); }
Z80FN_("BIT 7,H"       ,BIT_7_H         ) { BIT(7, H); }
Z80FN_("BIT 7,L"       ,BIT_7_L         ) { BIT(7, L); }
Z80FN_("BIT 7,(HL)"    ,BIT_7_IHLI      ) { BIT(7, READ(HL)); }
Z80FN_("BIT 7,(IX+d)"  ,BIT_7_IIX_dI    ) { BIT(7, READ(IX_d)); }
Z80FN_("BIT 7,(IY+d)"  ,BIT_7_IIY_dI    ) { BIT(7, READ(IY_d)); }

Z80FN_("SET 0,A"       ,SET_0_A         ) { SET(0, A); }
Z80FN_("SET 0,B"       ,SET_0_B         ) { SET(0, B); }
Z80FN_("SET 0,C"       ,SET_0_C         ) { SET(0, C); }
Z80FN_("SET 0,D"       ,SET_0_D         ) { SET(0, D); }
Z80FN_("SET 0,E"       ,SET_0_E         ) { SET(0, E); }
Z80FN_("SET 0,H"       ,SET_0_H         ) { SET(0, H); }
Z80FN_("SET 0,L"       ,SET_0_L         ) { SET(0, L); }
Z80FN_("SET 0,(HL)"    ,SET_0_IHLI      ) { unsigned char tmp = READ(HL); SET(0, tmp); WRITE(HL, tmp); }
Z80FN_("SET 0,(IX+d)"  ,SET_0_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(0, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 0,(IY+d)"  ,SET_0_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(0, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 1,A"       ,SET_1_A         ) { SET(1, A); }
Z80FN_("SET 1,B"       ,SET_1_B         ) { SET(1, B); }
Z80FN_("SET 1,C"       ,SET_1_C         ) { SET(1, C); }
Z80FN_("SET 1,D"       ,SET_1_D         ) { SET(1, D); }
Z80FN_("SET 1,E"       ,SET_1_E         ) { SET(1, E); }
Z80FN_("SET 1,H"       ,SET_1_H         ) { SET(1, H); }
Z80FN_("SET 1,L"       ,SET_1_L         ) { SET(1, L); }
Z80FN_("SET 1,(HL)"    ,SET_1_IHLI      ) { unsigned char tmp = READ(HL); SET(1, tmp); WRITE(HL, tmp); }
Z80FN_("SET 1,(IX+d)"  ,SET_1_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(1, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 1,(IY+d)"  ,SET_1_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(1, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 2,A"       ,SET_2_A         ) { SET(2, A); }
Z80FN_("SET 2,B"       ,SET_2_B         ) { SET(2, B); }
Z80FN_("SET 2,C"       ,SET_2_C         ) { SET(2, C); }
Z80FN_("SET 2,D"       ,SET_2_D         ) { SET(2, D); }
Z80FN_("SET 2,E"       ,SET_2_E         ) { SET(2, E); }
Z80FN_("SET 2,H"       ,SET_2_H         ) { SET(2, H); }
Z80FN_("SET 2,L"       ,SET_2_L         ) { SET(2, L); }
Z80FN_("SET 2,(HL)"    ,SET_2_IHLI      ) { unsigned char tmp = READ(HL); SET(2, tmp); WRITE(HL, tmp); }
Z80FN_("SET 2,(IX+d)"  ,SET_2_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(2, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 2,(IY+d)"  ,SET_2_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(2, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 3,A"       ,SET_3_A         ) { SET(3, A); }
Z80FN_("SET 3,B"       ,SET_3_B         ) { SET(3, B); }
Z80FN_("SET 3,C"       ,SET_3_C         ) { SET(3, C); }
Z80FN_("SET 3,D"       ,SET_3_D         ) { SET(3, D); }
Z80FN_("SET 3,E"       ,SET_3_E         ) { SET(3, E); }
Z80FN_("SET 3,H"       ,SET_3_H         ) { SET(3, H); }
Z80FN_("SET 3,L"       ,SET_3_L         ) { SET(3, L); }
Z80FN_("SET 3,(HL)"    ,SET_3_IHLI      ) { unsigned char tmp = READ(HL); SET(3, tmp); WRITE(HL, tmp); }
Z80FN_("SET 3,(IX+d)"  ,SET_3_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(3, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 3,(IY+d)"  ,SET_3_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(3, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 4,A"       ,SET_4_A         ) { SET(4, A); }
Z80FN_("SET 4,B"       ,SET_4_B         ) { SET(4, B); }
Z80FN_("SET 4,C"       ,SET_4_C         ) { SET(4, C); }
Z80FN_("SET 4,D"       ,SET_4_D         ) { SET(4, D); }
Z80FN_("SET 4,E"       ,SET_4_E         ) { SET(4, E); }
Z80FN_("SET 4,H"       ,SET_4_H         ) { SET(4, H); }
Z80FN_("SET 4,L"       ,SET_4_L         ) { SET(4, L); }
Z80FN_("SET 4,(HL)"    ,SET_4_IHLI      ) { unsigned char tmp = READ(HL); SET(4, tmp); WRITE(HL, tmp); }
Z80FN_("SET 4,(IX+d)"  ,SET_4_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(4, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 4,(IY+d)"  ,SET_4_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(4, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 5,A"       ,SET_5_A         ) { SET(5, A); }
Z80FN_("SET 5,B"       ,SET_5_B         ) { SET(5, B); }
Z80FN_("SET 5,C"       ,SET_5_C         ) { SET(5, C); }
Z80FN_("SET 5,D"       ,SET_5_D         ) { SET(5, D); }
Z80FN_("SET 5,E"       ,SET_5_E         ) { SET(5, E); }
Z80FN_("SET 5,H"       ,SET_5_H         ) { SET(5, H); }
Z80FN_("SET 5,L"       ,SET_5_L         ) { SET(5, L); }
Z80FN_("SET 5,(HL)"    ,SET_5_IHLI      ) { unsigned char tmp = READ(HL); SET(5, tmp); WRITE(HL, tmp); }
Z80FN_("SET 5,(IX+d)"  ,SET_5_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(5, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 5,(IY+d)"  ,SET_5_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(5, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 6,A"       ,SET_6_A         ) { SET(6, A); }
Z80FN_("SET 6,B"       ,SET_6_B         ) { SET(6, B); }
Z80FN_("SET 6,C"       ,SET_6_C         ) { SET(6, C); }
Z80FN_("SET 6,D"       ,SET_6_D         ) { SET(6, D); }
Z80FN_("SET 6,E"       ,SET_6_E         ) { SET(6, E); }
Z80FN_("SET 6,H"       ,SET_6_H         ) { SET(6, H); }
Z80FN_("SET 6,L"       ,SET_6_L         ) { SET(6, L); }
Z80FN_("SET 6,(HL)"    ,SET_6_IHLI      ) { unsigned char tmp = READ(HL); SET(6, tmp); WRITE(HL, tmp); }
Z80FN_("SET 6,(IX+d)"  ,SET_6_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(6, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 6,(IY+d)"  ,SET_6_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(6, tmp); WRITE(IY_d, tmp); }
Z80FN_("SET 7,A"       ,SET_7_A         ) { SET(7, A); }
Z80FN_("SET 7,B"       ,SET_7_B         ) { SET(7, B); }
Z80FN_("SET 7,C"       ,SET_7_C         ) { SET(7, C); }
Z80FN_("SET 7,D"       ,SET_7_D         ) { SET(7, D); }
Z80FN_("SET 7,E"       ,SET_7_E         ) { SET(7, E); }
Z80FN_("SET 7,H"       ,SET_7_H         ) { SET(7, H); }
Z80FN_("SET 7,L"       ,SET_7_L         ) { SET(7, L); }
Z80FN_("SET 7,(HL)"    ,SET_7_IHLI      ) { unsigned char tmp = READ(HL); SET(7, tmp); WRITE(HL, tmp); }
Z80FN_("SET 7,(IX+d)"  ,SET_7_IIX_dI    ) { unsigned char tmp = READ(IX_d); SET(7, tmp); WRITE(IX_d, tmp); }
Z80FN_("SET 7,(IY+d)"  ,SET_7_IIY_dI    ) { unsigned char tmp = READ(IY_d); SET(7, tmp); WRITE(IY_d, tmp); }

Z80FN_("RES 0,A"       ,RES_0_A         ) { RES(0, A); }
Z80FN_("RES 0,B"       ,RES_0_B         ) { RES(0, B); }
Z80FN_("RES 0,C"       ,RES_0_C         ) { RES(0, C); }
Z80FN_("RES 0,D"       ,RES_0_D         ) { RES(0, D); }
Z80FN_("RES 0,E"       ,RES_0_E         ) { RES(0, E); }
Z80FN_("RES 0,H"       ,RES_0_H         ) { RES(0, H); }
Z80FN_("RES 0,L"       ,RES_0_L         ) { RES(0, L); }
Z80FN_("RES 0,(HL)"    ,RES_0_IHLI      ) { unsigned char tmp = READ(HL); RES(0, tmp); WRITE(HL, tmp); }
Z80FN_("RES 0,(IX+d)"  ,RES_0_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(0, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 0,(IY+d)"  ,RES_0_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(0, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 1,A"       ,RES_1_A         ) { RES(1, A); }
Z80FN_("RES 1,B"       ,RES_1_B         ) { RES(1, B); }
Z80FN_("RES 1,C"       ,RES_1_C         ) { RES(1, C); }
Z80FN_("RES 1,D"       ,RES_1_D         ) { RES(1, D); }
Z80FN_("RES 1,E"       ,RES_1_E         ) { RES(1, E); }
Z80FN_("RES 1,H"       ,RES_1_H         ) { RES(1, H); }
Z80FN_("RES 1,L"       ,RES_1_L         ) { RES(1, L); }
Z80FN_("RES 1,(HL)"    ,RES_1_IHLI      ) { unsigned char tmp = READ(HL); RES(1, tmp); WRITE(HL, tmp); }
Z80FN_("RES 1,(IX+d)"  ,RES_1_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(1, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 1,(IY+d)"  ,RES_1_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(1, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 2,A"       ,RES_2_A         ) { RES(2, A); }
Z80FN_("RES 2,B"       ,RES_2_B         ) { RES(2, B); }
Z80FN_("RES 2,C"       ,RES_2_C         ) { RES(2, C); }
Z80FN_("RES 2,D"       ,RES_2_D         ) { RES(2, D); }
Z80FN_("RES 2,E"       ,RES_2_E         ) { RES(2, E); }
Z80FN_("RES 2,H"       ,RES_2_H         ) { RES(2, H); }
Z80FN_("RES 2,L"       ,RES_2_L         ) { RES(2, L); }
Z80FN_("RES 2,(HL)"    ,RES_2_IHLI      ) { unsigned char tmp = READ(HL); RES(2, tmp); WRITE(HL, tmp); }
Z80FN_("RES 2,(IX+d)"  ,RES_2_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(2, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 2,(IY+d)"  ,RES_2_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(2, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 3,A"       ,RES_3_A         ) { RES(3, A); }
Z80FN_("RES 3,B"       ,RES_3_B         ) { RES(3, B); }
Z80FN_("RES 3,C"       ,RES_3_C         ) { RES(3, C); }
Z80FN_("RES 3,D"       ,RES_3_D         ) { RES(3, D); }
Z80FN_("RES 3,E"       ,RES_3_E         ) { RES(3, E); }
Z80FN_("RES 3,H"       ,RES_3_H         ) { RES(3, H); }
Z80FN_("RES 3,L"       ,RES_3_L         ) { RES(3, L); }
Z80FN_("RES 3,(HL)"    ,RES_3_IHLI      ) { unsigned char tmp = READ(HL); RES(3, tmp); WRITE(HL, tmp); }
Z80FN_("RES 3,(IX+d)"  ,RES_3_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(3, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 3,(IY+d)"  ,RES_3_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(3, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 4,A"       ,RES_4_A         ) { RES(4, A); }
Z80FN_("RES 4,B"       ,RES_4_B         ) { RES(4, B); }
Z80FN_("RES 4,C"       ,RES_4_C         ) { RES(4, C); }
Z80FN_("RES 4,D"       ,RES_4_D         ) { RES(4, D); }
Z80FN_("RES 4,E"       ,RES_4_E         ) { RES(4, E); }
Z80FN_("RES 4,H"       ,RES_4_H         ) { RES(4, H); }
Z80FN_("RES 4,L"       ,RES_4_L         ) { RES(4, L); }
Z80FN_("RES 4,(HL)"    ,RES_4_IHLI      ) { unsigned char tmp = READ(HL); RES(4, tmp); WRITE(HL, tmp); }
Z80FN_("RES 4,(IX+d)"  ,RES_4_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(4, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 4,(IY+d)"  ,RES_4_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(4, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 5,A"       ,RES_5_A         ) { RES(5, A); }
Z80FN_("RES 5,B"       ,RES_5_B         ) { RES(5, B); }
Z80FN_("RES 5,C"       ,RES_5_C         ) { RES(5, C); }
Z80FN_("RES 5,D"       ,RES_5_D         ) { RES(5, D); }
Z80FN_("RES 5,E"       ,RES_5_E         ) { RES(5, E); }
Z80FN_("RES 5,H"       ,RES_5_H         ) { RES(5, H); }
Z80FN_("RES 5,L"       ,RES_5_L         ) { RES(5, L); }
Z80FN_("RES 5,(HL)"    ,RES_5_IHLI      ) { unsigned char tmp = READ(HL); RES(5, tmp); WRITE(HL, tmp); }
Z80FN_("RES 5,(IX+d)"  ,RES_5_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(5, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 5,(IY+d)"  ,RES_5_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(5, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 6,A"       ,RES_6_A         ) { RES(6, A); }
Z80FN_("RES 6,B"       ,RES_6_B         ) { RES(6, B); }
Z80FN_("RES 6,C"       ,RES_6_C         ) { RES(6, C); }
Z80FN_("RES 6,D"       ,RES_6_D         ) { RES(6, D); }
Z80FN_("RES 6,E"       ,RES_6_E         ) { RES(6, E); }
Z80FN_("RES 6,H"       ,RES_6_H         ) { RES(6, H); }
Z80FN_("RES 6,L"       ,RES_6_L         ) { RES(6, L); }
Z80FN_("RES 6,(HL)"    ,RES_6_IHLI      ) { unsigned char tmp = READ(HL); RES(6, tmp); WRITE(HL, tmp); }
Z80FN_("RES 6,(IX+d)"  ,RES_6_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(6, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 6,(IY+d)"  ,RES_6_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(6, tmp); WRITE(IY_d, tmp); }
Z80FN_("RES 7,A"       ,RES_7_A         ) { RES(7, A); }
Z80FN_("RES 7,B"       ,RES_7_B         ) { RES(7, B); }
Z80FN_("RES 7,C"       ,RES_7_C         ) { RES(7, C); }
Z80FN_("RES 7,D"       ,RES_7_D         ) { RES(7, D); }
Z80FN_("RES 7,E"       ,RES_7_E         ) { RES(7, E); }
Z80FN_("RES 7,H"       ,RES_7_H         ) { RES(7, H); }
Z80FN_("RES 7,L"       ,RES_7_L         ) { RES(7, L); }
Z80FN_("RES 7,(HL)"    ,RES_7_IHLI      ) { unsigned char tmp = READ(HL); RES(7, tmp); WRITE(HL, tmp); }
Z80FN_("RES 7,(IX+d)"  ,RES_7_IIX_dI    ) { unsigned char tmp = READ(IX_d); RES(7, tmp); WRITE(IX_d, tmp); }
Z80FN_("RES 7,(IY+d)"  ,RES_7_IIY_dI    ) { unsigned char tmp = READ(IY_d); RES(7, tmp); WRITE(IY_d, tmp); }

/****************************************************************************
 *	Jump Group
 ****************************************************************************/

Z80FN_("JP (HL)"       ,JP_IHLI         ) { PC = HL; }
Z80FN_("JP (IX)"       ,JP_IIXI         ) { PC = IX; }
Z80FN_("JP (IY)"       ,JP_IIYI         ) { PC = IY; }

#ifndef Z80_ASM

Z80FN_("JP lm"         ,JP_lm           ) { PC = arg12; }
//Z80FN_("JP Z,lm"       ,JP_Z_lm         ) { if(  F & 0x40 ) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP NZ,lm"      ,JP_NZ_lm        ) { if(!(F & 0x40)) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP C,lm"       ,JP_C_lm         ) { if(  F &    1 ) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP NC,lm"      ,JP_NC_lm        ) { if(!(F &    1)) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP PE,lm"      ,JP_PE_lm        ) { if(  F &    4 ) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP PO,lm"      ,JP_PO_lm        ) { if(!(F &    4)) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP M,lm"       ,JP_M_lm         ) { if(  F & 0x80 ) { PC = arg12; CYCLE -= 7; } }
//Z80FN_("JP P,lm"       ,JP_P_lm         ) { if(!(F & 0x80)) { PC = arg12; CYCLE -= 7; } }
// * Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
// - "JP cc"͏/sɂ炸ǉTCNłB
//   ܂ŊԈ+7TCNĂ܂Ă̂C܂B
Z80FN_("JP Z,lm"       ,JP_Z_lm         ) { if(  F & 0x40 ) { PC = arg12; } }
Z80FN_("JP NZ,lm"      ,JP_NZ_lm        ) { if(!(F & 0x40)) { PC = arg12; } }
Z80FN_("JP C,lm"       ,JP_C_lm         ) { if(  F &    1 ) { PC = arg12; } }
Z80FN_("JP NC,lm"      ,JP_NC_lm        ) { if(!(F &    1)) { PC = arg12; } }
Z80FN_("JP PE,lm"      ,JP_PE_lm        ) { if(  F &    4 ) { PC = arg12; } }
Z80FN_("JP PO,lm"      ,JP_PO_lm        ) { if(!(F &    4)) { PC = arg12; } }
Z80FN_("JP M,lm"       ,JP_M_lm         ) { if(  F & 0x80 ) { PC = arg12; } }
Z80FN_("JP P,lm"       ,JP_P_lm         ) { if(!(F & 0x80)) { PC = arg12; } }

Z80FN_("JR e"          ,JR_e            ) { PC += (char)arg1; }
Z80FN_("JR Z,e"        ,JR_Z_e          ) { if(  F & 0x40 ) { PC += (char)arg1; CYCLE -= 5; } }
Z80FN_("JR NZ,e"       ,JR_NZ_e         ) { if(!(F & 0x40)) { PC += (char)arg1; CYCLE -= 5; } }
Z80FN_("JR C,e"        ,JR_C_e          ) { if(  F &    1 ) { PC += (char)arg1; CYCLE -= 5; } }
Z80FN_("JR NC,e"       ,JR_NC_e         ) { if(!(F &    1)) { PC += (char)arg1; CYCLE -= 5; } }

Z80FN_("DJNZ e"        ,DJNZ_e          ) { if(--B) { PC += (char)arg1; CYCLE -= 5; } }

#endif /*Z80_ASM*/

/****************************************************************************
 *	Call and Return Group
 ****************************************************************************/

#ifndef Z80_ASM

Z80FN_("CALL lm"       ,CALL_lm         ) { PUSH(PC); PC = arg12; }
Z80FN_("CALL Z,lm"     ,CALL_Z_lm       ) { if(  F & 0x40 ) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL NZ,lm"    ,CALL_NZ_lm      ) { if(!(F & 0x40)) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL C,lm"     ,CALL_C_lm       ) { if(  F &    1 ) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL NC,lm"    ,CALL_NC_lm      ) { if(!(F &    1)) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL PE,lm"    ,CALL_PE_lm      ) { if(  F &    4 ) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL PO,lm"    ,CALL_PO_lm      ) { if(!(F &    4)) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL M,lm"     ,CALL_M_lm       ) { if(  F & 0x80 ) { PUSH(PC); PC = arg12; CYCLE -= 7; } }
Z80FN_("CALL P,lm"     ,CALL_P_lm       ) { if(!(F & 0x80)) { PUSH(PC); PC = arg12; CYCLE -= 7; } }

Z80FN_("RET"           ,RET             ) { POP(PC); }
Z80FN_("RET Z"         ,RET_Z           ) { if(  F & 0x40 ) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET NZ"        ,RET_NZ          ) { if(!(F & 0x40)) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET C"         ,RET_C           ) { if(  F &    1 ) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET NC"        ,RET_NC          ) { if(!(F &    1)) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET PE"        ,RET_PE          ) { if(  F &    4 ) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET PO"        ,RET_PO          ) { if(!(F &    4)) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET M"         ,RET_M           ) { if(  F & 0x80 ) { POP(PC); CYCLE -= 6; } }
Z80FN_("RET P"         ,RET_P           ) { if(!(F & 0x80)) { POP(PC); CYCLE -= 6; } }

Z80FN_("RETI"          ,RETI            ) { POP(PC);              z80_check_pending(z80); } /* {EIRETI}̖ߕтRETIŕۗINTv󂯕t܂ */
Z80FN_("RETN"          ,RETN            ) { POP(PC); IFF1 = IFF2; z80_check_pending(z80); } /* IFF101֕ω\̂ŕۗINTv */

Z80FN_("RST 00H"       ,RST_00H         ) { PUSH(PC); PC = 0x00; }
Z80FN_("RST 08H"       ,RST_08H         ) { PUSH(PC); PC = 0x08; }
Z80FN_("RST 10H"       ,RST_10H         ) { PUSH(PC); PC = 0x10; }
Z80FN_("RST 18H"       ,RST_18H         ) { PUSH(PC); PC = 0x18; }
Z80FN_("RST 20H"       ,RST_20H         ) { PUSH(PC); PC = 0x20; }
Z80FN_("RST 28H"       ,RST_28H         ) { PUSH(PC); PC = 0x28; }
Z80FN_("RST 30H"       ,RST_30H         ) { PUSH(PC); PC = 0x30; }
Z80FN_("RST 38H"       ,RST_38H         ) { PUSH(PC); PC = 0x38; }

#endif /*Z80_ASM*/

/****************************************************************************
 *	Input and Output Group
 ****************************************************************************/

Z80FN_("IN A,(C)"      ,IN_A_ICI        ) { A = IN(BC); F = (A & 0xa8) | (!A << 6) | PARITY(A) | (F & 1); }
Z80FN_("IN B,(C)"      ,IN_B_ICI        ) { B = IN(BC); F = (B & 0xa8) | (!B << 6) | PARITY(B) | (F & 1); }
Z80FN_("IN C,(C)"      ,IN_C_ICI        ) { C = IN(BC); F = (C & 0xa8) | (!C << 6) | PARITY(C) | (F & 1); }
Z80FN_("IN D,(C)"      ,IN_D_ICI        ) { D = IN(BC); F = (D & 0xa8) | (!D << 6) | PARITY(D) | (F & 1); }
Z80FN_("IN E,(C)"      ,IN_E_ICI        ) { E = IN(BC); F = (E & 0xa8) | (!E << 6) | PARITY(E) | (F & 1); }
Z80FN_("IN H,(C)"      ,IN_H_ICI        ) { H = IN(BC); F = (H & 0xa8) | (!H << 6) | PARITY(H) | (F & 1); }
Z80FN_("IN L,(C)"      ,IN_L_ICI        ) { L = IN(BC); F = (L & 0xa8) | (!L << 6) | PARITY(L) | (F & 1); }
Z80FN_("IN A,(n)"      ,IN_A_InI        ) { A = IN(arg1 | A << 8); }

//Z80FN_("INI"           ,INI             ) { unsigned char tmp = IN(BC); WRITE(HL++, tmp); B--; F = (F & 0xbf) | (!B << 6); } /* tO͎b */
//2005/01/14 tOωύXBύXOAύXアbŁAł͂܂B
//Z80FN_("INI"           ,INI             ) { unsigned char tmp = IN(BC); WRITE(HL++, tmp); B--; F = (F & 1) | 2 | (!B << 6); } /* tO͎b */
//2005/01/16 tOωύXBύXOAύXアbŁAł͂܂B
Z80FN_("INI"           ,INI             ) { unsigned char tmp = IN(BC); WRITE(HL++, tmp); DEC8(B); } /* tO͎b */
Z80FN_("INIR"          ,INIR            ) { z80op_INI(z80, code, arg1, arg2); if(!(F & 0x40)) { PC -= 2; CYCLE -= 5; } }
//Z80FN_("IND"           ,IND             ) { unsigned char tmp = IN(BC); WRITE(HL--, tmp); B--; F = (F & 0xbf) | (!B << 6); } /* tO͎b */
//2005/01/14 tOωύXBύXOAύXアbŁAł͂܂B
//Z80FN_("IND"           ,IND             ) { unsigned char tmp = IN(BC); WRITE(HL--, tmp); B--; F = (F & 1) | 2 | (!B << 6); } /* tO͎b */
//2005/01/16 tOωύXBύXOAύXアbŁAł͂܂B
Z80FN_("IND"           ,IND             ) { unsigned char tmp = IN(BC); WRITE(HL--, tmp); DEC8(B); } /* tO͎b */
Z80FN_("INDR"          ,INDR            ) { z80op_IND(z80, code, arg1, arg2); if(!(F & 0x40)) { PC -= 2; CYCLE -= 5; } }

Z80FN_("OUT (C),A"     ,OUT_ICI_A       ) { OUT(BC, A); }
Z80FN_("OUT (C),B"     ,OUT_ICI_B       ) { OUT(BC, B); }
Z80FN_("OUT (C),C"     ,OUT_ICI_C       ) { OUT(BC, C); }
Z80FN_("OUT (C),D"     ,OUT_ICI_D       ) { OUT(BC, D); }
Z80FN_("OUT (C),E"     ,OUT_ICI_E       ) { OUT(BC, E); }
Z80FN_("OUT (C),H"     ,OUT_ICI_H       ) { OUT(BC, H); }
Z80FN_("OUT (C),L"     ,OUT_ICI_L       ) { OUT(BC, L); }
Z80FN_("OUT (n),A"     ,OUT_InI_A       ) { OUT(arg1 | A << 8, A); }

//Z80FN_("OUTI"          ,OUTI            ) { OUT(BC, READ(HL++)); B--; F = (F & 0xbf) | (!B << 6); } /* tO͎b */
//2005/01/14 tOωύXBύXOAύXアbŁAł͂܂B
//Z80FN_("OUTI"          ,OUTI            ) { OUT(BC, READ(HL++)); B--; F = (F & 1) | 2 | (!B << 6); } /* tO͎b */
//2005/01/16 tOωύXBύXOAύXアbŁAł͂܂B
Z80FN_("OUTI"          ,OUTI            ) { OUT(BC, READ(HL++)); DEC8(B); } /* tO͎b */
Z80FN_("OTIR"          ,OTIR            ) { z80op_OUTI(z80, code, arg1, arg2); if(!(F & 0x40)) { PC -= 2; CYCLE -= 5; } }
//Z80FN_("OUTD"          ,OUTD            ) { OUT(BC, READ(HL--)); B--; F = (F & 0xbf) | (!B << 6); } /* tO͎b */
//2005/01/14 tOωύXBύXOAύXアbŁAł͂܂B
//Z80FN_("OUTD"          ,OUTD            ) { OUT(BC, READ(HL--)); B--; F = (F & 1) | 2 | (!B << 6); } /* tO͎b */
//2005/01/16 tOωύXBύXOAύXアbŁAł͂܂B
Z80FN_("OUTD"          ,OUTD            ) { OUT(BC, READ(HL--)); DEC8(B); } /* tO͎b */
Z80FN_("OTDR"          ,OTDR            ) { z80op_OUTD(z80, code, arg1, arg2); if(!(F & 0x40)) { PC -= 2; CYCLE -= 5; } }

