;	
;	clipz80a.s
;
;	P/ECE Z80 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
;	- 쐬JnB
;	* Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;	- "JP cc"͏/sɂ炸ǉTCNłB
;	  ܂ŊԈ+7TCNĂ܂Ă̂C܂B
;	* Mon Jan 17 05:55:00 JST 2005 Naoyuki Sawa
;	- RETI,RETNɂāAz80_check_pending()ւ̈%r12=z80ݒ肵YĂ̂C܂B
;
;#include "clipz80a.h"
;/	
;/	clipz80a.h
;/
;/	P/ECE Z80 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2003 Naoyuki Sawa
;/
;/	* Fri Nov 28 06:00:00 JST 2003 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define Z80_ASM
;#ifdef Z80_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	Z80\ framz80a.sɂ`Ă!!
;
;===== WX^ =====
;#define F		 0
;#define A		 1
;#define C		 2
;#define B		 3
;#define E		 4
;#define D		 5
;#define L		 6
;#define H		 7
;#define AF		 0
;#define BC		 2
;#define DE		 4
;#define HL		 6
;#define AF2		 8
;#define BC2		10
;#define DE2		12
;#define HL2		14
;#define IXL		16
;#define IXH		17
;#define IYL		18
;#define IYH		19
;#define IX		16
;#define IY		18
;#define SP		20
;#define PC		22
;=====  =====
;#define IFF1		32
;#define IFF2		33
;#define IM		34
;#define HALT		35
;#define CYCLE		36
;{{2005/01/07 INTvۗΉ̂߂ɒǉ
;#define PENDING		40
;#define PENDING_NO	41
;}}2005/01/07 INTvۗΉ̂߂ɒǉ
;===== O֐ =====
;#define READ		48
;#define WRITE		52
;#define IN		56
;#define OUT		60

;****************************************************************************

;
;	Z80=>DMGtOϊ\
;
				; C33(C,V,Z,N) => Z80(S,Z,V,C)
	.global z80_FLAG_CONV	; ====C33====     ====Z80====
z80_FLAG_CONV:			; ----CVZN        SZ---V-C   
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x40		; 00000010 02     01000000 40
	.byte	0xc0		; 00000011 03     11000000 c0
	.byte	0x04		; 00000100 04     00000100 04
	.byte	0x84		; 00000101 05     10000100 84
	.byte	0x44		; 00000110 06     01000100 44
	.byte	0xc4		; 00000111 07     11000100 c4
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x41		; 00001010 0a     01000001 41
	.byte	0xc1		; 00001011 0b     11000001 c1
	.byte	0x05		; 00001100 0c     00000101 05
	.byte	0x85		; 00001101 0d     10000101 85
	.byte	0x45		; 00001110 0e     01000101 45
	.byte	0xc5		; 00001111 0f     11000101 c5

;****************************************************************************
;	8-Bit Load Group
;****************************************************************************

;#macro LD_r_IlmI $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r15			; lm
;	xsll %r13, 8
;	or %r13, %r14
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro LD_r_IrrI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	xld.uh %r13, [%r12+$2]		; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro LD_r_Irr_dI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	xld.uh %r13, [%r12+$2]		; rr+d
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r13, %r14
;	ld.uh %r13, %r13
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro LD_IlmI_r $1
;	xld.w %r10, [%r12+WRITE]
;	ld.w %r13, %r15			; lm
;	xsll %r13, 8
;	or %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call %r10
;	ret
;#endm

;#macro LD_IrrI_n $1
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]		; *anti-interlock*
;	call %r10
;	ret
;#endm

;#macro LD_IrrI_r $1, $2
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]
;	xld.ub %r14, [%r12+$2]
;	call %r10
;	ret
;#endm

;#macro LD_Irr_dI_n $1
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]		; rr+d
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r13, %r14
;	ld.uh %r13, %r13
;	call.d %r10
;	ld.w %r14, %r15			; *delay*
;	ret
;#endm

;#macro LD_Irr_dI_r $1, $2
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]		; rr+d
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r13, %r14
;	ld.uh %r13, %r13
;	xld.ub %r14, [%r12+$2]
;	call %r10
;	ret
;#endm

;****************************************************************************

	.global z80op_LD_A_IlmI
z80op_LD_A_IlmI:
	pushn %r0	; 	LD_r_IlmI A
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; lm
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global z80op_LD_A_IBCI
z80op_LD_A_IBCI:
	pushn %r0	; 	LD_r_IrrI A, BC
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.uh %r13, [%r12+0x2]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_A_IDEI
z80op_LD_A_IDEI:
	pushn %r0	; 	LD_r_IrrI A, DE
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.uh %r13, [%r12+0x4]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_A_IHLI
z80op_LD_A_IHLI:
	pushn %r0	; 	LD_r_IrrI A, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_B_IHLI
z80op_LD_B_IHLI:
	pushn %r0	; 	LD_r_IrrI B, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_C_IHLI
z80op_LD_C_IHLI:
	pushn %r0	; 	LD_r_IrrI C, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_D_IHLI
z80op_LD_D_IHLI:
	pushn %r0	; 	LD_r_IrrI D, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_E_IHLI
z80op_LD_E_IHLI:
	pushn %r0	; 	LD_r_IrrI E, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_H_IHLI
z80op_LD_H_IHLI:
	pushn %r0	; 	LD_r_IrrI H, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_L_IHLI
z80op_LD_L_IHLI:
	pushn %r0	; 	LD_r_IrrI L, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global z80op_LD_A_IIX_dI
z80op_LD_A_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI A, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_B_IIX_dI
z80op_LD_B_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI B, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_C_IIX_dI
z80op_LD_C_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI C, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_D_IIX_dI
z80op_LD_D_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI D, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_E_IIX_dI
z80op_LD_E_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI E, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_H_IIX_dI
z80op_LD_H_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI H, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_L_IIX_dI
z80op_LD_L_IIX_dI:
	pushn %r0	; 	LD_r_Irr_dI L, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_A_IIY_dI
z80op_LD_A_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI A, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_B_IIY_dI
z80op_LD_B_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI B, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_C_IIY_dI
z80op_LD_C_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI C, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_D_IIY_dI
z80op_LD_D_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI D, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_E_IIY_dI
z80op_LD_E_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI E, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_H_IIY_dI
z80op_LD_H_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI H, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_LD_L_IIY_dI
z80op_LD_L_IIY_dI:
	pushn %r0	; 	LD_r_Irr_dI L, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global z80op_LD_IlmI_A
z80op_LD_IlmI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IlmI_r A
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; lm
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r13, %r14
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret

	.global z80op_LD_IHLI_n
z80op_LD_IHLI_n:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_n HL
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call %r10
	ret

	.global z80op_LD_IBCI_A
z80op_LD_IBCI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r BC, A
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.uh %r13, [%r12+0x2]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IDEI_A
z80op_LD_IDEI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r DE, A
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.uh %r13, [%r12+0x4]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_A
z80op_LD_IHLI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, A
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_B
z80op_LD_IHLI_B:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, B
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_C
z80op_LD_IHLI_C:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, C
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_D
z80op_LD_IHLI_D:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, D
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_E
z80op_LD_IHLI_E:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, E
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_H
z80op_LD_IHLI_H:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, H
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IHLI_L
z80op_LD_IHLI_L:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_IrrI_r HL, L
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]
	ld.ub	%r14,[%r12]
	call %r10
	ret

	.global z80op_LD_IIX_dI_n
z80op_LD_IIX_dI_n:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_n IX
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r14, %r15			; *delay*
	ret
	.global z80op_LD_IIY_dI_n
z80op_LD_IIY_dI_n:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_n IY
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r14, %r15			; *delay*
	ret

	.global z80op_LD_IIX_dI_A
z80op_LD_IIX_dI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, A
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_B
z80op_LD_IIX_dI_B:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, B
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_C
z80op_LD_IIX_dI_C:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, C
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_D
z80op_LD_IIX_dI_D:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, D
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_E
z80op_LD_IIX_dI_E:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, E
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_H
z80op_LD_IIX_dI_H:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, H
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIX_dI_L
z80op_LD_IIX_dI_L:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IX, L
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_A
z80op_LD_IIY_dI_A:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, A
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_B
z80op_LD_IIY_dI_B:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, B
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_C
z80op_LD_IIY_dI_C:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, C
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_D
z80op_LD_IIY_dI_D:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, D
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_E
z80op_LD_IIY_dI_E:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, E
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_H
z80op_LD_IIY_dI_H:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, H
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global z80op_LD_IIY_dI_L
z80op_LD_IIY_dI_L:
	ext	0x34		; 	xld.w %r10, [%r12+0x34]	; 	LD_Irr_dI_r IY, L
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]		; rr+d
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]
	ld.ub	%r14,[%r12]
	call %r10
	ret

;****************************************************************************
;	16-Bit Load Group
;****************************************************************************

;#macro LD_rr_rr $1, $2
;	xld.uh %r10, [%r12+$2]
;	xld.h [%r12+$1], %r10
;	ret
;#endm

;#macro LD_rr_lm $1
;	xsll %r15, 8
;	or %r14, %r15
;	xld.h [%r12+$1], %r14
;	ret
;#endm

;#macro LD_rr_IlmI $1
;	pushn %r1
	;
;	ld.w %r1, %r15			; (lm+0)
;	xsll %r1, 8
;	or %r1, %r14
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+($1+0)], %r10	; LO
	;
;	xadd %r1, %r1, 1		; (lm+1)
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+($1+1)], %r10	; HI
	;
;	popn %r1
;	ret
;#endm

;#macro LD_IlmI_rr $1
;	pushn %r1
	;
;	ld.w %r1, %r15			; (lm+0)
;	xsll %r1, 8
;	or %r1, %r14
	;
;	xld.w %r10, [%r12+WRITE]
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+($1+0)]	; LO
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xadd %r1, %r1, 1		; (lm+1)
	;
;	xld.w %r10, [%r0+WRITE]
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+($1+1)]	; HI
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

;#macro POP_rr $1
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+($1+0)], %r10	; LO
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+($1+1)], %r10	; HI
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;#macro PUSH_rr $1
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+($1+1)]	; HI
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+($1+0)]	; LO
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************

	.global z80op_LD_SP_HL
z80op_LD_SP_HL:
	ext	0x6		; 	xld.uh %r10, [%r12+0x6]	; 	LD_rr_rr SP, HL
	ld.uh	%r10,[%r12]
	ext	0x14		; 	xld.h [%r12+0x14], %r10
	ld.h	[%r12],%r10
	ret
	.global z80op_LD_SP_IX
z80op_LD_SP_IX:
	ext	0x10		; 	xld.uh %r10, [%r12+0x10]	; 	LD_rr_rr SP, IX
	ld.uh	%r10,[%r12]
	ext	0x14		; 	xld.h [%r12+0x14], %r10
	ld.h	[%r12],%r10
	ret
	.global z80op_LD_SP_IY
z80op_LD_SP_IY:
	ext	0x12		; 	xld.uh %r10, [%r12+0x12]	; 	LD_rr_rr SP, IY
	ld.uh	%r10,[%r12]
	ext	0x14		; 	xld.h [%r12+0x14], %r10
	ld.h	[%r12],%r10
	ret

	.global z80op_LD_BC_lm
z80op_LD_BC_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm BC
	or %r14, %r15
	ext	0x2		; 	xld.h [%r12+0x2], %r14
	ld.h	[%r12],%r14
	ret
	.global z80op_LD_DE_lm
z80op_LD_DE_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm DE
	or %r14, %r15
	ext	0x4		; 	xld.h [%r12+0x4], %r14
	ld.h	[%r12],%r14
	ret
	.global z80op_LD_HL_lm
z80op_LD_HL_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm HL
	or %r14, %r15
	ext	0x6		; 	xld.h [%r12+0x6], %r14
	ld.h	[%r12],%r14
	ret
	.global z80op_LD_SP_lm
z80op_LD_SP_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm SP
	or %r14, %r15
	ext	0x14		; 	xld.h [%r12+0x14], %r14
	ld.h	[%r12],%r14
	ret
	.global z80op_LD_IX_lm
z80op_LD_IX_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm IX
	or %r14, %r15
	ext	0x10		; 	xld.h [%r12+0x10], %r14
	ld.h	[%r12],%r14
	ret
	.global z80op_LD_IY_lm
z80op_LD_IY_lm:
	sll	%r15,0x8	; 	xsll %r15, 8	; 	LD_rr_lm IY
	or %r14, %r15
	ext	0x12		; 	xld.h [%r12+0x12], %r14
	ld.h	[%r12],%r14
	ret

	.global z80op_LD_BC_IlmI
z80op_LD_BC_IlmI:
	pushn %r1	; 	LD_rr_IlmI BC
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_LD_DE_IlmI
z80op_LD_DE_IlmI:
	pushn %r1	; 	LD_rr_IlmI DE
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_LD_HL_IlmI
z80op_LD_HL_IlmI:
	pushn %r1	; 	LD_rr_IlmI HL
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_LD_SP_IlmI
z80op_LD_SP_IlmI:
	pushn %r1	; 	LD_rr_IlmI SP
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x14		; 	xld.b [%r0+0x14], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x15		; 	xld.b [%r0+0x15], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_LD_IX_IlmI
z80op_LD_IX_IlmI:
	pushn %r1	; 	LD_rr_IlmI IX
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_LD_IY_IlmI
z80op_LD_IY_IlmI:
	pushn %r1	; 	LD_rr_IlmI IY
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10	; LO
	ld.b	[%r0],%r10
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10	; HI
	ld.b	[%r0],%r10
	;
	popn %r1
	ret

	.global z80op_LD_IlmI_BC
z80op_LD_IlmI_BC:
	pushn %r1	; 	LD_IlmI_rr BC
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x3		; 	xld.ub %r14, [%r0+0x3]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_LD_IlmI_DE
z80op_LD_IlmI_DE:
	pushn %r1	; 	LD_IlmI_rr DE
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_LD_IlmI_HL
z80op_LD_IlmI_HL:
	pushn %r1	; 	LD_IlmI_rr HL
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_LD_IlmI_SP
z80op_LD_IlmI_SP:
	pushn %r1	; 	LD_IlmI_rr SP
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x14		; 	xld.ub %r14, [%r12+0x14]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x15		; 	xld.ub %r14, [%r0+0x15]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_LD_IlmI_IX
z80op_LD_IlmI_IX:
	pushn %r1	; 	LD_IlmI_rr IX
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x10		; 	xld.ub %r14, [%r12+0x10]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x11		; 	xld.ub %r14, [%r0+0x11]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_LD_IlmI_IY
z80op_LD_IlmI_IY:
	pushn %r1	; 	LD_IlmI_rr IY
	;
	ld.w %r1, %r15			; (lm+0)
	sll	%r1,0x8		; 	xsll %r1, 8
	or %r1, %r14
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ext	0x12		; 	xld.ub %r14, [%r12+0x12]	; LO
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; (lm+1)
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ext	0x13		; 	xld.ub %r14, [%r0+0x13]	; HI
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_POP_AF
z80op_POP_AF:
	pushn %r1	; 	POP_rr AF
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10	; LO
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_POP_BC
z80op_POP_BC:
	pushn %r1	; 	POP_rr BC
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_POP_DE
z80op_POP_DE:
	pushn %r1	; 	POP_rr DE
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_POP_HL
z80op_POP_HL:
	pushn %r1	; 	POP_rr HL
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_POP_IX
z80op_POP_IX:
	pushn %r1	; 	POP_rr IX
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_POP_IY
z80op_POP_IY:
	pushn %r1	; 	POP_rr IY
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret

	.global z80op_PUSH_AF
z80op_PUSH_AF:
	pushn %r1	; 	PUSH_rr AF
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ld.ub	%r14,[%r0]	; 	xld.ub %r14, [%r0+0x0]	; LO
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_PUSH_BC
z80op_PUSH_BC:
	pushn %r1	; 	PUSH_rr BC
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x2		; 	xld.ub %r14, [%r0+0x2]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_PUSH_DE
z80op_PUSH_DE:
	pushn %r1	; 	PUSH_rr DE
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x4		; 	xld.ub %r14, [%r0+0x4]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_PUSH_HL
z80op_PUSH_HL:
	pushn %r1	; 	PUSH_rr HL
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_PUSH_IX
z80op_PUSH_IX:
	pushn %r1	; 	PUSH_rr IX
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x11		; 	xld.ub %r14, [%r12+0x11]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x10		; 	xld.ub %r14, [%r0+0x10]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_PUSH_IY
z80op_PUSH_IY:
	pushn %r1	; 	PUSH_rr IY
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x13		; 	xld.ub %r14, [%r12+0x13]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x12		; 	xld.ub %r14, [%r0+0x12]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret

;****************************************************************************
;	8-Bit Arithmetic Group
;****************************************************************************

; BOP8 ... 8bit Binary Operation
; UOP8 ... 8bit Unary  Operation

;#macro BOP8_n $1
;	xcall.d z80_$1
;	ld.w %r13, %r14			; *delay*
;	ret
;#endm

;#macro BOP8_r $1, $2
;	xld.ub %r13, [%r12+$2]
;	xcall z80_$1
;	ret
;#endm

;#macro BOP8_IrrI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]		; (rr)
;	xld.uh %r13, [%r12+$2]		; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10			; A op (rr)
;	xcall.d z80_$1
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r0
;	ret
;#endm

;#macro BOP8_Irr_dI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]		; (rr+d)
;	xld.uh %r13, [%r12+$2]
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r13, %r14
;	ld.uh %r13, %r13
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10			; A op (rr+d)
;	xcall.d z80_$1
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r0
;	ret
;#endm

;#macro UOP8_r $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d z80_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro UOP8_IrrI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	xld.uh %r13, [%r12+$2]		; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d z80_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	xld.uh %r13, [%r0+$2]		; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r0
;	ret
;#endm

;#macro UOP8_Irr_dI $1, $2
;	pushn %r1
	;
;	xld.uh %r1, [%r12+$2]		; rr+d
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r1, %r14
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d z80_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************

	.global z80op_ADD_A_n
z80op_ADD_A_n:
	ext	z80_ADD8@rm	; 	xcall.d z80_ADD8	; 	BOP8_n ADD8
	call.d	z80_ADD8@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_ADD_A_A
z80op_ADD_A_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r ADD8, A
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_B
z80op_ADD_A_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r ADD8, B
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_C
z80op_ADD_A_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r ADD8, C
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_D
z80op_ADD_A_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r ADD8, D
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_E
z80op_ADD_A_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r ADD8, E
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_H
z80op_ADD_A_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r ADD8, H
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_L
z80op_ADD_A_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r ADD8, L
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_IXH
z80op_ADD_A_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r ADD8, IXH
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_IXL
z80op_ADD_A_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r ADD8, IXL
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_IYH
z80op_ADD_A_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r ADD8, IYH
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_IYL
z80op_ADD_A_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r ADD8, IYL
	ld.ub	%r13,[%r12]
	ext	z80_ADD8@rm	; 	xcall z80_ADD8
	call	z80_ADD8@rl
	ret
	.global z80op_ADD_A_IHLI
z80op_ADD_A_IHLI:
	pushn %r0	; 	BOP8_IrrI ADD8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_ADD8@rm	; 	xcall.d z80_ADD8
	call.d	z80_ADD8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_ADD_A_IIX_dI
z80op_ADD_A_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI ADD8, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_ADD8@rm	; 	xcall.d z80_ADD8
	call.d	z80_ADD8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_ADD_A_IIY_dI
z80op_ADD_A_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI ADD8, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_ADD8@rm	; 	xcall.d z80_ADD8
	call.d	z80_ADD8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_ADC_A_n
z80op_ADC_A_n:
	ext	z80_ADC8@rm	; 	xcall.d z80_ADC8	; 	BOP8_n ADC8
	call.d	z80_ADC8@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_ADC_A_A
z80op_ADC_A_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r ADC8, A
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_B
z80op_ADC_A_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r ADC8, B
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_C
z80op_ADC_A_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r ADC8, C
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_D
z80op_ADC_A_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r ADC8, D
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_E
z80op_ADC_A_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r ADC8, E
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_H
z80op_ADC_A_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r ADC8, H
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_L
z80op_ADC_A_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r ADC8, L
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_IXH
z80op_ADC_A_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r ADC8, IXH
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_IXL
z80op_ADC_A_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r ADC8, IXL
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_IYH
z80op_ADC_A_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r ADC8, IYH
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_IYL
z80op_ADC_A_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r ADC8, IYL
	ld.ub	%r13,[%r12]
	ext	z80_ADC8@rm	; 	xcall z80_ADC8
	call	z80_ADC8@rl
	ret
	.global z80op_ADC_A_IHLI
z80op_ADC_A_IHLI:
	pushn %r0	; 	BOP8_IrrI ADC8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_ADC8@rm	; 	xcall.d z80_ADC8
	call.d	z80_ADC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_ADC_A_IIX_dI
z80op_ADC_A_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI ADC8, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_ADC8@rm	; 	xcall.d z80_ADC8
	call.d	z80_ADC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_ADC_A_IIY_dI
z80op_ADC_A_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI ADC8, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_ADC8@rm	; 	xcall.d z80_ADC8
	call.d	z80_ADC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_SUB_n
z80op_SUB_n:
	ext	z80_SUB8@rm	; 	xcall.d z80_SUB8	; 	BOP8_n SUB8
	call.d	z80_SUB8@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_SUB_A
z80op_SUB_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r SUB8, A
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_B
z80op_SUB_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r SUB8, B
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_C
z80op_SUB_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r SUB8, C
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_D
z80op_SUB_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r SUB8, D
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_E
z80op_SUB_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r SUB8, E
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_H
z80op_SUB_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r SUB8, H
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_L
z80op_SUB_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r SUB8, L
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_IXH
z80op_SUB_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r SUB8, IXH
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_IXL
z80op_SUB_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r SUB8, IXL
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_IYH
z80op_SUB_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r SUB8, IYH
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_IYL
z80op_SUB_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r SUB8, IYL
	ld.ub	%r13,[%r12]
	ext	z80_SUB8@rm	; 	xcall z80_SUB8
	call	z80_SUB8@rl
	ret
	.global z80op_SUB_IHLI
z80op_SUB_IHLI:
	pushn %r0	; 	BOP8_IrrI SUB8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_SUB8@rm	; 	xcall.d z80_SUB8
	call.d	z80_SUB8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SUB_IIX_dI
z80op_SUB_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI SUB8, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_SUB8@rm	; 	xcall.d z80_SUB8
	call.d	z80_SUB8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SUB_IIY_dI
z80op_SUB_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI SUB8, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_SUB8@rm	; 	xcall.d z80_SUB8
	call.d	z80_SUB8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_SBC_A_n
z80op_SBC_A_n:
	ext	z80_SBC8@rm	; 	xcall.d z80_SBC8	; 	BOP8_n SBC8
	call.d	z80_SBC8@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_SBC_A_A
z80op_SBC_A_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r SBC8, A
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_B
z80op_SBC_A_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r SBC8, B
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_C
z80op_SBC_A_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r SBC8, C
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_D
z80op_SBC_A_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r SBC8, D
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_E
z80op_SBC_A_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r SBC8, E
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_H
z80op_SBC_A_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r SBC8, H
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_L
z80op_SBC_A_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r SBC8, L
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_IXH
z80op_SBC_A_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r SBC8, IXH
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_IXL
z80op_SBC_A_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r SBC8, IXL
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_IYH
z80op_SBC_A_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r SBC8, IYH
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_IYL
z80op_SBC_A_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r SBC8, IYL
	ld.ub	%r13,[%r12]
	ext	z80_SBC8@rm	; 	xcall z80_SBC8
	call	z80_SBC8@rl
	ret
	.global z80op_SBC_A_IHLI
z80op_SBC_A_IHLI:
	pushn %r0	; 	BOP8_IrrI SBC8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_SBC8@rm	; 	xcall.d z80_SBC8
	call.d	z80_SBC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SBC_A_IIX_dI
z80op_SBC_A_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI SBC8, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_SBC8@rm	; 	xcall.d z80_SBC8
	call.d	z80_SBC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SBC_A_IIY_dI
z80op_SBC_A_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI SBC8, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_SBC8@rm	; 	xcall.d z80_SBC8
	call.d	z80_SBC8@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_AND_n
z80op_AND_n:
	ext	z80_AND@rm	; 	xcall.d z80_AND	; 	BOP8_n AND
	call.d	z80_AND@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_AND_A
z80op_AND_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r AND, A
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_B
z80op_AND_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r AND, B
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_C
z80op_AND_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r AND, C
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_D
z80op_AND_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r AND, D
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_E
z80op_AND_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r AND, E
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_H
z80op_AND_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r AND, H
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_L
z80op_AND_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r AND, L
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_IXH
z80op_AND_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r AND, IXH
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_IXL
z80op_AND_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r AND, IXL
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_IYH
z80op_AND_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r AND, IYH
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_IYL
z80op_AND_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r AND, IYL
	ld.ub	%r13,[%r12]
	ext	z80_AND@rm	; 	xcall z80_AND
	call	z80_AND@rl
	ret
	.global z80op_AND_IHLI
z80op_AND_IHLI:
	pushn %r0	; 	BOP8_IrrI AND, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_AND@rm	; 	xcall.d z80_AND
	call.d	z80_AND@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_AND_IIX_dI
z80op_AND_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI AND, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_AND@rm	; 	xcall.d z80_AND
	call.d	z80_AND@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_AND_IIY_dI
z80op_AND_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI AND, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_AND@rm	; 	xcall.d z80_AND
	call.d	z80_AND@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_OR_n
z80op_OR_n:
	ext	z80_OR@rm	; 	xcall.d z80_OR	; 	BOP8_n OR
	call.d	z80_OR@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_OR_A
z80op_OR_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r OR, A
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_B
z80op_OR_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r OR, B
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_C
z80op_OR_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r OR, C
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_D
z80op_OR_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r OR, D
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_E
z80op_OR_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r OR, E
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_H
z80op_OR_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r OR, H
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_L
z80op_OR_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r OR, L
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_IXH
z80op_OR_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r OR, IXH
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_IXL
z80op_OR_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r OR, IXL
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_IYH
z80op_OR_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r OR, IYH
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_IYL
z80op_OR_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r OR, IYL
	ld.ub	%r13,[%r12]
	ext	z80_OR@rm	; 	xcall z80_OR
	call	z80_OR@rl
	ret
	.global z80op_OR_IHLI
z80op_OR_IHLI:
	pushn %r0	; 	BOP8_IrrI OR, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_OR@rm	; 	xcall.d z80_OR
	call.d	z80_OR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_OR_IIX_dI
z80op_OR_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI OR, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_OR@rm	; 	xcall.d z80_OR
	call.d	z80_OR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_OR_IIY_dI
z80op_OR_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI OR, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_OR@rm	; 	xcall.d z80_OR
	call.d	z80_OR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_XOR_n
z80op_XOR_n:
	ext	z80_XOR@rm	; 	xcall.d z80_XOR	; 	BOP8_n XOR
	call.d	z80_XOR@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_XOR_A
z80op_XOR_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r XOR, A
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_B
z80op_XOR_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r XOR, B
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_C
z80op_XOR_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r XOR, C
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_D
z80op_XOR_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r XOR, D
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_E
z80op_XOR_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r XOR, E
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_H
z80op_XOR_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r XOR, H
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_L
z80op_XOR_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r XOR, L
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_IXH
z80op_XOR_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r XOR, IXH
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_IXL
z80op_XOR_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r XOR, IXL
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_IYH
z80op_XOR_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r XOR, IYH
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_IYL
z80op_XOR_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r XOR, IYL
	ld.ub	%r13,[%r12]
	ext	z80_XOR@rm	; 	xcall z80_XOR
	call	z80_XOR@rl
	ret
	.global z80op_XOR_IHLI
z80op_XOR_IHLI:
	pushn %r0	; 	BOP8_IrrI XOR, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_XOR@rm	; 	xcall.d z80_XOR
	call.d	z80_XOR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_XOR_IIX_dI
z80op_XOR_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI XOR, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_XOR@rm	; 	xcall.d z80_XOR
	call.d	z80_XOR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_XOR_IIY_dI
z80op_XOR_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI XOR, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_XOR@rm	; 	xcall.d z80_XOR
	call.d	z80_XOR@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_CP_n
z80op_CP_n:
	ext	z80_CP@rm	; 	xcall.d z80_CP	; 	BOP8_n CP
	call.d	z80_CP@rl
	ld.w %r13, %r14			; *delay*
	ret
	.global z80op_CP_A
z80op_CP_A:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	BOP8_r CP, A
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_B
z80op_CP_B:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	BOP8_r CP, B
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_C
z80op_CP_C:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	BOP8_r CP, C
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_D
z80op_CP_D:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	BOP8_r CP, D
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_E
z80op_CP_E:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	BOP8_r CP, E
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_H
z80op_CP_H:
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]	; 	BOP8_r CP, H
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_L
z80op_CP_L:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	BOP8_r CP, L
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_IXH
z80op_CP_IXH:
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]	; 	BOP8_r CP, IXH
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_IXL
z80op_CP_IXL:
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]	; 	BOP8_r CP, IXL
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_IYH
z80op_CP_IYH:
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]	; 	BOP8_r CP, IYH
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_IYL
z80op_CP_IYL:
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]	; 	BOP8_r CP, IYL
	ld.ub	%r13,[%r12]
	ext	z80_CP@rm	; 	xcall z80_CP
	call	z80_CP@rl
	ret
	.global z80op_CP_IHLI
z80op_CP_IHLI:
	pushn %r0	; 	BOP8_IrrI CP, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	ext	z80_CP@rm	; 	xcall.d z80_CP
	call.d	z80_CP@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_CP_IIX_dI
z80op_CP_IIX_dI:
	pushn %r0	; 	BOP8_Irr_dI CP, IX
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x10		; 	xld.uh %r13, [%r12+0x10]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_CP@rm	; 	xcall.d z80_CP
	call.d	z80_CP@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_CP_IIY_dI
z80op_CP_IIY_dI:
	pushn %r0	; 	BOP8_Irr_dI CP, IY
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]		; (rr+d)
	ld.w	%r10,[%r12]
	ext	0x12		; 	xld.uh %r13, [%r12+0x12]
	ld.uh	%r13,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	ext	z80_CP@rm	; 	xcall.d z80_CP
	call.d	z80_CP@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

	.global z80op_INC_A
z80op_INC_A:
	pushn %r0	; 	UOP8_r INC8, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_B
z80op_INC_B:
	pushn %r0	; 	UOP8_r INC8, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_C
z80op_INC_C:
	pushn %r0	; 	UOP8_r INC8, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_D
z80op_INC_D:
	pushn %r0	; 	UOP8_r INC8, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_E
z80op_INC_E:
	pushn %r0	; 	UOP8_r INC8, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_H
z80op_INC_H:
	pushn %r0	; 	UOP8_r INC8, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_L
z80op_INC_L:
	pushn %r0	; 	UOP8_r INC8, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_IXH
z80op_INC_IXH:
	pushn %r0	; 	UOP8_r INC8, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_IXL
z80op_INC_IXL:
	pushn %r0	; 	UOP8_r INC8, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_IYH
z80op_INC_IYH:
	pushn %r0	; 	UOP8_r INC8, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_IYL
z80op_INC_IYL:
	pushn %r0	; 	UOP8_r INC8, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_INC_IHLI
z80op_INC_IHLI:
	pushn %r0	; 	UOP8_IrrI INC8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_INC_IIX_dI
z80op_INC_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI INC8, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_INC_IIY_dI
z80op_INC_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI INC8, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_INC8@rm	; 	xcall.d z80_INC8
	call.d	z80_INC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_DEC_A
z80op_DEC_A:
	pushn %r0	; 	UOP8_r DEC8, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_B
z80op_DEC_B:
	pushn %r0	; 	UOP8_r DEC8, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_C
z80op_DEC_C:
	pushn %r0	; 	UOP8_r DEC8, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_D
z80op_DEC_D:
	pushn %r0	; 	UOP8_r DEC8, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_E
z80op_DEC_E:
	pushn %r0	; 	UOP8_r DEC8, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_H
z80op_DEC_H:
	pushn %r0	; 	UOP8_r DEC8, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_L
z80op_DEC_L:
	pushn %r0	; 	UOP8_r DEC8, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_IXH
z80op_DEC_IXH:
	pushn %r0	; 	UOP8_r DEC8, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_IXL
z80op_DEC_IXL:
	pushn %r0	; 	UOP8_r DEC8, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_IYH
z80op_DEC_IYH:
	pushn %r0	; 	UOP8_r DEC8, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_IYL
z80op_DEC_IYL:
	pushn %r0	; 	UOP8_r DEC8, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_DEC_IHLI
z80op_DEC_IHLI:
	pushn %r0	; 	UOP8_IrrI DEC8, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_DEC_IIX_dI
z80op_DEC_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI DEC8, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_DEC_IIY_dI
z80op_DEC_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI DEC8, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_DEC8@rm	; 	xcall.d z80_DEC8
	call.d	z80_DEC8@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	16-Bit Arithmetic Group
;****************************************************************************

; BOP16 ... 16bit Binary Operation

;#macro BOP16_rr_rr $1, $2, $3
;	pushn %r0
	;
;	xld.uh %r13, [%r0+$2]
;	xld.uh %r14, [%r0+$3]
;	xcall.d z80_$1
;	ld.w %r0, %r12			; *delay*
;	xld.h [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

;****************************************************************************

	.global z80op_ADD_HL_BC
z80op_ADD_HL_BC:
	pushn %r0	; 	BOP16_rr_rr ADD16, HL, BC
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x2		; 	xld.uh %r14, [%r0+0x2]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_HL_DE
z80op_ADD_HL_DE:
	pushn %r0	; 	BOP16_rr_rr ADD16, HL, DE
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_HL_HL
z80op_ADD_HL_HL:
	pushn %r0	; 	BOP16_rr_rr ADD16, HL, HL
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_HL_SP
z80op_ADD_HL_SP:
	pushn %r0	; 	BOP16_rr_rr ADD16, HL, SP
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x14		; 	xld.uh %r14, [%r0+0x14]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IX_BC
z80op_ADD_IX_BC:
	pushn %r0	; 	BOP16_rr_rr ADD16, IX, BC
	;
	ext	0x10		; 	xld.uh %r13, [%r0+0x10]
	ld.uh	%r13,[%r0]
	ext	0x2		; 	xld.uh %r14, [%r0+0x2]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.h [%r0+0x10], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IX_DE
z80op_ADD_IX_DE:
	pushn %r0	; 	BOP16_rr_rr ADD16, IX, DE
	;
	ext	0x10		; 	xld.uh %r13, [%r0+0x10]
	ld.uh	%r13,[%r0]
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.h [%r0+0x10], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IX_IX
z80op_ADD_IX_IX:
	pushn %r0	; 	BOP16_rr_rr ADD16, IX, IX
	;
	ext	0x10		; 	xld.uh %r13, [%r0+0x10]
	ld.uh	%r13,[%r0]
	ext	0x10		; 	xld.uh %r14, [%r0+0x10]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.h [%r0+0x10], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IX_SP
z80op_ADD_IX_SP:
	pushn %r0	; 	BOP16_rr_rr ADD16, IX, SP
	;
	ext	0x10		; 	xld.uh %r13, [%r0+0x10]
	ld.uh	%r13,[%r0]
	ext	0x14		; 	xld.uh %r14, [%r0+0x14]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.h [%r0+0x10], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IY_BC
z80op_ADD_IY_BC:
	pushn %r0	; 	BOP16_rr_rr ADD16, IY, BC
	;
	ext	0x12		; 	xld.uh %r13, [%r0+0x12]
	ld.uh	%r13,[%r0]
	ext	0x2		; 	xld.uh %r14, [%r0+0x2]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.h [%r0+0x12], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IY_DE
z80op_ADD_IY_DE:
	pushn %r0	; 	BOP16_rr_rr ADD16, IY, DE
	;
	ext	0x12		; 	xld.uh %r13, [%r0+0x12]
	ld.uh	%r13,[%r0]
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.h [%r0+0x12], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IY_IY
z80op_ADD_IY_IY:
	pushn %r0	; 	BOP16_rr_rr ADD16, IY, IY
	;
	ext	0x12		; 	xld.uh %r13, [%r0+0x12]
	ld.uh	%r13,[%r0]
	ext	0x12		; 	xld.uh %r14, [%r0+0x12]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.h [%r0+0x12], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADD_IY_SP
z80op_ADD_IY_SP:
	pushn %r0	; 	BOP16_rr_rr ADD16, IY, SP
	;
	ext	0x12		; 	xld.uh %r13, [%r0+0x12]
	ld.uh	%r13,[%r0]
	ext	0x14		; 	xld.uh %r14, [%r0+0x14]
	ld.uh	%r14,[%r0]
	ext	z80_ADD16@rm	; 	xcall.d z80_ADD16
	call.d	z80_ADD16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.h [%r0+0x12], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret

	.global z80op_ADC_HL_BC
z80op_ADC_HL_BC:
	pushn %r0	; 	BOP16_rr_rr ADC16, HL, BC
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x2		; 	xld.uh %r14, [%r0+0x2]
	ld.uh	%r14,[%r0]
	ext	z80_ADC16@rm	; 	xcall.d z80_ADC16
	call.d	z80_ADC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADC_HL_DE
z80op_ADC_HL_DE:
	pushn %r0	; 	BOP16_rr_rr ADC16, HL, DE
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]
	ld.uh	%r14,[%r0]
	ext	z80_ADC16@rm	; 	xcall.d z80_ADC16
	call.d	z80_ADC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADC_HL_HL
z80op_ADC_HL_HL:
	pushn %r0	; 	BOP16_rr_rr ADC16, HL, HL
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	ext	z80_ADC16@rm	; 	xcall.d z80_ADC16
	call.d	z80_ADC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_ADC_HL_SP
z80op_ADC_HL_SP:
	pushn %r0	; 	BOP16_rr_rr ADC16, HL, SP
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x14		; 	xld.uh %r14, [%r0+0x14]
	ld.uh	%r14,[%r0]
	ext	z80_ADC16@rm	; 	xcall.d z80_ADC16
	call.d	z80_ADC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret

	.global z80op_SBC_HL_BC
z80op_SBC_HL_BC:
	pushn %r0	; 	BOP16_rr_rr SBC16, HL, BC
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x2		; 	xld.uh %r14, [%r0+0x2]
	ld.uh	%r14,[%r0]
	ext	z80_SBC16@rm	; 	xcall.d z80_SBC16
	call.d	z80_SBC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SBC_HL_DE
z80op_SBC_HL_DE:
	pushn %r0	; 	BOP16_rr_rr SBC16, HL, DE
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]
	ld.uh	%r14,[%r0]
	ext	z80_SBC16@rm	; 	xcall.d z80_SBC16
	call.d	z80_SBC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SBC_HL_HL
z80op_SBC_HL_HL:
	pushn %r0	; 	BOP16_rr_rr SBC16, HL, HL
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	ext	z80_SBC16@rm	; 	xcall.d z80_SBC16
	call.d	z80_SBC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SBC_HL_SP
z80op_SBC_HL_SP:
	pushn %r0	; 	BOP16_rr_rr SBC16, HL, SP
	;
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	0x14		; 	xld.uh %r14, [%r0+0x14]
	ld.uh	%r14,[%r0]
	ext	z80_SBC16@rm	; 	xcall.d z80_SBC16
	call.d	z80_SBC16@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	Rotate and Shift Group
;****************************************************************************

	.global z80op_RL_A
z80op_RL_A:
	pushn %r0	; 	UOP8_r RL, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_B
z80op_RL_B:
	pushn %r0	; 	UOP8_r RL, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_C
z80op_RL_C:
	pushn %r0	; 	UOP8_r RL, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_D
z80op_RL_D:
	pushn %r0	; 	UOP8_r RL, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_E
z80op_RL_E:
	pushn %r0	; 	UOP8_r RL, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_H
z80op_RL_H:
	pushn %r0	; 	UOP8_r RL, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_L
z80op_RL_L:
	pushn %r0	; 	UOP8_r RL, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_IXH
z80op_RL_IXH:
	pushn %r0	; 	UOP8_r RL, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_IXL
z80op_RL_IXL:
	pushn %r0	; 	UOP8_r RL, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_IYH
z80op_RL_IYH:
	pushn %r0	; 	UOP8_r RL, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_IYL
z80op_RL_IYL:
	pushn %r0	; 	UOP8_r RL, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RL_IHLI
z80op_RL_IHLI:
	pushn %r0	; 	UOP8_IrrI RL, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_RL_IIX_dI
z80op_RL_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI RL, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_RL_IIY_dI
z80op_RL_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI RL, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RL@rm	; 	xcall.d z80_RL
	call.d	z80_RL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_RLC_A
z80op_RLC_A:
	pushn %r0	; 	UOP8_r RLC, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_B
z80op_RLC_B:
	pushn %r0	; 	UOP8_r RLC, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_C
z80op_RLC_C:
	pushn %r0	; 	UOP8_r RLC, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_D
z80op_RLC_D:
	pushn %r0	; 	UOP8_r RLC, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_E
z80op_RLC_E:
	pushn %r0	; 	UOP8_r RLC, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_H
z80op_RLC_H:
	pushn %r0	; 	UOP8_r RLC, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_L
z80op_RLC_L:
	pushn %r0	; 	UOP8_r RLC, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_IXH
z80op_RLC_IXH:
	pushn %r0	; 	UOP8_r RLC, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_IXL
z80op_RLC_IXL:
	pushn %r0	; 	UOP8_r RLC, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_IYH
z80op_RLC_IYH:
	pushn %r0	; 	UOP8_r RLC, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_IYL
z80op_RLC_IYL:
	pushn %r0	; 	UOP8_r RLC, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RLC_IHLI
z80op_RLC_IHLI:
	pushn %r0	; 	UOP8_IrrI RLC, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_RLC_IIX_dI
z80op_RLC_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI RLC, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_RLC_IIY_dI
z80op_RLC_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI RLC, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RLC@rm	; 	xcall.d z80_RLC
	call.d	z80_RLC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_RR_A
z80op_RR_A:
	pushn %r0	; 	UOP8_r RR, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_B
z80op_RR_B:
	pushn %r0	; 	UOP8_r RR, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_C
z80op_RR_C:
	pushn %r0	; 	UOP8_r RR, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_D
z80op_RR_D:
	pushn %r0	; 	UOP8_r RR, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_E
z80op_RR_E:
	pushn %r0	; 	UOP8_r RR, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_H
z80op_RR_H:
	pushn %r0	; 	UOP8_r RR, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_L
z80op_RR_L:
	pushn %r0	; 	UOP8_r RR, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_IXH
z80op_RR_IXH:
	pushn %r0	; 	UOP8_r RR, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_IXL
z80op_RR_IXL:
	pushn %r0	; 	UOP8_r RR, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_IYH
z80op_RR_IYH:
	pushn %r0	; 	UOP8_r RR, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_IYL
z80op_RR_IYL:
	pushn %r0	; 	UOP8_r RR, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RR_IHLI
z80op_RR_IHLI:
	pushn %r0	; 	UOP8_IrrI RR, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_RR_IIX_dI
z80op_RR_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI RR, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_RR_IIY_dI
z80op_RR_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI RR, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RR@rm	; 	xcall.d z80_RR
	call.d	z80_RR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_RRC_A
z80op_RRC_A:
	pushn %r0	; 	UOP8_r RRC, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_B
z80op_RRC_B:
	pushn %r0	; 	UOP8_r RRC, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_C
z80op_RRC_C:
	pushn %r0	; 	UOP8_r RRC, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_D
z80op_RRC_D:
	pushn %r0	; 	UOP8_r RRC, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_E
z80op_RRC_E:
	pushn %r0	; 	UOP8_r RRC, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_H
z80op_RRC_H:
	pushn %r0	; 	UOP8_r RRC, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_L
z80op_RRC_L:
	pushn %r0	; 	UOP8_r RRC, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_IXH
z80op_RRC_IXH:
	pushn %r0	; 	UOP8_r RRC, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_IXL
z80op_RRC_IXL:
	pushn %r0	; 	UOP8_r RRC, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_IYH
z80op_RRC_IYH:
	pushn %r0	; 	UOP8_r RRC, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_IYL
z80op_RRC_IYL:
	pushn %r0	; 	UOP8_r RRC, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_RRC_IHLI
z80op_RRC_IHLI:
	pushn %r0	; 	UOP8_IrrI RRC, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_RRC_IIX_dI
z80op_RRC_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI RRC, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_RRC_IIY_dI
z80op_RRC_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI RRC, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_RRC@rm	; 	xcall.d z80_RRC
	call.d	z80_RRC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_SLA_A
z80op_SLA_A:
	pushn %r0	; 	UOP8_r SLA, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_B
z80op_SLA_B:
	pushn %r0	; 	UOP8_r SLA, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_C
z80op_SLA_C:
	pushn %r0	; 	UOP8_r SLA, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_D
z80op_SLA_D:
	pushn %r0	; 	UOP8_r SLA, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_E
z80op_SLA_E:
	pushn %r0	; 	UOP8_r SLA, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_H
z80op_SLA_H:
	pushn %r0	; 	UOP8_r SLA, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_L
z80op_SLA_L:
	pushn %r0	; 	UOP8_r SLA, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_IXH
z80op_SLA_IXH:
	pushn %r0	; 	UOP8_r SLA, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_IXL
z80op_SLA_IXL:
	pushn %r0	; 	UOP8_r SLA, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_IYH
z80op_SLA_IYH:
	pushn %r0	; 	UOP8_r SLA, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_IYL
z80op_SLA_IYL:
	pushn %r0	; 	UOP8_r SLA, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SLA_IHLI
z80op_SLA_IHLI:
	pushn %r0	; 	UOP8_IrrI SLA, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SLA_IIX_dI
z80op_SLA_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI SLA, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_SLA_IIY_dI
z80op_SLA_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI SLA, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SLA@rm	; 	xcall.d z80_SLA
	call.d	z80_SLA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_SRA_A
z80op_SRA_A:
	pushn %r0	; 	UOP8_r SRA, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_B
z80op_SRA_B:
	pushn %r0	; 	UOP8_r SRA, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_C
z80op_SRA_C:
	pushn %r0	; 	UOP8_r SRA, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_D
z80op_SRA_D:
	pushn %r0	; 	UOP8_r SRA, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_E
z80op_SRA_E:
	pushn %r0	; 	UOP8_r SRA, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_H
z80op_SRA_H:
	pushn %r0	; 	UOP8_r SRA, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_L
z80op_SRA_L:
	pushn %r0	; 	UOP8_r SRA, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_IXH
z80op_SRA_IXH:
	pushn %r0	; 	UOP8_r SRA, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_IXL
z80op_SRA_IXL:
	pushn %r0	; 	UOP8_r SRA, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_IYH
z80op_SRA_IYH:
	pushn %r0	; 	UOP8_r SRA, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_IYL
z80op_SRA_IYL:
	pushn %r0	; 	UOP8_r SRA, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRA_IHLI
z80op_SRA_IHLI:
	pushn %r0	; 	UOP8_IrrI SRA, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SRA_IIX_dI
z80op_SRA_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI SRA, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_SRA_IIY_dI
z80op_SRA_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI SRA, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRA@rm	; 	xcall.d z80_SRA
	call.d	z80_SRA@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_SRL_A
z80op_SRL_A:
	pushn %r0	; 	UOP8_r SRL, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_B
z80op_SRL_B:
	pushn %r0	; 	UOP8_r SRL, B
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_C
z80op_SRL_C:
	pushn %r0	; 	UOP8_r SRL, C
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_D
z80op_SRL_D:
	pushn %r0	; 	UOP8_r SRL, D
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_E
z80op_SRL_E:
	pushn %r0	; 	UOP8_r SRL, E
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_H
z80op_SRL_H:
	pushn %r0	; 	UOP8_r SRL, H
	;
	ext	0x7		; 	xld.ub %r13, [%r12+0x7]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_L
z80op_SRL_L:
	pushn %r0	; 	UOP8_r SRL, L
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_IXH
z80op_SRL_IXH:
	pushn %r0	; 	UOP8_r SRL, IXH
	;
	ext	0x11		; 	xld.ub %r13, [%r12+0x11]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x11		; 	xld.b [%r0+0x11], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_IXL
z80op_SRL_IXL:
	pushn %r0	; 	UOP8_r SRL, IXL
	;
	ext	0x10		; 	xld.ub %r13, [%r12+0x10]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x10		; 	xld.b [%r0+0x10], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_IYH
z80op_SRL_IYH:
	pushn %r0	; 	UOP8_r SRL, IYH
	;
	ext	0x13		; 	xld.ub %r13, [%r12+0x13]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x13		; 	xld.b [%r0+0x13], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_IYL
z80op_SRL_IYL:
	pushn %r0	; 	UOP8_r SRL, IYL
	;
	ext	0x12		; 	xld.ub %r13, [%r12+0x12]
	ld.ub	%r13,[%r12]
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x12		; 	xld.b [%r0+0x12], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global z80op_SRL_IHLI
z80op_SRL_IHLI:
	pushn %r0	; 	UOP8_IrrI SRL, HL
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
	.global z80op_SRL_IIX_dI
z80op_SRL_IIX_dI:
	pushn %r1	; 	UOP8_Irr_dI SRL, IX
	;
	ext	0x10		; 	xld.uh %r1, [%r12+0x10]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_SRL_IIY_dI
z80op_SRL_IIY_dI:
	pushn %r1	; 	UOP8_Irr_dI SRL, IY
	;
	ext	0x12		; 	xld.uh %r1, [%r12+0x12]		; rr+d
	ld.uh	%r1,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	z80_SRL@rm	; 	xcall.d z80_SRL
	call.d	z80_SRL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	Jump Group
;****************************************************************************

;#macro JP_lm
;	xsll %r15, 8			; lm
;	or %r14, %r15
;	xld.h [%r12+PC], %r14		; PC
;	ret
;#endm

;;#macro JP_cc_lm $1
;;	xbtst [%r12+F], $1
;;	xjreq $$1
;;	;
;;	xsll %r15, 8			; lm
;;	or %r14, %r15
;;	;
;;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 7
;;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;;	xsub %r10, %r10, 7
;;	xld.w [%r12+CYCLE], %r10
;;$$1:
;;	ret
;;#endm
;; * Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;; - "JP cc"͏/sɂ炸ǉTCNłB
;;   ܂ŊԈ+7TCNĂ܂Ă̂C܂B
;#macro JP_cc_lm $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	xsll %r15, 8			; lm
;	or %r14, %r15
	;
;	xld.h [%r12+PC], %r14		; PC
;$$1:
;	ret
;#endm

;;#macro JP_Ncc_lm $1
;;	xbtst [%r12+F], $1
;;	xjrne $$1
;;	;
;;	xsll %r15, 8			; lm
;;	or %r14, %r15
;;	;
;;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 7
;;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;;	xsub %r10, %r10, 7
;;	xld.w [%r12+CYCLE], %r10
;;$$1:
;;	ret
;;#endm
;; * Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;; - "JP cc"͏/sɂ炸ǉTCNłB
;;   ܂ŊԈ+7TCNĂ܂Ă̂C܂B
;#macro JP_Ncc_lm $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	xsll %r15, 8			; lm
;	or %r14, %r15
	;
;	xld.h [%r12+PC], %r14		; PC
;$$1:
;	ret
;#endm

;#macro JR_e
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
;	xld.h [%r12+PC], %r14		; PC
;	ret
;#endm

;#macro JR_c_e $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 5
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro JR_Nc_e $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 5
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro DJNZ_e
;	xld.ub %r10, [%r12+B]		; --B
;	xsub %r10, %r10, 1
;	xld.b [%r12+B], %r10
;	xjreq $$1
	;
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 5
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;****************************************************************************

	.global z80op_JP_lm
z80op_JP_lm:
	sll	%r15,0x8	; 	xsll %r15, 8			; lm	; 	JP_lm
	or %r14, %r15
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
	ret
	.global z80op_JP_Z_lm
z80op_JP_Z_lm:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	JP_cc_lm 6
	jreq	__LX0001	; 	xjreq __L0001
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0001:				; __L0001:
	ret
	.global z80op_JP_NZ_lm
z80op_JP_NZ_lm:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	JP_Ncc_lm 6
	jrne	__LX0002	; 	xjrne __L0002
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0002:				; __L0002:
	ret
	.global z80op_JP_C_lm
z80op_JP_C_lm:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	JP_cc_lm 0
	jreq	__LX0003	; 	xjreq __L0003
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0003:				; __L0003:
	ret
	.global z80op_JP_NC_lm
z80op_JP_NC_lm:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	JP_Ncc_lm 0
	jrne	__LX0004	; 	xjrne __L0004
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0004:				; __L0004:
	ret
	.global z80op_JP_PE_lm
z80op_JP_PE_lm:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	JP_cc_lm 2
	jreq	__LX0005	; 	xjreq __L0005
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0005:				; __L0005:
	ret
	.global z80op_JP_PO_lm
z80op_JP_PO_lm:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	JP_Ncc_lm 2
	jrne	__LX0006	; 	xjrne __L0006
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0006:				; __L0006:
	ret
	.global z80op_JP_M_lm
z80op_JP_M_lm:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JP_cc_lm 7
	jreq	__LX0007	; 	xjreq __L0007
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0007:				; __L0007:
	ret
	.global z80op_JP_P_lm
z80op_JP_P_lm:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JP_Ncc_lm 7
	jrne	__LX0008	; 	xjrne __L0008
	;
	sll	%r15,0x8	; 	xsll %r15, 8			; lm
	or %r14, %r15
	;
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
__LX0008:				; __L0008:
	ret

	.global z80op_JR_e
z80op_JR_e:
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e	; 	JR_e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC
	ld.h	[%r12],%r14
	ret
	.global z80op_JR_Z_e
z80op_JR_Z_e:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	JR_c_e 6
	jreq	__LX0009	; 	xjreq __L0009
	;
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x24		; 	xld.w %r10, [%r12+0x24]	; CYCLE -= 5
	ld.w	%r10,[%r12]
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x5	; 	xsub %r10, %r10, 5
	ext	0x24		; 	xld.w [%r12+0x24], %r10
	ld.w	[%r12],%r10
__LX0009:				; __L0009:
	ret
	.global z80op_JR_NZ_e
z80op_JR_NZ_e:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	JR_Nc_e 6
	jrne	__LX0010	; 	xjrne __L0010
	;
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x24		; 	xld.w %r10, [%r12+0x24]	; CYCLE -= 5
	ld.w	%r10,[%r12]
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x5	; 	xsub %r10, %r10, 5
	ext	0x24		; 	xld.w [%r12+0x24], %r10
	ld.w	[%r12],%r10
__LX0010:				; __L0010:
	ret
	.global z80op_JR_C_e
z80op_JR_C_e:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	JR_c_e 0
	jreq	__LX0011	; 	xjreq __L0011
	;
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x24		; 	xld.w %r10, [%r12+0x24]	; CYCLE -= 5
	ld.w	%r10,[%r12]
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x5	; 	xsub %r10, %r10, 5
	ext	0x24		; 	xld.w [%r12+0x24], %r10
	ld.w	[%r12],%r10
__LX0011:				; __L0011:
	ret
	.global z80op_JR_NC_e
z80op_JR_NC_e:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	JR_Nc_e 0
	jrne	__LX0012	; 	xjrne __L0012
	;
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x24		; 	xld.w %r10, [%r12+0x24]	; CYCLE -= 5
	ld.w	%r10,[%r12]
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x5	; 	xsub %r10, %r10, 5
	ext	0x24		; 	xld.w [%r12+0x24], %r10
	ld.w	[%r12],%r10
__LX0012:				; __L0012:
	ret

	.global z80op_DJNZ_e
z80op_DJNZ_e:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]		; --B	; 	DJNZ_e
	ld.ub	%r10,[%r12]
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	jreq	__LX0013	; 	xjreq __L0013
	;
	ext	0x16		; 	xld.uh %r10, [%r12+0x16]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x24		; 	xld.w %r10, [%r12+0x24]	; CYCLE -= 5
	ld.w	%r10,[%r12]
	ext	0x16		; 	xld.h [%r12+0x16], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x5	; 	xsub %r10, %r10, 5
	ext	0x24		; 	xld.w [%r12+0x24], %r10
	ld.w	[%r12],%r10
__LX0013:				; __L0013:
	ret

;****************************************************************************
;	Call and Return Group
;****************************************************************************

;#macro CALL_lm
;	pushn %r2
	;
;	ld.w %r2, %r15			; lm
;	xsll %r2, 8
;	or %r2, %r14
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.h [%r0+PC], %r2		; PC
	;
;	popn %r2
;	ret
;#endm

;#macro CALL_c_lm $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	pushn %r2
	;
;	ld.w %r2, %r15			; lm
;	xsll %r2, 8
;	or %r2, %r14
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 7
;	xld.h [%r0+PC], %r2		; PC *anti-interlock*
;	xsub %r10, %r10, 7
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r2
;$$1:
;	ret
;#endm

;#macro CALL_Nc_lm $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	pushn %r2
	;
;	ld.w %r2, %r15			; lm
;	xsll %r2, 8
;	or %r2, %r14
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 7
;	xld.h [%r0+PC], %r2		; PC *anti-interlock*
;	xsub %r10, %r10, 7
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r2
;$$1:
;	ret
;#endm

;#macro RET
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;#macro RET_c $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 6
;	xld.h [%r0+SP], %r1		; SP *anti-interlock*
;	xsub %r10, %r10, 6
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r1
;$$1:
;	ret
;#endm

;#macro RET_Nc $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 6
;	xld.h [%r0+SP], %r1		; SP *anti-interlock*
;	xsub %r10, %r10, 6
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r1
;$$1:
;	ret
;#endm

;#macro RETI
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xcall.d z80_check_pending	; {EIRETI}̖ߕтRETIŕۗINTv󂯕t܂
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

;#macro RETN
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.ub %r10, [%r0+IFF2]		; IFF1 = IFF2
;	xld.h [%r0+SP], %r1		; SP *anti-interlock*
;	xld.b [%r0+IFF1], %r10
	;
;	xcall.d z80_check_pending	; IFF101֕ω\̂ŕۗINTv
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

;#macro RST_n $1
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.w %r10, $1			; PC
;	xld.h [%r0+PC], %r10
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************

	.global z80op_CALL_lm
z80op_CALL_lm:
	pushn %r2	; 	CALL_lm
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC
	ld.h	[%r0],%r2
	;
	popn %r2
	ret
	.global z80op_CALL_Z_lm
z80op_CALL_Z_lm:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	CALL_c_lm 6
	jreq	__LX0014	; 	xjreq __L0014
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0014:				; __L0014:
	ret
	.global z80op_CALL_NZ_lm
z80op_CALL_NZ_lm:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	CALL_Nc_lm 6
	jrne	__LX0015	; 	xjrne __L0015
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0015:				; __L0015:
	ret
	.global z80op_CALL_C_lm
z80op_CALL_C_lm:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	CALL_c_lm 0
	jreq	__LX0016	; 	xjreq __L0016
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0016:				; __L0016:
	ret
	.global z80op_CALL_NC_lm
z80op_CALL_NC_lm:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	CALL_Nc_lm 0
	jrne	__LX0017	; 	xjrne __L0017
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0017:				; __L0017:
	ret
	.global z80op_CALL_PE_lm
z80op_CALL_PE_lm:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	CALL_c_lm 2
	jreq	__LX0018	; 	xjreq __L0018
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0018:				; __L0018:
	ret
	.global z80op_CALL_PO_lm
z80op_CALL_PO_lm:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	CALL_Nc_lm 2
	jrne	__LX0019	; 	xjrne __L0019
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0019:				; __L0019:
	ret
	.global z80op_CALL_M_lm
z80op_CALL_M_lm:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	CALL_c_lm 7
	jreq	__LX0020	; 	xjreq __L0020
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0020:				; __L0020:
	ret
	.global z80op_CALL_P_lm
z80op_CALL_P_lm:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	CALL_Nc_lm 7
	jrne	__LX0021	; 	xjrne __L0021
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	sll	%r2,0x8		; 	xsll %r2, 8
	or %r2, %r14
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 7
	ld.w	%r10,[%r0]
	ext	0x16		; 	xld.h [%r0+0x16], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0x7	; 	xsub %r10, %r10, 7
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0021:				; __L0021:
	ret

	.global z80op_RET
z80op_RET:
	pushn %r1	; 	RET
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global z80op_RET_Z
z80op_RET_Z:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	RET_c 6
	jreq	__LX0022	; 	xjreq __L0022
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0022:				; __L0022:
	ret
	.global z80op_RET_NZ
z80op_RET_NZ:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	RET_Nc 6
	jrne	__LX0023	; 	xjrne __L0023
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0023:				; __L0023:
	ret
	.global z80op_RET_C
z80op_RET_C:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	RET_c 0
	jreq	__LX0024	; 	xjreq __L0024
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0024:				; __L0024:
	ret
	.global z80op_RET_NC
z80op_RET_NC:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	RET_Nc 0
	jrne	__LX0025	; 	xjrne __L0025
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0025:				; __L0025:
	ret
	.global z80op_RET_PE
z80op_RET_PE:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	RET_c 2
	jreq	__LX0026	; 	xjreq __L0026
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0026:				; __L0026:
	ret
	.global z80op_RET_PO
z80op_RET_PO:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	RET_Nc 2
	jrne	__LX0027	; 	xjrne __L0027
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0027:				; __L0027:
	ret
	.global z80op_RET_M
z80op_RET_M:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	RET_c 7
	jreq	__LX0028	; 	xjreq __L0028
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0028:				; __L0028:
	ret
	.global z80op_RET_P
z80op_RET_P:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	RET_Nc 7
	jrne	__LX0029	; 	xjrne __L0029
	;
	pushn %r1
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= 6
	ld.w	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0x6	; 	xsub %r10, %r10, 6
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0029:				; __L0029:
	ret

	.global z80op_RETI
z80op_RETI:
	pushn %r1	; 	RETI
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	z80_check_pending@rm	; 	xcall.d z80_check_pending	; {EIRETI}̖ߕтRETIŕۗINTv󂯕t܂
	call.d	z80_check_pending@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global z80op_RETN
z80op_RETN:
	pushn %r1	; 	RETN
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x30		; 	xld.w %r10, [%r12+0x30]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x16		; 	xld.b [%r0+0x16], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x30		; 	xld.w %r10, [%r0+0x30]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x17		; 	xld.b [%r0+0x17], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x21		; 	xld.ub %r10, [%r0+0x21]		; IFF1 = IFF2
	ld.ub	%r10,[%r0]
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	ext	0x20		; 	xld.b [%r0+0x20], %r10
	ld.b	[%r0],%r10
	;
	ext	z80_check_pending@rm	; 	xcall.d z80_check_pending	; IFF101֕ω\̂ŕۗINTv
	call.d	z80_check_pending@rl
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global z80op_RST_00H
z80op_RST_00H:
	pushn %r1	; 	RST_n 0x00
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ld.w	%r10,0x0	; 	xld.w %r10, 0x00			; PC
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_08H
z80op_RST_08H:
	pushn %r1	; 	RST_n 0x08
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ld.w	%r10,0x8	; 	xld.w %r10, 0x08			; PC
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_10H
z80op_RST_10H:
	pushn %r1	; 	RST_n 0x10
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ld.w	%r10,0x10	; 	xld.w %r10, 0x10			; PC
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_18H
z80op_RST_18H:
	pushn %r1	; 	RST_n 0x18
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ld.w	%r10,0x18	; 	xld.w %r10, 0x18			; PC
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_20H
z80op_RST_20H:
	pushn %r1	; 	RST_n 0x20
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x0		; 	xld.w %r10, 0x20			; PC
	ld.w	%r10,0x20
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_28H
z80op_RST_28H:
	pushn %r1	; 	RST_n 0x28
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x0		; 	xld.w %r10, 0x28			; PC
	ld.w	%r10,0x28
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_30H
z80op_RST_30H:
	pushn %r1	; 	RST_n 0x30
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x0		; 	xld.w %r10, 0x30			; PC
	ld.w	%r10,0x30
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret
	.global z80op_RST_38H
z80op_RST_38H:
	pushn %r1	; 	RST_n 0x38
	;
	ext	0x14		; 	xld.uh %r1, [%r12+0x14]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x34		; 	xld.w %r10, [%r12+0x34]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x17		; 	xld.ub %r14, [%r12+0x17]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x34		; 	xld.w %r10, [%r0+0x34]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x16		; 	xld.ub %r14, [%r0+0x16]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.h [%r0+0x14], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x0		; 	xld.w %r10, 0x38			; PC
	ld.w	%r10,0x38
	ext	0x16		; 	xld.h [%r0+0x16], %r10
	ld.h	[%r0],%r10
	;
	popn %r1
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*Z80_ASM*/
