/*	
 *	clipwire.c
 *
 *	C[t[``܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Dec 21 04:30:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu Dec 23 09:08:00 JST 2004 Naoyuki Sawa
 *	- ZNbsÕoOC܂B
 *	  (fcomYĂ̂܂ܔrĂāArɂȂĂ܂Ă܂)
 *	* Sun Dec 26 16:10:00 JST 2004 Naoyuki Sawa
 *	- render_line_3d()ǉ܂B
 *	* Wed Jul 05 03:16:43 JST 2006 Naoyuki Sawa
 *	- render_line_3d()̈^ύX܂B
 *	  ܂ŁAn_EI_(x,y,z)WׂăoňnĂ̂ύXA
 *	  n_xNgƏI_xNgւconst|C^ɂĈn悤ύX܂B
 *	  ̕ύXɂA̐4Ɏ܂AׂăWX^nƂȂāA܂B
 *	- 2006/07/05݁A{CuɂāA(const vector*)^̈ĝ͏߂ĂłB
 *	  ܂ł́AύXÔ悤ɁAxNg(x,y,z)WׂăoňnA
 *	  ܂́AxNg̒lnƂĂ܂B(ɁAclipfixW[QƂĂ)
 *	  ̕ύX́ACuŜ猩ƂⓝꐫɌ܂AOq̗_ƁA
 *	  ύXO̎dlł͈ČڂɂhƂlAύX肵܂B
 *	  {֐𗘗pĂvÓA܂قƂǖ̂ŁAύX̉e͏Ǝv܂B
 */
#include "clip.h"

void
render_wire(RENDER* render, const WIRE* wire, int color)
{
	/* ϊςݒ_Wobt@_def_vbuff[]Ɋmۂ܂B */
#define NV_MAX (sizeof _def_vbuff / sizeof(vector)) /* 128~8812=938 */
	vector* xv = (vector*)_def_vbuff/*[NV_MAX]*/;
	//
	int i;
	int nv;
	int ns;
	int iv;
	fixed f;
	fixed b;
	const vector* v;
	const WSEG* s;
	vector v0;
	vector v1;
	matrix m;

	/* _WXgAZOgXg擾܂B */
	nv = wire->nv;
	if((nv < 0) || (nv > NV_MAX)) {
		DIE(); /* _Ws */
	}
	ns = wire->ns;
	if(ns < 0) {
		DIE(); /* ZOgs */
	}
	v = (const vector*)(wire + 1);
	s = (const WSEG*)(v + nv);

	/* 炩߁ASĂ̒_WϊĂ܂B */
	m = render->context->matrix;
	for(i = 0;
	    i < nv;
	    i++, v++, xv++) {
		*xv = vxform(m, *v);
	}
	xv -= nv;  /* ϊςݒ_Wւ̃|C^Aobt@̐擪AhX֖߂܂ */
	//v -= nv; /* _WXg͂svȂ̂ŁA͐擪֖߂Kv܂ */

	/* eZOg`܂B */
	f = render->front;
	b = render->back;
	for(i = 0;
	    i < ns;
	    i++, s++) {

		/* n_AI_擾܂B */
		iv = s->iv0;
		if((iv < 0) || (iv > nv)) {
			DIE(); /* n_CfNXs */
		}
		v0 = xv[iv];
		iv = s->iv1;
		if((iv < 0) || (iv > nv)) {
			DIE(); /* I_CfNXs */
		}
		v1 = xv[iv];

		/* ZNbsOs܂B */
#define CLIP(A, B, OP, LIM) 								\
		if(!fcom(v##A.z, OP, LIM)) {						\
			if(!fcom(v##B.z, OP, LIM)) {					\
				continue;						\
			} else {							\
				fixed xAB = fsub(v##B.x, v##A.x);			\
				fixed yAB = fsub(v##B.y, v##A.y);			\
				fixed zAB = fsub(v##B.z, v##A.z);			\
				fixed zAL = fsub(LIM   , v##A.z);			\
				v##A.x = fadd(v##A.x, fdiv(fmul(xAB, zAL), zAB));	\
				v##A.y = fadd(v##A.y, fdiv(fmul(yAB, zAL), zAB));	\
				v##A.z = LIM;						\
			}								\
		}
		CLIP(0, 1, >=, f);
		CLIP(1, 0, >=, f);
		CLIP(0, 1, <=, b);
		CLIP(1, 0, <=, b);
#undef CLIP

		/* ϊs܂B
		 * * render->context->matrixɃr[|[gϊs񂪊|Ă邱ƑOłB
		 *   r[|[gϊśAmviewport()ł͂Ȃmviewportz()gĂB
		 *   ȏ̏ȂꍇA`挋ʂ͗\ł܂B
		 *   (cliprend.c render_mesh()ɂ͂̌ɊւRg܂łA
		 *    ϊs̑OɊւẮArender_mesh()render_wire()ƓłB)
		 */
		v0.x = fdiv(v0.x, v0.z);
		v0.y = fdiv(v0.y, v0.z);
		v1.x = fdiv(v1.x, v1.z);
		v1.y = fdiv(v1.y, v1.z);

		/* ZOg`܂B */
		render_line(render, fist(v0.x), fist(v0.y), fist(v1.x), fist(v1.y), color);
	}
}

void
//render_line_3d(RENDER* render, fixed x0, fixed y0, fixed z0, fixed x1, fixed y1, fixed z1, int color)
//Wed Jul 05 03:16:43 JST 2006 Naoyuki Sawa
render_line_3d(RENDER* render, const vector* v0, const vector* v1, int color)
{
	struct {
		WIRE w;
		vector v[2];
		WSEG s[1];
	} wire;
	/* \̂̏\ĝ͊댯łB̃RgQƂĂB */
	wire.w.nv = 2;
	wire.w.ns = 1;
	//wire.v[0].x = x0;
	//wire.v[0].y = y0;
	//wire.v[0].z = z0;
	//Wed Jul 05 03:16:43 JST 2006 Naoyuki Sawa
#if 0
	wire.v[0] = *v0;	/* ƁAmemcpy()ĂяoĂ܂܂ */
#else
	wire.v[0].x = v0->x;	/* ΒڑɂȂAmemcpy() */
	wire.v[0].y = v0->y;
	wire.v[0].z = v0->z;
#endif
	//wire.v[1].x = x1;
	//wire.v[1].y = y1;
	//wire.v[1].z = z1;
	//Wed Jul 05 03:16:43 JST 2006 Naoyuki Sawa
#if 0
	wire.v[1] = *v1;	/* ƁAmemcpy()ĂяoĂ܂܂ */
#else
	wire.v[1].x = v1->x;	/* ΒڑɂȂAmemcpy() */
	wire.v[1].y = v1->y;
	wire.v[1].z = v1->z;
#endif
	wire.s[0].iv0 = 0;
	wire.s[0].iv1 = 1;
	render_wire(render, &wire.w, color);
}
//	* Sun Dec 26 16:10:00 JST 2004 Naoyuki Sawa
//	- ȉ̃R[h́A"WSEG s[1]"ŏ[ȂƂ܂܊Ԉ"WSEG s[2]"ƂłB
//	  ʂłA͖Ȃ͂łB
//
//		void
//		render_line_3d(RENDER* render, vector v0, vector v1, int color)
//		{
//			struct {
//				WIRE w;
//				vector v[2];
//				WSEG s[2];	/* ʁ */
//			} wire = {
//				{ 2, 1 },	/* wire */
//				{ v0, v1 },	/* v[0..1] */
//				{ { 0, 1 } },	/* s[0] */
//			};
//			render_wire(render, &wire.w, color);
//		}
//
//	  Ƃ낪ÃR[hpcc33.exeŃRpCƁAs[]̏s܂!!
//	  ̂悤ɏCƁAs[]̏s܂B
//
//		void
//		render_line_3d(RENDER* render, vector v0, vector v1, int color)
//		{
//			struct {
//				WIRE w;
//				vector v[2];
//				WSEG s[1];	/* C */
//			} wire = {
//				{ 2, 1 },	/* wire */
//				{ v0, v1 },	/* v[0..1] */
//				{ { 0, 1 } },	/* s[0] */
//			};
//			render_wire(render, &wire.w, color);
//		}
//
//	Ȃ̂悤ȐU镑ɂȂ̂słB
//	萔ȊOō\̂̂CgpᔽȂ̂łAGCCVC++głOK̂͂łB
//	O҂̗s[]̏sȂ͒萔ŏĂ킯łBBB
//	GɃlXg\̂ꍇ́A\g킸IɑS݂łB
