;
;	clipw65a.s
;
;	P/ECE W65C02 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipw65a.h"

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

; CPUZbg܂B
;
	.global	w65c02_reset
w65c02_reset:
	xld.w	%r12, w65c02			; ܂NA܂B
	xld.w	%r13, 0
	xld.w	%r14, SIZEOF_W65C02
	xcall	memset
	;
	pushn	%r3
	xcall	w65c02_enter			; sReLXg֓܂B
	;
	xld.w	%addr, 0xfffc
	xcall	w65c02_read			; %data = [$FFFC+0]
	ld.w	%PC, %data			; %PC   = [$FFFC+0]
	xcall.d	w65c02_read			; %data =           [$FFFC+1]
	add	%addr, 1			; *delay*
	xsll	%data, 8			; %data =           [$FFFC+1]<<8
	or	%PC, %data			; %PC   = [$FFFC+0]|[$FFFC+1]<<8
	;
	xld.w	%S, 0xff			; S     = $FF (bBdlł͕s)
	;
	xld.w	%data, 0x04			; P     = D=0,I=1
	xcall	w65c02_set_p			;       (NVZ=Cb0Bdlł͕s)
	;
	xcall	w65c02_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

; IRQv܂B
;
	.global	w65c02_irq
w65c02_irq:
	pushn	%r3
	xcall	w65c02_enter			; sReLXg֓܂B
	;
	xbset	[%CPU+WI], IRQ_BIT		; IRQvtOZbg܂B
	xcall	w65c02_check_pending		; IRQs\ׂ܂B
	;
	xcall	w65c02_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

; NMIs܂B
;
	.global	w65c02_nmi
w65c02_nmi:
	pushn	%r3
	xcall	w65c02_enter			; sReLXg֓܂B
	;
	xld.w	%addr, 0xfffa			; NMIs܂B
	xcall.d	w65c02_interrupt
	ld.w	%data, 0			; *delay*
	;
	xcall	w65c02_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

; PWX^l擾܂B
; [in,out]
;	w65c02.c -------+
;	w65c02.di ---++ |
;	w65c02.v -+  || |
;	          |  || |
;	         NV11DIZC --> %data
;	         |     |
;	%NZ -----+-----+
; [use]
;	%dataɖ߂lݒ肷邱ƈȊÓASWX^ۑ܂B
;
	.global	w65c02_get_p
w65c02_get_p:
	xld.ub	%data, [%CPU+DI]		; %data  = 0000DI00
	xand	%data, %data, 0x0c
	;
	xbtst	[%CPU+V], 7			; %data |= 0V000000
	jreq	3
	ext	       (1<<6)^M			; (skip?)
	or	%data, (1<<6)^L			; (skip?)
	;
	xbtst	[%CPU+C], 0			; %data |= 0000000C
	jreq	2
	or	%data, 1<<0			; (skip?)
	;
	xand	%r9, %NZ, 0x8080		; %data |= N0000000
	jreq	3
	ext	       (1<<7)^M			; (skip?)
	or	%data, (1<<7)^L			; (skip?)
	;
	xand	%r9, %NZ, 0xff			; %data |= 000000Z0
	jrne	2
	or	%data, 1<<1			; (skip?)
	;
	ret.d
	add	%data, 0x30			; %data += 00110000 *delay*

; PWX^lݒ肵܂B
; [in,out]
;	          +--------> w65c02.v
;	          |  ++----> w65c02.di
;	          |  || +--> w65c02.c
;	          |  || |
;	data --> NV??DIZC
;	         |     |
;	         +-----+---> %NZ
; [use]
;	%NZɖ߂lݒ肷邱ƈȊÓASWX^ۑ܂B
;
	.global	w65c02_set_p
w65c02_set_p:
	xld.b	[%CPU+DI], %data		; DI  = ----DI--
	;
	ld.w	%r9, %data			; V   = V-------
	xsll	%r9, 1
	xld.b	[%CPU+V], %r9
	;
	xld.b	[%CPU+C], %data			; C   = -------C
	;
	ld.w	%NZ, %data			; %NZ = N------- 00000000
	xsll	%NZ, 8
	;
	not	%r9, %data			; %NZ = N------- 00000010 (Z=0)
	xand	%r9, %r9, 1<<1			;       N------- 00000000 (Z=1)
	ret.d
	or	%NZ, %r9			; *delay*

; 荞݂s܂B
; [in]
;		%data	%addr
;		------	------
;	IRQ	0	0xfffe
;	NMI	0	0xfffa
;	BRK	1	0xfffe
;
	.global	w65c02_interrupt
w65c02_interrupt:
	xxor	%s0, %data, 1			; %s0   = 0000000b (b=~B)
	;
	add	%PC, %data			; if B then PC++ (dl)
	ld.w	%data, %PC
	xcall.d	w65c02_push			; Push HI(PC)
	srl	%data, 8			; *delay*
	xcall.d	w65c02_push			; Push LO(PC)
	ld.ub	%data, %PC			; *delay*
	;
	xcall.d	w65c02_get_p			; %data = NV11DIZC
	sll	%s0, 4				; %s0   = 000b0000 *delay*
	xcall.d	w65c02_push			; Push P
	xor	%data, %s0			; %data = NV1BDIZC *delay*
	;
	xcall	w65c02_read			; %data = [vector+0]
	ld.w	%PC, %data			; %PC   = [vector+0]
	xcall.d	w65c02_read			; %data =            [vector+1]
	add	%addr, 1			; *delay*
	xsll	%data, 8			; %data =            [vector+1]<<8
	or	%PC, %data			; %PC   = [vector+0]|[vector+1]<<8
	;
	xld.w	%r9, 0x04			; D=0,I=1 (D=065C02gdl)
	xld.b	[%CPU+DI], %r9
	xbclr	[%CPU+WI], WAI_BIT		; 荞ݔɂAWAI܂B
	;
	ret

; ۗĂIRQv𒲂ׁAs\ȂΎs܂B
;
	.global	w65c02_check_pending
w65c02_check_pending:
	xbtst	[%CPU+DI], 2			; IRQ}XNĂȂ?
	xjrne	w65c02_check_pending_EXIT
	xbtst	[%CPU+WI], IRQ_BIT		; IRQvۗĂ邩?
	xjreq	w65c02_check_pending_EXIT
	;
	xbclr	[%CPU+WI], IRQ_BIT		; IRQvtONA܂B
	xld.w	%addr, 0xfffe			; IRQs܂B
	xcall.d	w65c02_interrupt
	ld.w	%data, 0			; *delay*
	;
w65c02_check_pending_EXIT:
	ret

;****************************************************************************
;	AddressMode (gppxႢ)
;****************************************************************************

	.global	w65c02_IaI
w65c02_IaI:
	xcall.d	w65c02_read			; %data = [PC+0]
	ld.w	%addr, %PC			; %addr =  PC+0			*delay*
	ld.w	%s0, %data			; %s0   = [PC+0]
	xcall.d	w65c02_read			; %data =        [PC+1]
	add	%addr, 1			; %addr =         PC+1		*delay*
	xsll	%data, 8			; %data =        [PC+1]<<8
	or	%s0, %data			; %s0   = [PC+0]|[PC+1]<<8
	add	%PC, 2				; PC+=2
	xcall.d	w65c02_read			; %data = [a+0]
	ld.w	%addr, %s0			; %addr =  a+0			*delay*
	ld.w	%s0, %data			; %s0   = [a+0]
	xcall.d	w65c02_read			; %data =       [a+1]
	add	%addr, 1			; %addr =        a+1		*delay*
	xsll	%data, 8			; %data =       [a+1]<<8
	or	%s0, %data			; %s0   = [a+0]|[a+1]<<8
	ret.d
	ld.w	%addr, %s0			; %addr = (a)			*delay*

	.global	w65c02_Ia_xI
w65c02_Ia_xI:
	xcall.d	w65c02_read			; %data = [PC+0]
	ld.w	%addr, %PC			; %addr =  PC+0			*delay*
	ld.w	%s0, %data			; %s0   = [PC+0]
	xcall.d	w65c02_read			; %data =        [PC+1]
	add	%addr, 1			; %addr =         PC+1		*delay*
	xsll	%data, 8			; %data =        [PC+1]<<8
	or	%s0, %data			; %s0   = [PC+0]|[PC+1]<<8
	add	%PC, 2				; PC+=2
	add	%s0, %X				; %s0   =  a+X
	xcall.d	w65c02_read			; %data = [a+X+0]
	ld.uh	%addr, %s0			; %addr =  a+X+0 ($0000..$FFFF)	*delay*
	ld.w	%s0, %data			; %s0   = [a+X+0]
	xcall.d	w65c02_read			; %data =         [a+X+1]
	add	%addr, 1			; %addr =          a+X+1	*delay*
	xsll	%data, 8			; %data =         [a+X+1]<<8
	or	%s0, %data			; %s0   = [a+X+0]|[a+X+1]<<8
	ret.d
	ld.w	%addr, %s0			; %addr = (a+X)			*delay*

;****************************************************************************
;	Operation (gppxႢ)
;****************************************************************************

	.global	w65c02_ERR
w65c02_ERR:
	xcall	w65c02_leave			; sReLXg𔲂܂B
	xjp	w65c02_err			; Cł̃G[[`ցB

;----------------------------------------------------------------------------

	.global	w65c02_ADCD
w65c02_ADCD:
	xcall	w65c02_leave
	xcall.d	w65c02_adcd
	ld.w	%r12, %data			; *delay*
	xjp	w65c02_enter

	.global	w65c02_SBCD
w65c02_SBCD:
	xcall	w65c02_leave
	xcall.d	w65c02_sbcd
	ld.w	%r12, %data			; *delay*
	xjp	w65c02_enter

;----------------------------------------------------------------------------

	.global	w65c02_TRB
w65c02_TRB:
	ld.w	%t0, %NZ		; %t0 = n------- n-------
	xsrl	%NZ, 8			; %NZ =          n-------
	or	%NZ, %t0		; %NZ =          N-------
	;xsll	%NZ, 8			; %NZ = N------- 00000000 -----------+
	;				;                                    |
	ld.w	%t0, %data		; %NZ = N------- 0000000Z            |
	and	%t0, %A			;                       |            |
	jreq.d	3			;  (data & A) ? 0 : 1 --+            |
	 xsll	%NZ, 8			; %NZ = N------- 00000000 *delay* <--+
	or	%NZ, 1			;                         (skip?)
	;
	not	%t0, %A			; %data = data & ~A
	ret.d
	and	%data, %t0		; *delay*

	.global	w65c02_TSB
w65c02_TSB:
	ld.w	%t0, %NZ		; %t0 = n------- n-------
	xsrl	%NZ, 8			; %NZ =          n-------
	or	%NZ, %t0		; %NZ =          N-------
	;xsll	%NZ, 8			; %NZ = N------- 00000000 -----------+
	;				;                                    |
	ld.w	%t0, %data		; %NZ = N------- 0000000Z            |
	and	%t0, %A			;                       |            |
	jreq.d	3			;  (data & A) ? 0 : 1 --+            |
	 xsll	%NZ, 8			; %NZ = N------- 00000000 *delay* <--+
	or	%NZ, 1			;                         (skip?)
	;
	ret.d
	or	%data, %A		; %data = data | A *delay*

;----------------------------------------------------------------------------

	.global	w65c02_CLI
w65c02_CLI:
	xbclr	[%CPU+DI], 2
	xjp	w65c02_check_pending		; ۗĂIRQv𒲂ׂ܂B

	.global	w65c02_SEI
w65c02_SEI:
	xbset	[%CPU+DI], 2
	ret

	.global	w65c02_CLD
w65c02_CLD:
	xbclr	[%CPU+DI], 3
	ret

	.global	w65c02_SED
w65c02_SED:
	xbset	[%CPU+DI], 3
	ret

	.global	w65c02_CLV
w65c02_CLV:
	xbclr	[%CPU+V], 7
	ret

;----------------------------------------------------------------------------

	.global	w65c02_NOP
w65c02_NOP:
	ret

	.global	w65c02_WAI
w65c02_WAI:
	xbset	[%CPU+WI], WAI_BIT
	ret.d
	ld.w	%CYCLE, 0			; *delay*

	.global	w65c02_STP
w65c02_STP:
	ret.d
	sub	%PC, 1				; *delay*

	.global	w65c02_BRK
w65c02_BRK:
	xld.w	%addr, 0xfffe			; BRKs܂B
	xjp.d	w65c02_interrupt
	ld.w	%data, 1			; *delay*

	.global	w65c02_RTI
w65c02_RTI:
	xcall	w65c02_pull			; Pull P
	xcall	w65c02_set_p
	xcall	w65c02_pull			; Pull LO(PC)
	xcall.d	w65c02_pull			; Pull HI(PC)
	ld.w	%PC, %data			; *delay*
	xsll	%data, 8			; %PC = PC
	xjp.d	w65c02_check_pending		; ۗĂIRQv𒲂ׂ܂B
	or	%PC, %data			; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_BBR0
	.global	w65c02_BBS0
w65c02_BBR0:
w65c02_BBS0:
	xand	%data, %data, (1<<0)
	ret

	.global	w65c02_BBR1
	.global	w65c02_BBS1
w65c02_BBR1:
w65c02_BBS1:
	xand	%data, %data, (1<<1)
	ret

	.global	w65c02_BBR2
	.global	w65c02_BBS2
w65c02_BBR2:
w65c02_BBS2:
	xand	%data, %data, (1<<2)
	ret

	.global	w65c02_BBR3
	.global	w65c02_BBS3
w65c02_BBR3:
w65c02_BBS3:
	xand	%data, %data, (1<<3)
	ret

	.global	w65c02_BBR4
	.global	w65c02_BBS4
w65c02_BBR4:
w65c02_BBS4:
	xand	%data, %data, (1<<4)
	ret

	.global	w65c02_BBR5
	.global	w65c02_BBS5
w65c02_BBR5:
w65c02_BBS5:
	xand	%data, %data, (1<<5)
	ret

	.global	w65c02_BBR6
	.global	w65c02_BBS6
w65c02_BBR6:
w65c02_BBS6:
	xand	%data, %data, (1<<6)
	ret

	.global	w65c02_BBR7
	.global	w65c02_BBS7
w65c02_BBR7:
w65c02_BBS7:
	xand	%data, %data, (1<<7)
	ret

;----------------------------------------------------------------------------

	.global	w65c02_RMB0
w65c02_RMB0:
	xand	%data, %data, ~(1<<0)
	ret

	.global	w65c02_RMB1
w65c02_RMB1:
	xand	%data, %data, ~(1<<1)
	ret

	.global	w65c02_RMB2
w65c02_RMB2:
	xand	%data, %data, ~(1<<2)
	ret

	.global	w65c02_RMB3
w65c02_RMB3:
	xand	%data, %data, ~(1<<3)
	ret

	.global	w65c02_RMB4
w65c02_RMB4:
	xand	%data, %data, ~(1<<4)
	ret

	.global	w65c02_RMB5
w65c02_RMB5:
	xand	%data, %data, ~(1<<5)
	ret

	.global	w65c02_RMB6
w65c02_RMB6:
	xand	%data, %data, ~(1<<6)
	ret

	.global	w65c02_RMB7
w65c02_RMB7:
	xand	%data, %data, ~(1<<7)
	ret

	.global	w65c02_SMB0
w65c02_SMB0:
	xoor	%data, %data, (1<<0)
	ret

	.global	w65c02_SMB1
w65c02_SMB1:
	xoor	%data, %data, (1<<1)
	ret

	.global	w65c02_SMB2
w65c02_SMB2:
	xoor	%data, %data, (1<<2)
	ret

	.global	w65c02_SMB3
w65c02_SMB3:
	xoor	%data, %data, (1<<3)
	ret

	.global	w65c02_SMB4
w65c02_SMB4:
	xoor	%data, %data, (1<<4)
	ret

	.global	w65c02_SMB5
w65c02_SMB5:
	xoor	%data, %data, (1<<5)
	ret

	.global	w65c02_SMB6
w65c02_SMB6:
	xoor	%data, %data, (1<<6)
	ret

	.global	w65c02_SMB7
w65c02_SMB7:
	xoor	%data, %data, (1<<7)
	ret

;****************************************************************************
;	
;****************************************************************************
