/*	
 *	clipw65.h
 *
 *	P/ECE W65C02 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_W65_H__
#define __CLIP_W65_H__

/****************************************************************************
 *	萔E\
 ****************************************************************************/

/* [note]
 *	* BtOPWX^̒ɑ݂܂B(http://www.nesworld.com/dev/bbrkinst.txtp)
 *	  ----------------------------------------------------------------------------------------
 *	   The B flag
 *	   ----------
 *	   No actual "B" flag exists inside the 6502's processor status register. 
 *	   The B flag only exists in the status flag byte pushed to the stack.
 *	   Naturally, when the flags are restored (via PLP or RTI), the B bit is discarded.
 *	   Depending on the means, the B status flag will be pushed to the stack as either 0 or 1.
 *	    software instructions BRK & PHP will push the B flag as being 1.
 *	    hardware interrupts IRQ & NMI will push the B flag as being 0.
 *	  ----------------------------------------------------------------------------------------
 *	* W65C02\̂ɂāAXWX^lYWX^l̃tB[hɒuŔA
 *	  W65C02S Microprocessor DATA SHEET ̃WX^Zbg̐} A,Y,X,PC,S,P ̏Ȃ̂ŁA
 *	  ɍ킹߂łB
 */
typedef struct _W65C02 {
	unsigned char a;	/* + 0,1          AAAAAAAA */
	unsigned char c;	/* + 1,1          -------C */
	unsigned short nz;	/* + 2,2 N------- NZZZZZZZ */
	unsigned char di;	/* + 4,1          ----DI-- */
	unsigned char v;	/* + 5,1          V------- */
	unsigned char y;	/* + 6,1          YYYYYYYY */
	unsigned char x;	/* + 7,1          XXXXXXXX */
	unsigned short pc;	/* + 8,2 PCPCPCPC PCPCPCPC */
	unsigned char s;	/* +10,1          SSSSSSSS */
	unsigned char wi;	/* +11,1          ------WI */
	int cycle;		/* +12,4 cTCN    */
} W65C02;			/* =16 */

/* W65C02.flags */
#define W65C02_IRQ (1<<0)	/* IRQۗ 0=,1=L */
#define W65C02_WAI (1<<1)	/* WAI 0=ʏ,1=~ */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern W65C02 w65c02; /* P/ECȄꍇ͍RAMɔzu -> framw65a.s */

typedef struct _W65C02SEQ {
	unsigned char resv0;	/* (\) */
	unsigned char resv1;	/* (\) */
	unsigned char resv2;	/* (\) */
	unsigned char cycle;	/* TCN */
	void (*fn1)();		/*  |     |      | jmp/jsr   */
	void (*fn2)();		/* NULL  | ڰ | ڽӰ | ڽӰ */
	void (*fn3)();		/* NULL  | NULL     | ڰ  | NULL      */
} W65C02SEQ;
extern const W65C02SEQ w65c02seq[0x100]; /* V[PXe[u */

/****************************************************************************
 *	AvP[V`
 ****************************************************************************/

#ifndef PIECE
int w65c02_read(int addr);		/* Read */
void w65c02_write(int addr, int data);	/* Write */
#else /*PIECE*/
/* %r1 w65c02_read(%r0); */		/* Read */
/* void w65c02_write(%r0, %r1); */	/* Write */
#endif /*PIECE*/

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* CPUZbg܂B
 */
void w65c02_reset();

/* PWX^l擾܂B
 * [out]
 *	߂l		PWX^lB(NV11DIZC)
 * [note]
 *	* bit4(BtO)bit5(\)́A1Ԃ܂B
 *	  B1Œł闝ŔAW65C02\̂̃RgQƂĂB
 */
#define w65c02_get_p w65c02_get_p_C /* AZuœ֐Ƃ̖OՓˉ */
int w65c02_get_p();

/* PWX^lݒ肵܂B
 * [in]
 *	p		PWX^lB(NV??DIZC)
 * [note]
 *	* bit4(BtO)bit5(\)͕ێȂ̂ŁAsō\܂B
 *	  BێȂŔAW65C02\̂̃RgQƂĂB
 */
#define w65c02_set_p w65c02_set_p_C /* AZuœ֐Ƃ̖OՓˉ */
void w65c02_set_p(int p);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void w65c02_run(int cycle);

/* IRQsA܂͕ۗ܂B
 */
void w65c02_irq();

/* NMIs܂B
 */
void w65c02_nmi();

#endif /*__CLIP_W65_H__*/
