/*	
 *	clipuvc.h
 *
 *	USB Video Class (UVC) Device
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue May 12 21:55:19 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __CLIP_UVC_H__
#define __CLIP_UVC_H__
/****************************************************************************
 *	v_NgID
 ****************************************************************************/
#define UVC_PRODUCT_ID	(PCE_PRODUCT_ID+0x1B)	/* d֎~!! */
/****************************************************************************
 *	UVCdlɌW`
 ****************************************************************************/
//QƎ:uUniversal Serial Bus Device Class Definition for Video Devices Revision 1.1 June 1, 2005v(USB_Video_Class_1.1.pdf)
/*--------------------------------------------------------------------------*/
//Appendix A. Video Device Class Codes
//A.1. Video Interface Class Code
#define UVC_CC_VIDEO						0x0E
//A.2. Video Interface Subclass Codes
#define UVC_SC_UNDEFINED					0x00
#define UVC_SC_VIDEOCONTROL					0x01
#define UVC_SC_VIDEOSTREAMING					0x02
#define UVC_SC_VIDEO_INTERFACE_COLLECTION			0x03
//A.3. Video Interface Protocol Codes
#define UVC_PC_PROTOCOL_UNDEFINED				0x00
//A.4. Video Class-Specific Descriptor Types
#define UVC_CS_UNDEFINED					0x20
#define UVC_CS_DEVICE						0x21
#define UVC_CS_CONFIGURATION					0x22
#define UVC_CS_STRING						0x23
#define UVC_CS_INTERFACE					0x24
#define UVC_CS_ENDPOINT						0x25
//A.5. Video Class-Specific VC Interface Descriptor Subtypes
#define UVC_VC_DESCRIPTOR_UNDEFINED				0x00
#define UVC_VC_HEADER						0x01
#define UVC_VC_INPUT_TERMINAL					0x02
#define UVC_VC_OUTPUT_TERMINAL					0x03
#define UVC_VC_SELECTOR_UNIT					0x04
#define UVC_VC_PROCESSING_UNIT					0x05
#define UVC_VC_EXTENSION_UNIT					0x06
//A.6. Video Class-Specific VS Interface Descriptor Subtypes
#define UVC_VS_UNDEFINED					0x00
#define UVC_VS_INPUT_HEADER					0x01
#define UVC_VS_OUTPUT_HEADER					0x02
#define UVC_VS_STILL_IMAGE_FRAME				0x03
#define UVC_VS_FORMAT_UNCOMPRESSED				0x04
#define UVC_VS_FRAME_UNCOMPRESSED				0x05
#define UVC_VS_FORMAT_MJPEG					0x06
#define UVC_VS_FRAME_MJPEG					0x07
//Reserved							0x08
//Reserved							0x09
#define UVC_VS_FORMAT_MPEG2TS					0x0A
//Reserved							0x0B
#define UVC_VS_FORMAT_DV					0x0C
#define UVC_VS_COLORFORMAT					0x0D
//Reserved							0x0E
//Reserved							0x0F
#define UVC_VS_FORMAT_FRAME_BASED				0x10
#define UVC_VS_FRAME_FRAME_BASED				0x11
#define UVC_VS_FORMAT_STREAM_BASED				0x12
//A.7. Video Class-Specific Endpoint Descriptor Subtypes
#define UVC_EP_UNDEFINED					0x00
#define UVC_EP_GENERAL						0x01
#define UVC_EP_ENDPOINT						0x02
#define UVC_EP_INTERRUPT					0x03
//A.8. Video Class-Specific Request Codes
#define UVC_RC_UNDEFINED					0x00
#define UVC_SET_CUR						0x01
#define UVC_GET_CUR						0x81
#define UVC_GET_MIN						0x82
#define UVC_GET_MAX						0x83
#define UVC_GET_RES						0x84
#define UVC_GET_LEN						0x85
#define UVC_GET_INFO						0x86
#define UVC_GET_DEF						0x87
//A.9. Control Selector Codes
//A.9.1. VideoControl Interface Control Selectors
#define UVC_VC_CONTROL_UNDEFINED				0x00
#define UVC_VC_VIDEO_POWER_MODE_CONTROL				0x01
#define UVC_VC_REQUEST_ERROR_CODE_CONTROL			0x02
//Reserved							0x03
//A.9.2. Terminal Control Selectors
#define UVC_TE_CONTROL_UNDEFINED				0x00
//A.9.3. Selector Unit Control Selectors
#define UVC_SU_CONTROL_UNDEFINED				0x00
#define UVC_SU_INPUT_SELECT_CONTROL				0x01
//A.9.4. Camera Terminal Control Selectors
#define UVC_CT_CONTROL_UNDEFINED				0x00
#define UVC_CT_SCANNING_MODE_CONTROL				0x01
#define UVC_CT_AE_MODE_CONTROL					0x02
#define UVC_CT_AE_PRIORITY_CONTROL				0x03
#define UVC_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL			0x04
#define UVC_CT_EXPOSURE_TIME_RELATIVE_CONTROL			0x05
#define UVC_CT_FOCUS_ABSOLUTE_CONTROL				0x06
#define UVC_CT_FOCUS_RELATIVE_CONTROL				0x07
#define UVC_CT_FOCUS_AUTO_CONTROL				0x08
#define UVC_CT_IRIS_ABSOLUTE_CONTROL				0x09
#define UVC_CT_IRIS_RELATIVE_CONTROL				0x0A
#define UVC_CT_ZOOM_ABSOLUTE_CONTROL				0x0B
#define UVC_CT_ZOOM_RELATIVE_CONTROL				0x0C
#define UVC_CT_PANTILT_ABSOLUTE_CONTROL				0x0D
#define UVC_CT_PANTILT_RELATIVE_CONTROL				0x0E
#define UVC_CT_ROLL_ABSOLUTE_CONTROL				0x0F
#define UVC_CT_ROLL_RELATIVE_CONTROL				0x10
#define UVC_CT_PRIVACY_CONTROL					0x11
//A.9.5. Processing Unit Control Selectors
#define UVC_PU_CONTROL_UNDEFINED				0x00
#define UVC_PU_BACKLIGHT_COMPENSATION_CONTROL			0x01
#define UVC_PU_BRIGHTNESS_CONTROL				0x02
#define UVC_PU_CONTRAST_CONTROL					0x03
#define UVC_PU_GAIN_CONTROL					0x04
#define UVC_PU_POWER_LINE_FREQUENCY_CONTROL			0x05
#define UVC_PU_HUE_CONTROL					0x06
#define UVC_PU_SATURATION_CONTROL				0x07
#define UVC_PU_SHARPNESS_CONTROL				0x08
#define UVC_PU_GAMMA_CONTROL					0x09
#define UVC_PU_WHITE_BALANCE_TEMPERATURE_CONTROL		0x0A
#define UVC_PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL		0x0B
#define UVC_PU_WHITE_BALANCE_COMPONENT_CONTROL			0x0C
#define UVC_PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL		0x0D
#define UVC_PU_DIGITAL_MULTIPLIER_CONTROL			0x0E
#define UVC_PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL			0x0F
#define UVC_PU_HUE_AUTO_CONTROL					0x10
#define UVC_PU_ANALOG_VIDEO_STANDARD_CONTROL			0x11
#define UVC_PU_ANALOG_LOCK_STATUS_CONTROL			0x12
//A.9.6. Extension Unit Control Selectors
#define UVC_XU_CONTROL_UNDEFINED				0x00
//A.9.7. VideoStreaming Interface Control Selectors
#define UVC_VS_CONTROL_UNDEFINED				0x00
#define UVC_VS_PROBE_CONTROL					0x01
#define UVC_VS_COMMIT_CONTROL					0x02
#define UVC_VS_STILL_PROBE_CONTROL				0x03
#define UVC_VS_STILL_COMMIT_CONTROL				0x04
#define UVC_VS_STILL_IMAGE_TRIGGER_CONTROL			0x05
#define UVC_VS_STREAM_ERROR_CODE_CONTROL			0x06
#define UVC_VS_GENERATE_KEY_FRAME_CONTROL			0x07
#define UVC_VS_UPDATE_FRAME_SEGMENT_CONTROL			0x08
#define UVC_VS_SYNCH_DELAY_CONTROL				0x09
/*--------------------------------------------------------------------------*/
//Appendix B. Terminal Types
//B.1. USB Terminal Types
#define UVC_TT_VENDOR_SPECIFIC					0x0100		//I/O	A Terminal dealing with a signal carried over a vendor-specific interface. The vendor-specific interface descriptor must contain a field that references the Terminal.
#define UVC_TT_STREAMING					0x0101		//I/O	A Terminal dealing with a signal carried over an endpoint in a VideoStreaming interface. The VideoStreaming interface descriptor points to the associated Terminal through the bTerminalLink field.
//B.2. Input Terminal Types
#define UVC_ITT_VENDOR_SPECIFIC					0x0200		//I	Vendor-Specific Input Terminal. 
#define UVC_ITT_CAMERA						0x0201		//I	Camera sensor. To be used only in Camera Terminal descriptors.
#define UVC_ITT_MEDIA_TRANSPORT_INPUT				0x0202		//I	Sequential media. To be used only in Media Transport Terminal Descriptors.
//B.3. Output Terminal Types
#define UVC_OTT_VENDOR_SPECIFIC					0x0300		//O	Vendor-Specific Output Terminal.
#define UVC_OTT_DISPLAY						0x0301		//O	Generic display (LCD, CRT, etc.).
#define UVC_OTT_MEDIA_TRANSPORT_OUTPUT				0x0302		//O	Sequential media . To be used only in Media Transport Terminal Descriptors.
//B.4. External Terminal Types
#define UVC_EXTERNAL_VENDOR_SPECIFIC				0x0400		//I/O	Vendor-Specific External Terminal.
#define UVC_COMPOSITE_CONNECTOR					0x0401		//I/O	Composite video connector.
#define UVC_SVIDEO_CONNECTOR					0x0402		//I/O	S-video connector.
#define UVC_COMPONENT_CONNECTOR					0x0403		//I/O	Component video connector.
/****************************************************************************
 *	萔C\
 ****************************************************************************/
typedef struct _ST_UVC {
	void		(*old_pceLCDTrans)();			//tbNOpceLCDTrans()				܂UVC_Start()Ă΂ĂȂNULL
	uint16_t	FrameID;				//yC[hwb_bmHeaderInfo'D0: Frame ID'
	uint16_t	txpos;					//txbuf[]̑oς݃sNZ
	uint8_t		txbuf[(DISP_X * DISP_Y) / 4];		//zʂ̃XibvVbg
} ST_UVC;
extern ST_UVC stUVC;
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
void UVC_Start();
void UVC_Stop();
#endif//__CLIP_UVC_H__
