/*	
 *	clipusb.h
 *
 *	USBhCo`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sat Oct 30 05:43:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Jul 03 03:45:00 JST 2005 Naoyuki Sawa
 *	- x_[IDAv_NgID̒`ǉ܂B
 *	* Wed Jul 06 05:26:00 JST 2005 Naoyuki Sawa
 *	- Gh|CgCfNX̒`ǉ܂B
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- usb_init(),usb_free()->usb_start(),usb_stop()ɖOύX܂B
 *	* Sat Dec 08 00:00:11 JST 2007 Naoyuki Sawa
 *	- MI[o[\Ƃ邽߂̎dlύXs܂B
 *	  ܂ł́Aep1_txdone(),ep2_rxdone()R[obNOɎMobt@ǂݏoANAĂ܂A
 *	  ́Aep1_txdone(),ep2_rxdone()ŎMobt@ǂݏoAłꍇ̂݃NAdlƂȂ܂B
 *	- ̎dlύXzA܂łƓƂ@́Aclipuio.c,clipeth.cQƂĂB
 *	  ̎dlύXɑΉAMI[o[Ƃ@́Aclipacm.cQƂĂB
 *	* Thu Sep 04 22:00:29 JST 2014 Naoyuki Sawa
 *	- 萔̒`ǉ܂B
 *	* Sun Sep 21 14:34:51 JST 2014 Naoyuki Sawa
 *	- [eBeBƂāAUSB_UINT16()`USB_UINT128()̃}Nǉ܂B
 *	* Thu May 07 21:15:37 JST 2015 Naoyuki Sawa
 *	- MRg[f[^obt@𓮓IɊ蓖Ă悤ɂ܂B
 *	- ܂ł́AMRg[f[^obt@A16oCgŒTCYɂĂ܂B
 *	  MRg[f[^TCY16oCg𒴂鎖͖낤ƍlĂĂ̂łA16oCg𒴂鎖܂B
 *	  ̓Iɂ́AUVC(USB video device class)́ASET_CURŃNGXgŁA26oCgłB
 *	  ܂ł̎ł́AUVCSET_CURŃNGXgɑ΂āAs̉(=Xg[)ԂĂ܂Ă܂B
 *	- ΍ĂƂẮAPɁAMRg[f[^obt@𑝂₷@L܂A̕@͎Ȃɂ܂B
 *	  lXȃfoCXNXŁAMRg[f[^TCY̍őlǂꂮ炢܂ŗL蓾̂AzłȂłB
 *	  ŁADevice-to-host̃foCXNGXg̓sxAMRg[f[^obt@𓮓IɊ蓖Ă鎖ɂ܂B
 *	- XAW[쐬́A荞ݓł̓I蓖ĂoȂ̂ŁAOq̂悤ȌŒTCY̕@Ă̂łAł́A荞ݓł̓I蓖ĂSɎgpł܂B
 *	  ̑̃fbgƂāA܂łAfoCXNGXgւ̊荞݉\ቺ܂AfoCXNGXgɍ͂܂dvł͖Ǝv̂ŁAvƎv܂B
 *	  ܂Ƃ߂ƁA̕ύXɂp̃fbg͂قږA̓foCXNGXg̎MRg[f[^TCYCɂɁAʃW[鎖o悤ɂȂ܂B
 *	  W[̊OC^[tFCX͕ύXĂ܂̂ŁẢʃW[̕ύXsvłB
 *	* Tue May 12 20:44:50 JST 2015 Naoyuki Sawa
 *	- D12OutCmd(),D12OutDat(),D12InDat()A[J֐˃O[o֐ɕύX܂B
 *	  AvP[VAuPDIUSBD12 R}hsv֐QׂȐAsP[XłB
 *	- R}hR[h̃V{`(D12_SET_ADDRESS_ENABLE`D12_READ_CHIP_ID)Aclipusb.cclipusb.hֈړ܂B
 *	  L̊֐O[o֐ɕύX̂ŁAAvP[VR}hR[hQƂKvłB
 */
#ifndef __CLIP_USB_H__
#define __CLIP_USB_H__

/****************************************************************************
 *	P/ECEJc[ C:/usr/PIECE/sysdev/pcekn/pceusb.h 
 ****************************************************************************/

/* x_[IDłB
 * [note]
 *	* o^ OeRSTED, Inc. 16i=0x0e19 10i=3609
 */
#define PCE_VENDOR_ID		0x0e19

/* v_NgIDłB
 */
#define PCE_PRODUCT_ID		0x1000
#define PCE_PRODUCT_ID_BASIC	(PCE_PRODUCT_ID + 0)	/* {[h */
#define PCE_PRODUCT_ID_GAMEPAD	(PCE_PRODUCT_ID + 1)	/* GamePad[h */

/* v_NgID̗\
 * [note]
 *	* 0x1002 - 0x10bf : P/ECE̋@\ĝߗ\
 *	  0x10c0 - 0x10ff : [Upɗ\
 *	  LȊO̔ԍ͎gpȂłB
 */

/****************************************************************************
 *	PDIUSBD12
 ****************************************************************************/

/* Gh|CgCfNX */
#define EP0OUT					  0
#define EP0IN					  1
#define EP1OUT					  2
#define EP1IN					  3
#define EP2OUT					  4
#define EP2IN					  5

/* eGh|Cg̍őpPbgTCY */
#define EP0_PACKET_SIZE				 16
#define EP1_PACKET_SIZE				 16
#define EP2_NONISO_PACKET_SIZE			 64	/* double-buffered */
#define EP2_ISOOUT_PACKET_SIZE			128	/* double-buffered */
#define EP2_ISOIN_PACKET_SIZE			128	/* double-buffered */
#define EP2_ISOIO_PACKET_SIZE			 64	/* double-buffered */
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//#define EP0TO2_MAX_PACKET_SIZE		128
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

/* D12OutCmd(cmd) */
/* Initialization commands */
#define D12_SET_ADDRESS_ENABLE			0xD0
#define D12_SET_ENDPOINT_ENABLE			0xD8
#define D12_SET_MODE				0xF3
#define D12_SET_DMA				0xFB
/* Data flow commands */
#define D12_READ_INTERRUPT_REGISTER		0xF4
#define D12_SELECT_ENDPOINT			0x00	/* 0x00`0x05 */
#define D12_READ_LAST_TRANSACTION_STATUS	0x40	/* 0x40`0x45 */
#define D12_READ_ENDPOINT_STATUS		0x80	/* 0x80`0x85 */
#define D12_READ_BUFFER				0xF0
#define D12_WRITE_BUFFER			0xF0
#define D12_SET_ENDPOINT_STATUS			0x40	/* 0x40`0x45 */
#define D12_ACKNOWLEDGE_SETUP			0xF1
#define D12_CLEAR_BUFFER			0xF2
#define D12_VALIDATE_BUFFER			0xFA
#define D12_SEND_RESUME				0xF6
#define D12_READ_CURRENT_FRAME_NUMBER		0xF5
/* Undocumented commands */
#define D12_READ_CHIP_ID			0xFD

/* D12_SetMode(config) */
#define D12_NOLAZYCLOCK				0x02
#define D12_CLOCKRUNNING			0x04
#define D12_INTERRUPTMODE			0x08
#define D12_SOFTCONNECT				0x10
#define D12_ENDP_NONISO				0x00
#define D12_ENDP_ISOOUT				0x40
#define D12_ENDP_ISOIN				0x80
#define D12_ENDP_ISOIO				0xC0
/* D12_SetMode(clkdiv) */
#define D12_CLOCK_12M				0x03
#define D12_CLOCK_4M				0x0b
#define D12_SETTOONE				0x40
#define D12_SOFONLY				0x80
/* D12_SetDMA(mode) */
#define D12_DMASINGLE				0x00
#define D12_BURST_4				0x01
#define D12_BURST_8				0x02
#define D12_BURST_16				0x03
#define D12_DMAENABLE				0x04
#define D12_DMA_INTOKEN				0x08
#define D12_AUTOLOAD				0x10
#define D12_NORMALPLUSSOF			0x20
#define D12_ENDP4INTENABLE			0x40
#define D12_ENDP5INTENABLE			0x80
/* D12_ReadInterruptRegister(retval) */
#define D12_INT_ENDP0OUT			0x01
#define D12_INT_ENDP0IN				0x02
#define D12_INT_ENDP1OUT			0x04
#define D12_INT_ENDP1IN				0x08
#define D12_INT_ENDP2OUT			0x10
#define D12_INT_ENDP2IN				0x20
#define D12_INT_BUSRESET			0x40
#define D12_INT_SUSPENDCHANGE			0x80
#define D12_INT_EOT				0x0100
/* D12_ReadLastTransactionStatus(retval) */
#define D12_DATARECEIVETRANSMITSUCCESS		0x01																		/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_NOERROR				0x00	//no error																/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_PIDENCODINGERROR			0x02	//PID encoding error; bits 7 to 4 are not the inversion of bits 3 to 0									/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_PIDUNKNOWN				0x04	//PID unknown; encoding is valid, but PID does not exist										/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_UNEXPECTEDPACKET			0x06	//unexpected packet; packet is not of the type expected (= token, data or acknowledge), or SETUP token to a non-control endpoint	/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_TOKENCRCERROR			0x08	//token CRC error															/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_DATACRCERROR			0x0A	//data CRC error															/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_TIMEOUTERROR			0x0C	//time-out error															/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_NEVERHAPPENS			0x0E	//never happens																/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_UNEXPECTEDEOP			0x10	//unexpected End-Of-Packet (EOP)													/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_SENTORRECEIVEDNAK			0x12	//sent or received NAK															/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_SENTSTALL				0x14	//sent stall, a token was received, but the endpoint was stalled									/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_OVERFLOWERROR			0x16	//overflow error, the received packet was longer than the available buffer space							/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_BITSTUFFERROR			0x1A	//bit stuff error															/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_WRONGDATAPID			0x1E	//wrong DATA PID; the received DATA PID was not what was expected									/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_SETUPPACKET				0x20
#define D12_DATA01PACKET			0x40																		/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
#define D12_PREVIOUSSTATUSNOTREAD		0x80																		/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
/* D12_ReadEndpointStatus(retval) */
//#define D12_SETUPPACKET			0x04	//D12_ReadLastTransactionStatusł̒`ƖÔł͒`ȂƂɂ܂B
#define D12_BUFFER0FULL				0x20
#define D12_BUFFER1FULL				0x40
#define D12_ENDPOINTSTALLED			0x80																		/*{{2014/09/04ǉ:萔̒`ǉ܂B}}*/
/* D12_SelectEndpoint(retval) */
#define D12_FULLEMPTY				0x01
#define D12_STALL				0x02

void D12OutCmd(int cmd);
void D12OutDat(int dat);
int D12InDat();

/* Initialization commands */
void D12_SetAddressEnable(int addr, int enable);
void D12_SetEndpointEnable(int enable);
void D12_SetMode(int config, int clkdiv);
void D12_SetDMA(int mode);
/* Data flow commands */
int D12_ReadInterruptRegister();
int D12_SelectEndpoint(int endp);
int D12_ReadLastTransactionStatus(int endp);
int D12_ReadEndpointStatus(int endp);
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//int D12_ReadEndpoint(int endp, void* buf, int maxlen);
//int D12_WriteEndpoint(int endp, const void* ptr, int len);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
int D12_ReadBuffer(int endp, void* buf, int maxlen);
int D12_WriteBuffer(int endp, const void* ptr, int len);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
void D12_SetEndpointStatus(int endp, int stall);
void D12_AcknowledgeSetup(int endp);
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
void D12_ClearBuffer(int endp);
void D12_ValidateBuffer(int endp);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
/* General commands */
void D12_SendResume();
int D12_ReadCurrentFrameNumber();
/* Undocumented commands */
int D12_ReadChipID();

/****************************************************************************
 *	USBdl
 ****************************************************************************/

/* DEVICE_REQUEST.bRequest */
#define GET_STATUS		 0	/* foCXȂǂ̏Ԃ擾 */
#define CLEAR_FEATURE		 1	/* w肵@\𖳌ɂBSTALL̃NAŎgp */
#define SET_FEATURE		 3	/* w肵@\Lɂ */
#define SET_ADDRESS		 5	/* foCX̃AhXݒ肷 */
#define GET_DESCRIPTOR		 6	/* fBXNv^擾 */
#define SET_DESCRIPTOR		 7	/* fBXNv^ݒ肷 */
#define GET_CONFIGURATION	 8	/* RtBM[V擾 */
#define SET_CONFIGURATION	 9	/* RtBM[V肷 */
#define GET_INTERFACE		10	/* C^[tF[X擾 */
#define SET_INTERFACE		11	/* C^[tF[X肷 */
#define SYNCH_FRAME		12	/* 邽߂Ƀt[ԍ擾 */

typedef struct _DEVICE_REQUEST {
	unsigned char bmRequestType;	/* D7  : ] */
					/*       0:OUT 1:IN */
					/* D6-5: ^Cv */
					/*       0:W 1:NX 2:x_ 3:\ */
					/* D4-0: M */
					/*       0:foCX 1:C^[tF[X 2:Gh|Cg 3:̑ 4ȍ~:\ */
	unsigned char  bRequest;	/* NGXg̓ */
	unsigned short wValue;		/* bRequestŒ߂ */
	unsigned short wIndex;		/* bRequestŒ߂CfbNX܂̓ItZbg */
	unsigned short wLength;		/* f[^̒ */
} __attribute__((packed)) DEVICE_REQUEST;
//~~~~~~~~~~~~~~~~~~~~~~~
//DEVICE_REQUEST\̂ɊւČ΁ApbN𖾎ȂĂłA킴ƖĂ܂B
//USB\̒`ɂĂApfBOh__attribute__((packed))𖾎ĂB
//
// 2004/10/31 20:10:00 Naoyuki Sawa ǋL
//
// * P/ECECRpC__attribute__((packed))gꍇ́AאS̒ӂKvł!!
//   \̖̃pfBOATCYێx̗prɂg܂B
//   \̓rɁAItZbgn܂HalfLongƁAoCi܂B
//
// * KADEVICE_REQUESTȉ̃fBXNv^\̂́Apacked̗Lɂ炸zuƂȂ܂B
//   (USBdl̂̂A\̂̊ItZbgHalfLongzuȂ悤AzĂ̂Ǝv܂)
//   \̖̃pfBOATCYƂ邽߂ɁA__attribute__((packed))w肵Ă܂B
//
// * P/ECECRpĆA__attribute__((packed))𐳂܂B
//   ̓IɌƁACRpC(gcc33.exe)packed𐳂FAItZbgTCYvZĂ̂łA
//   AZu(as33.exe)ɃpfBOǉĂ܂Ă܂B
//
//	struct ARRAY {
//		unsigned char  a;
//		unsigned short b;
//	} __attribute__((packed));
//	struct ARRAY array = { 0x12, 0x3456 };
//	/* sizeof(struct ARRAY)͐3ƂȂĂ܂B... */
//
//	gcc33.exeɂĐR[h...
//
//	.byte 0x12
//	.half 0x3456	; .half[߂́AOɁ.align 0ȂAÖق̃ACgs
//
//	as33.exeɂĐoCi...
//
//	0x12
//	0x00		; .half[߂ɂÖق̃pfBO
//	0x56
//	0x34
//
// * KADEVICE_REQUESTȉ̃fBXNv^\̂́AItZbgHalfLongȂ̂ŁA
//   PƂŎg聚Aq̗̂悤Ȗ͔܂B
//   ȂA\̔zgƁA肪܂B
//
//	const ENDPOINT_DESCRIPTOR endpoint_desc[2] = {{
//		bLength:		sizeof(ENDPOINT_DESCRIPTOR),
//		bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
//		bEndpointAddress:	0x82, /* EP2IN */
//		bmAttributes:		2, /* Bulk */
//		wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
//	},{
//		bLength:		sizeof(ENDPOINT_DESCRIPTOR),
//		bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
//		bEndpointAddress:	0x02, /* EP2OUT */
//		bmAttributes:		2, /* Bulk */
//		wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
//	}};
//
//	gcc33.exeɂĐR[h...
//
//	.byte	7	// + 0,1 ... endpoint_desc[0]̊Jn
//	.byte	5	// + 1,1
//	.byte	130	// + 2,1
//	.byte	2	// + 3,1
//	.half	64	// + 4,2
//	.space	1	// + 6,1
//	.byte	7	// + 7,1 ... endpoint_desc[1]̊Jn
//	.byte	5	// + 8,1
//	.byte	2	// + 9,1
//	.byte	2	// +10,1
//	(pfBOx1)	// .half[߂AÖق̃ACgsĂ܂!!
//	.half	64	// +12,2
//	.space	1	// +14,1
//
// * _͎̂ƂłB
//   {Iɂ́AP/ECECRpC__attribute__((packed))gĂ͂܂B
//   __attribute__((packed))̗Lɂ炸tB[hItZbgƂȂ\̂ɂāA
//   \̖̃pfBOATCYێ邽߂__attribute__((packed))
//   w肵Ă\܂񂪁Â悤ȍ\̂̔zgƁAsȃoCi܂B
//   __attribute__((packed))w肵\̂̔z쐬Ă͂܂B

/* ????_DESCRIPTOR.bDescriptorType */
#define DEVICE_DESCRIPTOR_TYPE		1
#define CONFIGURATION_DESCRIPTOR_TYPE	2
#define STRING_DESCRIPTOR_TYPE		3
#define INTERFACE_DESCRIPTOR_TYPE	4
#define ENDPOINT_DESCRIPTOR_TYPE	5

/* \̔zgp֎~!! R͏̃̕RgQ */
typedef struct _DEVICE_DESCRIPTOR {
	unsigned char  bLength;			/* fBXNv^̃TCY (18) */
	unsigned char  bDescriptorType;		/* fBXNv^̃^Cv (1) */
	unsigned short bcdUSB;			/* BCD\USBdl[Xԍ */
	unsigned char  bDeviceClass;		/* NXR[h */
	unsigned char  bDeviceSubClass;		/* TuNXR[h */
	unsigned char  bDeviceProtocol;		/* vgRR[h */
	unsigned char  bMaxPacketSize0;		/* Gh|Cg0̍őpPbgTCY */
	unsigned short idVendor;		/* x_ID */
	unsigned short idProduct;		/* v_NgID */
	unsigned short bcdDevice;		/* BCD\̃foCX̃[Xԍ */
	unsigned char  iManufacture;		/* ҃XgOfBXNv^CfbNX */
	unsigned char  iProduct;		/* iXgOfBXNv^CfbNX */
	unsigned char  iSerialNumber;		/* ԍXgOfBXNv^CfbNX */
	unsigned char  bNumConfigurations;	/* \\Ȑ */
} __attribute__((packed)) DEVICE_DESCRIPTOR;

/* \̔zgp֎~!! R͏̃̕RgQ */
typedef struct _CONFIGURATION_DESCRIPTOR {
	unsigned char  bLength;			/* fBXNv^̃TCY (9) */
	unsigned char  bDescriptorType;		/* fBXNv^̃^Cv (2) */
	unsigned short wTotalLength;		/* \S(RtBM[VAC^[tF[XAGh|CgfBXNv^̍v)̒ */
	unsigned char  bNumInterfaces;		/* RtBM[VC^[tF[X̐ */
	unsigned char  bConfigurationValue;	/* Set Configuration ł̍\I邽߂̈ */
	unsigned char  iConfiguration;		/* RtBM[ṼXgOfBXNv^ւ̃CfbNX */
	unsigned char  bmAttributes;		/* \̓ */
						/* D7:oXd D6:ȓd D5:[gEF[NAbv */
	unsigned char  MaxPower;		/* őoXd͏ʂ2mAPʂŎw */
} __attribute__((packed)) CONFIGURATION_DESCRIPTOR;

/* \̔zgp֎~!! R͏̃̕RgQ */
typedef struct _STRING_DESCRIPTOR {
	unsigned char  bLength;			/* fBXNv^̃TCY (2+TCY) */
	unsigned char  bDescriptorType;		/* fBXNv^̃^Cv (3) */
	// unsigned short wLANGID[TCY/2] ܂ char bString[TCY] ܂B */
} __attribute__((packed)) STRING_DESCRIPTOR;

/* \̔zgp֎~!! R͏̃̕RgQ */
typedef struct _INTERFACE_DESCRIPTOR {
	unsigned char bLength;			/* fBXNv^̃TCY (9) */
	unsigned char bDescriptorType;		/* fBXNv^̃^Cv (4) */
	unsigned char bInterfaceNumber;		/* ̃C^[tF[X\CfbNXԍ */
	unsigned char bAlternateSetting;	/* Set Interface ő֐ݒI邽߂̈l */
	unsigned char bNumEndpoints;		/* ̃C^[tF[XGh|Cg̐ */
	unsigned char bInterfaceClass;		/* NXR[h(Xg[WAv^Ȃǂ̃NXw肷) */
	unsigned char bInterfaceSubClass;	/* TuNXR[h */
	unsigned char bInterfaceProtocol;	/* vgRR[h */
	unsigned char iInterface;		/* C^[tF[X̃XgOfBXNv^ւ̃CfbNX */
} __attribute__((packed)) INTERFACE_DESCRIPTOR;

/* \̔zgp֎~!! R͏̃̕RgQ */
typedef struct _ENDPOINT_DESCRIPTOR {
	unsigned char  bLength;			/* fBXNv^̃TCY (7) */
	unsigned char  bDescriptorType;		/* fBXNv^̃^Cv (5) */
	unsigned char  bEndpointAddress;	/* Gh|Cgԍ */
						/* D7  :  */
						/*       0:OUT 1:IN */
						/* D6-4: \(0) */
						/* D3-0: Gh|Cgԍ */
	unsigned char  bmAttributes;		/*  */
						/* D1-0: ]^Cv */
						/*       0:Rg[ 1:AC\NiX 2:oN 3:C^vg */
	unsigned short wMaxPacketSize;		/* őpPbgTCY */
	unsigned char  bInterval;		/* |[OԊu */
} __attribute__((packed)) ENDPOINT_DESCRIPTOR;

/****************************************************************************
 *	USBhCo
 ****************************************************************************/

/* USBINF.(Device request callbacks) */
typedef void (*DEVICE_REQUEST_CALLBACK)(const DEVICE_REQUEST* req, const unsigned char* dat, int len);

/* USBtbN
 * * usb_start()ւ̈Ƃėp܂B
 *   mode͕Kݒ肵ĂBʏ0x00:NONISOȂ̂ŁA[NAł\܂B
 *   Cxg/NGXgnh͎ĝݒ肵AgȂ̂NULLɂĂB
 *
 * // dv!!
 * // * AvP[VɂUSBINF쐬ꍇɁAGCCg̍\̃ow\gĂ͂܂!!
 * //   Ƃ΁Amodeep1_txdoneset_addressݒ肵Ac胁oNULLƂꍇɁA
 * //   ̂悤ȃR[hƂ...
 * // 
 * // 	^ԈC[W!!^
 * // 	USBINF usb_inf = {
 * // 		mode: D12_ENDP_NONISO,
 * // 		ep1_txdone: my_ep1_txdone,
 * // 		standard_request: {
 * // 			set_address: my_set_address,
 * // 		},
 * // 	};
 * // 
 * //   gcc33.exe\̂̏Asvȋ󔒂C[W𐶐Ă܂܂B
 * //   ǂgcc33.exéAlXg\̂ɑ΂AGCCg̍\̃o\ɕs悤łB
 * //   gcc33.exeȊOGCC(x86,Sparc,MIPS,SHp...)ł͑vȂ̂ǂAmFłB
 * //   Ȃgcc33.exełAlXgĂȂ\̂̏ꍇ͖ȂGCCg̍\̃o\g܂B
 * // 
 * 2004/10/31 15:39:00 Naoyuki Sawa
 *   q̖邽߁A\̂̃lXg߂܂BŁAGCCg\gďĂvłB
 *   ̃vOłA\̂lXgƂ́AGCCg\gďȂ悤ACĂB
 */
typedef struct _USBINF {
	/* USBC mode */
	int mode;							/* USBC[h(D12_ENDP_NONISO/ISOOUT/ISOIN/ISOIO) */
	/* USBC raw event */
	void (*bus_reset)();						/* oXZbgCxg */
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	void (*ep1_rxdone)(const unsigned char dat[/*len*/], int len);	/* EP1MCxg */
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	void (*ep1_rxdone)();						/* EP1MCxg */
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	void (*ep1_txdone)();						/* EP1MCxg */
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	void (*ep2_rxdone)(const unsigned char dat[/*len*/], int len);	/* EP2MCxg */
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	void (*ep2_rxdone)();						/* EP2MCxg */
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	void (*ep2_txdone)();						/* EP2MCxg */
	/* Device request */
	//struct {
	//\̂̃lXg͂߂܂BR͏̃RgQƂĂB
		DEVICE_REQUEST_CALLBACK get_status;			/* foCXȂǂ̏Ԃ擾 */
		DEVICE_REQUEST_CALLBACK clear_feature;			/* w肵@\𖳌ɂBSTALL̃NAŎgp */
		DEVICE_REQUEST_CALLBACK set_feature;			/* w肵@\Lɂ */
		DEVICE_REQUEST_CALLBACK set_address;			/* foCX̃AhXݒ肷 */
		DEVICE_REQUEST_CALLBACK get_descriptor;			/* fBXNv^擾 */
		DEVICE_REQUEST_CALLBACK set_descriptor;			/* fBXNv^ݒ肷 */
		DEVICE_REQUEST_CALLBACK get_configuration;		/* RtBM[V擾 */
		DEVICE_REQUEST_CALLBACK set_configuration;		/* RtBM[V肷 */
		DEVICE_REQUEST_CALLBACK get_interface;			/* C^[tF[X擾 */
		DEVICE_REQUEST_CALLBACK set_interface;			/* C^[tF[X肷 */
		DEVICE_REQUEST_CALLBACK synch_frame;			/* 邽߂Ƀt[ԍ擾 */
	//} standard_request;
	//\̂̃lXg͂߂܂BR͏̃RgQƂĂB
	DEVICE_REQUEST_CALLBACK class_request;
	DEVICE_REQUEST_CALLBACK vendor_request;
} USBINF;

/* dv!!
 *
 * [U[`ep2_rxdone()́Â悤ɎĂB
 *
 *	<: NONISO[h̏ꍇ> ISOOUT/ISOIN/ISOIO[h̏ꍇlłB
 *
 *		while((len = D12_ReadEndpoint(4, dat, 64)) != -1^M^) {
 *			^ datB ^
 *		}
 *
 * CGh|Cg̓_uobt@\ɂȂĂ̂ŁAxɓ̃pPbgMł܂B
 * USBC̎M荞݂́A@gMobt@ɃpPbghꍇɔsꑱ̂ł͂ȂA
 *                           AgVpPbguԁhɔs܂B
 * Ȃ炩̌ŁAڃpPbgMɑ΂鉞xÅԂɓڂ̃pPbgMƂ܂B
 * łAڃpPbgĊ荞݃tONAƁA܂ĂȂڂ̃pPbg
 * 荞݂܂Ƃ߂ăNAĂ܂ƂɂȂ܂B
 *
 * USBC̊荞ݏq@̎dlȂ΁Aڂ̃pPbgɊ荞݃tONAĂA
 * ɂ܂荞݃tOZbgāAڂ̃pPbgɑ΂銄荞݂̂ł傤ǂA
 * cOȂPDIUSBD12̎dl͏qAłAڂ̃pPbgɑ΂銄荞ݗv͎Ă܂܂B
 *
 * ̖h߂ɁAwȂƂAD12_ReadLastTransactionStatus()ɂĊ荞݃tONA
 * _œĂpPbǵAmɑSďxƂKvłB
 * Ȃ킿A<>̂悤ȃR[hLqĂB
 * 
 * pPbgɐVpPbgꍇ́ÃpPbgĂ܂đvłB
 * VpPbgɑΉ銄荞݃tONAɁAVpPbg邱ƂɂȂA
 * AʂȊ荞݂񔭐邾łB(while(len=...)[v́Aɔ)
 *
 * 2004/11/06 ǋL
 *
 * qwhile()ɑ鏈́ACuōs悤ɕύX܂B
 * MʒmR[obNĂяoOɁACuD12_ReadEndpoint()sAR[obNɂ̓f[^ƒn܂B
 * ACGh|Cg_uobt@ł邱ƂӎKv͂܂B
 * ڂ́Afn_usb_isr()̎QƂĂB
 */

/* USBRg[̐tbN܂B
 * [in]
 *	ui	USBtbNւ̃|C^
 *		usb_start()̓|C^̎weRs[ĕێ܂B
 *		֐ԂAJĂ܂Ă\܂B
 * [note]
 *	* ɃtbNĂꍇ́AIɂtbNĂtbN܂B
 *	  ]āAusb_start()֐͏ɐ܂B
 *	* AvP[VIOɁAKIusb_stop()ĂŃtbNĂB
 *	  usb_stop()Ă΂ɃAvP[VIƁAVXe삵܂B
 */
void usb_start(const USBINF* ui);

/* USBRg[̐tbN܂B
 * [note]
 *	* ܂tbNĂȂꍇ́Å֐͉܂B
 */
void usb_stop();

/* Gh|Cg0 IN(foCXzXg)gāAf[^𑗐M܂B
 * [in]
 *	ptr	Mf[^̐擪AhX
 *	len	Mf[^̃oCg
 * [note]
 *	* ̊֐́AfoCXNGXgւ̉ƂĂ̂ݗpł܂B
 *	  USBINF\̂Ɏw肵foCXNGXgnhR[obNꂽɁA
 *	  R[obN̒炾p\łB̓IȗpŕÂƂłB
 *	  - GETNGXgɑ΂Rg[f[^ԐM
 *	  - SETNGXgɑ΂Xe[^X(pPbg)ԐM
 *	  ȊO̖ړIE^C~OŗpƁA\łȂʂƂȂ܂B
 *	* M͔񓯊ɍs܂B
 *	  M܂ŁAptr̎wf[^QƂꑱ܂B
 *	  f[^J/ύXȂ悤CĂB
 *	  ̃foCXNGXgMAf[^J/ύXĂSłB
 */
void usb_ep0_tx(const void* ptr, int len);

/* Gh|Cg0 IN/OUT Xg[܂B
 * [note]
 *	* ̊֐́AfoCXNGXgւ̉ƂĂ̂ݗpł܂B
 *	  USBINF\̂Ɏw肵foCXNGXgnhR[obNꂽɁA
 *	  R[obN̒炾p\łB̓IȗpŕÂƂłB
 *	  - sȃfoCXNGXgɑ΂ے艞
 *	  ȊO̖ړIE^C~OŗpƁA\łȂʂƂȂ܂B
 */
void usb_ep0_stall();

/****************************************************************************
 *	[eBeB
 ****************************************************************************/

/* NX`̃fBXNv^oCgzƂĒ`ƂɁA16rbgȏ̒lACgŃoCgzɖߍނ߂̃}NłB
 * USB_UINT48(),USB_UINT64(),USB_UINT128()̈́A(ʃ[h,ʃ[h)̏ł邱ƂɒӂĂB
 * gṕAclipptp.cȂǂQƂĂB */
#define USB_UINT16( a)		((uint8_t)(a)),((uint8_t)((a)>>8))
#define USB_UINT24( a)		((uint8_t)(a)),((uint8_t)((a)>>8)),((uint8_t)((a)>>16))		//<gp>Audio Device ClassType I Format Type DescriptortSamFreq
#define USB_UINT32( a)		((uint8_t)(a)),((uint8_t)((a)>>8)),((uint8_t)((a)>>16)),((uint8_t)((a)>>24))
#define USB_UINT64( a,b)	USB_UINT32(a  ),USB_UINT32(b  )					//<gp>Picture Transfer ProtocolStorageInfo DatasetMaxCapacity
#define USB_UINT128(a,b,c,d)	USB_UINT64(a,b),USB_UINT64(c,d)					//<gp>Media Transfer ProtocolObjectPropDesc datasetPersistentUniqueObjectIdentifierDefaultValue

#endif /*__CLIP_USB_H__*/
