/*	
 *	clipunz.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Wed Feb 27 19:37:00 JST 2003 Naoyuki Sawa
 *	- VK쐬B
 *	  my_unzip()clipzlib.cڂĂ܂B
 *	  clipzlib.cɂmy_compress()ĂāAmy_unzip()clipzlib.cɓƁA
 *	  my_unzip()gŁAzlibk[`܂ŃNĂ܂łB
 *	* Sun Jul 13 18:48:00 JST 2003 Naoyuki Sawa
 *	- my_unzip(..., buffer=0, ...) ŁA[hɃTCY擾ł悤ɂ܂B
 *	* Thu Nov 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- my_unzip()ufi_outǉB
 */
#include "clip.h"

/****************************************************************************
 *	zipWJ
 ****************************************************************************/

int
my_unzip(const char* zip_fname, const char* item_name, void* buffer, int max_size, unz_file_info* ufi_out)
{
	int retval, len;
	unzFile uf;
	unz_file_info ufi;

	/* ZIPt@CJ܂B */
	uf = unzOpen(zip_fname);
	if(uf == NULL) return 0;

	/* ړĨACeփV[N܂B */
	retval = unzLocateFile(uf, item_name, 0);
	if(retval != 0) { unzClose(uf); return 0; }

	/* ACȅ擾܂B */
	retval = unzGetCurrentFileInfo(uf, &ufi, NULL, 0, NULL, 0, NULL, 0);
	if(retval != 0) { unzClose(uf); return 0; }

	/* ACeTCY擾܂B */
	len = ufi.uncompressed_size;

	/* ǂݍݗvȂ... */
	if(buffer != NULL) {
		/* obt@TCY傫΁Aǂݍ߂܂B */
		if(len > max_size) { unzClose(uf); return 0; }

		/* ACeJ܂B */
		retval = unzOpenCurrentFile(uf);
		if(retval != 0) { unzClose(uf); return 0; }

		/* ACeǂݍ݂܂B */
		retval = unzReadCurrentFile(uf, buffer, len);
		if(retval != len) { unzClose(uf); return 0; }

		/* ACeAǂݍ߂ƂmF܂BiCRCj */
		retval = unzCloseCurrentFile(uf);
		if(retval != 0) { unzClose(uf); return 0; }
	}

	/* ZIPt@C܂B */
	unzClose(uf);

	/* ACe񂪗vĂAi[܂B */
	if(ufi_out) memcpy(ufi_out, &ufi, sizeof(unz_file_info));

	/* ACeTCYԂ܂B */
	return len;
}

