/*	
 *	clipuio.h
 *
 *	USB I/O (oN]ɂAPI/O)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Jul 08 06:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Jul 09 23:23:00 JST 2005 Naoyuki Sawa
 *	- uio_stat()ǉ܂B
 *	* Fri Jul 22 07:40:00 JST 2005 Naoyuki Sawa
 *	- C^vg]oN]ɕύX܂B
 *	  C^vg]̓oXXPW[O̗DxÃfoCX̒ʐMjQ
 *	  \̂ŁAoXXPW[O̗Dx邽߂ɃoN]ɕύX܂B
 *	  "Ô"̑[ułAC^vg]łɖ肪킯ł͂܂B
 *	  oN]ւ̕ύXAɓɈႢ͊܂B
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- uio_open(),uio_close()->uio_start(),uio_stop()ɖOύX܂B
 */
#ifndef __CLIP_UIO_H__
#define __CLIP_UIO_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* P/ECE UIOfoCX̃v_NgIDÂ悤ɒ`܂B
 * P/ECE USBvOƏdȂ悤AӂĂ!!
 */
#define UIO_PRODUCT_ID	(PCE_PRODUCT_ID+0x15)

/****************************************************************************
 *	
 ****************************************************************************/

/* USB I/OJn܂B
 * [in]
 *	rxcap		Mobt@TCYB
 *	txcap		Mobt@TCYB
 *	rxdone		MR[obNB(NULL:)
 *	txdone		MR[obNB(NULL:)
 * [note]
 *	* uio_start()ĂяoAvP[V́AIOɕKA
 *	  uio_stop()ĂяoĂB
 *	  uio_stop()ĂяoɏIƁAP/ECEVXeُ퓮ƂȂ܂B
 *	* M(M)obt@TCYEP2_NONISO_PACKET_SIZE̒lw肵ꍇA
 *	  M(M)obt@TCYEP2_NONISO_PACKET_SIZEƂȂ܂B
 *	* MR[obŃAUSBRg[̎M荞݂ɓ܂B
 *	  [oCgMłĂM荞݂͔̂ŁA
 *	  MR[obNɁAKMf[^邱Ƃۏ؂܂B
 *	* MR[obŃAUSBRg[̑M荞݂ɓ܂B
 *	  2005/07/08݂̎ł́ȂMsɃR[obN̂ŁA
 *	  Mobt@ɏȂƂEP2_NONISO_PACKET_SIZEȏ̋󂫂ۏ؂܂B
 *	  A̎ύXɂ蓮삪ς\̂ŁA
 *	  MR[obN̑Mobt@̋󂫃TCY肵ȂłB
 *	  2005/07/31ǋL
 *	- M荞ݔɁAMobt@󂾂ꍇɂ̂݁AMR[obNs悤ύX܂B
 *	  ܂ł́A1pPbgM(0oCgpPbg̑M܂)ɑMR[obNsĂ܂B
 *	- ̕ύXɂAMR[obNAuio_start()Ŏw肵Mobt@TCYS̋󂫂ۏ؂܂B
 */
void uio_start(int rxcap, int txcap, void (*rxdone)(), void (*txdone)());

/* USB I/Oؒf܂B
 * [note]
 *	* uio_stop()́AɈSɌĂяoƂł܂B
 *	  uio_start()ĂяoĂȂĂAuio_stop()ĂяoĂ\܂B
 */
void uio_stop();

/* USB I/OZbg܂B
 * [note]
 *	* Zbg鍀ڂ́ÂƂłB
 *	- Mobt@ɂ܂B
 *	- MI[o[G[܂B
 */
void uio_reset();

/* Mobt@f[^o܂B
 * [in]
 *	dat		of[^i[obt@B
 *	len		of[^̍őoCgB
 * [out]
 *	߂l		ۂɎof[^̃oCgB
 *			MI[o[ĂꍇA}CiXlԂ܂B
 */
int uio_recv(void* dat, int len);

/* Mobt@փf[^ǉ܂B
 * [in]
 *	dat		Mf[^B
 *	len		Mf[^̃oCgB
 *			-1w肷ƁAAsciiZƌȂăf[^TCYf܂B
 * [out]
 *	߂l		ۂɑMf[^̃oCgB
 *			Mobt@ɏ[ȋ󂫂Ȃꍇ́AlenƂȂ܂B
 */
int uio_send(const void* dat, int len);

/* MoCgAG[Ԃ擾܂B
 * [in]
 *	stat		ʂi[UIOSTAT\̂ւ̃|C^B
 */
typedef struct _UIOSTAT {
	int rxlen;	/* Mobt@ɂMς݃f[^oCg() */
	int rxlog;	/* MoCg            (Zbg_̒ʎZ) */
	int rxerr;	/* MI[o[oCg(Zbg_̒ʎZ) */
	int txlen;	/* Mobt@ɂ鑗M҂f[^oCg() */
	int txlog;	/* MoCg            (Zbg_̒ʎZ) */
} UIOSTAT;
void uio_stat(UIOSTAT* stat);

#endif /*__CLIP_UIO_H__*/
