/*	
 *	cliptcp.h
 *
 *	TCPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Tue Sep 20 04:34:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Sep 23 15:29:00 JST 2005 Naoyuki Sawa
 *	- tcp_socket_state()ǉ܂B
 */
#ifndef __CLIP_TCP_H__
#define __CLIP_TCP_H__

/****************************************************************************
 *	TCPvgRhCo
 ****************************************************************************/

/*--------------------------------------------------------------------------*
 |                                                                          |
 |                       TCPvgRԑJڐ}                            |
 |                                                                          |
 |   (QlłB{hCo͂̂Ƃ̎łȂAȗĂ܂)   |
 |                                                                          |
 |                            +------------+                                |
 |                            |            | <----------------------+       |
 |                            |   CLOSED   |               A        |       |
 |                            |            | -----------+  |        |       |
 |                            +------------+ ACTIVE OPEN|  |        |       |
 |                     PASSIVE OPEN|  A      -----------|  |        |       |
 |                                 |  |        SYNM  |  |        |       |
 |                                 V  |CLOSE            |  |        |       |
 |                            +------------+            |  |        |       |
 |                            |            |            |  |        |       |
 |             +------------> |   LISTEN   |            |  |        |       |
 |             |              |            |            |  |        |       |
 |             |              +------------+            |  |        |       |
 |             |          SYNM  |  | M            |  |        |       |
 |             |        -----------|  |-------          |  | CLOSE  |       |
 |             |        SYNACKM|  |SYNM          |  |------- |       |
 |             |RSTM            |  |                 V  |RSTM |       |
 |       +------------+ <----------+  +----------> +------------+   |       |
 |       |            |                    SYNM |            |   |       |
 |       |SYN-RECEIVED| <------------------------- |  SYN-SENT  |   |       |
 |       |            |                    ACKM |            |   |       |
 |       +------------+ -----------+  +----------- +------------+   |       |
 |             | CLOSE  ACKM    |  |SYNACKM                  |       |
 |             |-------  ofSYN     |  |-----------                  |       |
 |             |FINM            |  |  ACKM                    |       |
 |             |                   V  V                             |       |
 |             |              +------------+                        |       |
 |             |              |            |                        |       |
 |             |              |ESTABLISHED |                        |       |
 |             |              |            |                        |       |
 |             |              +------------+                        |       |
 |             |             CLOSE |  |FINM                      |       |
 |             |            -------|  |-------                      |       |
 |             V            FINM|  |ACKM                      |       |
 |       +------------+            |  |            +------------+   |       |
 |       |            | <----------+  +----------> |            |   |       |
 |       | FIN-WAIT-1 |                            | CLOSE-WAIT |   |       |
 |       |            | -----------+               |            |   |       |
 |       +------------+ FINM    |               +------------+   |       |
 |             |ACKM -------    |                CLOSE |         |       |
 |             | ofFIN  ACKM    |               -------|         |       |
 |             V                   V               FINMV         |       |
 |       +------------+       +------------+       +------------+   |       |
 |       |            |       |            |       |            |   |       |
 |       | FIN-WAIT-2 |       |  CLOSING   |       |  LAST-ACK  |   |       |
 |       |            |       |            |       |            |   |       |
 |       +------------+       +------------+       +------------+   |       |
 |             |FINM     ACKM|               ACKM|         |       |
 |             |-------      ofFIN |                ofFIN |         |       |
 |             |ACKM            V                      |         |       |
 |             |              +------------+ TIMEOUT      |         |       |
 |             |              |            |  =2MSL       V         |       |
 |             +------------> | TIME-WAIT  | -----------------------+       |
 |                            |            |                                |
 |                            +------------+                                |
 |                                                                          |
 *--------------------------------------------------------------------------*/

typedef struct _TCPCLIENT TCPCLIENT;

/* NCAgo^p̍\ */
/*typedef*/ struct _TCPCLIENT {

	/*------------------------------------------------------------------------------*
	 *	tcp_open()ĂяoOɁAAvP[VɂĐݒ肵ĂtB[hB	*
	 *	tcp_open()ĂяóAύXĂ͂ȂB			*
	 *------------------------------------------------------------------------------*/

	/* ActiveOpenAPassiveOpen̏ꍇAlocal_portwA܂́Aw肵ȂƂ\łB
	 * local_portw肵Ȃ(0ݒ)Atcp_open()IɃGtF|[g蓖Ă܂B
	 */
	int local_port;				/* [J|[g */

	/* ActiveOpen ̏ꍇ́Aremote_ip_address̎wK{łB(0ȊOݒ)
	 * PassiveOpen̏ꍇ́Aremote_ip_addressw肷ƁÃAhX̐ڑ󂯕t܂B
	 *                      remote_ip_addressw肵Ȃ΁ACӂ̃AhX̐ڑ󂯕t܂B
	 */
	int remote_ip_address;			/* [gIPAhX */

	/* ActiveOpen ̏ꍇ́Aremote_port̎wK{łB(0ȊOݒ)
	 * PassiveOpen̏ꍇ́Aremote_portw肷ƁÃ|[g̐ڑ󂯕t܂B
	 *                      remote_portw肵Ȃ΁ACӂ̃|[g̐ڑ󂯕t܂B
	 */
	int remote_port;			/* [g|[g */

	/*------------------------------------------------------------------------------*
	 *	TCPvgRhCoAŎgptB[hB			*
	 *	AvP[V́Aȉ̃tB[hɃANZXĂ͂ȂB		*
	 *------------------------------------------------------------------------------*/

	int state;				/*  */

	int recv_sequence_number;		/* MV[PXԍ */
	int send_sequence_number;		/* MV[PXԍ */
	int send_window;			/* MEChE */

	BUFFER* recv_buffer;			/* Mobt@ */
	BUFFER* send_buffer;			/* Mobt@ */

	int T0;					/* đf̊ */

	LIST_ENTRY list_entry;			/* NCAgXg */

} /*TCPCLIENT*/;

/* TCPCLIENT.state */
#define TCP_LISTEN        0 /* Cӂ̃[gTCPу[g|[g̃RlNVv҂Ă邱Ƃ\ĂB */
#define TCP_SYN_SENT      1 /* RlNVv𑗐MAɑΉRlNVv҂Ă邱Ƃ\ĂB */
#define TCP_SYN_RECEIVED  2 /* RlNVv̎MƑM̗sARlNVv̊mFɂ鏳F҂Ă邱Ƃ\ĂB */
#define TCP_ESTABLISHED   3 /* I[vRlNV\ĂAMf[^̓[UɓnBRlNṼf[^]tF[Yɂʏ̏ԂłB */
#define TCP_FIN_WAIT_1    4 /* [gTCP̃RlNVIvA邢͈ȑOɑMRlNVIv̊mF҂Ă邱Ƃ\ĂB */
#define TCP_FIN_WAIT_2    5 /* [gTCP̃RlNVIv҂Ă邱Ƃ\ĂB */
#define TCP_CLOSE_WAIT    6 /* [J[ŨRlNVIv҂Ă邱Ƃ\ĂB */
#define TCP_CLOSING       7 /* [gTCP̃RlNVIv̊mF҂Ă邱Ƃ\ĂB */
#define TCP_LAST_ACK      8 /* łɃ[gTCP֑MRlNVIv̊mF҂Ă邱Ƃ\ĂB(̓[gTCP̃RlNVIv̊mF܂) */
#define TCP_TIME_WAIT     9 /* [gTCPRlNVIv̊mFMĂƊmMł邾̎Ԃ҂Ă邱Ƃ\ĂB */
#define TCP_CLOSED       10 /* SRlNVȂԂ\ĂB */

/*--------------------------------------------------------------------------*/

/* TCPvgRhCoJn܂B
 * [note]
 *	* tcp_start()ĂяoAvP[V́AIOɕKAtcp_stop()ĂяoĂB
 *	  tcp_stop()ĂяoɃAvP[VIƁAP/ECEVXeُ퓮N܂B
 *	* tcp_open()ĂяoăNCAgo^OɁAKAtcp_start()ĂяoĂB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void tcp_start();

/* TCPvgRhCo~܂B
 * [note]
 *	* tcp_stop()́AɈSɌĂяo\łB
 *	  tcp_start()ĂяoĂȂĂAłAłAtcp_stop()Ăяoč\܂B
 *	* tcp_stop()ĂяoƁAo^ĂNCAǵAIɂׂēo^܂B
 *	  tcp_stop()ĂяoOɁAX̃NCAgAIɓo^Kv͂܂B
 *	  ܂Atcp_stop()ĂяoɁAtcp_close()ĂяoĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void tcp_stop();

/* TCPڑN܂B
 * [in]
 *	client		ĂяoɂĊmۂANCAgo^p̍\́B
 *			etB[hA炩ߓK؂ɏĂĂB
 *	active		PassiveOpenȂ΁A0w肵ĂB
 *			ActiveOpen Ȃ΁A1w肵ĂB
 * [note]
 *	* tcp_open()́AڑNAɏԂ܂B
 *	  ActiveOpenAPassiveOpenȀꍇAڑ̓obNOEhōs܂B
 *	* NCAgo^p̍\̂́ATCPvgRhCõXgɃN܂B
 *	  tcp_close()Ăяoēo^܂ŁA\̂JĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void tcp_open(TCPCLIENT* client, int active);

/* TCPڑI܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 *	timeout		ؒf҂^CAEg[ms]B
 *			w肳ꂽAlg܂B(2005/09/19݁A1bł)
 *			^CAEgOCLOSEDԂƂȂꍇAɏԂ܂B
 * [note]
 *	* o^̃NCAgo^悤ƂƁAG[I܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	~
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void tcp_close(TCPCLIENT* client, int timeout);

/* f[^M܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 *	data		f[^i[obt@̐擪AhXB
 *	maxlength	obt@̋eʁB
 * [out]
 *	߂l		Mobt@Ƀf[^L΁Af[^i[Af[^Ԃ܂B()
 *			Mobt@Ƀf[^AM\A܂́Aڑ҂ԂȂ΁A0Ԃ܂B
 *			Mobt@Ƀf[^AMIԂȂ΁AԂ܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
int tcp_recv(TCPCLIENT* client, void* data/*[maxlength]*/, int maxlength);

/* f[^𑗐M܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 *	data		Mf[^̐擪AhXB
 *	length		f[^B
 * [out]
 *	߂l		M\ԂȂ΁AۂɑMf[^Ԃ܂B(0A܂́A)
 *			ڑ҂ԂȂ΁A0Ԃ܂B
 *			MIԂȂ΁AԂ܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
int tcp_send(TCPCLIENT* client, const void* data/*[length]*/, int length);

/****************************************************************************
 *	TCP\Pbg
 ****************************************************************************/

/* TCP\Pbg\ */
typedef struct _TCPSOCKET {
	TCPCLIENT tcp_client;	/* TCPNCAgo^p */
} TCPSOCKET;

/*--------------------------------------------------------------------------*/

/* TCP\PbgJ܂B
 * [in]
 *	local_port		[J|[gB
 *				ActiveOpen ̏ꍇ: wA܂́Aȗ(0)\łBʏ́Aȗ܂B
 *				PassiveOpen̏ꍇ: wA܂́Aȗ(0)\łBʏ́Aw肵܂B
 *				̏ꍇAȗƁAIɃGtF|[g蓖Ă܂B
 *	remote_ip_address	[gIPAhXB
 *				ActiveOpen ̏ꍇ: wK{łB
 *				PassiveOpen̏ꍇ: wA܂́Aȗ(0)\łBʏ́Aȗ܂B
 *				                   w肷ƁÃ[gIPAhX̐ڑ󂯓܂B
 *				                   ȗƁACӂ̃[gIPAhX̐ڑ󂯓܂B
 *	remote_port		[g|[gB
 *				ActiveOpen ̏ꍇ: wK{łB
 *				PassiveOpen̏ꍇ: wA܂́Aȗ(0)\łBʏ́Aȗ܂B
 *				                   w肷ƁÃ[g|[g̐ڑ󂯓܂B
 *				                   ȗƁACӂ̃[g|[g̐ڑ󂯓܂B
 *	active			PassiveOpenȂ΁A0w肵ĂB
 *				ActiveOpen Ȃ΁A1w肵ĂB
 * [out]
 *	߂l			TCP\PbgB
 * [note]
 *	* ʓIȁAActiveOpeňĂяóÂ悤ɂȂ܂B
 *		tcp_socket = tcp_socket_open(0, IP_ADDRESS(192,168,1,1), 80, 1); // 192.168.1.1:80֐ڑ
 *	* ʓIȁAPassiveOpeňĂяóÂ悤ɂȂ܂B
 *		tcp_socket = tcp_socket_open(80, 0, 0, 0); // |[gԍ80ŔCӂ̃[gڑ҂
 *	* ̊֐́Aɐ܂B
 *	  ڑ́AobNOEhŐis܂B
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
TCPSOCKET* tcp_socket_open(int local_port, int remote_ip_address, int remote_port, int active);

/* TCP\Pbg܂B
 * [in]
 *	tcp_socket		TCP\PbgB
 *	timeout			ؒf҂^CAEg[ms]B
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	~
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
void tcp_socket_close(TCPSOCKET* tcp_socket, int timeout);

/* TCP\PbgAf[^ǂݏo܂B
 * [in]
 *	tcp_socket		TCP\PbgB
 *	data			f[^i[obt@̐擪AhXB
 *	maxlength		obt@̋eʁB
 * [out]
 *	߂l			tcp_recv()QƂĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
int tcp_socket_recv(TCPSOCKET* tcp_socket, void* data/*[maxlength]*/, int maxlength);

/* TCP\PbgցAf[^݂܂B
 * [in]
 *	tcp_socket		TCP\PbgB
 *	data			Mf[^̐擪AhXB
 *	length			f[^B
 * [out]
 *	߂l			tcp_send()QƂĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
int tcp_socket_send(TCPSOCKET* tcp_socket, const void* data/*[length]*/, int length);

/* TCP\Pbg̏Ԃ擾܂B
 * [in]
 *	tcp_socket		TCP\PbgB
 * [out]
 *	߂l			ԁB
 * [note]
 *	* TCP̂AԂQƂ@ƍlAvO̓ǂ݈Ղ̂߂ɁA{֐pӂ܂B
 *	  ȊOTCPA[J|[gA[gIPAhXA[g|[gȂǂ́AڎQƂĂB
 */
static inline int tcp_socket_state(TCPSOCKET* tcp_socket) { return tcp_socket->tcp_client.state; }

#endif /*__CLIP_TCP_H__*/
