/*
 *	cliptapx.c
 *
 *	TAP~LT[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Fri Sep 18 22:38:30 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static void TapMxrCh_Exec(ST_TapMxr* pTapMxr, int iMxrCh, int iElapTime);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//~LT[𓮓Iɍ쐬B
ST_TapMxr* TapMxr_New(int nMxrCh) {
	ST_TapMxr* pTapMxr;
	if(((nMxrCh < 1) || (nMxrCh > 32))) { DIE(); }	//~LT[`l͈͊OȂ΃G[
	//mۂB
	pTapMxr = malloc(sizeof(ST_TapMxr) +		//~LT[
		(sizeof(ST_TapMxrCh) * nMxrCh));	//~LT[`l
	if(!pTapMxr) { DIE(); }
	//~LT[ÓIɏB
	TapMxr_Init(pTapMxr, nMxrCh);
	return pTapMxr;
}
/*---------------------------------------------------------------------------*/
//~LT[ÓIɏB
void TapMxr_Init(ST_TapMxr* pTapMxr, int nMxrCh) {
	int iMxrCh;
	if(((nMxrCh < 1) || (nMxrCh > 32))) { DIE(); }	//~LT[`l͈͊OȂ΃G[
	//~LT[`li[B
	pTapMxr->nMxrCh = nMxrCh;
	//~LT[`lNAB
	for(iMxrCh = 0; iMxrCh < pTapMxr->nMxrCh; iMxrCh++) {
		ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
		memset(pMxrCh, 0, sizeof(ST_TapMxrCh));
	}
}
/*---------------------------------------------------------------------------*/
//Iɍ쐬~LT[JB
void TapMxr_Free(ST_TapMxr* pTapMxr) {
	free(pTapMxr);
}
/*---------------------------------------------------------------------------*/
//~LT[sB
void TapMxr_Exec(ST_TapMxr* pTapMxr, int iElapTime) {
	int iMxrCh;
	if(iElapTime <    0) { iElapTime =    0; }	//oߎԂ0bȂ΁A0bɕ␳B
	if(iElapTime > 1000) { iElapTime = 1000; }	//oߎԂ1b߂Ȃ΁A1bɕ␳B
	//~LT[`lsB
	for(iMxrCh = 0; iMxrCh < pTapMxr->nMxrCh; iMxrCh++) {
		TapMxrCh_Exec(pTapMxr, iMxrCh, iElapTime);
	}
}
/*---------------------------------------------------------------------------*/
void TapMxrCh_SetAtt(ST_TapMxr* pTapMxr, int iMxrCh, int iAttTo, int iRate, int iScale) {
	//~LT[`l擾B
	ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
ENTER_CS;
	//p[^łAVωJnBp[^Ȃ΁A݂̕ωpB
	if((pMxrCh->iAttTo != iAttTo) || (pMxrCh->iRate != iRate) || (pMxrCh->iScale != iScale)) {
		//p[^i[B
		pMxrCh->iAttTo   = iAttTo;	//ڕW
		pMxrCh->iRate    = iRate;	//ʕωx(q)
		pMxrCh->iScale   = iScale;	//ʕωx()
		pMxrCh->iErrTerm = 0;		//덷
		//ʕωx̃p[^Еł0(=f)Ȃ΁AڕWʂ݌ʂ֑fB
		if(!iRate || !iScale) { pMxrCh->iAttNow = iAttTo; }
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
int TapMxr_GetAtt(ST_TapMxr* pTapMxr, int iMxrChMask) {
	//~LT[`lz̐擪AhX擾B
	ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, 0);
	//~LT[`l}XÑ~LT[`lȏ̃rbgmɃNAāAϐɊi[B
	unsigned uMxrChMask = iMxrChMask & ~(-1 << pTapMxr->nMxrCh);
	//݌ʂ̍v0ƂĂB
	int iAtt = 0;
	do {
		//̃~LT[`lKpȂ΁A݌ʂZB
		if(uMxrChMask & 1) { iAtt += pMxrCh->iAttNow; }	//iAttNow8bittB[hȂ̂ŁAv32bit𒴂鎖͂܂B
		//~LT[`l֐i߂B
		pMxrCh++;
	} while((uMxrChMask >>= 1));	//~LT[`l}XNVtgA1̃rbgȂ烋[v𔲂B
	//݌ʂ̍vԂB
	return iAtt;
}
/*---------------------------------------------------------------------------*/
//~LT[`l擾B
ST_TapMxrCh* TapMxr_GetMxrCh(ST_TapMxr* pTapMxr, int iMxrCh) {
	if((unsigned)iMxrCh >= (unsigned)pTapMxr->nMxrCh) { DIE(); }	//~LT[`lԍ͈͊OȂ΃G[
	return (ST_TapMxrCh*)(pTapMxr + 1) + iMxrCh;
}
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//~LT[`lsB
static void TapMxrCh_Exec(ST_TapMxr* pTapMxr, int iMxrCh, int iElapTime) {
	//~LT[`l擾B
	ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
	//݌ʂƖڕWʂ擾B
	int iAttNow = pMxrCh->iAttNow;	//݌
	int iAttTo  = pMxrCh->iAttTo;	//ڕW
	//݌ʂƖڕWʂقȂȂ(=ωȂ)c
	if(iAttNow != iAttTo) {
		//덷(iRate~oߎ)ZAiScaleŏčωʂ߂B
		div_t d = div(
			pMxrCh->iErrTerm + (pMxrCh->iRate * iElapTime),
			pMxrCh->iScale);
		//ωʂcA덷ɏ߂B
		pMxrCh->iErrTerm = d.rem;
		//ωʂA݌ʂɔfB
		if(iAttNow < iAttTo) { if((iAttNow += d.quot) > iAttTo) { iAttNow = iAttTo; } }	//ω̏ꍇ
		else                 { if((iAttNow -= d.quot) < iAttTo) { iAttNow = iAttTo; } }	//ω̏ꍇ
		//݌ʂ߂B
		pMxrCh->iAttNow = iAttNow;
	}
}
