/*
 *	cliptaps.h
 *
 *	TAPV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sun Sep 13 20:50:05 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __CLIP_TAPS_H__
#define __CLIP_TAPS_H__
/*****************************************************************************
 *	萔A\
 *****************************************************************************/
//foCX`l
typedef struct _ST_TapDevCh {
	uint8_t			iLogCh;				//+ 0,  1 ̃foCX`l𐧌䂵Ă_`lԍ	UINT8_MAX=(~Ӗ)
} ST_TapDevCh;							//= 1
/*---------------------------------------------------------------------------*/
//_`l
typedef struct _ST_TapLogCh {
	uint16_t		iPhr;				//+ 0,  2 t[Yԍ						UINT16_MAX=(~Ӗ)
	uint8_t			iLoop;				//+ 2,  1 [v						0=[v
	uint8_t			iAtt;				//+ 3,  1 
	 int8_t			iPan;				//+ 4,  1 p
	uint8_t			iDevCh;				//+ 5,  1 ̘_`l䂵ĂfoCX`lԍ	UINT8_MAX=(~,,ĐJnɃfoCX`lloȂ,,ĐJnɃfoCX`l肳ꂽӖ)
	uint8_t			iSeqCh;				//+ 6,  1 ̘_`l𐧌䂵ĂV[PT`lԍ	UINT8_MAX=(V[PT`lɐ䂳ĂȂӖB~Ӗ̂ł͂Ȃɒӂ)
	uint8_t			iCont;				//+ 7,  1 [vt[Yp[ms]
	 int32_t		iWait;				//+ 8,  4 ҂[ms]
} ST_TapLogCh;							//=12
/*---------------------------------------------------------------------------*/
//V[PT`l
typedef struct _ST_TapSeqCh {
	const uint8_t*		pData;				//+ 0,  4 V[PXf[^					NULL=(~Ӗ)
	 int32_t		iWait;				//+ 4,  4 ҂[ms]
} ST_TapSeqCh;							//= 8
/*---------------------------------------------------------------------------*/
//
typedef struct _ST_TapSeqInfo {
	uint16_t		nPhr;				//+ 0,  2 t[Y						1`UINT16_MAX
	uint8_t			nDevCh;				//+ 2,  1 foCX`l					1`UINT8_MAX
	uint8_t			nLogCh;				//+ 3,  1 _`l					1`UINT8_MAX
	uint8_t			nSeqCh;				//+ 4,  1 V[PT`l					1`UINT8_MAX
	uint8_t			iCont;				//+ 5,  1 [vt[Yp[ms]			0`UINT8_MAX	0Ȃ΃[vt[YpsȂB
								//+ 6,  2 (pfBO)
	void (*fnPlay)(int iLogCh, ST_TapLogCh* pLogCh);	//+ 8,  4 ĐJnʒm
	void (*fnStop)(int iLogCh, ST_TapLogCh* pLogCh);	//+12,  4 Đ~ʒm
	void (*fnLoop)(int iLogCh, ST_TapLogCh* pLogCh);	//+16,  4 R[vʒm					fnPlayƓR[obN֐ݒ肵ĂǂB
	void (*fnEnd )(int iLogCh, ST_TapLogCh* pLogCh);	//+20,  4 R~ʒm						fnStopƓR[obN֐ݒ肵ĂǂB
	void (*fnCtrl)(int iLogCh, ST_TapLogCh* pLogCh);	//+24,  4 Rg[ʒm
	int  (*fnGetPhrTime)(int iPhr);				//+28,  4 t[Y[ms]擾B				(0`INT_MAX)ԂB
	int  (*fnGetPhrNext)(int iPhr);				//+32,  4 t[Y`FC̎̃t[Yԍ擾B	ʏt[YȂ-1ԂBSt[YȂ-2ԂBԃt[YȂ0`(nPhr-1),,iPhrȊO̒lԂB[vt[YȂiPhrԂB
	const uint8_t*		TBL_TapSet[0/*nLogCh*/];	//+36, 4N TAPZbg
} ST_TapSeqInfo;						//= ?
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//dv
//AvP[V`̃R[obN֐̒AW[̊֐ĂяoĂ͂ȂB
//W[̎́AR[obN֐̌ĂяoɁAW[̓ԂωȂOƂĂB
//AR[obN֐̒瓖W[̊֐ĂяoƁAԂωė\łȂ쌋ʂƂȂB
/*---------------------------------------------------------------------------*/
//V[PT
typedef struct _ST_TapSeq {
	const ST_TapSeqInfo*	pInfo;				//+ 0,  4 
    //	ST_TapDevCh		TBL_DevCh[(nDevCh+3)&~3];	//+ 4, 1N foCX`l
    //	ST_TapLogCh		TBL_LogCh[ nLogCh      ];	//+ ?,12N _`l
    //	ST_TapSeqCh		TBL_SeqCh[ nSeqCh      ];	//+ ?, 8N V[PT`l
} ST_TapSeq;							//= ?
/*****************************************************************************
 *	O[o֐錾
 *****************************************************************************/
//V[PT
ST_TapSeq* TapSeq_New(const ST_TapSeqInfo* pInfo);
void TapSeq_Init(ST_TapSeq* pTapSeq, const ST_TapSeqInfo* pInfo);
void TapSeq_Free(ST_TapSeq* pTapSeq);
void TapSeq_Exec(ST_TapSeq* pTapSeq, int iElapTime);
//_`l
void TapLogCh_Play(ST_TapSeq* pTapSeq, int iLogCh, int iPhr, int iLoop, int iAtt, int iPan);
void TapLogCh_Stop(ST_TapSeq* pTapSeq, int iLogCh);
void TapLogCh_Ctrl(ST_TapSeq* pTapSeq, int iLogCh, int iAtt, int iPan);
//V[PT`l
void TapSeqCh_Play(ST_TapSeq* pTapSeq, int iSeqCh, const void* pData);
void TapSeqCh_Stop(ST_TapSeq* pTapSeq, int iSeqCh);
//
ST_TapDevCh* TapSeq_GetDevCh(ST_TapSeq* pTapSeq, int iDevCh);
ST_TapLogCh* TapSeq_GetLogCh(ST_TapSeq* pTapSeq, int iLogCh);
ST_TapSeqCh* TapSeq_GetSeqCh(ST_TapSeq* pTapSeq, int iSeqCh);
/****************************************************************************
 *	dTapSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#define USE_TAPDEF_BIN	//[eBeB֐svȂ΂̃V{`RgAEgĂB
#ifdef  USE_TAPDEF_BIN
void TapSeqCh_PlayNo(ST_TapSeq* pTapSeq, int iTapSeqCh, const void* pTapDefBin, int iTapSeqNo);
#endif//USE_TAPDEF_BIN
#endif//__CLIP_TAPS_H__
