/*
 *	cliptaps.c
 *
 *	TAPV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sun Sep 13 20:50:05 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"
//#define PRODUCT_SPECIFIC_WORKAROUND//̃V{`ƁAiŗL̒sB
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static void TapSeqInfo_Verify(const ST_TapSeqInfo* pInfo);
static int TapSeq_GetPhrNext(ST_TapSeq* pTapSeq, int iPhr);
static int TapSeq_GetPhrTime(ST_TapSeq* pTapSeq, int iPhr);
static int TapSeq_GetPhrType(ST_TapSeq* pTapSeq, int iPhr);
static void TapSeq_AcqLogCh(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_PlaySubr(ST_TapSeq* pTapSeq, int iLogCh, int iPhr);
static void TapLogCh_LoopSubr(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_StopSubr(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_Exec(ST_TapSeq* pTapSeq, int iLogCh, int iElapTime);
static void TapSeqCh_Exec(ST_TapSeq* pTapSeq, int iSeqCh, int iElapTime);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//V[PT𓮓Iɍ쐬B
ST_TapSeq* TapSeq_New(const ST_TapSeqInfo* pInfo) {
	ST_TapSeq* pTapSeq;
	//B
	TapSeqInfo_Verify(pInfo);
	//mۂB
	pTapSeq = malloc(sizeof(ST_TapSeq) +				//V[PT
		(sizeof(ST_TapDevCh) * ((pInfo->nDevCh+3)&~3)) +	//foCX`l
		(sizeof(ST_TapLogCh) *   pInfo->nLogCh       ) +	//_`l
		(sizeof(ST_TapSeqCh) *   pInfo->nSeqCh       ));	//V[PT`l
	if(!pTapSeq) { DIE(); }
	//V[PTÓIɏB
	TapSeq_Init(pTapSeq, pInfo);
	return pTapSeq;
}
/*---------------------------------------------------------------------------*/
//V[PTÓIɏB
void TapSeq_Init(ST_TapSeq* pTapSeq, const ST_TapSeqInfo* pInfo) {
	int iDevCh, iLogCh, iSeqCh;
	//B
	TapSeqInfo_Verify(pInfo);
	//i[B
	pTapSeq->pInfo = pInfo;
	//foCX`lNAB
	for(iDevCh = 0; iDevCh < pTapSeq->pInfo->nDevCh; iDevCh++) {
		ST_TapDevCh* pDevCh = TapSeq_GetDevCh(pTapSeq, iDevCh);
		pDevCh->iLogCh = -1;	//̃foCX`l𐧌䂵Ă_`lԍ	UINT8_MAX=(~Ӗ)
	}
	//_`lNAB
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
		pLogCh->iPhr   = -1;	//t[Yԍ						UINT16_MAX=(~Ӗ)
		pLogCh->iDevCh = -1;	//̘_`l䂵ĂfoCX`lԍ	UINT8_MAX=(~,,ĐJnɃfoCX`lloȂ,,ĐJnɃfoCX`l肳ꂽӖ)
		pLogCh->iSeqCh = -1;	//̘_`l𐧌䂵ĂV[PT`lԍ	UINT8_MAX=(V[PT`lɐ䂳ĂȂӖB~Ӗ̂ł͂Ȃɒӂ)
	}
	//V[PT`lNAB
	for(iSeqCh = 0; iSeqCh < pTapSeq->pInfo->nSeqCh; iSeqCh++) {
		ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
		pSeqCh->pData  = NULL;	//V[PXf[^					NULL=(~Ӗ)
	}
}
/*---------------------------------------------------------------------------*/
//Iɍ쐬V[PTJB
void TapSeq_Free(ST_TapSeq* pTapSeq) {
	free(pTapSeq);
}
/*---------------------------------------------------------------------------*/
//V[PTsB
void TapSeq_Exec(ST_TapSeq* pTapSeq, int iElapTime) {
	int iLogCh, iSeqCh;
	if(iElapTime <    0) { iElapTime =    0; }	//oߎԂ0bȂ΁A0bɕ␳B
	if(iElapTime > 1000) { iElapTime = 1000; }	//oߎԂ1b߂Ȃ΁A1bɕ␳B
	//_`lsB
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		TapLogCh_Exec(pTapSeq, iLogCh, iElapTime);
	}
	//̏K{łBtɂƃV[PTĐJn̘_`l̑҂Ԃ炵Ă܂ꂪL܂B
	//V[PT`lsB
	for(iSeqCh = 0; iSeqCh < pTapSeq->pInfo->nSeqCh; iSeqCh++) {
		TapSeqCh_Exec(pTapSeq, iSeqCh, iElapTime);
	}
}
/*---------------------------------------------------------------------------*/
//_`lĐJnB
void TapLogCh_Play(ST_TapSeq* pTapSeq, int iLogCh, int iPhr, int iLoop, int iAtt, int iPan) {
	int iPhrType;
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//̘_`l𐧌䂵ĂV[PT`lԍAmɃNAB
	// - AvP[V璼ڌĂяoꂽꍇ́A(pLogCh->iSeqCh=-1)̂܂܂ƂȂB
	// - V[PTĂяoꂽꍇ́Å֐ԂɁAV[PT̒pLogCh->iSeqChݒ肷B
	pLogCh->iSeqCh = -1;
	//[vt[YpԂAmɃNAB
	// - ݂̍ĐpꍇA擪ĐJnꍇAǂɂKvȏȂ̂ŁAōŝǂB
	pLogCh->iCont  = 0;
	//ĐJnt[Ỹt[Y`FC̍Ō̃t[ÝAt[Yʂ擾B
	iPhrType = TapSeq_GetPhrType(pTapSeq, iPhr);
	//ĐJnt[Ỹt[Y`FC̍Ō̃t[YA[vt[YȂ΁c
	// - ʏt[Y(-1),,St[Y(-2)Ȃ΁AL̔fs킸AɁA݂̍Đ~擪ĐJnB
	if(iPhrType >= 0) {
		//_`lĐȂ΁c
		if(pLogCh->iPhr != UINT16_MAX) {
			//Đ̃t[Y̍Ō̃t[Y[vt[Ył,,ĐJnt[YƓt[Y`FCȂ΁AĐJns킸Ɍ݂̍ĐpB
			//Đ̃t[Y̍Ō̃t[Y[vt[YȊO,,ĐJnt[Yƕʂ̃t[Y`FCȂ΁A݂̍Đ~擪ĐJnB
			if(TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) == iPhrType) {
				//_`ľʂƃpύXB
				// - ĐJns킸Ɍ݂̍Đp鎞Aʂƃp͐VlKpKvLB
				TapLogCh_Ctrl(pTapSeq, iLogCh, iAtt, iPan);
				return;	//܂
			}
		}
		//ĐJnt[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ̂ŁA[v񐔂𖳌[vɒuB
		iLoop = 0;
	}
	//_`lmɍĐ~B
	TapLogCh_Stop(pTapSeq, iLogCh);
	//[v񐔂i[B
	pLogCh->iLoop = iLoop;
	//ʂi[B
	pLogCh->iAtt  = iAtt;
	//pi[B
	pLogCh->iPan  = iPan;
	//҂ԂNAB
	// - ̌AĐJñTu[`̒ŁAt[YԂZB
	pLogCh->iWait = 0;
	//foCX`llB
	// - foCX`l̊lɎsꍇLB
	//   foCX`l̊lɎsꍇAȉ̏sB
	TapSeq_AcqLogCh(pTapSeq, iLogCh);
	//ĐJñTu[`sB
	TapLogCh_PlaySubr(pTapSeq, iLogCh, iPhr);
}
/*---------------------------------------------------------------------------*/
//_`lĐ~B
void TapLogCh_Stop(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//̘_`l𐧌䂵ĂV[PT`lԍAmɃNAB
	pLogCh->iSeqCh = -1;
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { return; }
	//Đ̃t[Ỹt[Y`FC̍Ō̃t[YASt[YȊOȂ΁c
	// - St[YȂ΁A_`l̓V[PT`l̐OAR~܂ŌpB
	if(TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) != -2/*St[Y*/) {
		//Đ~ʒmsB
		// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
		(*pTapSeq->pInfo->fnStop)(iLogCh, pLogCh);
		//Đ~̃Tu[`sB
		TapLogCh_StopSubr(pTapSeq, iLogCh);
	}
}
/*---------------------------------------------------------------------------*/
//_`ľʂƃpύXB
void TapLogCh_Ctrl(ST_TapSeq* pTapSeq, int iLogCh, int iAtt, int iPan) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { return; }
	//ʂƃpωȂ΁AɋAB
	if((pLogCh->iAtt == iAtt) && (pLogCh->iPan == iPan)) { return; }
	//ʂi[B
	pLogCh->iAtt = iAtt;
	//pi[B
	pLogCh->iPan = iPan;
	//Rg[ʒmsB
	// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
	(*pTapSeq->pInfo->fnCtrl)(iLogCh, pLogCh);
}
/*---------------------------------------------------------------------------*/
//V[PT`lĐJnB
void TapSeqCh_Play(ST_TapSeq* pTapSeq, int iSeqCh, const void* pData) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
ENTER_CS;
	//V[PT`lmɍĐ~B
	TapSeqCh_Stop(pTapSeq, iSeqCh);
	//V[PXf[^i[B
	pSeqCh->pData = pData;
	//҂ԂNAB
	pSeqCh->iWait = 0;
	//V[PXf[^̐擪Ɂu҂Ԗv̏L΁AsB
	TapSeqCh_Exec(pTapSeq, iSeqCh, 0);
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//V[PT`lĐ~B
void TapSeqCh_Stop(ST_TapSeq* pTapSeq, int iSeqCh) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
	int iLogCh;
ENTER_CS;
	//V[PXf[^NAB
	pSeqCh->pData = NULL;
	//e_`lɂāc
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
		//̃V[PT`l䂵Ă_`lȂ΁c
		if(pLogCh->iSeqCh == iSeqCh) {
			//̘_`l𐧌䂵ĂV[PT`lԍNAB
			// - ̉̏TapLogCh_Stop()Ăяoꍇ́A(pLogCh->iSeqCh=-1)xsɂȂAʂQ͖B
			pLogCh->iSeqCh = -1;
			//_`lĐȂ΁c
			// - KĐł͂AÔ߂ɊmF鎖ɂB
			if(pLogCh->iPhr != UINT16_MAX) {
				//AvP[V`̃[vt[YpԂ0łȂ,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ΁c
				if(pTapSeq->pInfo->iCont && (TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) >= 0)) {
					//[vt[YpԂ܂JnĂȂ΁A[vt[YpԂJnB
					// - [vpԓɍēx̏sꂽꍇ́A[vpԂĊJȂB
					if(!pLogCh->iCont) { pLogCh->iCont = pTapSeq->pInfo->iCont; }
				//AvP[V`̃[vt[YpԂ0,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YłȂ΁c
				} else {
					//_`lĐ~B
					TapLogCh_Stop(pTapSeq, iLogCh);
				}
			}
		}
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//foCX`l擾B
ST_TapDevCh* TapSeq_GetDevCh(ST_TapSeq* pTapSeq, int iDevCh) {
	if((unsigned)iDevCh >= (unsigned)pTapSeq->pInfo->nDevCh) { DIE(); }	//foCX`lԍ͈͊OȂ΃G[
	return (ST_TapDevCh*)(pTapSeq + 1) + iDevCh;
}
/*---------------------------------------------------------------------------*/
//_`l擾B
ST_TapLogCh* TapSeq_GetLogCh(ST_TapSeq* pTapSeq, int iLogCh) {
	if((unsigned)iLogCh >= (unsigned)pTapSeq->pInfo->nLogCh) { DIE(); }	//_`lԍ͈͊OȂ΃G[
	return (ST_TapLogCh*)(TapSeq_GetDevCh(pTapSeq, 0) + ((pTapSeq->pInfo->nDevCh+3)&~3)) + iLogCh;
}
/*---------------------------------------------------------------------------*/
//V[PT`l擾B
ST_TapSeqCh* TapSeq_GetSeqCh(ST_TapSeq* pTapSeq, int iSeqCh) {
	if((unsigned)iSeqCh >= (unsigned)pTapSeq->pInfo->nSeqCh) { DIE(); }	//V[PT`lԍ͈͊OȂ΃G[
	return (ST_TapSeqCh*)(TapSeq_GetLogCh(pTapSeq, 0) + pTapSeq->pInfo->nLogCh) + iSeqCh;
}
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
//B
static void TapSeqInfo_Verify(const ST_TapSeqInfo* pInfo) {
	int iDevCh, iLogCh;
	if(!pInfo->nPhr		||		//t[Y				1`UINT16_MAX
	   !pInfo->nDevCh	||		//foCX`l			1`UINT8_MAX
	   !pInfo->nLogCh	||		//_`l			1`UINT8_MAX
	   !pInfo->nSeqCh	||		//V[PT`l			1`UINT8_MAX
	// !pInfo->iCont	||		//[vt[Yp[ms]	0`UINT8_MAX
	   !pInfo->fnPlay	||		//ĐJnʒm
	   !pInfo->fnStop	||		//Đ~ʒm
	   !pInfo->fnLoop	||		//R[vʒm
	   !pInfo->fnEnd	||		//R~ʒm
	   !pInfo->fnCtrl	||		//Rg[ʒm
	   !pInfo->fnGetPhrTime	||		//t[Y[ms]擾B
	   !pInfo->fnGetPhrNext) { DIE(); }	//t[Y`FC̎̃t[Yԍ擾B
	for(iLogCh = 0; iLogCh < pInfo->nLogCh; iLogCh++) {
		const uint8_t* pTapSet = pInfo->TBL_TapSet[iLogCh];	//TAPZbg
		uint8_t mask[256/8];
		memset(mask, 0, sizeof mask);
		while((iDevCh = *pTapSet++) != UINT8_MAX) {	//TAPZbg(擪UINT8_MAX)ƂBtF[_[Ƃėp_`ĺAfoCX`l̊lsvłꍇɁATAPZbgݒ肹B
			if((unsigned)iDevCh >= (unsigned)pInfo->nDevCh) { DIE(); }	//foCX`lԍ͈͊OȂ΃G[
			if(mask[iDevCh/8] &  (1<<(iDevCh&7))) { DIE(); }		//̘_`lTAPZbgŁAfoCX`lԍ𕡐w肵Ă͂ȂB
			   mask[iDevCh/8] |= (1<<(iDevCh&7));
		}
	}
}
/*---------------------------------------------------------------------------*/
//t[Y[ms]擾B
static int TapSeq_GetPhrTime(ST_TapSeq* pTapSeq, int iPhr) {
	int iTime;
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
	iTime = (*pTapSeq->pInfo->fnGetPhrTime)(iPhr);
	if(iTime < 0) { DIE(); }						//(0`INT_MAX)͈̔͊OȂ΃G[		Œ~ꍇ̓AvP[V`̃R[obN֐̃oOł\B
	return iTime;
}
/*---------------------------------------------------------------------------*/
//t[Y`FC̎̃t[Yԍ擾B
static int TapSeq_GetPhrNext(ST_TapSeq* pTapSeq, int iPhr) {
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
	iPhr = (*pTapSeq->pInfo->fnGetPhrNext)(iPhr);
	if((iPhr < -2) || (iPhr >= pTapSeq->pInfo->nPhr)) { DIE(); }		//-2,,t[Yԍ͈͊OȂ΃G[	Œ~ꍇ̓AvP[V`̃R[obN֐̃oOł\B
	return iPhr;
}
/*---------------------------------------------------------------------------*/
//t[Y`FC̍Ō̃t[ÝAt[Yʂ擾B
static int TapSeq_GetPhrType(ST_TapSeq* pTapSeq, int iPhr) {
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
	for(;;) {
		int iPhrNext = TapSeq_GetPhrNext(pTapSeq, iPhr);
		if(iPhrNext <     0) { return iPhrNext; }	//-1=ʏt[Y,,-2=St[Y
		if(iPhrNext == iPhr) { return iPhr;     }	//0ȏ=[vt[Y
		iPhr = iPhrNext;
	}
}
/*---------------------------------------------------------------------------*/
//foCX`llB
static void TapSeq_AcqLogCh(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh;
	ST_TapDevCh* pDevCh;
	const uint8_t* pTapSet;
	int iDevCh, iDevChSel, iLogChMax;
	//_`l擾B
	pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`lAɃfoCX`l𐧌䂵Ă鎖́AN蓾Ȃ͂łB
	if(pLogCh->iDevCh != UINT8_MAX) { DIE(); }	//ŃG[~ꍇA֐ĂяoOTapLogCh_Stop()ĂяoAYĂ\B
	//TAPZbg(̘_`lŎgpfoCX`lԍ̃Xg)擾B
	pTapSet = pTapSeq->pInfo->TBL_TapSet[iLogCh];
	//foCX`lԍ(-1)Cő̘_`lԍ̘_`lԍƂĂB
	iDevChSel = -1, iLogChMax = iLogCh;
	//TAPZbg̏I[(UINT8_MAX)ɓB܂Łc
	while((iDevCh = *pTapSet++) != UINT8_MAX) {	//TAPZbg(擪UINT8_MAX)ƂBtF[_[Ƃėp_`ĺAfoCX`l̊lsvłꍇɁATAPZbgݒ肹B
		//foCX`l擾B
		pDevCh = TapSeq_GetDevCh(pTapSeq, iDevCh);
		//foCX`lAɂ̘_`lɐ䂳Ă鎖́AN蓾Ȃ͂łB
		if(pDevCh->iLogCh == iLogCh) { DIE(); }
		//foCX`l𐧌䂵Ă_`lA̘_`l傫,,~(UINT8_MAX)Ȃ΁AfoCX`lloB
		//~̃foCX`lL΂lA~̃foCX`l΁Aő̘_`lԍɐ䂳ĂfoCX`llB
		//̘_`l傫_`lԍɐ䂳ĂfoCX`l΁AlɎsB
		if(pDevCh->iLogCh > iLogChMax) {
			iDevChSel = iDevCh;
			iLogChMax = pDevCh->iLogCh;
		}
	}
	//foCX`lloc
	if(iDevChSel != -1) {
		//̘_`l䂵ĂfoCX`lԍi[B
		pLogCh->iDevCh = iDevChSel;
		//foCX`l擾B
		pDevCh = TapSeq_GetDevCh(pTapSeq, iDevChSel);
		//̃foCX`lA̘_`lɐ䂳Ăc
		if(pDevCh->iLogCh != UINT8_MAX) {
			//̃foCX`l𐧌䂵Ă_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, pDevCh->iLogCh);
			//̘_`l䂵ĂfoCX`lÃfoCX`lł鎖mFB
			if(pLogCh->iDevCh != iDevChSel) { DIE(); }
			//̘_`l䂵ĂfoCX`lANAB
			pLogCh->iDevCh = -1;
		}
		//̃foCX`l𐧌䂵Ă_`lԍi[B
		pDevCh->iLogCh = iLogCh;
	}
}
/*---------------------------------------------------------------------------*/
//ĐJñTu[`B
static void TapLogCh_PlaySubr(ST_TapSeq* pTapSeq, int iLogCh, int iPhr) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//t[Yԍi[B
	pLogCh->iPhr   = iPhr;
	//t[YԂ擾A҂ԂɉZB
	pLogCh->iWait += TapSeq_GetPhrTime(pTapSeq, pLogCh->iPhr);
	//ĐJnʒmsB
	// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
	(*pTapSeq->pInfo->fnPlay)(iLogCh, pLogCh);
}
/*---------------------------------------------------------------------------*/
//R[ṽTu[`B
static void TapLogCh_LoopSubr(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//t[YԂ擾A҂ԂɉZB
	pLogCh->iWait += TapSeq_GetPhrTime(pTapSeq, pLogCh->iPhr);
	//R[vʒmsB
	// - ̘_`l䂵ĂfoCX`lꍇŗǂB
	(*pTapSeq->pInfo->fnLoop)(iLogCh, pLogCh);
}
/*---------------------------------------------------------------------------*/
//Đ~̃Tu[`B
static void TapLogCh_StopSubr(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`l~ƂB
	pLogCh->iPhr = -1;
	//̘_`l䂵ĂfoCX`lL΁c
	if(pLogCh->iDevCh != UINT8_MAX) {
		//foCX`l擾B
		ST_TapDevCh* pDevCh = TapSeq_GetDevCh(pTapSeq, pLogCh->iDevCh);
		//̃foCX`l𐧌䂵Ă_`lA̘_`lł鎖mFB
		if(pDevCh->iLogCh != iLogCh) { DIE(); }
		//foCX`l~ƂB
		pDevCh->iLogCh = -1;
		//̘_`l䂵ĂfoCX`lANAB
		pLogCh->iDevCh = -1;
	}
}
/*---------------------------------------------------------------------------*/
//_`lsB
static void TapLogCh_Exec(ST_TapSeq* pTapSeq, int iLogCh, int iElapTime) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { return; }
	//[vt[YpԂJnĂc
	if(pLogCh->iCont) {
		//[vt[YpԂ炷B
		UVAR_SUB(pLogCh->iCont, iElapTime);
		//[vt[YpԂ0ɂȂc
		if(!pLogCh->iCont) {
			//Đ~ʒmsB
			// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
			(*pTapSeq->pInfo->fnStop)(iLogCh, pLogCh);
			//Đ~̃Tu[`sB
			TapLogCh_StopSubr(pTapSeq, iLogCh);
			return;	//܂
		}
	}
	//҂Ԃ炷B
	VAR_SUB(pLogCh->iWait, iElapTime);
	//҂Ԃ0ȉłԁAJԂB
	while(pLogCh->iWait <= 0) {
		//̃t[Y擾B
		int iPhr = TapSeq_GetPhrNext(pTapSeq, pLogCh->iPhr);
		//݂̃t[YAʏt[YȂ΁c
		if(iPhr == -1) {
			//[vłȂ,,[v񐔂炵0ɂȂc
			if(pLogCh->iLoop && !--pLogCh->iLoop) {
				//R~ʒmsB
				// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
				(*pTapSeq->pInfo->fnEnd)(iLogCh, pLogCh);
				//Đ~̃Tu[`sB
				TapLogCh_StopSubr(pTapSeq, iLogCh);
				return;	//܂
			//[v,,[v񐔂炵0ɂȂȂ΁c
			} else {
				//R[ṽTu[`sB
				TapLogCh_LoopSubr(pTapSeq, iLogCh);
			}
		//݂̃t[YA[vt[YȂ΁c
		} else if(iPhr == pLogCh->iPhr) {
			//R[ṽTu[`sB
			TapLogCh_LoopSubr(pTapSeq, iLogCh);
		//݂̃t[YAԃt[YȂ΁c
		} else {
			//ĐJñTu[`sB
			TapLogCh_PlaySubr(pTapSeq, iLogCh, iPhr);
		}
	}
}
/*---------------------------------------------------------------------------*/
//V[PT`lsB
static void TapSeqCh_Exec(ST_TapSeq* pTapSeq, int iSeqCh, int iElapTime) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
	ST_TapLogCh* pLogCh;
	int iData, iTime, iLogCh, iPhr, iLoop, iAtt, iPan;
	//V[PT`l~Ȃ΁AɋAB
	if(!pSeqCh->pData) { return; }
	//҂Ԃ炷B
	VAR_SUB(pSeqCh->iWait, iElapTime);
	//҂Ԃ0ȉłԁAJԂB
	while(pSeqCh->iWait <= 0) {
		switch((iData = *pSeqCh->pData++)) {
		default:DIE();
		//V[PXf[^̏I[
		case 0x00://
			//V[PXf[^̏I[ŃXeCB
			pSeqCh->pData--;
			return;	//܂
		//1`4oCgEFCg
		case 0x01://(iTime-0x00001)[ 7: 0]								//1oCgEFCg͈̔ = 0x00001+(0`0x000000FF) [ms]
		case 0x02://(iTime-0x00101)[15: 8] (iTime-0x00101)[ 7: 0]					//2oCgEFCg͈̔ = 0x00101+(0`0x0000FFFF) [ms]
		case 0x03://(iTime-0x10101)[23:16] (iTime-0x10101)[15: 8] (iTime-0x10101)[ 7:0]			//3oCgEFCg͈̔ = 0x10101+(0`0x00FFFFFF) [ms]
		case 0x04://(iTime        )[31:24] (iTime        )[23:16] (iTime        )[15:8] (iTime)[7:0]	//4oCgEFCg͈̔ =         (0`0xFFFFFFFF) [ms]
			//EFCgԂ擾B
			iTime  = 0;
			if(iData == 0x04) { iTime = -0x01010101; }	//4oCgEFCgȂ4񃋁[v閈(+1)𑊎EB
			do {
				iTime <<= 8;
				iTime  += ((*pSeqCh->pData++) + 1);
			} while(--iData);
			//҂Ԃ𑝂₷B
			VAR_ADD(pSeqCh->iWait, iTime);
			break;
		//Rg[`FW
		case 0x05://iLogCh iAtt
		case 0x06://iLogCh      iPan
		case 0x07://iLogCh iAtt iPan
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
			//,p擾B
			iAtt   = pLogCh->iAtt; if(iData & 1) { iAtt =         *pSeqCh->pData++; }	//l:ݒl
			iPan   = pLogCh->iPan; if(iData & 2) { iPan = (int8_t)*pSeqCh->pData++; }	//l:ݒl
			//Rg[`FWsB
			TapLogCh_Ctrl(pTapSeq, iLogCh, iAtt, pLogCh->iPan);
			break;
			break;
		//_`lĐJn
		case 0x08://iLogCh iPhr[15:8] iPhr[7:0]                
		case 0x09://iLogCh iPhr[15:8] iPhr[7:0] iLoop          
		case 0x0A://iLogCh iPhr[15:8] iPhr[7:0]       iAtt     
		case 0x0B://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt     
		case 0x0C://iLogCh iPhr[15:8] iPhr[7:0]            iPan
		case 0x0D://iLogCh iPhr[15:8] iPhr[7:0] iLoop      iPan
		case 0x0E://iLogCh iPhr[15:8] iPhr[7:0]       iAtt iPan
		case 0x0F://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt iPan
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
			//t[Yԍ擾B
			iPhr   = *pSeqCh->pData++;
			iPhr <<= 8;
			iPhr  |= *pSeqCh->pData++;
			//,p,[v񐔂擾B
			iLoop  = 1; if(iData & 1) { iLoop =         *pSeqCh->pData++; }			//l:[v=1
			iAtt   = 0; if(iData & 2) { iAtt  =         *pSeqCh->pData++; }			//l:=0()
			iPan   = 0; if(iData & 4) { iPan  = (int8_t)*pSeqCh->pData++; }			//l:p=0()
			//_`lĐJnB
			TapLogCh_Play(pTapSeq, iLogCh, iPhr, iLoop, iAtt, iPan);
			//̘_`l𐧌䂵ĂV[PT`lԍݒ肷B
			pLogCh->iSeqCh = iSeqCh;
			break;
		//_`lĐ~
		case 0x10://iLogCh
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
#ifdef  PRODUCT_SPECIFIC_WORKAROUND
			//_`lĐ,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ΁A_`lĐ~R}h𖳎B
			if((pLogCh->iPhr != UINT16_MAX) && (TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) >= 0)) { break; }
#endif//PRODUCT_SPECIFIC_WORKAROUND
			//_`lĐ~B
			TapLogCh_Stop(pTapSeq, iLogCh);
			break;
		}
	}
}
/****************************************************************************
 *	dTapSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#ifdef  USE_TAPDEF_BIN
void TapSeqCh_PlayNo(ST_TapSeq* pTapSeq, int iTapSeqCh, const void* pTapDefBin, int iTapSeqNo) {
	const int* const TBL_TapSeqNo = pTapDefBin;						//oCi̐擪ɃAhXe[uLBAhX̓f[^{(BYTEz)̃CfNXłB
	const int nTapSeqNo = TBL_TapSeqNo[0];							//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
	const unsigned char* const TBL_TapSeq = (const unsigned char*)&TBL_TapSeqNo[nTapSeqNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
	if((iTapSeqNo <= 0) || (iTapSeqNo >= nTapSeqNo)) { DIE(); }
	TapSeqCh_Play(pTapSeq, iTapSeqCh, &TBL_TapSeq[TBL_TapSeqNo[iTapSeqNo]]);
}
#endif//USE_TAPDEF_BIN
/*****************************************************************************
 *	
 *****************************************************************************/
//:YMZ871ٰߏɂ
//YMZ871ٰߏͤƭقƎ@̋Ⴄ
//@ƭق̐ǂނƤȉ̂悤ȏłƓǂݎ̂:
////QƎ:YMZ871عƭ٣(5MZ871A40.pdf)3.4.1.3.ٰߏ
//for(;;) {
//  1Đ;
//  if(LOOP_x != 255) {
//    if(!LOOP_x) { break; }
//    LOOP_x--;
//  }
//}
//Aۂ̋琄Ƥۂ͈̓ȉ̂悤ɂȂĂƎv:
// = 0;
//for(;;) {
//  1Đ;
//  if( < 255) { ++; }
//  if( > LOOP_x) { break; }
//}
//@ȂΤLOOP_xωuԂPVUP_x=1sƋԂĂ܂
//ł͖肪L̂Ť@ł͂ȂAłɂȂĂ
//rLOOP_xPVUP_x=1sƤAɉɂȂ鎖mF
//]ĤL̐A͍ĂƎv
//:L𓥂܂Ă̒ӓ_
//عݒ`fnCtrlPVUP_x=1sۤLOOP_xpLogCh->iLoopݒ肵Ă͂Ȃ
//pLogCh->iLoop͏LAŌƂ(LOOP_x-)łLOOP_xƂ͈Ⴄl
//LOOP_xpLogCh->iLoopݒ肵PVUP_x=1sƤc񐔂]vɌĂ܂
//]ĤعݑfnPlaypLogCh->iLoopLĂKvL
//PNRCL=1Ă\Ȃغق͔ς킵̂ŤعݑŋLĂǂ낤
//L̏ͤ_ٖɋLĂKv͖޲ٖō\Ȃ
//PVUP_x=1sɂऍĐJnƓLOOP_xݒ肷邽߂̖ړI
