/*	
 *	clipsv.c
 *
 *	P/ECE SUPERVISION Video/Sound Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Thu Apr 14 05:55:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	Video
 ****************************************************************************/

SVVIDEO svvideo;

void
svvideo_reset(unsigned char ram[/*0x0000..0x0x5fdf*/])
{
	SVVIDEO* video = &svvideo;

	/* ܂NA܂B */
	memset(video, 0, sizeof(SVVIDEO));

	/* RAM/WX^ւ̃|C^i[܂B */
	video->ram = ram;
}

void
svvideo_write(int addr, int data)
{
	SVVIDEO* video = &svvideo;
	unsigned char* ram = video->ram;

	ram[addr] = data;

	/* ݂̂ƂAWX^݂ɂċN铮͂܂B */
	//switch(addr) {
	//case 0x2000:	/* x size (Ή) */
	//case 0x2001:	/* y size (Ή) */
	//case 0x2002:	/* horicontal offset in pixel */
	//case 0x2003:	/* vertical   offset in pixel */
	//}
}

/****************************************************************************
 *	Sound
 ****************************************************************************/

SVSOUND svsound;

void
svsound_reset(unsigned char ram[/*0x0000..0x5fff*/],
        const unsigned char rom[/*0x0000..0x7fff or 0xffff*/])
{
	SVSOUND* sound = &svsound;

	/* ܂NA܂B */
	memset(sound, 0, sizeof(SVSOUND));

	/* RAM/WX^ƁAROMC[Wւ̃|C^i[܂B */
	sound->ram = ram;
	sound->rom = rom;

	/* LFSR܂B */
	sound->noise.lfsr = 1;
}
void
svsound_write(int addr, int data)
{
	SVSOUND* sound = &svsound;
	unsigned char* ram = sound->ram;
	//
	SVSOUNDTONE* tone;
	SVSOUNDNOISE* noise;

	ram[addr] = data;

	switch(addr) {
	/*========== Tone ==========*/
	case 0x2010:
	case 0x2014:
		tone = &sound->tone[(addr >> 2) & 1];
		tone->period = data | (ram[addr + 1] & 7) << 8;
		if(tone->period >= 7) {
			tone->period *= 32;
		} else {
			tone->period = 0; /* Off */
		}
		return;
	case 0x2011:
	case 0x2015:
		tone = &sound->tone[(addr >> 2) & 1];
		tone->period = ram[addr - 1] | (data & 7) << 8;
		if(tone->period >= 7) {
			tone->period *= 32;
		} else {
			tone->period = 0; /* Off */
		}
		return;
	case 0x2012:
	case 0x2016:
		tone = &sound->tone[(addr >> 2) & 1];
		tone->volume = data & 15;
		return;
	//case 0x2013: (s)
	//case 0x2017: (s)
	// dlł́AԂ4/255bPʂŎw肷郌WX^AƂȂĂ̂łA
	// ԂǗƁACrystball̃Q[ŉȂȂĂ܂܂B
	// ̃G~[^łAԂ͊ǗĂȂ悤łB
	/*========== Noise ==========*/
	case 0x2028:
		noise = &sound->noise;
		noise->volume = data & 15;
		noise->period = data >> 4;
		return;
	//case 0x2029: (s)
	// dlł́AԂ4/255bPʂŎw肷郌WX^AƂȂĂ̂łA
	// ԂǗƁACrystball̃Q[ŉȂȂĂ܂܂B
	// ̃G~[^łAԂ͊ǗĂȂ悤łB
	case 0x202a:
		noise = &sound->noise;
		noise->on = (data >> 4) & 1;
		return;
	///*========== DMA ==========*/
	//case 0x2018: (Ή)
	//case 0x2019: (Ή)
	//case 0x201a: (Ή)
	//case 0x201b: (Ή)
	//case 0x201c: (Ή)
	}
}

void
svsound_mix(short wbuff[/*SVSOUNDBUFLEN*/])
{
	SVSOUND* sound = &svsound;

	memset(wbuff, 0, sizeof(short) * SVSOUNDBUFLEN);

	svsound_tone_mix(&sound->tone[0], wbuff);
	svsound_tone_mix(&sound->tone[1], wbuff);
	svsound_noise_mix(&sound->noise, wbuff);

	svsound_volume_shift(wbuff);
}

