/*	
 *	clipsti.h
 *
 *	P/ECE STIC Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed May 18 20:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_STI_H__
#define __CLIP_STI_H__

/* ============
 * STICɂ
 * ============
 * - STIĆAStandard Television Interface Chip̗łB
 * - STIĆAΉKïႢɂA̕i킪܂B
 *   EAY-3-8900   4.000   MHz (CCIRKi)
 *   EAY-3-8900-1 3.579545MHz (NTSCKi)
 *   IntellivisionɓڂĂ̂́AAY-3-8900-1łB
 *   M^C~OȊO̎dĺAǂ݂łB
 */

/* ===============================================
 * IntellivisionnhRg[͂̃rbg`
 * ===============================================
 * - ẼnhRg[AY-3-8914̃|[gA($01FE)A
 *   ̃nhRg[AY-3-8914̃|[gB($01FF)ɐڑĂ܂B
 * - ͕͂_ŁAȉ̒`NOTlۂ̓͂ƂȂ܂B
 * - {́AnhRg[͂STICƂ͊֌WȂ̂łǁA
 *   ɒ`ꏊ̂ŁAƂ肠Œ`邱Ƃɂ܂B
 *
 *	  +---- Top Action (same) ----+
 *	  |                           |
 *	  |     +---------------+     |
 *	  |   +-| +---+---+---+ |-+   |
 *	  +-> | | | 1 | 2 | 3 | | | <-+ 
 *	      +-| +---+---+---+ |-+     
 *	        | | 4 | 5 | 6 | |       
 *	        | +---+---+---+ |       
 *	        | | 7 | 8 | 9 | |       
 *	      +-| +---+---+---+ |-+     R
 *	L --> | | | C | 0 | E | | | <-- i
 *	e     +-| +---+---+---+ |-+     g
 *	f       +---------------+       h
 *	t       |    +-----+    |       t
 *	        |  +-+     +-+  |       
 *	A       | ++         ++ |       A
 *	c       | |           | |       c
 *	t       | ++         ++ |       t
 *	i       |  +-+     +-+  |       i
 *	o       |    +-----+    |       o
 *	n       +---------------+       n
 */
#define INTV_KEY_DOWN		((1<<0)              )
#define INTV_KEY_UP		((1<<2)              )
#define INTV_KEY_RIGHT		(       (1<<1)       )
#define INTV_KEY_LEFT		(       (1<<3)       )
#define INTV_KEY_DOWN_RIGHT	((1<<0)|(1<<1)|(1<<4))
#define INTV_KEY_DOWN_LEFT	((1<<0)|(1<<3)|(1<<4))
#define INTV_KEY_UP_RIGHT	((1<<2)|(1<<1)|(1<<4))
#define INTV_KEY_UP_LEFT	((1<<2)|(1<<3)|(1<<4))
//
#define INTV_KEY_3		((1<<0)|(1<<5))
#define INTV_KEY_2		((1<<0)|(1<<6))
#define INTV_KEY_1		((1<<0)|(1<<7))
#define INTV_KEY_6		((1<<1)|(1<<5))
#define INTV_KEY_5		((1<<1)|(1<<6))
#define INTV_KEY_4		((1<<1)|(1<<7))
#define INTV_KEY_9		((1<<2)|(1<<5))
#define INTV_KEY_8		((1<<2)|(1<<6))
#define INTV_KEY_7		((1<<2)|(1<<7))
#define INTV_KEY_ENTER		((1<<3)|(1<<5))
#define INTV_KEY_0		((1<<3)|(1<<6))
#define INTV_KEY_CLEAR		((1<<3)|(1<<7))
//
#define INTV_KEY_ACTION_TOP	((1<<5)|       (1<<7))
#define INTV_KEY_ACTION_LEFT	((1<<5)|(1<<6)       )
#define INTV_KEY_ACTION_RIGHT	(       (1<<6)|(1<<7))

/****************************************************************************
 *
 ****************************************************************************/

/* STIC_ASMV{`ǂݍ݂܂B
 * STIC_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipstia.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef STIC_ASM
#endif /*PIECE*/

/****************************************************************************
 *	
 ****************************************************************************/

#define STIC_CLOCK	NTSC_COLOR_SUBCARRIER
#define INTV_CLOCK	(STIC_CLOCK/4)	/* Intellivision CPU }VTCN */

#ifdef PIECE
#define STIC_GRAYSCALE
#endif /*PIECE*/

/*  */
/* AZu[`璼ڎQƂĂ̂ŁAtH[}bgŒłB */
/* tH[}bgύXƂ́Aclipstia.h̒`Ǐ]ĂB */
/*  */

typedef struct _STICMOB {
	unsigned char flags;		/* + 0,1: {PRIO,VISB,INTR,YRES,XFLIP,YFLIP} */
	unsigned char color;		/* + 1,1: FG Color */
	unsigned char x_size;		/* + 2,1: XSIZE */
	unsigned char y_size;		/* + 3,1: YSIZ2,YSIZ4 */
	short x;			/* + 4,2: X Coordinate */
	short y;			/* + 6,2: Y Coordinate */
	short w;			/* + 8,2: {8,16} */
	short h;			/* +10,2: {4,8,16,32,64} */
	unsigned short card;		/* +12,2: GRAM/GROM Card # */
	unsigned short collision;	/* +14,2: COLL BORD,BG,MOB7-0 */
} STICMOB;				/* =16 */

/* STICMOB.flags */
#define STICMOB_PRIORITY	(1<<0)	/* PRIO */
#define STICMOB_VISIBLE		(1<<1)	/* VISB */
#define STICMOB_INTERACT	(1<<2)	/* INTR */
#define STICMOB_RESOLUTION	(1<<3)	/* YRES */
#define STICMOB_X_FLIP		(1<<4)	/* XFLIP */
#define STICMOB_Y_FLIP		(1<<5)	/* YFLIP */

typedef struct _STIC {
	const unsigned short* backtab/*[$0200-$02EF]*/;
	const unsigned char* graphics/*[$3000-$3AFF]*/;
	unsigned char* vbuff/*[160*96]*/;
	//
	unsigned char flags;		/* {STIC_*} */
	unsigned char x_delay;		/* 0..7 */
	unsigned char y_delay;		/* 0..7 */
	unsigned char border_color;
	unsigned char color_stack[4];
	STICMOB mob[8];
} STIC;

/* STIC.flags */
#define STIC_MODE			(1<<0)	/* 0 = Color Stack & Colored Squares Mode, 1 = Foreground/Background Mode */
#define STIC_BORDER_EXTENSION_LEFT	(1<<1)	/* Border extension left edge */
#define STIC_BORDER_EXTENSION_TOP	(1<<2)	/* Border extension top edge */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern STIC stic;

#ifdef STIC_GRAYSCALE
extern const unsigned char stic_grayscale_table[16/*Color*/];
#else /*STIC_GRAYSCALE*/
extern const unsigned char stic_color_table[16/*Color*/][3/*R,G,B*/];
#endif /*STIC_GRAYSCALE*/

/****************************************************************************
 *	֐
 ****************************************************************************/

void stic_fill_background_card(int x, int y, int color);
void stic_draw_background_card(int x, int y, int card, int color);
void stic_draw_colored_squares(int x, int y, const char colors[/*4*/]);
void stic_draw_mob(const STICMOB* mob);
void stic_make_mob_graphics(const STICMOB* mob, unsigned short graphics[/*64*/]);
void stic_make_background_card_mask(int card, unsigned short mask[/*8*/]);
void stic_make_colored_squares_mask(const char colors[/*4*/], unsigned short mask[/*8*/]);
int stic_collision_graphics(int x1, int y1, const unsigned short* g1/*[64]*/, int x2, int y2, const unsigned short* g2/*[64]*/);
void stic_collision();

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void stic_reset(const unsigned short backtab[/*$0200-$02EF*/], const unsigned char graphics[/*$3000-$3AFF*/]);
int stic_read(int addr);
void stic_write(int addr, int data);
void stic_update(unsigned char vbuff[/*160*96*/]);
#ifdef STIC_GRAYSCALE
void stic_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*96*/]);
#endif /*STIC_GRAYSCALE*/

#endif /*__CLIP_STI_H__*/
