/*	
 *	clipspc.h
 *
 *	P/ECE SPC Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 06 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SPC_H__
#define __CLIP_SPC_H__

/* v!! ̂߂ɁwS-SMP̓NbN = S-DSP̓NbN = 2.048MHzxߑłŎ܂B */

/****************************************************************************
 *	SPCt@Cdl
 ****************************************************************************/

/* * ID666/SPCHEADER\̂ǂAgGfBAłB
 *
 * * ID666/SPCHEADER\̂ǂAtB[hACgȂŃpbNĂ܂B
 *   ̂shortintgȂ̂ŁA2oCgȏ̃tB[hchar[]ƂĒ`܂B
 *
 * * SPCt@CɊ܂܂ĂID666 Tag text format / binary format ǂ炩@słB
 *   Ƃ肠ɋʂ song_title,game_title,dumper,comments tB[hĝSłB
 */

/* ID666 Tag (text format) */
typedef struct _ID666TEXT {
	         char song_title[32];		/* +0002eh, 32: Song title */
	         char game_title[32];		/* +0004eh, 32: Game title */
	         char dumper[16];		/* +0006eh, 16: Name of dumper */
	         char comments[32];		/* +0007eh, 32: Comments */
	         char date[11];			/* +0009eh, 11: Date SPC was dumped (MM/DD/YYYY) */
	         char play_time[3];		/* +000a9h,  3: Number of seconds to play song before fading out */
	         char fade_time[5];		/* +000ach,  5: Length of face in milliseconds */
	         char artist[32];		/* +000b1h, 32: Artist of song */
	unsigned char channel_disable;		/* +000d1h,  1: Default channel disables (0:enable/1:disable) */
	unsigned char emulator;			/* +000d2h,  1: Emulator used to dump SPC (0:unknown/1:ZSNES/2:Snes9x) */
	unsigned char resv000d3[45];		/* +000d3h, 45: (\) */
} ID666TEXT;					/* =00100h,210 */

/* ID666 Tag (binary format) */
typedef struct _ID666BINARY {
	         char song_title[32];		/* +0002eh, 32: Song title */
	         char game_title[32];		/* +0004eh, 32: Game title */
	         char dumper[16];		/* +0006eh, 16: Name of dumper */
	         char comments[32];		/* +0007eh, 32: Comments */
	unsigned char date[4];			/* +0009eh,  4: Date SPC was dumped (YYYYMMDD) */
	unsigned char resv000a2[7];		/* +000a2h,  7: (\) */
	unsigned char play_time[3];		/* +000a9h,  3: Number of seconds to play song before fading out */
	unsigned char fade_time[4];		/* +000ach,  4: Length of face in milliseconds */
	         char artist[32];		/* +000b0h, 32: Artist of song */
	unsigned char channel_disable;		/* +000d0h,  1: Default channel disables (0:enable/1:disable) */
	unsigned char emulator;			/* +000d1h,  1: Emulator used to dump SPC (0:unknown/1:ZSNES/2:Snes9x) */
	unsigned char resv000d3[46];		/* +000d2h, 46: (\) */
} ID666BINARY;					/* =00100h,210 */

/* ID666 Tag */
typedef union _ID666 {
	ID666TEXT text;				/* text format */
	ID666BINARY binary;			/* binary format */
} ID666;

typedef struct _SPCHEADER {
	         char signature[33];		/* +00000h, 33: "SNES-SPC700 Sound File Data v0.30" Œ */
	unsigned char resv00021[2];		/* +00021h,  2: {26,26} Œ */
	unsigned char has_id666;		/* +00023h,  1: ID666 TagL/ (26:L/27:) */
	unsigned char minor_ver;		/* +00024h,  1: }Ci[o[W (30Œ?) */
	/*===== SPC700 Registers =====*/
	unsigned char pc[2];			/* +00025h,  1: PC */
	unsigned char a;			/* +00027h,  1: A */
	unsigned char x;			/* +00028h,  1: X */
	unsigned char y;			/* +00029h,  1: Y */
	unsigned char psw;			/* +0002ah,  1: PSW */
	unsigned char sp;			/* +0002bh,  1: SP */
	unsigned char resv0002c[2];		/* +0002ch,  2: (\) uSPC File Format v0.30v(spc_file_format.txt)ɂ3oCgƏĂ܂BA? */
	/*===== ID666 Tag =====*/
	        ID666 id666;			/* +0002eh,210: ID666 Tag (text or binary format) */
	/*===== Memory Image =====*/
	unsigned char main_ram[0x10000];	/* +00100h,64K: CRAM */
	unsigned char dsp_regs[128];		/* +10100h,128: DSPWX^ */
	unsigned char resv10180[64];		/* +10180h, 64: (\) */
	unsigned char extra_ram[64];		/* +101c0h, 64: Extra RAM (IPL ROM̗RAM?) */
} SPCHEADER;					/* =10200h */
						/* ̌Extended ID666 Itemsꍇ܂B(Ή) */

/****************************************************************************
 *	SPChCo
 ****************************************************************************/

#define SPCBUFLEN	320		/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

#define SPC_CLOCK	SDSP_CLOCK	/* CPUDSPNbN[Hz] (ʂł) */

/*
 *	SPC^C} ({S-SMPI`bv)
 */
typedef struct _SPCTIMER {
	int start;		/* 0:STOP/1:START ($00f1[2:0]ɑ) */
	unsigned period;	/* $00fa`$00fcɏ܂ꂽl𕪎{ĕێ */
	//
	int cycle;		/* o߃TCNJEgpCPUTCNlۑ */
	unsigned progress;	/* o߃TCN */
} SPCTIMER;

/*
 *	SPChCo
 */
typedef struct _SPCDRIVER {
	/*===== SNESn[hEFAɊւ =====*/
	/*{{SSMPRAREADO֐g߁ACAEgŒ*/
	SSMP ssmp;			/* SSMP Core */
	unsigned char mem[0x10000];	/* Main Memory */
	/*}}SSMPRAREADO֐g߁ACAEgŒ*/
	SDSP sdsp;			/* SDSP Core */
	SPCTIMER timer[3];		/* Timer (8K/8K/64K[Hz]) */

	/*===== SPCt@C\tgEFAɊւ =====*/
	/* TODO: */
} SPCDRIVER;

/*
 *	SSMPG~[VpO֐
 */
unsigned char spc_ssmp_read(SSMP* ssmp, unsigned short addr);
void spc_ssmp_write(SSMP* ssmp, unsigned short addr, unsigned char data);
unsigned char spc_ssmp_in(SSMP* ssmp, unsigned short addr);
void spc_ssmp_out(SSMP* ssmp, unsigned short addr, unsigned char data);

/*
 *	SPChCo֐
 */
int spc_init(SPCDRIVER* spc, const void* data);
int spc_mix(SPCDRIVER* spc, short wbuff[/*SPCBUFLEN*/]);
int spc_stream_callback(short* wbuff, int param);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* SPCt@C̍ĐJn܂B
 * [in]
 *	data		SPCf[^̐擪AhXB
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKspc_stop()ĂŁAxN^𕜌ĂB
 */
int spc_play(const void* data);

/* SPCt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void spc_stop();

#endif /*__CLIP_SPC_H__*/
