/*	
 *	clipsn7.h
 *
 *	P/ECE SN76489/SN76496(DCSG) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 24 18:30:00 JST 2005 Naoyuki Sawa
 *	- ̂߂ɑ啝ȉs܂B
 *	  VGM PlayerŜ2.5{xȂ̂ŁAP̂ł͂ƑȂĂƎv܂B
 *	- т̂鋌R[h keep/SN76489Oۑ-20050124.zip ɕۑĂ܂B
 */
#ifndef __CLIP_SN7_H__
#define __CLIP_SN7_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* Channel0..2: Tone */
typedef struct _SN76489TONE {
	int volume;		/* + 0,4:  (:0..15:)   */
	int period;		/* + 4,4: o͋ɐ]     */
	int progress;		/* + 8,4: isJE^         */
	int polarity;		/* +12,4: o͋ɐ (0=,1=) */
} SN76489TONE;			/* =16 */

/* Channel3: Noise */
typedef struct _SN76489NOISE {
	int volume;		/* + 0,4:  (:0..15:)                    */
	int period;		/* + 4,4: LFSRVtg                        */
	int progress;		/* + 8,4: isJE^                          */
	int lfsr;		/* +12,4: LFSR(Linear Feedback Shift Register)  */
				/*        LFSRbit0o͋ɐł (0:,1:)  */
	int fbtype;		/* +16,4: tB[hobN^Cv                  */
				/*        0=mCY     (^bvrbg=0x1)   */
				/*        1=zCgmCY (^bvrbg=0x9)   */
} SN76489NOISE;			/* =20 */

/* SN76489 Chip */
typedef struct _SN76489 {
	int clock;		/* + 0, 4: ̓NbN       */
	int i_channel;		/* + 4, 4: ݒ`lԍ   */
	SN76489TONE tone[3];	/* + 8,48: g[`l0`2 */
	SN76489NOISE noise;	/* +56,20: mCY`l     */
} SN76489;			/* =76 */

/****************************************************************************
 *	֐
 ****************************************************************************/

void sn76489_tone_mix(SN76489* sn, SN76489TONE* tone, short wbuff[/*count*/], int count);
void sn76489_noise_mix(SN76489* sn, SN76489NOISE* noise, short wbuff[/*count*/], int count);
void sn76489_volume_shift(short wbuff[/*count*/], int count);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* SN76489RAZbg܂B
 * [in]
 *	sn		SN76489\́B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ASN76489ZbgsꍇɁAKvɉČĂяoĂB
 */
void sn76489_reset(SN76489* sn, int clock);

/* SN764891oCg݂܂B
 * [in]
 *	sn		SN76489\́B
 *	data		ރf[^B
 */
void sn76489_write(SN76489* sn, unsigned char data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	sn		SN76489\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void sn76489_mix(SN76489* sn, short wbuff[/*count*/], int count);

#endif /*__CLIP_SN7_H__*/
