/*	
 *	clipsl4r.c
 *
 *	XbgQ[pTu[`W(4CEART@)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Tue Jun 24 21:30:13 JST 2014 Naoyuki Sawa
 *	- 1st[XB
 *	- W[́APCŃc[쐬鎞ɃvWFNgɊ܂߂Ďgp܂B
 *	  P/ECEŒڎgp邱Ƃ͖̂ŁAclip.h,Makefileɂ͊܂߂Ă܂B
 */
#include "clip.h"

/****************************************************************************
 *	XybNf[^쐬Eo
 ****************************************************************************/
#ifdef  WIN32	//PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
/*--------------------------------------------------------------------------*
 *	o̔f
 *--------------------------------------------------------------------------*/
#define PRODUCT_SPECIFIC		//̃V{`ƁA@L̒sB
//#define SLOT_SPEC_ALLOW_TPIHZ_NOBONUS	//̃V{`ƁA_uepCnYEgvepCnYeB
//#define SLOT_SPEC_ALLOW_MIDCH_NOBONUS	//̃V{`ƁAi`F[[`ڂƂȂB
//#define SLOT_SPEC_ALLOW_CHSEV_NOBONUS	//̃V{`ƁAi`F[tZu[`ڂƂȂB
/*--------------------------------------------------------------------------*
 *	\
 *--------------------------------------------------------------------------*/
/* 3[ܔ */
typedef struct _ST_Slot_HitChk3 {
	unsigned char	iHitFlg[7/*iLine*/];					//[Cԍ]ˊGgԍ				0`(SIZE_HitFlg-1)
	unsigned char	aPriority[64/*SIZE_HitCd*/][3];				//[uԍ][]˗Dx				0,1`		uDx=0vȂ΁A~sł邱ƂB
} ST_Slot_HitChk3;
/* 2[ܗ\ */
typedef struct _ST_Slot_HitChk2 {
	unsigned char	aMinPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍŏDx				0,1`		uŏDx=0vȂ΁A~sł邱ƂB
	unsigned char	aMaxPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍőDx				0,1`		őDxŏDx
} ST_Slot_HitChk2;
/* 1[ܗ\ */
typedef struct _ST_Slot_HitChk1 {
	unsigned char	aMinPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍŏDx				0,1`		uŏDx=0vȂ΁A~sł邱ƂB
	unsigned char	aMaxPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍőDx				0,1`		őDxŏDx
} ST_Slot_HitChk1;
/* 1[~ */
typedef struct _ST_Slot_StpCtl1 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl1;
/* 2[~ */
typedef struct _ST_Slot_StpCtl2 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl2;
/* 3[~ */
typedef struct _ST_Slot_StpCtl3 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl3;
/* ~eXg */
typedef struct _ST_Slot_StpTst {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/][3];				//[uԍ][[ԍ]ˈ			0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aPriority[64/*SIZE_HitCd*/];				//[uԍ]˗Dx				0,1`
} ST_Slot_StpTst;
/* GgeXg */
typedef struct _ST_Slot_CmbTst {
	int		nCmbCnt;						//Gg					0~
	int		aStpCnt[64/*SIZE_HitCd*/][7/*iLine*/];			//[uԍ][Cԍ]ˊGg\	0~
	unsigned char	aResult[64/*SIZE_HitCd*/];				//[uԍ]ˌ				0~2		0=,1=G[:uɊ܂܂Ȃ̂ɕ\ꂽ,2=x:uɊ܂܂̂ɕ\Ȃ
} ST_Slot_CmbTst;
/* XybNf[^r_ */
typedef struct _ST_Slot_Spec_Builder {
	const ST_Slot_SpecInfo* pInfo;						//XybN
	ST_Slot_HitChk3 TBL_HitChk3[21][21][21];				//[[~ʒu][[~ʒu][E[~ʒu]3[ܔ
	ST_Slot_HitChk2 TBL_HitChk2[6][21][21];					//[][~σ[1~ʒu][~σ[2~ʒu]2[ܗ\
										// =0c1~[=,2~[=
										// =1c1~[=,2~[=E
										// =2c1~[=E,2~[=
										// =3c1~[=,2~[=E
										// =4c1~[=,2~[=
										// =5c1~[=E,2~[=
	ST_Slot_HitChk1 TBL_HitChk1[3][21];					//[][~σ[~ʒu]1[ܗ\
										// =0c1~[=
										// =1c1~[=
										// =2c1~[=E
	ST_Slot_StpCtl1 TBL_StpCtl1[3][21];					//[][~[ʒu]1[~
										// =0c1~[=
										// =1c1~[=
										// =2c1~[=E
	ST_Slot_StpCtl2 TBL_StpCtl2[6][21][21];					//[][~σ[~ʒu][~[ʒu]2[~
										// =0c1~[=,2~[=
										// =1c1~[=,2~[=E
										// =2c1~[=E,2~[=
										// =3c1~[=,2~[=E
										// =4c1~[=,2~[=
										// =5c1~[=E,2~[=
	ST_Slot_StpCtl3 TBL_StpCtl3[6][21][21][21];				//[][~σ[1~ʒu][~σ[2~ʒu][~[ʒu]3[~
										// =0c1~[1=,2~[2=,3~[=E
										// =1c1~[1=,2~[2=E,3~[=
										// =2c1~[1=E,2~[2=,3~[=
										// =3c1~[1=,2~[2=E,3~[=
										// =4c1~[1=,2~[2=,3~[=E
										// =5c1~[1=E,2~[2=,3~[=
	ST_Slot_StpTst TBL_StpTst[6][21][21][21];				//[ԍ][1~[ʒu][2~[ʒu][3~[ʒu]˒~eXg
	ST_Slot_CmbTst TBL_CmbTst[256/*SIZE_HitFlg*/];				//[Ggԍ]ˊGgeXg
} ST_Slot_Spec_Builder;
/*--------------------------------------------------------------------------*
 *	[J萔
 *--------------------------------------------------------------------------*/
static const char* const TBL_Slot_Spec_Color[7+1]={"gray","red","green","yellow","blue","magenta","cyan","white"};	//[Fԍ]HTMLJ[l[
static const unsigned char TBL_Slot_Spec_HkmCnt_Color[5+1]={7,6,3,5,1,0};	//[]ːFԍ
static const char* const TBL_Slot_Spec_Result_Mark[2+1]={"","~",""};	//[]ˌʋL
static const unsigned char TBL_Slot_Spec_Result_Color[2+1]={4,1,3};		//[]ːFԍ
/*--------------------------------------------------------------------------*
 *	[J֐
 *--------------------------------------------------------------------------*/
/* Gʒu(iPictPos)A(nHkmCnt)A񂾊Gʒu߂B
 * [in]
 *	iPictPos	Gʒu	0`20
 *	nHkmCnt			0`4
 * [out]
 *	߂l		Gʒu	0`20
 */
static int Slot_Spec_GetPictPos_Hkm(int iPictPos, int nHkmCnt) {
	if((unsigned)iPictPos > 20) { DIE(); }
	if((unsigned)nHkmCnt > 4) { DIE(); }
	if((iPictPos -= nHkmCnt) < 0) { iPictPos += 21; }
	return iPictPos;
}
/*--------------------------------------------------------------------------*/
/* e[̒~GAiPict1,iPict2,iPict3łAGgB
 * [in]
 *	pBuilder	XybNf[^r_
 *	iPict1		[̊Gԍ	0`(SIZE_Pict-1)
 *	iPict2		[̊Gԍ	0`(SIZE_Pict-1)
 *	iPict3		E[̊Gԍ	0`(SIZE_Pict-1)
 * [out]
 *	߂l		Ggԍ		0`(SIZE_HitFlg-1)
 */
static int Slot_Spec_FindHitFlg(ST_Slot_Spec_Builder* pBuilder, int iPict1, int iPict2, int iPict3) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iHitFlg;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	/* w肳ꂽGԍł邱ƂmFB */
	if(((unsigned)iPict1 >= (unsigned)pInfo->SIZE_Pict) ||
	   ((unsigned)iPict2 >= (unsigned)pInfo->SIZE_Pict) ||
	   ((unsigned)iPict3 >= (unsigned)pInfo->SIZE_Pict)) { DIE(); }
	/* eGgɂāc */
	for(iHitFlg = pInfo->SIZE_HitFlg - 1; iHitFlg >= 0; iHitFlg--) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		/* Ggf[^jĂȂƂmFB */
		if(((unsigned)pHitFlg->aPict[0] >= (unsigned)pInfo->SIZE_Pict) ||
		   ((unsigned)pHitFlg->aPict[1] >= (unsigned)pInfo->SIZE_Pict) ||
		   ((unsigned)pHitFlg->aPict[2] >= (unsigned)pInfo->SIZE_Pict)) { DIE(); }
		/* GԍvAGgԍԂB */
		if((!pHitFlg->aPict[0] || (pHitFlg->aPict[0] == iPict1)) &&
		   (!pHitFlg->aPict[1] || (pHitFlg->aPict[1] == iPict2)) &&
		   (!pHitFlg->aPict[2] || (pHitFlg->aPict[2] == iPict3))) { return iHitFlg; }
	}
	DIE(); /* ȂƂA(iHitFlg=0:nY)Ɉv͂Ȃ̂ŁA֓BG[B */
}
/*--------------------------------------------------------------------------*/
/* ő擾B
 * [in]
 *	pBuilder	XybNf[^r_
 *	iHitCd		uԍ		0`(SIZE_HitCd-1)
 *	iReel		[ԍ		0`2
 * [out]
 *	߂l		ő		1,,4
 */
static int GetHkmCntMax(ST_Slot_Spec_Builder* pBuilder, int iHitCd, int iReel) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	/* w肳ꂽuԍł邱ƂmFB */
	if((unsigned)iHitCd >= (unsigned)pInfo->SIZE_HitCd) { DIE(); }
	/* w肳ꂽ[ԍł邱ƂmFB */
	if((unsigned)iReel > 2) { DIE(); }
	/* CTȂ΁ACTɖƂ郊[ԍȂ΁Aő1ƂB */
	if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel == pInfo->CT_Reel)) { return 1; }
#ifdef  PRODUCT_SPECIFIC//{{@L̒
	/* ذȂ΁ACTɖƂ郊[ԍȂ΁Aő1ƂB */
	if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ذ"  ) && (iReel == pInfo->CT_Reel)) { return 1; }
#endif//PRODUCT_SPECIFIC//}}@L̒
	/* ȊOȂ΁Aő1ƂB */
	return 4;
}
/*--------------------------------------------------------------------------*
 *	3[ܔ
 *--------------------------------------------------------------------------*/
/* 3[ܔf[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk3(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iReel1, iReel2, iReel3, iLine, iHitCd, iOrder, iPriority;
	ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	iReel1 = 0; /* [ */
	iReel2 = 1; /* [ */
	iReel3 = 2; /* E[ */
	/* [̊e~ʒuɂāc */
	for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
		/* [̊e~ʒuɂāc */
		for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
			/* E[̊e~ʒuɂāc */
			for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
				pHitChk3 = &pBuilder->TBL_HitChk3[aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
				/* eCɂāc */
				for(iLine = 0; iLine < 7; iLine++) {
					/* Ggԍ擾B */
					pHitChk3->iHitFlg[iLine] = Slot_Spec_FindHitFlg(pBuilder,
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + Slot_GetLineRow(iLine, iReel1), iReel1),
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + Slot_GetLineRow(iLine, iReel2), iReel2),
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3] + Slot_GetLineRow(iLine, iReel3), iReel3));
				}
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					/* eɂāc */
					for(iOrder = 0; iOrder < 3; iOrder++) {
						/* eCɂāc */
						for(iLine = 0; iLine < 7; iLine++) {
							/* ̃ĆAGg擾B */
							pHitFlg = &pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]];
							iPriority = pHitFlg->aPriority[iHitCd][iOrder][iLine <= 2];
							if(iPriority < -1) { DIE(); }
#ifdef  PRODUCT_SPECIFIC//{{@L̒
							/* ꃊv͏΃C(=iZu)D悷悤ADx(+1)B */
							if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "") && strstr(pHitFlg->pName, "")) {
								if(iLine == Slot_Line_Z) { if(iPriority <= 0) { DIE(); } iPriority += 1; } /* iZu */
							}
							/* @͍E[Ƀ`F[6ԊuɗLA{[iXG𑵂鎞ɁA[i`F[E[i`F[tZũ[`ڂo߂B
							 * ŁA[`ڂ̗Dx(-1)邱ƂɂB[`ڂoɃ{[iXG𑵂Ȃ΁A[`ڂoȂD悷邱ƂɂB
							 * [`ڂȂʒȕꍇ̂݁A[`ڂo邮炢̕AopxƂĒxǂƎvB */
							if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ްŽ") && strstr(pHitFlg->pName, "ްŽ")) {
								if(iLine == Slot_Line_F) { if(iPriority <= 2) { DIE(); } iPriority -= 2; } /* [i`F[+E[i`F[tZu */
								if(iLine == Slot_Line_V) { if(iPriority <= 1) { DIE(); } iPriority -= 1; } /* [i`F[                                */
								if(iLine == Slot_Line_A) { if(iPriority <= 1) { DIE(); } iPriority -= 1; } /*                      E[i`F[tZu */
							}
#endif//PRODUCT_SPECIFIC//}}@L̒
							/* ̏uŒ~\ȊGgȂ΁c */	//̔fł́ADx(-1)܂߂B
							if(iPriority) {
								/* DxXVB */			//̔fŁADx(-1)OB
								if((int)iPriority > (int)pHitChk3->aPriority[iHitCd][iOrder]) { pHitChk3->aPriority[iHitCd][iOrder] = iPriority; }
							/* ̏uŒ~sȊGg1łL΁c */
							} else {
								/* ~sƌ肷B */
								pHitChk3->aPriority[iHitCd][iOrder] = 0;
								break; /* ܂ */
							}
						}
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 3[ܔf[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk3(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iReel1, iReel2, iReel3, iLine, iHitCd, iOrder;
	const ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_Pict* pPict;
	iReel1 = 0; /* [ */
	iReel2 = 1; /* [ */
	iReel3 = 2; /* E[ */
	fprintf(fp, "<table>\n");
	fprintf(fp, "<caption>%s</caption>\n", "TBL_HitChk3");
	/* [̊e~ʒuɂāc */
	for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
		/* [̊e~ʒuɂāc */
		for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
			/* E[̊e~ʒuɂāc */
			for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
				pHitChk3 = &pBuilder->TBL_HitChk3[aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel3]);							//E[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3], iReel3)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//E[~G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* eCɂāc */
				  fprintf(fp, "<td>");
				    for(iLine = 0; iLine < 7; iLine++) {
				    	if(iLine) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]].iColor]);
				    	  fprintf(fp, "%s", pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]].pName);			//Gg
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				  /* euɂāc */
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, "|"); }
				    	/* eɂāc */
				    	for(iOrder = 0; iOrder < 3; iOrder++) {
				    		if(iOrder) { fprintf(fp, " "); }
				    		fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk3->aPriority[iHitCd][iOrder] ? 7 : 0]);
				    		  fprintf(fp, "%d", pHitChk3->aPriority[iHitCd][iOrder]);			//Dx
				    		fprintf(fp, "</font>");
				    	}
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
	}
	fprintf(fp, "</table>\n");
}
/*--------------------------------------------------------------------------*
 *	2[ܗ\
 *--------------------------------------------------------------------------*/
/* 2[ܗ\f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk2(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, nHkmCnt, nMinPriority1, nMaxPriority1, nMinPriority2, nMaxPriority2;
	ST_Slot_HitChk2* pHitChk2;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ][ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pHitChk2 = &pBuilder->TBL_HitChk2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					nMinPriority1 = nMaxPriority1 = 0;
					/* ][̊e~ʒuɂāc */
					for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
						nMinPriority2 = nMaxPriority2 = 0;
						/* ő擾B */
						nHkmCnt = GetHkmCntMax(pBuilder, iHitCd, iReel3);
						/* eɂāc */
						do {
							/* 3[ܔf[^擾 */
							switch(iReel3) {
							case 0: pHitChk3 = &pBuilder->TBL_HitChk3[Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ][                         aPictPos[2]          ]; break;
							case 1: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
							case 2: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
							default: DIE();
							}
							/* ~\Ȃ΁c */
							if(pHitChk3->aPriority[iHitCd][iReel1]) {
								/* ŏDxƍőDxXVB */
								if(!nMinPriority2) {	/*  */
									nMinPriority2 = pHitChk3->aPriority[iHitCd][iReel1];
									nMaxPriority2 = pHitChk3->aPriority[iHitCd][iReel1];
								} else {		/* XV */
									if(pHitChk3->aPriority[iHitCd][iReel1] < nMinPriority2) { nMinPriority2 = pHitChk3->aPriority[iHitCd][iReel1]; }
									if(pHitChk3->aPriority[iHitCd][iReel1] > nMaxPriority2) { nMaxPriority2 = pHitChk3->aPriority[iHitCd][iReel1]; }
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁c */
						if(!nMinPriority2) {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
							break; /* ܂ */
						}
						/* ŏDxƍőDxXVB */
						if(!nMinPriority1) {	/*  */
							nMinPriority1 = nMinPriority2;
							nMaxPriority1 = nMaxPriority2;
						} else {		/* XV */
							if(nMinPriority2 < nMinPriority1) { nMinPriority1 = nMinPriority2; }
							if(nMaxPriority2 > nMaxPriority1) { nMaxPriority1 = nMaxPriority2; }
						}
					}
#ifndef SLOT_SPEC_ALLOW_TPIHZ_NOBONUS
					//{{--- _uepCnYEgvepCnY֎~ꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
					/* unYȂ΁c */
					if(!iHitCd) {
						int iLine, TpiCnt = 0;
						/* eCɂāc */
						for(iLine = 0; iLine < 7; iLine++) {
							/* epCsB */
							if(Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + Slot_GetLineRow(iLine, iReel1), iReel1) ==
							   Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + Slot_GetLineRow(iLine, iReel2), iReel2)) { TpiCnt++; }
						}
						/* unYŁAepCC2CȏȂ΁A~sƌ肷B */
						if(TpiCnt >= 2) { nMinPriority1 = nMaxPriority1 = 0; }
					}
					//}}--- _uepCnYEgvepCnY֎~ꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_TPIHZ_NOBONUS
#ifdef  PRODUCT_SPECIFIC//{{@L̒
					/* 1~[[Ȃ΁c */
					if(iReel1 == 1) {
						/* 2~[([,,E[)̏i,͉iɃ`F[oȂ΁c */
						if((strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + 0/*i*/, iReel2)].pName, "ذ")) ||
						   (strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + 2/*i*/, iReel2)].pName, "ذ"))) {
							/* u`F[,,SȂ΁c */
							if((strstr(pInfo->TBL_HitCd[iHitCd].pName, "ذ"  )) ||
							   (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S"))) {
								/* ~\Ȃ΁c([̈ʒuɂẮAۂɂ͒~Ȃӏ̂ŏOB) */
								if(nMinPriority1) {
									/* o葁A`F[oB͉o̔fłAK{ł͂ȂB */
									nMaxPriority1++;		/* őDxA`F[̗̊Dx+1ƂB */
								}
							}
						}
					}
#endif//PRODUCT_SPECIFIC//}}@L̒
					/* ŏDxƍőDxi[B */
					pHitChk2->aMinPriority[iHitCd] = nMinPriority1;
					pHitChk2->aMaxPriority[iHitCd] = nMaxPriority1;
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 2[ܗ\f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk2(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd;
	const ST_Slot_HitChk2* pHitChk2;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_HitChk2", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pHitChk2 = &pBuilder->TBL_HitChk2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//~σ[1~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[1~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//~σ[2~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[2~G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* euɂāc */
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk2->aMinPriority[iHitCd] ? 7 : 0]);
				    	  fprintf(fp, "%d-%d", pHitChk2->aMinPriority[iHitCd], pHitChk2->aMaxPriority[iHitCd]);	//ŏDx,őDx
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	1[ܗ\
 *--------------------------------------------------------------------------*/
/* 1[ܗ\f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk1(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd, nHkmCnt, nMinPriority1, nMaxPriority1, nMinPriority2, nMaxPriority2, nMinPriority3, nMaxPriority3;
	ST_Slot_HitChk1* pHitChk1;
	const ST_Slot_HitChk2* pHitChk2;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pHitChk1 = &pBuilder->TBL_HitChk1[iOrder][aPictPos[iReel1]];
			/* euɂāc */
			for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				nMinPriority1 = nMaxPriority1 = 0;
				/* ][1Ɖ][2ɂāc */
				for(iReel2 = (iReel1+1)%3; iReel2 != iReel1; iReel2 = (iReel2+1)%3) {
					nMinPriority2 = nMaxPriority2 = 0;
					/* ][̊e~ʒuɂāc */
					for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
						nMinPriority3 = nMaxPriority3 = 0;
						/* ő擾B */
						nHkmCnt = GetHkmCntMax(pBuilder, iHitCd, iReel2);
						/* eɂāc */
						do {
							/* 2[ܗ\f[^擾 */
							pHitChk2 = &pBuilder->TBL_HitChk2[Slot_FindOrder(iReel1, iReel2)][aPictPos[iReel1]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], nHkmCnt)];
							/* ~\Ȃ΁c */
							if(pHitChk2->aMinPriority[iHitCd]) {
								/* ŏDxƍőDxXVB */
								if(!nMinPriority3) {
									nMinPriority3 = pHitChk2->aMinPriority[iHitCd];
									nMaxPriority3 = pHitChk2->aMaxPriority[iHitCd];
								} else {
									if(pHitChk2->aMinPriority[iHitCd] < nMinPriority3) { nMinPriority3 = pHitChk2->aMinPriority[iHitCd]; }
									if(pHitChk2->aMaxPriority[iHitCd] > nMaxPriority3) { nMaxPriority3 = pHitChk2->aMaxPriority[iHitCd]; }
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁c */
						if(!nMinPriority3) {
							/* ~sƌ肷B */
							nMinPriority2 = nMaxPriority2 = 0;
							break; /* ܂ */
						}
						/* ŏDxƍőDxXVB */
						if(!nMinPriority2) {
							nMinPriority2 = nMinPriority3;
							nMaxPriority2 = nMaxPriority3;
						} else {
							if(nMinPriority3 < nMinPriority2) { nMinPriority2 = nMinPriority3; }
							if(nMaxPriority3 > nMaxPriority2) { nMaxPriority2 = nMaxPriority3; }
						}
					}
					/* ][̕Еł~sȂ΁c */
					if(!nMinPriority2) {
						/* ~sƌ肷B */
						nMinPriority1 = nMaxPriority1 = 0;
						break; /* ܂ */
					}
					/* ŏDxƍőDxXVB */
					if(!nMinPriority1) {
						nMinPriority1 = nMinPriority2;
						nMaxPriority1 = nMaxPriority2;
					} else {
						if(nMinPriority2 < nMinPriority1) { nMinPriority1 = nMinPriority2; }
						if(nMaxPriority2 > nMaxPriority1) { nMaxPriority1 = nMaxPriority2; }
					}
				}
#ifndef SLOT_SPEC_ALLOW_MIDCH_NOBONUS
				//{{--- [1~Ai`F[[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
				/* [1~Ȃ΁c */
				if(iReel1 == 0) {
					/* i`F[Ȃ΁c */
					if(strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 1/*i*/, iReel1)].pName, "ذ")) {
						/* u{[iXȂ΁c */
						if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ްŽ")) {
							/* oA[`ڂނƂɂB͉o̔fłAK{ł͂ȂB */
							if(!nMinPriority1) { DIE(); }	/* ŏDxA~\ł͂BłȂΐ݌v~XB */
#ifdef  PRODUCT_SPECIFIC//{{@L̒
							/* @͍E[Ƀ`F[6ԊuɗLA{[iXG𑵂鎞ɁA[i`F[E[i`F[tZũ[`ڂo߂B
							 * ŁA[`ڂ̗Dx(+1)ȂƂɂBSlot_Spec_BuildHitChk3()́A@L̒QƂB */
#else //PRODUCT_SPECIFIC//}}@L̒
							nMaxPriority1++;		/* őDxAZů̗Dx+1ƂB */			//uőDxŏDxvێ邽߂ɁAőDx̕𑝂₷ƂɂBŗǂvB͈ႤA{[iXƏdID搧ƂꍇɁADɂȂȂ肪邩mȂBŏDx𑝂₷K؂?
#endif//PRODUCT_SPECIFIC//}}@L̒
						/* u{[iXȊOȂ΁c */
						} else {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
						}
					}
				}
				//}}--- [1~Ai`F[[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_MIDCH_NOBONUS
#ifndef SLOT_SPEC_ALLOW_CHSEV_NOBONUS
				//{{--- E[1~Ai`F[tZu[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
				/* E[1~Ȃ΁c */
				if(iReel1 == 2) {
					/* i`F[tZuȂ΁c */
					if(strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 1/*i*/, iReel1)].pName, "ذ") &&
					   strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 2/*i*/, iReel1)].pName, "")) {
						/* u{[iXȂ΁c */
						if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ްŽ")) {
							/* oA[`ڂނƂɂB͉o̔fłAK{ł͂ȂB */
							if(!nMinPriority1) { DIE(); }	/* ŏDxA~\ł͂BłȂΐ݌v~XB */
#ifdef  PRODUCT_SPECIFIC//{{@L̒
							/* @͍E[Ƀ`F[6ԊuɗLA{[iXG𑵂鎞ɁA[i`F[E[i`F[tZũ[`ڂo߂B
							 * ŁA[`ڂ̗Dx(+1)ȂƂɂBSlot_Spec_BuildHitChk3()́A@L̒QƂB */
#else //PRODUCT_SPECIFIC//}}@L̒
							nMaxPriority1++;		/* őDxAZů̗Dx+1ƂB */			//uőDxŏDxvێ邽߂ɁAőDx̕𑝂₷ƂɂBŗǂvB͈ႤA{[iXƏdID搧ƂꍇɁADɂȂȂ肪邩mȂBŏDx𑝂₷K؂?
#endif//PRODUCT_SPECIFIC//}}@L̒
						/* u{[iXȊOȂ΁c */
						} else {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
						}
					}
				}
				//}}--- E[1~Ai`F[tZu[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_CHSEV_NOBONUS
#ifdef  PRODUCT_SPECIFIC//{{@L̒
				/* [1~,,E[1~Ȃ΁c */
				if((iReel1 == 0) || (iReel1 == 2)) {
					/* i,͉iɃ`F[oȂ΁c */
					if((strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 0/*i*/, iReel1)].pName, "ذ")) ||
					   (strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 2/*i*/, iReel1)].pName, "ذ"))) {
						/* u`F[,,SȂ΁c */
						if((strstr(pInfo->TBL_HitCd[iHitCd].pName, "ذ"  )) ||
						   (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S"))) {
							/* o葁A`F[oB͉o̔fłAK{ł͂ȂB */
							if(!nMinPriority1) { DIE(); }	/* ŏDxA~\ł͂BłȂΐ݌v~XB */
							nMaxPriority1++;		/* őDxA`F[̗̊Dx+1ƂB */
						}
					}
				}
#endif//PRODUCT_SPECIFIC//}}@L̒
				/* ŏDxƍőDxi[B */
				pHitChk1->aMinPriority[iHitCd] = nMinPriority1;
				pHitChk1->aMaxPriority[iHitCd] = nMaxPriority1;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 1[ܗ\f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk1(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd;
	const ST_Slot_HitChk1* pHitChk1;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_HitChk1", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pHitChk1 = &pBuilder->TBL_HitChk1[iOrder][aPictPos[iReel1]];
			fprintf(fp, "<tr>");
			  fprintf(fp, "<td>");
			    fprintf(fp, "%2d", aPictPos[iReel1]);								//~σ[~ʒu
			    fprintf(fp, " ");
			    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
			    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
			      fprintf(fp, "%s", pPict->pName);									//~σ[~G
			    fprintf(fp, "</font>");
			  fprintf(fp, "</td>");
			  /* euɂāc */
			  fprintf(fp, "<td>");
			    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			    	if(iHitCd) { fprintf(fp, " "); }
			    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk1->aMinPriority[iHitCd] ? 7 : 0]);
			    	  fprintf(fp, "%d-%d", pHitChk1->aMinPriority[iHitCd], pHitChk1->aMaxPriority[iHitCd]);		//ŏDx,őDx
			    	fprintf(fp, "</font>");
			    }
			  fprintf(fp, "</td>");
			fprintf(fp, "</tr>\n");
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	1[~
 *--------------------------------------------------------------------------*/
/* 1[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl1(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd, nHkmCnt, nMinPriority, nMaxPriority;
	ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_HitChk1* pHitChk1;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~[ */
		/* ~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][aPictPos[iReel1]];
			/* euɂāc */
			for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				nMinPriority = nMaxPriority = 0;
				pStpCtl1->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
				/* ő擾B */
				nHkmCnt = GetHkmCntMax(pBuilder, iHitCd, iReel1);
				/* eɂāc */
				do {
					/* 1[ܗ\f[^擾 */
					pHitChk1 = &pBuilder->TBL_HitChk1[iReel1][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], nHkmCnt)];
					/* ~\Ȃ΁c */
					if(pHitChk1->aMinPriority[iHitCd]) {
						/* I:
						 * EőDx傫΁AIB
						 * EőDx,,ŏDx傫΁AIB
						 * EőDx,,ŏDxȂ΁AIBA[v̌Dŏ㏑B
						 */
						if((pHitChk1->aMaxPriority[iHitCd] >  nMaxPriority) ||
						  ((pHitChk1->aMaxPriority[iHitCd] == nMaxPriority) && (pHitChk1->aMinPriority[iHitCd] >= nMinPriority))) {
							nMinPriority = pHitChk1->aMinPriority[iHitCd];
							nMaxPriority = pHitChk1->aMaxPriority[iHitCd];
							pStpCtl1->aHkmCnt[iHitCd] = nHkmCnt;
						}
					}
				} while(--nHkmCnt >= 0);
				/* SĂ̈Œ~sȂ΁A݌v~XłB */
				if(pStpCtl1->aHkmCnt[iHitCd] == 5) { DIE(); }
				/* ۂɒ~~ʒuɁA~\}[NB */
				pBuilder->TBL_StpCtl1[iOrder][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpCtl1->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 1[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl1(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd;
	const ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl1", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~[ */
		/* ~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][aPictPos[iReel1]];
			fprintf(fp, "<tr>");
			  fprintf(fp, "<td>");
			    fprintf(fp, "%2d", aPictPos[iReel1]);								//~[ʒu
			    fprintf(fp, " ");
			    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
			    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
			      fprintf(fp, "%s", pPict->pName);									//~[G
			    fprintf(fp, "</font>");
			  fprintf(fp, "</td>");
			  /* euɂāc */
			  fprintf(fp, "<td>");
			    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			    	if(iHitCd) { fprintf(fp, " "); }
			    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl1->aHkmCnt[iHitCd]]]);
			    	  fprintf(fp, "%d", pStpCtl1->aHkmCnt[iHitCd]);							//
			    	fprintf(fp, "</font>");
			    }
			  fprintf(fp, "</td>");
			fprintf(fp, "</tr>\n");
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	2[~
 *--------------------------------------------------------------------------*/
/* 2[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl2(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd, nHkmCnt, nMinPriority, nMaxPriority;
	ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_HitChk2* pHitChk2;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					nMinPriority = nMaxPriority = 0;
					pStpCtl2->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
					/* ~σ[̒~ʒuA~\Ȃ΁c */
					if(pBuilder->TBL_StpCtl1[iReel1][aPictPos[iReel1]].aStpFlg[iHitCd]) {
						/* ő擾B */
						nHkmCnt = GetHkmCntMax(pBuilder, iHitCd, iReel2);
						/* eɂāc */
						do {
							/* 2[ܗ\f[^擾 */
							pHitChk2 = &pBuilder->TBL_HitChk2[Slot_FindOrder(iReel1, iReel2)][aPictPos[iReel1]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], nHkmCnt)];
							/* ~\Ȃ΁c */
							if(pHitChk2->aMinPriority[iHitCd]) {
								/* I:
								 * EőDx傫΁AIB
								 * EőDx,,ŏDx傫΁AIB
								 * EőDx,,ŏDxȂ΁AIBA[v̌Dŏ㏑B
								 */
								if((pHitChk2->aMaxPriority[iHitCd] >  nMaxPriority) ||
								  ((pHitChk2->aMaxPriority[iHitCd] == nMaxPriority) && (pHitChk2->aMinPriority[iHitCd] >= nMinPriority))) {
									nMinPriority = pHitChk2->aMinPriority[iHitCd];
									nMaxPriority = pHitChk2->aMaxPriority[iHitCd];
									pStpCtl2->aHkmCnt[iHitCd] = nHkmCnt;
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁A݌v~XłB */
						if(pStpCtl2->aHkmCnt[iHitCd] == 5) { DIE(); }
						/* ۂɒ~~ʒuɁA~\}[NB */
						pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpCtl2->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 2[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl2(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd;
	const ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl2", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//~σ[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//~[ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~[G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* euɂāc */
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl2->aHkmCnt[iHitCd]]]);
				    	  fprintf(fp, "%d", pStpCtl2->aHkmCnt[iHitCd]);						//
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	3[~
 *--------------------------------------------------------------------------*/
/* 3[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl3(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, nHkmCnt, Priority;
	ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ~[ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* ~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						Priority = 0;
						pStpCtl3->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
						/* ~σ[1ƒ~σ[2̒~ʒuA~\Ȃ΁c */
						if(pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]].aStpFlg[iHitCd]) {
							/* ő擾B */
							nHkmCnt = GetHkmCntMax(pBuilder, iHitCd, iReel3);
							/* eɂāc */
							do {
								/* 3[ܔf[^擾 */
								switch(iReel3) {
								case 0: pHitChk3 = &pBuilder->TBL_HitChk3[Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ][                         aPictPos[2]          ]; break;
								case 1: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
								case 2: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
								default: DIE();
								}
								/* ~\Ȃ΁c */
								if(pHitChk3->aPriority[iHitCd][iReel1]) {
									/* I:
									 * EDx傫΁AIB
									 * EDxȂ΁AIBA[v̌Dŏ㏑B
									 */
									if(pHitChk3->aPriority[iHitCd][iReel1] >= Priority) {
										Priority = pHitChk3->aPriority[iHitCd][iReel1];
										pStpCtl3->aHkmCnt[iHitCd] = nHkmCnt;
									}
								}
							} while(--nHkmCnt >= 0);
							/* SĂ̈Œ~sȂ΁A݌v~XłB */
							if(pStpCtl3->aHkmCnt[iHitCd] == 5) { DIE(); }
							/* ۂɒ~~ʒuɁA~\}[NB */
							pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpCtl3->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
						}
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 3[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl3(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd;
	const ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl3", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ~[ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* ~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					fprintf(fp, "<tr>");
					  fprintf(fp, "<td>");
					    fprintf(fp, "%2d", aPictPos[iReel1]);						//~σ[1~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~σ[1~G
					    fprintf(fp, "</font>");
					    fprintf(fp, " ");
					    fprintf(fp, "%2d", aPictPos[iReel2]);						//~σ[2~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~σ[2~G
					    fprintf(fp, "</font>");
					    fprintf(fp, " ");
					    fprintf(fp, "%2d", aPictPos[iReel3]);						//~[~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3], iReel3)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~[~G
					    fprintf(fp, "</font>");
					  fprintf(fp, "</td>");
					  /* euɂāc */
					  fprintf(fp, "<td>");
					    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					    	if(iHitCd) { fprintf(fp, " "); }
					    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl3->aHkmCnt[iHitCd]]]);
					    	  fprintf(fp, "%d", pStpCtl3->aHkmCnt[iHitCd]);					//
					    	fprintf(fp, "</font>");
					    }
					  fprintf(fp, "</td>");
					fprintf(fp, "</tr>\n");
				}
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	~eXg
 *--------------------------------------------------------------------------*/
/* ~eXgsB
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpTst(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, iOrder1, iOrder2, iOrder3, aStopPos[3];
	ST_Slot_StpTst* pStpTst;
	const ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						/* 1[~f[^2[~f[^3[~f[^̉ԍ擾B */
						iOrder1 = iOrder % 3;	/* 0,1,2,0,1,2 */
						iOrder2 = iOrder;	/* 0,1,2,3,4,5 */
						iOrder3 = iOrder;	/* 0,1,2,3,4,5 */
						/* 1~[̈i[B */
						pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder1][aPictPos[iReel1]];
						pStpTst->aHkmCnt[iHitCd][iReel1] = pStpCtl1->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel1] > 4) { DIE(); }
						aStopPos[iReel1] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpTst->aHkmCnt[iHitCd][iReel1]);
						/* 2~[̈i[B */
						pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder2][aStopPos[iReel1]][aPictPos[iReel2]];
						pStpTst->aHkmCnt[iHitCd][iReel2] = pStpCtl2->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel2] > 4) { DIE(); }
						aStopPos[iReel2] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpTst->aHkmCnt[iHitCd][iReel2]);
						/* 3~[̈i[B */
						pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder3][aStopPos[iReel1]][aStopPos[iReel2]][aPictPos[iReel3]];
						pStpTst->aHkmCnt[iHitCd][iReel3] = pStpCtl3->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel3] > 4) { DIE(); }
						aStopPos[iReel3] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpTst->aHkmCnt[iHitCd][iReel3]);
						/* 3[ܔf[^擾 */
						pHitChk3 = &pBuilder->TBL_HitChk3[aStopPos[0]][aStopPos[1]][aStopPos[2]];
						/* Dx擾B */
						pStpTst->aPriority[iHitCd] = pHitChk3->aPriority[iHitCd][iReel1];
						if(!pStpTst->aPriority[iHitCd]) { DIE(); }
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ~eXǧʂHTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpTst(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd;
	const ST_Slot_StpTst* pStpTst;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpTst", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					fprintf(fp, "<tr>");
					  fprintf(fp, "<td>%2d %2d %2d</td>", aPictPos[iReel1],					//1~[̉ʒu
					                                      aPictPos[iReel2],					//2~[̉ʒu
					                                      aPictPos[iReel3]);				//3~[̉ʒu
					  /* euɂāc */
					  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					  	fprintf(fp, "<td>");
					  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[0]);
					  	    fprintf(fp, "%d %d %d", pStpTst->aHkmCnt[iHitCd][iReel1],			//1~[̈
					  	                            pStpTst->aHkmCnt[iHitCd][iReel2],			//2~[̈
					  	                            pStpTst->aHkmCnt[iHitCd][iReel3]);			//3~[̈
					  	  fprintf(fp, "</font>");
					  	  fprintf(fp, " ");
					  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[1]);
					  	    fprintf(fp, "%d", pStpTst->aPriority[iHitCd]);				//Dx
					  	  fprintf(fp, "</font>");
					  	fprintf(fp, "</td>");
					  }
					fprintf(fp, "</tr>\n");
				}
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	GgeXg
 *--------------------------------------------------------------------------*/
/* GgeXgsB
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildCmbTst(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, iHitFlg, iLine, nStpCntSum_Total, nStpCntSum_HitCd, aStopPos[3];
	ST_Slot_CmbTst* pCmbTst;
	const ST_Slot_StpTst* pStpTst;
	const ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	/* [̊eGʒuɂāc */
	for(aPictPos[0] = 0; aPictPos[0] < 21; aPictPos[0]++) {
		/* [̊eGʒuɂāc */
		for(aPictPos[1] = 0; aPictPos[1] < 21; aPictPos[1]++) {
			/* E[̊eGʒuɂāc */
			for(aPictPos[2] = 0; aPictPos[2] < 21; aPictPos[2]++) {
				/* Ggԍ擾B */
				iHitFlg = Slot_Spec_FindHitFlg(pBuilder,
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[0], 0),
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[1], 1),
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[2], 2));
				/* GgZB */
				pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];
				pCmbTst->nCmbCnt++;
			}
		}
	}
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						/* 1~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel1] > 4) { DIE(); }
						aStopPos[iReel1] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpTst->aHkmCnt[iHitCd][iReel1]);
						/* 2~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel2] > 4) { DIE(); }
						aStopPos[iReel2] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpTst->aHkmCnt[iHitCd][iReel2]);
						/* 3~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel3] > 4) { DIE(); }
						aStopPos[iReel3] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpTst->aHkmCnt[iHitCd][iReel3]);
						/* 3[ܔf[^擾 */
						pHitChk3 = &pBuilder->TBL_HitChk3[aStopPos[0]][aStopPos[1]][aStopPos[2]];
						/* eCɂāc */
						for(iLine = 0; iLine < 7; iLine++) {
							/* Gg\񐔂𑝂₷B */
							if((unsigned)pHitChk3->iHitFlg[iLine] >= (unsigned)pInfo->SIZE_HitFlg) { DIE(); }
							pCmbTst = &pBuilder->TBL_CmbTst[pHitChk3->iHitFlg[iLine]];
							pCmbTst->aStpCnt[iHitCd][iLine]++;
						}
					}
				}
			}
		}
	}
	/* eGgɂāc */
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];	/* Gg */
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];		/* Gg\ */
		nStpCntSum_Total = 0;				/* Gg\񐔂̍v */
		/* euɂāc */
		for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			nStpCntSum_HitCd = 0;			/* Gg\񐔂̍v */
			/* e*L*Cɂāc */
			for(iLine = 3/*LC*/; iLine < 7; iLine++) {
				/* Gg\񐔂̍vZB */
				nStpCntSum_HitCd += pCmbTst->aStpCnt[iHitCd][iLine];
				nStpCntSum_Total += pCmbTst->aStpCnt[iHitCd][iLine];
			}
			/* ̏uŁÅGg\Ȃ΁c */
			if(nStpCntSum_HitCd) {
				/* ̏uɁÅGg܂܂Ȃ΁c */
				if((pHitFlg->aPriority[iHitCd][0/**/][0/*LC*/] != 0) ||	//(-1)܂
				   (pHitFlg->aPriority[iHitCd][1/**/][0/*LC*/] != 0) ||	//(-1)܂
				   (pHitFlg->aPriority[iHitCd][2/*E*/][0/*LC*/] != 0)) {	//(-1)܂
					pCmbTst->aResult[iHitCd] = 0;	/*  */
				/* ̏uɁÅGg܂܂ȂȂ΁c */
				} else {
					pCmbTst->aResult[iHitCd] = 1;	/* G[:uɊ܂܂Ȃ̂ɕ\ꂽ */
					fprintf(stderr, "###Slot_BuildCmbTst: uԍ%d,Ggԍ%dɂāuG[:uɊ܂܂Ȃ̂ɕ\ꂽv܂B\n", iHitCd, iHitFlg);
				}
			/* ̏uŁÅGg\ȂȂ΁c */
			} else {
				/* ̏uɁÅGg܂܂Ȃ΁c */
				if((pHitFlg->aPriority[iHitCd][0/**/][0/*LC*/] >= 1) ||	//(-1)͏
				   (pHitFlg->aPriority[iHitCd][1/**/][0/*LC*/] >= 1) ||	//(-1)͏
				   (pHitFlg->aPriority[iHitCd][2/*E*/][0/*LC*/] >= 1)) {	//(-1)͏
					pCmbTst->aResult[iHitCd] = 2;	/* x:uɊ܂܂̂ɕ\Ȃ */
					if(iHitCd != (pInfo->SIZE_HitCd-1)/*S*/) { /* uSȂ΁Aɂ͏uɊGg͒`Ȃ̂ŁAx\ȂB\Ă\ȂAx\B */
						fprintf(stderr, "###Slot_BuildCmbTst: uԍ%d,Ggԍ%dɂāux:uɊ܂܂̂ɕ\Ȃv܂B\n", iHitCd, iHitFlg);
					}
				/* ̏uɁÅGg܂܂ȂȂ΁c */
				} else {
					pCmbTst->aResult[iHitCd] = 0;	/*  */
				}
			}
		}
		if(!nStpCntSum_Total && pHitFlg->nPay) {
			fprintf(stderr, "###Slot_BuildCmbTst: Ggԍ%dɂāux:̊Gg͈x\Ȃv܂B\n", iHitFlg);
		}
	}
}
/*--------------------------------------------------------------------------*/
/* GgeXǧʂHTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintCmbTst(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iHitFlg, iHitCd, iReel, iLine, aStpCntSum[7/*iLine*/], nCmbCntSum = 0;	/* o̗L鏬̊Gg̍v */
	const ST_Slot_CmbTst* pCmbTst;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	fprintf(fp, "<table>\n");
	fprintf(fp, "<caption>%s</caption>\n", "TBL_CmbTst");
	/* wb_\B */
	fprintf(fp, "<tr>");
	  fprintf(fp, "<th></th>");
	  fprintf(fp, "<th></th>");
	  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
	  	fprintf(fp, "<th>");
	  	  fprintf(fp, "%2d", iHitCd);											//uԍ
	  	  fprintf(fp, " ");
	  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_HitCd[iHitCd].iColor]);
	  	    fprintf(fp, "%s",  pInfo->TBL_HitCd[iHitCd].pName);								//u
	  	  fprintf(fp, "</font>");
	  	fprintf(fp, "</th>");
	  }
	  fprintf(fp, "<th align=center>v</th>");
	fprintf(fp, "</tr>");
	/* eGgɂāc */
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fp, "<tr>");
		  fprintf(fp, "<td>");
		    fprintf(fp, "%3d", iHitFlg);										//Ggԍ
		    for(iReel = 0; iReel < 3; iReel++) {
		    	fprintf(fp, " ");
		    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_Pict[pHitFlg->aPict[iReel]].iColor]);
		    	  fprintf(fp, "%s", pInfo->TBL_Pict[pHitFlg->aPict[iReel]].pName);					//Gg
		    	fprintf(fp, "</font>");
		    }
		    fprintf(fp, " ");
		    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitFlg->nPay ? 7 : 0]);
		      fprintf(fp, "%2d", pHitFlg->nPay);									//o
		    fprintf(fp, "</font>");
		  fprintf(fp, "</td>");
		  /* Gg\B */
		  fprintf(fp, "<td>");
		    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitFlg->nPay ? 7 : 0]);
		      fprintf(fp, "%4d", pCmbTst->nCmbCnt);									//Gg
		      if(pHitFlg->nPay) { nCmbCntSum += pCmbTst->nCmbCnt; }		/* o̗L鏬̊Gg̍vZB */
		    fprintf(fp, "</font>");
		  fprintf(fp, "</td>");
		  /* Gg\񐔂̍vNAB */
		  memset(aStpCntSum, 0, sizeof aStpCntSum);
		  /* euɂāc */
		  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		  	fprintf(fp, "<td>");
		  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_Result_Color[pCmbTst->aResult[iHitCd]]]);
		  	    fprintf(fp, "%s", TBL_Slot_Spec_Result_Mark[pCmbTst->aResult[iHitCd]]);				//
		  	  fprintf(fp, "</font>");
		  	  /* eCɂāc */
		  	  for(iLine = 0; iLine < 7; iLine++) {
		  	  	fprintf(fp, " ");
		  	  	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pCmbTst->aStpCnt[iHitCd][iLine] ? 7 : 0]);
		  	  	  fprintf(fp, "%5d", pCmbTst->aStpCnt[iHitCd][iLine]);						//Gg\
		  	  	fprintf(fp, "</font>");
		  	  	aStpCntSum[iLine] += pCmbTst->aStpCnt[iHitCd][iLine];	/* Gg\񐔂̍vZB */
		  	  }
		  	fprintf(fp, "</td>");
		  }
		  /* Gg\񐔂̍v\B */
		  fprintf(fp, "<td>");
		    for(iLine = 0; iLine < 7; iLine++) {
		    	if(iLine) { fprintf(fp, " "); }
		    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[aStpCntSum[iLine] ? 7 : 0]);
		    	  fprintf(fp, "%7d", aStpCntSum[iLine]);								//Gg\񐔂̍v
		    	fprintf(fp, "</font>");
		    }
		  fprintf(fp, "</td>");
		fprintf(fp, "</tr>\n");
	}
	/* Gg̍v\B
	 * uVZ@̔Fyь^̌蓙ɊւK ʕ\5 񓷎VZ@ɌWZp̋Ki(1)\ɊւKivv:
	 * BB̊Gg킹
	 * EBB̕o360ȉ(CTڗL)̏ꍇABB̊GgA(21^3)/(2/1500)ȉł邱ƁBAő12ʂB		(@ɂ͊֌W)
	 * EBB̕o360(CTږ)̏ꍇABB̊GgA(21^3)/(1/1500)ȉł邱ƁBAő 6ʂB		(@ɂ͊֌W)
	 * RB&JAC̊Gg킹
	 * EBBڗL̏ꍇARB̊GgA(21^3)*(1/500)ȉł邱ƁBAő18ʂB					(@ɂ͊֌W)
	 * @BBږ̏ꍇARB̊GgA(21^3)*(3/500)ȉł邱ƁBAő55ʂB					(@ɂ͊֌W)
	 * ERBJACINL̏ꍇAJACIN̊GgA(21^3)/(10/500)ȉł邱ƁBAő185ʂB				(@ɂ͊֌W)
	 * CT̊Gg킹
	 * ECT̊Ggɂ́AB
	 * ̊Gg
	 * Eo̗L鏬̊GgA(21^3)/(11/100),,(21^3)/(40/100)ȉł邱ƁBAŏ1019,ő3704ʂB	̓_eXg
	 * EvC̊Gg킹ɂ́AB
	 */
	fprintf(fp, "<tr>");
	  fprintf(fp, "<td align=center>1019v3704</td>");
	  fprintf(fp, "<td>");
	    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[((nCmbCntSum >= 1019) && (nCmbCntSum <= 3704)) ? 7 : 1]);
	      fprintf(fp, "%4d", nCmbCntSum);											//o̗L鏬̊Gg̍v
	    fprintf(fp, "</font>");
	  fprintf(fp, "</td>");
	  fprintf(fp, "<td colspan=%d></td>", pInfo->SIZE_HitCd+1);
	fprintf(fp, "</tr>\n");
	fprintf(fp, "</table>\n");
}
/*--------------------------------------------------------------------------*
 *	f[^쐬
 *--------------------------------------------------------------------------*/
static void Slot_Spec_BuildData(ST_Slot_Spec_Builder* pBuilder) {
	static const struct {
		const char* HtmlFileName;
		void (*pfnBuild)(ST_Slot_Spec_Builder* pBuilder);
		void (*pfnPrint)(ST_Slot_Spec_Builder* pBuilder, FILE* fp);
	} tbl[]={
		/* f[^쐬 */
		{"HitChk3.html",&Slot_Spec_BuildHitChk3,&Slot_Spec_PrintHitChk3},	//3[ܔ
		{"HitChk2.html",&Slot_Spec_BuildHitChk2,&Slot_Spec_PrintHitChk2},	//2[ܗ\
		{"HitChk1.html",&Slot_Spec_BuildHitChk1,&Slot_Spec_PrintHitChk1},	//1[ܗ\
		/* f[^쐬 */
		{"StpCtl1.html",&Slot_Spec_BuildStpCtl1,&Slot_Spec_PrintStpCtl1},	//1[~
		{"StpCtl2.html",&Slot_Spec_BuildStpCtl2,&Slot_Spec_PrintStpCtl2},	//2[~
		{"StpCtl3.html",&Slot_Spec_BuildStpCtl3,&Slot_Spec_PrintStpCtl3},	//3[~
		/* eXg */
		{"StpTst.html",&Slot_Spec_BuildStpTst,&Slot_Spec_PrintStpTst},		//~eXg
		{"CmbTst.html",&Slot_Spec_BuildCmbTst,&Slot_Spec_PrintCmbTst},		//GgeXg
	};
	FILE* fp;
	int i;
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		fp = fopen(tbl[i].HtmlFileName, "w");
		if(!fp) { DIE(); }
		/* f[^쐬Ef[^쐬EeXg */
		(*tbl[i].pfnBuild)(pBuilder);
		/* HTMLwb_o */
		fprintf(fp, "<html>\n");
		fprintf(fp, "<head>\n");
		fprintf(fp, "  <style type=\"text/css\">\n");
		fprintf(fp, "    *{font-family:\"MS Mincho\";font-size:12px}\n");
		fprintf(fp, "    *{white-space:pre}\n");
		fprintf(fp, "    body{color:white;background-color:black}\n");
		fprintf(fp, "    table,caption,th,td{border-width:1px;border-style:solid;border-collapse:collapse}\n");
		fprintf(fp, "  </style>\n");
		fprintf(fp, "</head>\n");
		fprintf(fp, "<body>\n");
		/* HTML{fBo */
		(*tbl[i].pfnPrint)(pBuilder, fp);
		/* HTMLtb^o */
		fprintf(fp, "</body>\n");
		fprintf(fp, "</html>\n");
		fclose(fp);
	}
	/* HTMLCfNXy[Wo */
	fp = fopen("index.html", "w");
	if(!fp) { DIE(); }
	fprintf(fp, "<html>\n");
	fprintf(fp, "<body>\n");
	fprintf(fp, "<table>\n");
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		struct stat st;
		if(stat(tbl[i].HtmlFileName, &st)) { DIE(); }
		fprintf(fp, "<tr><td><a href=\"%s\">%s</td><td align=right>%d</td></tr>\n", tbl[i].HtmlFileName, tbl[i].HtmlFileName, (int)st.st_size);
	}
	fprintf(fp, "</table>\n");
	fprintf(fp, "</body>\n");
	fprintf(fp, "</html>\n");
	fclose(fp);
}
/*--------------------------------------------------------------------------*
 *	f[^o
 *--------------------------------------------------------------------------*/
/* G */
static void Slot_Spec_PrintData_Pict(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_Pict* pPict;
	int iPict;
	for(iPict = 0; iPict < pInfo->SIZE_Pict; iPict++) {
		pPict = &pInfo->TBL_Pict[iPict];
		fprintf(fpH, "#define Pict_%s %2d//%s\n",
			pPict->pSym, iPict, pPict->pName);
	}
	fprintf(fpH, "#define Pict_Size %d\n", pInfo->SIZE_Pict);
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_Pict_Name[Pict_Size]={\n");
	for(iPict = 0; iPict < pInfo->SIZE_Pict; iPict++) {
		pPict = &pInfo->TBL_Pict[iPict];
		fprintf(fpC, "\"%s\",//%2d %s\n",
			pPict->pName,
			iPict, pPict->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_Pict_Name[Pict_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* [z */
static void Slot_Spec_PrintData_Reel(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iPictPos;
	fprintf(fpH, "#define Reel_CT %d\n", pInfo->CT_Reel);
	//
	fprintf(fpC, "const unsigned short TBL_Reel[21]={\n");
	for(iPictPos = 0; iPictPos < 21; iPictPos++) {
		fprintf(fpC, "%2d<<0|%2d<<4|%2d<<8,//%2d %s %s %s\n",
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 0),
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 1),
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 2),
			iPictPos,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 0)].pName,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 1)].pName,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 2)].pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const unsigned short TBL_Reel[21];\n");
}
/*--------------------------------------------------------------------------*/
/* u */
static void Slot_Spec_PrintData_HitCd(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitCd* pHitCd;
	int iHitCd, iRT;
	fprintf(fpC, "const unsigned short TBL_HitCd[HitCd_Size][%d][6]={\n", ARRAY_SIZE(pInfo->TBL_HitCd->aWeight));
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		fprintf(fpH, "#define HitCd_%s %2d//%s\n",
			pHitCd->pSym, iHitCd, pHitCd->pName);
		fprintf(fpC, "{");
		for(iRT = 0; iRT < ARRAY_SIZE(pInfo->TBL_HitCd->aWeight); iRT++) {
			if(iRT) { fprintf(fpC, ","); }
			fprintf(fpC, "{%5d,%5d,%5d,%5d,%5d,%5d}",
				pHitCd->aWeight[iRT][0], pHitCd->aWeight[iRT][1], pHitCd->aWeight[iRT][2], pHitCd->aWeight[iRT][3], pHitCd->aWeight[iRT][4], pHitCd->aWeight[iRT][5]);
		}
		fprintf(fpC, "},//%2d %s %s\n",
			iHitCd, pHitCd->pSym, pHitCd->pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "#define HitCd_Size %d\n", pInfo->SIZE_HitCd);
	fprintf(fpH, "extern const unsigned short TBL_HitCd[HitCd_Size][%d][6];\n", ARRAY_SIZE(pInfo->TBL_HitCd->aWeight));
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_HitCd_Name[HitCd_Size]={\n");
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		fprintf(fpC, "\"%s\",//%2d %s\n",
			pHitCd->pName,
			iHitCd, pHitCd->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_HitCd_Name[HitCd_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* Gg */
static void Slot_Spec_PrintData_HitFlg(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	int iHitFlg, nNameLen = strlen(pInfo->TBL_Pict[0].pName);
	fprintf(fpC, "const unsigned short TBL_HitFlg[HitFlg_Size]={\n");
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fpH, "#define HitFlg_%s %3d//%s\n",
			pHitFlg->pSym, iHitFlg, pHitFlg->pName);
		fprintf(fpC, "%2d|%2d<<4|%2d<<8|%2d<<12,//%2d %s %s %-*s %-*s %-*s\n",
			pHitFlg->aPict[0],pHitFlg->aPict[1],pHitFlg->aPict[2],pHitFlg->nPay,
			iHitFlg, pHitFlg->pSym, pHitFlg->pName,
			nNameLen,pHitFlg->aPict[0]?pInfo->TBL_Pict[pHitFlg->aPict[0]].pName:"-",
			nNameLen,pHitFlg->aPict[1]?pInfo->TBL_Pict[pHitFlg->aPict[1]].pName:"-",
			nNameLen,pHitFlg->aPict[2]?pInfo->TBL_Pict[pHitFlg->aPict[2]].pName:"-");
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "#define HitFlg_Size %d\n", pInfo->SIZE_HitFlg);
	fprintf(fpH, "extern const unsigned short TBL_HitFlg[HitFlg_Size];\n");
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_HitFlg_Name[HitFlg_Size]={\n");
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fpC, "\"%s\",//%3d %s\n",
			pHitFlg->pName,
			iHitFlg, pHitFlg->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_HitFlg_Name[HitFlg_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* uˊGg */
static void Slot_Spec_PrintData_HitCd_HitFlg(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitCd* pHitCd;
	int iHitCd, iHitFlg, x;
	fprintf(fpC, "const unsigned char TBL_HitCd_HitFlg[HitCd_Size][(HitFlg_Size+7)/8]={\n");
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		x = 0;
		fprintf(fpC, "{");
		for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
			if((pInfo->TBL_HitFlg[iHitFlg].aPriority[iHitCd][0/**/][0/*LC*/] != 0) ||	//(-1)܂
			   (pInfo->TBL_HitFlg[iHitFlg].aPriority[iHitCd][1/**/][0/*LC*/] != 0) ||	//(-1)܂
			   (pInfo->TBL_HitFlg[iHitFlg].aPriority[iHitCd][2/*E*/][0/*LC*/] != 0)) {	//(-1)܂
				x |= (1<<(iHitFlg&7));
			}
			if(((iHitFlg&7) == 7) || (iHitFlg == (pInfo->SIZE_HitFlg-1))) {
				fprintf(fpC, "%3d", x);
				x = 0;
				if(iHitFlg != (pInfo->SIZE_HitFlg-1)) { fprintf(fpC, ","); }
			}
		}
		fprintf(fpC, "},//%2d %s %s\n",
			iHitCd, pHitCd->pSym, pHitCd->pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const unsigned char TBL_HitCd_HitFlg[HitCd_Size][(HitFlg_Size+7)/8];\n");
}
/*--------------------------------------------------------------------------*/
/* ~ */
static int Slot_Spec_PrintData_fnGetStpCtl1(void* pParam, int iHitCd, int iReel1, int iPushPos1) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl1* pStpCtl1;
	int iOrder = iReel1;
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl1   )) { DIE(); }
	if((unsigned)iPushPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl1[0])) { DIE(); }
	pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][iPushPos1];
	if((unsigned)pStpCtl1->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl1->aHkmCnt[iHitCd];
}
static int Slot_Spec_PrintData_fnGetStpCtl2(void* pParam, int iHitCd, int iReel1, int iReel2, int iStopPos1, int iPushPos2) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl2* pStpCtl2;
	int iOrder = Slot_FindOrder(iReel1, iReel2);
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl2      )) { DIE(); }
	if((unsigned)iStopPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl2[0]   )) { DIE(); }
	if((unsigned)iPushPos2 >= ARRAY_SIZE(pBuilder->TBL_StpCtl2[0][0])) { DIE(); }
	pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][iStopPos1][iPushPos2];
	if((unsigned)pStpCtl2->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl2->aHkmCnt[iHitCd];
}
static int Slot_Spec_PrintData_fnGetStpCtl3(void* pParam, int iHitCd, int iReel1, int iReel2, int iReel3, int iStopPos1, int iStopPos2, int iPushPos3) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl3* pStpCtl3;
	int iOrder = Slot_FindOrder(iReel1, iReel2);
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl3         )) { DIE(); }
	if((unsigned)iStopPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0]      )) { DIE(); }
	if((unsigned)iStopPos2 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0][0]   )) { DIE(); }
	if((unsigned)iPushPos3 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0][0][0])) { DIE(); }
	pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][iStopPos1][iStopPos2][iPushPos3];
	if((unsigned)pStpCtl3->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl3->aHkmCnt[iHitCd];
}
static void Slot_Spec_PrintData_StpCtl(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	ST_Slot_StpCtl_BuilderInfo stBuilderInfo;
	ST_Slot_StpCtl* pStpCtl;
	/* ~f[^r_ݒ肷B */
	memset(&stBuilderInfo, 0, sizeof stBuilderInfo);
	stBuilderInfo.HitCd_Size   = pInfo->SIZE_HitCd;
	stBuilderInfo.pParam       = pBuilder;
	stBuilderInfo.fnGetStpCtl1 = &Slot_Spec_PrintData_fnGetStpCtl1;
	stBuilderInfo.fnGetStpCtl2 = &Slot_Spec_PrintData_fnGetStpCtl2;
	stBuilderInfo.fnGetStpCtl3 = &Slot_Spec_PrintData_fnGetStpCtl3;
	/* ~f[^쐬B */
	pStpCtl = Slot_BuildStpCtl(&stBuilderInfo);
	/* ~f[^o͂B */
	Slot_PrintStpCtl(pStpCtl, fpH, fpC);
	/* ~f[^JB */
	free(pStpCtl);
}
/*--------------------------------------------------------------------------*/
static void Slot_Spec_PrintData(ST_Slot_Spec_Builder* pBuilder) {
	static const struct {
		void (*pfnPrint)(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC);
	} tbl[]={
		{&Slot_Spec_PrintData_Pict},		//G
		{&Slot_Spec_PrintData_Reel},		//[z
		{&Slot_Spec_PrintData_HitCd},		//u
		{&Slot_Spec_PrintData_HitFlg},		//Gg
		{&Slot_Spec_PrintData_HitCd_HitFlg},	//uˊGg
		{&Slot_Spec_PrintData_StpCtl},		//~
	};
	FILE *fpH, *fpC;
	int i;
	if(!(fpH = fopen("SlotData.h", "w"))) { DIE(); }
	if(!(fpC = fopen("SlotData.c", "w"))) { DIE(); }
	fprintf(fpC, "#include <clip.h>\n");
	fprintf(fpC, "#include \"SlotData.h\"\n");
	fprintf(fpH, "#ifndef __SLOTDATA_H__\n");
	fprintf(fpH, "#define __SLOTDATA_H__\n");
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		(*tbl[i].pfnPrint)(pBuilder, fpH, fpC);
	}
	fprintf(fpH, "#endif//__SLOTDATA_H__\n");
	fclose(fpH);
	fclose(fpC);
}
/*--------------------------------------------------------------------------*
 *	O[o֐
 *--------------------------------------------------------------------------*/
void Slot_MakeSpec(const ST_Slot_SpecInfo* pInfo) {
	ST_Slot_Spec_Builder* pBuilder;
	/* XybNB */
	if((pInfo->SIZE_Pict   < 1) || (pInfo->SIZE_Pict   >  11)) { DIE(); }	//Any+10G܂
	if(                   (unsigned)pInfo->CT_Reel     >   2 ) { DIE(); }
	if((pInfo->SIZE_HitCd  < 1) || (pInfo->SIZE_HitCd  >  64)) { DIE(); }
	if((pInfo->SIZE_HitFlg < 1) || (pInfo->SIZE_HitFlg > 256)) { DIE(); }
	/* XybNf[^r_̃mۂB */
	pBuilder = calloc(1, sizeof(ST_Slot_Spec_Builder));
	if(!pBuilder) { DIE(); }
	/* XybNi[B */
	pBuilder->pInfo = pInfo;
	/* f[^쐬 */
	Slot_Spec_BuildData(pBuilder);
	/* f[^o */
	Slot_Spec_PrintData(pBuilder);
	/* XybNf[^r_̃JB */
	free(pBuilder);
}
#endif//WIN32	//PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
