/*	
 *	clipsid.c
 *
 *	P/ECE SID(MOS6581) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

/* mCYWFl[^e[u */
const char sid_noise_table[256] = {
	'\x37','\x4a','\xab','\x8e','\xfe','\x31','\x2d','\x1c','\xc7','\x1e','\xd0','\x47','\x9e','\x4e','\xbd','\xea',
	'\xcd','\x3b','\x62','\x22','\xe2','\xa3','\x6a','\x49','\xa8','\x82','\xc1','\xfd','\x2b','\x12','\x93','\x19',
	'\xb8','\xd1','\x4d','\xba','\xda','\x7a','\x9a','\x3a','\x5d','\x09','\x66','\x37','\x4d','\xba','\xdd','\x8c',
	'\xf7','\x0a','\x6c','\x56','\xe5','\xb4','\xbe','\xef','\xe5','\xb4','\xbf','\xf5','\x03','\x47','\x9c','\x43',
	'\x89','\xe8','\xbf','\xf6','\x05','\x53','\xd6','\x68','\x42','\x84','\xcc','\x37','\x4c','\xb7','\xce','\x3e',
	'\x70','\x69','\x46','\x9a','\x39','\x55','\xe2','\xa5','\x73','\x77','\x8e','\xfd','\x2a','\x0c','\x74','\x7d',
	'\xab','\x8f','\x02','\x41','\x80','\xbc','\xe3','\xa6','\x78','\x8f','\x03','\x47','\x9c','\x44','\x8e','\x00',
	'\x39','\x58','\xf1','\xed','\xdc','\x86','\xd7','\x6b','\x50','\xca','\x2c','\x15','\xa2','\x61','\x1c','\xc7',
	'\x1c','\xc5','\x14','\x9d','\x4c','\xb4','\xbf','\xf4','\xfd','\x2a','\x09','\x67','\x3b','\x61','\x1f','\xd2',
	'\x53','\xd7','\x6b','\x51','\xd0','\x47','\x9b','\x41','\x7e','\xad','\x9a','\x3d','\x69','\x46','\x95','\x21',
	'\xdd','\x8c','\xf6','\x09','\x67','\x3d','\x6b','\x52','\xd2','\x54','\xe0','\x97','\x2b','\x0e','\x7f','\xb4',
	'\xbc','\xe6','\xb6','\xc5','\x13','\x98','\x30','\x27','\xfb','\x20','\xd9','\x75','\x80','\xba','\xdd','\x8b',
	'\xef','\xe3','\xa9','\x85','\xd3','\x56','\xe8','\xc0','\xf8','\x0f','\x86','\xd7','\x6a','\x4b','\xaf','\xa6',
	'\x76','\x85','\xd0','\x49','\xa6','\x79','\x94','\x1d','\xc8','\x23','\xe7','\xbd','\xe8','\xbf','\xf6','\x05',
	'\x50','\xca','\x2b','\x11','\x8e','\xff','\x34','\x3e','\x6d','\x5a','\xfc','\x26','\xf9','\x18','\xb0','\xa8',
	'\x7f','\xb3','\xba','\xdd','\x8a','\xe9','\xc8','\x23','\xe6','\xb6','\xc5','\x14','\x9f','\x54','\xde','\x8f',
};

/* ATTACK RATE e[u (ɗvNbN) */
const int sid_attack_table[16] = {
	   2000,	/* 0*/
	   8000,	/* 1*/
	  16000,	/* 2*/
	  24000,	/* 3*/
	  38000,	/* 4*/
	  56000,	/* 5*/
	  68000,	/* 6*/
	  80000,	/* 7*/
	 100000,	/* 8*/
	 250000,	/* 9*/
	 500000,	/*10*/
	 800000,	/*11*/
	1000000,	/*12*/
	3000000,	/*13*/
	5000000,	/*14*/
	8000000,	/*15*/
};

/* DECAY/RELEASE RATE e[u (ɗvNbN) */
const int sid_decay_release_table[16] = {
	    6000,	/* 0*/
	   24000,	/* 1*/
	   48000,	/* 2*/
	   72000,	/* 3*/
	  114000,	/* 4*/
	  168000,	/* 5*/
	  204000,	/* 6*/
	  240000,	/* 7*/
	  300000,	/* 8*/
	  750000,	/* 9*/
	 1500000,	/*10*/
	 2400000,	/*11*/
	 3000000,	/*12*/
	 9000000,	/*13*/
	15000000,	/*14*/
	24000000,	/*15*/
};

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
sid_reset(SID* sid, int clock)
{
	memset(sid, 0, sizeof(SID));

	/* * 1TvɉNbNiނ?
	 *	1Tv̌oߎ = 1 / SPEAKER_FREQUENCY
	 *	1NbŇoߎ = 1 / clock
	 *	1TṽNbN = (1 / SPEAKER_FREQUENCY) / (1 / clock)
	 *				  = clock / SPEAKER_FREQUENCY
	 *	A[  = clock % SPEAKER_FREQUENCY
	 *	 clock(=1000000O) > SPEAKER_FREQUENCY(=16000) Ɖ肷B
	 */
	if(clock < SPEAKER_FREQUENCY) DIE();
	sid->clock.n = clock % SPEAKER_FREQUENCY;
	sid->clock.u = clock / SPEAKER_FREQUENCY;
}

unsigned char
sid_read(SID* sid, int regno)
{
	int data = -1; /* x} */

	switch(regno) {
	case 0x19: /* POTX */
	case 0x1a: /* POTY */
	case 0x1b: /* OSC3/Random */
	case 0x1c: /* ENV3 */
		/* TODO: Ή */
		break;
#ifdef SIDPLAY_DEBUG
	default:
		/* WriteOnlyWX^̕sǂݍ݂́AG[ɖ邱Ƃɂ܂B */
		TRACE("INVALID SID READ: %02x\n", regno);
		break;
#endif /*SIDPLAY_DEBUG*/
	}

	return data;
}

void
sid_write(SID* sid, int regno, unsigned char data)
{
#define CASE_VOICE(V)								\
	case (V) * 7 + 0: /* Freq Lo */						\
		((unsigned char*)&sid->voice[V].to.freq)[0] = data;		\
		break;								\
	case (V) * 7 + 1: /* Freq Hi */						\
		((unsigned char*)&sid->voice[V].to.freq)[1] = data;		\
		break;								\
	case (V) * 7 + 2: /* PW Lo */						\
		((unsigned char*)&sid->voice[V].wg.pw)[0] = data;		\
		break;								\
	case (V) * 7 + 3: /* PW Hi */						\
		((unsigned char*)&sid->voice[V].wg.pw)[1] = data & 0xf;		\
		break;								\
	case (V) * 7 + 4: /* Control Reg */					\
		sid->voice[V].wg.wf = (data >> 4) & 0xf;			\
		if(data & 1) { /* RELEASE/0 =(GATE ON)=> ATTACK */		\
			if(sid->voice[V].eg.cycle <= SIDEG_RELEASE) {		\
				sid->voice[V].eg.cycle = SIDEG_ATTACK;		\
				sid->voice[V].eg.progress = 0;			\
			}							\
		} else { /* ATTACK/DECAY/SUSTAIN =(GATE OFF)=> RELEASE */	\
			if(sid->voice[V].eg.cycle > SIDEG_RELEASE) {		\
				sid->voice[V].eg.cycle = SIDEG_RELEASE;		\
				sid->voice[V].eg.progress = 0;			\
			}							\
		}								\
		/* TODO: TEST/RING MOD/SYNC Ή */				\
		break;								\
	case (V) * 7 + 5: /* Attack/Decay */					\
		sid->voice[V].eg.atk = (data >> 4) & 0xf;			\
		sid->voice[V].eg.dcy = data & 0xf;				\
		break;								\
	case (V) * 7 + 6: /* Sustain/Release */					\
		sid->voice[V].eg.stn = (data >> 4) & 0xf;			\
		sid->voice[V].eg.rls = data & 0xf;				\
		break;

	switch(regno) {
	CASE_VOICE(0)
	CASE_VOICE(1)
	CASE_VOICE(2)
	/* Filter */
	case 0x15: /* FC Lo */
		/* TODO: Ή */
		break;
	case 0x16: /* FC Hi */
		/* TODO: Ή */
		break;
	case 0x17: /* Res/Filt */
		/* TODO: Ή */
		break;
	case 0x18: /* Mode/Vol */
		sid->vol = data & 0xf;
		/* TODO: 3 OFF/HP/BP/LP Ή */
		break;
#ifdef SIDPLAY_DEBUG
	default:
		/* "Outrun_Europa_PSID.sid"mem[0xd41c]ɕs(?)݂Ă܂EEE
		 * ̑SWX^NA]ReadOnlyWX^܂ŃNA悤ƂĂ݂łB
		 * mɎ@ł͒Pɖ邾Ȃ̂ŁA{vOG[邱Ƃɂ܂B
		 */
		TRACE("INVALID SID WRITE: %02x %02d\n", regno, data);
		break;
#endif /*SIDPLAY_DEBUG*/
	}

#undef CASE_VOICE
}

/*  */
void
sid_mix(SID* sid, short wbuff[/*SIDBUFLEN*/])
{
	int i_sample;
	int value;
	int step;

	for(i_sample = 0; i_sample < SIDBUFLEN; i_sample++) {
		value = sid_mix1(sid, &step/*g܂*/);
		/* value: t17.5bit */
		value >>= 1/**/; /* t16.5bit */
		if(value < -0x7fff) value = -0x7fff;
		if(value >  0x7fff) value =  0x7fff;
		*wbuff++ = value;
	}
}

