/*	
 *	clipsds.h
 *
 *	P/ECE S-DSP Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 06 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SDS_H__
#define __CLIP_SDS_H__

/****************************************************************************
 *
 ****************************************************************************/

/* v!! ̂߂Ɂw̓NbN = 2.048MHzxߑłŎ܂B */
#define SDSP_CLOCK	2048000

/* P/ECEXs[J[o1TvɁAS-DSPNbNTCNiނ? */
#define SDSP_STEP	(SDSP_CLOCK / SPEAKER_FREQUENCY) /* 204816=w128x */

//
// Pitch̎dl
// 
// Pitch	0x0400	0x0800	0x1000	0x2000	0x3fff
// Octave	  -2	  -1	 	  +1	  +2
// 
// ̓NbN = 2.048MHz = 2048KHz
// TvOf[^̘^[g = 32Khz (vmF)
// 
// Pitch=0x1000 ̎ Đ[g=̓NbN(204832)
// Đ[gPitchƓ̓NbNɔႷB
// 
// ]āA
// 
// Đ[g = ̓NbN~Pitch0x1000(204832)
//            = ̓NbN~Pitch0x100064
//            = ̓NbN~Pitch0x40000
// 
// NbNoߐTvOf[^is߂@
// 
// Pitch=0x40000 ̎ TvOf[^is=NbNoߐ
// (ۂɂPitch0x0000`0x3fff܂łł)
// 
// TvOf[^isPitchɔႷB
// 
// ]āA
// 
// TvOf[^is = NbNoߐ~Pitch0x40000
//
// P/ECEXs[J[o͂ɓčlƁEEE
//
// P/ECEXs[J[o1TvɁAS-DSPNbN128TCNiށB
// (S-DSPNbNP/ECEXs[J[NbN = 2.048MHz16KHz = 128)
// Xs[J[o1Tv́AS-DSPTvOf[^iśA
//
// TvOf[^is = 128~Pitch0x40000
//                          = Pitch0x800
//                          = Pitch >> 11
//
// ]āA
//
// isJE^ɂ́AXs[J[o1TvPitchlZB
// isJE^́A11rbǧŒ菬ƌȂB
// 21rbgTvf[^̃juAhXItZbgƂȂ܂B
//   (ۂɂ͍őł(16+1)rbg܂ŁBȏ͎gȂ͂łB)
//
// Gx[vWFl[^̍XVԊuɂ
//
// 32KHzłB(S-DSPdl)
//
// ]āA
//
// P/ECEXs[J[o(16KHz)1TvɁA2񕪂̍XVs܂B
//

/****************************************************************************
 *
 ****************************************************************************/

/***** Voice *****/
typedef struct _SDSPVOICE {
	int vol;			/* Volume (0:MIN`256:MAX) */
	int p;				/* Pitch */
	int srcn;			/* Source Number (SRCN~4) */
	int adsr_gain;			/* Mode 0:GAIN/1:ADSR */
	int ar;				/* Attack Rate */
	int dr;				/* Decay Rate */
	int sl;				/* Sustain Level */
	int sr;				/* Sustain Rate */
	int gain;			/* Gain */
	int non;			/* Noise 0:OFF/1:ON */
	//
	int envx;			/* Envelope generator output ( 7.16bit) */
	int outx;			/* ENVX~VOL output          (15.16bit) */
	//
	int state;			/* 0:OFF=>4:ATTACK=>3:DECAY=>2:SUSTAIN=>1:RELEASE=>0:OFF */
	int progress;			/* isJE^ (21.11bitAq̐Q) */
} SDSPVOICE;

/* SDSVOICE.state */
#define SDSVOICE_ATTACK		4
#define SDSVOICE_DECAY		3
#define SDSVOICE_SUSTAIN	2
#define SDSVOICE_RELEASE	1

/***** S-DSP Chip *****/
typedef struct _SDSP {
	const unsigned char* mem;	/* Wave Memory (64KBACPUƋL) */
	int addr;			/* Register Address */
	unsigned char reg[0x80];	/* Register Data */
	//
	SDSPVOICE voice[8];		/* Voice */
	int mvol;			/* Main Volume (0:MIN`256:MAX) */
	int mute;			/* Mute */
	int nck;			/* Noise Generator Clock */
	int dir;			/* Source Directory (DIR~0x100) */
} SDSP;

/****************************************************************************
 *	
 ****************************************************************************/

void sdsp_voice_mix(SDSP* sdsp, SDSPVOICE* voice, int* mixbuf, int count);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* SDSPRAZbg܂B
 * [in]
 *	sdsp		SDSP\́B
 *	mem		g`B(64KB)
 *			SNES̍\ł́ACPUCLĂ܂B
 *			CPUC̐擪AhXw肵ĂB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ASDSPZbgsꍇɁAKvɉČĂяoĂB
 */
void sdsp_reset(SDSP* sdsp, const void* mem);

/* f[^ǂݏ郌WX^AhXݒ擾܂B
 * [in]
 *	sdsp		SDSP\́B
 * [out]
 *	߂l		WX^AhXB
 * [note]
 *	* S-SMPCԂ$00F2ԒnREADɑ܂B
 */
unsigned char sdsp_addr_read(SDSP* sdsp);

/* f[^ǂݏ郌WX^AhXݒ肵܂B
 * [in]
 *	sdsp		SDSP\́B
 *	addr		WX^AhXB(0x00`0x7f)
 * [note]
 *	* S-SMPCԂ$00F2ԒnWRITEɑ܂B
 */
void sdsp_addr_write(SDSP* sdsp, unsigned char addr); /* $00F2 WRITE */

/* WX^f[^ǂݍ݂܂B
 * [in]
 *	sdsp		SDSP\́B
 * [out]
 *	߂l		WX^f[^B
 * [note]
 *	* ǂݍރWX^́A炩sdsp_addr_write()Őݒ肵Ă܂B
 *	* S-SMPCԂ$00F3ԒnREADɑ܂B
 */
unsigned char sdsp_data_read(SDSP* sdsp);

/* WX^f[^݂܂B
 * [in]
 *	sdsp		SDSP\́B
 *	data		WX^f[^B
 * [note]
 *	* ރWX^́A炩sdsp_addr_write()Őݒ肵Ă܂B
 *	* S-SMPCԂ$00F3ԒnWRITEɑ܂B
 */
void sdsp_data_write(SDSP* sdsp, unsigned char data);

/* w肳ꂽTṽ~LVOs܂B
 * [in]
 *	sdsp		SDSP\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void sdsp_mix(SDSP* sdsp, short wbuff[/*count*/], int count);

#endif /*__CLIP_SDS_H__*/
