/*	
 *	clipsckb.c
 *
 *	IXN[L[{[h
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Tue Dec 03 23:45:04 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/

static ST_ScrKbd stScrKbd;

/****************************************************************************
 *	[J萔
 ****************************************************************************/

typedef struct _ST_ScrKbd_Key {
	unsigned char  Dir[4];		/* [0]=EړCfNX,[1]=ړCfNX,[2]=ړCfNX,[3]=ړCfNX */
	unsigned char  Pos[4];		/* [0]=XW,[1]=YW,[2]=,[3]= */
	unsigned short KeySym[2];	/* [0]=L[V,[1]=VtgԃL[V */
} ST_ScrKbd_Key;
static const ST_ScrKbd_Key TBL_ScrKbd_Key[] = {
	{{ 1,15,16,76},{ 2, 2, 3, 3},{XK_Escape      ,XK_Escape     }},// 0
	{{ 2, 0,17,78},{ 6, 2, 3, 3},{XK_F1          ,XK_F1         }},// 1
	{{ 3, 1,18,78},{ 8, 2, 3, 3},{XK_F2          ,XK_F2         }},// 2
	{{ 4, 2,19,78},{10, 2, 3, 3},{XK_F3          ,XK_F3         }},// 3
	{{ 5, 3,20,78},{12, 2, 3, 3},{XK_F4          ,XK_F4         }},// 4
	{{ 6, 4,21,78},{15, 2, 3, 3},{XK_F5          ,XK_F5         }},// 5
	{{ 7, 5,22,78},{17, 2, 3, 3},{XK_F6          ,XK_F6         }},// 6
	{{ 8, 6,23,78},{19, 2, 3, 3},{XK_F7          ,XK_F7         }},// 7
	{{ 9, 7,24,78},{21, 2, 3, 3},{XK_F8          ,XK_F8         }},// 8
	{{10, 8,25,78},{24, 2, 3, 3},{XK_F9          ,XK_F9         }},// 9
	{{11, 9,26,78},{26, 2, 3, 3},{XK_F10         ,XK_F10        }},//10
	{{12,10,27,78},{28, 2, 3, 3},{XK_F11         ,XK_F11        }},//11
	{{13,11,28,78},{30, 2, 3, 3},{XK_F12         ,XK_F12        }},//12
	{{14,12,30,81},{34, 2, 3, 3},{XK_Print       ,XK_Print      }},//13
	{{15,13,31,82},{36, 2, 3, 3},{XK_Scroll_Lock ,XK_Scroll_Lock}},//14
	{{ 0,14,32,83},{38, 2, 3, 3},{XK_Pause       ,XK_Pause      }},//15
	{{17,32,33, 0},{ 2, 6, 3, 3},{XK_quoteleft   ,XK_asciitilde }},//16
	{{18,16,34, 1},{ 4, 6, 3, 3},{XK_1           ,XK_exclam     }},//17
	{{19,17,35, 2},{ 6, 6, 3, 3},{XK_2           ,XK_at         }},//18
	{{20,18,36, 3},{ 8, 6, 3, 3},{XK_3           ,XK_numbersign }},//19
	{{21,19,37, 4},{10, 6, 3, 3},{XK_4           ,XK_dollar     }},//20
	{{22,20,38, 5},{12, 6, 3, 3},{XK_5           ,XK_percent    }},//21
	{{23,21,39, 6},{14, 6, 3, 3},{XK_6           ,XK_asciicircum}},//22
	{{24,22,40, 7},{16, 6, 3, 3},{XK_7           ,XK_ampersand  }},//23
	{{25,23,41, 8},{18, 6, 3, 3},{XK_8           ,XK_asterisk   }},//24
	{{26,24,42, 9},{20, 6, 3, 3},{XK_9           ,XK_parenleft  }},//25
	{{27,25,43,10},{22, 6, 3, 3},{XK_0           ,XK_parenright }},//26
	{{28,26,44,11},{24, 6, 3, 3},{XK_minus       ,XK_underscore }},//27
	{{29,27,45,12},{26, 6, 3, 3},{XK_equal       ,XK_plus       }},//28
	{{30,28,46,80},{28, 6, 5, 3},{XK_BackSpace   ,XK_BackSpace  }},//29
	{{31,29,47,13},{34, 6, 3, 3},{XK_Insert      ,XK_Insert     }},//30
	{{32,30,48,14},{36, 6, 3, 3},{XK_Home        ,XK_Home       }},//31
	{{16,31,49,15},{38, 6, 3, 3},{XK_Prior       ,XK_Prior      }},//32
	{{34,49,50,16},{ 2, 8, 4, 3},{XK_Tab         ,XK_Tab        }},//33
	{{35,33,51,17},{ 5, 8, 3, 3},{XK_q           ,XK_Q          }},//34
	{{36,34,51,18},{ 7, 8, 3, 3},{XK_w           ,XK_W          }},//35
	{{37,35,52,19},{ 9, 8, 3, 3},{XK_e           ,XK_E          }},//36
	{{38,36,53,20},{11, 8, 3, 3},{XK_r           ,XK_R          }},//37
	{{39,37,54,21},{13, 8, 3, 3},{XK_t           ,XK_T          }},//38
	{{40,38,55,22},{15, 8, 3, 3},{XK_y           ,XK_Y          }},//39
	{{41,39,56,23},{17, 8, 3, 3},{XK_u           ,XK_U          }},//40
	{{42,40,57,24},{19, 8, 3, 3},{XK_i           ,XK_I          }},//41
	{{43,41,58,25},{21, 8, 3, 3},{XK_o           ,XK_O          }},//42
	{{44,42,59,26},{23, 8, 3, 3},{XK_p           ,XK_P          }},//43
	{{45,43,60,27},{25, 8, 3, 3},{XK_bracketleft ,XK_braceleft  }},//44
	{{46,44,61,28},{27, 8, 3, 3},{XK_bracketright,XK_braceright }},//45
	{{47,45,62,29},{29, 8, 4, 3},{XK_backslash   ,XK_bar        }},//46
	{{48,46,81,30},{34, 8, 3, 3},{XK_Delete      ,XK_Delete     }},//47
	{{49,47,75,31},{36, 8, 3, 3},{XK_End         ,XK_End        }},//48
	{{33,48,83,32},{38, 8, 3, 3},{XK_Next        ,XK_Next       }},//49
	{{51,62,63,33},{ 2,10, 5, 3},{XK_Caps_Lock   ,XK_Caps_Lock  }},//50
	{{52,50,64,35},{ 6,10, 3, 3},{XK_a           ,XK_A          }},//51
	{{53,51,65,36},{ 8,10, 3, 3},{XK_s           ,XK_S          }},//52
	{{54,52,66,37},{10,10, 3, 3},{XK_d           ,XK_D          }},//53
	{{55,53,67,38},{12,10, 3, 3},{XK_f           ,XK_F          }},//54
	{{56,54,68,39},{14,10, 3, 3},{XK_g           ,XK_G          }},//55
	{{57,55,69,40},{16,10, 3, 3},{XK_h           ,XK_H          }},//56
	{{58,56,70,41},{18,10, 3, 3},{XK_j           ,XK_J          }},//57
	{{59,57,71,42},{20,10, 3, 3},{XK_k           ,XK_K          }},//58
	{{60,58,72,43},{22,10, 3, 3},{XK_l           ,XK_L          }},//59
	{{61,59,73,44},{24,10, 3, 3},{XK_semicolon   ,XK_colon      }},//60
	{{62,60,73,45},{26,10, 3, 3},{XK_quoteright  ,XK_quotedbl   }},//61
	{{50,61,75,46},{28,10, 5, 3},{XK_Return      ,XK_Return     }},//62
	{{64,75,76,50},{ 2,12, 6, 3},{XK_Shift_L     ,XK_Shift_L    }},//63
	{{65,63,78,51},{ 7,12, 3, 3},{XK_z           ,XK_Z          }},//64
	{{66,64,78,52},{ 9,12, 3, 3},{XK_x           ,XK_X          }},//65
	{{67,65,78,53},{11,12, 3, 3},{XK_c           ,XK_C          }},//66
	{{68,66,78,54},{13,12, 3, 3},{XK_v           ,XK_V          }},//67
	{{69,67,78,55},{15,12, 3, 3},{XK_b           ,XK_B          }},//68
	{{70,68,78,56},{17,12, 3, 3},{XK_n           ,XK_N          }},//69
	{{71,69,78,57},{19,12, 3, 3},{XK_m           ,XK_M          }},//70
	{{72,70,78,58},{21,12, 3, 3},{XK_comma       ,XK_less       }},//71
	{{73,71,78,59},{23,12, 3, 3},{XK_period      ,XK_greater    }},//72
	{{74,72,78,60},{25,12, 3, 3},{XK_slash       ,XK_question   }},//73
	{{75,73,80,62},{27,12, 6, 3},{XK_Shift_R     ,XK_Shift_R    }},//74
	{{63,74,82,48},{36,12, 3, 3},{XK_Up          ,XK_Up         }},//75
	{{77,83, 0,63},{ 2,14, 4, 3},{XK_Control_L   ,XK_Control_L  }},//76
	{{78,76, 0,63},{ 7,14, 4, 3},{XK_Alt_L       ,XK_Alt_L      }},//77
	{{79,77, 7,69},{10,14,15, 3},{XK_space       ,XK_space      }},//78
	{{80,78,29,74},{24,14, 4, 3},{XK_Alt_R       ,XK_Alt_R      }},//79
	{{81,79,29,74},{29,14, 4, 3},{XK_Control_R   ,XK_Control_R  }},//80
	{{82,80,13,47},{34,14, 3, 3},{XK_Left        ,XK_Left       }},//81
	{{83,81,14,75},{36,14, 3, 3},{XK_Down        ,XK_Down       }},//82
	{{76,82,15,49},{38,14, 3, 3},{XK_Right       ,XK_Right      }},//83
};
#define ScrKbd_W        43
#define ScrKbd_H           19
#define SIZE_ScrKbd_Key ARRAY_SIZE(TBL_ScrKbd_Key)

/****************************************************************************
 *	
 ****************************************************************************/

void ScrKbd_Init() {
	/* \̂NA܂B */
	memset(&stScrKbd, 0, sizeof stScrKbd);
	/* lݒ肵܂B */
//	stScrKbd.iKey           = 0;	/* 0`(SIZE_ScrKbd_Key-1) */
//	stScrKbd.x = stScrKbd.y = 0;	/* \ʒu */
	stScrKbd.Foreground     = 3;	/* OiF */
//	stScrKbd.Background     = 0;	/* wiF */
	stScrKbd.ActiveColor    = 2;	/* orbNF */
}

/****************************************************************************
 *	
 ****************************************************************************/

void ScrKbd_SetPos(int x, int y) {
	/* \ʒui[܂B */
	stScrKbd.x = x;
	stScrKbd.y = y;
}

/****************************************************************************
 *	
 ****************************************************************************/

void ScrKbd_SetColor(int Foreground, int Background, int ActiveColor) {
	/* Fi[܂B */
	stScrKbd.Foreground  = Foreground;
	stScrKbd.Background  = Background;
	stScrKbd.ActiveColor = ActiveColor;
}

/****************************************************************************
 *	
 ****************************************************************************/

int ScrKbd_Exec(int joy, int* state/*NULL*/) {
	/* ̑sÓACL[̘_IȏԂi[܂B
	 * - uÓvԂi[Ƃ́AX Window System̃Cxgstatep[^̋ɕ킢܂B
	 */
	if(state) {
		*state = (stScrKbd.Flag.Caps_Lock<<0)
		       | (stScrKbd.Flag.Control  <<1)
		       | (stScrKbd.Flag.Shift    <<2)
		       | (stScrKbd.Flag.Alt      <<3);
	}
	/* L[Iړ܂B */
	if(joy & TRG_RI) { stScrKbd.iKey = TBL_ScrKbd_Key[stScrKbd.iKey].Dir[0]; }
	if(joy & TRG_LF) { stScrKbd.iKey = TBL_ScrKbd_Key[stScrKbd.iKey].Dir[1]; }
	if(joy & TRG_DN) { stScrKbd.iKey = TBL_ScrKbd_Key[stScrKbd.iKey].Dir[2]; }
	if(joy & TRG_UP) { stScrKbd.iKey = TBL_ScrKbd_Key[stScrKbd.iKey].Dir[3]; }
	/* L[܂B */
	if(joy & TRG_A) {
		/* VtgԂɉAL[V擾܂B */
		int KeySym = TBL_ScrKbd_Key[stScrKbd.iKey].KeySym[stScrKbd.Flag.Caps_Lock ^ stScrKbd.Flag.Shift];
		/* CL[Ȃ΁ACaps Lock,Control,Shift,Alt̘_IȏԂ𔽓]܂B */
		switch(KeySym) {
		case XK_Caps_Lock:
			stScrKbd.Flag.Caps_Lock ^= 1;
			break;
		case XK_Control_L:
		case XK_Control_R:
			stScrKbd.Flag.Control ^= 1;
			break;
		case XK_Shift_L:
		case XK_Shift_R:
			stScrKbd.Flag.Shift ^= 1;
			break;
		case XK_Alt_L:
		case XK_Alt_R:
			stScrKbd.Flag.Alt ^= 1;
			break;
		default:
			/* LȊÕL[Ȃ΁Aȍ~Control,Shift,Altꂽ̂ƌȂƂɂ܂B */
			stScrKbd.Flag.Control = 0;
			stScrKbd.Flag.Shift = 0;
			stScrKbd.Flag.Alt = 0;
			break;
		}
		return KeySym;
	}
	/* L[CxgȂ΁A0Ԃ܂B */
	return 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

void ScrKbd_Draw(RENDER* r) {
	int iKey, Active;
	const ST_ScrKbd_Key* pKey;

	/* L[{[hŜ̘g`܂B */
	render_rectangle(r,
		stScrKbd.x,
		stScrKbd.y,
		ScrKbd_W,
		ScrKbd_H,
		stScrKbd.Foreground);
	/* L[{[hŜ̔wihׂ܂B */
	render_rectangle_fill(r,
		stScrKbd.x + 1,
		stScrKbd.y + 1,
		ScrKbd_W - 2,
		ScrKbd_H - 2,
		stScrKbd.Background);
	/* eL[ɂāc */
	for(iKey = 0; iKey < SIZE_ScrKbd_Key; iKey++) {
		pKey = &TBL_ScrKbd_Key[iKey];
		/* IĂL[ȊOȂ΁c */
		if(stScrKbd.iKey != iKey) {
			/* L[̘g`܂B */
			render_rectangle(r,
				stScrKbd.x + pKey->Pos[0],
				stScrKbd.y + pKey->Pos[1],
				             pKey->Pos[2],
				             pKey->Pos[3],
				stScrKbd.Foreground);
			/* _IȏԂĂL[Ȃ΁AANeBuFœhׂ܂B
			 * łȂ΁AɃL[{[hŜ̔wiFœhׂĂ̂ŁAhׂKv͗L܂B
			 */
			Active = 0;
			switch(pKey->KeySym[0]) {
			case XK_Caps_Lock:
				if(stScrKbd.Flag.Caps_Lock) { Active = 1; }
				break;
			case XK_Control_L:
			case XK_Control_R:
				if(stScrKbd.Flag.Control) { Active = 1; }
				break;
			case XK_Shift_L:
			case XK_Shift_R:
				if(stScrKbd.Flag.Shift) { Active = 1; }
				break;
			case XK_Alt_L:
			case XK_Alt_R:
				if(stScrKbd.Flag.Alt) { Active = 1; }
				break;
			}
			if(Active) {
				render_rectangle_fill(r,
					stScrKbd.x + pKey->Pos[0] + 1,
					stScrKbd.y + pKey->Pos[1] + 1,
					             pKey->Pos[2] - 2,
					             pKey->Pos[3] - 2,
					stScrKbd.ActiveColor);
			}
		}
	}
	/* IĂL[ɂāc */
	pKey = &TBL_ScrKbd_Key[stScrKbd.iKey];
	/* L[̘gA傫`܂B */
	render_rectangle(r,
		stScrKbd.x + pKey->Pos[0] - 1,
		stScrKbd.y + pKey->Pos[1] - 1,
		             pKey->Pos[2] + 2,
		             pKey->Pos[3] + 2,
		stScrKbd.Foreground);
	/* L[̔wiA傫hׂ܂B
	 * ׂ̃L[̘gɔĂ̂ŁA_IȏԂĂȂL[łĂAwiFŏh肷KvL܂B
	 */
	Active = 0;
	switch(pKey->KeySym[0]) {
	case XK_Caps_Lock:
		if(stScrKbd.Flag.Caps_Lock) { Active = 1; }
		break;
	case XK_Control_L:
	case XK_Control_R:
		if(stScrKbd.Flag.Control) { Active = 1; }
		break;
	case XK_Shift_L:
	case XK_Shift_R:
		if(stScrKbd.Flag.Shift) { Active = 1; }
		break;
	case XK_Alt_L:
	case XK_Alt_R:
		if(stScrKbd.Flag.Alt) { Active = 1; }
		break;
	}
	render_rectangle_fill(r,
		stScrKbd.x + pKey->Pos[0],
		stScrKbd.y + pKey->Pos[1],
		             pKey->Pos[2],
		             pKey->Pos[3],
		Active ? stScrKbd.ActiveColor : stScrKbd.Background);
}

