/*	
 *	clipsap.h
 *
 *	P/ECE SAP Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Jan 26 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SAP_H__
#define __CLIP_SAP_H__

typedef struct _SAPDRIVER SAPDRIVER;

/****************************************************************************
 *	SAPt@C`
 ****************************************************************************/

/*
 *	SAPt@Cwb_
 *
 *	SAPt@Cwb_͍sPʂ̃eLXg`łB
 *	SAPHEADER\̂ƃoCivł͂܂B
 */
typedef struct _SAPHEADER {
	char author[32];	/* Name of composer */
	char name[32];		/* Song title */
	char date[32];		/* Copyright year or yrar of creation */
	char type;		/* Player type */
	unsigned short player;	/* Address of player part which will be executed in 1/50 sec intervals */
	unsigned short music;	/* Address with music data (for C type) */
	unsigned short init;	/* Address of player part which will init player (for all types except C) */
	int songs;		/* Number of songs */
	int defsong;		/* First song which will be played when .sap will be loaded */
	int fastplay;		/* Number of lines between each call of playing routine */
	int stereo;		/* Tune uses dual POKEY configuration */
} SAPHEADER;

/****************************************************************************
 *	SAPhCo
 ****************************************************************************/

#define SAPBUFLEN	320		/* 1[tick](=1/50[sec])̃Tv */

#define SAP_CLOCK	1773447		/* PAL  CPUPOKEYNbN[Hz] (ʂł) */
//#define SAP_CLOCK	1789772		/* NTSC CPUPOKEYNbN[Hz] (ʂł) */
/* POKEY Chip ł64KHzNbŃÅ{NbN28B */
/* 15KHzNbŃA{NbN28~4=112Đ܂B */

/*
 *	SAPhCo
 */
/*typedef*/ struct _SAPDRIVER {
	/*{{M6502RAREADO֐g߁ACAEgŒ*/
	M6502 m6502;			/* 6502 Core */
	unsigned char mem[0x10000];	/* Main Memory */
	/*}}M6502RAREADO֐g߁ACAEgŒ*/
	POKEY pokey;			/* POKEY Chip */
	//
	SAPHEADER header;		/* SAPt@Cwb_ */
	//
	DDA samples_dda;		/* 荞݊Ԋȕo̓TvvZpDDA */
	int samples;			/* 񊄂荞ݔ܂ł̎co̓Tv */
} /*SAPDRIVER*/;

/*
 *	M6502G~[VpO֐
 *
 *	SAP_IO_READV{`ƁAI/O READɑΉ܂B
 *	SAPt@ĆAI/O READɑΉȂĂtł悤łB
 *	I/O READɑΉ6502G~[VȂxȂ̂ŁA
 *	ʏSAP_IO_READV{`ȂŉB
 */
//#define SAP_IO_READ
#ifdef SAP_IO_READ /* I/O READΉ̂ */
unsigned char sap_m6502_read(M6502* m6502, unsigned short addr);
unsigned char sap_m6502_in(M6502* m6502, unsigned short addr);
#endif /*SAP_IO_READ*/
void sap_m6502_write(M6502* m6502, unsigned short addr, unsigned char data);
void sap_m6502_out(M6502* m6502, unsigned short addr, unsigned char data);

/*
 *	SAPhCo֐
 */
void sap_m6502_setup(SAPDRIVER* sap, int a, int x, int y, int pc);
int sap_init(SAPDRIVER* sap, const void* _data, int len, int i_song);
const void* sap_init_header(SAPHEADER* header, const void* _data);
int sap_mix(SAPDRIVER* sap, short* wbuff);
int sap_stream_callback(short* wbuff, int param);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* SAPt@C̍ĐJn܂B
 * [in]
 *	data		SAPf[^̐擪AhXB
 *	len		SAPf[^̃oCgB
 *	i_song		gbNԍB(0`)
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKsap_stop()ĂŁAxN^𕜌ĂB
 */
int sap_play(const void* data, int len, int i_song);

/* SAPt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void sap_stop();

#endif /*__CLIP_SAP_H__*/
