/*
 *	cliprudc.h
 *
 *	pX[^[̑`(Ramp-up/Down control)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Wed Apr 23 21:55:05 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Mon May 05 14:59:40 JST 2014 Naoyuki Sawa
 *	- RudCtlCh_Move()CAݒ~,,S̈ړʂ0Ȃ΁AȂ悤ɂ܂B
 *	  ̔fsȂƁAumove 0vumove 0vƎsA~㎥݂̂̃foCXsxsĂ܂łB
 *	  ڏ͂ł\܂񂪁Ad̖͂ʂɂȂ܂B
 *	* Mon May 05 19:19:03 JST 2014 Naoyuki Sawa
 *	- ~㎥Ԃǉ܂B
 *	- ܂ł́A~,,~㓮vsĂ߁A~㎥[ɍsȂ肪܂B
 *	  ~㎥ԂǉƂɂāA~A~㎥I҂ĂA~㓮vs悤ɂȂ܂B
 *	- ARudCtlCh_Move()RudCtlCh_Stop()́A̔fɁA~㎥ۂl܂B
 *	  ~㎥RudCtlCh_Move()sꍇA~㎥̏I҂ɁAɐVJn܂B(܂łƓ)
 *	  ~㎥RudCtlCh_Stop()sꍇAV~JnɁA݂̒~㎥p܂B(܂łƓ)
 *	* Tue May 06 15:46:46 JST 2014 Naoyuki Sawa
 *	- ړ̃ZTGbW𖳎Ȃ@ύXARudCtlCh_Exec()Ŕf悤ɂ܂B
 *	  ̕ύXɂāA쎞̓ʏ͕svɂȂ܂B
 *	* Thu May 29 00:28:30 JST 2014 Naoyuki Sawa
 *	- ~̓ɂāAڕW䂪N傫(=x)ꍇ́AڕWŋN悤ɏC܂B
 *	  ~̓ɂāAڕW䂪~傫(=x)ꍇ́AڕWŒ~悤ɏC܂B
 *	  쒆̒~ɂāAݕ䂪~傫(=x)ꍇ́AݕŒ~悤ɏC܂B
 *	* Wed Jun 11 21:00:52 JST 2014 Naoyuki Sawa
 *	- RudCtlCh_Exec()C܂BC_́Aȉ̒ʂł:
 *	  uZTGbWt߂Œ~ہA~㎥ɐUĕsȕ̃ZTGbW𕡐񌟏oA2ڂ{ƌȂč̗pĂĂ܂vƂ肪B
 *	  邽߂ɁA~,,~㎥́ASpuriousSnsEdgeDetected̃rbgZbgȂƂɂB
 *	* Thu Nov 27 18:54:32 JST 2014 Naoyuki Sawa
 *	- pX[^[̒ڐǉ܂B
 *	  ́AKvɔĂނǉ@\łAϋɓIɎg͂܂B
 *	  ύXɂĂAȂׂ̎ύXȂ悤AӂĕύX܂B
 *	  ύXӏ́u//{{2014/11/27ǉ:pX[^[̒ڐǉ܂Bvň͂ĂB
 */
#ifndef __CLIP_RUDC_H__
#define __CLIP_RUDC_H__

/****************************************************************************
 *	pX[^[̑`(Ramp-up/Down control) - Ǘ
 ****************************************************************************/
#define RudCtlCh_Max 3 /* ``lԍ̍ől(̒l܂) */		//B(3+1)`lőȂꍇ́A₵ĂB
/*--------------------------------------------------------------------------*/
/* v */
typedef struct _ST_RudCtlReq {
	 uint8_t Cond;			/* s(RudCtlReq_If_*,,RudCtlReq_When_*) */
	 uint8_t PosType;		/* ʒuw@(RudCtlReq_Abs,,RudCtlReq_Rel) */
	 int16_t Pos;			/* ʒu */
	uint16_t Spd;			/* ڕW */			//őŗǂ0w肵č\ȂBڕW̉l̒lw肷ƁARudCtlCh_Move()Iɕ␳B
//ȗ	 uint8_t s,t;			/* x[pps/clk] */			//ṽp[^ŁAxwł悤ĂǂApقڎgȂ̂ŏȗBx͏ɁAST_RudCtlChInfo.r1/s1,,r2/s2gp邱ƂɂBKvɂȂAṽp[^ɒǉďB
} ST_RudCtlReq;
/* ST_RudCtlReq.Cond(sv̏ꍇ) */
#define RudCtlReq_If_Never	0	/* sȂ */			//
#define RudCtlReq_If_SnsOn	1	/* ZTOnȂΎs */		//
#define RudCtlReq_If_SnsOff	2	/* ZTOffȂΎs */		//
#define RudCtlReq_If_Always	3	/* Ŏs */			//
/* ST_RudCtlReq.Cond(Cxgsv̏ꍇ) */					//@	CxgsACxgsv̂܂ܑsvɓn悤ACond̒l݌vB
#define RudCtlReq_When_Never	0	/* sȂ */			//	Ⴆ΁AZTOnGbW(1)AZTOn(1)sɈvāAsB
#define RudCtlReq_When_SnsRise	1	/* ZTOnGbWŎs */		//	̓Iɂ́ARudCtlCh_Exec()̎QƂB
#define RudCtlReq_When_SnsFall	2	/* ZTOffGbWŎs */		//
#define RudCtlReq_When_SnsEdge	3	/* ZTGbWŎs */		//
//{{2014/11/27ǉ:pX[^[̒ڐǉ܂B
/* ST_RudCtlReq.Cond(ڐ̏ꍇ) */
#define RudCtlReq_Cond_Direct	(1<<7)	/* ڐ䒆ł邱ƂtO */	//̃tOݒ肷֐RudCtlCh_MoveDirect()݂̂łBAvP[VIɐݒ/QƂ邱Ƃ͖B
//}}2014/11/27ǉ:pX[^[̒ڐǉ܂B
/* ST_RudCtlReq.PosType */
#define RudCtlReq_Rel		0	/* Έʒuw */
#define RudCtlReq_Abs		1	/* Έʒuw */
/*--- O[o萔 ---*/
//̎sv
// - ̎svpɂɎgp̂ŁA萔ƂĒ`ĂƂɂB
//   gp: RudCtlCh_Move(pRudCtlCh, ReqImm, stRudCtlReq_Never/**/);
extern const ST_RudCtlReq stRudCtlReq_Never;
/*--------------------------------------------------------------------------*/
/* p[^ */
typedef struct _ST_RudCtlAct {
	 int16_t d;			/* ړ(0=,1=t) */	//{0,1}ȊO̒l͕sł邱ƂɒӂB
	uint16_t n[3+1+3];		/* 1,2,3AڕWA3,2,1 */
	uint16_t p[3+1+3];		/* Ԉړ1,2,3[pulse]AڕWxړ[pulse]AԈړ3,2,1[pulse] */
} ST_RudCtlAct;
/* ST_RudCtlAct̃tB[h𒼐ڃANZXAL̃}NgpB */
#define RudCtlAct_d(  pRudCtlAct) ((pRudCtlAct)->d   )	/* ړ */
#define RudCtlAct_n11(pRudCtlAct) ((pRudCtlAct)->n[0])	/* 1 */
#define RudCtlAct_n12(pRudCtlAct) ((pRudCtlAct)->n[1])	/* 2 */
#define RudCtlAct_n13(pRudCtlAct) ((pRudCtlAct)->n[2])	/* 3 */
#define RudCtlAct_n(  pRudCtlAct) ((pRudCtlAct)->n[3])	/* ڕW */
#define RudCtlAct_n23(pRudCtlAct) ((pRudCtlAct)->n[4])	/* 1 */
#define RudCtlAct_n22(pRudCtlAct) ((pRudCtlAct)->n[5])	/* 2 */
#define RudCtlAct_n21(pRudCtlAct) ((pRudCtlAct)->n[6])	/* 3 */
#define RudCtlAct_p11(pRudCtlAct) ((pRudCtlAct)->p[0])	/* Ԉړ3[pulse] */
#define RudCtlAct_p12(pRudCtlAct) ((pRudCtlAct)->p[1])	/* Ԉړ2[pulse] */
#define RudCtlAct_p13(pRudCtlAct) ((pRudCtlAct)->p[2])	/* Ԉړ1[pulse] */
#define RudCtlAct_p(  pRudCtlAct) ((pRudCtlAct)->p[3])	/* ڕWxړ[pulse] */
#define RudCtlAct_p23(pRudCtlAct) ((pRudCtlAct)->p[4])	/* Ԉړ3[pulse] */
#define RudCtlAct_p22(pRudCtlAct) ((pRudCtlAct)->p[5])	/* Ԉړ2[pulse] */
#define RudCtlAct_p21(pRudCtlAct) ((pRudCtlAct)->p[6])	/* Ԉړ1[pulse] */
/*--------------------------------------------------------------------------*/
/* ``l */
typedef struct _ST_RudCtlChInfo {
	uint16_t Sns;			/* ZT}XN */			//ZT̃rbgʒu16bit͈͓łƉ肵BłȂꍇuint32_tɕύXB
	uint16_t Bac;			/* obNbV[pulse] */
	struct {
		/* ʒu */
		 int16_t PosLim;	/* Eʒu */				//PosPosLim𒴂APosFixɏB
		 int16_t PosFix;	/* Cʒu */				//ړȂ΁ADir[0].PosLim=Dir[0].PosFixADir[1].PosLim=Dir[1].PosFixƂ̂ǂB]ړȂ΁ADir[0].PosLim=Dir[1].PosFixADir[1].PosLim=Dir[0].PosFixƂ̂ǂB
		 int16_t PosSns;	/* ZTOnGbWʒu */		//ZTOnGbWoA Dir[0].PosSns  ɏBtZTOnGbWoA Dir[1].PosSns  ɏB	//ړ̏ꍇ(ɂ͈ړ͈͂̒[ɃZTo͈͂L钼ړ̏ꍇ)́AZTOnGbŴ͖ŁA_~[lł邪AtZTOnGbWƓlݒ肹BƋt̃ZTOnGbWʒuǂŁAړ]ړ𔻒fĂ鏈LBRudCtlCh_Exec()RudCtlCh_MoveAbs()QƂB
		/* x */							//tZTOffGbWoADir[0].PosSns-1ɏBZTOffGbWoADir[1].PosSns+1ɏB
		uint16_t n;		/* ڕW̉l */
		uint16_t n1;		/* N̉l */
		uint16_t r1, s1;	/* x[pps/clk]̏l */
		uint16_t n2;		/* ~̉l */
		uint16_t r2, s2;	/* x[pps/clk]̏l */
		/* ~㎥ */
		uint16_t StpTim;	/* ~㎥[clk] */
	} Dir[2];			/* [0]=,[1]=t */
} ST_RudCtlChInfo;
/*--------------------------------------------------------------------------*/
/* ` */
typedef struct _ST_RudCtlInfo {
	void (*fnMove)(int iRudCtlCh, const ST_RudCtlAct* pRudCtlAct);		/* foCXJn֐(AvP[V`) */
//sv	void (*fnStop)(int iRudCtlCh);						/* foCX~֐(AvP[V`) */	//݂̎ł͎gpĂȂB~fnMovegČRɒ~Ă邩B~̋@\ǉ邽߂ɕKvɂȂ畜B݂͖łB
	uint16_t fCLK;								/* {NbN[pps] */
	ST_RudCtlChInfo TBL_RudCtlChInfo[RudCtlCh_Max+1];			/* ``l */				//gpȂ``l̑``ĺAStB[h̒l0ƂĂB
} ST_RudCtlInfo;
/*--------------------------------------------------------------------------*/
/* ``l */
typedef struct _ST_RudCtlCh {
	uint16_t Sns;			/* ZT */			//ɗL				ZTԂ̃rbgтɁAZT}XNKplBL̕@ňԂ𔻒肵AԂƔ肷܂ł͕ωȂB
	uint16_t SnsCnt;		/* ZTݏԃJE^ */		//ɗL				mCYpBZTԂԂƓȂ΁ÃZTԕωɔSnsCnt0ɂBZTԂԂƈႤȂSnsCnt+1A(SnsCnt>=Spd)ɂȂԂƔfBvɁA悻1[pulse]ԃZTԂωȂΈԂƔ肷Bɂ́ASpdω̂Őm1[pulse]Ԃł͂ȂApȂ낤BA~Spd=0Ȃ̂ŏ(SnsCnt>=Spd)łAԂƂȂB
	 int16_t Pos;			/* ݈ʒu */				//ɗL
	uint16_t Spd;			/* ݕ */			//ɗL				(Spd=0ȊO,StpTim=s)c쒆B(Spd=0,StpTim=0ȊO)c~,,~㎥B(Spd=0,StpTim=0)c~,,㎥B
	uint16_t StpTim;		/* c~㎥[clk] */		//ɗL				~ԂSpd݂̂Ŕf邩ASpdStpTimŔf邩́AʂɂBRudCtlCh_Move()RudCtlCh_Stop()ł́ASpd݂̂ŔfBRudCtlCh_Exec()Œ~㓮vśASpdStpTimŔfB
	uint16_t Cnt;			/* ݌oߎ[clk] */			//~͖
	uint16_t DivCnt;		/* ݕ̕JE^ */		//~͖
	uint16_t BacCnt;		/* obNbVJE^[pulse] */	//~͖				t]JnɃZbgBBacCntcĂԁAPosωȂB
	ST_RudCtlAct Act;		/* p[^ */			//~Ō̓p[^ێ	~ST_RudCtlCh.Act.d́AOړӖ(obNbVɎgp)BN͑Oړsł邪AOړ=0()ƌȂƂɂB
//sv	ST_RudCtlReq ReqImm1;		/* sv(sv) */
	ST_RudCtlReq ReqEvt1;		/* sv(Cxgsv) */
	ST_RudCtlReq ReqImm2;		/* ~㓮v(sv) */
	ST_RudCtlReq ReqEvt2;		/* ~㓮v(Cxgsv) */
} ST_RudCtlCh;
/*--- O[o֐ ---*/
void RudCtlCh_Move(int iRudCtlCh, ST_RudCtlReq ReqImm/*sv*/, ST_RudCtlReq ReqEvt/*Cxgsv*/);
void RudCtlCh_Stop(int iRudCtlCh);
/*--------------------------------------------------------------------------*/
/* ` */
typedef struct _ST_RudCtl {
	const ST_RudCtlInfo* pRudCtlInfo;		/* `ւ̃|C^ */
	ST_RudCtlCh TBL_RudCtlCh[RudCtlCh_Max+1];	/* ``l */		//yӁzɂvolatileł邪RpCœKjQ̂volatileȗBO珑ł͂ȂBOǏo͊֐oRB1word̓ǏoɌ蒼ړǏoĂ\ȂArW[[vŊĎĂ͂ȂB(RpCœKĈ񂵂ǏoȂ)
} ST_RudCtl;
/* OST_RudCtl.TBL_RudCtlCh[]ɃANZXꍇ́AL̃}NgpB */
#define RudCtlCh_Get(iRudCtlCh)		(&((volatile ST_RudCtl*)&stRudCtl)->TBL_RudCtlCh[iRudCtlCh])
#define RudCtlCh_GetPos(iRudCtlCh)	(RudCtlCh_Get(iRudCtlCh)->Pos)		//
#define RudCtlCh_GetSpd(iRudCtlCh)	(RudCtlCh_Get(iRudCtlCh)->Spd)		//pɂɎQƂtB[ĥ݃}N`BȊÕtB[h́AuRudCtlCh_Get()->tB[hvŎQƂB
#define RudCtlCh_GetStpTim(iRudCtlCh)	(RudCtlCh_Get(iRudCtlCh)->StpTim)	//
/*--- O[oϐ ---*/
extern ST_RudCtl stRudCtl;
/*--- O[o֐ ---*/
void RudCtl_Init(const ST_RudCtlInfo* pRudCtlInfo);
void RudCtl_Exec(int Sns/*ZTԂ̃rbg*/);

/****************************************************************************
 *	AvP[Vp̃[eBeB}N
 ****************************************************************************/
/* w肵``lԍɑΉA``lɃANZX}NBȕւ̂߂ɒ`̂ŁAgpȂĂ\ȂBST_RudCtl.pRudCtlInfóAAvP[VRudCtl_Init()Ɏw肵|C^̂܂܊i[Ă邾łBAvP[VST_RudCtlInfoێĂ͂A𒼐ڎQƂĂ\ȂB */
#define RudCtlCh_GetInfo(iRudCtlCh)	(&stRudCtl.pRudCtlInfo->TBL_RudCtlChInfo[iRudCtlCh])
#define RudCtlCh_GetPosLim(iRudCtlCh,d)	(RudCtlCh_GetInfo(iRudCtlCh)->Dir[d].PosLim)						//
#define RudCtlCh_GetPosSns(iRudCtlCh,d)	(RudCtlCh_GetInfo(iRudCtlCh)->Dir[d].PosSns)						//pɂɎQƂtB[ĥ݃}N`BȊÕtB[h́AuRudCtlCh_GetInfo()->tB[hvŎQƂB
#define RudCtlCh_GetWidth(iRudCtlCh)	(RudCtlCh_GetPosLim(iRudCtlCh,0)-RudCtlCh_GetPosLim(iRudCtlCh,1)+1) //őړ	//

/****************************************************************************
 *	AvP[Vp̃[eBeB֐
 ****************************************************************************/
/* PȐprȂ΁ARudCtlCh_Move()RudCtlCh_Stop()𒼐ڎgpȂĂAL̎Oނ̊֐ŗpƎv܂B */
void RudCtlCh_MoveInit(int iRudCtlCh);
void RudCtlCh_MoveAbs(int iRudCtlCh, int Pos/*Έʒu*/, int Spd/*0=ő*/);
void RudCtlCh_MoveRel(int iRudCtlCh, int Pos/*Έʒu*/, int Spd/*0=ő*/);

//{{2014/11/27ǉ:pX[^[̒ڐǉ܂B
/****************************************************************************
 *	pX[^[̒ڐ
 ****************************************************************************/
void RudCtlCh_MoveDirect(int iRudCtlCh, int RelPos, int Spd, int StaCond, int StpCond);
void RudCtlCh_StopDirect(int iRudCtlCh);
//}}2014/11/27ǉ:pX[^[̒ڐǉ܂B

#endif/*__CLIP_RUDC_H__*/
