
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		REG_open_key
		.global		REG_get_value
		.global		REG_get_string
REG_open_key:
		;//%r12 := keyBody
		;//%r13 := keyName
		jp.d		REG_open_get				;//
		ld.w		%r14, 0					;//%r14    := flag = 0												*delay*
REG_get_string:
		;//%r12 := keyBody
		;//%r13 := stringName
		ld.w		%r14, 1					;//%r14    := flag = 1
REG_open_get:
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8				;//
		cmp		%r12, 0					;//if(!keyBody) { return NULL }
		jreq.d		REG_open_get_RET			;//
		ld.w		%r10, 0					;//%r10    :=            NULL											*delay*
	ld.b	[%sp+0x5],%r13	; 		xld.b		[%sp+5], %r13				;//[%sp+5] := Name2[1] = Name
		sra		%r13, 8					;//%r13    :=            Name >>= 8
	ld.b	[%sp+0x4],%r13	; 		xld.b		[%sp+4], %r13				;//[%sp+4] := Name2[0] = Name
		sra		%r13, 8					;//%r13    :=            Name >>= 8
		jrne		REG_open_get_RET			;//if(Name    ) { return NULL }
		cmp		%r14, 0					;//if(flag) {
		jreq.d		REG_open_get_L10			;//  
		ld.w		%r13, %r12				;//%r13    := keyBody												*delay*
		ld.ub		%r10, [%r12]+				;//  %r10    :=                      nKeyHi                = *keyBody++
		ld.ub		%r13, [%r12]+				;//  %r13    :=                                   nKeyLo   = *keyBody++
		sla		%r10, 8					;//  %r10    :=                      nKeyHi  <<8
		or		%r13, %r10				;//  %r13    :=            nKey   = (nKeyHi  <<8)|nKeyLo
		add		%r12, %r13				;//  %r12    := keyBody +  nKey   * 1
		sla		%r13, 2					;//  %r13    :=            nKey   * 4
		add		%r12, %r13				;//  %r12    := keyBody += nKey   * (2/*keyName*/+3/*keyBodyDist*/)
		ld.ub		%r10, [%r12]+				;//  %r10    :=                      nValueHi              = *keyBody++
		ld.ub		%r13, [%r12]+				;//  %r13    :=                                   nValueLo = *keyBody++
		sla		%r10, 8					;//  %r10    :=                      nValueHi<<8
		or		%r13, %r10				;//  %r13    :=            nValue = (nValueHi<<8)|nValueLo
		sla		%r13, 2					;//  %r13    :=            nValue * (2/*valueName*/+2/*valueData*/)
		add		%r13, %r12				;//  %r13    := keyBody += nValue * (2/*valueName*/+2/*valueData*/)
REG_open_get_L10:							;//}
		ld.w		%r12, %sp				;//%r12    := &[%sp+0]
	ext	REG_name_compar+0x0@h	; 		xld.w		%r10, REG_name_compar			;//%r10    := REG_name_compar
	ext	REG_name_compar+0x0@m
	ld.w	%r10,REG_name_compar+0x0@l
		ld.w		[%r12]+, %r10				;//[%sp+0] := REG_name_compar, %r12 := Name2
		ld.ub		%r10, [%r13]+				;//%r10    :=       nHi         = *keyBody++
		ld.ub		%r14, [%r13]+				;//%r14    :=               nLo = *keyBody++
		sla		%r10, 8					;//%r10    :=       nHi<<8
		or		%r14, %r10				;//%r14    := n  = (nHi<<8)|nLo
	ext	bsearch@rm	; 		xcall.d		bsearch					;//%r10    := keyBody = bsearch(Name2, keyBody, n, (2/*Name*/+3/*Dist*/), REG_name_compar)
	call.d	bsearch@rl
		ld.w		%r15, 5					;//%r15    :=                                      (2/*Name*/+3/*Dist*/)					*delay*
		cmp		%r10, 0					;//if(!keyBody) { return NULL }
		jreq		REG_open_get_RET			;//
		add		%r10, 2					;//%r10    :=                                                             keyBody += 2/*Name*/
		ld.b		%r11, [%r10]+				;//%r11    :=                      DistHi                        = (char)*keyBody++
		ld.ub		%r12, [%r10]+				;//%r12    :=                                 DistMi             =       *keyBody++
		ld.ub		%r13, [%r10]+				;//%r13    :=                                             DistLo =       *keyBody++
		sla		%r11, 8					;//%r11    :=                      DistHi<<8
		or		%r11, %r12				;//%r11    :=                     (DistHi<<8)|DistMi
		sla		%r11, 8					;//%r11    :=                    ((DistHi<<8)|DistMi)<<8
		or		%r11, %r13				;//%r11    :=            Dist = (((DistHi<<8)|DistMi)<<8)|DistLo
		add		%r10, %r11				;//%r10    := keyBody += Dist
REG_open_get_RET:							;//
	add	%sp,0x2		; 		xadd		%sp, %sp, 8				;//
		ret							;//return     keyBody
		;//-----------------------------------------------------;//
REG_get_value:
		;//%r12 := keyBody
		;//%r13 := valueName
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8				;//
		cmp		%r12, 0					;//if(!keyBody ) { return -1 }
		jreq		REG_get_value_RET_M1			;//
	ld.b	[%sp+0x5],%r13	; 		xld.b		[%sp+5], %r13				;//[%sp+5] := valueName2[1] = valueName
		sra		%r13, 8					;//%r13    :=                 valueName >>= 8
	ld.b	[%sp+0x4],%r13	; 		xld.b		[%sp+4], %r13				;//[%sp+4] := valueName2[0] = valueName
		sra		%r13, 8					;//%r13    :=                 valueName >>= 8
		jrne		REG_get_value_RET_M1			;//if(valueName) { return -1 }
		ld.ub		%r10, [%r12]+				;//%r10    :=                    nKeyHi            = *keyBody++
		ld.ub		%r13, [%r12]+				;//%r13    :=                               nKeyLo = *keyBody++
		sla		%r10, 8					;//%r10    :=                    nKeyHi<<8
		or		%r13, %r10				;//%r13    :=            nKey = (nKeyHi<<8)|nKeyLo
		add		%r12, %r13				;//%r12    := keyBody +  nKey * 1
		sla		%r13, 2					;//%r13    :=            nKey * 4
		add		%r13, %r12				;//%r13    := keyBody += nKey * (2/*keyName*/+3/*keyBodyDist*/)
		ld.w		%r12, %sp				;//%r12    := &[%sp+0]
	ext	REG_name_compar+0x0@h	; 		xld.w		%r10, REG_name_compar			;//%r10    := REG_name_compar
	ext	REG_name_compar+0x0@m
	ld.w	%r10,REG_name_compar+0x0@l
		ld.w		[%r12]+, %r10				;//[%sp+0] := REG_name_compar, %r12 := valueName2
		ld.ub		%r10, [%r13]+				;//%r10    :=            nValueHi              = *keyBody++
		ld.ub		%r14, [%r13]+				;//%r14    :=                         nValueLo = *keyBody++
		sla		%r10, 8					;//%r10    :=            nValueHi<<8
		or		%r14, %r10				;//%r14    := nValue  = (nValueHi<<8)|nValueLo
	ext	bsearch@rm	; 		xcall.d		bsearch					;//%r10    := keyBody = bsearch(valueName2, keyBody, nValue, (2/*valueName*/+2/*valueData*/), REG_name_compar)
	call.d	bsearch@rl
		ld.w		%r15, 4					;//%r15    :=                                                (2/*valueName*/+2/*valueData*/)			*delay*
		cmp		%r10, 0					;//if(!keyBody ) { return -1 }
		jreq		REG_get_value_RET_M1			;//
		add		%r10, 2					;//%r10    :=                                             keyBody += 2/*valueName*/
		ld.ub		%r11, [%r10]+				;//%r11    :=              valueDataHi                 = *keyBody++
		ld.ub		%r10, [%r10]				;//%r10    :=                              valueDataLo = *keyBody
		sla		%r11, 8					;//%r11    :=              valueDataHi<<8									*anti-interlock*
		or		%r10, %r11				;//%r10    := valueData = (valueDataHi<<8)|valueDataLo
REG_get_value_RET:							;//
	add	%sp,0x2		; 		xadd		%sp, %sp, 8				;//
		ret							;//return     valueData
REG_get_value_RET_M1:							;//
		jp.d		REG_get_value_RET			;//
		ld.w		%r10, -1				;//%r10    := valueData = -1											*delay*
		;//-----------------------------------------------------;//
REG_name_compar:
		;//%r12 := x
		;//%r13 := y
		ld.ub		%r10, [%r12]+				;//%r10 := xVal = *x++
		ld.ub		%r11, [%r13]+				;//%r11 := yVal = *y++
		cmp		%r10, %r11				;//if(xVal == yVal) {
		jrne		3					;//  
		 ld.ub		%r10, [%r12]				;//  %r10 := xVal = *x
		 ld.ub		%r11, [%r13]				;//  %r11 := yVal = *y }
		ret.d							;//return  xVal - yVal												*anti-interlock*
		sub		%r10, %r11				;//%r10 := xVal - yVal												*delay*

	
		.code
		.align		1
		.global		REG_open_key_l
		.global		REG_open_key_a
		.global		REG_open_key_v
		.global		REG_get_value_l
		.global		REG_get_value_a
		.global		REG_get_value_v
		.global		REG_get_string_l
		.global		REG_get_string_a
		.global		REG_get_string_v
REG_open_key_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_open_key_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_open_key_v:
		;//%r12 := keyBody
		;//%r13 := names
	   ;//{{2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
	   ;//	xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key
	   ;//	jp		REG_open_get_v				;//
	   ;//2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
		ld.w		%r9, [%r13]				;//%r9  := names[0]
	ext	REG_open_key+0x0@h	; 		xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key											*anti-interlock*
	ext	REG_open_key+0x0@m
	ld.w	%r14,REG_open_key+0x0@l
		cmp		%r9, -1					;//if(names[0] != -1) {
		jrne		REG_open_get_v				;//  goto REG_open_get_v }
		ret.d							;//return  keyBody
		ld.w		%r10, %r12				;//%r10 := keyBody												*delay*
	   ;//}}2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
		;//-----------------------------------------------------;//
REG_get_value_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_get_value_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_value_v:
		;//%r12 := keyBody
		;//%r13 := names
	ext	REG_get_value+0x0@h	; 		xld.w		%r14, REG_get_value			;//%r14 := fn = REG_get_value
	ext	REG_get_value+0x0@m
	ld.w	%r14,REG_get_value+0x0@l
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_string_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_get_string_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_string_v:
		;//%r12 := keyBody
		;//%r13 := names
	ext	REG_get_string+0x0@h	; 		xld.w		%r14, REG_get_string			;//%r14 := fn = REG_get_string
	ext	REG_get_string+0x0@m
	ld.w	%r14,REG_get_string+0x0@l
		;//-----------------------------------------------------;//
REG_open_get_v:
		;//%r12 := keyBody
		;//%r13 := names
		;//%r14 := fn
		pushn		%r1					;//
		ld.w		%r0, %r13				;//%r0  :=         names
		ld.w		%r1, %r14				;//%r1  :=         fn
		ld.w		%r13, [%r0]+				;//%r13 := name = *names++
		cmp		%r13, -1				;//if(name != -1)
		jreq		REG_open_get_v_NAMES_EMPTY		;//  
		jp		REG_open_get_v_START			;//  goto L_START
REG_open_get_v_LOOP:							;//  do {
	ext	REG_open_key@rm	; 		xcall		REG_open_key				;//    %r10 := keyBody = REG_open_key(keyBody, name)
	call	REG_open_key@rl
		ld.w		%r12, %r10				;//    %r12 := keyBody
		ld.w		%r13, [%r0]+				;//    %r13 := name = *names++
REG_open_get_v_START:							;//    
		ld.w		%r14, [%r0]				;//    %r14 := *names
		cmp		%r14, -1				;//    														!INTERLOCK!
		jrne		REG_open_get_v_LOOP			;//  } while(*names != -1)
REG_open_get_v_NAMES_EMPTY:						;//}
		ld.w		%r14, %r1				;//%r14 :=  fn
		popn		%r1					;//
		jp		%r14					;//return (*fn)(keyBody, name)

