/*	
 *	clipreg.c
 *
 *	WXge[u
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Mar 24 02:10:47 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Mar 24 21:45:37 JST 2015 Naoyuki Sawa
 *	- REG_open_key(),y,REG_get_value()ɁA(keyBody=NULL)w肵ĂSɂ܂B
 *	  REG_open_key_v()REG_get_value_v()̏̑啔ʉăR[h팸܂B
 *	* Thu Mar 26 21:28:16 JST 2015 Naoyuki Sawa
 *	- dRegTblC.exȅo̓f[^\ύXɔAW[啝ɕύX܂B
 *	  O܂ł̓L[zjAT[`Ă܂A̓oCiT[`ɂȂ܂B
 *	  ڍׂ́Auclip/tool/dRegTblC/winapp.hv̓̃RgQƂĂB
 *	* Sat Apr 11 13:20:40 JST 2015 Naoyuki Sawa
 *	 - ̃f[^^CvǉA啝ȕύXs܂B
 *	   ύXÕR[hQƂɂ́AÕA[JCuQƂĂB
 *	* Mon Jul 27 21:32:15 JST 2015 Naoyuki Sawa
 *	- REG_open_key_v()̏C܂BCéAȉ̒ʂł:
 *	  'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
 *	- ɁAclipfsm.c  FsmObj_GetTransKey() ɂāA'REG_open_key_l(keyBody,-1)'(keyBody)gԂ҂R[hĂ܂Ă܂B
 *	  ܂ł́A'REG_open_key_l(keyBody,-1)'NULLԂĂ̂ŁAFsmObj_GetTransKey() 삵Ă܂łB
 *	  A'REG_open_key_l(keyBody,-1)'(keyBody)gԂ悤ɏĈŁAFsmObj_GetTransKey() 삷悤ɂȂ܂B
 *	- L̏CAREG_open_get_v()REG_open_key()ł͂ȂAREG_open_key_v()ōsŔAe͈͂߂邽߂łB
 *	  REG_open_get_v()REG_open_key()́Å֐Ƃ̋ʐ̂߂ɁA(keyName=-1)I[ƌȂᏈs܂B
 *	  Ꮘ́AĂяoKw̐󂢕ōsSƍlāAREG_open_key_v()ōsɂ܂B
 */
#include "clip.h"
/****************************************************************************
 *	{IȊ֐
 ****************************************************************************/
#ifndef PIECE
static int REG_name_compar(const void* _x, const void* _y) {
	const unsigned char* x = _x;
	const unsigned char* y = _y;
	int retVal = *x++ - *y++;		//name(16rbg)̏8rbgrBI[o[t[̐Sẑ͖ŌZʂrʂƌȂėǂB
	if(!retVal) { retVal = *x - *y; }	//16rbgȂΉ8rbgrB
	return retVal;
}
//(keyBody=NULL)w肵ĂSłBʂ͏NULLɂȂ܂B
//keyNameɔ͈͊O̒l(0~0xFFFFȊO)w肵ĂSłBʂ͏NULLɂȂ܂B
const unsigned char* REG_open_key(const unsigned char* keyBody, int keyName) {
	unsigned char keyName2[2];
	int nKey, keyBodyDist;
	if(!keyBody  ) { return NULL; }		//(keyBody=NULL)w肳ꂽNULLԂB
	keyName2[1]    = keyName;		//
	keyName      >>= 8;			//16rbg,rbOGfBA
	keyName2[0]    = keyName;		//
	keyName      >>= 8;			//
	if(keyName   ) { return NULL; }		//ȉ̏keyNamȅ16bit𖳎̂ŁA16bitRvȂ悤͈͊O̒lOĂB
	//L[̔zB
	nKey           = *keyBody++;		//
	nKey         <<= 8;			//16rbg,rbOGfBA
	nKey          |= *keyBody++;		//
	keyBody = bsearch(
		keyName2,			//keyNamẻ16bit݂̂QƂB
		keyBody,
		nKey,
		(2/*keyName*/+3/*keyBodyDist*/),
		REG_name_compar);
	if(!keyBody) { return NULL; }		//L[ȂNULLԂB
	keyBody += 2/*keyName*/;
	keyBodyDist    = (char)*keyBody++;	//
	keyBodyDist  <<= 8;			//
	keyBodyDist   |=       *keyBody++;	//L24rbg,rbOGfBA
	keyBodyDist  <<= 8;			//
	keyBodyDist   |=       *keyBody++;	//
	keyBody += keyBodyDist;			//L[{fB̃AhX߂B
	return keyBody;				//L[{fB̃AhXԂB
}
//(keyBody=NULL)w肵ĂSłBʂ͏(-1)ɂȂ܂B
//valueNameɔ͈͊O̒l(0~0xFFFFȊO)w肵ĂSłBʂ͏(-1)ɂȂ܂B
int REG_get_value(const unsigned char* keyBody, int valueName) {
	unsigned char valueName2[2];
	int nKey, nValue, valueData;
	if(!keyBody  ) { return -1; }		//(keyBody=NULL)w肳ꂽ(-1)ԂB
	valueName2[1]  = valueName;		//
	valueName    >>= 8;			//16rbg,rbOGfBA
	valueName2[0]  = valueName;		//
	valueName    >>= 8;			//
	if(valueName ) { return -1; }		//ȉ̏valueNamȅ16bit𖳎̂ŁA16bitRvȂ悤͈͊O̒lOĂB
	//L[̔zXLbvB
	nKey           = *keyBody++;		//
	nKey         <<= 8;			//16rbg,rbOGfBA
	nKey          |= *keyBody++;		//
	keyBody       += nKey   * (2/*keyName*/+3/*keyBodyDist*/);
	//l̔zB
	nValue         = *keyBody++;		//
	nValue       <<= 8;			//16rbg,rbOGfBA
	nValue        |= *keyBody++;		//
	keyBody = bsearch(
		valueName2,			//valueNamẻ16bit݂̂QƂB
		keyBody,
		nValue,
		(2/*valueName*/+2/*valueData*/),
		REG_name_compar);
	if(!keyBody  ) { return -1; }		//lȂ(-1)ԂB
	keyBody += 2/*valueName*/;
	valueData      = *keyBody++;		//
	valueData    <<= 8;			//16rbg,rbOGfBA
	valueData     |= *keyBody;		//
	return valueData;			//l̃f[^ԂB
}
//(keyBody=NULL)w肵ĂSłBʂ͏NULLɂȂ܂B
//stringNameɔ͈͊O̒l(0~0xFFFFȊO)w肵ĂSłBʂ͏NULLɂȂ܂B
const char* REG_get_string(const unsigned char* keyBody, int stringName) {
	unsigned char stringName2[2];
	int nKey, nValue, nString, stringDist;
	if(!keyBody  ) { return NULL; }		//(keyBody=NULL)w肳ꂽNULLԂB
	stringName2[1] = stringName;		//
	stringName   >>= 8;			//16rbg,rbOGfBA
	stringName2[0] = stringName;		//
	stringName   >>= 8;			//
	if(stringName) { return NULL; }		//ȉ̏stringNamȅ16bit𖳎̂ŁA16bitRvȂ悤͈͊O̒lOĂB
	//L[̔zXLbvB
	nKey           = *keyBody++;		//
	nKey         <<= 8;			//16rbg,rbOGfBA
	nKey          |= *keyBody++;		//
	keyBody       += nKey   * (2/*keyName*/+3/*keyBodyDist*/);
	//l̔zXLbvB
	nValue         = *keyBody++;		//
	nValue       <<= 8;			//16rbg,rbOGfBA
	nValue        |= *keyBody++;		//
	keyBody       += nValue * (2/*valueName*/+2/*valueData*/);
	//̔zB
	nString        = *keyBody++;		//
	nString      <<= 8;			//16rbg,rbOGfBA
	nString       |= *keyBody++;		//
	keyBody = bsearch(
		stringName2,			//stringNamẻ16bit݂̂QƂB
		keyBody,
		nString,
		(2/*stringName*/+3/*stringDist*/),
		REG_name_compar);
	if(!keyBody  ) { return NULL; }		//񂪌ȂNULLԂB
	keyBody += 2/*stringName*/;
	stringDist     = (char)*keyBody++;	//
	stringDist   <<= 8;			//
	stringDist    |=       *keyBody++;	//L24rbg,rbOGfBA
	stringDist   <<= 8;			//
	stringDist    |=       *keyBody++;	//
	keyBody += stringDist;			//f[^̃AhX߂B
	return (const char*)keyBody;		//f[^̃AhXԂB
}
#else //PIECE
const unsigned char* REG_open_key(const unsigned char* keyBody, int keyName);
int REG_get_value(const unsigned char* keyBody, int valueName);
const char* REG_get_string(const unsigned char* keyBody, int stringName);
asm("
		.code
		.align		1
		.global		REG_open_key
		.global		REG_get_value
		.global		REG_get_string
REG_open_key:
		;//%r12 := keyBody
		;//%r13 := keyName
		jp.d		REG_open_get				;//
		ld.w		%r14, 0					;//%r14    := flag = 0												*delay*
REG_get_string:
		;//%r12 := keyBody
		;//%r13 := stringName
		ld.w		%r14, 1					;//%r14    := flag = 1
REG_open_get:
		xsub		%sp, %sp, 8				;//
		cmp		%r12, 0					;//if(!keyBody) { return NULL }
		jreq.d		REG_open_get_RET			;//
		ld.w		%r10, 0					;//%r10    :=            NULL											*delay*
		xld.b		[%sp+5], %r13				;//[%sp+5] := Name2[1] = Name
		sra		%r13, 8					;//%r13    :=            Name >>= 8
		xld.b		[%sp+4], %r13				;//[%sp+4] := Name2[0] = Name
		sra		%r13, 8					;//%r13    :=            Name >>= 8
		jrne		REG_open_get_RET			;//if(Name    ) { return NULL }
		cmp		%r14, 0					;//if(flag) {
		jreq.d		REG_open_get_L10			;//  
		ld.w		%r13, %r12				;//%r13    := keyBody												*delay*
		ld.ub		%r10, [%r12]+				;//  %r10    :=                      nKeyHi                = *keyBody++
		ld.ub		%r13, [%r12]+				;//  %r13    :=                                   nKeyLo   = *keyBody++
		sla		%r10, 8					;//  %r10    :=                      nKeyHi  <<8
		or		%r13, %r10				;//  %r13    :=            nKey   = (nKeyHi  <<8)|nKeyLo
		add		%r12, %r13				;//  %r12    := keyBody +  nKey   * 1
		sla		%r13, 2					;//  %r13    :=            nKey   * 4
		add		%r12, %r13				;//  %r12    := keyBody += nKey   * (2/*keyName*/+3/*keyBodyDist*/)
		ld.ub		%r10, [%r12]+				;//  %r10    :=                      nValueHi              = *keyBody++
		ld.ub		%r13, [%r12]+				;//  %r13    :=                                   nValueLo = *keyBody++
		sla		%r10, 8					;//  %r10    :=                      nValueHi<<8
		or		%r13, %r10				;//  %r13    :=            nValue = (nValueHi<<8)|nValueLo
		sla		%r13, 2					;//  %r13    :=            nValue * (2/*valueName*/+2/*valueData*/)
		add		%r13, %r12				;//  %r13    := keyBody += nValue * (2/*valueName*/+2/*valueData*/)
REG_open_get_L10:							;//}
		ld.w		%r12, %sp				;//%r12    := &[%sp+0]
		xld.w		%r10, REG_name_compar			;//%r10    := REG_name_compar
		ld.w		[%r12]+, %r10				;//[%sp+0] := REG_name_compar, %r12 := Name2
		ld.ub		%r10, [%r13]+				;//%r10    :=       nHi         = *keyBody++
		ld.ub		%r14, [%r13]+				;//%r14    :=               nLo = *keyBody++
		sla		%r10, 8					;//%r10    :=       nHi<<8
		or		%r14, %r10				;//%r14    := n  = (nHi<<8)|nLo
		xcall.d		bsearch					;//%r10    := keyBody = bsearch(Name2, keyBody, n, (2/*Name*/+3/*Dist*/), REG_name_compar)
		ld.w		%r15, 5					;//%r15    :=                                      (2/*Name*/+3/*Dist*/)					*delay*
		cmp		%r10, 0					;//if(!keyBody) { return NULL }
		jreq		REG_open_get_RET			;//
		add		%r10, 2					;//%r10    :=                                                             keyBody += 2/*Name*/
		ld.b		%r11, [%r10]+				;//%r11    :=                      DistHi                        = (char)*keyBody++
		ld.ub		%r12, [%r10]+				;//%r12    :=                                 DistMi             =       *keyBody++
		ld.ub		%r13, [%r10]+				;//%r13    :=                                             DistLo =       *keyBody++
		sla		%r11, 8					;//%r11    :=                      DistHi<<8
		or		%r11, %r12				;//%r11    :=                     (DistHi<<8)|DistMi
		sla		%r11, 8					;//%r11    :=                    ((DistHi<<8)|DistMi)<<8
		or		%r11, %r13				;//%r11    :=            Dist = (((DistHi<<8)|DistMi)<<8)|DistLo
		add		%r10, %r11				;//%r10    := keyBody += Dist
REG_open_get_RET:							;//
		xadd		%sp, %sp, 8				;//
		ret							;//return     keyBody
		;//-----------------------------------------------------;//
REG_get_value:
		;//%r12 := keyBody
		;//%r13 := valueName
		xsub		%sp, %sp, 8				;//
		cmp		%r12, 0					;//if(!keyBody ) { return -1 }
		jreq		REG_get_value_RET_M1			;//
		xld.b		[%sp+5], %r13				;//[%sp+5] := valueName2[1] = valueName
		sra		%r13, 8					;//%r13    :=                 valueName >>= 8
		xld.b		[%sp+4], %r13				;//[%sp+4] := valueName2[0] = valueName
		sra		%r13, 8					;//%r13    :=                 valueName >>= 8
		jrne		REG_get_value_RET_M1			;//if(valueName) { return -1 }
		ld.ub		%r10, [%r12]+				;//%r10    :=                    nKeyHi            = *keyBody++
		ld.ub		%r13, [%r12]+				;//%r13    :=                               nKeyLo = *keyBody++
		sla		%r10, 8					;//%r10    :=                    nKeyHi<<8
		or		%r13, %r10				;//%r13    :=            nKey = (nKeyHi<<8)|nKeyLo
		add		%r12, %r13				;//%r12    := keyBody +  nKey * 1
		sla		%r13, 2					;//%r13    :=            nKey * 4
		add		%r13, %r12				;//%r13    := keyBody += nKey * (2/*keyName*/+3/*keyBodyDist*/)
		ld.w		%r12, %sp				;//%r12    := &[%sp+0]
		xld.w		%r10, REG_name_compar			;//%r10    := REG_name_compar
		ld.w		[%r12]+, %r10				;//[%sp+0] := REG_name_compar, %r12 := valueName2
		ld.ub		%r10, [%r13]+				;//%r10    :=            nValueHi              = *keyBody++
		ld.ub		%r14, [%r13]+				;//%r14    :=                         nValueLo = *keyBody++
		sla		%r10, 8					;//%r10    :=            nValueHi<<8
		or		%r14, %r10				;//%r14    := nValue  = (nValueHi<<8)|nValueLo
		xcall.d		bsearch					;//%r10    := keyBody = bsearch(valueName2, keyBody, nValue, (2/*valueName*/+2/*valueData*/), REG_name_compar)
		ld.w		%r15, 4					;//%r15    :=                                                (2/*valueName*/+2/*valueData*/)			*delay*
		cmp		%r10, 0					;//if(!keyBody ) { return -1 }
		jreq		REG_get_value_RET_M1			;//
		add		%r10, 2					;//%r10    :=                                             keyBody += 2/*valueName*/
		ld.ub		%r11, [%r10]+				;//%r11    :=              valueDataHi                 = *keyBody++
		ld.ub		%r10, [%r10]				;//%r10    :=                              valueDataLo = *keyBody
		sla		%r11, 8					;//%r11    :=              valueDataHi<<8									*anti-interlock*
		or		%r10, %r11				;//%r10    := valueData = (valueDataHi<<8)|valueDataLo
REG_get_value_RET:							;//
		xadd		%sp, %sp, 8				;//
		ret							;//return     valueData
REG_get_value_RET_M1:							;//
		jp.d		REG_get_value_RET			;//
		ld.w		%r10, -1				;//%r10    := valueData = -1											*delay*
		;//-----------------------------------------------------;//
REG_name_compar:
		;//%r12 := x
		;//%r13 := y
		ld.ub		%r10, [%r12]+				;//%r10 := xVal = *x++
		ld.ub		%r11, [%r13]+				;//%r11 := yVal = *y++
		cmp		%r10, %r11				;//if(xVal == yVal) {
		jrne		3					;//  
		 ld.ub		%r10, [%r12]				;//  %r10 := xVal = *x
		 ld.ub		%r11, [%r13]				;//  %r11 := yVal = *y }
		ret.d							;//return  xVal - yVal												*anti-interlock*
		sub		%r10, %r11				;//%r10 := xVal - yVal												*delay*
");
#endif//PIECE
/****************************************************************************
 *	[eBeB֐
 ****************************************************************************/
#ifndef PIECE
static int REG_open_get_v(const unsigned char* keyBody, const int* names, int (*fn)(const unsigned char*, int)) {
	int name = *names++;
	if(name != -1) {
		goto L_START;
		do {
			keyBody = REG_open_key(keyBody, name);	//(keyBody=NULL)w肳ꂽAREG_open_key()NULLԂ(keyBody=NULL)ɂȂĂApĈSłB
			name = *names++;
L_START:		;
		} while(*names != -1);
	}
	return (*fn)(keyBody, name);	//(keyBody=NULL)(name=-1)̏ꍇłȀsĈSłB
}
/*--------------------------------------------------------------------------*/
const unsigned char* REG_open_key_l(const unsigned char* keyBody, ...) {
	va_list ap;
	va_start(ap, keyBody);
	keyBody = REG_open_key_a(keyBody, ap);
	va_end(ap);
	return keyBody;
}
const unsigned char* REG_open_key_a(const unsigned char* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_open_key_v(keyBody, names);
}
const unsigned char* REG_open_key_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
    //{{2015/07/27ǉ:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
	if(names[0] == -1) { return keyBody; }
    //}}2015/07/27ǉ:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
	return (const unsigned char*)REG_open_get_v(keyBody, names, (int (*)(const unsigned char*, int))REG_open_key);
}
/*--------------------------------------------------------------------------*/
int REG_get_value_l(const unsigned char* keyBody, ...) {
	int valueData;
	va_list ap;
	va_start(ap, keyBody);
	valueData = REG_get_value_a(keyBody, ap);
	va_end(ap);
	return valueData;
}
int REG_get_value_a(const unsigned char* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_value_v(keyBody, names);
}
int REG_get_value_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]valueName,]-1*/) {
	return REG_open_get_v(keyBody, names, REG_get_value);
}
/*--------------------------------------------------------------------------*/
const char* REG_get_string_l(const unsigned char* keyBody, ...) {
	const char* stringData;
	va_list ap;
	va_start(ap, keyBody);
	stringData = REG_get_string_a(keyBody, ap);
	va_end(ap);
	return stringData;
}
const char* REG_get_string_a(const unsigned char* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_string_v(keyBody, names);
}
const char* REG_get_string_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]stringName,]-1*/) {
	return (const char*)REG_open_get_v(keyBody, names, (int (*)(const unsigned char*, int))REG_get_string);
}
#else //PIECE
const unsigned char* REG_open_key_l(const unsigned char* keyBody, ...);
const unsigned char* REG_open_key_a(const unsigned char* keyBody, va_list ap);
const unsigned char* REG_open_key_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
/*--------------------------------------------------------------------------*/
int REG_get_value_l(const unsigned char* keyBody, ...);
int REG_get_value_a(const unsigned char* keyBody, va_list ap);
int REG_get_value_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]valueName,]-1*/);
/*--------------------------------------------------------------------------*/
const char* REG_get_string_l(const unsigned char* keyBody, ...);
const char* REG_get_string_a(const unsigned char* keyBody, va_list ap);
const char* REG_get_string_v(const unsigned char* keyBody, const int* names/*[[[[keyName,]keyName],c,]stringName,]-1*/);
asm("
		.code
		.align		1
		.global		REG_open_key_l
		.global		REG_open_key_a
		.global		REG_open_key_v
		.global		REG_get_value_l
		.global		REG_get_value_a
		.global		REG_get_value_v
		.global		REG_get_string_l
		.global		REG_get_string_a
		.global		REG_get_string_v
REG_open_key_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_open_key_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_open_key_v:
		;//%r12 := keyBody
		;//%r13 := names
	   ;//{{2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
	   ;//	xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key
	   ;//	jp		REG_open_get_v				;//
	   ;//2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
		ld.w		%r9, [%r13]				;//%r9  := names[0]
		xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key											*anti-interlock*
		cmp		%r9, -1					;//if(names[0] != -1) {
		jrne		REG_open_get_v				;//  goto REG_open_get_v }
		ret.d							;//return  keyBody
		ld.w		%r10, %r12				;//%r10 := keyBody												*delay*
	   ;//}}2015/07/27ύX:'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
		;//-----------------------------------------------------;//
REG_get_value_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_get_value_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_value_v:
		;//%r12 := keyBody
		;//%r13 := names
		xld.w		%r14, REG_get_value			;//%r14 := fn = REG_get_value
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_string_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_get_string_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_string_v:
		;//%r12 := keyBody
		;//%r13 := names
		xld.w		%r14, REG_get_string			;//%r14 := fn = REG_get_string
		;//-----------------------------------------------------;//
REG_open_get_v:
		;//%r12 := keyBody
		;//%r13 := names
		;//%r14 := fn
		pushn		%r1					;//
		ld.w		%r0, %r13				;//%r0  :=         names
		ld.w		%r1, %r14				;//%r1  :=         fn
		ld.w		%r13, [%r0]+				;//%r13 := name = *names++
		cmp		%r13, -1				;//if(name != -1)
		jreq		REG_open_get_v_NAMES_EMPTY		;//  
		jp		REG_open_get_v_START			;//  goto L_START
REG_open_get_v_LOOP:							;//  do {
		xcall		REG_open_key				;//    %r10 := keyBody = REG_open_key(keyBody, name)
		ld.w		%r12, %r10				;//    %r12 := keyBody
		ld.w		%r13, [%r0]+				;//    %r13 := name = *names++
REG_open_get_v_START:							;//    
		ld.w		%r14, [%r0]				;//    %r14 := *names
		cmp		%r14, -1				;//    														!INTERLOCK!
		jrne		REG_open_get_v_LOOP			;//  } while(*names != -1)
REG_open_get_v_NAMES_EMPTY:						;//}
		ld.w		%r14, %r1				;//%r14 :=  fn
		popn		%r1					;//
		jp		%r14					;//return (*fn)(keyBody, name)
");
#endif//PIECE
