/*
 *	clipquat.h
 *
 *	NH[^jICu`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Mon Sep 11 01:20:26 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu Sep 14 13:34:52 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __CLIP_QUAT_H__
#define __CLIP_QUAT_H__

/*****************************************************************************
 *	quaternion
 *****************************************************************************/

/* NH[^jI\̂̒`łB */
typedef struct _quaternion {
	fixed x;	/* (I) */
	fixed y;	/* (J) */
	fixed z;	/* (K) */
	fixed w;	/* (1) */
} quaternion;

extern const quaternion QUATERNION_0;	/* [NH[^jI(a̒Pʌ) */
extern const quaternion QUATERNION_1;	/* PʃNH[^jI(ς̒Pʌ) */

/* NH[^jȈ֐͗pӂĂ܂B
 * GCCg@\𗘗pāÂ悤ɏ܂B
 *	quaternion q;
 *	...
 *	q = (quaternion){x_value,y_value,z_value,w_value};
 *	...
 */

/* NH[^jI̘a߂܂B
 * [in,out]
 *	߂l = a + b
 */
quaternion qadd(quaternion a, quaternion b);

/* NH[^jI̘a̋t߂܂B()
 * [in,out]
 *	߂l = -a
 */
quaternion qneg(quaternion a);

/* NH[^jI̐ς߂܂B(NH[^jI)
 * [in,out]
 *	߂l = a * b
 * [note]
 *	* ]\NH[^jIƂ́A|킹ĂB
 *	- ʒu\NH[^jIpA]\NH[^jIq1ŉ]ǍA]\NH[^jIq2ŉ]ɂ́A
 *		quaternion p  = (quaternion){ x, y, z, 0 };
 *		quaternion q1 = qrot(Ax1, Ay1, Az1, d1);
 *		quaternion q2 = qrot(Ax2, Ay2, Az2, d2);
 *		p = vrotq(q1, p);
 *		p = vrotq(q2, p);
 *	  ]\NH[^jIq1q2炩ߍq߁AāAʒu\NH[^jIp]ɂ́A
 *		quaternion p  = (quaternion){ x, y, z, 0 };
 *		quaternion q1 = qrot(Ax1, Ay1, Az1, d1);
 *		quaternion q2 = qrot(Ax2, Ay2, Az2, d2);
 *		quaternion q  = qmul(q2, q1);  // qmul(q1, q2) ł͂ȂƂɒ!!
 *		p = vrotq(q, p);
 *	  ǂ̕@łA]̈ʒu\NH[^jIp͓ʂƂȂ܂B
 */
quaternion qmul(quaternion a, quaternion b);

/* NH[^jI̐ς̋t߂܂B(tNH[^jI)
 * [in,out]
 *	߂l = a^-1
 */
quaternion qinv(quaternion a);

/* NH[^jI̊e𓯂lŏZ܂B
 * [in,out]
 *	߂l = a * b
 */
quaternion qfmul(quaternion a, fixed b);
quaternion qimul(quaternion a, int   b);

/* NH[^jI̊e𓯂lŏZ܂B
 * [in,out]
 *	߂l = a / b
 */
quaternion qfdiv(quaternion a, fixed b);
quaternion qidiv(quaternion a, int   b);

/* NH[^jI߂܂B
 * [in,out]
 *	߂l = a*
 */
quaternion qconj(quaternion a);

/* NH[^jĨm߂܂B
 * [in,out]
 *	߂l = ||a||
 */
fixed qnorm(quaternion a);

/* NH[^jĨm2߂܂B
 * [in,out]
 *	߂l = ||a||^2
 */
fixed qnorm2(quaternion a);

/* NH[^jI𐳋K܂B
 * [in,out]
 *	߂l = a / ||a||
 */
quaternion qnormal(quaternion a);

/* NH[^jI̓ς߂܂B
 * [in,out]
 *	߂l = aEb
 * [note]
 * 	* NH[^jI̓ς̒`́Aȉ̒ʂłB
 *		aEb = ||a||||b||cos
 *	- u3D-CGvO}[̂߂̃NH[^jIv(Hw)ɂ́ANH[^jI̓ς̒`ڂĂȂ悤łA
 *	  uNH[^jIɂWϊ(http://www.purose.net/~y_kim/QuaternionTransform.pdf)vp.14 ɋLqĂ܂B
 *	* NH[^jIa,b]\NH[^jIłꍇA̓/2ɊÂč쐬Ă܂B(qrot()̎Q)
 *	  ]āANH[^jI̓ςԂcosƂAۂɂcos/2ƂȂ܂B
 *	  ]\NH[^jIa,b̐px߂ɂ́Aȉ̂悤ɌvZ܂B
 *		 = acos(aEb / ||a||||b||) * 2
 *	  a,b͉]\NH[^jIȂ̂ŁA||a||=||b||=1 Ɖ肷΁A
 *		 = acos(aEb) * 2
 *	- Ƃ낪Aʐ`ԂsƂ́A = acos(aEb) * 2 ƂĂ͂܂B
 *	  Ƃ/2ł܂܁ACɂɐi߂ƁA]̕ԌʂɂȂ܂B
 *	  qslerp()̎̃RgQƂĂB(2006/09/14݁A܂AłĂ܂)
 */
fixed qdot(quaternion a, quaternion b);

/* ]\NH[^jI쐬܂B
 * [in]
 *	x,y,z		]xNgB
 *	d		]pxB
 * [out]
 *	߂l		]\NH[^jIB
 * [note]
 *	* ]xNǵAKĂȂĂ\܂B
 */
quaternion qrot(fixed x, fixed y, fixed z, fixed d);

/* NH[^jI̋ʐ`Ԃs܂B
 * [in]
 *	a		t=0̂Ƃ̉]\NH[^jIB
 *	b		t=1̂Ƃ̉]\NH[^jIB
 * [out]
 *	߂l		ʐ`ԂꂽNH[^jIB
 * [note]
 *	* ]\NH[^jÍAKĂKv܂B
 *	- NH[^jIɑ΂ĉZJԂƁA덷~ς܂B
 *	  K؂ȃ^C~Oqnormal()ĂяoAKĂB
 *	  (Zʂɑ΂āAAKsKv͂܂B)
 */
quaternion qslerp(quaternion a, quaternion b, fixed t);

/* ]\NH[^jIŁAxNg]܂B
 * [in]
 *	v		]xNgB
 *	q		]\NH[^jIB
 * [out]
 *	߂l		]ꂽxNgB
 * [note]
 *	* ]\NH[^jÍAKĂKv܂B
 *	- NH[^jIɑ΂ĉZJԂƁA덷~ς܂B
 *	  K؂ȃ^C~Oqnormal()ĂяoAKĂB
 *	  (Zʂɑ΂āAAKsKv͂܂B)
 *	* ]\NH[^jÍAʒu\NH[^jI̍|̂łA
 *	  ȑZ}N̗֐lāAxNgANH[^jÏƂ܂B
 *	  ֐D悵đËȂ΁Avxform()̈lɂׂ̂łA
 *	  vxform()̈͂ύXłB(Ԉ肵ĎgĂAAZuĂ铙̗R)
 *	  ]āAvxform()̎dl͕ύXȂƂɂ܂B(2006/09/14 )
 */
vector vrotq(vector v, quaternion q);

/* ]\NH[^jIŁAsϊ܂B
 * [in]
 *	m		ϊsB
 *	q		]\NH[^jIB
 * [out]
 *	߂l		ϊꂽsB
 * [note]
 *	* ]\NH[^jÍAKĂKv܂B
 *	- NH[^jIɑ΂ĉZJԂƁA덷~ς܂B
 *	  K؂ȃ^C~Oqnormal()ĂяoAKĂB
 *	  (Zʂɑ΂āAAKsKv͂܂B)
 *	* ]\NH[^jÍA]̍s̍|̂łA
 *	  ȑZ}N̗֐lāAsANH[^jÏƂ܂B
 */
matrix mrotq(matrix m, quaternion q);

/*****************************************************************************
 *	ȑZ
 *****************************************************************************/

/* quaternion */
#define    qadd_(a, b)	do { (a) =    qadd((a), (b)); } while(0)
#define    qneg_(a   )	do { (a) =    qneg((a)     ); } while(0)
#define    qmul_(a, b)	do { (a) =    qmul((a), (b)); } while(0)
#define    qinv_(a   )	do { (a) =    qinv((a)     ); } while(0)
#define   qfmul_(a, b)	do { (a) =   qfmul((a), (b)); } while(0)
#define   qimul_(a, b)	do { (a) =   qimul((a), (b)); } while(0)
#define   qfdiv_(a, b)	do { (a) =   qfdiv((a), (b)); } while(0)
#define   qidiv_(a, b)	do { (a) =   qidiv((a), (b)); } while(0)
#define   qconj_(a   )	do { (a) =   qconj((a)     ); } while(0)
#define qnormal_(a   )	do { (a) = qnormal((a)     ); } while(0)

/* vector */
#define vrotq_(v, q)	do { (v) = vrotq((v), (q)); } while(0)

/* matrix */
#define mrotq_(m, q)	do { (m) = mrotq((m), (q)); } while(0)

#endif /*__CLIP_QUAT_H__*/
