/*
 *	clipquaf.c
 *
 *	_ŃNH[^jICu`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2009 Naoyuki Sawa
 *
 *	* Sat May 02 20:49:01 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	- clipquat.cW[ɁAPɕs_č쐬܂B
 *	  éAclipquat.hclipquat.c̃RgQƂĂB
 *	  ꕔAό`ĂӏȂǂ܂AASY͓łB
 *	- 2009/05/02݁A܂A쌟؂s[łB
 *	* Sun May 03 14:10:47 JST 2009 Naoyuki Sawa
 *	- mat3f_rotq()AZuAAȃ܂B
 *	* Sun May 03 21:34:27 JST 2009 Naoyuki Sawa
 *	- quatf_mul()AZuAAȃ܂B
 *	* Mon May 04 15:25:01 JST 2009 Naoyuki Sawa
 *	- quatf_add()Aquatf_neg()Aquatf_conj()AZuAȃ܂B
 *	  quatf_add()͍Aquatf_neg()quatf_conj()͂킸ɒᑬɂȂ܂B
 *	- quatf_mulf()Aquatf_divf()AZuAAȃ܂B
 *	- quatf_norm()̃oOC܂B
 *	  quatf_norm2()ĂԂׂƂAԈႦquatf_norm()gĂł܂B
 *	* Mon May 04 19:56:30 JST 2009 Naoyuki Sawa
 *	- quatf_inv()Aquatf_normal()Aquatf_norm()Aquatf_norm2()Aquatf_dot()AZuAAȃ܂B
 */
#include "clip.h"

#ifndef PIECE
#define NOASM	// ̃V|`ƁACłgp܂B */
#endif /*PIECE*/

/*****************************************************************************
 *	quaternion
 *****************************************************************************/

const quatf quatf_0 = { 0.0f, 0.0f, 0.0f, 0.0f };
const quatf quatf_1 = { 0.0f, 0.0f, 0.0f, 1.0f };

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void quatf_inv(quatf* q/*[in,out]*/) {
	quatf_conj(q);
	quatf_divf(q, quatf_norm2(q));
}
void quatf_normal(quatf* q/*[in,out]*/) {
	quatf_divf(q, quatf_norm(q));
}
float/*[out]*/ quatf_norm(const quatf* q/*[in]*/) {
	return sqrtf(quatf_norm2(q));
}
float/*[out]*/ quatf_norm2(const quatf* q/*[in]*/) {
	return quatf_dot(q, q);
}
float/*[out]*/ quatf_dot(const quatf* q1/*[in]*/, const quatf* q2/*[in]*/) {
	return (q1->x * q2->x) + (q1->y * q2->y) + (q1->z * q2->z) + (q1->w * q2->w);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		quatf_inv
		.global		quatf_normal
		.global		quatf_norm
		.global		quatf_norm2
		.global		quatf_dot
quatf_inv:	;//-------------------------------------;
		pushn		%r0
		xcall.d		quatf_conj		;// %r10 := quatf_conj(q)
		ld.w		%r0, %r12		;// %r0  :=            q
		call.d		quatf_norm2		;// %r10 :=               quatf_norm2(q)
		ld.w		%r12, %r0		;// %r12 :=                           q		*delay*
		ld.w		%r12, %r0		;// %r12 :=            q
		popn		%r0
		xjp.d		quatf_divf		;// %r10 := quatf_divf(q, quatf_norm2(q))
		ld.w		%r13, %r10		;// %r13 :=               quatf_norm2(q)	*delay*
quatf_normal:	;//-------------------------------------;
		pushn		%r0
		call.d		quatf_norm		;// %r10 :=               quatf_norm(q)
		ld.w		%r0, %r12		;// %r0  :=            q			*delay*
		ld.w		%r12, %r0		;// %r12 :=            q
		popn		%r0
		xjp.d		quatf_divf		;// %r10 := quatf_divf(q, quatf_norm(q))
		ld.w		%r13, %r10		;// %r13 :=               quatf_norm(q)		*delay*
quatf_norm:	;//-------------------------------------;
		call		quatf_norm2		;// %r10 :=       quatf_norm2(q)
		xjp.d		sqrtf			;// %r10 := sqrtf(quatf_norm2(q))
		ld.w		%r12, %r10		;// %r12 :=       quatf_norm2(q)		*delay*
quatf_norm2:	;//-------------------------------------;
		ld.w		%r13, %r12		;// %r13 := q1 = q2 = q
quatf_dot:	;//-------------------------------------;
		ld.w		%r4, %r12		;// %r4  := q1
		ld.w		%r5, %r13		;// %r5  := q2
		xld.w		%r6, __mulsf3		;// %r6  := __mulsf3
		;//
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->x
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->x
		call		%r6			;// %r10 := dot  = q1->x * q2->x
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->y		|
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->y	|
		call.d		%r6			;// %r10 :=        q1->y * q2->y	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
		xcall.d		__addsf3		;// %r10 := dot += q1->y * q2->y
		ld.w		%r13, %r10		;// %r13 :=        q1->y * q2->y		*delay*
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]+		;// %r12 :=        q1->z		|
		ld.w		%r13, [%r5]+		;// %r13 :=                q2->z	|
		call.d		%r6			;// %r10 :=        q1->z * q2->z	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
		xcall.d		__addsf3		;// %r10 := dot += q1->z * q2->z
		ld.w		%r13, %r10		;// %r13 :=        q1->z * q2->z		*delay*
;//		ld.w		%r7, %r10		;// %r7  := dot ------------------------+
		;//					;//					|
		ld.w		%r12, [%r4]		;// %r12 :=        q1->w		|
		ld.w		%r13, [%r5]		;// %r13 :=                q2->w	|
		call.d		%r6			;// %r10 :=        q1->w * q2->w	|
		ld.w		%r7, %r10		;// <-----------------------------------+	*delay*
		ld.w		%r12, %r7		;// %r12 := dot
		xjp.d		__addsf3		;// %r10 := dot += q1->w * q2->w
		ld.w		%r13, %r10		;// %r13 :=        q1->w * q2->w		*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void quatf_add(quatf* q1/*[in,out]*/, const quatf* q2/*[in]*/) {
	q1->x += q2->x;
	q1->y += q2->y;
	q1->z += q2->z;
	q1->w += q2->w;
}
void quatf_neg(quatf* q/*[in,out]*/) {
	q->x = -q->x;
	q->y = -q->y;
	q->z = -q->z;
	q->w = -q->w;
}
void quatf_conj(quatf* q/*[in,out]*/) {
	q->x = -q->x;
	q->y = -q->y;
	q->z = -q->z;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		quatf_add
		.global		quatf_neg
		.global		quatf_conj
quatf_add:	;//-------------------------------------;
		xld.w		%r4, __addsf3		;// %r4  := op = __addsf3
		jp.d		quatf_add_neg_conj
quatf_neg:	;//-------------------------------------;
		ld.w		%r5, 4			;// %r5  := cnt = 4			*delay*
		jp.d		quatf_neg_conj
quatf_conj:	;//-------------------------------------;
		ld.w		%r13, %r12		;// %r13 := q2 = q1 (_~[ǂݍ݌)	*delay*
		ld.w		%r5, 3			;// %r5  := cnt = 3
quatf_neg_conj:	;//-------------------------------------;
		xld.w		%r4, __negsf2		;// %r4  := op = __negsf2
quatf_add_neg_conj:;//----------------------------------;
		ld.w		%r6, %r12		;// %r6  := q1
		ld.w		%r7, %r13		;// %r7  := q2
quatf_add_neg_conj_LOOP:				;// do {
		ld.w		%r12, [%r6]		;//   %r12 := q1->i
		ld.w		%r13, [%r7]+		;//   %r13 :=          q2->i
		call		%r4			;//   %r10 := q1->i op q2->i
		ld.w		[%r6]+, %r10		;//   q1->i = q1->i op q2->i
		sub		%r5, 1			;//   %r5  := cnt--
		jrne		quatf_add_neg_conj_LOOP	;// } while(cnt)
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void quatf_mulf(quatf* q/*[in,out]*/, float f/*[in]*/) {
	q->x *= f;
	q->y *= f;
	q->z *= f;
	q->w *= f;
}
void quatf_divf(quatf* q/*[in,out]*/, float f/*[in]*/) {
	q->x /= f;
	q->y /= f;
	q->z /= f;
	q->w /= f;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		quatf_mulf
		.global		quatf_divf
quatf_mulf:	;//-------------------------------------;
		xld.w		%r4, __mulsf3		;// %r4  := op = __mulsf3
		jp.d		quatf_mulf_divf
quatf_divf:	;//-------------------------------------;
		ld.w		%r5, 4			;// %r5  := cnt = 4		*delay*
		xld.w		%r4, __divsf3		;// %r4  := op = __divsf3
quatf_mulf_divf:;//-------------------------------------;
		ld.w		%r6, %r12		;// %r6  := q
		ld.w		%r7, %r13		;// %r7  := f
quatf_mulf_divf_LOOP:					;// do {
		ld.w		%r12, [%r6]		;//   %r12 := q->i
		call.d		%r4			;//   %r10 := q->i op f
		ld.w		%r13, %r7		;//   %r13 :=         f		*delay*
		ld.w		[%r6]+, %r10		;//   q->i := q->i op f
		sub		%r5, 1			;//   %r5  := cnt--
		jrne		quatf_mulf_divf_LOOP	;// } while(cnt)
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

void quatf_slerp(quatf* out/*[out]*/, const quatf* q1/*[in]*/, const quatf* q2/*[in]*/, float t/*[in]*/) {
	float d   = acosf(quatf_dot(q1, q2));
	float s   =  sinf(d);
	quatf tmp = *q2;
	     *out = *q1;
	if(s) {
		quatf_mulf(&tmp, sinf(d *      t ));
		quatf_mulf( out, sinf(d * (1 - t)));
		quatf_add ( out, &tmp);
		quatf_divf( out, s   );
	}
}

/*--------------------------------------------------------------------------*/

void vec3f_rotq(const quatf* q/*[in]*/, vec3f* v/*[in,out]*/) {
	quatf q1 = *q;
	quatf qv = { v->x, v->y, v->z, 0.0f };
	quatf q2 = *q;
	quatf_conj(&q2);
	quatf_mul (&q1, &qv);
	quatf_mul (&q1, &q2);
	v->x = q1.x;
	v->y = q1.y;
	v->z = q1.z;
}

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void quatf_mul(quatf* q1/*[in,out]*/, const quatf* q2/*[in]*/) {
	quatf tmp = *q1;
	q1->x = (tmp.x * q2->w) + (tmp.w * q2->x) + (tmp.y * q2->z) - (tmp.z * q2->y);
	q1->y = (tmp.y * q2->w) + (tmp.w * q2->y) + (tmp.z * q2->x) - (tmp.x * q2->z);
	q1->z = (tmp.z * q2->w) + (tmp.w * q2->z) + (tmp.x * q2->y) - (tmp.y * q2->x);
	q1->w = (tmp.w * q2->w) - (tmp.x * q2->x) - (tmp.y * q2->y) - (tmp.z * q2->z);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		quatf_mul
quatf_mul:
		pushn		%r3
		ld.w		%r0, %r12		;// %r0  := q1
		ld.w		%r1, %r13		;// %r1  := q2
		xld.w		%r2, __mulsf3		;// %r2  := __mulsf3
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                    x2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               x1
		call.d		%r2			;// %r10 :=         xx := x1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r7, %r10		;// %r7  := w  := + xx
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               y1
		call.d		%r2			;// %r10 :=         yx := y1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r6, %r10		;// %r6  := z  := + yx
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=               z1
		call.d		%r2			;// %r10 :=         zx := z1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r5, %r10		;// %r5  := y  := + zx
		;//
		ld.w		%r12, [%r0]		;// %r12 :=               w1
		call.d		%r2			;// %r10 :=         wx := w1 * x2
		ld.w		%r13, %r3		;// %r13 :=                    x2			*delay*
		ld.w		%r4, %r10		;// %r4  := x  := + wx
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                         y2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    x1
		call.d		%r2			;// %r10 :=              xy := x1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r12, %r10		;// %r12 :=              xy
		xcall.d		__subsf3		;// %r10 := z  := - yx + xy
		ld.w		%r13, %r6		;// %r13 :=       + yx					*delay*
		ld.w		%r6, %r10		;// %r6  := z
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    y1
		call.d		%r2			;// %r10 :=              yy := y1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              yy
		xcall.d		__addsf3		;// %r10 := w  := + xx + yy
		ld.w		%r12, %r7		;// %r12 :=       + xx					*delay*
		ld.w		%r7, %r10		;// %r7  := w
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                    z1
		call.d		%r2			;// %r10 :=              zy := z1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              zy
		xcall.d		__subsf3		;// %r10 := x  := + wx - zy
		ld.w		%r12, %r4		;// %r12 :=       + wx					*delay*
		ld.w		%r4, %r10		;// %r4  := x
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                    w1
		call.d		%r2			;// %r10 :=              wy := w1 * y2
		ld.w		%r13, %r3		;// %r13 :=                         y2			*delay*
		ld.w		%r13, %r10		;// %r13 :=              wy
		xcall.d		__addsf3		;// %r10 := y  := + zx + wy
		ld.w		%r12, %r5		;// %r12 :=       + zx					*delay*
		ld.w		%r5, %r10		;// %r5  := y
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]+		;// %r3  :=                              z2
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         x1
		call.d		%r2			;// %r10 :=                   xz := x1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   xz
		xcall.d		__subsf3		;// %r10 := y  := + zx + wy - xz
		ld.w		%r12, %r5		;// %r12 :=       + zx + wy				*delay*
		ld.w		%r5, %r10		;// %r5  := y
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         y1
		call.d		%r2			;// %r10 :=                   yz := y1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   yz
		xcall.d		__addsf3		;// %r10 := x  := + wx - zy + yz
		ld.w		%r12, %r4		;// %r12 :=       + wx - zy				*delay*
		ld.w		%r4, %r10		;// %r4  := x
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=                         z1
		call.d		%r2			;// %r10 :=                   zz := z1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   zz
		xcall.d		__addsf3		;// %r10 := w  := + xx + yy + zz
		ld.w		%r12, %r7		;// %r12 :=       + xx + yy				*delay*
		ld.w		%r7, %r10		;// %r7  := w
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                         w1
		call.d		%r2			;// %r10 :=                   wz := w1 * z2
		ld.w		%r13, %r3		;// %r13 :=                              z2		*delay*
		ld.w		%r13, %r10		;// %r13 :=                   wz
		xcall.d		__addsf3		;// %r10 := z  := - yx + xy + wz
		ld.w		%r12, %r6		;// %r12 :=       - yx + xy				*delay*
		ld.w		%r6, %r10		;// %r6  := z
		;//
		sub		%r0, 12			;// %r0  := q1
		;//-------------------------------------;
		ld.w		%r3, [%r1]		;// %r3  :=                                   w2
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              x1
		call.d		%r2			;// %r10 :=                        xw := x1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        xw
		xcall.d		__addsf3		;// %r10 := x  := + wx - zy + yz + xw
		ld.w		%r12, %r4		;// %r12 :=       + wx - zy + yz			*delay*
		ld.w		[%r0]+, %r10		;// q1->x = x
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              y1
		call.d		%r2			;// %r10 :=                        yw := y1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        yw
		xcall.d		__addsf3		;// %r10 := y  := + zx + wy - xz + yw
		ld.w		%r12, %r5		;// %r12 :=       + zx + wy - xz			*delay*
		ld.w		[%r0]+, %r10		;// q1->y = y
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              z1
		call.d		%r2			;// %r10 :=                        zw := z1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r13, %r10		;// %r13 :=                        zw
		xcall.d		__addsf3		;// %r10 := z  := - yx + xy + wz + zw
		ld.w		%r12, %r6		;// %r12 :=       - yx + xy + wz			*delay*
		ld.w		[%r0]+, %r10		;// q1->z = z
		;//
		ld.w		%r12, [%r0]		;// %r12 :=                              w1
		call.d		%r2			;// %r10 :=                        ww := w1 * w2
		ld.w		%r13, %r3		;// %r13 :=                                   w2	*delay*
		ld.w		%r12, %r10		;// %r12 :=                        ww
		xcall.d		__subsf3		;// %r10 := w  := - xx - yy - zz + ww
		ld.w		%r13, %r7		;// %r13 :=       + xx + yy + zz			*delay*
		ld.w		[%r0], %r10		;// q1->w = w
		;//-------------------------------------;
		popn		%r3
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void mat3f_rotq(mat3f* m/*[in,out]*/, const quatf* q/*[in]*/) {
	mat3f tmp = {
		1.0f - 2.0f * (q->y * q->y + q->z * q->z),        2.0f * (q->x * q->y - q->z * q->w),        2.0f * (q->z * q->x + q->y * q->w), 0.0f,
		       2.0f * (q->x * q->y + q->z * q->w), 1.0f - 2.0f * (q->z * q->z + q->x * q->x),        2.0f * (q->y * q->z - q->x * q->w), 0.0f,
		       2.0f * (q->z * q->x - q->y * q->w),        2.0f * (q->y * q->z + q->x * q->w), 1.0f - 2.0f * (q->x * q->x + q->y * q->y), 0.0f,
	};
	mat3f_xform(m, &tmp);
}
#else /*NOASM*/
/* * Sun May 03 14:10:47 JST 2009 Naoyuki Sawa
 * - EPSONRpĆAu2.0f*(...)v̉ZAu(...)+(...)vɕϊ悤łB
 *   A_̉ŹAZx̂ŁAĒxȂĂ܂܂B
 * - ŁAAZułł́Awɒ1𑫂āA2{悤ɍ܂B
 *   A(...)0.0̏ꍇ́Aw1𑫂ƑSʂ̒lɂȂĂ܂̂ŁA肷Kv܂B
 * - {A0.0̔́A+0.0(0x00000000)-0.0(0x80000000)𔻒肷Kv܂B
 *   Aframflt1.sŎ__subsf3́Aʂ0.0̏ꍇ͕K+0.0ԂA-0.0Ԃ܂B
 *   ]āA-0.0𔻒肷Kv͖A+0.0𔻒肷ucmp %r10,0vŏ[łB
 */
asm("
		.code
		.align		1
		.global		mat3f_rotq
mat3f_rotq:
		pushn		%r3
		xsub		%sp, %sp, 48
		ld.w		%r0, %r12		;// %r0  := m
		ld.w		%r1, [%r13]+		;// %r1  := x = q->x
		ld.w		%r2, [%r13]+		;// %r2  := y = q->y
		ld.w		%r3, [%r13]+		;// %r3  := z = q->z
		ld.w		%r4, [%r13]		;// %r4  := w = q->w
		xld.w		%r5, 0x00800000		;// %r5  := exp = 1
		;// %r0  := m
		;// %r1  := x
		;// %r2  := y
		;// %r3  := z
		;// %r4  := w
		;// %r5  := exp
		;// %sp  := tmp
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 :=      x
		xcall.d		__mulsf3		;// %r10 := xy = x * y
		ld.w		%r13, %r2		;// %r13 :=          y				*delay*
		ld.w		%r6, %r10		;// %r6  := xy
		;//
		ld.w		%r12, %r3		;// %r12 :=      z
		xcall.d		__mulsf3		;// %r10 := zw = z * w
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := zw
		;//
		ld.w		%r12, %r6		;// %r6  := xy
		xcall.d		__subsf3		;// %r10 := xy - zw
		ld.w		%r13, %r7		;// %r7  :=      zw				*delay*
		cmp		%r10, 0			;// if(xy - zw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xy - zw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+4], %r10		;// [%sp+4]  := tmp->a01 = (xy - zw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := xy
		xcall.d		__addsf3		;// %r10 := xy + zw
		ld.w		%r13, %r7		;// %r7  :=      zw				*delay*
		cmp		%r10, 0			;// if(xy + zw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xy + zw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+16], %r10		;// [%sp+16] := tmp->a10 = (xy + zw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r2		;// %r12 :=      y
		xcall.d		__mulsf3		;// %r10 := yz = y * z
		ld.w		%r13, %r3		;// %r13 :=          z				*delay*
		ld.w		%r6, %r10		;// %r6  := yz
		;//
		ld.w		%r12, %r1		;// %r12 :=      x
		xcall.d		__mulsf3		;// %r10 := xw = x * w
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := xw
		;//
		ld.w		%r12, %r6		;// %r6  := yz
		xcall.d		__subsf3		;// %r10 := yz - xw
		ld.w		%r13, %r7		;// %r7  :=      xw				*delay*
		cmp		%r10, 0			;// if(yz - xw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yz - xw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+24], %r10		;// [%sp+24] := tmp->a12 = (yz - xw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := yz
		xcall.d		__addsf3		;// %r10 := yz + xw
		ld.w		%r13, %r7		;// %r7  :=      xw				*delay*
		cmp		%r10, 0			;// if(yz + xw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yz + xw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+36], %r10		;// [%sp+36] := tmp->a21 = (yz + xw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r3		;// %r12 :=      z
		xcall.d		__mulsf3		;// %r10 := zx = z * x
		ld.w		%r13, %r1		;// %r13 :=          x				*delay*
		ld.w		%r6, %r10		;// %r6  := zx
		;//
		ld.w		%r12, %r2		;// %r12 :=      y
		xcall.d		__mulsf3		;// %r10 := yw = y * w
		ld.w		%r13, %r4		;// %r13 :=          w				*delay*
		ld.w		%r7, %r10		;// %r7  := yw
		;//
		ld.w		%r12, %r6		;// %r6  := zx
		xcall.d		__subsf3		;// %r10 := zx - yw
		ld.w		%r13, %r7		;// %r7  :=      yw				*delay*
		cmp		%r10, 0			;// if(zx - yw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zx - yw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+32], %r10		;// [%sp+32] := tmp->a20 = (zx - yw) * 2
		;//
		ld.w		%r12, %r6		;// %r6  := zx
		xcall.d		__addsf3		;// %r10 := zx + yw
		ld.w		%r13, %r7		;// %r7  :=      yw				*delay*
		cmp		%r10, 0			;// if(zx + yw)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zx + yw) * 2			*delay*
		 sub		%r10, %r5
		xld.w		[%sp+8], %r10		;// [%sp+8]  := tmp->a02 = (zx + yw) * 2
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 :=      x
		xcall.d		__mulsf3		;// %r10 := xx = x * x
		ld.w		%r13, %r1		;// %r13 :=          x				*delay*
		ld.w		%r1, %r10		;// %r1  := xx
		;//
		ld.w		%r12, %r2		;// %r12 :=      y
		xcall.d		__mulsf3		;// %r10 := yy = y * y
		ld.w		%r13, %r2		;// %r13 :=          y				*delay*
		ld.w		%r2, %r10		;// %r1  := yy
		;//
		ld.w		%r12, %r3		;// %r12 :=      z
		xcall.d		__mulsf3		;// %r10 := zz = z * z
		ld.w		%r13, %r3		;// %r13 :=          z				*delay*
		ld.w		%r3, %r10		;// %r1  := zz
		;//
		xld.w		%r4, 0x3f800000		;// %r4  := 1.0
		;// %r0  := m
		;// %r1  := xx
		;// %r2  := yy
		;// %r3  := zz
		;// %r4  := 1.0
		;// %r5  := exp
		;// %sp  := tmp
		;//-------------------------------------;
		ld.w		%r12, %r2		;// %r12 := yy
		xcall.d		__addsf3		;// %r10 := yy + zz
		ld.w		%r13, %r3		;// %r13 :=      zz				*delay*
		cmp		%r10, 0			;// if(yy + zz)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (yy + zz) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
		xcall.d		__subsf3		;// %r10 := 1.0 - (yy + zz) * 2
		ld.w		%r13, %r10		;// %r13 :=       (yy + zz) * 2			*delay*
		xld.w		[%sp+0], %r10		;// [%sp+0]  := tmp->a00 = 1.0 - (yy + zz) * 2
		;//-------------------------------------;
		ld.w		%r12, %r3		;// %r12 := zz
		xcall.d		__addsf3		;// %r10 := zz + xx
		ld.w		%r13, %r1		;// %r13 :=      xx				*delay*
		cmp		%r10, 0			;// if(zz + xx)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (zz + xx) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
		xcall.d		__subsf3		;// %r10 := 1.0 - (zz + xx) * 2
		ld.w		%r13, %r10		;// %r13 :=       (zz + xx) * 2			*delay*
		xld.w		[%sp+20], %r10		;// [%sp+20] := tmp->a11 = 1.0 - (zz + xx) * 2
		;//-------------------------------------;
		ld.w		%r12, %r1		;// %r12 := xx
		xcall.d		__addsf3		;// %r10 := xx + yy
		ld.w		%r13, %r2		;// %r13 :=      yy				*delay*
		cmp		%r10, 0			;// if(xx + yy)
		jrne.d		3
		 add		%r10, %r5		;//   %r10 := (xx + yy) * 2			*delay*
		 sub		%r10, %r5
		ld.w		%r12, %r4		;// %r12 := 1.0
		xcall.d		__subsf3		;// %r10 := 1.0 - (xx + yy) * 2
		ld.w		%r13, %r10		;// %r13 :=       (xx + yy) * 2			*delay*
		xld.w		[%sp+40], %r10		;// [%sp+40] := tmp->a22 = 1.0 - (xx + yy) * 2
		;//-------------------------------------;
		xld.w		[%sp+12], %r8		;// [%sp+12] := tmp->a03 = 0.0
		xld.w		[%sp+28], %r8		;// [%sp+28] := tmp->a13 = 0.0
		xld.w		[%sp+44], %r8		;// [%sp+44] := tmp->a23 = 0.0
		ld.w		%r13, %sp		;// %r13 :=        tmp
		xcall.d		mat3f_xform		;// mat3f_xform(m, tmp)
		ld.w		%r12, %r0		;// %r12 :=     m				*delay*
		xadd		%sp, %sp, 48
		popn		%r3
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

void quatf_rot(quatf* out/*[out]*/, const vec3f* axis/*[in]*/, float ang/*[in]*/) {
	float s = sinf(ang / 2.0f) / vec3f_mag(axis);
	float c = cosf(ang / 2.0f);
	out->x  = axis->x * s;
	out->y  = axis->y * s;
	out->z  = axis->z * s;
	out->w  =           c;
}

