/*	
 *	clipptp.c
 *
 *	USB PTP Responder (Picture Transfer Protocol), USB MTP Responder (Media Transfer Protocol)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Fri Sep 05 21:36:08 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Sep 06 23:41:20 JST 2014 Naoyuki Sawa
 *	- Xg[ŃG[ʒḿAł悤ɂȂ܂B
 *	  ڍׂ́AuG[̕@ɂāv́u2014/09/06ǋLvQƂĂB
 *	* Sun Sep 14 02:44:46 JST 2014 Naoyuki Sawa
 *	- fnCXf[^Zbg(DeviceInfo Dataset)ImageFormatsɁAUndefinedǉ܂B
 *	  ̕ύXɂAWindows7P/ECE֏ނƂAx\Ă肪܂B
 *	- IuWFNgf[^ZbgObjectFormatAVendorDefinedUndefinedɕύX܂B
 *	  Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂̂悤łB
 *	  IuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
 *	- PTP_Start()ɈbMTPǉAMTPfoCXƂēł悤ɂ܂B
 *	 ܂AWindowsMTPfoCXƂĔF悤ɂŁAMTPL͉̓Ă܂B
 *	- MTP Extension format codesǉ܂B
 *	  fnCXf[^Zbg(DeviceInfo Dataset)ImageFormatsɁAMTP Extension format codesǉ܂B
 *	  ̕ύXɂA*.xls*.docނƂɂAx\ȂȂ܂B(܂*.exe͌xo܂B)
 *	  MTP Extension format codeśAMTPłȂPTPƂē삵Ă鎞LłB
 *	* Mon Sep 15 02:07:06 JST 2014 Naoyuki Sawa
 *	- MTP Extension operation codes,MTP Extension response codes,MTP Extension event codes,MTP Extension device properties,MTP Extension protection statusesǉ܂B
 *	- ObjectPropertyǉ܂B
 *	* Mon Sep 15 19:28:40 JST 2014 Naoyuki Sawa
 *	- Get/Set,FormFlag,MTP Extension form flagsǉ܂B
 *	* Mon Sep 15 21:24:52 JST 2014 Naoyuki Sawa
 *	- MTP̃Iy[V(GetObjectPropsSupported,GetObjectPropDesc,GetObjectPropValue)܂B
 *	  V{USE_MTP_OPERATION`ƁA샂[h(PTP/MTP)Ɋ֌WÃIy[VLɂȂ܂B
 *	  V{USE_MTP_OPERATION`Ȃ΁A샂[h(PTP/MTP)Ɋ֌WÃIy[VɂȂ܂B
 *	  '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́APTPƂĔFfoCXłĂAMTP̃Iy[VΉĂ΁AMTP̃Iy[Vgpē삷悤łB
 *	  '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́AMTPƂĔFfoCXłĂAMTP̃Iy[VΉĂȂ΁APTP̃Iy[V݂̂œ삷悤łB
 *	* Sat Sep 20 08:44:17 JST 2014 Naoyuki Sawa
 *	- FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
 *	  ڍׂ́Aclippce.ćut@C݌n֐̔rṽRgƁuFRAM4̈̑ޔ𕜌vQƂĂB
 */
#include "clip.h"

/* * Mon Sep 15 21:24:52 JST 2014 Naoyuki Sawa
 * - MTP̃Iy[V(GetObjectPropsSupported,GetObjectPropDesc,GetObjectPropValue)܂B
 *   V{USE_MTP_OPERATION`ƁA    샂[h(PTP/MTP)Ɋ֌WÃIy[VLɂȂ܂B
 *   V{USE_MTP_OPERATION`Ȃ΁A샂[h(PTP/MTP)Ɋ֌WÃIy[VɂȂ܂B
 *   '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́APTPƂĔFfoCXłĂAMTP̃Iy[VΉĂ΁AMTP̃Iy[Vgpē삷悤łB
 *   '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́AMTPƂĔFfoCXłĂAMTP̃Iy[VΉĂȂ΁APTP̃Iy[V݂̂œ삷悤łB */
#define USE_MTP_OPERATION

/****************************************************************************
 *	Ql
 ****************************************************************************/
//G[̕@ɂ
//uPTP Error Recoveryv(http://msdn.microsoft.com/en-us/library/windows/hardware/ff546442(v=vs.85).aspx)p:
//During initialization of the Microsoft PTP class minidriver (that is, on initial retrieval of the DeviceInfo and ObjectInfo datasets, and the property descriptions),
//any error is treated as a catastrophic failure, and the WIA minidriver fails to initialize.
//During later processing (for example, while retrieving an image), when an unrecognized error occurs,
//the Microsoft PTP minidriver first attempts to send the Get Device Status USB class-specific request (described in the USB Still Image Capture Device Definition).
//If that request succeeds, the driver clears any stalled endpoints and continues.
//If the Get Device Status request fails, the PTP minidriver attempts to reset the device using the Device Reset class-specific request (described in the USB Still Image Capture Device Definition).
//If the Device Reset class-specific request succeeds, it returns S_FALSE instead of S_OK. If resetting the device fails, the Device Reset class-specific request returns an error code.
//ƏĂ邪AۂɎƁAG[̕oȂB
//̓Iɂ́AGet Device StatusDevice Reset͌Ă΂邪ǍClear FeatureĂ΂ȂB
//̌́AGet Device Status̖߂l̍\AȂ̂ƎvB
//{AGet Device Status̖߂lɂ́AXg[ĂpCvǉĕԂƂɂȂĂ̂A
//dl(Universal Serial Bus Still Image Capture Device Definition)̐BŁA̓Iȍ\킩ȂB
//ŁA1oCgzŃoNGh|Cg̔ԍ(0x020x82)i[Ă݂AClear FeatureĂ΂ȂB
//̖ڏȀ݂AXg[ŃG[ʒḿAP/ECE𔲂邵̕@B
//ł邾Xg[ɁAX|XtF[YŃG[Ԃ悤ɍHv邵ƎvB
//2014/09/06ǋL
//܂B܂Ő삵ĂȂ̂́Aȉ̓̌łB
//1. clipusb.cdevice_request_endpoint()ɃoOLAclear_feature()삵Ă܂łB
//2. Get Device Status Request̖߂lParameterUINT8zɂĂ܂BUINT32złB
//LCƂAXg[ŃG[ʒmɁAĎ̏s悤ɂȂ܂B
/*--------------------------------------------------------------------------*/
//uMTP Compliance Test - Requirements - Media Playersv(http://msdn.microsoft.com/en-us/library/windows/hardware/jj124296.aspx)p:
//The test validates that the following Object Properties are supported for each supported format:
//1. StorageID
//2. ObjectFormat
//3. ProtectionStatus
//4. ObjectSize
//5. ObjectFileName
//6. ParentObject
//7. PersistentUniqueObjectIdentifier
//8. Name
//9. Non-Consumable
//T|[gׂIuWFNgvpeB́AL̒ʂłB
//ɏdvȂ̂́AParentObjectPersistentUniqueObjectIdentifierłBڍׂ́AȉǂłB
/*--------------------------------------------------------------------------*/
//uMedia Transfer Protocol Revision 1.1 April 6th, 2011v(MTPforUSB-IFv1.1.pdf)p:
//5.3.2.6 Required Object Properties
//Devices which implement Object Properties must implement as Object Properties the properties which map to the required fields of the ObjectInfo dataset, as well as certain properties which are required for effective functioning of the protocol.
//Required properties for all object formats include:
//EStorageID
//EObjectFormat
//EObjectCompressedSize
//EPersistent Unique Object Identifier
//EName
//Devices which support file systems through the use of associations must support the following object properties:
//EParentObject
//GetObjectPropsSupported,GetObjectPropDesc,GetObjectPropValueꍇ́AL̃vpeBɑΉ邱ƂK{łB
// - ParentObjectɑΉȂƁAPCP/ECEփt@C񂾌ɁÃZVŁÃt@C폜łȂȂ܂B(Windows7ɂĊmF)		ydvz
// - Persistent Unique Object IdentifierɑΉȂƁAt@C̈ꗗ\͂ł邪At@C̓ǂݏłȂȂ܂B(Windows7ɂĊmF)		ydvz
// - ObjectCompressedSizéAObjectSizêƂƎv܂B
// - NaméAObjectFileNamêƂNamêƂȂ̂ŁAΉĂƂɂ܂B
/*--------------------------------------------------------------------------*/
//uMedia Transfer Protocol Revision 1.1 April 6th, 2011v(MTPforUSB-IFv1.1.pdf)p:
//5.3.2.7 Optimizing Object Properties
//The development of object properties allows considerable improvements in functionality over the static descriptive set of metadata exposed in the ObjectInfo dataset, however, it comes at the cost of a dramatically increased number of queries to the device.
//This has been mitigated in the Basic MTP specification by defining object-property retrieval groups.
//5.3.2.7.1 Object Property Groups
//Many devices currently maintain an accelerator file or database containing a subset of available metadata used by the device for its own UI.
//These metadata items, when defined as object properties, are much more easily and efficiently retrieved than metadata stored within the content on the device.
//Devices are encouraged to identify the relative retrieval qualities of different properties by assigning them a group value in the ObjectPropDesc dataset, and allowing them to be retrieved based on that group value.
//Group codes shall be assigned in ascending order, based upon the relative retrieval speed of the property.
//The expected behavior of an initiator that is taking advantage of object property groups is that it will retrieve properties in ascending order.
//5.3.2.7.2 Special Values for Object Property Groups
//Properties of essentially unbounded size shall be marked with a group code of 0xFFFFFFFF.
//This includes any property defined by a LongString or ByteArray form.
//It is the responsibility of the device to accurately identify these groups.
//ObjectPropDescDataset.GroupCodeɂĂ̐łB
//ǂACjVG[^X|_GetObjectPropValue𔭍sہAvpeBǂ̏Ԃŗv邩Ɋւŵ悤łB
//GȃfoCXł́AvpeB̏ԂŎoƌǂ悤łAP/ECEł͊֌Ŵ0Œɂ邱Ƃɂ܂B
/****************************************************************************
 *	O[oϐ
 ****************************************************************************/
ST_PTP stPTP;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void vendor_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void ep2_rxdone();
static void ep2_txdone();
static int ep2_txsub();
static void put_string(void* _dst, const char* src);
static void get_string(char* dst, const void* _src);
static int is_protected_filename(const char* name);
static int process_command();
static int process_dataout(const void* buf, int len);
static int process_datain(void* buf, int len);
/****************************************************************************
 *	USBtbN
 ****************************************************************************/
static const USBINF usb_inf = {
	/* USBC mode */
	mode:			D12_ENDP_NONISO,
	/* USBC raw event */
	ep2_rxdone:		ep2_rxdone,
	ep2_txdone:		ep2_txdone,
	/* Device request */
	get_descriptor:		get_descriptor,
	set_configuration:	set_configuration,
	set_interface:		set_interface,
	/* Class request */
	class_request:		class_request,
	vendor_request:		vendor_request,
};
/****************************************************************************
 *	fBXNv^
 ****************************************************************************/
/* D.6.1.1 Device Descriptor */
static const DEVICE_DESCRIPTOR device_desc_PTP = {
	bLength:		sizeof(DEVICE_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	DEVICE_DESCRIPTOR_TYPE,			//Device Descriptor Type
	bcdUSB:			0x0110,					//USB Specification Release Number
//sv	bDeviceClass:		0x00,					//Class information may be found at the interface level
//sv	bDeviceSubClass:	0x00,					//bDeviceSubClass is zero
//sv	bDeviceProtocol:	0x00,					//bDeviceProtocol is zero
	bMaxPacketSize0:	EP0_PACKET_SIZE,			//mplementation specific, may be set to 8, 16, 32 or 64
	idVendor:		PCE_VENDOR_ID,				//Vendor ID assigned to IHV by USB-IF
	idProduct:		PTP_PRODUCT_ID,				//Product ID assigned by IHV
	bcdDevice:		0x0001,					//Device release number in BCD assigned by IHV to this release of model
	iManufacture:		1,					//Index of string descriptor describing IHV. If set to zero (0), there is no manufacturer string.
	iProduct:		2,					//Index of string describing this product. If set to zero (0), there is no product string.
//sv	iSerialNumber:		0,					//Index of string descriptor with this specific devicefs serial number. If set to zero (0), this device does not have a serial number.
	bNumConfigurations:	1,					//Device has this number of configurations.
};
static const DEVICE_DESCRIPTOR device_desc_MTP = {
	bLength:		sizeof(DEVICE_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	DEVICE_DESCRIPTOR_TYPE,			//Device Descriptor Type
	bcdUSB:			0x0200,					//USB Specification Release Number	//ydvzVersion 2.0+ required for microsoft os descriptors to work.
//sv	bDeviceClass:		0x00,					//Class information may be found at the interface level
//sv	bDeviceSubClass:	0x00,					//bDeviceSubClass is zero
//sv	bDeviceProtocol:	0x00,					//bDeviceProtocol is zero
	bMaxPacketSize0:	EP0_PACKET_SIZE,			//mplementation specific, may be set to 8, 16, 32 or 64
	idVendor:		PCE_VENDOR_ID,				//Vendor ID assigned to IHV by USB-IF
	idProduct:		MTP_PRODUCT_ID,				//Product ID assigned by IHV		//ydvzPTPMTPID𓯂ɂĂ͂ȂBڍׂclipptp.h́uv_NgIDṽRgQƂĂB
	bcdDevice:		0x0001,					//Device release number in BCD assigned by IHV to this release of model
	iManufacture:		1,					//Index of string descriptor describing IHV. If set to zero (0), there is no manufacturer string.
	iProduct:		2,					//Index of string describing this product. If set to zero (0), there is no product string.
//sv	iSerialNumber:		0,					//Index of string descriptor with this specific devicefs serial number. If set to zero (0), this device does not have a serial number.
	bNumConfigurations:	1,					//Device has this number of configurations.
};
/*--------------------------------------------------------------------------*/
/* D.6.1.2 Configuration Descriptor */
static const CONFIGURATION_DESCRIPTOR config_desc = {
	bLength:		sizeof(CONFIGURATION_DESCRIPTOR),	//The length of this descriptor
	bDescriptorType:	CONFIGURATION_DESCRIPTOR_TYPE,		//Configuration Descriptor Type
	wTotalLength:		sizeof(CONFIGURATION_DESCRIPTOR) +	//Total length of data returned for this configuration. Includes this descriptor and all of the descriptors that follow (interface, endpoint and vendor specific, if present).
				sizeof(INTERFACE_DESCRIPTOR) +
				sizeof(ENDPOINT_DESCRIPTOR) * 3,
	bNumInterfaces:		1,					//This configuration has <#> interfaces
	bConfigurationValue:	1,					//Implementation specific value used as an argument to Set Configuration to select this configuration
//sv	iConfiguration:		0,					//Index of string describing this configu ration. If set to zero (0), there is no configuration string.
	bmAttributes:		0x80,		/* Bus-powered */	//Configuration characteristics as defined by USB Specification
	MaxPower:		100 / 2,	/* 100[mA]() */	//Maximum power draw from the bus by this device when this configuration is selected.
};
/* D.6.1.3 Still Image Interface Descriptor */
static const INTERFACE_DESCRIPTOR interface_desc = {
	bLength:		sizeof(INTERFACE_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	INTERFACE_DESCRIPTOR_TYPE,		//Interface Descriptor Type
//sv	bInterfaceNumber:	0,					//Number of interface in configuration
//sv	bAlternateSetting:	0x00,					//Default setting for this interface
	bNumEndpoints:		3,					//Number of endpoints in this interface, not including the default endpoint.
	bInterfaceClass:	0x06,					//Image interface
	bInterfaceSubClass:	0x01,					//Still Image Capture Device
	bInterfaceProtocol:	0x01,					//This field indicates the protocol sup ported by this device. PIMA 15740 compliant devices use Bulk-only protocol
//sv	iInterface:		0,					//Index of string describing this inter face. If set to zero (0), there is no inter face string.
};
/* D.6.1.4 Data-In Endpoint Descriptor */
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,		//Endpoint Descriptor Type
	bEndpointAddress:	0x82,		/* EP2IN */		//Any endpoint number not used by another endpoint. The direction shall be set to IN.
	bmAttributes:		2,		/* Bulk */		//The endpoint uses bulk transfers
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,			//Maximum packet size used by this endpoint. This must be less than or equal to 64 bytes.
//sv	bInterval:		0,					//Ignored
};
/* D.6.1.5 Data-Out Endpoint Descriptor */
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2out = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,		//Endpoint Descriptor Type
	bEndpointAddress:	0x02,		/* EP2OUT */		//Any endpoint number not used by another endpoint. The direction shall be set to OUT.
	bmAttributes:		2,		/* Bulk */		//The endpoint uses bulk transfers
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,			//Maximum packet size used by this endpoint. This must be less than or equal to 64 bytes.
//sv	bInterval:		0,					//Ignored
};
/* D.6.1.6 Interrupt Endpoint Descriptor */
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep1in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),		//The length of this descriptor
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,		//Endpoint Descriptor Type
	bEndpointAddress:	0x81,		/* EP1IN */		//Any endpoint number not used by another endpoint. The direction shall be set to IN.
	bmAttributes:		3,		/* Interrupt */		//The endpoint uses interrupt transfers
	wMaxPacketSize:		EP1_PACKET_SIZE,			//Maximum packet size used by this endpoint. This must be less than or equal to 64 bytes.
	bInterval:		100,		/* 100[ms] */		//Interval for polling endpoint for data transfers
};
/*--------------------------------------------------------------------------*/
/* D.6.1.7 String Descriptors */
static const char* const string_desc[] = {
//	   ++-- 04 06 08 0a 0c 0e 10 12 14 16 18 1a 1c 1e 20 22 24 26 28 2a 2c 2e 30
//	   ||
//	"\x??\3_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0"
	"\x04\3\x09\x04",						// 0: wLANGID = 0x0409 English (United States)
	"\x16\3P\0i\0e\0c\0e\0 \0L\0a\0b\0.\0",				// 1: iManufacture   = "Piece Lab."
	"\x22\3P\0/\0E\0C\0E\0 \0U\0S\0B\0 \0d\0e\0v\0i\0c\0e\0",	// 2: iProduct       = "P/ECE USB device"
};
/****************************************************************************
 *	̑̃[Jf[^
 ****************************************************************************/
/* R}htF[Y̎ɍsׂtF[Y */
static const uint16_t TBL_DataDirection[][2/*OperationCode,Phase*/] = {
	{PTP_OperationCode_GetDeviceInfo		,PTP_Phase_DataIn	},
	{PTP_OperationCode_OpenSession			,PTP_Phase_Response	},
	{PTP_OperationCode_CloseSession			,PTP_Phase_Response	},
	{PTP_OperationCode_GetStorageIDs		,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetStorageInfo		,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetNumObjects		,PTP_Phase_Response	},
	{PTP_OperationCode_GetObjectHandles		,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetObjectInfo		,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetObject			,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetThumb			,PTP_Phase_DataIn	},
	{PTP_OperationCode_DeleteObject			,PTP_Phase_Response	},
	{PTP_OperationCode_SendObjectInfo		,PTP_Phase_DataOut	},
	{PTP_OperationCode_SendObject			,PTP_Phase_DataOut	},
	{PTP_OperationCode_InitiateCapture		,PTP_Phase_Response	},
	{PTP_OperationCode_FormatStore			,PTP_Phase_Response	},
	{PTP_OperationCode_ResetDevice			,PTP_Phase_Response	},
	{PTP_OperationCode_SelfTest			,PTP_Phase_Response	},
	{PTP_OperationCode_SetObjectProtection		,PTP_Phase_Response	},
	{PTP_OperationCode_PowerDown			,PTP_Phase_Response	},
	{PTP_OperationCode_GetDevicePropDesc		,PTP_Phase_DataIn	},
	{PTP_OperationCode_GetDevicePropValue		,PTP_Phase_DataIn	},
	{PTP_OperationCode_SetDevicePropValue		,PTP_Phase_DataOut	},
	{PTP_OperationCode_ResetDevicePropValue		,PTP_Phase_Response	},
	{PTP_OperationCode_TerminateOpenCapture		,PTP_Phase_Response	},
	{PTP_OperationCode_MoveObject			,PTP_Phase_Response	},
	{PTP_OperationCode_CopyObject			,PTP_Phase_Response	},
	{PTP_OperationCode_GetPartialObject		,PTP_Phase_DataIn	},
	{PTP_OperationCode_InitiateOpenCapture		,PTP_Phase_Response	},
#ifdef  USE_MTP_OPERATION
	/*--- MTP Extension operation codes ---*/
	{MTP_OperationCode_GetObjectPropsSupported	,PTP_Phase_DataIn	},
	{MTP_OperationCode_GetObjectPropDesc		,PTP_Phase_DataIn	},
	{MTP_OperationCode_GetObjectPropValue		,PTP_Phase_DataIn	},
	{MTP_OperationCode_SetObjectPropValue		,PTP_Phase_DataOut	},
	{MTP_OperationCode_GetObjectPropList		,PTP_Phase_DataIn	},
	{MTP_OperationCode_SetObjectPropList		,PTP_Phase_DataOut	},
	{MTP_OperationCode_GetInterdependentPropDesc	,PTP_Phase_DataIn	},
	{MTP_OperationCode_SendObjectPropList		,PTP_Phase_DataOut	},
	{MTP_OperationCode_GetObjectReferences		,PTP_Phase_DataIn	},
	{MTP_OperationCode_SetObjectReferences		,PTP_Phase_DataOut	},
	{MTP_OperationCode_Skip				,PTP_Phase_Response	},
#endif//USE_MTP_OPERATION
};
/*--------------------------------------------------------------------------*/
/* DeviceInfo Dataset */
static const uint8_t DeviceInfoDataset[] = {
	USB_UINT16(100),						// 1 StandardVersion		2 UINT16	u0x0100vł͂Ȃu100vŐB
#ifdef  USE_MTP_OPERATION
	USB_UINT32(6),							// 2 VendorExtensionID		4 UINT32	uMTP Device Extensions for Metadata Transferv(http://msdn.microsoft.com/en-us/library/windows/desktop/dd563898(v=vs.85).aspx)p:
	USB_UINT16(100),						// 3 VendorExtensionVersion	2 UINT16	Media Transfer Protocol (MTP) is a protocol designed for portable media devices.
	26,								// 4 VendorExtensionDesc	? String	The primary purpose of this protocol is to provide a common protocol for exchanging data between a computer and a portable media device.
	 USB_UINT16('m'),// 1						//						This includes receiving and sending media objects and enumerating the contents and capabilities of the device.
	 USB_UINT16('i'),// 2						//						MTP uses persistent unique object identifiers (PUOIDs) to uniquely identify digital media items (and other objects) stored on a device.
	 USB_UINT16('c'),// 3						//						When exchanging information about changes that have occurred on a device that supports MTP, the device and Windows Media Player use PUOIDs to identify which objects have changed.
	 USB_UINT16('r'),// 4						//						The header file named wmpdevices.h, which is installed as part of the Windows Media Player SDK, defines the structures and constants needed to support Windows Media Player device extensions
	 USB_UINT16('o'),// 5						//						For a device to be recognized as supporting metadata transfer through the Windows Media Player MTP device extension set, it must include the following information in the DeviceInfo dataset. (For more information about this dataset, see section 4.6.1 of the MTP specification.)
	 USB_UINT16('s'),// 6						//						 Dataset field           Field order  Data type  Value
	 USB_UINT16('o'),// 7						//						 VendorExtensionID       2            UINT32     0x00000006
	 USB_UINT16('f'),// 8						//						 VendorExtensionVersion  3            UINT16     0x0064 (100)
	 USB_UINT16('t'),// 9						//						 VendorExtensionDesc     4            String     "microsoft.com/WMPPD: 10.0"
	 USB_UINT16('.'),//10						//						The following table provides details about the MTP operation for accelerated metadata transfer.
	 USB_UINT16('c'),//11						//						 Item                   Description
	 USB_UINT16('o'),//12						//						 Operation Code         0x9201
	 USB_UINT16('m'),//13						//						 Operation Parameter 1  The transaction ID supplied by the device during the previous session. This value is zero for the first session.
	 USB_UINT16('/'),//14						//						 Operation Parameter 2  Starting index. This value is always zero on the first call of a session. On subsequent calls within the same synchronization session, this value increases by the sum of the count of the modified and the deleted items from the previous response data.
	 USB_UINT16('W'),//15						//						 Operation Parameter 3  0x10000. This constant, defined in wmpdevices.h, is the maximum number of PUOIDs that can be returned in the response. Note that the value of this constant may be revised in future releases of this header file.
	 USB_UINT16('M'),//16						//						 Operation Parameter 4  0
	 USB_UINT16('P'),//17						//						 Operation Parameter 5  0
	 USB_UINT16('P'),//18						//						 Data                   The device returns two contiguous MTP arrays containing PUOIDs. Each MTP array begins with a DWORD value indicating the count of items in the array, followed by the array of elements. The first MTP array contains the list of PUOIDs that have been added or changed. The second MTP array contains the list of PUOIDs that have been deleted from the portable device. Note that the sum of PUOID count in the two arrays must not exceed the value passed in Operation Parameter 3.
	 USB_UINT16('D'),//19						//						 Data Direction         R->I
	 USB_UINT16(':'),//20						//						 Response Code          Options MTP_RESPONSE_OK (0x2001) or valid error response code.
	 USB_UINT16(' '),//21						//						 Response Parameter 1   The device's current transaction ID.
	 USB_UINT16('1'),//22						//						 Response Parameter 2   The number of PUOIDs that remain to be retrieved by future requests.
	 USB_UINT16('0'),//23						//						 Response Parameter 3   DWORD containing status information. Status is indicated in a bitwise fashion. See Remarks for information about flags to use.
	 USB_UINT16('.'),//24						//						 Response Parameter 4   0
	 USB_UINT16('0'),//25						//						 Response Parameter 5   0
	 USB_UINT16( 0 ),//26						//
#else //USE_MTP_OPERATION
	USB_UINT32(0),							// 2 VendorExtensionID		4 UINT32
	USB_UINT16(0),							// 3 VendorExtensionVersion	2 UINT16
	0,								// 4 VendorExtensionDesc	? String
#endif//USE_MTP_OPERATION
	USB_UINT16(0),							// 5 FunctionalMode		2 UINT16
#ifdef  USE_MTP_OPERATION
	USB_UINT32(15),							// 6 OperationsSupported	? OperationCode Array
	 USB_UINT16(PTP_OperationCode_GetDeviceInfo),				// 1
	 USB_UINT16(PTP_OperationCode_OpenSession),				// 2
	 USB_UINT16(PTP_OperationCode_CloseSession),				// 3
	 USB_UINT16(PTP_OperationCode_GetStorageIDs),				// 4
	 USB_UINT16(PTP_OperationCode_GetStorageInfo),				// 5
	 USB_UINT16(PTP_OperationCode_GetNumObjects),				// 6
	 USB_UINT16(PTP_OperationCode_GetObjectHandles),			// 7
	 USB_UINT16(PTP_OperationCode_GetObjectInfo),				// 8
	 USB_UINT16(PTP_OperationCode_GetObject),				// 9
//	 USB_UINT16(PTP_OperationCode_GetThumb),				//
	 USB_UINT16(PTP_OperationCode_DeleteObject),				//10
	 USB_UINT16(PTP_OperationCode_SendObjectInfo),				//11
	 USB_UINT16(PTP_OperationCode_SendObject),				//12
//	 USB_UINT16(PTP_OperationCode_InitiateCapture),				//
//	 USB_UINT16(PTP_OperationCode_FormatStore),				//
//	 USB_UINT16(PTP_OperationCode_ResetDevice),				//
//	 USB_UINT16(PTP_OperationCode_SelfTest),				//
//	 USB_UINT16(PTP_OperationCode_SetObjectProtection),			//
//	 USB_UINT16(PTP_OperationCode_PowerDown),				//
//	 USB_UINT16(PTP_OperationCode_GetDevicePropDesc),			//
//	 USB_UINT16(PTP_OperationCode_GetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_SetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_ResetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_TerminateOpenCapture),			//
//	 USB_UINT16(PTP_OperationCode_MoveObject),				//
//	 USB_UINT16(PTP_OperationCode_CopyObject),				//
//	 USB_UINT16(PTP_OperationCode_GetPartialObject),			//
//	 USB_UINT16(PTP_OperationCode_InitiateOpenCapture),			//
	 /*--- MTP Extension operation codes ---*/
	 USB_UINT16(MTP_OperationCode_GetObjectPropsSupported),			//13	
	 USB_UINT16(MTP_OperationCode_GetObjectPropDesc),			//14	5.3.2.1 Requirements for Object Property Support
	 USB_UINT16(MTP_OperationCode_GetObjectPropValue),			//15	
//	 USB_UINT16(MTP_OperationCode_SetObjectPropValue),			//
//	 USB_UINT16(MTP_OperationCode_GetObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_SetObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_GetInterdependentPropDesc),		//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_SendObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_GetObjectReferences),			//
//	 USB_UINT16(MTP_OperationCode_SetObjectReferences),			//
//	 USB_UINT16(MTP_OperationCode_Skip),					//
#else //USE_MTP_OPERATION
	USB_UINT32(12),							// 6 OperationsSupported	? OperationCode Array
	 USB_UINT16(PTP_OperationCode_GetDeviceInfo),				// 1
	 USB_UINT16(PTP_OperationCode_OpenSession),				// 2
	 USB_UINT16(PTP_OperationCode_CloseSession),				// 3
	 USB_UINT16(PTP_OperationCode_GetStorageIDs),				// 4
	 USB_UINT16(PTP_OperationCode_GetStorageInfo),				// 5
	 USB_UINT16(PTP_OperationCode_GetNumObjects),				// 6
	 USB_UINT16(PTP_OperationCode_GetObjectHandles),			// 7
	 USB_UINT16(PTP_OperationCode_GetObjectInfo),				// 8
	 USB_UINT16(PTP_OperationCode_GetObject),				// 9
//	 USB_UINT16(PTP_OperationCode_GetThumb),				//
	 USB_UINT16(PTP_OperationCode_DeleteObject),				//10
	 USB_UINT16(PTP_OperationCode_SendObjectInfo),				//11
	 USB_UINT16(PTP_OperationCode_SendObject),				//12
//	 USB_UINT16(PTP_OperationCode_InitiateCapture),				//
//	 USB_UINT16(PTP_OperationCode_FormatStore),				//
//	 USB_UINT16(PTP_OperationCode_ResetDevice),				//
//	 USB_UINT16(PTP_OperationCode_SelfTest),				//
//	 USB_UINT16(PTP_OperationCode_SetObjectProtection),			//
//	 USB_UINT16(PTP_OperationCode_PowerDown),				//
//	 USB_UINT16(PTP_OperationCode_GetDevicePropDesc),			//
//	 USB_UINT16(PTP_OperationCode_GetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_SetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_ResetDevicePropValue),			//
//	 USB_UINT16(PTP_OperationCode_TerminateOpenCapture),			//
//	 USB_UINT16(PTP_OperationCode_MoveObject),				//
//	 USB_UINT16(PTP_OperationCode_CopyObject),				//
//	 USB_UINT16(PTP_OperationCode_GetPartialObject),			//
//	 USB_UINT16(PTP_OperationCode_InitiateOpenCapture),			//
	 /*--- MTP Extension operation codes ---*/
//	 USB_UINT16(MTP_OperationCode_GetObjectPropsSupported),			//	
//	 USB_UINT16(MTP_OperationCode_GetObjectPropDesc),			//	5.3.2.1 Requirements for Object Property Support
//	 USB_UINT16(MTP_OperationCode_GetObjectPropValue),			//	
//	 USB_UINT16(MTP_OperationCode_SetObjectPropValue),			//
//	 USB_UINT16(MTP_OperationCode_GetObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_SetObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_GetInterdependentPropDesc),		//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_SendObjectPropList),			//	//Enhanced Operation
//	 USB_UINT16(MTP_OperationCode_GetObjectReferences),			//
//	 USB_UINT16(MTP_OperationCode_SetObjectReferences),			//
//	 USB_UINT16(MTP_OperationCode_Skip),					//
#endif//USE_MTP_OPERATION
	USB_UINT32(0),							// 7 EventsSupported		? EventCode Array
	USB_UINT32(0),							// 8 DevicePropertiesSupported	? DevicePropCode Array
	USB_UINT32(0),							// 9 CaptureFormats		? ObjectFormatCode Array
	USB_UINT32(96),							//10 ImageFormats		? ObjectFormatCode Array
	 USB_UINT16(PTP_ObjectFormat_Undefined),				// 1	0x3000		//Undefined non-image object						Windows7P/ECE֏ނƂAOSm̊gq(*.jpg,*.png)ȊÓASāuUndefinedv`ƂĈBuUndefinedv`܂߂ĂȂƁAA
	 USB_UINT16(PTP_ObjectFormat_Association),				// 2	0x3001		//Association (e.g. folder)						@u`foCXɃRs[Ă낵ł? gp̃foCXł́Ãt@CĐ܂͕\łȂ\܂BvƂx\Ă܂B
	 USB_UINT16(PTP_ObjectFormat_Script),					// 3	0x3002		//Device-model-specific script						
	 USB_UINT16(PTP_ObjectFormat_Executable),				// 4	0x3003		//Device-model-specific binary executable				
	 USB_UINT16(PTP_ObjectFormat_Text),					// 5	0x3004		//Text file								
	 USB_UINT16(PTP_ObjectFormat_HTML),					// 6	0x3005		//HyperText Markup Language file (text)					
	 USB_UINT16(PTP_ObjectFormat_DPOF),					// 7	0x3006		//Digital Print Order Format file (text)				
	 USB_UINT16(PTP_ObjectFormat_AIFF),					// 8	0x3007		//Audio clip								
	 USB_UINT16(PTP_ObjectFormat_WAV),					// 9	0x3008		//Audio clip								
	 USB_UINT16(PTP_ObjectFormat_MP3),					//10	0x3009		//Audio clip								
	 USB_UINT16(PTP_ObjectFormat_AVI),					//11	0x300A		//Video clip								
	 USB_UINT16(PTP_ObjectFormat_MPEG),					//12	0x300B		//Video clip								
	 USB_UINT16(PTP_ObjectFormat_ASF),					//13	0x300C		//Microsoft Advanced Streaming Format (video)				
	 USB_UINT16(PTP_ObjectFormat_UnknownImageObject),			//14	0x3800		//Unknown image object							
	 USB_UINT16(PTP_ObjectFormat_EXIF_JPEG),				//15	0x3801		//Exchangeable File Format, JEIDA standard				
	 USB_UINT16(PTP_ObjectFormat_TIFF_EP),					//16	0x3802		//Tag Image File Format for Electronic Photography			
	 USB_UINT16(PTP_ObjectFormat_FlashPix),					//17	0x3803		//Structured Storage Image Format					
	 USB_UINT16(PTP_ObjectFormat_BMP),					//18	0x3804		//Microsoft Windows Bitmap file						`ĂIuWFNgtH[}bgASė񋓂ĂƂɂBɗ񋓂ĂȂ`́AOSŔfāARs[s,,x\B
	 USB_UINT16(PTP_ObjectFormat_CIFF),					//19	0x3805		//Canon Camera Image File Format					
	 USB_UINT16(PTP_ObjectFormat_Reserved_0x3806),				//20	0x3806		//Reserved								
	 USB_UINT16(PTP_ObjectFormat_GIF),					//21	0x3807		//Graphics Interchange Format						
	 USB_UINT16(PTP_ObjectFormat_JFIF),					//22	0x3808		//JPEG File Interchange Format						
	 USB_UINT16(PTP_ObjectFormat_PCD),					//23	0x3809		//PhotoCD Image Pac							
	 USB_UINT16(PTP_ObjectFormat_PICT),					//24	0x380A		//Quickdraw Image Format						
	 USB_UINT16(PTP_ObjectFormat_PNG),					//25	0x380B		//Portable Network Graphics						
	 USB_UINT16(PTP_ObjectFormat_Reserved_0x380C),				//26	0x380C		//Reserved								
	 USB_UINT16(PTP_ObjectFormat_TIFF),					//27	0x380D		//Tag Image File Format							
	 USB_UINT16(PTP_ObjectFormat_TIFF_IT),					//28	0x380E		//Tag Image File Format for Information Technology (graphic arts)	
	 USB_UINT16(PTP_ObjectFormat_JP2),					//29	0x380F		//JPEG2000 Baseline File Format						
	 USB_UINT16(PTP_ObjectFormat_JPX),					//30	0x3810		//JPEG2000 Extended File Format						
//	 USB_UINT16(PTP_ObjectFormat_Reserved),					//	0x3000/*+?*/	//Reserved for future use	All other codes with MSN of 0011	
//	 USB_UINT16(PTP_ObjectFormat_VendorDefined),				//	0xB000/*+?*/	//Vendor-Defined		All other codes with MSN of 1011	
	 /*--- MTP Extension format codes ---*/					//												
	 USB_UINT16(MTP_ObjectFormat_UndefinedFirmware),			//31	0xB802											
	 USB_UINT16(MTP_ObjectFormat_WBMP ),					//32	0xB803		//Wireless Application Protocol Bitmap Format (.wbmp). image/vnd.wap.wbmp http://www.wapforum.org/what/technical/SPEC-WAESpec-19990524.pdf
	 USB_UINT16(MTP_ObjectFormat_JPEG_XR ),					//33	0xB804		//JPEG XR, also known as HD Photo (.hdp,.jxr,.wpd). image/vnd.ms-photo. ISO/IEC 29199-2:2009 http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=51609
	 USB_UINT16(MTP_ObjectFormat_WindowsImageFormat),			//34	0xB881											
	 USB_UINT16(MTP_ObjectFormat_UndefinedAudio),				//35	0xB900		//Undefined audio object						
	 USB_UINT16(MTP_ObjectFormat_WMA),					//36	0xB901		//Windows Media Audio							
	 USB_UINT16(MTP_ObjectFormat_OGG),					//37	0xB902											
	 USB_UINT16(MTP_ObjectFormat_AAC),					//38	0xB903		//Advanced Audio Coding (.aac). audio/aac. MPEG-4 AAC.			
	 USB_UINT16(MTP_ObjectFormat_Audible),					//39	0xB904											
	 USB_UINT16(MTP_ObjectFormat_FLAC),					//40	0xB906		//Free Lossless Audio Codec						
	 USB_UINT16(MTP_ObjectFormat_QCELP),					//41	0xB907		//Qualcomm Code Excited Linear Prediction (.qcp). audio/qcelp		
	 USB_UINT16(MTP_ObjectFormat_AMR),					//42	0xB908		//Adaptive Multi-Rate audio codec (.amr). audio/amr			
	 USB_UINT16(MTP_ObjectFormat_UndefinedVideo),				//43	0xB980		//Undefined video object						
	 USB_UINT16(MTP_ObjectFormat_WMV),					//44	0xB981		//Windows Media Video							
	 USB_UINT16(MTP_ObjectFormat_MP4Container),				//45	0xB982		//ISO 14496-1								
	 USB_UINT16(MTP_ObjectFormat_MP2),					//46	0xB983		//MPEG-1 Layer II audio (ISO/IEC 13818-3)				
	 USB_UINT16(MTP_ObjectFormat_3GPContainer),				//47	0xB984		//3GPP file format. Details: http://www.3gpp.org/ftp/Specs/html-info/26244.htm (page title - "Transparent end-to-end packet switched streaming service, 3GPP file format").
	 USB_UINT16(MTP_ObjectFormat_3G2),					//48	0xB985		//3GPP2 format (.3g2). video/3gpp2, audio/3gpp2 http://www.3gpp2.org/Public_html/specs/C.S0050-B_v1.0_070521.pdf
	 USB_UINT16(MTP_ObjectFormat_AVCHD),					//49	0xB986		//MPEG-4 AVC video and Dolby Digital audio within an MPEG-2 Transport Stream as constrained by the AVCHD format specification http://www.avchd-info.org/
	 USB_UINT16(MTP_ObjectFormat_ATSC_TS),					//50	0xB987		//MPEG-2 video and AC-3 audio within an ATSC-compliant MPEG-2 Transport Stream
	 USB_UINT16(MTP_ObjectFormat_DVB_TS),					//51	0xB988		//MPEG-2 video and MPEG-1 Layer II or AC-3 audio within a DVB-compliant MPEG-2 Transport Stream
	 USB_UINT16(MTP_ObjectFormat_UndefinedCollection),			//52	0xBA00											
	 USB_UINT16(MTP_ObjectFormat_AbstractMultimediaAlbum),			//53	0xBA01											
	 USB_UINT16(MTP_ObjectFormat_AbstractImageAlbum),			//54	0xBA02											
	 USB_UINT16(MTP_ObjectFormat_AbstractAudioAlbum),			//55	0xBA03											
	 USB_UINT16(MTP_ObjectFormat_AbstractVideoAlbum),			//56	0xBA04											
	 USB_UINT16(MTP_ObjectFormat_AbstractAudioVideoPlaylist),		//57	0xBA05											
	 USB_UINT16(MTP_ObjectFormat_AbstractContactGroup),			//58	0xBA06											
	 USB_UINT16(MTP_ObjectFormat_AbstractMessageFolder),			//59	0xBA07											
	 USB_UINT16(MTP_ObjectFormat_AbstractChapteredProduction),		//60	0xBA08											
	 USB_UINT16(MTP_ObjectFormat_AbstractAudioPlaylist),			//61	0xBA09											
	 USB_UINT16(MTP_ObjectFormat_AbstractVideoPlaylist),			//62	0xBA0A											
	 USB_UINT16(MTP_ObjectFormat_AbstractMediacast),			//63	0xBA0B		//For use with mediacasts; references multimedia enclosures of RSS feeds or episodic content
	 USB_UINT16(MTP_ObjectFormat_WPLPlaylist),				//64	0xBA10											
	 USB_UINT16(MTP_ObjectFormat_M3UPlaylist),				//65	0xBA11											
	 USB_UINT16(MTP_ObjectFormat_MPLPlaylist),				//66	0xBA12											
	 USB_UINT16(MTP_ObjectFormat_ASXPlaylist),				//67	0xBA13											
	 USB_UINT16(MTP_ObjectFormat_PLSPlaylist),				//68	0xBA14											
	 USB_UINT16(MTP_ObjectFormat_UndefinedDocument),			//69	0xBA80											
	 USB_UINT16(MTP_ObjectFormat_AbstractDocument),				//70	0xBA81											
	 USB_UINT16(MTP_ObjectFormat_XMLDocument),				//71	0xBA82											
	 USB_UINT16(MTP_ObjectFormat_MicrosoftWordDocument),			//72	0xBA83											
	 USB_UINT16(MTP_ObjectFormat_MHTCompiledHTMLDocument),			//73	0xBA84											
	 USB_UINT16(MTP_ObjectFormat_MicrosoftExcelSpreadsheet),		//74	0xBA85											
	 USB_UINT16(MTP_ObjectFormat_MicrosoftPowerpointDocument),		//75	0xBA86											
	 USB_UINT16(MTP_ObjectFormat_UndefinedMessage),				//76	0xBB00											
	 USB_UINT16(MTP_ObjectFormat_AbstractMessage),				//77	0xBB01											
	 USB_UINT16(MTP_ObjectFormat_UndefinedBookmark),			//78	0xBB10											
	 USB_UINT16(MTP_ObjectFormat_AbstractBookmark),				//79	0xBB11											
	 USB_UINT16(MTP_ObjectFormat_UndefinedAppointment),			//80	0xBB20											
	 USB_UINT16(MTP_ObjectFormat_AbstractAppointment),			//81	0xBB21											
	 USB_UINT16(MTP_ObjectFormat_vCalendar1_0),				//82	0xBE22		//(vmF:0xBE220xBE02̂ǂ炪̂s)			
	 USB_UINT16(MTP_ObjectFormat_UndefinedTask),				//83	0xBB40											
	 USB_UINT16(MTP_ObjectFormat_AbstractTask),				//84	0xBB41											
	 USB_UINT16(MTP_ObjectFormat_iCalendar),				//85	0xBB42											
	 USB_UINT16(MTP_ObjectFormat_UndefinedNote),				//86	0xBB60											
	 USB_UINT16(MTP_ObjectFormat_AbstractNote),				//87	0xBB61											
	 USB_UINT16(MTP_ObjectFormat_UndefinedContact),				//88	0xBB80											
	 USB_UINT16(MTP_ObjectFormat_AbstractContact),				//89	0xBB81											
	 USB_UINT16(MTP_ObjectFormat_vCard2),					//90	0xBB82											
	 USB_UINT16(MTP_ObjectFormat_vCard3),					//91	0xBB83											
	 USB_UINT16(MTP_ObjectFormat_UndefinedCalendarItem),			//92	0xBE00											
	 USB_UINT16(MTP_ObjectFormat_AbstractCalendarItem),			//93	0xBE01											
	 USB_UINT16(MTP_ObjectFormat_vCalendar1),				//94	0xBE02		//(vmF:0xBE220xBE02̂ǂ炪̂s)			
	 USB_UINT16(MTP_ObjectFormat_vCalendar2),				//95	0xBE03											
	 USB_UINT16(MTP_ObjectFormat_UndefinedWindowsExecutable),		//96	0xBE80											
	11,								//11 Manufacturer		? String
	 USB_UINT16('P'),// 1
	 USB_UINT16('i'),// 2
	 USB_UINT16('e'),// 3
	 USB_UINT16('c'),// 4
	 USB_UINT16('e'),// 5
	 USB_UINT16(' '),// 6
	 USB_UINT16('L'),// 7
	 USB_UINT16('a'),// 8
	 USB_UINT16('b'),// 9
	 USB_UINT16('.'),//10
	 USB_UINT16( 0 ),//11
	17,								//12 Model			? String
	 USB_UINT16('P'),// 1
	 USB_UINT16('/'),// 2
	 USB_UINT16('E'),// 3
	 USB_UINT16('C'),// 4
	 USB_UINT16('E'),// 5
	 USB_UINT16(' '),// 6
	 USB_UINT16('U'),// 7
	 USB_UINT16('S'),// 8
	 USB_UINT16('B'),// 9
	 USB_UINT16(' '),//10
	 USB_UINT16('d'),//11
	 USB_UINT16('e'),//12
	 USB_UINT16('v'),//13
	 USB_UINT16('i'),//14
	 USB_UINT16('c'),//15
	 USB_UINT16('e'),//16
	 USB_UINT16( 0 ),//17
	0,								//13 DeviceVersion		? String
	0,								//14 SerialNumber		? String
};
/*--------------------------------------------------------------------------*/
//If a physical store does not contain any logical stores, the LogicalStorageID should be set to 0x0000, and it shall be assumed that the store does not contain any data, nor can it receive any data.
//StorageIDs of 0x00000000 and 0xFFFFFFFF are not used to refer to real stores, but have context-specific meanings, such as gall-stores,h or gthe default store.h
#define StorageID	(1|1<<16)	//PhysicalStorageID=1,LogicalStorageID=1
/*--------------------------------------------------------------------------*/
/* StorageID Array */
static const uint8_t StorageIDArray[] = {
	USB_UINT32(1),
	 USB_UINT32(StorageID),// 0
};
/*--------------------------------------------------------------------------*/
/* StorageInfo Dataset */
static const uint8_t StorageInfoDataset[] = {
	USB_UINT16(PTP_StorageType_FixedRAM),				// 1 StorageType		2 UINT16
	USB_UINT16(PTP_FilesystemType_GenericFlat),			// 2 FilesystemType		2 UINT16
	USB_UINT16(PTP_AccessCapability_ReadWrite),			// 3 AccessCapability		2 UINT16
	USB_UINT64(-1,-1),						// 4 MaxCapacity		8 UINT64	If this field is unused, it should report 0xFFFFFFFF.
	USB_UINT64(-1,-1),						// 5 FreeSpaceInBytes		8 UINT64	If this value is not useful for the device, it may set this field to 0xFFFFFFFF and rely upon the FreeSpaceInImages field instead.
	USB_UINT32(-1),							// 6 FreeSpaceInImages		4 UINT32	If the device does not implement this capability, this field should be set to 0xFFFFFFFF. This field may be used for devices that do not report FreeSpaceInBytes, or the two fields may be used in combination.
	0,								// 7 StorageDescription		? String
	0,								// 8 VolumeLabel		? String
};
/*--------------------------------------------------------------------------*/
#ifdef  USE_MTP_OPERATION
/* ObjectPropCode Array */
static const uint8_t ObjectPropCodeArray[] = {
	USB_UINT32(9),
	 USB_UINT16(MTP_ObjectProperty_StorageID),				// 1
	 USB_UINT16(MTP_ObjectProperty_ObjectFormat),				// 2
	 USB_UINT16(MTP_ObjectProperty_ProtectionStatus),			// 3
	 USB_UINT16(MTP_ObjectProperty_ObjectSize),				// 4
//	 USB_UINT16(MTP_ObjectProperty_AssociationType),			//
//	 USB_UINT16(MTP_ObjectProperty_AssociationDesc),			//
	 USB_UINT16(MTP_ObjectProperty_ObjectFileName),				// 5
//	 USB_UINT16(MTP_ObjectProperty_DateCreated),				//
//	 USB_UINT16(MTP_ObjectProperty_DateModified),				//
//	 USB_UINT16(MTP_ObjectProperty_Keywords),				//
	 USB_UINT16(MTP_ObjectProperty_ParentObject),				// 6
//	 USB_UINT16(MTP_ObjectProperty_AllowedFolderContents),			//
//	 USB_UINT16(MTP_ObjectProperty_Hidden),					//
//	 USB_UINT16(MTP_ObjectProperty_SystemObject),				//
	 USB_UINT16(MTP_ObjectProperty_PersistentUniqueObjectIdentifier),	// 7
//	 USB_UINT16(MTP_ObjectProperty_SyncID),					//
//	 USB_UINT16(MTP_ObjectProperty_PropertyBag),				//
	 USB_UINT16(MTP_ObjectProperty_Name),					// 8
//	 USB_UINT16(MTP_ObjectProperty_CreatedBy),				//
//	 USB_UINT16(MTP_ObjectProperty_Artist),					//
//	 USB_UINT16(MTP_ObjectProperty_DateAuthored),				//
//	 USB_UINT16(MTP_ObjectProperty_Description),				//
//	 USB_UINT16(MTP_ObjectProperty_URLReference),				//
//	 USB_UINT16(MTP_ObjectProperty_LanguageLocale),				//
//	 USB_UINT16(MTP_ObjectProperty_CopyrightInformation),			//
//	 USB_UINT16(MTP_ObjectProperty_Source),					//
//	 USB_UINT16(MTP_ObjectProperty_OriginLocation),				//
//	 USB_UINT16(MTP_ObjectProperty_DateAdded),				//
	 USB_UINT16(MTP_ObjectProperty_NonConsumable),				// 9
//	 USB_UINT16(MTP_ObjectProperty_CorruptUnplayable),			//
//	 USB_UINT16(MTP_ObjectProperty_ProducerSerialNumber),			//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleFormat),		//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleSize),		//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleHeight),		//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleWidth),		//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleDuration),		//
//	 USB_UINT16(MTP_ObjectProperty_RepresentativeSampleData),		//
//	 USB_UINT16(MTP_ObjectProperty_Width),					//
//	 USB_UINT16(MTP_ObjectProperty_Height),					//
//	 USB_UINT16(MTP_ObjectProperty_Duration),				//
//	 USB_UINT16(MTP_ObjectProperty_Rating),					//
//	 USB_UINT16(MTP_ObjectProperty_Track),					//
//	 USB_UINT16(MTP_ObjectProperty_Genre),					//
//	 USB_UINT16(MTP_ObjectProperty_Credits),				//
//	 USB_UINT16(MTP_ObjectProperty_Lyrics),					//
//	 USB_UINT16(MTP_ObjectProperty_SubscriptionContentID),			//
//	 USB_UINT16(MTP_ObjectProperty_ProducedBy),				//
//	 USB_UINT16(MTP_ObjectProperty_UseCount),				//
//	 USB_UINT16(MTP_ObjectProperty_SkipCount),				//
//	 USB_UINT16(MTP_ObjectProperty_LastAccessed),				//
//	 USB_UINT16(MTP_ObjectProperty_ParentalRating),				//
//	 USB_UINT16(MTP_ObjectProperty_MetaGenre),				//
//	 USB_UINT16(MTP_ObjectProperty_Composer),				//
//	 USB_UINT16(MTP_ObjectProperty_EffectiveRating),			//
//	 USB_UINT16(MTP_ObjectProperty_Subtitle),				//
//	 USB_UINT16(MTP_ObjectProperty_OriginalReleaseDate),			//
//	 USB_UINT16(MTP_ObjectProperty_AlbumName),				//
//	 USB_UINT16(MTP_ObjectProperty_AlbumArtist),				//
//	 USB_UINT16(MTP_ObjectProperty_Mood),					//
//	 USB_UINT16(MTP_ObjectProperty_DRMStatus),				//
//	 USB_UINT16(MTP_ObjectProperty_SubDescription),				//
//	 USB_UINT16(MTP_ObjectProperty_IsCropped),				//
//	 USB_UINT16(MTP_ObjectProperty_IsColourCorrected),			//
//	 USB_UINT16(MTP_ObjectProperty_ImageBitDepth),				//
//	 USB_UINT16(MTP_ObjectProperty_Fnumber),				//
//	 USB_UINT16(MTP_ObjectProperty_ExposureTime),				//
//	 USB_UINT16(MTP_ObjectProperty_ExposureIndex),				//
//	 USB_UINT16(MTP_ObjectProperty_TotalBitRate),				//
//	 USB_UINT16(MTP_ObjectProperty_BitrateType),				//
//	 USB_UINT16(MTP_ObjectProperty_SampleRate),				//
//	 USB_UINT16(MTP_ObjectProperty_NumberOfChannels),			//
//	 USB_UINT16(MTP_ObjectProperty_AudioBitDepth),				//
//	 USB_UINT16(MTP_ObjectProperty_ScanType),				//
//	 USB_UINT16(MTP_ObjectProperty_AudioWAVECodec),				//
//	 USB_UINT16(MTP_ObjectProperty_AudioBitRate),				//
//	 USB_UINT16(MTP_ObjectProperty_VideoFourCCCodec),			//
//	 USB_UINT16(MTP_ObjectProperty_VideoBitRate),				//
//	 USB_UINT16(MTP_ObjectProperty_FramesPerThousandSeconds),		//
//	 USB_UINT16(MTP_ObjectProperty_KeyFrameDistance),			//
//	 USB_UINT16(MTP_ObjectProperty_BufferSize),				//
//	 USB_UINT16(MTP_ObjectProperty_EncodingQuality),			//
//	 USB_UINT16(MTP_ObjectProperty_EncodingProfile),			//
//	 USB_UINT16(MTP_ObjectProperty_DisplayName),				//
//	 USB_UINT16(MTP_ObjectProperty_BodyText),				//
//	 USB_UINT16(MTP_ObjectProperty_Subject),				//
//	 USB_UINT16(MTP_ObjectProperty_Priority),				//
//	 USB_UINT16(MTP_ObjectProperty_GivenName),				//
//	 USB_UINT16(MTP_ObjectProperty_MiddleNames),				//
//	 USB_UINT16(MTP_ObjectProperty_FamilyName),				//
//	 USB_UINT16(MTP_ObjectProperty_Prefix),					//
//	 USB_UINT16(MTP_ObjectProperty_Suffix),					//
//	 USB_UINT16(MTP_ObjectProperty_PhoneticGivenName),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneticFamilyName),			//
//	 USB_UINT16(MTP_ObjectProperty_EmailPrimary),				//
//	 USB_UINT16(MTP_ObjectProperty_EmailPersonal1),				//
//	 USB_UINT16(MTP_ObjectProperty_EmailPersonal2),				//
//	 USB_UINT16(MTP_ObjectProperty_EmailBusiness1),				//
//	 USB_UINT16(MTP_ObjectProperty_EmailBusiness2),				//
//	 USB_UINT16(MTP_ObjectProperty_EmailOthers),				//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberPrimary),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberPersonal),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberPersonal2),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberBusiness),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberBusiness2),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberMobile),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberMobile2),			//
//	 USB_UINT16(MTP_ObjectProperty_FaxNumberPrimary),			//
//	 USB_UINT16(MTP_ObjectProperty_FaxNumberPersonal),			//
//	 USB_UINT16(MTP_ObjectProperty_FaxNumberBusiness),			//
//	 USB_UINT16(MTP_ObjectProperty_PagerNumber),				//
//	 USB_UINT16(MTP_ObjectProperty_PhoneNumberOthers),			//
//	 USB_UINT16(MTP_ObjectProperty_PrimaryWebAddress),			//
//	 USB_UINT16(MTP_ObjectProperty_PersonalWebAddress),			//
//	 USB_UINT16(MTP_ObjectProperty_BusinessWebAddress),			//
//	 USB_UINT16(MTP_ObjectProperty_InstantMessengerAddress),		//
//	 USB_UINT16(MTP_ObjectProperty_InstantMessengerAddress2),		//
//	 USB_UINT16(MTP_ObjectProperty_InstantMessengerAddress3),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalFull),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalLine1),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalLine2),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalCity),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalRegion),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalPostalCode),	//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressPersonalCountry),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessFull),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessLine1),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessLine2),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessCity),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessRegion),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessPostalCode),	//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressBusinessCountry),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherFull),			//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherLine1),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherLine2),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherCity),			//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherRegion),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherPostalCode),		//
//	 USB_UINT16(MTP_ObjectProperty_PostalAddressOtherCountry),		//
//	 USB_UINT16(MTP_ObjectProperty_OrganizationName),			//
//	 USB_UINT16(MTP_ObjectProperty_PhoneticOrganizationName),		//
//	 USB_UINT16(MTP_ObjectProperty_Role),					//
//	 USB_UINT16(MTP_ObjectProperty_Birthdate),				//
//	 USB_UINT16(MTP_ObjectProperty_MessageTo),				//
//	 USB_UINT16(MTP_ObjectProperty_MessageCC),				//
//	 USB_UINT16(MTP_ObjectProperty_MessageBCC),				//
//	 USB_UINT16(MTP_ObjectProperty_MessageRead),				//
//	 USB_UINT16(MTP_ObjectProperty_MessageReceivedTime),			//
//	 USB_UINT16(MTP_ObjectProperty_MessageSender),				//
//	 USB_UINT16(MTP_ObjectProperty_ActivityBeginTime),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityEndTime),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityLocation),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityRequiredAttendees),		//
//	 USB_UINT16(MTP_ObjectProperty_ActivityOptionalAttendees),		//
//	 USB_UINT16(MTP_ObjectProperty_ActivityResources),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityAccepted),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityTentative),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityDeclined),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityReminderTime),			//
//	 USB_UINT16(MTP_ObjectProperty_ActivityOwner),				//
//	 USB_UINT16(MTP_ObjectProperty_ActivityStatus),				//
//	 USB_UINT16(MTP_ObjectProperty_Owner),					//
//	 USB_UINT16(MTP_ObjectProperty_Editor),					//
//	 USB_UINT16(MTP_ObjectProperty_Webmaster),				//
//	 USB_UINT16(MTP_ObjectProperty_URLSource),				//
//	 USB_UINT16(MTP_ObjectProperty_URLDestination),				//
//	 USB_UINT16(MTP_ObjectProperty_TimeBookmark),				//
//	 USB_UINT16(MTP_ObjectProperty_ObjectBookmark),				//
//	 USB_UINT16(MTP_ObjectProperty_ByteBookmark),				//
//	 USB_UINT16(MTP_ObjectProperty_LastBuildDate),				//
//	 USB_UINT16(MTP_ObjectProperty_TimetoLive),				//
//	 USB_UINT16(MTP_ObjectProperty_MediaGUID),				//
};
/*--------------------------------------------------------------------------*/
/* ObjectPropDesc dataset */
static const uint8_t ObjectPropDescDataset_StorageID[] = {
	USB_UINT16(MTP_ObjectProperty_StorageID),				// 1 PropertyCode	2 UINT16	0xDC01			//vmF:uMedia Transfer Protocol Revision 1.1 April 6th, 2011v(MTPforUSB-IFv1.1.pdf)ł͂̃tB[ȟ^'UINT32'ƂȂĂ邪A'UINT16'̊ԈႢƔf'UINT16'ɂB̃vpeB̐ł͂̃tB[ȟ^'UINT16'ƂȂĂAB.2.1 StorageID̐'UINT32'ƂȂĂsRB5.1.2.1 Device Property Describing Dataset̐ł'UINT16'ƂȂĂA'UINT16'낤B
	USB_UINT16(PTP_DataType_UINT32),					// 2 Datatype		2 UINT16	0x0006 (UINT32)		//vmF:uMedia Transfer Protocol Revision 1.1 April 6th, 2011v(MTPforUSB-IFv1.1.pdf)ł͂̃tB[ȟ^'UINT32'ƂȂĂ邪A'UINT16'̊ԈႢƔf'UINT16'ɂB̃vpeB̐ł͂̃tB[ȟ^'UINT16'ƂȂĂAB.2.1 StorageID̐'UINT32'ƂȂĂsRB5.1.2.1 Device Property Describing Dataset̐ł'UINT16'ƂȂĂA'UINT16'낤B
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT32(0),								// 4 DefaultValue			0x00000000
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_ObjectFormat[] = {
	USB_UINT16(MTP_ObjectProperty_ObjectFormat),				// 1 PropertyCode	2 UINT16	0xDC02
	USB_UINT16(PTP_DataType_UINT16),					// 2 Datatype		2 UINT16	0x0004 (UINT16)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT16(0),								// 4 DefaultValue			0x0000			dluMedia Transfer Protocol Revision 1.1 April 6th, 2011v(MTPforUSB-IFv1.1.pdf)ł0x0000ƂȂĂ܂AAndroid 4.4.2̃X}z0x3000Ԃ悤łBǂɂĂɉe͖悤̂ŁAdlɏ]0x0000ɂ邱Ƃɂ܂B
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_ProtectionStatus[] = {
	USB_UINT16(MTP_ObjectProperty_ProtectionStatus),			// 1 PropertyCode	2 UINT16	0xDC03
	USB_UINT16(PTP_DataType_UINT16),					// 2 Datatype		2 UINT16	0x0004 (UINT16)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT16(0),								// 4 DefaultValue			0x0000
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_EnumerationForm,						// 6 FormFlag		1 UINT8		0x02 Enumeration form
	USB_UINT16(4),								// 7 NumberOfValues	2 UINT16
	 USB_UINT16(PTP_ProtectionStatus_NoProtection),				// 8 SupportedValue1			0x0000 No Protection
	 USB_UINT16(PTP_ProtectionStatus_ReadOnly),				// 9 SupportedValue2			0x0001 Read-only
	 USB_UINT16(MTP_ProtectionStatus_ReadOnlyData),				//10 SupportedValue3			0x8002 Read-only data
	 USB_UINT16(MTP_ProtectionStatus_NonTransferableData),			//11 SupportedValue4			0x8003 Non-transferrable data
};
static const uint8_t ObjectPropDescDataset_ObjectSize[] = {
	USB_UINT16(MTP_ObjectProperty_ObjectSize),				// 1 PropertyCode	2 UINT16	0xDC04
	USB_UINT16(PTP_DataType_UINT64),					// 2 Datatype		2 UINT16	0x0008 (UINT64)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT64(0,0),							// 4 DefaultValue			0x0000000000000000
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_ObjectFileName[] = {
	USB_UINT16(MTP_ObjectProperty_ObjectFileName),				// 1 PropertyCode	2 UINT16	0xDC07
	USB_UINT16(PTP_DataType_STR),						// 2 Datatype		2 UINT16	0xFFFF (STRING)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		Device-defined
	0,									// 4 DefaultValue			0x00 (Null String)
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None 0x05 RegularExpression form
};
static const uint8_t ObjectPropDescDataset_ParentObject[] = {
	USB_UINT16(MTP_ObjectProperty_ParentObject),				// 1 PropertyCode	2 UINT16	0xDC0B
	USB_UINT16(PTP_DataType_UINT32),					// 2 Datatype		2 UINT16	0x0006 (UINT32)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT32(0),								// 4 DefaultValue			0x00000000
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_PersistentUniqueObjectIdentifier[] = {
	USB_UINT16(MTP_ObjectProperty_PersistentUniqueObjectIdentifier),	// 1 PropertyCode	2 UINT16	0xDC41
	USB_UINT16(PTP_DataType_UINT128),					// 2 Datatype		2 UINT16	0x000A (UINT128)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	USB_UINT128(0,0,0,0),							// 4 DefaultValue			0x0c0
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_Name[] = {
	USB_UINT16(MTP_ObjectProperty_Name),					// 1 PropertyCode	2 UINT16	0xDC44
	USB_UINT16(PTP_DataType_STR),						// 2 Datatype		2 UINT16	0xFFFF (STRING)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		Device-defined
	0,									// 4 DefaultValue			0x00 (Null String)
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_None,							// 6 FormFlag		1 UINT8		0x00 None
};
static const uint8_t ObjectPropDescDataset_NonConsumable[] = {
	USB_UINT16(MTP_ObjectProperty_NonConsumable),				// 1 PropertyCode	2 UINT16	0xDC4F
	USB_UINT16(PTP_DataType_UINT8),						// 2 Datatype		2 UINT16	0x0002 (UINT8)
	PTP_GetSet_Get,								// 3 Get/Set		1 UINT8		0x00 (GET)
	0x00,									// 4 DefaultValue			0x00
	USB_UINT32(0),								// 5 GroupCode		4 UINT32	Device-defined
	PTP_FormFlag_EnumerationForm,						// 6 FormFlag		1 UINT8		0x02 Enumeration form
	USB_UINT16(2),								// 7 NumberOfValues	2 UINT16
	 0x00,									// 8 SupportedValue1			A value of 0x00 indicates that the object is intended for consumption,
	 0x01,									// 9 SupportedValue2			and a value of 0x01 indicates that it shall simply be stored.
};
#endif//USE_MTP_OPERATION
/****************************************************************************
 *	
 ****************************************************************************/
void PTP_Start(const char* pProtectedFilenames, int bMTP) {
	/* mɏIĂB */
	PTP_Stop();
	/* veNgt@C̃Xgi[B */
	stPTP.pProtectedFilenames = pProtectedFilenames ? /*GCCg@\*/ : "";
	/* 샂[hi[B */
	stPTP.bMTP = bMTP;
	/* USB̃tbNJnB */
	usb_start(&usb_inf);
}
/*--------------------------------------------------------------------------*/
void PTP_Stop() {
	/* USB̃tbNIB */
	usb_stop();
	/* \̃NAB */
	memset(&stPTP, 0, sizeof stPTP);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	int type  = HIBYTE(req->wValue);
	int index = LOBYTE(req->wValue);
	switch(type) {
	case DEVICE_DESCRIPTOR_TYPE:
		if(!stPTP.bMTP) {
			usb_ep0_tx(&device_desc_PTP, sizeof(DEVICE_DESCRIPTOR));
		} else {
			usb_ep0_tx(&device_desc_MTP, sizeof(DEVICE_DESCRIPTOR));
		}
		return;
	case CONFIGURATION_DESCRIPTOR_TYPE:
		if(index == 0) {
			static uint8_t buf[sizeof(CONFIGURATION_DESCRIPTOR) +	/* config_desc */
					   sizeof(INTERFACE_DESCRIPTOR) +	/* interface_desc */
					   sizeof(ENDPOINT_DESCRIPTOR) * 3];	/* endpoint_desc_ep2in,endpoint_desc_ep2out,endpoint_desc_ep1in */
			uint8_t* ptr =  memcpy(buf, &config_desc,          sizeof(CONFIGURATION_DESCRIPTOR))  + sizeof(CONFIGURATION_DESCRIPTOR);
			         ptr =  memcpy(ptr, &interface_desc,       sizeof(INTERFACE_DESCRIPTOR)    )  + sizeof(INTERFACE_DESCRIPTOR);
			         ptr =  memcpy(ptr, &endpoint_desc_ep2in,  sizeof(ENDPOINT_DESCRIPTOR)     )  + sizeof(ENDPOINT_DESCRIPTOR);
			         ptr =  memcpy(ptr, &endpoint_desc_ep2out, sizeof(ENDPOINT_DESCRIPTOR)     )  + sizeof(ENDPOINT_DESCRIPTOR);
			       /*ptr =*/memcpy(ptr, &endpoint_desc_ep1in,  sizeof(ENDPOINT_DESCRIPTOR)     )/*+ sizeof(ENDPOINT_DESCRIPTOR)*/;
			usb_ep0_tx(buf, sizeof buf);
			return;
		}
		break;
	case STRING_DESCRIPTOR_TYPE:
		if(stPTP.bMTP) {
			if(index == 0xEE) {
				//MS OS String Descriptor
				static const uint8_t MS_OS_String_Descriptor[]={
					0x12,									//bLength		Must be 0x12
					0x03,									//bDescriptorType	Must be 0x03
					0x4D,0x00,0x53,0x00,0x46,0x00,0x54,0x00,0x31,0x00,0x30,0x00,0x30,0x00,	//rgbSignature[14]	must be L"MSFT100"
					0xFE,									//bMSVendorCode		any
					0x00};									//bPad			Must be 0x00
				usb_ep0_tx(MS_OS_String_Descriptor, sizeof MS_OS_String_Descriptor);
				return;
			}
		}
		if(index < ARRAY_SIZE(string_desc)) {
			usb_ep0_tx(string_desc[index], string_desc[index][0]);
			return;
		}
		break;
	}
	usb_ep0_stall(); /* Ή */
}
/*--------------------------------------------------------------------------*/
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	D12_SetEndpointEnable(req->wValue == 1);
	usb_ep0_tx(NULL, 0); /* ACK */
}
/*--------------------------------------------------------------------------*/
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	usb_ep0_tx(NULL, 0); /* ACK */
}
/*--------------------------------------------------------------------------*/
static void class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	switch(req->bRequest) {
	/*--------------------------------------------------------------------------*/
//	case 0x64://Cancel Request
//	case 0x65://Get Extended Event Data
//	case 0x66://Device Reset Request
	/*--------------------------------------------------------------------------*/
	case 0x67://Get Device Status Request
		if((D12_ReadEndpointStatus(EP2OUT) | D12_ReadEndpointStatus(EP2IN)) & D12_ENDPOINTSTALLED) {
			static const uint8_t DeviceStatusData[]={
				USB_UINT16(2+2+4+4),					//wLength	This field specifies the total length of the status data
				USB_UINT16(PTP_ResponseCode_TransactionCancelled),	//Code		The PIMA15740 Response Code or Vendor Code: 0x2001 Status OK 0x2019 Device Busy 0x201F Transaction Cancelled
				USB_UINT32(0x02),	/* EP2OUT */			//Parameter 1	The format and meaning of the parameter depends on the Status Code. For device initiated cancels this parameter contains an endpoint number.	dl(uPHOTOGRAPHIC AND IMAGING MANUFACTURERS ASSOCIATION, INC. PIMA 15740:2000vpima15740-2000.pdf)ɂ͖LĂȂłA
				USB_UINT32(0x82),	/* EP2IN */			//Parameter N	The format and meaning of the parameter depends on the Status Code. For device initiated cancels this parameter contains an endpoint number.	ParameterUINT32złBGh|Cgԍ̔zȂ̂UINT8z񂩂ƎvłAUINT32z񂪐łB(Windows7̋萄)
			};
			usb_ep0_tx(DeviceStatusData, sizeof DeviceStatusData);
		} else {
			static const uint8_t DeviceStatusData[]={
				USB_UINT16(2+2),					//wLength	This field specifies the total length of the status data
				USB_UINT16(PTP_ResponseCode_OK),			//Code		The PIMA15740 Response Code or Vendor Code: 0x2001 Status OK 0x2019 Device Busy 0x201F Transaction Cancelled
			};
			usb_ep0_tx(DeviceStatusData, sizeof DeviceStatusData);
		}
		return;
	/*--------------------------------------------------------------------------*/
	}
	/* The Device may support class-specific requests.
	 * The device shall return STALL if an unrecognized or unsupported device-specific request is received. */
	usb_ep0_stall(); /* Ή */
}
/*--------------------------------------------------------------------------*/
static void vendor_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	if(stPTP.bMTP) {
		if(req->bRequest == 0xFE) {
			//MTP USB Extended Configuration Descriptor
			static const uint8_t MTP_USB_Extended_Configuration_Descriptor[]={
				//MSOS_EXT_CONFIG_DESCRIPTOR_HEADER
				0x28,0x00,0x00,0x00,				//dwLength			Length of the entire Extended Configuration Descriptor
				0x00,0x01,					//bcdVersion			Version info in BCD: 0x0100 ~ 1.00
				0x04,0x00,					//wIndex			must be MSOS_FEATURE_INDEX_EXTENDED_CONFIG_DESC, or 0x0004
				0x01,						//bCount			total number of Function Sections that follow the header section
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,		//bReserved[7]			RESERVED, should be 0x00
				//MSOS_EXT_CONFIG_DESCRIPTOR_FUNCTION
				0x00,						//bFirstInterfaceNumber		Starting Interface Number for this function
				0x01,						//bInterfaceCount		Total number of interfaces 
				0x4D,0x54,0x50,0x00,0x00,0x00,0x00,0x00,	//compatibleID[8]		Compatible ID as defined by Microsoft
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//subCompatibleID[8]		The Sub Compatible ID as defined by Microsoft
				0x00,0x00,0x00,0x00,0x00,0x00};			//bReserved[6]			RESERVED, should be 0x00
			usb_ep0_tx(MTP_USB_Extended_Configuration_Descriptor, sizeof MTP_USB_Extended_Configuration_Descriptor);
			return;
		}
	}
	usb_ep0_stall(); /* Ή */
}
/*--------------------------------------------------------------------------*/
static void ep2_rxdone() {
	union { uint8_t buf[EP2_NONISO_PACKET_SIZE]; PTP_GenericContainerStructure Container; } u;
	int len;
	for(;;) {
		/* Mf[^ǂݏoBMf[^΋ABMf[^ǂݏoAǂݏoMf[^NAB
		 * - D12_ReadBuffer()(-1)ꍇ́AD12_ClearBuffer()Ăł͂ȂB
		 *   D12_ReadBuffer()`D12_ClearBuffer()̊ԂɐVf[^ꍇAǂݏoOɃNAoOɂȂB */
		memset(&u, 0, sizeof u);
		if((len = D12_ReadBuffer(EP2OUT, &u, sizeof u)) == -1) { return; } /* ܂ */
		         D12_ClearBuffer(EP2OUT);
		/* R}htF[YȂ΁c */
		if(stPTP.Phase == PTP_Phase_Command) {
			/* ȉ̌ɕsiȂ΁AG[ƌȂăXg[B
			 * - R}htF[Y̎Mf[^́AyC[hTCY(64Byte)ł͂B
			 *   (Reiwb_(12Byte)+p[^~0`5(0`20Byte)=12`32Byte64Byte) */
			if((len == EP2_NONISO_PACKET_SIZE) ||					//yC[hTCYłȂ
			   (u.Container.ContainerLength != len) ||				//ReiƈvĂȂ
			   (u.Container.ContainerType != PTP_ContainerType_CommandBlock)) {	//R}hubNłȂ
				break; } /* stall */
			/* Iy[VNGXgf[^Zbg\zB */
			memset(&stPTP.OperationRequestDataset, 0, sizeof stPTP.OperationRequestDataset);
			stPTP.OperationRequestDataset.OperationCode = u.Container.Code;
			stPTP.TransactionID                         = u.Container.TransactionID;
			if((len -= offsetof(PTP_GenericContainerStructure, Payload)) < 0) { len = 0; }
			if(len > sizeof stPTP.OperationRequestDataset.Parameter) { len = sizeof stPTP.OperationRequestDataset.Parameter; }
			memcpy(stPTP.OperationRequestDataset.Parameter, u.Container.Payload, len);
			/* R}hBG[Ȃ΁AXg[B */
			if(process_command()) { break; } /* stall */
			/* f[^CtF[Y,,X|XtF[YJnBf[^AEgtF[YȂ΁Aep2_txsub()B */
			if(ep2_txsub()) { break; } /* stall */
		/* f[^AEgtF[YȂ΁c */
		} else if(stPTP.Phase == PTP_Phase_DataOut) {
			/* Ō̃pPbgł邩𔻒肵ĂB
			 * - f[^AEgtF[Y̎Mf[^́AyC[hTCỸpPbgŏI[B
			 *   Reiłfł邪AIɃyC[hTCỸpPbgŏI[̂APTP̎dlłB
			 *   The Data phase ends when the number of bytes transferred equals the number of bytes specified in the first four bytes of the Data Block that coincide with a short or a NULL packet.
			 *   A short packet or a NULL packet indicates the end of the end of a Data phase.
			 *   If the number of bytes specified in the first four bytes of the Data Block are an integral multiple of the wMaxPacketSize field of the Endpoint Descriptor the Data phase will end in a NULL packet. */
			int end = (len != EP2_NONISO_PACKET_SIZE);
			/* ŏ̃pPbgȂ΁c */
			if(!stPTP.DataPos) {
				/* f[^ubNłȂ΁AG[ƌȂăXg[B */
				if(u.Container.ContainerType != PTP_ContainerType_DataBlock) { break; } /* stall */
				/* f[^擾Bf[^0Ȃ΁AG[ƌȂăXg[B */
				stPTP.DataLen = u.Container.ContainerLength - offsetof(PTP_GenericContainerStructure, Payload);
				if(stPTP.DataLen < 0) { break; } /* stall */
				/* MTCYAReiwb_̃TCYB */
				if((len -= offsetof(PTP_GenericContainerStructure, Payload)) < 0) { len = 0; }
				/* f[^obt@̐擪ւ炷B */
				memmove(&u, u.Container.Payload, len);
			}
			/* Ō̃pPbgMf[^sv,,f[^ʒuf[^𒴉߂AG[ƌȂB */
			if((end && ((stPTP.DataPos + len) != stPTP.DataLen)) ||
			           ((stPTP.DataPos + len) >  stPTP.DataLen)) { break; } /* stall */
			/* f[^B */
			if(len && process_dataout(u.buf, len)) { break; } /* stall */
			/* f[^ʒuZB */
			stPTP.DataPos += len;
			/* Ō̃pPbgȂ΁c */
			if(end) {
				/* X|XtF[YֈڍsB */
				stPTP.Phase = PTP_Phase_Response;
				/* X|XtF[YJnB */
				if(ep2_txsub()) { break; } /* stall */
			}
		/* ȊÕtF[YȂ΁c */
		} else {
			/* ȊÕtF[Ył͎MȂ͂łBMꍇ́AG[ƌȂăXg[B */
			break; /* stall */
		}
		/* MpB
		 * _uobt@̂ʂɎMf[^cĂ邩,,̏ɐVf[^\L邩B */
	}
	/* STALL Bulk-in & Bulk-out Endpoints */
	D12_SetEndpointStatus(EP2OUT, 1);
	D12_SetEndpointStatus(EP2IN , 1);
	/* R}htF[Y֖߂B */
	stPTP.Phase = PTP_Phase_Command;
}
/*--------------------------------------------------------------------------*/
static void ep2_txdone() {
	if(ep2_txsub()) {
		/* STALL Bulk-in & Bulk-out Endpoints */
		D12_SetEndpointStatus(EP2OUT, 1);
		D12_SetEndpointStatus(EP2IN , 1);
		/* R}htF[Y֖߂B */
		stPTP.Phase = PTP_Phase_Command;
	}
}
/*--------------------------------------------------------------------------*/
static int ep2_txsub() {
	union { uint8_t buf[EP2_NONISO_PACKET_SIZE]; PTP_GenericContainerStructure Container; } u;
	int len;
	for(;;) {
		/* f[^CtF[YȂ΁c */
		if(stPTP.Phase == PTP_Phase_DataIn) {
			int end;
			/* ŏ̃pPbgȂ΁c */
			if(!stPTP.DataPos) {
				/* Rei\zB */
				memset(&u, 0, sizeof u);
				u.Container.ContainerLength = offsetof(PTP_GenericContainerStructure, Payload) + stPTP.DataLen;
				u.Container.ContainerType   = PTP_ContainerType_DataBlock;
				u.Container.Code            = stPTP.OperationRequestDataset.OperationCode;	//The Data Block will use the OperationCode from the Command Block
				u.Container.TransactionID   = stPTP.TransactionID;
				/* ŏ̃pPbgɓ镪́Af[^擾B */
				len = (stPTP.DataLen - stPTP.DataPos);
				if(len > (EP2_NONISO_PACKET_SIZE - offsetof(PTP_GenericContainerStructure, Payload))) {
				   len = (EP2_NONISO_PACKET_SIZE - offsetof(PTP_GenericContainerStructure, Payload)); }
				if(len && process_datain(u.Container.Payload, len)) { return -1; }
			/* ŏ̃pPbgłȂ΁c */
			} else {
				/* f[^擾B */
				len = (stPTP.DataLen - stPTP.DataPos);
				if(len > EP2_NONISO_PACKET_SIZE) { len = EP2_NONISO_PACKET_SIZE; }
				if(len && process_datain(u.buf, len)) { return -1; }
			}
			/* ŏ̃pPbgȂ΁AReiwb_̃TCYZAMTCYƂB */
			if(!stPTP.DataPos) { len += offsetof(PTP_GenericContainerStructure, Payload); }
			/* pPbgށBpPbg񂾂ApPbgoJnB
			 * - pPbg߂Ȃ΁ApPbg𑗏oɁA(0)ԂB
			 *   ̌őMobt@󂢂Aep2_txdone()͂łB
			 *   ep2_txdone()AēxAsB */
			if((len = D12_WriteBuffer(EP2IN, &u, len)) == -1) { return 0; }
			       D12_ValidateBuffer(EP2IN);
			/* Ō̃pPbgł邩𔻒肵ĂB
			 * - f[^CtF[Y̑Mf[^́AyC[hTCỸpPbgŏI[B
			 *   Reiłfł邪AIɃyC[hTCỸpPbgŏI[̂APTP̎dlłB
			 *   The Data phase ends when the number of bytes transferred equals the number of bytes specified in the first four bytes of the Data Block that coincide with a short or a NULL packet.
			 *   A short packet or a NULL packet indicates the end of the end of a Data phase.
			 *   If the number of bytes specified in the first four bytes of the Data Block are an integral multiple of the wMaxPacketSize field of the Endpoint Descriptor the Data phase will end in a NULL packet. */
			end = (len != EP2_NONISO_PACKET_SIZE);
			/* ŏ̃pPbgȂ΁AMTCYAReiwb_̃TCYB */
			if(!stPTP.DataPos) { if((len -= offsetof(PTP_GenericContainerStructure, Payload)) < 0) { len = 0; } }
			/* f[^ʒuZB */
			stPTP.DataPos += len;
			/* Ō̃pPbgȂ΁AX|XtF[YֈڍsB */
			if(end) { stPTP.Phase = PTP_Phase_Response; }
		/* X|XtF[YȂ΁c */
		} else if(stPTP.Phase == PTP_Phase_Response) {
			/* Rei\zB
			 * - X|XtF[Y̑Mf[^́AyC[hTCY(64Byte)łB
			 *   (Reiwb_(12Byte)+p[^~5(20Byte)=32Byte64Byte) */
			memset(&u, 0, sizeof u);
			u.Container.ContainerLength = offsetof(PTP_GenericContainerStructure, Payload) + sizeof stPTP.ResponseDataset.Parameter;
			u.Container.ContainerType   = PTP_ContainerType_ResponseBlock;
			u.Container.Code            = stPTP.ResponseDataset.ResponseCode;
			u.Container.TransactionID   = stPTP.TransactionID;
			memcpy(u.Container.Payload, stPTP.ResponseDataset.Parameter, sizeof stPTP.ResponseDataset.Parameter);
			/* pPbgށBpPbg񂾂ApPbgoJnB
			 * - pPbg߂Ȃ΁ApPbg𑗏oɁA(0)ԂB
			 *   ̌őMobt@󂢂Aep2_txdone()͂łB
			 *   ep2_txdone()AēxAsB */
			if((len = D12_WriteBuffer(EP2IN, &u, u.Container.ContainerLength)) == -1) { return 0; }
			       D12_ValidateBuffer(EP2IN);
			/* R}htF[Y֖߂B */
			stPTP.Phase = PTP_Phase_Command;
		/* ȊÕtF[YȂ΁c */
		} else {
			/* ȊÕtF[Ył͑MȂBMɁA(0)ԂB */
			return 0;
		}
		/* MpB
		 * _uobt@̂ʂ󂢂Ă邩,,̏Ƀf[^oobt@󂢂\L邩B */
	}
}
/*--------------------------------------------------------------------------*/
static void put_string(void* _dst, const char* src) {
	char* len = _dst;	//NumChars
	char* dst = _dst + 1;	//StringChars
	*len = 0;
	if(*src) {		//(NumChars=0)̏ꍇAI[̃ki[ȂB
		int c;
		do {
			*dst++ = c = *src++;
			*dst++ = 0;
			(*len)++;
		} while(c);
	}
}
/*--------------------------------------------------------------------------*/
static void get_string(char* dst, const void* _src) {
	const uint8_t* src = _src;
	int len = *src++;	//NumChars
	while(len--) {
		*dst++ = *src;
		          src += 2;
	}
	*dst = 0;		//(NumChars=0)̏ꍇAI[̃ktB
}
/*--------------------------------------------------------------------------*/
static int is_protected_filename(const char* name) {
	const char* ptr = stPTP.pProtectedFilenames;
	/* veNgt@C̃Xg̏I[ɒB܂Łc */
	while(*ptr) {
		/* veNgt@CɈvA1ԂB */
		if(!strcasecmp(ptr, name)) { return 1; }
		/* veNgt@CA֐i߂B */
		ptr += (strlen(ptr) + 1);
	}
	/* veNgt@CɈvȂ΁A0ԂB */
	return 0;
}
/*--------------------------------------------------------------------------*/
static int process_command() {
	int i;
	/* R}htF[Y̎ɍsׂtF[Y擾B */
	for(i = 0; i < ARRAY_SIZE(TBL_DataDirection); i++) { if(TBL_DataDirection[i][0/*OperationCode*/] == stPTP.OperationRequestDataset.OperationCode) { break; } }
	if((unsigned)i >= ARRAY_SIZE(TBL_DataDirection)) { return -1; }
	stPTP.Phase = TBL_DataDirection[i][1/*Phase*/];
	/* ȍ~̃R[hʂ팸邽߂ɁAʓIȒlݒ肵ĂB */
	memset(&stPTP.ResponseDataset, 0, sizeof stPTP.ResponseDataset);
	stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_OK;
	stPTP.DataLen = stPTP.DataPos = 0, stPTP.DataPtr = NULL;
	/* Iy[VR[hɂāc */
	switch(stPTP.OperationRequestDataset.OperationCode) {
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetDeviceInfo:
		stPTP.DataLen = sizeof DeviceInfoDataset;
		stPTP.DataPtr = (void*)DeviceInfoDataset;
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_OpenSession:
		stPTP.SessionID = stPTP.OperationRequestDataset.Parameter[0];
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_CloseSession:
		stPTP.SessionID = 0;
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetStorageIDs:
		stPTP.DataLen = sizeof StorageIDArray;
		stPTP.DataPtr = (void*)StorageIDArray;
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetStorageInfo:
		{
			/* t@CVXe̓v擾B */
			struct statvfs st;
			if(statvfs("/", &st)) { return -1; }
			/* Xg[Wf[^ZbgRs[AMaxCapacity,FreeSpaceInBytesi[B */
			// 1 StorageType		+ 0,2 UINT16
			// 2 FilesystemType		+ 2,2 UINT16
			// 3 AccessCapability		+ 4,2 UINT16
			// 4 MaxCapacity		+ 6,8 UINT64
			// 5 FreeSpaceInBytes		+14,8 UINT64
			// 6 FreeSpaceInImages		+22,4 UINT32
			// 7 StorageDescription		+26,? String
			// 8 VolumeLabel		+ ?,? String
			memcpy(stPTP.WorkBuf, StorageInfoDataset, sizeof StorageInfoDataset);
			PUT_LEWORD(stPTP.WorkBuf +  6, st.f_frsize * st.f_blocks);	//MaxCapacity
			PUT_LEWORD(stPTP.WorkBuf + 10, 0);				//
			PUT_LEWORD(stPTP.WorkBuf + 14, st.f_frsize * st.f_bfree);	//FreeSpaceInBytes
			PUT_LEWORD(stPTP.WorkBuf + 18, 0);				//
			/* Xg[Wf[^ZbgAf[^CtF[Y̑Mf[^ƂB */
			stPTP.DataLen = sizeof StorageInfoDataset;
			stPTP.DataPtr = stPTP.WorkBuf;
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetNumObjects:
	case PTP_OperationCode_GetObjectHandles:
		{
			/* IuWFNgnhz쐬B
			 * readdir()g킸ɁAfBNgGg𒼐ڑBIuWFNgnh𓾂邽߂łB */
			const pffsMASTERBLOCK* msb = (pffsMASTERBLOCK*)pceSystemGetInfo()->pffs_top;
			const DIRECTORY *pdir = msb->dir, *pdir_end = msb->dir + MAXDIR;
			uint32_t* ObjectHandleArray = (uint32_t*)stPTP.WorkBuf;
			ObjectHandleArray[0/*NumElements*/] = 0;
			do {
				/* gp̃fBNgGgȂ΁c(\usr\PIECE\sysdev\pcekn\file.c Search() Q) */
				if((pdir->name[0] == 0) || (pdir->name[0] == -1)) { continue; }	//
				/* z̗vf𑝂₵AIuWFNgnhi[B
				 * fBNgGgւ̃|C^AIuWFNgnhƂĊi[邱ƂɂB */
				ObjectHandleArray[++ObjectHandleArray[0/*NumElements*/]] = (uint32_t)pdir;
			} while(++pdir < pdir_end);
			switch(stPTP.OperationRequestDataset.OperationCode) {
			/*--------------------------------------------------------------------------*/
			case PTP_OperationCode_GetNumObjects:
				/* IuWFNgAX|X̃p[^Ɋi[B */
				stPTP.ResponseDataset.Parameter[0] = ObjectHandleArray[0/*NumElements*/];
				break;
			/*--------------------------------------------------------------------------*/
			case PTP_OperationCode_GetObjectHandles:
				/* IuWFNgnhzAf[^CtF[Y̑Mf[^ƂB */
				stPTP.DataLen = sizeof(uint32_t) * (1 + ObjectHandleArray[0/*NumElements*/]);
				stPTP.DataPtr = ObjectHandleArray;
				break;
			/*--------------------------------------------------------------------------*/
			default: DIE();
			}
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetObjectInfo:
		{
			const DIRECTORY* pdir = (DIRECTORY*)stPTP.OperationRequestDataset.Parameter[0];
			struct stat st;
			if(stat(pdir->name, &st)) {	//IuWFNgnhs
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
				return 0;
			}
			/* IuWFNgf[^Zbg\zB */
			// 1 StorageID			+ 0,4 StorageID
			// 2 ObjectFormat		+ 4,2 ObjectFormatCode		WindowsXpŎƂA@VendorDefined*ȊO*ɂƁAGNXv[ɊgqςĂ܂BAVendorDefinedɂƁAGNXv[Ń_uNbNăvr[悤ƂƃGNXv[sIB@̕AdȂ̂ŁAVendorDefinedɂ邱ƂɂB
			// 3 ProtectionStatus		+ 6,2 UINT16			Windows7łƂA@̖͔ȂBA_uNbNɂǂ̃r[AN邩ɂ͉e悤BA̖ȂB_ƂẮAWindows7łAVendorDefinedɂĖȂB
			// 4 ObjectCompressedSize	+ 8,4 UINT32			WindowsXpŁAʂ̖肪BgqقȂ̃t@CLƁAWindowsXp̃GNXv[ł́AЕ̃t@C\Ă܂BWindowsXṕAgqt@CObjectFormat̑gŁAĂ̂ł͂ȂƎvB@B
			// 5 ThumbFormat		+12,2 ObjectFormatCode		@@ɈƂɁAWindowsXp̃GNXv[oRŁÃt@C𗼕폜悤ƂƁAP/ECEnOAbvBǂ̂悤ȃNGXgŁAP/ECEnOAbvĂ̂A܂𒲍łĂȂB
			// 6 ThumbCompressedSize	+14,4 UINT32			2014/09/14ǋL:Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂łBIuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
			// 7 ThumbPixWidth		+18,4 UINT32
			// 8 ThumbPixHeight		+22,4 UINT32
			// 9 ImagePixWidth		+26,4 UINT32
			//10 ImagePixHeight		+30,4 UINT32
			//11 ImageBitDepth		+34,4 UINT32
			//12 ParentObject		+38,4 ObjectHandle
			//13 AssociationType		+42,2 AssociationCode
			//14 AssociationDesc		+44,4 AssociationDesc
			//15 SequenceNumber		+48,4 UINT32
			//16 Filename			+52,? String		1+((8+1+3)+1)*2=27Byte(Max)
			//17 CaptureDate		+ ?,? DateTime String	1
			//18 ModificationDate		+ ?,? DateTime String	1
			//19 Keywords			+ ?,? String		1
			memset(stPTP.WorkBuf, 0, sizeof stPTP.WorkBuf);
			PUT_LEWORD(stPTP.WorkBuf +  0, StorageID);				//StorageID
		    //{{2014/09/14ύX:Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂̂悤łBIuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
		    //	PUT_LEHALF(stPTP.WorkBuf +  4, PTP_ObjectFormat_VendorDefined);		//ObjectFormat		LRgQ
		    //2014/09/14ύX:Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂̂悤łBIuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
			PUT_LEHALF(stPTP.WorkBuf +  4, PTP_ObjectFormat_Undefined);		//ObjectFormat		LRgQ
		    //}}2014/09/14ύX:Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂̂悤łBIuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
		//sv	PUT_LEHALF(stPTP.WorkBuf +  6, PTP_ProtectionStatus_NoProtection);	//ProtectionStatus	(PTP_ProtectionStatus_NoProtection=0)Ȃ̂ŕsv
			PUT_LEWORD(stPTP.WorkBuf +  8, st.st_size);				//ObjectCompressedSize
			put_string(stPTP.WorkBuf + 52, pdir->name);				//Filename
			if(is_protected_filename(pdir->name)) {//veNgt@C?
				PUT_LEHALF(stPTP.WorkBuf +  6, PTP_ProtectionStatus_ReadOnly);	//ProtectionStatus
			}
			/* IuWFNgf[^ZbgAf[^CtF[Y̑Mf[^ƂB */
			stPTP.DataLen = 52 + (1 + stPTP.WorkBuf[52] * 2) + 3;
			stPTP.DataPtr = stPTP.WorkBuf;
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetObject:
		{
			const DIRECTORY* pdir = (DIRECTORY*)stPTP.OperationRequestDataset.Parameter[0];
			struct stat st;
			if(stat(pdir->name, &st)) {	//IuWFNgnhs
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
				return 0;
			}
			/* f[^CtF[ÝAMf[^ݒ肷B */
			stPTP.DataLen = st.st_size;
		}
		return 0;
	/*--------------------------------------------------------------------------*/
//	case PTP_OperationCode_GetThumb:
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_DeleteObject:
		{
			int retval;
			const DIRECTORY* pdir = (DIRECTORY*)stPTP.OperationRequestDataset.Parameter[0];
			if(is_protected_filename(pdir->name)) {//veNgt@C?
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_ObjectWriteProtected;
				return 0;
			}
			/* t@C폜B */
		    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
		    //	memcpy(stPTP.save_FRAM4, FRAM4_START, FRAM4_SIZE);	//FRAM4ޔ
		    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
			retval = pceFileDelete(pdir->name);			//FRAM4j󂳂
		    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
		    //	memcpy(FRAM4_START, stPTP.save_FRAM4, FRAM4_SIZE);	//FRAM4𕜌
		    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
			if(retval) {	//IuWFNgnhs
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
				return 0;
			}
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_SendObjectInfo:
	case PTP_OperationCode_SendObject:
		/** no job **/
		return 0;
	/*--------------------------------------------------------------------------*/
//	case PTP_OperationCode_InitiateCapture:
//	case PTP_OperationCode_FormatStore:
//	case PTP_OperationCode_ResetDevice:
//	case PTP_OperationCode_SelfTest:
//	case PTP_OperationCode_SetObjectProtection:
//	case PTP_OperationCode_PowerDown:
//	case PTP_OperationCode_GetDevicePropDesc:
//	case PTP_OperationCode_GetDevicePropValue:
//	case PTP_OperationCode_SetDevicePropValue:
//	case PTP_OperationCode_ResetDevicePropValue:
//	case PTP_OperationCode_TerminateOpenCapture:
//	case PTP_OperationCode_MoveObject:
//	case PTP_OperationCode_CopyObject:
//	case PTP_OperationCode_GetPartialObject:
//	case PTP_OperationCode_InitiateOpenCapture:
	/*--------------------------------------------------------------------------*/
#ifdef  USE_MTP_OPERATION
	case MTP_OperationCode_GetObjectPropsSupported:
		stPTP.DataLen = sizeof ObjectPropCodeArray;
		stPTP.DataPtr = (void*)ObjectPropCodeArray;
		return 0;
	/*--------------------------------------------------------------------------*/
	case MTP_OperationCode_GetObjectPropDesc:
		{
			switch(stPTP.OperationRequestDataset.Parameter[0]) {
			case MTP_ObjectProperty_StorageID:
				stPTP.DataLen = sizeof ObjectPropDescDataset_StorageID;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_StorageID;
				break;
			case MTP_ObjectProperty_ObjectFormat:
				stPTP.DataLen = sizeof ObjectPropDescDataset_ObjectFormat;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_ObjectFormat;
				break;
			case MTP_ObjectProperty_ProtectionStatus:
				stPTP.DataLen = sizeof ObjectPropDescDataset_ProtectionStatus;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_ProtectionStatus;
				break;
			case MTP_ObjectProperty_ObjectSize:
				stPTP.DataLen = sizeof ObjectPropDescDataset_ObjectSize;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_ObjectSize;
				break;
			case MTP_ObjectProperty_ObjectFileName:
				stPTP.DataLen = sizeof ObjectPropDescDataset_ObjectFileName;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_ObjectFileName;
				break;
			case MTP_ObjectProperty_ParentObject:
				stPTP.DataLen = sizeof ObjectPropDescDataset_ParentObject;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_ParentObject;
				break;
			case MTP_ObjectProperty_PersistentUniqueObjectIdentifier:
				stPTP.DataLen = sizeof ObjectPropDescDataset_PersistentUniqueObjectIdentifier;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_PersistentUniqueObjectIdentifier;
				break;
			case MTP_ObjectProperty_Name:
				stPTP.DataLen = sizeof ObjectPropDescDataset_Name;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_Name;
				break;
			case MTP_ObjectProperty_NonConsumable:
				stPTP.DataLen = sizeof ObjectPropDescDataset_NonConsumable;
				stPTP.DataPtr = (void*)ObjectPropDescDataset_NonConsumable;
				break;
			default:	//IuWFNgvpeBR[hs
				stPTP.ResponseDataset.ResponseCode = MTP_ResponseCode_InvalidObjectPropCode;
				return 0;
			}
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case MTP_OperationCode_GetObjectPropValue:
		{
			const DIRECTORY* pdir = (DIRECTORY*)stPTP.OperationRequestDataset.Parameter[0];
			struct stat st;
			if(stat(pdir->name, &st)) {	//IuWFNgnhs
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
				return 0;
			}
			/* ȍ~̏ŁAUINT64,UINT12832rbgȏ̊i[ȗł悤A炩߃obt@ŜNAĂB */
			memset(stPTP.WorkBuf, 0, sizeof stPTP.WorkBuf);
			switch(stPTP.OperationRequestDataset.Parameter[1]) {
			case MTP_ObjectProperty_StorageID:
				PUT_LEWORD(stPTP.WorkBuf, StorageID);
				stPTP.DataLen = sizeof(uint32_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_ObjectFormat:
				PUT_LEHALF(stPTP.WorkBuf, PTP_ObjectFormat_Undefined);
				stPTP.DataLen = sizeof(uint16_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_ProtectionStatus:
			//sv	PUT_LEHALF(stPTP.WorkBuf, PTP_ProtectionStatus_NoProtection);	//(PTP_ProtectionStatus_NoProtection=0)Ȃ̂ŕsv
				if(is_protected_filename(pdir->name)) {//veNgt@C?
					PUT_LEHALF(stPTP.WorkBuf, PTP_ProtectionStatus_ReadOnly);
				}
				stPTP.DataLen = sizeof(uint16_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_ObjectSize:
				PUT_LEWORD(stPTP.WorkBuf + 0, st.st_size);	//UINT64
			//sv	PUT_LEWORD(stPTP.WorkBuf + 4, 0);		//
				stPTP.DataLen = sizeof(uint64_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_ObjectFileName:
			case MTP_ObjectProperty_Name:
				put_string(stPTP.WorkBuf, pdir->name);
				stPTP.DataLen = 1 + stPTP.WorkBuf[0] * 2;
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_ParentObject:
				//B.2.11 Parent Object
				//If this object exists in a hierarchy, this property will contain the object handle of the parent of this object.
				//Only objects of type Association may be identified in this field.
				//If this object is in the root or the device does not support associations, this field shall be set to 0x00000000.
				//Devices cannot be moved by updating this property.
				//They must be moved using the MoveObject operation.
				//The value of this property must be identical to the value of field 12 of the ObjectInfo dataset.
			//sv	PUT_LEWORD(stPTP.WorkBuf, 0x00000000);
				stPTP.DataLen = sizeof(uint32_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_PersistentUniqueObjectIdentifier:
				PUT_LEWORD(stPTP.WorkBuf +  0, (int)pdir);	//UINT128
			//sv	PUT_LEWORD(stPTP.WorkBuf +  4, 0);		//
			//sv	PUT_LEWORD(stPTP.WorkBuf +  8, 0);		//
			//sv	PUT_LEWORD(stPTP.WorkBuf + 12, 0);		//
				stPTP.DataLen = 16/*sizeof(uint128_t)*/;
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			case MTP_ObjectProperty_NonConsumable:
				//B.2.29 Non-Consumable
				//This property determines whether or not this object is intended to be consumed by the device, or whether it has been placed on the device just for storage.
				//If this property is not present, all data is assumed to be intended for consumption.
				//If this property is supported, it must be supported for all objects on the device.
				//The allowed values for this property are identified in the FORM fields of the Object Property Description dataset, and must contain the values 0x00 and 0x01.
				//A value of 0x00 indicates that the object is intended for consumption, and a value of 0x01 indicates that it shall simply be stored.
				//If a vendor-specific extension is defined which extends the allowed values of this property, it shall use only values with a most significant bit of 1.
				PUT_LEHALF(stPTP.WorkBuf, 0x01);	//a value of 0x01 indicates that it shall simply be stored.
				stPTP.DataLen = sizeof(uint8_t);
				stPTP.DataPtr = stPTP.WorkBuf;
				break;
			default:	//IuWFNgvpeBR[hs
				stPTP.ResponseDataset.ResponseCode = MTP_ResponseCode_InvalidObjectPropCode;
				return 0;
			}
		}
		return 0;
	/*--------------------------------------------------------------------------*/
//	case MTP_OperationCode_GetObjectPropList:
//	case MTP_OperationCode_GetInterdependentPropDesc:
//	case MTP_OperationCode_GetObjectReferences:
#endif//USE_MTP_OPERATION
	/*--------------------------------------------------------------------------*/
	}
	/* ΁AG[ƂB */
	return -1;
}
/*--------------------------------------------------------------------------*/
static int process_dataout(const void* buf, int len) {
	/* f[^|C^ݒ肳ĂAf[^i[B */
	if(stPTP.DataPtr) { memcpy(stPTP.DataPtr + stPTP.DataPos, buf, len); }
	/* Iy[VR[hɂāc */
	switch(stPTP.OperationRequestDataset.OperationCode) {
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_SendObjectInfo:
		/* ŏ̃pPbgȂ΁c */
		if(!stPTP.DataPos) {
			/* IuWFNgf[^ZbgA[Nobt@Ɋi[ł邱ƂmFB */
			if(stPTP.DataLen > sizeof stPTP.WorkBuf) { return -1; }	//s
			stPTP.DataPtr = stPTP.WorkBuf;
			/* ŏ̃pPbgi[B񂩂́A֐̐擪̋ʏŊi[B */
			memcpy(stPTP.DataPtr + stPTP.DataPos, buf, len);
		}
		/* Ō̃pPbgȂ΁c */
		if(stPTP.DataPos + len == stPTP.DataLen) {
			char name[(8+1+3)+1];
			{
				int retval;
				// 1 StorageID			+ 0,4 StorageID
				// 2 ObjectFormat		+ 4,2 ObjectFormatCode
				// 3 ProtectionStatus		+ 6,2 UINT16
				// 4 ObjectCompressedSize	+ 8,4 UINT32
				// 5 ThumbFormat		+12,2 ObjectFormatCode
				// 6 ThumbCompressedSize	+14,4 UINT32
				// 7 ThumbPixWidth		+18,4 UINT32
				// 8 ThumbPixHeight		+22,4 UINT32
				// 9 ImagePixWidth		+26,4 UINT32
				//10 ImagePixHeight		+30,4 UINT32
				//11 ImageBitDepth		+34,4 UINT32
				//12 ParentObject		+38,4 ObjectHandle
				//13 AssociationType		+42,2 AssociationCode
				//14 AssociationDesc		+44,4 AssociationDesc
				//15 SequenceNumber		+48,4 UINT32
				//16 Filename			+52,? String
				//17 CaptureDate		+ ?,? DateTime String
				//18 ModificationDate		+ ?,? DateTime String
				//19 Keywords			+ ?,? String
				uint32_t size = LEWORD(stPTP.WorkBuf +  8);	//ObjectCompressedSize
				uint8_t* pstr =        stPTP.WorkBuf + 52 ;	//Filename
				if(pstr[0]/*I[k*/ > sizeof name) {	//t@Cs
					stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_GeneralError;
					return 0;
				}
				get_string(name, pstr);
				strlwr(name);//P/ECE͏t@CgȂ̂ŁAIɏ邱ƂɂBK{ł͂ȂAȂƁA啶̃t@C]悤ƂɃG[ɂȂʓ|ł邩B
				if(is_protected_filename(name)) {//veNgt@C?
					stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_ObjectWriteProtected;
					return 0;
				}
				/* t@C쐬B */
			    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
			    //	memcpy(stPTP.save_FRAM4, FRAM4_START, FRAM4_SIZE);	//FRAM4ޔ
			    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
				retval = pceFileCreate(name, size);			//FRAM4j󂳂
			    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
			    //	memcpy(FRAM4_START, stPTP.save_FRAM4, FRAM4_SIZE);	//FRAM4𕜌
			    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
				if(retval) {	//t@C쐬s
					stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_StoreFull;
					return 0;
				}
			}
			{
				const pffsMASTERBLOCK* msb = (pffsMASTERBLOCK*)pceSystemGetInfo()->pffs_top;
				const DIRECTORY *pdir = msb->dir, *pdir_end = msb->dir + MAXDIR;
				do {
				//	/* gp̃fBNgGgȂ΁c(\usr\PIECE\sysdev\pcekn\file.c Search() Q) */	//t@C̔r
				//	if((pdir->name[0] == 0) || (pdir->name[0] == -1)) { continue; }	//				//fł̂ŕsv
					/* ܍쐬t@CɈvc */
					if(!strcmp(pdir->name, name)) {
						/* fBNgGgւ̃|C^IuWFNgnhƂāAX|X̃p[^Ɋi[B */
						stPTP.ObjectHandle = (int)pdir;	//SendObjectInfoSendObjectւ̈np
						stPTP.ResponseDataset.Parameter[0] = StorageID;			//Responder StorageID in which the object will be stored
					//	stPTP.ResponseDataset.Parameter[1] = -1;			//Responder Parent ObjectHandle in which the object will be stored
						stPTP.ResponseDataset.Parameter[2] = stPTP.ObjectHandle;	//Responderfs reserved ObjectHandle for the incoming object
						return 0;
					}
				} while(++pdir < pdir_end);
				/* ܍쐬t@C̃fBNgGgȂ(?)Bۂɂ͋N蓾Ȃ͂B */
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_GeneralError;
			}
		}
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_SendObject:
		{
			int sct = stPTP.DataPos / BLOCKSIZE;			//݂̃f[^ʒuɑΉZN^ԍ
			int pos = stPTP.DataPos % BLOCKSIZE;			//[Nobt@݈̏ʒu
			do {
				int cnt = BLOCKSIZE - pos;			//[Nobt@ɏރoCg߂
				if(cnt > len) { cnt = len; }			//
				memcpy(&stPTP.WorkBuf[pos], buf, cnt);		//[Nobt@ɏ
				if(((          pos + cnt) ==     BLOCKSIZE) ||	//[Nobt@tɂȂ,,
				   ((stPTP.DataPos + len) == stPTP.DataLen)) {	//Ō̃pPbgMc
					const DIRECTORY* pdir = (DIRECTORY*)stPTP.ObjectHandle;	//SendObjectInfoSendObjectւ̈np
					FILEACC fa;
					if(pceFileOpen(&fa, pdir->name, FOMD_WR)) {	//IuWFNgnhs
						stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
						return 0;
					}
					/* [Nobt@ZN^֏ */
				    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
				    //	memcpy(stPTP.save_FRAM4, FRAM4_START, FRAM4_SIZE);	//FRAM4ޔ
				    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
					pceFileWriteSct(&fa, stPTP.WorkBuf, sct, pos + cnt);	//FRAM4j󂳂
				    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
				    //	memcpy(FRAM4_START, stPTP.save_FRAM4, FRAM4_SIZE);	//FRAM4𕜌
				    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
					pceFileClose(&fa);
					sct++;					//ZN^ԍ֐i߂
					pos = 0;				//[Nobt@݈̏ʒu擪֖߂
				}
				buf += cnt;					//[Nobt@ɏ񂾕AMf[^i߂
				len -= cnt;					//Mf[^̎coCg炷
			} while(len);						//Mf[^̎coCgLԁAJԂ
		}
		return 0;
	/*--------------------------------------------------------------------------*/
//	case PTP_OperationCode_SetDevicePropValue:
	/*--------------------------------------------------------------------------*/
#ifdef  USE_MTP_OPERATION
//	case MTP_OperationCode_SetObjectPropValue:
//	case MTP_OperationCode_SetObjectPropList:
//	case MTP_OperationCode_SendObjectPropList:
//	case MTP_OperationCode_SetObjectReferences:
#endif//USE_MTP_OPERATION
	/*--------------------------------------------------------------------------*/
	}
	/* ΁AG[ƂB */
	return -1;
}
/*--------------------------------------------------------------------------*/
static int process_datain(void* buf, int len) {
	/* f[^|C^ݒ肳ĂAf[^擾B */
	if(stPTP.DataPtr) { memcpy(buf, stPTP.DataPtr + stPTP.DataPos, len); }
	/* Iy[VR[hɂāc */
	switch(stPTP.OperationRequestDataset.OperationCode) {
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetDeviceInfo:
	case PTP_OperationCode_GetStorageIDs:
	case PTP_OperationCode_GetStorageInfo:
	case PTP_OperationCode_GetObjectHandles:
	case PTP_OperationCode_GetObjectInfo:
		/** no job **/
		return 0;
	/*--------------------------------------------------------------------------*/
	case PTP_OperationCode_GetObject:
		{
			/* 1pPbg擾xɃt@CJƂB͈PłB
			 * ۂɎƂA̕@łǏox͏[āA薳ƔfB */
			const DIRECTORY* pdir = (DIRECTORY*)stPTP.OperationRequestDataset.Parameter[0];
			FILE* fp = fopen(pdir->name, "rb");	//ydvzfopen()͔r䂳ĂȂB荞݊Oœfopen()gƁAclipio.c̃t@CI/O\̃obt@鋰ꂪLBW[𗘗pAvP[V́A荞݊Ofopen(),fclose()gꍇAIɊ荞݋֎~ɂB
			if(!fp) {	//IuWFNgnhs
				stPTP.ResponseDataset.ResponseCode = PTP_ResponseCode_InvalidObjectHandle;
				return 0;
			}
			fseek(fp, stPTP.DataPos, SEEK_SET);	//ɂ̓G[`FbNׂAƉ肵ďȗB
			fread(buf, 1, len, fp);			//ɂ̓G[`FbNׂAƉ肵ďȗB
			fclose(fp);
		}
		return 0;
	/*--------------------------------------------------------------------------*/
//	case PTP_OperationCode_GetThumb:
//	case PTP_OperationCode_GetDevicePropDesc:
//	case PTP_OperationCode_GetDevicePropValue:
//	case PTP_OperationCode_GetPartialObject:
	/*--------------------------------------------------------------------------*/
#ifdef  USE_MTP_OPERATION
	case MTP_OperationCode_GetObjectPropsSupported:
	case MTP_OperationCode_GetObjectPropDesc:
	case MTP_OperationCode_GetObjectPropValue:
		/** no job **/
		return 0;
	/*--------------------------------------------------------------------------*/
//	case MTP_OperationCode_GetObjectPropList:
//	case MTP_OperationCode_GetInterdependentPropDesc:
//	case MTP_OperationCode_GetObjectReferences:
#endif//USE_MTP_OPERATION
	/*--------------------------------------------------------------------------*/
	}
	/* ΁AG[ƂB */
	return -1;
}
