/*	
 *	clipprin.c
 *
 *	USB Printer Device
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Sat May 23 13:57:58 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"
/****************************************************************************
 *	O[oϐ
 ****************************************************************************/
ST_Printer stPrinter;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void ep2_rxdone();
static void ep2_rxsub();
/****************************************************************************
 *	USBtbN
 ****************************************************************************/
static const USBINF usb_inf={
	//USBC mode
	.mode			= D12_ENDP_NONISO,
	//USBC raw event
	.ep2_rxdone		= ep2_rxdone,
	//Device request
	.get_descriptor		= get_descriptor,
	.set_configuration	= set_configuration,
	.set_interface		= set_interface,
	//Class request
	.class_request		= class_request,
};
/****************************************************************************
 *	fBXNv^
 ****************************************************************************/
//QƎ
//uUniversal Serial Bus Device Class Definition for Printing Devices Version 1.1 January 2000v(usbprint11a021811.pdf)
//5. Standard Descriptors
/*--------------------------------------------------------------------------*/
//5.1 Device Descriptor
static const DEVICE_DESCRIPTOR DeviceDescriptor={
	.bLength		= sizeof(DEVICE_DESCRIPTOR),
	.bDescriptorType	= DEVICE_DESCRIPTOR_TYPE,
	.bcdUSB			= 0x0110,
//	.bDeviceClass		= 0,
//	.bDeviceSubClass	= 0,
//	.bDeviceProtocol	= 0,
	.bMaxPacketSize0	= EP0_PACKET_SIZE,
	.idVendor		= PCE_VENDOR_ID,
	.idProduct		= PRINTER_PRODUCT_ID,
	.bcdDevice		= 0x0001,
	.iManufacture		= 1,
	.iProduct		= 2,
//	.iSerialNumber		= 0,
	.bNumConfigurations	= 1,
};
/*--------------------------------------------------------------------------*/
//5.2 Configuration Descriptor
static const CONFIGURATION_DESCRIPTOR ConfigurationDescriptor={
	.bLength		= sizeof(CONFIGURATION_DESCRIPTOR),
	.bDescriptorType	= CONFIGURATION_DESCRIPTOR_TYPE,
	.wTotalLength		= sizeof(CONFIGURATION_DESCRIPTOR) +
				  sizeof(INTERFACE_DESCRIPTOR) +
				  sizeof(ENDPOINT_DESCRIPTOR),
	.bNumInterfaces		= 1,
	.bConfigurationValue	= 1,
//	.iConfiguration		= 0,
	.bmAttributes		= 0x80,
	.MaxPower		= 100/2,
};
/*--------------------------------------------------------------------------*/
//5.3 Interface Descriptors
static const INTERFACE_DESCRIPTOR InterfaceDescriptor={
	.bLength		= sizeof(INTERFACE_DESCRIPTOR),
	.bDescriptorType	= INTERFACE_DESCRIPTOR_TYPE,
//	.bInterfaceNumber	= 0,
//	.bAlternateSetting	= 0,
	.bNumEndpoints		= 1,
	.bInterfaceClass	= 7,						//Base class for printers.
	.bInterfaceSubClass	= 1,						//The subclass codes for Printer devices are: 01 Printers
	.bInterfaceProtocol	= 1,						//Printer Interface Type: 00 Reserved, undefined. 01 Unidirectional interface. 02 Bi-directional interface. 03 1284.4 compatible bi-directional interface. 04-FEh Reserved for future use. FFh Vendor-specific printers do not use classspecific protocols.
//	.iInterface		= 0,
};
/*--------------------------------------------------------------------------*/
//5.4 Endpoint Descriptors
static const ENDPOINT_DESCRIPTOR EndpointDescriptor={
	.bLength		= sizeof(ENDPOINT_DESCRIPTOR),
	.bDescriptorType	= ENDPOINT_DESCRIPTOR_TYPE,
	.bEndpointAddress	= 0x02,						//EP2OUT
	.bmAttributes		= 2,						//Bulk
	.wMaxPacketSize		= EP2_NONISO_PACKET_SIZE,
//	.bInterval		= 0,
};
/*--------------------------------------------------------------------------*/
static const uint16_t* const TBL_StringDescriptor[]={
  (const uint16_t []){
	STRING_DESCRIPTOR_TYPE<<8|4,						//bLength,bDescriptorType
	0x0409,									//wLANGID[0]
},(const uint16_t []){
	STRING_DESCRIPTOR_TYPE<<8|22,						//bLength,bDescriptorType
	'P','i','e','c','e',' ','L','a','b','.',				//bString
},(const uint16_t []){
	STRING_DESCRIPTOR_TYPE<<8|34,						//bLength,bDescriptorType
	'P','/','E','C','E',' ','U','S','B',' ','d','e','v','i','c','e'
}};
/****************************************************************************
 *	
 ****************************************************************************/
void Printer_Start(int rxcap/*0*/, void (*rxdone/*NULL*/)()) {
	//mɏIĂB
	Printer_Stop();
	//\̂NAB
	memset(&stPrinter, 0, sizeof stPrinter);
	//Mobt@mۂB
	if(rxcap < EP2_NONISO_PACKET_SIZE) { rxcap = EP2_NONISO_PACKET_SIZE; }
	stPrinter.rxcap = rxcap;
	stPrinter.rxbuf = malloc(rxcap);
	if(!stPrinter.rxbuf) { DIE(); }
	//MR[obNi[B
	stPrinter.rxdone = rxdone;
	//USB̃tbNJnB
	usb_start(&usb_inf);
}
/*--------------------------------------------------------------------------*/
void Printer_Stop() {
	//USB̃tbNIB
	usb_stop();
	//Mobt@JB
	free(stPrinter.rxbuf/*NULL*/);
	//\̂NAB
	memset(&stPrinter, 0, sizeof stPrinter);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	static void* buf;
	       void* ptr;
	int type  = HIBYTE(req->wValue);
	int index = LOBYTE(req->wValue);
	switch(type) {
	case DEVICE_DESCRIPTOR_TYPE:
		{
			usb_ep0_tx(&DeviceDescriptor, sizeof DeviceDescriptor);
			return;
		}
		break;
	case CONFIGURATION_DESCRIPTOR_TYPE:
		if(index == 0) {
			buf = realloc(buf, sizeof ConfigurationDescriptor + sizeof InterfaceDescriptor + sizeof EndpointDescriptor);
			ptr =         buf;
			ptr = mempcpy(ptr, &ConfigurationDescriptor, sizeof ConfigurationDescriptor);
			ptr = mempcpy(ptr, &InterfaceDescriptor    , sizeof InterfaceDescriptor    );
			ptr = mempcpy(ptr, &EndpointDescriptor     , sizeof EndpointDescriptor     );
			usb_ep0_tx(   buf, sizeof ConfigurationDescriptor + sizeof InterfaceDescriptor + sizeof EndpointDescriptor);
			return;
		}
		break;
	case STRING_DESCRIPTOR_TYPE:
		if(index < ARRAY_SIZE(TBL_StringDescriptor)) {
			usb_ep0_tx(TBL_StringDescriptor[index], (uint8_t)TBL_StringDescriptor[index][0]);
			return;
		}
		break;
	}
	usb_ep0_stall();	//Ή
}
/*--------------------------------------------------------------------------*/
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	D12_SetEndpointEnable(req->wValue == 1);
	usb_ep0_tx(NULL, 0);	//ACK
}
/*--------------------------------------------------------------------------*/
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	usb_ep0_tx(NULL, 0);	//ACK
}
/****************************************************************************
 *	
 ****************************************************************************/
static void class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len) {
	switch(req->bRequest) {
	case PRINTER_GET_DEVICE_ID:
		{
			//Ql
			//@uUndocumented Printing Wikiv(http://www.undocprint.org/)́wIEEE Standard 1284x(http://www.undocprint.org/formats/communication_protocols/ieee_1284)
			//AuȂЂӐVv(http://www.nahitech.com/nahitafu/)́wIEEE1284FPGAŎ悤x(http://www.nahitech.com/nahitafu/fpgavhdl/ieee1284_2/ieee1284_2.html)
			//BuMicrochipv(http://www.microchip.com/)́wUSB Printer Class(Client, not Host)x(http://www.microchip.com/forums/m491016.aspx)
			static const char DeviceId[]=
				"\x00\x50"			// 2	̃tB[hg̃TCY܂ނ̂BQƎB̗͊ԈĂ܂܂܍Ō̃tB[hDESŌĂfoCX̔Fɉe悤łB
				"MFG:Generic;"			//12	yK{zWindows'Generic / Text Only'v^ƂĔF邽߂ɕKvȐݒB(QƎB)
				"MDL:Generic_/_Text_Only;"	//24	yK{zWindows'Generic / Text Only'v^ƂĔF邽߂ɕKvȐݒB(QƎB)
				"CLS:PRINTER;"			//12
				"CMD:none;"			// 9	(֌W?)
				"DES:P/ECE USB device;";	//21
			usb_ep0_tx(&DeviceId, sizeof DeviceId);
		}
		return;
	case PRINTER_GET_PORT_STATUS:
		{
			//7..6	Reserved Reserved for future use; device shall return these bits reset to zero.
			//5	Paper Empty 1 = Paper Empty, 0 = Paper Not Empty
			//4	Select 1 = Selected, 0 = Not Selected
			//3	Not Error 1 = No Error, 0 = Error
			//2..0	Reserved Reserved for future use; device shall return these bits reset to zero.
			static const uint8_t PortStatus = (0/*Paper Not Empty*/<<5)|(1/*Selected*/<<4)|(1/*No Error*/<<3);
			usb_ep0_tx(&PortStatus, sizeof PortStatus);
		}
		return;
	case PRINTER_SOFT_RESET:
		{
			usb_ep0_tx(NULL, 0);	//ACK
		}
		return;
	}
	//The Device may support class-specific requests.
	//The device shall return STALL if an unrecognized or unsupported device-specific request is received.
	usb_ep0_stall();	//Ή
}
/****************************************************************************
 *	
 ****************************************************************************/
//M̃ASÝAclipacm.cW[ƓłB
/*--------------------------------------------------------------------------*/
static void ep2_rxdone() {
	ep2_rxsub();
	if(stPrinter.rxdone) { stPrinter.rxdone(); }
}
/*--------------------------------------------------------------------------*/
static void ep2_rxsub() {
	uint8_t buf[EP2_NONISO_PACKET_SIZE], *ptr;
	int len, pos;
	//_uobt@ɓpPbgSďB
	for(;;) {
		len = D12_ReadBuffer(EP2OUT, buf, sizeof buf);
		if((len == -1) || //pPbgB
		   (len > (stPrinter.rxcap - stPrinter.rxlen))) {
			//stPrinter.rxbufɋ󂫂ꍇ́ApPbgNAɁAUSBC̎Mobt@ɎcĂ܂B
			//Mobt@ɑÕpPbgcĂ΁APC͎̃pPbg𑗐MłAubNԂƂȂ܂B
			//ŁAstPrinter_recv()ĂяoAstPrinter.rxbufɋ󂫂łAcĂpPbgǂݏo܂B
			//ɂāAMobt@ƂȂāAPC̃ubNԂāÃpPbgė܂B
			break;
		}
		D12_ClearBuffer(EP2OUT);
		if(len) {
			pos = (stPrinter.rxpos + stPrinter.rxlen);
			stPrinter.rxlen += len;
			ptr = buf;
			do {
				if(pos >= stPrinter.rxcap) { pos -= stPrinter.rxcap; }
				stPrinter.rxbuf[pos++] = *ptr++;
			} while(--len);
		}
	}
}
/*--------------------------------------------------------------------------*/
int Printer_Recv(void* buf/*[buflen]*/, int buflen) {
	uint8_t* ptr = buf;
ENTER_CS;
	do {
		int len = (stPrinter.rxlen <= buflen) ? stPrinter.rxlen : buflen;
		if(len) {
			buflen          -= len;
			stPrinter.rxlen -= len;
			do {
				*ptr++ = stPrinter.rxbuf[stPrinter.rxpos++];
				if(stPrinter.rxpos == stPrinter.rxcap) { stPrinter.rxpos = 0; }
			} while(--len);
		}
		//stPrinter.rxbufɋ󂫂łA̕USBC̎Mobt@ǂݏoB
		//USBC̎Mobt@ł邾ɂ邽߂ɁAKx͌ĂяoB
		ep2_rxsub();
	} while(stPrinter.rxlen && buflen);
LEAVE_CS;
	return ptr - (uint8_t*)buf;
}
/****************************************************************************
 *	AvP[V̎gp(|[Ȍꍇ)
 ****************************************************************************/
#if 0
void app_main(){
 char buf[256/*ύX*/];
 FILE* fp=fopen("test.txt","w");
 Printer_Start(0,NULL);
 for(;;){
  int len;
  schedule();
  if(joy&TRG_A){break;}
  if((len=Printer_Recv(buf,sizeof buf))){fwrite(buf,1,len,fp);}
 }
 Printer_Stop();
}
#endif
/****************************************************************************
 *	AvP[V̎gp(Cxghȕꍇ)
 ****************************************************************************/
#if 0
static FILE* fp;
static void onRecv(){
 char buf[256/*ύX*/];
 int len=Printer_Recv(buf,sizeof buf);
 fwrite(buf,1,len,fp);
}
void app_main(){
 fp=fopen("test.txt","w");
 Printer_Start(0,onRecv);
 for(;;){
  schedule();
  if(joy&TRG_A){break;}
 }
 Printer_Stop();
}
#endif
/****************************************************************************
 *	eXg@(Windows Xp̏ꍇ)
 ****************************************************************************/
//v^FAX
//Generic / Text Only
//˃vpeB
//˃eXgy[Ẅ
//{̕'.'ɂȂĂ܂܂A'Generic / Text Only'v^̈ʂƂĂ͂Ő݂łB
//GۃGfB^ł͈ł܂łBGۃGfB^̓eLXgOtBbNƂĈp݂łB
//(notepad.exe)ȂΈł܂B
