/*	
 *	clippp4i.h
 *
 *	P/ECE PPU (RICOH RP2C02) Emulator (1/4𑜓x)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Feb 09 04:34:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */

/****************************************************************************
 *
 ****************************************************************************/

/* PPUG~[V́ABG`֐̎ɗp܂B
 *	void ppu4_draw_chr      (int xpos, int ypos, int code, int palno)
 *	void ppu4_draw_chr_revx (int xpos, int ypos, int code, int palno)
 *	void ppu4_draw_chr_revy (int xpos, int ypos, int code, int palno)
 *	void ppu4_draw_chr_revxy(int xpos, int ypos, int code, int palno)
 * [in]
 *	(xpos,ypos)	`悷8x8`̍㌴_WB
 *	code		LԍB($000-$100)
 *	palno		J[R[h̏3bitB($0-$7)
 */
#ifdef PPU_DRAW_CHR_IMPLEMENT
{
	PPU* p_ppu = &ppu;
	unsigned char* vram = ppu_vram;
	//
	int scan_start = p_ppu->scan_start;
	int scan_end = p_ppu->scan_end;
	unsigned char* vbuff = p_ppu->vbuff;
	unsigned char* clut = p_ppu->clut;
	//
	int x;
	int y;
	int v;
	int v0;
	int v1;
	unsigned char* pattern;

	scan_start /= 2;
	scan_end   /= 2;
	xpos       /= 2;
	ypos       /= 2;

	/* Sɕ`̈OȂ΁AA܂B */
	if(ypos <= scan_start - 4 || ypos >= scan_end ||
	   xpos <=          0 - 4 || xpos >=      128) {
		return;
	}

	vbuff += ypos * 128 + xpos;
	clut += palno << 2;
#if(PPU_REVY == 0)
	pattern = &vram[0x0000 | code << 4];
#else /*PPU_REVY*/
	pattern = &vram[0x0007 | code << 4];
#endif /*PPU_REVY*/

	/* Sɕ`̈Ȃ΁ANbsOsvB */
	if(ypos >= scan_start && ypos <= scan_end - 4 &&
	   xpos >=          0 && xpos <=      128 - 4) {
		y = 4;
		do {
#if(PPU_REVX == 0)
			v0 = MIRROR(pattern[0]);
			v1 = MIRROR(pattern[8]) << 1;
#else /*PPU_REVX*/
			v0 = pattern[0];
			v1 = pattern[8] << 1;
#endif /*PPU_REVX*/
			x = 4;
			do {
				v = (v0 & 1) | (v1 & 2);
				if(v) {
					*vbuff = clut[v];
				}
				v0 >>= 2;
				v1 >>= 2;
				vbuff++;
			} while(--x);
			vbuff += 128 - 4;
#if(PPU_REVY == 0)
			pattern += 2;
#else /*PPU_REVY*/
			pattern -= 2;
#endif /*PPU_REVY*/
		} while(--y);

	/* `̈͂ݏoꍇANbsOKvB */
	} else {
		y = 4;
		do {
			if(ypos >= scan_start && ypos < scan_end) {
#if(PPU_REVX == 0)
				v0 = MIRROR(pattern[0]);
				v1 = MIRROR(pattern[8]) << 1;
#else /*PPU_REVX*/
				v0 = pattern[0];
				v1 = pattern[8] << 1;
#endif /*PPU_REVX*/
				x = 4;
				do {
					v = (v0 & 1) | (v1 & 2);
					if(v) {
						if(xpos >= 0 && xpos < 128) {
							*vbuff = clut[v];
						}
					}
					v0 >>= 2;
					v1 >>= 2;
					xpos++;
					vbuff++;
				} while(--x);
				xpos  -= 4;
				vbuff -= 4;
			}
			ypos++;
			vbuff += 128;
#if(PPU_REVY == 0)
			pattern += 2;
#else /*PPU_REVY*/
			pattern -= 2;
#endif /*PPU_REVY*/
		} while(--y);
	}
}
#endif PPU_DRAW_CHR_IMPLEMENT

/****************************************************************************
 *
 ****************************************************************************/
