/*	
 *	clipp62.c
 *
 *	P/ECE HuC6280-PSG Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	֐
 ****************************************************************************/

/* `l{[XV܂B */
void
huc6280psg_update_volume(HUC6280PSG* psg, HUC6280PSGCHANNEL* channel)
{
	channel->volume = psg->main_volume					/*   5bit C{[   */
			* (channel->reg[2] & 0x1f)				/* + 5bit `l{[ */
			* ((channel->reg[3] & 0xf) + (channel->reg[3] >> 4));	/* + 5bit EoXZ */
}										/* =15bit */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
huc6280psg_reset(HUC6280PSG* psg, int clock)
{
	int i_channel;
	HUC6280PSGCHANNEL* channel;

	/* ܂NAB */
	memset(psg, 0, sizeof(HUC6280PSG));

	/* NbNisDDAZbgAbvB */
	psg->clock_progress.u = clock / SPEAKER_FREQUENCY; /* ̕ω */
	psg->clock_progress.n = clock % SPEAKER_FREQUENCY; /* [̑ */
	psg->clock_progress.d =        -SPEAKER_FREQUENCY; /* [ */

	/* 0s̃tB[hmɏB */
	for(i_channel = 0, channel = psg->channel; i_channel < 6; i_channel++, channel++) {
		channel->tone_period	= 1 << 12;
		channel->noise_period	= 0x20 << 6;	/* Ch4,5̂ݕK{ */
		channel->noise_lfsr	= 1;		/* Ch4,5̂ݕK{ */
	}
}

void
huc6280psg_write(HUC6280PSG* psg, int addr, unsigned char data)
{
	int i_channel, volume;
	HUC6280PSGCHANNEL* channel;

	switch(addr) {
	/***** ݒ`lI *****/
	case 0:	/* ?????ccc (c:`lԍ(0`5)) */
		data &= 7;	/* gprbg}XN */
		if(data <= 5) psg->channel_select = data;
		return;

	/***** C{[ *****/
	case 1:	/* llllrrrr (l:C{[, r:EC{[) */
		volume = (data & 0xf) + (data >> 4);	/* EC{[Z (4bit~2 = 5bit) */
		if(psg->main_volume == volume) return;	/* ω */
		psg->main_volume = volume;		/* ω̒li[ */
		for(i_channel = 0, channel = psg->channel; i_channel < 6; i_channel++, channel++) {
			huc6280psg_update_volume(psg, channel);	/* `l{[XV */
		}
		return;

	/***** `lݒ *****/
#define REG(i)	(channel->reg[(i) - 2])	/* HUC6280PSGCHANNEL.reg[6]$0802`$0807ێĂ܂ */

	case 2:	/* ffffffff (f:g[[ 7-0]) */
	case 3:	/* ????ffff (f:g[[11-8]) */
		channel = &psg->channel[psg->channel_select];
		if(REG(addr) == data) return;	/* ω */
		REG(addr) = data;	/* ω̒li[ */
		//
		channel->tone_period = REG(2) | (REG(3) & 0xf) << 8;
		if(!channel->tone_period) channel->tone_period = 1 << 12; /* vmF */
		channel->tone_progress = channel->tone_period; /* Kv? */
		return;

	case 4:	/* cd?vvvvv (c:`lON/OFF, d:DirectD/A ON/OFF, v:`l{[) */
		data &= 0xdf;	/* rEi[Oɖgprbg}XN */
		//
		channel = &psg->channel[psg->channel_select];
		if(REG(addr) == data) return;	/* ω */
		REG(addr) = data;	/* ω̒li[ */
		//
		channel->enable = (REG(4) >> 7) & 1;
		channel->dda = (REG(4) >> 6) & 1;
		if(channel->dda) channel->wave_index = 0;
		huc6280psg_update_volume(psg, channel);
		return;

	case 5:	/* llllrrrr (l:`l{[, r:E`l{[) */
		channel = &psg->channel[psg->channel_select];
		if(REG(addr) == data) return;	/* ω */
		REG(addr) = data;	/* ω̒li[ */
		//
		huc6280psg_update_volume(psg, channel);
		return;

	case 6:	/* 000wwwww (w:g`f[^) */
		data &= 0xdf;	/* gprbg}XN */
		//
		channel = &psg->channel[psg->channel_select];
		//
		channel->wave[channel->wave_index & 0x1f] = data - 16;	/* 0`31 => -16`+15 ϊ */
		if(!channel->dda) channel->wave_index++;
		return;

	case 7:	/* n??fffff (n:mCYON/OFF, f:mCY1̕␔) */
		if(psg->channel_select < 4) return;	/* Ch0,1,2,3ɂ̓mCY[hȂ */
		data &= 0x9f;	/* rEi[Oɖgprbg}XN */
		//
		channel = &psg->channel[psg->channel_select];
		if(REG(addr) == data) return;	/* ω */
		REG(addr) = data;	/* ω̒li[ */
		//
		channel->noise = (REG(7) >> 7) & 1;
		if(channel->noise) {
			channel->noise_period = (~REG(7) & 0x1f) << 6;
			if(!channel->noise_period) channel->noise_period = 0x20 << 6; /* vmF */
			channel->noise_progress = channel->noise_period; /* Kv? */
		}
		return;

#undef REG

	///***** LFO (Ή) *****/
	//case 8:
	//case 9:
	//	return;
	}
}

