/*
 *	clipobj3.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Wed Jun 28 00:42:05 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	  ExpatCuN̂ŁAsoCi傫Ȃ܂B
 *	  mesh_load()gȂoCiAʂɑ傫Ȃ̂邽߁A
 *	  ʏ̕`惂W[clipren2.c,clipren3.cƂ͕ʃt@Cɂ܂B
 *	- 2006/06/28݁AeNX`W̓ǂݍ݂̓mFłB
 *	  ExportPieceClipvOCŁAeNX`Wo͂łB
 *	  ꉞA{W[̃eNX`Wǂݍݏ́ASĂ̂ŁA
 *	  oO΂̂܂܂ővȂ͂łB
 *	  2006/06/29ǋL 
 *	  ExportPieceClipvOCɁAeNX`Wo͂ǉ܂B
 *	  {W[̓ǂݍݏAȂ삵Ă悤łB
 *	* Wed Jun 28 04:51:07 JST 2006 Naoyuki Sawa
 *	- "XML_Parser parser"Amesh_load()̃[JϐAMESHLOAD\̂̃oֈړ܂B
 *	  _ł͓ɈӖ͂܂񂪁AAGgnhŃG[\ꍇɔāA
 *	  "XML_GetCurrentLineNumber(ml->parser)"Ȃǂ̌Ăяo\Ƃ邽߂łB
 *	* Thu Jun 29 14:44:46 JST 2006 Naoyuki Sawa
 *	- t@Cclipmesh.cclipobj3.cɕύX܂B
 *	- wire_load()ǉ܂B
 *	* Sun Aug 10 21:42:25 JST 2008 Naoyuki Sawa
 *	- tool/ExportPieceClipA<vector>vfŒ菬_łȂ_ŏo͂悤ύXƂɒǏ]A
 *	  mesh_load()wire_load()ɁA_̂܂ܓǂݍނAŒ菬_ɕϊ邩̑Iǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	mesh_load
 *****************************************************************************/

#define MESHLOAD_STAT_MESH_START	0
#define MESHLOAD_STAT_MESH_END		1
#define MESHLOAD_STAT_VECTOR_START	2
#define MESHLOAD_STAT_VECTOR_END	3
#define MESHLOAD_STAT_TCOORD_START	4
#define MESHLOAD_STAT_TCOORD_END	5
#define MESHLOAD_STAT_FACE_START	6
#define MESHLOAD_STAT_FACE_END		7
#define MESHLOAD_STAT_FACEVERTEX_START	8
#define MESHLOAD_STAT_FACEVERTEX_END	9
#define MESHLOAD_STAT_EOF		-1

#define MESHLOAD_BUFLEN	64	/* ǂݍ݃obt@ () */

/*{{clipren3.c*/
#define N_VERTICES_MAX	8	/* 1|S̍ő咸_ */
/*}}clipren3.c*/

typedef struct _MESHLOAD {
	XML_Parser parser;
	//
//{{2008/08/10:ǉ
	int convert_fixed;	/* 0 = <vector>vf𕂓_̂܂܂ŁA_MESHƂB */
	//			/* 1 = <vector>vfŒ菬_ɕϊAŒ菬_MESHƂB */
//}}2008/08/10:ǉ
	int stat;		/* MESHLOAD_STAT_* */
	int iv;
	int ic;
	int if_;
	int ifv;
	//
	MESH m;
	vector v[255/*nv*/];
	TCOORD c[255/*nc*/];
	struct {
		FACE f;
		FACEVERTEX fv[N_VERTICES_MAX/*nfv*/];
	} f[255/*nf*/];
	//
	unsigned char buf[MESHLOAD_BUFLEN];
} MESHLOAD;

static void
mesh_load_start_element(void* user_data, const char* name, const char* atts[])
{
	MESHLOAD* ml = user_data;

	switch(ml->stat) {
	case MESHLOAD_STAT_MESH_START:
		if(strcasecmp(name, "mesh") ||
		   !atts[0] || strcasecmp(atts[0], "nv") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "nc") || !atts[3] ||
		   !atts[4] || strcasecmp(atts[4], "nf") || !atts[5] ||
		    atts[6]) {
			DIE();
		}
		ml->m.nv = atoi(atts[1]);
		ml->m.nc = atoi(atts[3]);
		ml->m.nf = atoi(atts[5]);
		if(ml->m.nv) {        /* _WL */
			ml->stat = MESHLOAD_STAT_VECTOR_START;
			ml->iv   = 0;
		} else if(ml->m.nc) { /* eNX`WL */
			ml->stat = MESHLOAD_STAT_TCOORD_START;
			ml->ic   = 0;
		} else if(ml->m.nf) { /* tFCXL */
			ml->stat = MESHLOAD_STAT_FACE_START;
			ml->if_  = 0;
		} else {              /* 󃁃bV */
			ml->stat = MESHLOAD_STAT_MESH_END;
		}
		break;

	case MESHLOAD_STAT_VECTOR_START:
		if(strcasecmp(name, "vector") ||
		   !atts[0] || strcasecmp(atts[0], "x") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "y") || !atts[3] ||
		   !atts[4] || strcasecmp(atts[4], "z") || !atts[5] ||
		    atts[6]) {
			DIE();
		}
//{{2008/08/10:ύX
//		ml->v[ml->iv].x = (fixed)atoi(atts[1]);
//		ml->v[ml->iv].y = (fixed)atoi(atts[3]);
//		ml->v[ml->iv].z = (fixed)atoi(atts[5]);
//2008/08/10:ύX
		if(ml->convert_fixed) {
			ml->v[ml->iv].x = fld(atof(atts[1]));
			ml->v[ml->iv].y = fld(atof(atts[3]));
			ml->v[ml->iv].z = fld(atof(atts[5]));
		} else {
			float x = atof(atts[1]);
			float y = atof(atts[3]);
			float z = atof(atts[5]);
			ml->v[ml->iv].x = *(fixed*)&x;
			ml->v[ml->iv].y = *(fixed*)&y;
			ml->v[ml->iv].z = *(fixed*)&z;
		}
//}}2008/08/10:ύX
		ml->stat = MESHLOAD_STAT_VECTOR_END;
		break;

	case MESHLOAD_STAT_TCOORD_START:
		if(strcasecmp(name, "tcoord") ||
		   !atts[0] || strcasecmp(atts[0], "s") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "t") || !atts[3] ||
		    atts[4]) {
			DIE();
		}
		ml->c[ml->ic].s = atoi(atts[1]);
		ml->c[ml->ic].t = atoi(atts[3]);
		ml->stat = MESHLOAD_STAT_TCOORD_END;
		break;

	case MESHLOAD_STAT_FACE_START:
		if(strcasecmp(name, "face") ||
		   !atts[0] || strcasecmp(atts[0], "nfv") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "c"  ) || !atts[3] ||
		    atts[4]) {
			DIE();
		}
		ml->f[ml->if_].f.nfv = atoi(atts[1]);
		ml->f[ml->if_].f.c   = atoi(atts[3]);
		if(ml->f[ml->if_].f.nfv) { /* tFCX_L */
			if(ml->f[ml->if_].f.nfv > N_VERTICES_MAX) {
				DIE();
			}
			ml->stat = MESHLOAD_STAT_FACEVERTEX_START;
			ml->ifv  = 0;
		} else {                   /* tFCX */
			ml->stat = MESHLOAD_STAT_FACE_END;
		}
		break;

	case MESHLOAD_STAT_FACEVERTEX_START:
		if(strcasecmp(name, "facevertex") ||
		   !atts[0] || strcasecmp(atts[0], "iv") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "ic") || !atts[3] ||
		    atts[4]) {
			DIE();
		}
		ml->f[ml->if_].fv[ml->ifv].iv = atoi(atts[1]);
		ml->f[ml->if_].fv[ml->ifv].ic = atoi(atts[3]);
		ml->stat = MESHLOAD_STAT_FACEVERTEX_END;
		break;

	default:
		DIE();
	}
}

static void
mesh_load_end_element(void* user_data, const char* name)
{
	MESHLOAD* ml = user_data;

	switch(ml->stat) {
	case MESHLOAD_STAT_MESH_END:
		if(strcasecmp(name, "mesh")) {
			DIE();
		}
		ml->stat = MESHLOAD_STAT_EOF;
		break;

	case MESHLOAD_STAT_VECTOR_END:
		if(strcasecmp(name, "vector")) {
			DIE();
		}
		if(++ml->iv < ml->m.nv) { /* _Wp */
			ml->stat = MESHLOAD_STAT_VECTOR_START;
		} else if(ml->m.nc) {     /* eNX`WL */
			ml->stat = MESHLOAD_STAT_TCOORD_START;
			ml->ic   = 0;
		} else if(ml->m.nf) {     /* tFCXL */
			ml->stat = MESHLOAD_STAT_FACE_START;
			ml->if_  = 0;
		} else {                  /* bVI */
			ml->stat = MESHLOAD_STAT_MESH_END;
		}
		break;

	case MESHLOAD_STAT_TCOORD_END:
		if(strcasecmp(name, "tcoord")) {
			DIE();
		}
		if(++ml->ic < ml->m.nc) { /* eNX`Wp */
			ml->stat = MESHLOAD_STAT_TCOORD_START;
		} else if(ml->m.nf) {     /* tFCXL */
			ml->stat = MESHLOAD_STAT_FACE_START;
			ml->if_ = 0;
		} else {                  /* bVI */
			ml->stat = MESHLOAD_STAT_MESH_END;
		}
		break;

	case MESHLOAD_STAT_FACE_END:
		if(strcasecmp(name, "face")) {
			DIE();
		}
		if(++ml->if_ < ml->m.nf) { /* tFCXp */
			ml->stat = MESHLOAD_STAT_FACE_START;
		} else {                   /* bVI */
			ml->stat = MESHLOAD_STAT_MESH_END;
		}
		break;

	case MESHLOAD_STAT_FACEVERTEX_END:
		if(strcasecmp(name, "facevertex")) {
			DIE();
		}
		if(++ml->ifv < ml->f[ml->if_].f.nfv) { /* tFCX_p */
			ml->stat = MESHLOAD_STAT_FACEVERTEX_START;
		} else {                               /* bVI */
			ml->stat = MESHLOAD_STAT_FACE_END;
		}
		break;

	default:
		DIE();
	}
}

MESH*
//{{2008/08/10:ύX
//mesh_load(const char* filename)
//2008/08/10:ύX
mesh_load(const char* filename, int convert_fixed)
//}}2008/08/10:ύX
{
	int result;
	int size;
	int done;
	FILE* fp;
	MESHLOAD* ml;
	MESH* m;
	unsigned char* p;

	/* t@CJ܂B */
	fp = fopen(filename, "rt");
	if(!fp) {
		DIE();
	}

	/* MESHLOAD\̂̃mۂ܂B */
	ml = calloc(1, sizeof(MESHLOAD));
	if(!ml) {
		DIE();
	}

//{{2008/08/10:ǉ
	ml->convert_fixed = convert_fixed;
//}}2008/08/10:ǉ

	/* XMLp[T쐬܂B */
	ml->parser = XML_ParserCreate(NULL);
	if(!ml->parser) {
		DIE();
	}

	/* [Uf[^ݒ肵܂B */
	XML_SetUserData(ml->parser, ml);

	/* vfnhݒ肵܂B */
	XML_SetElementHandler(ml->parser, mesh_load_start_element, mesh_load_end_element);

	do {
		/* t@Cǂݍ݂܂B */
		size = fread(ml->buf, 1, MESHLOAD_BUFLEN, fp);

		/* t@CI[ɒBׂ܂B */
		done = feof(fp);

		/* ǂݍ񂾕p[X܂B */
		result = XML_Parse(ml->parser, ml->buf, size, done);
		if(result == XML_STATUS_ERROR) {
			DIE();
		}
	} while(!done); /* t@CI[ɒB܂ */

	/* bVŜ̃TCY߂܂B */
	size =  sizeof(MESH);
	size += sizeof(vector) * ml->m.nv;
	size += sizeof(TCOORD) * ml->m.nc;
	for(ml->if_ = 0; ml->if_ < ml->m.nf; ml->if_++) {
		size += sizeof(FACE);
		size += sizeof(FACEVERTEX) * ml->f[ml->if_].f.nfv;
	}

	/* bVŜ̃mۂ܂B */
	m = calloc(size, 1);
	if(!m) {
		DIE();
	}

	/* bVŜgݗĂ܂B */
	p = (unsigned char*)m;
	memcpy(p, &ml->m, sizeof(MESH));
	       p +=       sizeof(MESH);
	memcpy(p, ml->v, sizeof(vector) * ml->m.nv);
	       p +=      sizeof(vector) * ml->m.nv;
	memcpy(p, ml->c, sizeof(TCOORD) * ml->m.nc);
	       p +=      sizeof(TCOORD) * ml->m.nc;
	for(ml->if_ = 0; ml->if_ < ml->m.nf; ml->if_++) {
		memcpy(p, &ml->f[ml->if_].f, sizeof(FACE));
		       p +=                  sizeof(FACE);
		memcpy(p, ml->f[ml->if_].fv, sizeof(FACEVERTEX) * ml->f[ml->if_].f.nfv);
		       p +=                  sizeof(FACEVERTEX) * ml->f[ml->if_].f.nfv;
	}

	/* XMLp[T폜܂B */
	XML_ParserFree(ml->parser);

	/* MESHLOAD\̂̃J܂B */
	free(ml);

	/* t@C܂B */
	fclose(fp);

	return m;
}

/*****************************************************************************
 *	wire_load
 *****************************************************************************/

#define WIRELOAD_STAT_WIRE_START	0
#define WIRELOAD_STAT_WIRE_END		1
#define WIRELOAD_STAT_VECTOR_START	2
#define WIRELOAD_STAT_VECTOR_END	3
#define WIRELOAD_STAT_WSEG_START	4
#define WIRELOAD_STAT_WSEG_END		5
#define WIRELOAD_STAT_EOF		-1

#define WIRELOAD_BUFLEN	64	/* ǂݍ݃obt@ () */

typedef struct _WIRELOAD {
	XML_Parser parser;
	//
//{{2008/08/10:ǉ
	int convert_fixed;	/* 0 = <vector>vf𕂓_̂܂܂ŁA_WIREƂB */
	//			/* 1 = <vector>vfŒ菬_ɕϊAŒ菬_WIREƂB */
//}}2008/08/10:ǉ
	int stat;	/* WIRELOAD_STAT_* */
	int iv;
	int is;
	//
	WIRE* w;	/* <mesh>ƈāA擪<wire>^OŃTCYł܂B */
	//		/* ]āAMESHLOAD\̂ɂ悤Ȓԃobt@͕svłA */
	//		/* <wire>^OǂݍݎɁAŜ̃ubNmۂł܂B */
	//
	vector* v;	/* MESHLOAD.wɊmۂubN̒|CgĂ܂B */
	WSEG* s;	/* MESHLOAD.wɊmۂubN̒|CgĂ܂B */
	//
	unsigned char buf[WIRELOAD_BUFLEN];
} WIRELOAD;

static void
wire_load_start_element(void* user_data, const char* name, const char* atts[])
{
	WIRELOAD* wl = user_data;
	int nv;
	int ns;

	switch(wl->stat) {
	case WIRELOAD_STAT_WIRE_START:
		if(strcasecmp(name, "wire") ||
		   !atts[0] || strcasecmp(atts[0], "nv") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "ns") || !atts[3] ||
		    atts[4]) {
			DIE();
		}
		nv = atoi(atts[1]);
		ns = atoi(atts[3]);
		wl->w = calloc(sizeof(WIRE) + sizeof(vector) * nv + sizeof(WSEG) * ns, 1);
		if(!wl->w) {
			DIE();
		}
		wl->w->nv = nv;
		wl->w->ns = ns;
		wl->v = (vector*)(wl->w + 1 );
		wl->s = (  WSEG*)(wl->v + nv);
		if(wl->w->nv) {        /* _WL */
			wl->stat = WIRELOAD_STAT_VECTOR_START;
			wl->iv   = 0;
		} else if(wl->w->ns) { /* ZOgL */
			wl->stat = WIRELOAD_STAT_WSEG_START;
			wl->is   = 0;
		} else {               /* 󃏃Ct[ */
			wl->stat = WIRELOAD_STAT_WIRE_END;
		}
		break;

	case WIRELOAD_STAT_VECTOR_START:
		if(strcasecmp(name, "vector") ||
		   !atts[0] || strcasecmp(atts[0], "x") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "y") || !atts[3] ||
		   !atts[4] || strcasecmp(atts[4], "z") || !atts[5] ||
		    atts[6]) {
			DIE();
		}
//{{2008/08/10:ύX
//		wl->v[wl->iv].x = (fixed)atoi(atts[1]);
//		wl->v[wl->iv].y = (fixed)atoi(atts[3]);
//		wl->v[wl->iv].z = (fixed)atoi(atts[5]);
//2008/08/10:ύX
		if(wl->convert_fixed) {
			wl->v[wl->iv].x = fld(atof(atts[1]));
			wl->v[wl->iv].y = fld(atof(atts[3]));
			wl->v[wl->iv].z = fld(atof(atts[5]));
		} else {
			float x = atof(atts[1]);
			float y = atof(atts[3]);
			float z = atof(atts[5]);
			wl->v[wl->iv].x = *(fixed*)&x;
			wl->v[wl->iv].y = *(fixed*)&y;
			wl->v[wl->iv].z = *(fixed*)&z;
		}
//}}2008/08/10:ύX
		wl->stat = WIRELOAD_STAT_VECTOR_END;
		break;

	case WIRELOAD_STAT_WSEG_START:
		if(strcasecmp(name, "wseg") ||
		   !atts[0] || strcasecmp(atts[0], "iv0") || !atts[1] ||
		   !atts[2] || strcasecmp(atts[2], "iv1") || !atts[3] ||
		    atts[4]) {
			DIE();
		}
		wl->s[wl->is].iv0 = atoi(atts[1]);
		wl->s[wl->is].iv1 = atoi(atts[3]);
		wl->stat = WIRELOAD_STAT_WSEG_END;
		break;

	default:
		DIE();
	}
}

static void
wire_load_end_element(void* user_data, const char* name)
{
	WIRELOAD* wl = user_data;

	switch(wl->stat) {
	case WIRELOAD_STAT_WIRE_END:
		if(strcasecmp(name, "wire")) {
			DIE();
		}
		wl->stat = WIRELOAD_STAT_EOF;
		break;

	case WIRELOAD_STAT_VECTOR_END:
		if(strcasecmp(name, "vector")) {
			DIE();
		}
		if(++wl->iv < wl->w->nv) { /* _Wp */
			wl->stat = WIRELOAD_STAT_VECTOR_START;
		} else if(wl->w->ns) {     /* ZOgL */
			wl->stat = WIRELOAD_STAT_WSEG_START;
			wl->is   = 0;
		} else {                   /* Ct[I */
			wl->stat = WIRELOAD_STAT_WIRE_END;
		}
		break;

	case WIRELOAD_STAT_WSEG_END:
		if(strcasecmp(name, "wseg")) {
			DIE();
		}
		if(++wl->is < wl->w->ns) { /* ZOgp */
			wl->stat = WIRELOAD_STAT_WSEG_START;
		} else {                   /* Ct[I */
			wl->stat = WIRELOAD_STAT_WIRE_END;
		}
		break;

	default:
		DIE();
	}
}

WIRE*
//{{2008/08/10:ύX
//wire_load(const char* filename)
//2008/08/10:ύX
wire_load(const char* filename, int convert_fixed)
//}}2008/08/10:ύX
{
	int result;
	int size;
	int done;
	FILE* fp;
	WIRELOAD* wl;
	WIRE* w;

	/* t@CJ܂B */
	fp = fopen(filename, "rt");
	if(!fp) {
		DIE();
	}

	/* WIRELOAD\̂̃mۂ܂B */
	wl = calloc(1, sizeof(WIRELOAD));
	if(!wl) {
		DIE();
	}

//{{2008/08/10:ǉ
	wl->convert_fixed = convert_fixed;
//}}2008/08/10:ǉ

	/* XMLp[T쐬܂B */
	wl->parser = XML_ParserCreate(NULL);
	if(!wl->parser) {
		DIE();
	}

	/* [Uf[^ݒ肵܂B */
	XML_SetUserData(wl->parser, wl);

	/* vfnhݒ肵܂B */
	XML_SetElementHandler(wl->parser, wire_load_start_element, wire_load_end_element);

	do {
		/* t@Cǂݍ݂܂B */
		size = fread(wl->buf, 1, WIRELOAD_BUFLEN, fp);

		/* t@CI[ɒBׂ܂B */
		done = feof(fp);

		/* ǂݍ񂾕p[X܂B */
		result = XML_Parse(wl->parser, wl->buf, size, done);
		if(result == XML_STATUS_ERROR) {
			DIE();
		}
	} while(!done); /* t@CI[ɒB܂ */

	/* Ct[Ŝ̃擾܂B */
	w = wl->w;

	/* XMLp[T폜܂B */
	XML_ParserFree(wl->parser);

	/* WIRELOAD\̂̃J܂B */
	free(wl);

	/* t@C܂B */
	fclose(fp);

	return w;
}

