/*	
 *	clipmt.c
 *
 *	ZkEcCX^[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2012 Naoyuki Sawa
 *
 *	* Thu Dec 06 17:08:54 JST 2012 Naoyuki Sawa
 *	- clipmisc.c 番܂B
 */
#include "clip.h"

/****************************************************************************
 *	ZkEcCX^[
 ****************************************************************************/

#ifndef PIECE
///* VvȎ */
//void MT_init(MT* self, unsigned s) {
//	self->mt[0] = s;
//	for(self->mti = 1; self->mti < MT_N; self->mti++) {
//		self->mt[self->mti]  = self->mt[self->mti - 1];
//		self->mt[self->mti] ^= self->mt[self->mti - 1] >> 30;
//		self->mt[self->mti] *= 1812433253;
//		self->mt[self->mti] += self->mti;
//	}
//}
//AZu鏀ƂāA܂B̓e͓łB
void MT_init(MT* self, unsigned s) {
	unsigned i;
	unsigned* p;

	self->mti = MT_N;
	p = self->mt;
	*p++ = s;
	i = 1;
	do {
		s ^= s >> 30;
		s *= 1812433253;
		s += i;
		*p++ = s;
	} while(++i != MT_N);
}
#else /*PIECE*/
void MT_init(MT* self, unsigned s);
asm("
		.code
		.align		1
		.global		MT_init
MT_init:
		;// %r12 := self
		;// %r13 := s
		xld.w		%r4, 624		;// %r4  := MT_N
		ld.w		[%r12]+, %r4		;// self->mti = MT_N, %r12 := p = self->mt
		ld.w		[%r12]+, %r13		;// *p++ = s
		ld.w		%r5, 1			;// %r5  := i = 1
		xld.w		%r6, 1812433253		;// %r6  := 1812433253
MT_init_LOOP_I:						;// do {
		;// %r4  := MT_N
		;// %r5  := i
		;// %r6  := 1812433253
		;// %r12 := self->mt
		;// %r13 := s
		ld.w		%r7, %r13		;//   %r7  :=      s
		xsrl		%r7, 30			;//   %r7  :=      s >> 30
		xor		%r13, %r7		;//   %r13 := s ^= s >> 30
		mltu.w		%r13, %r6		;//   %alr := s *= 1812433253
		ld.w		%r13, %alr		;//   %r13 := s
		add		%r13, %r5		;//   %r13 := s += i
		ld.w		[%r12]+, %r13		;//   *p++ = s
		add		%r5, 1			;//   %r5  := i++
		cmp		%r5, %r4		;// } while(i != MT_N)
		jrne		MT_init_LOOP_I
		ret
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
///* VvȎ */
//unsigned MT_int32(MT* self) {
//	unsigned x;
//	if(self->mti >= MT_N) {
//		for(self->mti = 0; self->mti < MT_N; self->mti++) {
//			x  = self->mt[ self->mti            ] & 0x80000000;
//			x |= self->mt[(self->mti + 1) % MT_N] & 0x7FFFFFFF;
//			self->mt[self->mti]  = self->mt[(self->mti + MT_M) % MT_N];
//			self->mt[self->mti] ^= x >> 1;
//			if(x & 1) self->mt[self->mti] ^= 0x9908B0DF;
//		}
//		self->mti = 0;
//	}
//	x  = self->mt[self->mti++];
//	x ^= (x >> 11);
//	x ^= (x <<  7) & 0x9D2C5680;
//	x ^= (x << 15) & 0xEFC60000;
//	x ^= (x >> 18);
//	return x;
//}
//AZu鏀ƂāA܂B̓e͓łB
unsigned MT_int32(MT* self) {
	unsigned i;
	unsigned x0;
	unsigned x1;
	unsigned xM;
	unsigned* p0;
	unsigned* p1;
	unsigned* pM;

	i = self->mti;
	if(i == MT_N) {
		p0 = &self->mt[0];
		p1 = &self->mt[1];
		pM = &self->mt[MT_M];
		do {
			x0 = *p0;
			x1 = *p1++;
			xM = *pM++;
			x0 &=      0x80000000;
			x0 |= x1 & 0x7FFFFFFF;
			xM ^= x0 >> 1;
			if(x0 & 1) xM ^= 0x9908B0DF;
			*p0++ = xM;
			if(p1 == &self->mt[MT_N]) p1 -= MT_N;
			if(pM == &self->mt[MT_N]) pM -= MT_N;
		} while(--i);
	}
	self->mti = i + 1;
	x0  = self->mt[i];
	x0 ^= (x0 >> 11);
	x0 ^= (x0 <<  7) & 0x9D2C5680;
	x0 ^= (x0 << 15) & 0xEFC60000;
	x0 ^= (x0 >> 18);
	return x0;
}
#else /*PIECE*/
unsigned MT_int32(MT* self);
asm("
		.code
		.align		1
		.global		MT_int32
MT_int32:
		;// %r12 := self
		ld.w		%r4, [%r12]		;// %r4  := i = self->mti
		xcmp		%r4, 624
		jrne		MT_int32_NEXT		;// if(i == MT_N) {
		;//-------------------------------------;//  
		add		%r12, 4			;//   %r12 := p0 = &self->mt[0]
		xadd		%r13, %r12, 4		;//   %r13 := p1 = &self->mt[1]
		xadd		%r14, %r12, 1588	;//   %r14 := pM = &self->mt[MT_M]
		xadd		%r15, %r12, 2496	;//   %r15 :=      &self->mt[MT_N]
		;// %r4  := i = MT_N
		;// %r12 := p0
		;// %r13 := p1
		;// %r14 := pM
		;// %r15 := &self->mt[MT_N]
MT_int32_LOOP:						;//   do {
		ld.w		%r5, [%r12]		;//     %r5  := x0 = *p0
		ld.w		%r6, [%r13]+		;//     %r6  := x1 = *p1++
		ld.w		%r7, [%r14]+		;//     %r7  := xM = *pM++
		;// %r4  := i
		;// %r5  := x0
		;// %r6  := x1
		;// %r7  := xM
		;// %r12 := p0
		;// %r13 := p1
		;// %r14 := pM
		;// %r15 := &self->mt[MT_N]
		add		%r5, %r5		;//     %psr(C)   :=                     x0[31]
		adc		%r6, %r6		;//     %r6[31:1] := x1[30:0], %r6[0] := x0[31]
		rr		%r6, 1			;//     %r6       := x0 = (x0 & 0x80000000) | (x1 & 0x7FFFFFFF)
		;//
		ld.w		%r5, %r6		;//     %r5  :=       x0
		srl		%r5, 1			;//     %r5  :=       x0 >> 1
		xor		%r7, %r5		;//     %r7  := xM ^= x0 >> 1
		;//
		and		%r6, 1
		jreq		MT_int32_X0_AND_1	;//     if(x0 & 1)
		xxor		%r7, %r7, 0x9908B0DF	;//       %r7  := xM ^= 0x9908B0DF
MT_int32_X0_AND_1:
		ld.w		[%r12]+, %r7		;//     *p0++ = xM
		;//
		cmp		%r13, %r15
		jrne		MT_int32_P1_MT_N	;//     if(p1 == &self->mt[MT_N])
		xsub		%r13, %r13, 2496	;//       %r13 := p1 -= MT_N = &self->mt[0]
MT_int32_P1_MT_N:
		cmp		%r14, %r15
		jrne		MT_int32_PM_MT_N	;//     if(pM == &self->mt[MT_N])
		xsub		%r14, %r14, 2496	;//       %r14 := pM -= MT_N = &self->mt[0]
MT_int32_PM_MT_N:
		sub		%r4, 1			;//     %r4  := i--
		jrne		MT_int32_LOOP		;//   } while(i)
		;//
		xsub		%r12, %r12, 2500	;//   %r12 := self = p0 - (MT_N + 1)
		;// %r4  := i = 0
		;// %r12 := self
		;//-------------------------------------;//
MT_int32_NEXT:						;// }
		;// %r4  := i
		;// %r12 := self = &self->mt[-1]
		add		%r4, 1			;// %r4  :=     i + 1
		ld.w		[%r12], %r4		;// self->mti = i + 1
		;//
		sll		%r4, 2			;// %r4  :=                              (i + 1) * 4
		add		%r12, %r4		;// %r12 :=     &self->mt[i] = &self->mt[(i + 1) - 1]
		ld.w		%r10, [%r12]		;// %r10 := x0 = self->mt[i]
		;//
		ld.w		%r5, %r10		;// %r5  :=        x0		!INTERLOCK!
		xsrl		%r5, 11			;// %r5  :=       (x0 >> 11)
		xor		%r10, %r5		;// %r10 := x0 ^= (x0 >> 11)
		;//
		ld.w		%r5, %r10		;// %r5  :=        x0
		sll		%r5, 7			;// %r5  :=       (x0 <<  7)
		xand		%r5, %r5, 0x9D2C5680	;// %r5  :=       (x0 <<  7) & 0x9D2C5680
		xor		%r10, %r5		;// %r10 := x0 ^= (x0 <<  7) & 0x9D2C5680
		;//
		ld.w		%r5, %r10		;// %r5  :=        x0
		xsll		%r5, 15			;// %r5  :=       (x0 << 15)
		xand		%r5, %r5, 0xEFC60000	;// %r5  :=       (x0 << 15) & 0xEFC60000
		xor		%r10, %r5		;// %r10 := x0 ^= (x0 << 15) & 0xEFC60000
		;//
		ld.w		%r5, %r10		;// %r5  :=        x0
		xsrl		%r5, 18			;// %r5  :=       (x0 >> 18)
		ret.d
		xor		%r10, %r5		;// %r10 := x0 ^= (x0 >> 18)	*delay*
");
#endif /*PIECE*/

