/*	
 *	clipmou.h
 *
 *	VA}EXhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon May 31 05:44:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _MOUSEDRIVER {
	int ready;		/* }EXF1 */
	unsigned char buf[3];	/* Mobt@ */
	int len;		/* Mobt@̗LoCg */
	//
	int dx;			/* Omouse_get()ȍ~́Aړ */
	int dy;			/* Omouse_get()ȍ~́Aړ */
	int button;		/* ÓIȃ{^ (MOUSE_BUTTON(*)) */
	int trigger;		/* Omouse_get()ȍ~ɔgK (MOUSE_PRESS(*)AMOUSE_RELEASE(*)) */
} MOUSEDRIVER;
static MOUSEDRIVER mouse;

static void mouse_recv_callback();

/****************************************************************************
 *	
 ****************************************************************************/

int
mouse_open()
{
	int T0;

	/* ܂mɕ܂B */
	mouse_close();

	/* hCo\̂NA܂B */
	memset(&mouse, 0, sizeof mouse);

	/* VA|[gJ܂B */
	com_open(	/* }CN\tgvgRdl... */
		1200,	/* 1200 bits/sec   */
		0,	/* peB    */
		7,	/* 7f[^rbg   */
		1,	/* 1Xgbvrbg */
		0, 0, mouse_recv_callback, NULL);

	/* }EX̓d𗎂Ƃ܂B(}EXRTSMdĂ܂) */
	com_rts(0);

	/* mɓd悤A0.1bx҂܂B() */
	T0 = pceTimerGetCount();
	while(pceTimerGetCount() - T0 < 100) {
		/** no job **/
	}

	/* Ô߁AMobt@NA܂B */
	com_reset();

	/* }EX̓d܂B */
	com_rts(1);

	/* 14~bȓ'M'ė͂łB
	 * 'M'Mmouse_recv_callback()ready1ɂ̂ŁA܂ő҂܂B
	 * }EX̓dONɎԂ邩mȂ̂ŁAƒ߂0.5b܂ő҂Ƃɂ܂B
	 */
	T0 = pceTimerGetCount();
	while(pceTimerGetCount() - T0 < 500) {
		if(mouse.ready) break;
	}

	/* }EXFłȂ΁AN[AbvāAsԂ܂B */
	if(!mouse.ready) {
		mouse_close();
		return -1; /* s */
	}

	return 0; /*  */
}

void
mouse_close()
{
	/* mɃVA|[g܂B */
	com_close();

	/* mɃhCo\̂NA܂B */
	memset(&mouse, 0, sizeof mouse);
}

void
mouse_recv_callback()
{
	int retval;
	unsigned char v;
	int dx;
	int dy;
	int lb;
	int rb;

	for(;;) {
		/* Mobt@1oCgo܂B */
		retval = com_recv(&v, 1);

		/* Mf[^Ȃ΁Aɔ܂B */
		if(!retval) {
			break;
		}

		/* MG[Ȃ΁AZbgĔ܂Bȍ~͒ʏ폈𑱂܂B */
		if(retval < 0) {
			com_reset();
			break;
		}

		/* ȍ~́A܎o1oCgf[^̏łB */

		/*** }EXF܂ ***/
		if(!mouse.ready) {
			/* d'M'MA}EXFOKłB */
			if((char)v == 'M') {
				mouse.ready = 1;
			}

		/*** }EXFς ***/
		} else {
			/* }CN\tgvgR̃pPbg`͎̂ƂłB
			 *
			 *	rbgԍ: [6] [5] [4] [3] [2] [1] [0]
			 *	PoCg:  1   lb  rb dy7 dy6 dx7 dx6
			 *	QoCg:  0  dx5 dx4 dx3 dx2 dx1 dx0
			 *	RoCg:  0  dy5 dy4 dy3 dy2 dy1 dy0
			 *
 			 *	lb: {^
 			 *	rb: E{^
 			 *	dx: ړ
 			 *	dy: ړ
 			 */
			if(v & 0x40) {
				/* bit6=1̃f[^MAI1oCgڂɊi[܂B
				 * ɉoCgMĂꍇA̓S~ƂĔj܂B
				 */
				mouse.buf[0] = v;
				mouse.len = 1;
			} else {
				/* bit6=0̃f[^MA2or3oCgڂƂĊi[܂B
				 * ܂1oCgڂMĂȂ΁Ãf[^̓S~ƂĔj܂B
				 */
				if(mouse.len) {
					mouse.buf[mouse.len++] = v;
					if(mouse.len == 3) { /* pPbg */
						dx = (char)((mouse.buf[0] & 0x03) << 6 | (mouse.buf[1] & 0x3f));
						dy = (char)((mouse.buf[0] & 0x0c) << 4 | (mouse.buf[2] & 0x3f));
						lb = mouse.buf[0] & 0x20;
						rb = mouse.buf[0] & 0x10;

						if(!dx && !dy &&
						   ((lb && (mouse.button & MOUSE_BUTTON(0))) || (!lb && !(mouse.button & MOUSE_BUTTON(0)))) &&
						   ((rb && (mouse.button & MOUSE_BUTTON(1))) || (!rb && !(mouse.button & MOUSE_BUTTON(1))))) {
							/* ړʃ[Ń{^ԂωȂA{^̃gOʒmłB
							 * }EXړȂ璆{^/JƁAړʃAɂȂĂ܂悤łB
							 *   Ȃ킿A{^̃gOʒmƂĔʂł郁bZ[WĂ܂܂B
							 *   @słEEE(Sysgration uMOUSE 700v FCC ID: HQXPC93010-12 ɂĊmF)
							 */
							if(mouse.button & MOUSE_BUTTON(2)) {
								mouse.button &= ~MOUSE_BUTTON(2);
								mouse.trigger |= MOUSE_RELEASE(2);
							} else {
								mouse.button |= MOUSE_BUTTON(2);
								mouse.trigger |= MOUSE_PRESS(2);
							}
						} else {
							/* Ȃ΁Aʏ̃}EXړ܂͍E{^EJʒmłB */
							mouse.dx += dx;
							mouse.dy += dy;
							if(lb) {
								if(!(mouse.button & MOUSE_BUTTON(0))) {
									mouse.button |= MOUSE_BUTTON(0);
									mouse.trigger |= MOUSE_PRESS(0);
								}
							} else {
								if(mouse.button & MOUSE_BUTTON(0)) {
									mouse.button &= ~MOUSE_BUTTON(0);
									mouse.trigger |= MOUSE_RELEASE(0);
								}
							}
							if(rb) {
								if(!(mouse.button & MOUSE_BUTTON(1))) {
									mouse.button |= MOUSE_BUTTON(1);
									mouse.trigger |= MOUSE_PRESS(1);
								}
							} else {
								if(mouse.button & MOUSE_BUTTON(1)) {
									mouse.button &= ~MOUSE_BUTTON(1);
									mouse.trigger |= MOUSE_RELEASE(1);
								}
							}
						}

						mouse.len = 0; /* YȂ!! */
					}
				}
			}
		}
	}
}

void
mouse_get(int* dx, int* dy, int* button)
{
ENTER_CS;
	if(dx) *dx = mouse.dx;
	if(dy) *dy = mouse.dy;
	if(button) *button = mouse.button | mouse.trigger;

	mouse.dx = 0;
	mouse.dy = 0;
	//mouse.button̓NA܂!!
	mouse.trigger = 0;
LEAVE_CS;
}
