/*	
 *	clipm68i.c
 *
 *	P/ECE M6800 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipm68i.h"	/*M6800G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/* ߂܂B
 */
M6800FN_(ERR_INHERENT)
{
	switch(code) {
	/*{{from MAME 0.67 src/cpu/m6800/6800dasm.c*/
	case 0x12: /* Undoc'd HD63701YO opcode $12 'asx1' */
	case 0x13: /* Undoc'd HD63701YO opcode $13 'asx2' */
		/* Add contents of stack to x register. */
		X += READ(S + 1);
		return;
	}
	/*}}from MAME 0.67 src/cpu/m6800/6800dasm.c*/
	DIE();
}

/****************************************************************************
 *
 ****************************************************************************/

#ifndef M6800_ASM

/* !!
 * HalfCarryω̂́AAL[^Ώۂ8bitZłB
 *	ABA
 *	ADDA, ADDB
 *	ADCA, ADCB
 * ȊO̖߂łHalfCarry͕ω܂B
 */

int m6800_ADD(M6800* m6800, int a, int b) {
	int tmp = a + b;
	CC = (CC & ~0x2f) |
	     ((((a & 0xf) + (b & 0xf)) & 0x10) << 1) |		/* H */
	     ((tmp >> 4) & 8) |					/* N */
	     (!(tmp & 0xff) << 2) |				/* Z */
	     (((~(a ^ b) & (a ^ tmp)) >> 6) & 2) |		/* V */
	     ((tmp >> 8) & 1);					/* C */
	return tmp & 0xff;
}

int m6800_ADC(M6800* m6800, int a, int b) {
	int c = CC & 1;
	int tmp = a + b + c;
	CC = (CC & ~0x2f) |
	     ((((a & 0xf) + (b & 0xf) + c) & 0x10) << 1) |	/* H */
	     ((tmp >> 4) & 8) |					/* N */
	     (!(tmp & 0xff) << 2) |				/* Z */
	     (((~(a ^ b) & (a ^ tmp)) >> 6) & 2) |		/* V */
	     ((tmp >> 8) & 1);					/* C */
	return tmp & 0xff;
}

int m6800_SUB(M6800* m6800, int a, int b) {
	int tmp = a - b;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!(tmp & 0xff) << 2) |				/* Z */
	     ((((a ^ b) & (a ^ tmp)) >> 6) & 2) |		/* V */
	     ((tmp >> 8) & 1);					/* C */
	return tmp & 0xff;
}

int m6800_SBC(M6800* m6800, int a, int b) {
	int c = CC & 1;
	int tmp = a - b - c;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!(tmp & 0xff) << 2) |				/* Z */
	     ((((a ^ b) & (a ^ tmp)) >> 6) & 2) |		/* V */
	     ((tmp >> 8) & 1);					/* C */
	return tmp & 0xff;
}

int m6800_ADDW(M6800* m6800, int a, int b) {
	int tmp = a + b;
	CC = (CC & ~0xf) |
	     ((tmp >> 12) & 8) |				/* N */
	     (!(tmp & 0xffff) << 2) |				/* Z */
	     (((~(a ^ b) & (a ^ tmp)) >> 14) & 2) |		/* V */
	     ((tmp >> 16) & 1);					/* C */
	return tmp & 0xffff;
}

int m6800_SUBW(M6800* m6800, int a, int b) {
	int tmp = a - b;
	CC = (CC & ~0xf) |
	     ((tmp >> 12) & 8) |				/* N */
	     (!(tmp & 0xffff) << 2) |				/* Z */
	     ((((a ^ b) & (a ^ tmp)) >> 14) & 2) |		/* V */
	     ((tmp >> 16) & 1);					/* C */
	return tmp & 0xffff;
}

int m6800_AND(M6800* m6800, int a, int b) {
	a &= b;
	TEST(a);						/* N,Z,V */
	return a;
}

int m6800_ORA(M6800* m6800, int a, int b) {
	a |= b;
	TEST(a);						/* N,Z,V */
	return a;
}

int m6800_EOR(M6800* m6800, int a, int b) {
	a ^= b;
	TEST(a);						/* N,Z,V */
	return a;
}

int m6800_INC(M6800* m6800, int a) {
	a = (a + 1) & 0xff;
	CC = (CC & ~0xe) |
	     ((a >> 4) & 8) |					/* N */
	     (!a << 2) |					/* Z */
	     ((a == 0x80) << 1);				/* V */
	return a;
}

int m6800_DEC(M6800* m6800, int a) {
	a = (a - 1) & 0xff;
	CC = (CC & ~0xe) |
	     ((a >> 4) & 8) |					/* N */
	     (!a << 2) |					/* Z */
	     ((a == 0x7f) << 1);				/* V */
	return a;
}

int m6800_COM(M6800* m6800, int a) {
	a = ~a & 0xff;
	CC = (CC & ~0xf) |
	     ((a >> 4) & 8) |					/* N */
	     (!a << 2) |					/* Z */
								/* V */
	     1;							/* C */
	return a;
}

int m6800_NEG(M6800* m6800, int a) {
	a = (~a + 1) & 0xff;
	CC = (CC & ~0xf) |
	     ((a >> 4) & 8) |					/* N */
	     ((a == 0x80) << 1);				/* V */
	if(!a) CC |= 5;						/* Z,C(dlA{!?) */
	return a;
}

void m6800_TST(M6800* m6800, int a) {
	CC = (CC & ~0xf) |
	     ((a >> 4) & 8) |					/* N */
	     (!a << 2);						/* Z */
								/* V */
								/* C */
}

#endif /*M6800_ASM*/

int m6800_ASL(M6800* m6800, int a) {
	int tmp = (a << 1) & 0xff;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!tmp << 2) |					/* Z */
	     ((a >> 7) & 1);					/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

int m6800_ASR(M6800* m6800, int a) {
	int tmp = ((char)a >> 1) & 0xff;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!tmp << 2) |					/* Z */
	     (a & 1);						/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

int m6800_LSR(M6800* m6800, int a) {
	int tmp = a >> 1;
	CC = (CC & ~0xf) |
								/* N */
	     (!tmp << 2) |					/* Z */
	     (a & 1);						/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

int m6800_ROL(M6800* m6800, int a) {
	int tmp = ((a << 1) | (CC & 1)) & 0xff;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!tmp << 2) |					/* Z */
	     ((a >> 7) & 1);					/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

int m6800_ROR(M6800* m6800, int a) {
	int tmp = ((a >> 1) | (CC << 7)) & 0xff;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!tmp << 2) |					/* Z */
	     (a & 1);						/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

/*  */
int m6800_ASLW(M6800* m6800, int a) {
	int tmp = (a << 1) & 0xffff;
	CC = (CC & ~0xf) |
	     ((tmp >> 12) & 8) |				/* N */
	     (!tmp << 2) |					/* Z */
	     ((a >> 15) & 1);					/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

/*  */
int m6800_LSRW(M6800* m6800, int a) {
	int tmp = a >> 1;
	CC = (CC & ~0xf) |
								/* N */
	     (!tmp << 2) |					/* Z */
	     (a & 1);						/* C */
	CC |= ((CC >> 2) ^ (CC << 1)) & 2;			/* V=N^C(dl) */
	return tmp;
}

/****************************************************************************
 *	ACCUMULATOR AND MEMORY
 ****************************************************************************/

#ifndef M6800_ASM

M6800FN_(ABA_INHERENT) { A = ADD(A, B); }
M6800FN_(ADDA_DATA)    { A = ADD(A, arg); }
M6800FN_(ADDB_DATA)    { B = ADD(B, arg); }
M6800FN_(ADDA_ADDRESS) { A = ADD(A, READ(arg)); }
M6800FN_(ADDB_ADDRESS) { B = ADD(B, READ(arg)); }

M6800FN_(ADCA_DATA)    { A = ADC(A, arg); }
M6800FN_(ADCB_DATA)    { B = ADC(B, arg); }
M6800FN_(ADCA_ADDRESS) { A = ADC(A, READ(arg)); }
M6800FN_(ADCB_ADDRESS) { B = ADC(B, READ(arg)); }

M6800FN_(SBA_INHERENT) { A = SUB(A, B); }
M6800FN_(SUBA_DATA)    { A = SUB(A, arg); }
M6800FN_(SUBB_DATA)    { B = SUB(B, arg); }
M6800FN_(SUBA_ADDRESS) { A = SUB(A, READ(arg)); }
M6800FN_(SUBB_ADDRESS) { B = SUB(B, READ(arg)); }

M6800FN_(SBCA_DATA)    { A = SBC(A, arg); }
M6800FN_(SBCB_DATA)    { B = SBC(B, arg); }
M6800FN_(SBCA_ADDRESS) { A = SBC(A, READ(arg)); }
M6800FN_(SBCB_ADDRESS) { B = SBC(B, READ(arg)); }

M6800FN_(CBA_INHERENT) { SUB(A, B); }
M6800FN_(CMPA_DATA)    { SUB(A, arg); }
M6800FN_(CMPB_DATA)    { SUB(B, arg); }
M6800FN_(CMPA_ADDRESS) { SUB(A, READ(arg)); }
M6800FN_(CMPB_ADDRESS) { SUB(B, READ(arg)); }

M6800FN_(ANDA_DATA)    { A = AND(A, arg); }
M6800FN_(ANDB_DATA)    { B = AND(B, arg); }
M6800FN_(ANDA_ADDRESS) { A = AND(A, READ(arg)); }
M6800FN_(ANDB_ADDRESS) { B = AND(B, READ(arg)); }

M6800FN_(ORAA_DATA)    { A = ORA(A, arg); }
M6800FN_(ORAB_DATA)    { B = ORA(B, arg); }
M6800FN_(ORAA_ADDRESS) { A = ORA(A, READ(arg)); }
M6800FN_(ORAB_ADDRESS) { B = ORA(B, READ(arg)); }

M6800FN_(EORA_DATA)    { A = EOR(A, arg); }
M6800FN_(EORB_DATA)    { B = EOR(B, arg); }
M6800FN_(EORA_ADDRESS) { A = EOR(A, READ(arg)); }
M6800FN_(EORB_ADDRESS) { B = EOR(B, READ(arg)); }

M6800FN_(INCA_INHERENT) { A = INC(A); }
M6800FN_(INCB_INHERENT) { B = INC(B); }
M6800FN_(INC_ADDRESS)   { WRITE(arg, INC(READ(arg))); }

M6800FN_(DECA_INHERENT) { A = DEC(A); }
M6800FN_(DECB_INHERENT) { B = DEC(B); }
M6800FN_(DEC_ADDRESS)   { WRITE(arg, DEC(READ(arg))); }

M6800FN_(COMA_INHERENT) { A = COM(A); }
M6800FN_(COMB_INHERENT) { B = COM(B); }
M6800FN_(COM_ADDRESS)   { WRITE(arg, COM(READ(arg))); }

M6800FN_(NEGA_INHERENT) { A = NEG(A); }
M6800FN_(NEGB_INHERENT) { B = NEG(B); }
M6800FN_(NEG_ADDRESS)   { WRITE(arg, NEG(READ(arg))); }

M6800FN_(TAB_INHERENT) { B = A; TEST(B); }
M6800FN_(TBA_INHERENT) { A = B; TEST(A); }

M6800FN_(LDAA_DATA)    { A = arg;       TEST(A); }
M6800FN_(LDAB_DATA)    { B = arg;       TEST(B); }
M6800FN_(LDAA_ADDRESS) { A = READ(arg); TEST(A); }
M6800FN_(LDAB_ADDRESS) { B = READ(arg); TEST(B); }

M6800FN_(STAA_ADDRESS) { WRITE(arg, A); TEST(A); }
M6800FN_(STAB_ADDRESS) { WRITE(arg, B); TEST(B); }

M6800FN_(BITA_DATA)    { AND(A, arg); }
M6800FN_(BITB_DATA)    { AND(B, arg); }
M6800FN_(BITA_ADDRESS) { AND(A, READ(arg)); }
M6800FN_(BITB_ADDRESS) { AND(B, READ(arg)); }

M6800FN_(TSTA_INHERENT) { TST(A); }
M6800FN_(TSTB_INHERENT) { TST(B); }
M6800FN_(TST_ADDRESS)   { TST(READ(arg)); }

M6800FN_(CLRA_INHERENT) { A = 0;         CC = (CC & ~0xf) | 4; }
M6800FN_(CLRB_INHERENT) { B = 0;         CC = (CC & ~0xf) | 4; }
M6800FN_(CLR_ADDRESS)   { WRITE(arg, 0); CC = (CC & ~0xf) | 4; }

M6800FN_(ROLA_INHERENT) { A = ROL(A); }
M6800FN_(ROLB_INHERENT) { B = ROL(B); }
M6800FN_(ROL_ADDRESS)   { WRITE(arg, ROL(READ(arg))); }

M6800FN_(RORA_INHERENT) { A = ROR(A); }
M6800FN_(RORB_INHERENT) { B = ROR(B); }
M6800FN_(ROR_ADDRESS)   { WRITE(arg, ROR(READ(arg))); }

M6800FN_(ASLA_INHERENT) { A = ASL(A); }
M6800FN_(ASLB_INHERENT) { B = ASL(B); }
M6800FN_(ASL_ADDRESS)   { WRITE(arg, ASL(READ(arg))); }

M6800FN_(ASRA_INHERENT) { A = ASR(A); }
M6800FN_(ASRB_INHERENT) { B = ASR(B); }
M6800FN_(ASR_ADDRESS)   { WRITE(arg, ASR(READ(arg))); }

M6800FN_(LSRA_INHERENT) { A = LSR(A); }
M6800FN_(LSRB_INHERENT) { B = LSR(B); }
M6800FN_(LSR_ADDRESS)   { WRITE(arg, LSR(READ(arg))); }

M6800FN_(PSHA_INHERENT) { PUSH(A); }
M6800FN_(PSHB_INHERENT) { PUSH(B); }

M6800FN_(PULA_INHERENT) { PULL(A); }
M6800FN_(PULB_INHERENT) { PULL(B); }

#endif /*M6800_ASM*/

/*  */
M6800FN_(DAA_INHERENT) {
	/* 6800 CPU emulator written by Larry Bank */
	/* Copyright 1998 BitBank Software, Inc.   */
	/* ̕@قڂ̂܂܎g킹Ē܂B*/
	/* 肪Ƃ܂B                  */
	int a = A;
	int b = 0;
	int hi = A & 0xf0;
	int lo = A & 0x0f;
	int tmp;
	if((lo > 0x09) || (CC & 0x20)) b |= 0x06;
	if((hi > 0x80) && (lo > 0x09)) b |= 0x60;
	if((hi > 0x90) || (CC & 0x01)) b |= 0x60;
	tmp = a + b;
	CC = (CC & ~0xf) |
	     ((tmp >> 4) & 8) |					/* N */
	     (!(tmp & 0xff) << 2) |				/* Z */
	     (((~(a ^ b) & (a ^ tmp)) >> 6) & 2) |		/* V */
	     ((tmp >> 8) & 1);					/* C */
	A = tmp;
}

/****************************************************************************
 *	INDEX REGISTER AND STACK
 ****************************************************************************/

M6800FN_(CPX_DATA)    { SUBW(X, arg); }
M6800FN_(CPX_ADDRESS) { SUBW(X, READW(arg)); }

M6800FN_(DEX_INHERENT) { X--; CC = (CC & ~4) | (!X << 2); }
M6800FN_(DES_INHERENT) { S--; } /* tOωȂ!! */

M6800FN_(INX_INHERENT) { X++; CC = (CC & ~4) | (!X << 2); }
M6800FN_(INS_INHERENT) { S++; } /* tOωȂ!! */

M6800FN_(LDX_DATA)    { X = arg;        TESTW(X); }
M6800FN_(LDS_DATA)    { S = arg;        TESTW(S); }
M6800FN_(LDX_ADDRESS) { X = READW(arg); TESTW(X); }
M6800FN_(LDS_ADDRESS) { S = READW(arg); TESTW(S); }

M6800FN_(STX_ADDRESS) { WRITEW(arg, X); TESTW(X); }
M6800FN_(STS_ADDRESS) { WRITEW(arg, S); TESTW(S); } /* tOω!! */

M6800FN_(TXS_INHERENT) { S = X - 1; }
M6800FN_(TSX_INHERENT) { X = S + 1; }

/****************************************************************************
 *	JUMP AND BRANCH
 ****************************************************************************/

#ifndef M6800_ASM

M6800FN_(JMP_ADDRESS) { PC = arg; }
M6800FN_(BRA_ADDRESS) { PC = arg; }
M6800FN_(JSR_ADDRESS) { PUSHW(PC); PC = arg; }
M6800FN_(BSR_ADDRESS) { PUSHW(PC); PC = arg; }
M6800FN_(RTS_INHERENT) { PULLW(PC); }

M6800FN_(BCC_ADDRESS) { if(!(CC & 1)) PC = arg; }
M6800FN_(BCS_ADDRESS) { if( (CC & 1)) PC = arg; }
M6800FN_(BVC_ADDRESS) { if(!(CC & 2)) PC = arg; }
M6800FN_(BVS_ADDRESS) { if( (CC & 2)) PC = arg; }
M6800FN_(BNE_ADDRESS) { if(!(CC & 4)) PC = arg; }
M6800FN_(BEQ_ADDRESS) { if( (CC & 4)) PC = arg; }
M6800FN_(BPL_ADDRESS) { if(!(CC & 8)) PC = arg; }
M6800FN_(BMI_ADDRESS) { if( (CC & 8)) PC = arg; }
M6800FN_(BGE_ADDRESS) { if(             !(((CC >> 2) ^ CC) & 2)) PC = arg; } /*       !(N^V) */
M6800FN_(BLT_ADDRESS) { if(              (((CC >> 2) ^ CC) & 2)) PC = arg; } /*        (N^V) */
M6800FN_(BGT_ADDRESS) { if(!(CC & 4) && !(((CC >> 2) ^ CC) & 2)) PC = arg; } /* !Z && !(N^V) */
M6800FN_(BLE_ADDRESS) { if( (CC & 4) ||  (((CC >> 2) ^ CC) & 2)) PC = arg; } /*  Z ||  (N^V) */
M6800FN_(BHI_ADDRESS) { if(!(CC & 5)) PC = arg; } /* !Z && !C */
M6800FN_(BLS_ADDRESS) { if( (CC & 5)) PC = arg; } /*  Z ||  C */

#endif /*M6800_ASM*/

M6800FN_(NOP_INHERENT) { /** no job **/ }
M6800FN_(RTI_INHERENT) { m6800_rti(m6800); }
M6800FN_(SWI_INHERENT) { m6800_int(m6800, M6800_SWI_VECTOR); }
M6800FN_(WAI_INHERENT) { WAIT = 1; } /* {͊荞݂ɔăWX^ޔĂ~܂ */

/****************************************************************************
 *	CONDITIONS CODE REGISTER
 ****************************************************************************/

M6800FN_(SEC_INHERENT) { CC |= 1; }
M6800FN_(CLC_INHERENT) { CC &= ~1; }
M6800FN_(SEV_INHERENT) { CC |= 2; }
M6800FN_(CLV_INHERENT) { CC &= ~2; }
M6800FN_(SEI_INHERENT) { CC |= 0x10; }
M6800FN_(CLI_INHERENT) {
	CC &= ~0x10;			/* CC(I) 1:֎~0: ɕω\ */
	m6800_check_pending(m6800);	/* YȂ!! */
}

M6800FN_(TPA_INHERENT) { A = CC; }
M6800FN_(TAP_INHERENT) {
	CC = A;				/* CC(I) 1:֎~0: ɕω\ */
	CC |= 0xc0;			/* CC[7:6]=11Œ */
	m6800_check_pending(m6800);	/* YȂ!! */
}

/****************************************************************************
 *	M6801/03 EXTENDED
 ****************************************************************************/

/*  */

M6800FN_(LDD_DATA)    { D = arg;        TESTW(D); }
M6800FN_(LDD_ADDRESS) { D = READW(arg); TESTW(D); }
M6800FN_(STD_ADDRESS) { WRITEW(arg, D); TESTW(D); }

M6800FN_(ADDD_DATA)    { D = ADDW(D, arg); }
M6800FN_(SUBD_DATA)    { D = SUBW(D, arg); }
M6800FN_(ADDD_ADDRESS) { D = ADDW(D, READW(arg)); }
M6800FN_(SUBD_ADDRESS) { D = SUBW(D, READW(arg)); }

M6800FN_(ASLD_INHERENT) { D = ASLW(D); }
M6800FN_(LSRD_INHERENT) { D = LSRW(D); }
M6800FN_(MUL_INHERENT) {
	D = A * B;
	CC = (CC & ~1) |
	     ((D >> 7) & 1);	/* ʂbit7L[tOɔfƂdl */
}

M6800FN_(ABX_INHERENT)  { X += B; }
M6800FN_(PSHX_INHERENT) { PUSHW(X); }
M6800FN_(PULX_INHERENT) { PULLW(X); }

M6800FN_(BRN_ADDRESS) { /** no job **/ }

/****************************************************************************
 *	HD6301/03 EXTENDED
 ****************************************************************************/

/*  */

/* AIM/OIM/EIM/TIM͓̃p[^邽߁AM6800̊̃AhbVO[hɓĂ͂܂܂B
 * ̒ǉ߂̂߂ɖߏ֐̈𑝂₷͔̂̂ŁAᏈƂ܂B
 * 2oCgImmediateAhbVO[hƌȂăe[u쐬Ă܂B
 * (m6800.xlsVBAvÕRgQƂĂB)
 * ߏ֐Ŗ{̃AhbVO[h𔻒fAK؂ɏ܂B
 */
M6800FN_(AIM_DATA) {
	unsigned char  data = arg >> 8;   /* 1oCg */
	unsigned short addr = arg & 0xff; /* 2oCg */
	if(code & 0x10) { /* $71: Direct address */
		/** no job **/
	} else { /* $61: Indexed address */
		addr += X;
	}
	WRITE(addr, AND(READ(addr), data));
}
M6800FN_(OIM_DATA) {
	unsigned char  data = arg >> 8;   /* 1oCg */
	unsigned short addr = arg & 0xff; /* 2oCg */
	if(code & 0x10) { /* $72: Direct address */
		/** no job **/
	} else { /* $62: Indexed address */
		addr += X;
	}
	WRITE(addr, ORA(READ(addr), data));
}
M6800FN_(EIM_DATA) {
	unsigned char  data = arg >> 8;   /* 1oCg */
	unsigned short addr = arg & 0xff; /* 2oCg */
	if(code & 0x10) { /* $75: Direct address */
		/** no job **/
	} else { /* $65: Indexed address */
		addr += X;
	}
	WRITE(addr, EOR(READ(addr), data));
}
M6800FN_(TIM_DATA) {
	unsigned char  data = arg >> 8;   /* 1oCg */
	unsigned short addr = arg & 0xff; /* 2oCg */
	if(code & 0x10) { /* $7B: Direct address */
		/** no job **/
	} else { /* $6B: Indexed address */
		addr += X;
	}
	AND(READ(addr), data);
}

M6800FN_(XGDX_INHERENT) { unsigned short tmp = D; D = X; X = tmp; }

M6800FN_(SLP_INHERENT) { DIE(); } /* RESET܂Œ~B܂gȂ͂łB */

/****************************************************************************
 *
 ****************************************************************************/

