/*	
 *	cliplzss.c
 *
 *	LZSSWJ[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Thu Sep 10 00:42:56 JST 2009 Naoyuki Sawa
 *	- VK쐬B
 *	* Sun Jul 07 18:34:29 JST 2013 Naoyuki Sawa
 *	- LZSS_1ALZSS_1_init()ALZSS_1_get()ǉ܂B
 *	- LZSS_2ALZSS_2_init()ALZSS_2_get()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

int
lzss_uncompress1(void* _dst_data/*[dst_lim]*/, int dst_lim, const void* _src_data/*[src_len]*/, int src_len)
{
	      unsigned char* dst_data = _dst_data;
	const unsigned char* src_data = _src_data;

	/*{{͈̔͂́Alzss_uncompress1lzss_uncompress2ƂŁAقڋʂ̏*/
	int flag_mask = 0;
	int flag = 0;
	int dst_len = 0;
	int src_pos = 0;
	int hdr;
	int len;
	int dist;
	int pos;
	while(src_pos < src_len) {
		/* tO擾 */
		if(!flag_mask) {
			flag_mask = 1 << 7;	/*{{lzss_uncompress1lzss_uncompress2ƂŁAႤ̂͂}}*/
			flag = src_data[src_pos++];
		}
		/* kR[h̏ꍇ */
		if(!(flag & flag_mask)) {
			/* kR[h {(match_dist-1),(match_len-2)} 擾 */
			hdr = src_data[src_pos++];
			len = (hdr & 15) + 2;
			dist = (hdr >> 4) + 1;
			/* kR[hWJ */
			pos = dst_len - dist;
			do {
				if(dst_len < dst_lim) {
					dst_data[dst_len] = dst_data[pos];
				}
				dst_len++;
				pos++;
			} while(--len);
		/* kR[h̏ꍇ */
		} else {
			/* kR[ho͂ */
			if(dst_len < dst_lim) {
				dst_data[dst_len] = src_data[src_pos];
			}
			dst_len++;
			src_pos++;
		}
		/* tOrbgʒui߂ */
		flag_mask >>= 1;
	}
	/*}}͈̔͂́Alzss_uncompress1lzss_uncompress2ƂŁAقڋʂ̏*/

	return dst_len;
}

/*--------------------------------------------------------------------------*/

int
lzss_uncompress2(void* _dst_data/*[dst_lim]*/, int _dst_lim, const void* _src_data/*[src_len]*/, int _src_len)
{
	      unsigned short* dst_data = _dst_data;
	const unsigned short* src_data = _src_data;
	int dst_lim = _dst_lim >> 1; /* n[t[hPʂɕϊBꍇ́AꎞIɒ[؂̂ĂĂ */
	int src_len = _src_len >> 1; /* n[t[hPʂɕϊBꍇ́AꎞIɒ[؂̂ĂĂ */

	/*{{͈̔͂́Alzss_uncompress1lzss_uncompress2ƂŁAقڋʂ̏*/
	int flag_mask = 0;
	int flag = 0;
	int dst_len = 0;
	int src_pos = 0;
	int hdr;
	int len;
	int dist;
	int pos;
	while(src_pos < src_len) {
		/* tO擾 */
		if(!flag_mask) {
			flag_mask = 1 << 15;	/*{{lzss_uncompress1lzss_uncompress2ƂŁAႤ̂͂}}*/
			flag = src_data[src_pos++];
		}
		/* kR[h̏ꍇ */
		if(!(flag & flag_mask)) {
			/* kR[h {(match_dist-1),(match_len-2)} 擾 */
			hdr = src_data[src_pos++];
			len = (hdr & 15) + 2;
			dist = (hdr >> 4) + 1;
			/* kR[hWJ */
			pos = dst_len - dist;
			do {
				if(dst_len < dst_lim) {
					dst_data[dst_len] = dst_data[pos];
				}
				dst_len++;
				pos++;
			} while(--len);
		/* kR[h̏ꍇ */
		} else {
			/* kR[ho͂ */
			if(dst_len < dst_lim) {
				dst_data[dst_len] = src_data[src_pos];
			}
			dst_len++;
			src_pos++;
		}
		/* tOrbgʒui߂ */
		flag_mask >>= 1;
	}
	/*}}͈̔͂́Alzss_uncompress1lzss_uncompress2ƂŁAقڋʂ̏*/

	/* ̓f[^oCgꍇ́A̓f[^̒[oCgÂ܂܏o̓f[^̖ɒǉ */
	dst_len <<= 1; /* oCgPʂɕϊ */
	if(_src_len/*oCgP*/ & 1) {
		if(dst_len/*oCgP*/ < _dst_lim/*oCgP*/) {
			((unsigned char*)_dst_data)[dst_len/*oCgP*/] = ((const unsigned char*)_src_data)[_src_len/*oCgP*/ - 1];
		}
		dst_len++; /* oCgP */
	}
	return dst_len; /* oCgP */
}

/****************************************************************************
 *	
 ****************************************************************************/

void LZSS_1_init(LZSS_1* self, const void* data) {
	self->data      = data;		/* K{ */
	self->flag_mask = 0;		/* NAK{ */
	self->flag      = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBɕK擾B */
	self->len       = 0;		/* NAK{ */
	self->dist      = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBkR[h̊JnɕK擾B */
	self->pos       = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBۂɂ͂ǂL^JnĂǂB */
//	memset(self->dic, 0, sizeof self->dic);	/* NAsvBkf[^Ȃ΁A܂li[ĂȂӏ͎QƂȂ͂BԂZk邽߂ɁANAȂƂɂB */
}

unsigned char LZSS_1_get(LZSS_1* self) {
	unsigned char val;
	unsigned char hdr;
	/* tO𖢎擾Ȃ΁c */
	if(!self->flag_mask) {
		/* tO擾 */
		self->flag_mask = 1 << 7;
		self->flag = *self->data++;
	}
	/* kR[h̏ꍇ */
	if(!(self->flag & self->flag_mask)) {
		/* kR[h𖢎擾Ȃ΁c */
		if(!self->len) {
			/* kR[h {(match_dist-1),(match_len-2)} 擾 */
			hdr = *self->data++;
			self->len  = (hdr & 15) + 2;
			self->dist = (hdr >> 4) + 1;
		}
		/* kR[hWJ */
		val = self->dic[(self->pos - self->dist) & 15];
		/* kR[h̓WJc */
		if(!--self->len) {
			/* tOʒu֐i߂ */
			self->flag_mask >>= 1;
		}
	} else {
		/* kR[h擾 */
		val = *self->data++;
		/* tOʒu֐i߂ */
		self->flag_mask >>= 1;
	}
	/* lɋL^ */
	self->dic[self->pos++ & 15] = val;
	return val;
}

/*--------------------------------------------------------------------------*/

void LZSS_2_init(LZSS_2* self, const void* data) {
	self->data      = data;		/* K{ */
	self->flag_mask = 0;		/* NAK{ */
	self->flag      = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBɕK擾B */
	self->len       = 0;		/* NAK{ */
	self->dist      = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBkR[h̊JnɕK擾B */
	self->pos       = 0;		/* NAK{ł͂ȂAՂ̂߂ɃNAĂBۂɂ͂ǂL^JnĂǂB */
//	memset(self->dic, 0, sizeof self->dic);	/* NAsvBkf[^Ȃ΁A܂li[ĂȂӏ͎QƂȂ͂BԂZk邽߂ɁANAȂƂɂB */
}

unsigned short LZSS_2_get(LZSS_2* self) {
	unsigned short val;
	unsigned short hdr;
	/* tO𖢎擾Ȃ΁c */
	if(!self->flag_mask) {
		/* tO擾 */
		self->flag_mask = 1 << 15;
		self->flag = *self->data++;
	}
	/* kR[h̏ꍇ */
	if(!(self->flag & self->flag_mask)) {
		/* kR[h𖢎擾Ȃ΁c */
		if(!self->len) {
			/* kR[h {(match_dist-1),(match_len-2)} 擾 */
			hdr = *self->data++;
			self->len  = (hdr & 15) + 2;
			self->dist = (hdr >> 4) + 1;
		}
		/* kR[hWJ */
		val = self->dic[(self->pos - self->dist) & 4095];
		/* kR[h̓WJc */
		if(!--self->len) {
			/* tOʒu֐i߂ */
			self->flag_mask >>= 1;
		}
	} else {
		/* kR[h擾 */
		val = *self->data++;
		/* tOʒu֐i߂ */
		self->flag_mask >>= 1;
	}
	/* lɋL^ */
	self->dic[self->pos++ & 4095] = val;
	return val;
}

