/*	
 *	cliplzh.h
 *
 *	P/ECE LZH
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Apr 14 12:30:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_LZH_H__
#define __CLIP_LZH_H__

/****************************************************************************
 *	t@Cwb_
 ****************************************************************************/

#define LZHBYTE(p)	((unsigned char )(((unsigned char*)(p))[0]))
#define LZHHALF(p)	((unsigned short)(((unsigned char*)(p))[0] | ((unsigned char*)(p))[1] << 8))
#define LZHWORD(p)	((unsigned int  )(((unsigned char*)(p))[0] | ((unsigned char*)(p))[1] << 8 | ((unsigned char*)(p))[2] << 16 | ((unsigned char*)(p))[3] << 24))

/*
 *	x0wb_
 */
typedef struct _LZHLEVEL0HEADER {
	unsigned char header_size	[1];		// wb_̑傫(method_idȍ~)
	unsigned char header_sum	[1];		// wb_̃`FbNT(method_idȍ~)
							//-----------------------------------------------
	         char method_id		[5];		// k@̎					|
	unsigned char packed_size	[4];		// k̃t@CTCY			|
	unsigned char original_size	[4];		// ̃t@CTCY				|
	unsigned char time		[2];		// t@C̍ŏIXV			|
	unsigned char date		[2];		// t@C̍ŏIXV				|
	unsigned char attribute		[1];		// t@C̑				| header_size
	unsigned char level		[1];		// wb_̃x(0x00Œ)			|
	unsigned char name_length	[1];		// t@C̒				|
//	         char pathname		[name_length];	// t@C(tpX)			|
//	unsigned char file_crc		[2];		// t@CCRC-16				|
//	unsigned char ext_header	[...];		// g\					|
} LZHLEVEL0HEADER;					//-----------------------------------------------
//	unsigned char file_data		[packed_size];	// kf[^					| packed_size
							//-----------------------------------------------

/*
 *	x1wb_
 */
typedef struct _LZHLEVEL1HEADER {
	unsigned char header_size	[1];		// {wb_̑傫(method_idȍ~)
	unsigned char header_sum	[1];		// {wb_̃`FbNT(method_idȍ~)
							//-----------------------------------------------
	         char method_id		[5];		// k@̎					|
	unsigned char skip_size		[4];		// XLbvTCY				|
	unsigned char original_size	[4];		// ̃t@CTCY				|
	unsigned char time		[2];		// t@C̍ŏIXV			|
	unsigned char date		[2];		// t@C̍ŏIXV				|
	unsigned char reserved		[1];		// \tB[h(0x20Œ)			|
	unsigned char level		[1];		// wb_̃x(0x01Œ)			| header_size
	unsigned char name_length	[1];		// t@C̒(0ȂΊgwb_Q)	|
//	         char filename		[name_length];	// t@C(t@Ĉ)			|
//	unsigned char file_crc		[2];		// t@CCRC-16				|
//	unsigned char os_id		[1];		// ɂ쐬OS̎ʎq			|
//	unsigned char ext_header	[...];		// g\(x0wb_݊)		|
//	unsigned char next_header_size	[2];		// ŏ̊gwb_TCY			|
} LZHLEVEL1HEADER;					//-----------------------------------------------
//	LZHEXTHEADER ext-header		[...];		// gwb_					|
//	LZHEXTHEADER ext-header		[...];		//						|
//			.		  .		//						|
//			.		  .		//						| skip_size
//			.		  .		//						|
//	LZHEXTHEADER ext-header		[...];		//						|
//	unsigned char file_data		[...];		// kf[^					|
							//-----------------------------------------------

/*
 *	x2wb_
 */
typedef struct _LZHLEVEL2HEADER {			//-----------------------------------------------
	unsigned char total_header_size	[2];		// Swb_̑傫(total_header_size܂)	|
	         char method_id		[5];		// k@̎					|
	unsigned char packed_size	[4];		// k̃t@CTCY			|
	unsigned char original_size	[4];		// ̃t@CTCY				|
	unsigned char time		[4];		// t@C̍ŏIXV			|
	unsigned char reserved		[1];		// \tB[h(0x20Œ)			|
	unsigned char level		[1];		// wb_̃x(0x02Œ)			|
	unsigned char file_crc		[2];		// t@CCRC-16				|
	unsigned char os_id		[1];		// ɂ쐬OS̎ʎq			| total_header_size
	unsigned char next_header_size	[2];		// ŏ̊gwb_TCY			|
} LZHLEVEL2HEADER;					//						|
//	LZHEXTHEADER ext-header		[...];		// gwb_					|
//	LZHEXTHEADER ext-header		[...];		//						|
//			.		  .		//						|
//			.		  .		//						|
//			.		  .		//						|
//	LZHEXTHEADER ext-header		[...];		//						|
//	unsigned char padding		[0 or 1];	// pfBO(ꍇ܂)		|
//							//-----------------------------------------------
//	unsigned char file_data		[packed_size];	// kf[^					| packed_size
							//-----------------------------------------------

/*
 *	gwb_(x1Ax2)
 */
typedef struct _LZHEXTHEADER {
	unsigned char ext_type		[1];		/* ʎq */
//	unsigned char data		[...];		/* f[^ */
//	unsigned char next_header_size	[2];		/* ŏ̊gwb_TCY */
} LZHEXTHEADER;

/* LZHEXTHEADER.ext_type */
#define LZH_EXTTYPE_HEADER_CRC		0		/* wb_CRC-16 */
#define LZH_EXTTYPE_FILENAME		1		/* t@C */
#define LZH_EXTTYPE_DIRECTORY		2		/* fBNg */

/*
 *	x0`2wb_AKvȕo܂B
 */
typedef struct _LZHDIR {
	char pathname[128];		/* tpX */
	char method_id[5];		/* k@̎ */
	int packed_size;		/* k̃t@CTCY */
	int original_size;		/* ̃t@CTCY */
	int file_crc;			/* CRC-16 */
	const void* file_data;		/* kf[^AhX */
} LZHDIR;

/* `FbNTvZ܂B
 * [in]
 *	data		f[^擪AhXB
 *	len		f[^TCYB(oCgP)
 * [out]
 *	߂l		`FbNTԂ܂B
 * [note]
 *	* lzh_gethdr0()Alzh_gethdr1()痘p܂B
 */
int lzh_chksum(const void* data, int len);

/* LZHdlCRC-16vZ܂B
 * [in]
 *	data		f[^擪AhXB
 *	len		f[^TCYB(oCgP)
 * [out]
 *	߂l		CRC-16Ԃ܂B
 * [note]
 *	* LZHCRC-16́AʓICRC-16Ƃ͑قȂ܂B
 *	  LZHȊO̗prɂ͎gȂ悤łB
 */
int lzh_crc16(const void* data, int len);

/* t@Cr܂B
 * [in]
 *	s1,s2		rt@CB
 * [out]
 *	߂l		vA0Ԃ܂B
 *			vȂ΁A0ȊO̒lԂ܂B
 * [note]
 *	* t@C̑啶Ə͋ʂ܂B
 *	  ܂ApX"/""\"͋ʂ܂B
 *	* lzh_find()痘p܂B
 */
int lzh_strcmp(const char* s1, const char* s2);

/* gwb_ǂݍ݂܂B
 * [in]
 *	dir			t@Ci[LZHDIR\́B
 *	exthdr			ŏ̊gwb_̐擪AhXB
 *	next_header_size	ŏ̊gwb_TCYB
 *	filename		x1wb_痘pꍇA{wb_̃t@Cւ̃|C^B
 *				x2wb_痘pꍇANULLB
 *	filename_size		x1wb_痘pꍇA{wb_̃t@C̒
 *				x2wb_痘pꍇA0B
 * [out]
 *	߂l			Ȃ΁Agwb_̍vTCYԂ܂B
 *				sȂ΁A̒lԂ܂B
 *	dir->pathname		t@C(tpX)i[܂B
 * [note]
 *	* lzh_gethdr1()Alzh_gethdr2()痘p܂B
 */
int lzh_getexthdr(LZHDIR* dir, const void* exthdr, int next_header_size, const char* filename, int filename_size);

/* x0wb_ǂݍ݁At@C쐬܂B
 * [in]
 *	dir		t@Ci[LZHDIR\́B
 *	header		x0wb_ւ̃|C^B
 * [out]
 *	߂l		Ȃ΁Ã݂wb_玟̃wb_ւ̃ItZbgԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* lzh_dir()痘p܂B
 */
int lzh_gethdr0(LZHDIR* dir, const LZHLEVEL0HEADER* header);

/* x1wb_ǂݍ݁At@C쐬܂B
 * [in]
 *	dir		t@Ci[LZHDIR\́B
 *	header		x1wb_ւ̃|C^B
 * [out]
 *	߂l		Ȃ΁Awb_TCYԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* lzh_dir()痘p܂B
 */
int lzh_gethdr1(LZHDIR* dir, const LZHLEVEL1HEADER* header);

/* x2wb_ǂݍ݁At@C쐬܂B
 * [in]
 *	dir		t@Ci[LZHDIR\́B
 *	header		x2wb_ւ̃|C^B
 * [out]
 *	߂l		Ȃ΁Awb_TCYԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* lzh_dir()痘p܂B
 */
int lzh_gethdr2(LZHDIR* dir, const LZHLEVEL2HEADER* header);

/****************************************************************************
 *	o̓oCgXg[
 ****************************************************************************/

typedef struct _LZHBYTESTREAM {
	unsigned char* buffer;	/* obt@擪AhX */
	int len;		/* obt@TCY (byteP) */
	int pos;		/* ݈ʒu   (byteP) */
} LZHBYTESTREAM;

/* o̓oCgXg[܂B
 * [in]
 *	bytestream	LZHBYTESTREAM\́B
 *	buffer		o̓obt@̐擪AhXB
 *	len		o̓obt@TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int lzh_bytestream_init(LZHBYTESTREAM* out, void* buffer, int len);

/* 1oCg݂܂B
 * [in]
 *	bytestream	LZHBYTESTREAM\́B
 *	value		ރoCglB[7:0]
 *			[31:8]͎̂Ă܂B
 * [out]
 *	߂l		Ȃ΁A񂾃oCg(=1)Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 *	*out		ǂݍ񂾃oCgB
 */
int lzh_bytestream_put(LZHBYTESTREAM* out, int value);

/****************************************************************************
 *	̓rbgXg[
 ****************************************************************************/

typedef struct _LZHBITSTREAM {
	const unsigned char* data;	/* f[^擪AhX */
	int len;			/* f[^TCY (bitP) */
	int pos;			/* ǂݍ݈ʒu (bitP) */
} LZHBITSTREAM;

/* ̓rbgXg[܂B
 * [in]
 *	in		LZHBITSTREAM\́B
 *	data		̓f[^̐擪AhXB
 *	len		̓f[^TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int lzh_bitstream_init(LZHBITSTREAM* in, const void* data, int len);

/* rbgǂݍ݂܂B
 * [in]
 *	in		LZHBITSTREAM\́B
 *	out		ǂݍ񂾃rbgi[ϐւ̃|C^B
 *	cnt		ǂݍރrbgB(0`32)
 * [out]
 *	߂l		Ȃ΁Aǂݍ񂾃rbg(=bits)Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 *	*out		ǂݍ񂾃rbgB
 */
int lzh_bitstream_get(LZHBITSTREAM* in, int* out, int cnt);

/****************************************************************************
 *	񕪖 (binary tree)
 ****************************************************************************/

#define LZHBINARYTREE_MAXBITS	16		/* ̍őrbg(dl) */
#define LZHBINARYTREE_MAXVALUE	(256 + 256 - 3)	/* 蓖Ăl̍ől(dl) */

typedef struct _LZHBINARYTREE {
	unsigned short next[2];	/* [0]:bit=0̒T / [1]:bit=1̒T */
} LZHBINARYTREE;

/* LZHBINARYTREE.next[bit] */
#define LZHBINARYTREE_BLANK	((1 << 16) - 1)	/* LZHBINARYTREE.next[bit]󂫂ł邱Ƃ܂B */
#define LZHBINARYTREE_LEAF	(1 << (16 - 1))	/* LZHBINARYTREE.next[bit]̍ŏʃrbg1Ȃ΁AȊÕrbgl܂B */
						/* LZHBINARYTREE.next[bit]̍ŏʃrbg0Ȃ΁Ãm[hCfNX܂B */

/* 0`values-1̒lɕ蓖āA񕪖؂{Al}̃yAǉ܂B
 * [in]
 *	tree		LZHBINARYTREEzB
 *	len		LZHBINARYTREEz̗vfB
 *	code_bits	0`values-1̒lɑΉ镄̃rbgw肷zB(0`LZHBINARYTREE_MAXBITS)
 *	values		code_bitsz̗vfB(0`LZHBINARYTREE_MAXVALUE+1)
 * [out]
 *	߂l		gpLZHBINARYTREEz̗vfԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* ĂяoɂāAcode_bitsz̓eݒ肵ĂĂB
 */
int lzh_binarytree_init(LZHBINARYTREE tree[/*len*/], int len, const unsigned char code_bits[/*values*/], int values);

/* 񕪖؂{Al}̃yAǉ܂B
 * [in]
 *	tree		LZHBINARYTREEzB
 *	len		LZHBINARYTREEz̗vfB
 *	code		B
 *	code_bits	rbgB(1`LZHBINARYTREE_MAXBITS)
 *	value		lB(0`LZHBINARYTREE_MAXVALUE)
 * [out]
 *	߂l		ǉȂ΁Ali[m[h̃CfNXԂ܂B(0`len-1)
 *			ǉsȂ΁A̒lԂ܂B
 * [note]
 *	* lzh_binarytree_init()痘p܂B
 *	  AvP[VvO璼ڌĂяoƂ͂܂B
 */
int lzh_binarytree_add(LZHBINARYTREE tree[/*len*/], int len, int code, int code_bits, int value);

/* 񕪖؂畄ɑΉl܂B
 * [in]
 *	tree		LZHBINARYTREEzB
 *	len		LZHBINARYTREEz̗vfB
 *	in		ǂݍރrbgXg[B
 *	out		li[邽߂̕ϐւ̃|C^B
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			ȂȂ΁A̒lԂ܂B
 *	*out		lB
 */
int lzh_binarytree_lookup(LZHBINARYTREE tree[/*len*/], int len, LZHBITSTREAM* in, int* out);

/****************************************************************************
 *	-lh5-^Cv̓WJTu[`
 ****************************************************************************/

/* -lh5-^Cv̓WJTu[`łB
 * [in]
 *	dir		t@CB
 *	out		o̓oCgXg[B
 *	in		̓rbgXg[B
 * [out]
 *	߂l		Ȃ΁Ao̓oCgԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* lzh_uncompress()痘p܂B
 *	  AvP[VvO璼ڌĂяoƂ͂܂B
 */
int lzh_uncompress_lh5(LZHDIR* dir, LZHBYTESTREAM* out, LZHBITSTREAM* in);
int _lzh_uncompress_lh5(LZHDIR* dir, LZHBYTESTREAM* out, LZHBITSTREAM* in,
	unsigned char code_bits[/*LZHBINARYTREE_MAXVALUE + 1*/], LZHBINARYTREE nodes[/*nodes_len*/], int nodes_len);

/* Piɂrbg\𕜍܂B
 * [in]
 *	in		̓rbgXg[B
 *	out		rbgi[邽߂̕ϐւ̃|C^B
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 *	*out		rbgi[܂B
 * [note]
 *	* lzh_uncompress_lh5()痘p܂B
 *	  AvP[VvO璼ڌĂяoƂ͂܂B
 */
int lzh_bitlength_decode_lh5(LZHBITSTREAM* in, int* out);

/* 8KBXCh̋\𕜍܂B
 * [in]
 *	distance_code_tree	Distance code c[̐擪m[hB
 *	distance_code_tree_len	Distance code c[̃m[hB
 *	in			̓rbgXg[B
 *	out			rbgi[邽߂̕ϐւ̃|C^B
 * [out]
 *	߂l			Ȃ΁A0Ԃ܂B
 *				sȂ΁A̒lԂ܂B
 *	*out			rbgi[܂B
 * [note]
 *	* lzh_uncompress_lh5()痘p܂B
 *	  AvP[VvO璼ڌĂяoƂ͂܂B
 */
int lzh_distance_decode_lh5(LZHBINARYTREE* distance_code_tree, int distance_code_tree_len, LZHBITSTREAM* in, int* out);

/****************************************************************************
 *	LZHfR[_
 ****************************************************************************/

typedef struct _LZH {
	const unsigned char* data;	/* LZHf[^擪AhX */
	int len;			/* LZHf[^TCY */
	/* lzh_dir() */
	int dir_pos;			/* t@C񑖍ʒu */
} LZH;

/* LZHf[^J܂B
 * [in]
 *	lzh		LZH\́B
 *	data		LZHf[^擪AhXB
 *	len		LZHf[^TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int lzh_init(LZH* lzh, const void* data, int len);

/* t@Cǂݍ݂܂B
 * [in]
 *	lzh		LZH\́B
 *	dir		NULLw肷ƁAt@C񑖍ʒu擪֖߂܂B
 *			NULLȊOw肷ƁAt@CǂݍŊi[Aʒu֐i߂܂B
 * [out]
 *	߂l		dirNULLw肵ꍇA0Ԃ܂B
 *			dirNULLȊOw肵ꍇAt@CǂݍݐȂ΁A0Ԃ܂B
 *			                             t@CǂݍݎsȂ΁A̒lԂ܂B
 * [note]
 *	* t@Cꗗ\vO܂B
 *		lzh_init(&lzh, data, len);
 *		lzh_dir(&lzh, NULL);
 *		while(lzh_dir(&lzh, &dir) == 0) {
 *			puts(dir.pathname);
 *		}
 */
int lzh_dir(LZH* lzh, LZHDIR* dir);

/* wt@CɈvt@Cǂݍ݂܂B
 * [in]
 *	lzh		LZH\́B
 *	pathname	t@CB
 *	dir		t@Ci[邽߂̕ϐւ̃|C^B
 * [out]
 *	߂l		wt@CɈvt@C񂪌A0Ԃ܂B
 *			wt@CɈvt@C񂪌Ȃ΁A̒lԂ܂B
 * [note]
 *	* t@C̑啶Ə͋ʂ܂B
 *	  ܂ApX"/""\"͋ʂ܂B
 */
int lzh_find(LZH* lzh, const char* pathname, LZHDIR* dir);

/* wt@CɈvt@CWJ܂B
 * [in]
 *	lzh		LZH\́B
 *	pathname	t@CB
 *	outbuf		o̓obt@B
 *	outlen		o̓obt@TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁Ao̓oCgԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* s̗v́Â悤Ȃ̂܂B
 *	  Ewt@CɈvt@CȂB
 *	  Eo̓obt@TCYsĂB
 *	  EWJf[^CRCvȂB(LZHf[^jĂ)
 */
int lzh_uncompress(LZH* lzh, const char* pathname, void* outbuf, int outlen);

#endif /*__CLIP_LZH_H__*/
