/*	
 *	cliplzh.c
 *
 *	P/ECE LZH
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Apr 14 12:30:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Apr 19 12:30:00 JST 2004 Naoyuki Sawa
 *	- fBNgP̂̃Gg(-lhd-)𖳎悤ɕύX܂B
 *	  IGNORE_DIRECTORYV{̐QƂĂB
 *	* Sun Oct 24 13:47:00 JST 2004 Naoyuki Sawa
 *	- LZHDIR.pathname[]̃TCY44128֑₵܂B
 *	  SPCyt@CɂāAt@Ce̐(Q[+Ȗ,etc)ɂȂĂꍇA
 *	  ɒt@CtĂ邱Ƃ߂łB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/* * IGNORE_DIRECTORYV{`ƁAfBNgP̂̃Gg(-lhd-)𖳎܂B
 *   ̓Iɂ́Â悤ȓƂȂ܂B
 *   - lzh_dir()ɂfBNgꗗ擾ŁAfBNgP̂̃GgXLbv܂B
 *   - lzh_find()ɂt@CGgŁAfBNgP̂̃Ggɂ͈v܂B
 *   - lzh_uncompress()ɂt@CWJŁAfBNgP̂w肷ƃG[Ԃ܂B
 * * fBNgP̂̃Gg(-lhd-)𖳎邱ƂɂŔÂƂłB
 *   ʏ́ALZHt@C쐬ɃfBNgP̂܂݂܂񂪁A
 *   IvVwɂAfBNgP̂܂LZHt@C쐬邱Ƃ\łB
 *   ȂP/ECEł̗pɂāAfBNgP̂Ƃ͂܂܂B
 *   t@CGgꗗɃfBNgP̂܂܂ƂĈÂ炢ʂ̂ŁA
 *   fBNgP̂̃Gg𖳎邱Ƃɂ܂B
 * * IGNORE_DIRECTORYV{̒`ƁAfBNgP̂̃Gg(-lhd-)𖳎܂B
 *   Oq̒ʂAʏLZHt@C̓fBNgP̂̃Gg܂܂Ȃ̂ŁA
 *   fBNgP̂̃Gg݂邱ƂOƂvOĂ͂܂B
 */
#define IGNORE_DIRECTORY

/****************************************************************************
 *	t@Cwb_
 ****************************************************************************/

int
lzh_chksum(const void* data, int len)
{
	int sum = 0;
	const unsigned char* p = (const unsigned char*)data;
	while(len--) sum += *p++;
	return sum & 0xff; /* 8rbĝݎgp */
}

int
lzh_crc16(const void* data, int len)
{
#define POLY	((1<<(15-15))|	\
		 (1<<(15- 2))|	\
		 (1<<(15- 0)))

	const unsigned char* p = (const unsigned char*)data;
	int i, r, v;

	r = 0;

	while(len--) {
		v = *p++;
		for(i = 0; i < 8; i++) {
			if((r ^ v) & 1) {
				r = (r >> 1) ^ POLY;
			} else {
				r =  r >> 1;
			}
			v >>= 1;
		}
	}

	return r;

#undef POLY
}

int
lzh_strcmp(const char* s1, const char* s2)
{
	int c1, c2;
	do {
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
		if(c1 == '\\') c1 = '/';
		if(c2 == '\\') c2 = '/';
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}

int
lzh_getexthdr(LZHDIR* dir, const void* exthdr, int next_header_size, const char* filename, int filename_size)
{
	int i;
	int ext_type;
	int data_size;
	int name_length;
	char c;
	const unsigned char* p;
	const unsigned char* next_p;
	//
	int total_extheader_size = 0;
	const char* directory = NULL;
	int directory_size = 0;

	/* p͍ŏ̊gwb_w܂B */
	p = (const unsigned char*)exthdr;

	/* gwb_͏ȂƂʎq(1oCg)Ǝ̊gwb_TCY(2oCg)̍v3oCgȏKvłB */
	while(next_header_size) {
		if(next_header_size < 1/*ext_type*/ + 2/*next_header_size*/) return ERRNO;
		total_extheader_size += next_header_size; /* gwb_TCYv */

		/* ̊gwb_ʒuۑB */
		next_p = p + next_header_size;

		/* f[^̃TCY擾B */
		data_size = next_header_size - (1 + 2);

		/* ʎqÅgwb_TCY擾B */
		ext_type = LZHBYTE(p);
		next_header_size = LZHHALF(&p[next_header_size - 2]);

		/* p̓f[^w܂B */
		p += 1;

		switch(ext_type) {
		case LZH_EXTTYPE_HEADER_CRC:
			/* wb_CRC-16͍s܂B
			 * wb_CRC-16́Ai[ĂCRC-16lNAĂ狁߂Ȃ΂܂B
			 * A݂̎ł̓wb_ŜROMɒu܂܏邱Ƃz肵Ă̂ŁAwb_CRC-16lNA邱Ƃł܂B
			 * wb_ŜRAMɓǂݍŏΉ\łAۂɔjwb_ɏoƂ͂܂ȂƔfA͌ȂƂɂ܂B
			 */
			break;
		case LZH_EXTTYPE_FILENAME:
			filename = (const char*)p;
			filename_size = data_size;
			break;
		case LZH_EXTTYPE_DIRECTORY:
			directory = (const char*)p;
			directory_size = data_size;
			break;
		default:
			/* LȊO̊gwb_͖܂B */
			break;
		}

		/* ̊gwb_ʒu𕜌B */
		p = next_p;
	}

	/* fBNgƃt@CȂĊi[܂B */
	name_length = 0;
	for(i = 0; i < directory_size; i++) {
		if(name_length == sizeof(dir->pathname) - 1) break;
		c = directory[i];
		if(c == '\xff') c = '/'; /* '\''/'́A'\xff'ɕϊĊi[Ă܂ */
		dir->pathname[name_length++] = c;
	}
	/* directory[]̖ɂ̓Zp[^tĂ͂Ȃ̂ŁAIȒǉ͕svł */
	for(i = 0; i < filename_size; i++) {
		if(name_length == sizeof(dir->pathname) - 1) break;
		c = filename[i];
		if(c == '\xff') c = '/'; /* '\''/'́A'\xff'ɕϊĊi[Ă܂ */
		dir->pathname[name_length++] = c;
	}

	return total_extheader_size;
}

int
lzh_gethdr0(LZHDIR* dir, const LZHLEVEL0HEADER* header)
{
	int header_size;
	int header_sum;
	int name_length;
	const unsigned char* p;

	/* ܂NAB */
	memset(dir, 0, sizeof(LZHDIR));

	/* wb_̃xB */
	if(LZHBYTE(header->level) != 0x00) return ERRNO; /* xs */

	/* wb_̑傫擾B */
	header_size = LZHBYTE(header->header_size);

	/* wb_̃`FbNTB */
	header_sum = lzh_chksum(header->method_id, header_size);
	if(header_sum != LZHBYTE(header->header_sum)) return ERRNO; /* `FbNTs */

	/* k@̎ށAk̃t@CTCYÃt@CTCY擾B */
	memcpy(dir->method_id, header->method_id, 5);
	dir->packed_size = LZHWORD(header->packed_size);
	dir->original_size = LZHWORD(header->original_size);

	/* ppathnamew܂B */
	p = (const unsigned char*)(header + 1);

	/* t@C(tpX)擾B */
	name_length = LZHBYTE(header->name_length);
	if(name_length <= sizeof(dir->pathname) - 1) {
		memcpy(dir->pathname, p, name_length);
	} else {
		memcpy(dir->pathname, p, sizeof(dir->pathname) - 1); /* t@Cꍇ͌ȗ */
	}
	p += name_length;

	/* t@CCRC-16擾B */
	dir->file_crc = LZHHALF(p);
	p += 2;

	/* kf[^AhXi[B */
	p = (const unsigned char*)header;
	dir->file_data = p + 1/*header_size*/ + 1/*header_sum*/ + header_size;

	return 1/*header_size*/ + 1/*header_sum*/ + header_size + dir->packed_size;
}

int
lzh_gethdr1(LZHDIR* dir, const LZHLEVEL1HEADER* header)
{
	int header_size;
	int header_sum;
	int skip_size;
	int filename_size;
	int next_header_size;
	int total_extheader_size;
	const char* filename;
	const unsigned char* p;

	/* ܂NAB */
	memset(dir, 0, sizeof(LZHDIR));

	/* wb_̃xA\tB[hB */
	if(LZHBYTE(header->level) != 0x01) return ERRNO; /* xs */
	if(LZHBYTE(header->reserved) != 0x20) return ERRNO; /* \tB[hs */

	/* {wb_̑傫擾B */
	header_size = LZHBYTE(header->header_size);

	/* {wb_̃`FbNTB */
	header_sum = lzh_chksum(header->method_id, header_size);
	if(header_sum != LZHBYTE(header->header_sum)) return ERRNO; /* `FbNTs */

	/* k@̎ށAXLbvTCYÃt@CTCY擾B */
	memcpy(dir->method_id, header->method_id, 5);
	skip_size = LZHWORD(header->skip_size);
	dir->original_size = LZHWORD(header->original_size);

	/* pfilenamew܂B */
	p = (const unsigned char*)(header + 1);

	/* t@C(t@Ĉ)擾B
	 * header->name_length=0Ȃ΁At@Cgwb_Ɋi[Ă܂B
	 * gwb_Ƀt@CAŎ擾l㏑܂B
	 */
	filename = (const char*)p;
	filename_size = LZHBYTE(header->name_length);
	p += filename_size;

	/* t@CCRC-16擾B */
	dir->file_crc = LZHHALF(p);
	p += 2;

	/* pnext_header_sizew܂B */
	p = (const unsigned char*)header;
	p += 1/*header_size*/ + 1/*header_sum*/ + header_size - 2/*next_header_size*/;

	/* ŏ̊gwb_TCY擾B */
	next_header_size = LZHHALF(p);

	/* p͍ŏ̊gwb_w܂B */
	p += 2/*next_header_size*/;

	/* gwb_ǂݍ݂܂B */
	total_extheader_size = lzh_getexthdr(dir, p, next_header_size, filename, filename_size);
	if(total_extheader_size < 0) return total_extheader_size;

	/* k̃t@CTCYAkf[^AhXi[B */
	dir->packed_size = skip_size - total_extheader_size;
	dir->file_data = p + total_extheader_size;

	return 1/*header_size*/ + 1/*header_sum*/ + header_size + skip_size;
}

int
lzh_gethdr2(LZHDIR* dir, const LZHLEVEL2HEADER* header)
{
	int total_header_size;
	int next_header_size;
	int total_extheader_size;
	const unsigned char* p;

	/* ܂NAB */
	memset(dir, 0, sizeof(LZHDIR));

	/* wb_̃xA\tB[hB */
	if(LZHBYTE(header->level) != 0x02) return ERRNO; /* xs */
	if(LZHBYTE(header->reserved) != 0x20) return ERRNO; /* \tB[hs */

	/* Swb_̑傫擾B */
	total_header_size = LZHBYTE(header->total_header_size);

	/* k@̎ށAk̃t@CTCYÃt@CTCYAt@CCRC-16擾B */
	memcpy(dir->method_id, header->method_id, 5);
	dir->packed_size = LZHWORD(header->packed_size);
	dir->original_size = LZHWORD(header->original_size);
	dir->file_crc = LZHHALF(header->file_crc);

	/* ŏ̊gwb_TCY擾B */
	next_header_size = LZHHALF(header->next_header_size);

	/* p͍ŏ̊gwb_w܂B */
	p = (const unsigned char*)(header + 1);

	/* gwb_ǂݍ݂܂B */
	total_extheader_size = lzh_getexthdr(dir, p, next_header_size, NULL, 0);
	if(total_extheader_size < 0) return total_extheader_size;

	/* kf[^AhXi[B
	 * x2wb_̏ꍇAgwb_̌ɃpfBÖ悪݂ꍇ̂ŁA
	 *	dir->file_data = p + total_extheader_size
	 * ƂĂ͂܂B
	 * total_header_size̓pfBÖ܂񂾃TCYȂ̂ŁÂ悤ɌvZ܂B
	 */
	p = (const unsigned char*)header;
	dir->file_data = p + total_header_size;

	return total_header_size + dir->packed_size;
}

/****************************************************************************
 *	o̓oCgXg[
 ****************************************************************************/

int
lzh_bytestream_init(LZHBYTESTREAM* out, void* buffer, int len)
{
	if(len < 0) return ERRNO;

	memset(out, 0, sizeof(LZHBYTESTREAM));
	out->buffer = (unsigned char*)buffer;
	out->len = len;

	return 0;
}

int
lzh_bytestream_put(LZHBYTESTREAM* out, int value)
{
	if(out->pos >= out->len) return ERRNO;

	out->buffer[out->pos++] = (unsigned char)value;

	return 1;
}

/****************************************************************************
 *	̓rbgXg[
 ****************************************************************************/

int
lzh_bitstream_init(LZHBITSTREAM* in, const void* data, int len)
{
	if((len < 0) || (len > INT_MAX / 8 - 1)) return ERRNO;

	memset(in, 0, sizeof(LZHBITSTREAM));
	in->data = (const unsigned char*)data;
	in->len = len * 8; /* bitP */

	return 0;
}

int
lzh_bitstream_get(LZHBITSTREAM* in, int* out, int bits)
{
	//	       s1  s2                 
	//	       /   /                  
	//	    +----+-+                  
	//	LSB|.....xxx|xxxxxxxx|xxx.....|MSB
	//	    |    +--------------+     
	//	    p    |      /             
	//	        pos   bits            

	int v, n, s1, s2;
	const unsigned char* p;

	if(bits < 0 || bits > 32) return ERRNO;
	if(in->pos + bits > in->len) return ERRNO;

	/* 32bitlɑ΂32bitVtǵACdlIɂ̓AEgłB
	 * 32bitVtg邽߂ɁAbits=0̏ꍇʏƂ܂B
	 */
	if(!bits) {
		*out = 0;
		return 0;
	}

	p = &in->data[in->pos / 8];
	s1 = in->pos & 7;
	s2 = 8 - s1;

	v = (*p++ << 24) << s1;
	n = bits - s2;
	while(n > 0) {
		v |= (unsigned)(*p++ << 24) >> s2;
		//   ~~~~~~~~~~IȌ^ϊKvłB
		//             (unsigned char)ɑ΂<<ZqgƁAÖق̕ϊ(int)ɂȂ܂B
		//             (int)̂܂>>ZqgƁAŏʃrbggĂ܂܂B
		//             ŏʃrbggȂ悤AI(unsigned)ɕϊ܂B
		s2 += 8;
		n -= 8;
	}

	*out = (unsigned)v >> (32 - bits);
	in->pos += bits;

	return bits;
}

/****************************************************************************
 *	񕪖 (binary tree)
 ****************************************************************************/

int
lzh_binarytree_init(LZHBINARYTREE tree[/*len*/], int len, const unsigned char code_bits[/*values*/], int values)
{
	int retval;
	int value;
	int bits;
	int code;
	int index;
	unsigned short bits_count[LZHBINARYTREE_MAXBITS + 1]; /* 2x17=34[byte] */
	unsigned short bits_code [LZHBINARYTREE_MAXBITS + 1]; /* 2x17=34[byte] */

	if(values < 0 || values > LZHBINARYTREE_MAXVALUE + 1) return ERRNO;

	/* 񕪖؂̑Sm[hnext[0,1]ALZHBINARYTREE_BLANKɏ܂B */
	memset(tree, -1, sizeof(LZHBINARYTREE) * len);

	/* erbg蓖Ăꂽl̐𐔂܂B */
	memset(bits_count, 0, sizeof bits_count);
	for(value = 0; value < values; value++) {
		bits = code_bits[value];
		if(bits > LZHBINARYTREE_MAXBITS) return ERRNO;
		if(bits) bits_count[bits]++; /* rbg0̒l͕sgp */
	}

	/* erbg̍ŏ̕蓖Ă܂B */
	code = 0;
	for(bits = 1; bits <= LZHBINARYTREE_MAXBITS; bits++) {
		code = (code + bits_count[bits - 1]) << 1;
		bits_code[bits] = (unsigned short)code;
	}

	/* elɕ蓖āA񕪖؂{Al}̃yAǉ܂B */
	index = -1; /* li[m[hCfNX̍ől */
	for(value = 0; value < values; value++) {
		bits = code_bits[value];
		if(bits) { /* 0rbg̒l(=gp)͒ǉ܂ */
			code = bits_code[bits]++;
			retval = lzh_binarytree_add(tree, len, code, bits, value);
			if(retval < 0) return retval;
			if(retval > index) index = retval;
		}
	}

	/* gpm[h(=li[m[hCfNX̍ől+1)Ԃ܂B */
	return index + 1;
}

int
lzh_binarytree_add(LZHBINARYTREE tree[/*len*/], int len, int code, int code_bits, int value)
{
	int index;
	int bit;
	int next_index;
	LZHBINARYTREE* node;

	if(code_bits < 1 || code_bits > LZHBINARYTREE_MAXBITS ) return ERRNO;
	if(value     < 0 || value     > LZHBINARYTREE_MAXVALUE) return ERRNO;

	/* ̃Nǂ鏈B */
	index = 0;
	for(;;) {
		/* m[h擾܂B */
		if(index > len - 1) return ERRNO; /* 񕪖ؔj */
		node = &tree[index];

		/* c蕄rbg炵܂B */
		code_bits--;

		/* T(0or1)擾܂B */
		bit = (code >> code_bits) & 1;

		/* Ō̃rbgȂAli[ցB */
		if(!code_bits) goto FINAL;

		/* ̃m[hCfNX擾܂B */
		next_index = node->next[bit];

		/* Nr؂ꂽA܂B */
		if(next_index == LZHBINARYTREE_BLANK) break;

		/* m[hCfNXXVA[vB */
		if(next_index <= index) return ERRNO; /* O֖߂邱Ƃ͂肦Ȃ */
		index = next_index;
		if(index & LZHBINARYTREE_LEAF) return ERRNO; /* 񕪖ؔj */
	}

	/* ݂̃m[hŁAƂ󂫂̃m[hT܂B
	 * ~~~~~~~~~~~~~~~~~~~~dv!!݂̃m[hƂ󂫂̉\܂B
	 */
	for(next_index = index + 1; next_index < len; next_index++) {
		if(tree[next_index].next[0] == LZHBINARYTREE_BLANK &&
		   tree[next_index].next[1] == LZHBINARYTREE_BLANK) break;
	}
	if(next_index == len) return ERRNO; /* m[hs */

	/* ŏ̋󂫃m[hփN܂B */
	node->next[bit] = (unsigned short)next_index;

	/* 㑱N쐬鏈B */
	index = next_index;
	node = &tree[index];
	for(;;) {
		/* c蕄rbg炵܂B */
		code_bits--;

		/* T(0or1)擾܂B */
		bit = (code >> code_bits) & 1;

		/* Ō̃rbgȂAli[ցB */
		if(!code_bits) goto FINAL;

		/* ̃m[hփN܂B */
		index++;
		if(index > len - 1) return ERRNO; /* m[hs */
		if(node->next[bit] != LZHBINARYTREE_BLANK) return ERRNO; /* 񕪖ؔj */
		node->next[bit] = (unsigned short)index;
		node++;
	}

FINAL:
	/* li[܂B */
	if(node->next[bit] != LZHBINARYTREE_BLANK) return ERRNO; /* 񕪖ؔj */
	node->next[bit] = (unsigned short)(value | LZHBINARYTREE_LEAF);

	/* li[m[h̃CfNXԂ܂B */
	return index;
}

int
lzh_binarytree_lookup(LZHBINARYTREE tree[/*len*/], int len, LZHBITSTREAM* in, int* out)
{
	int index;
	int bit;
	int next_index;
	int value;
	LZHBINARYTREE* node;

	/* ̃Nǂ鏈B */
	index = 0;
	for(;;) {
		/* m[h擾܂B */
		if(index > len - 1) return ERRNO; /* 񕪖ؔj */
		node = &tree[index];

		/* 1rbgǂݍ݂܂B */
		if(lzh_bitstream_get(in, &bit, 1) < 0) return ERRNO;

		/* ̃m[hCfNX擾܂B */
		next_index = node->next[bit];
		if(next_index & LZHBINARYTREE_LEAF) break; /* [t(or)ȂΔ܂ */

		/* m[hCfNXXVA[vB */
		if(next_index <= index) return ERRNO; /* O֖߂邱Ƃ͂肦Ȃ */
		index = next_index;
	}

	/* l擾܂B */
	value = next_index & ~LZHBINARYTREE_LEAF;
	if(value < 0 || value > LZHBINARYTREE_MAXVALUE) return ERRNO; /* 񕪖ؔj */
	/*next_index=LZHBINARYTREE_BLANKꍇAŃG[oł܂B*/

	/* li[܂B */
	*out = value;

	return 0;
}

/****************************************************************************
 *	-lh5-WJTu[`
 ****************************************************************************/

/* * lzh_uncompress_lh5()ŊmۂA񕪖؃m[hobt@̗vfłB
 *   Code Length codeALiteral/Length codeADistance code ec[́Ãm[hobt@ɍ쐬܂B
 *   O̃c[̍vm[hm[hobt@vf𒴂ƁAWJsG[Ԃ܂B
 * * ő升vm[h͗_ŋ߂Ȃ悤Ȃ̂ŁAŒ邵܂B
 *   ̈kf[^ŎĂ݂ƂAO̃c[̍vm[h300`400xƂȂ܂B
 *   1024ĂΏ[Ǝv܂A1024𒴂邱Ƃ΁AĒĂB
 */
#define LH5_NODES_LEN	1024	/*  */

int
lzh_uncompress_lh5(LZHDIR* dir, LZHBYTESTREAM* out, LZHBITSTREAM* in)
{
	int retval;
	unsigned char* code_bits/*[LZHBINARYTREE_MAXVALUE + 1]*/;
	LZHBINARYTREE* nodes/*[LH5_NODES_LEN]*/;

	/* rbgzpmۂ܂B */
	code_bits = (unsigned char*)malloc(sizeof(unsigned char) * (LZHBINARYTREE_MAXVALUE + 1));
	if(!code_bits) {
		return ERRNO;
	}

	/* 񕪖؃m[hobt@pmۂ܂B */
	nodes = (LZHBINARYTREE*)malloc(sizeof(LZHBINARYTREE) * LH5_NODES_LEN);
	if(!nodes) {
		free(code_bits);
		return ERRNO;
	}

	/* WJ̖{̂Ăяo܂B */
	retval = _lzh_uncompress_lh5(dir, out, in, code_bits, nodes, LH5_NODES_LEN);

	/* 񕪖؃m[hobt@pJ܂B */
	free(nodes);

	/* rbgzpJ܂B */
	free(code_bits);

	return retval;
}

int
_lzh_uncompress_lh5(LZHDIR* dir, LZHBYTESTREAM* out, LZHBITSTREAM* in,
	unsigned char code_bits[/*LZHBINARYTREE_MAXVALUE + 1*/], LZHBINARYTREE nodes[/*nodes_len*/], int nodes_len)
{
	int retval;
	int blocksize;
	int values;
	int value;
	int code;
	int zerocount_3to5;
	int bitlength;
	int length;
	int distance;

	LZHBINARYTREE* tree;				/* m[hobt@̋󂫗vf擪m[h */
	int tree_len;					/* m[hobt@̎c󂫗vf */
	//
	LZHBINARYTREE* code_length_code_tree;		/* Code Length code c[̐擪m[h */
	int code_length_code_tree_len;			/* Code Length code c[̃m[h */
	//
	LZHBINARYTREE* literal_length_code_tree;	/* Literal/Length code c[̐擪m[h */
	int literal_length_code_tree_len;		/* Literal/Length code c[̃m[h */
	//
	LZHBINARYTREE* distance_code_tree;		/* Distance code c[̐擪m[h */
	int distance_code_tree_len;			/* Distance code c[̃m[h */

	while(out->pos < dir->original_size) {
		/* ubNTCY擾܂B */
		if(lzh_bitstream_get(in, &blocksize, 16) < 0) return ERRNO;
		if(!blocksize) blocksize = 1 << 16; /* 1`64K */

		/* m[hobt@Zbg܂BYȂ!! */
		tree = nodes;
		tree_len = nodes_len;

		/***** Code Length code c[WJ *****/

		ASSERT(LZHBINARYTREE_MAXVALUE >= 18);
		memset(code_bits, 0, 18 + 1);
		if(lzh_bitstream_get(in, &values, 5) < 0) return ERRNO;
		if(values > 18 + 1) return ERRNO;
		if(!values) {
			if(lzh_bitstream_get(in, &value, 5) < 0) return ERRNO;
			if(value > 18) return ERRNO;
			code_bits[value] = 1;
		} else {
			for(value = 0; value < values; value++) {
				if(value == 3) {
					if(lzh_bitstream_get(in, &zerocount_3to5, 2) < 0) return ERRNO;
					if(zerocount_3to5) { /* 3`5܂ł̊Ԃ0A鐔 */
						value += zerocount_3to5 - 1;
						continue;
					}
				}
				retval = lzh_bitlength_decode_lh5(in, &bitlength);
				if(retval < 0) return retval;
				code_bits[value] = (unsigned char)bitlength;
			}
		}
		retval = lzh_binarytree_init(tree, tree_len, code_bits, 18 + 1);
		if(retval < 0) DIE();
		code_length_code_tree = tree;
		code_length_code_tree_len = retval;
		tree += retval;
		tree_len -= retval;

		/***** Literal/Length code c[WJ *****/

		memset(code_bits, 0, LZHBINARYTREE_MAXVALUE + 1);
		if(lzh_bitstream_get(in, &values, 9) < 0) return ERRNO;
		if(values > LZHBINARYTREE_MAXVALUE + 1) return ERRNO;
		if(!values) {
			if(lzh_bitstream_get(in, &value, 9) < 0) return ERRNO;
			if(value > LZHBINARYTREE_MAXVALUE) return ERRNO;
			code_bits[value] = 1;
		} else {
			for(value = 0; value < values; value++) {
				retval = lzh_binarytree_lookup(code_length_code_tree, code_length_code_tree_len, in, &code);
				if(retval < 0) return retval;
				if(code < 0) {
					return ERRNO;
				} else if(code == 0) {	/* code=0 => bits=0 */
					/** no job **/
				} else if(code == 1) {	/* code=1 => bits=0~3`18 */
					if(lzh_bitstream_get(in, &code, 4) < 0) return ERRNO;
					value +=  3 + code - 1;
				} else if(code == 2) {	/* code=2 => bits=0~20`531 */
					if(lzh_bitstream_get(in, &code, 9) < 0) return ERRNO;
					value += 20 + code - 1;
				} else if(code <= 18) {	/* code=3`18 => bits=1`16 */
					code_bits[value] = (unsigned char)(1 + (code - 3));
				} else {
					return ERRNO;
				}
			}
		}
		retval = lzh_binarytree_init(tree, tree_len, code_bits, LZHBINARYTREE_MAXVALUE + 1);
		if(retval < 0) DIE();
		literal_length_code_tree = tree;
		literal_length_code_tree_len = retval;
		tree += retval;
		tree_len -= retval;

		/***** Distance code c[WJ *****/

		ASSERT(LZHBINARYTREE_MAXVALUE >= 13); /* 2^13=8KB */
		memset(code_bits, 0, 13 + 1);
		if(lzh_bitstream_get(in, &values, 4) < 0) return ERRNO;
		if(values > 13 + 1) return ERRNO;
		if(!values) {
			if(lzh_bitstream_get(in, &value, 4) < 0) return ERRNO;
			if(value > 13) return ERRNO;
			code_bits[value] = 1;
		} else {
			for(value = 0; value < values; value++) {
				retval = lzh_bitlength_decode_lh5(in, &bitlength);
				if(retval < 0) return retval;
				code_bits[value] = (unsigned char)bitlength;
			}
		}
		retval = lzh_binarytree_init(tree, tree_len, code_bits, 13 + 1);
		if(retval < 0) DIE();
		distance_code_tree = tree;
		distance_code_tree_len = retval;
		tree += retval;
		tree_len -= retval;

		/***** XChɂ镜C *****/

		do {
			/* Literal/Length B */
			retval = lzh_binarytree_lookup(literal_length_code_tree, literal_length_code_tree_len, in, &code);
			if(retval < 0) return retval;

			if(code < 256) {
				/* Literal */
				if(lzh_bytestream_put(out, code) < 0) return ERRNO;
			} else {
				/* Length & Distance */
				length = 3 + (code - 256);
				retval = lzh_distance_decode_lh5(distance_code_tree, distance_code_tree_len, in, &distance);
				if(retval < 0) return retval;
				if(distance > out->pos) return ERRNO; /* o̓obt@JnʒuO̓Rs[s */
				do {
					if(lzh_bytestream_put(out, out->buffer[out->pos - distance]) < 0) return ERRNO;
				} while(--length);
			}
		} while(--blocksize > 0);
	}

	return out->pos;
}

int
lzh_bitlength_decode_lh5(LZHBITSTREAM* in, int* out)
{
	int bitlength;
	int x;

	/*	rbg	rbgp^[
	 *	 0		000
	 *	 1		001
	 *	 2		010
	 *	 3		011
	 *	 4		100
	 *	 5		101
	 *	 6		110
	 *	 7		1110
	 *	 8		11110
	 *	 9		111110
	 *	10		1111110
	 *	11		11111110
	 *	12		111111110
	 *	13		1111111110
	 *	14		11111111110
	 *	15		111111111110
	 *	16		1111111111110
	 */
	if(lzh_bitstream_get(in, &bitlength, 3) < 0) return ERRNO;
	if(bitlength == 7) {
		for(;;) {
			if(lzh_bitstream_get(in, &x, 1) < 0) return ERRNO;
			if(!x) break;
			bitlength++;
			if(bitlength > 16) return ERRNO;
		}
	}
	*out = bitlength;

	return 0;
}

int
lzh_distance_decode_lh5(LZHBINARYTREE* distance_code_tree, int distance_code_tree_len, LZHBITSTREAM* in, int* out)
{
	int retval;
	int bitlength;
	int distance;

	/*			rbgp^[
	 *	1+0		0000
	 *	1+1		0001
	 *	1+2`3		0010n
	 *	1+4`7		0011nn
	 *	1+8`15		0100nnn
	 *	1+16`31	0101nnnn
	 *	1+32`63	0110nnnnn
	 *	1+64`127	0111nnnnnn
	 *	1+128`255	1000nnnnnnn
	 *	1+256`511	1001nnnnnnnn
	 *	1+512`1023	1010nnnnnnnnn
	 *	1+1024`2047	1011nnnnnnnnnn
	 *	1+2048`4095	1100nnnnnnnnnnn
	 *	1+4096`8191	1101nnnnnnnnnnnn
	 */
	retval = lzh_binarytree_lookup(distance_code_tree, distance_code_tree_len, in, &bitlength);
	if(bitlength < 0) {
		return ERRNO;
	} else if(bitlength == 0) {
		distance = 0;
	} else if(bitlength <= 13) { /* 2^13=8KB */
		bitlength--;
		if(lzh_bitstream_get(in, &distance, bitlength) < 0) return ERRNO;
		distance |= 1 << bitlength;
	} else {
		return ERRNO;
	}
	*out = 1 + distance;

	return 0;
}

/****************************************************************************
 *	LZHfR[_
 ****************************************************************************/

int
lzh_init(LZH* lzh, const void* data, int len)
{
	if(len < 0) return ERRNO;

	memset(lzh, 0, sizeof(LZH));
	lzh->data = (const unsigned char*)data;
	lzh->len = len;

	return 0;
}

int
lzh_dir(LZH* lzh, LZHDIR* dir)
{
	int retval;
	const unsigned char* header;

	if(dir) {
#ifdef IGNORE_DIRECTORY
		do {
#endif /*IGNORE_DIRECTORY*/
			/* Gh}[N(0x00)oA܂f[^cĂĂIƂ܂B
			 * Lȃwb_1oCgڂ0x00łĂ͂܂B
			 * Ƀx2wb_̏ꍇAtotal_header_sizẻʃoCg0x00ɂȂȂ悤A
			 * KvɉăpfBOǉAwb_TCY𒲐Ă܂B(GR[_̎d)
			 */
			if(lzh->dir_pos < lzh->len && !lzh->data[lzh->dir_pos]) return ERRNO;

			/* cf[^wb_TCYɖȂ΁AsłB
			 * x0`2̃wb_͂ItZbg20̈ʒuɃxi[Ă܂B
			 * ]āAȂƂ݈ʒu21oCgȏȂΏI[ƌȂ܂B
			 * LZHt@C̏I[́AOq̃Gh}[NɂĎ͂łB
			 * ŏI[oꍇAGh}[Nt@Cj̉\܂B
			 */
			if(lzh->len - lzh->dir_pos < 21) return ERRNO;

			/* t@Cǂݍ݂܂B */
			header = &lzh->data[lzh->dir_pos];
			switch(header[20]) {
			case 0:	/* x0wb_ */
				retval = lzh_gethdr0(dir, (const LZHLEVEL0HEADER*)header);
				break;
			case 1:	/* x1wb_ */
				retval = lzh_gethdr1(dir, (const LZHLEVEL1HEADER*)header);
				break;
			case 2:	/* x2wb_ */
				retval = lzh_gethdr2(dir, (const LZHLEVEL2HEADER*)header);
				break;
			default:
				return ERRNO;
			}

			/* t@C񑖍ʒu֐i߂܂B */
			lzh->dir_pos += retval;
#ifdef IGNORE_DIRECTORY
		} while(memcmp(dir->method_id, "-lhd-", 5) == 0); /* fBNgP̂Ȃ΁A܂ */
#endif /*IGNORE_DIRECTORY*/
	} else {
		/* t@C񑖍ʒu擪֖߂܂B */
		lzh->dir_pos = 0;
	}

	return 0;
}

int
lzh_find(LZH* lzh, const char* pathname, LZHDIR* dir)
{
	int retval;
	int dir_pos0 = lzh->dir_pos; /* t@C񑖍ʒuޔ */

	/* t@C񑖍ʒu擪֖߂܂B */
	lzh_dir(lzh, NULL);
	for(;;) {
		/* t@Cǂݍ݂܂B */
		retval = lzh_dir(lzh, dir);
		if(retval < 0) break;

		/* t@Cr܂B */
		if(lzh_strcmp(dir->pathname, pathname) == 0) {
			retval = 0;
			break;
		}
	}

	lzh->dir_pos = dir_pos0; /* t@C񑖍ʒu */
	return retval;
}

int
lzh_uncompress(LZH* lzh, const char* pathname, void* outbuf, int outlen)
{
	int retval;
	int crc16;
	LZHDIR dir;
	LZHBITSTREAM in;
	LZHBYTESTREAM out;

	/* t@CT܂B */
	retval = lzh_find(lzh, pathname, &dir);
	if(retval < 0) return retval;
	if(dir.original_size > outlen) return ERRNO; /* o̓obt@s */

	if(dir.method_id[0] == '-' &&
	   dir.method_id[1] == 'l' &&
	   dir.method_id[2] == 'h' &&
	   dir.method_id[4] == '-') {
		switch(dir.method_id[3]) {
		/*==========================================================*
		 *	-lh0-	k
		 *==========================================================*/
		case '0':
			/* kȂ̂ŁAkTCYƓWJTCY͓͂B */
			if(dir.packed_size != dir.original_size) return ERRNO;

			/* kf[^o̓obt@ɃRs[܂B */
			memcpy(outbuf, dir.file_data, dir.original_size);

			break;

		/*==========================================================*
		 *	-lh5-	8KBXChk
		 *==========================================================*/
		case '5':
			/* ̓Xg[܂B */
			retval = lzh_bitstream_init(&in, dir.file_data, dir.packed_size);
			if(retval < 0) return retval;

			/* o̓Xg[܂B */
			retval = lzh_bytestream_init(&out, outbuf, outlen);
			if(retval < 0) return retval;

			/* WJ܂B */
			retval = lzh_uncompress_lh5(&dir, &out, &in);
			if(retval < 0) return retval;
			if(retval != dir.original_size) return retval; /* o̓TCYsv */

			break;

		/*==========================================================*
		 *	-lhd-	fBNg
		 *==========================================================*/
		case 'd':
			return ERRNO; /* Ή */

		/*==========================================================*
		 *	̑̈k`ɂ͖ΉłB
		 *==========================================================*/
		default:
			return ERRNO; /* Ή */
		}
	}

	/* CRCB */
	crc16 = lzh_crc16(outbuf, dir.original_size);
	if(dir.file_crc != crc16) return ERRNO;

	/* o̓TCYԂ܂B */
	return dir.original_size;
}

