
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		LOT_draw_column
LOT_draw_column:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := rndval
LOT_draw_column_LOOP:
		sub		%r13, 1			;// %r13 := column_size--
		jrlt		LOT_draw_column_MISS	;// if(column_size < 0) return -1
		;//
		ld.uh		%r10, [%r12]+		;// %r10 := hitval = *column++
		ld.uh		%r11, [%r12]+		;// %r11 := weight = *column++
;//{{
;//		add		%r11, 1			;// %r11 :=           (weight + 1)
;//		sub		%r14, %r11		;// %r14 := rndval -= (weight + 1)
;//		jrge		LOT_draw_column_LOOP	;// if(rndval <  0) return hitval
;//
		sub		%r14, %r11		;// %r14 := rndval -= (weight    )
		jrgt.d		LOT_draw_column_LOOP	;// if(rndval <= 0) return hitval
		sub		%r14, 1			;// %r14 := rndval -= (         1)	*delay*
;//}}
		ret					;// return  hitval
LOT_draw_column_MISS:
		ret.d					;// return  -1
		ld.w		%r10, -1		;// %r10 := -1				*delay*

	
		.code
		.align		1
		.global		LOT_get_column_weight
LOT_get_column_weight:
		;//%r12 := column
		;//%r13 := column_size
		;//%r14 := hitval_sel
	ext	0x3ff		; 		xcmp		%r14, 0xFFFF				;//if((unsigned)hitval_sel > USHRT_MAX) {
	cmp	%r14,0x3f
		jrugt.d		LOT_get_column_weight_RET		;//  %r10     := x = -1
		ld.w		%r10, -1				;//  goto RET }																		*delay*
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8				;//
	ld.h	[%sp+0x2],%r14	; 		xld.h		[%sp+4], %r14				;//[%sp+4].uh := hitval_sel
		ld.w		%r14, %r13				;//%r14       := column_size
		ld.w		%r13, %r12				;//%r13       := column
		ld.w		%r12, %sp				;//%r12       := &[%sp+0]
	ext	LOT_get_column_weight_compar+0x0@h	; 		xld.w		%r9, LOT_get_column_weight_compar	;//%r9        := LOT_get_column_weight_compar
	ext	LOT_get_column_weight_compar+0x0@m
	ld.w	%r9,LOT_get_column_weight_compar+0x0@l
		ld.w		[%r12]+, %r9				;//[%sp+0].w  := LOT_get_column_weight_compar, %r12 := &hitval_sel
	ext	bsearch@rm	; 		xcall.d		bsearch					;//%r10       := column = bsearch(&hitval_sel, column, column_size, sizeof(unsigned short) * 2/*{hitval,weight}*/, LOT_get_column_weight_compar)
	call.d	bsearch@rl
		ld.w		%r15, 4					;//%r15       :=                                                    sizeof(unsigned short) * 2/*{hitval,weight}*/					*delay*
		sub		%r10, 1					;//%r10       := x = column - 1
		jrult.d		4					;//if(x != -1) {
	add	%sp,0x2		; 		 xadd		%sp, %sp, 8				;//																			*delay*
		 add		%r10, 3					;//  %r10     :=   column + sizeof(unsigned short) = x + 1 + sizeof(unsigned short)
		 ld.uh		%r10, [%r10]				;//  %r10     := *(column + sizeof(unsigned short))
LOT_get_column_weight_RET:
		ret.d							;//return        x + 1
		add		%r10, 1					;//%r10       := x + 1																	*delay*
		;//-----------------------------------------------------;//
LOT_get_column_weight_compar:
		;//%r12 := _x
		;//%r13 := _y
		ld.uh		%r10, [%r12]				;//%r10 := x = *(unsigned short*)_x
		ld.uh		%r9 , [%r13]				;//%r9  := y = *(unsigned short*)_y
		ret.d							;//return  x - y
		sub		%r10, %r9				;//%r10 := x - y																	*delay*

	
		.code
		.align		1
LOT_seek_and_call:
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.uh		%r4, [%r12]+					;//%r4  := table_size = *table++
		ld.uh		%r5, [%r12]+					;//%r5  := id_size    = *table++
		sla		%r5, 2						;//%r5  := id_size * sizeof(int)
LOT_seek_and_call_L1:								;//for(;;) {
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		sub		%r4, 1						;//%r4  := table_size--
		jrlt		LOT_seek_and_call_DIE				;//if(table_size < 0) { DIE() }
		ld.w		%r6, %r5					;//%r6  := n_id = id_size * sizeof(int)
		ld.w		%r7, 0						;//%r7  := diff = 0
LOT_seek_and_call_L2:								;//for(;;) {
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r6  := n_id
		;//%r7  := diff
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		sub		%r6, 4						;//%r6  := n_id -= sizeof(int)
		jrlt		LOT_seek_and_call_L3				;//if(n_id < 0) { break }
		ld.uh		%r10, [%r12]+					;//%r10 :=          id1       = *table++
		ld.w		%r11, [%r13]+					;//%r11 :=                id2 = *pid++
		sub		%r10, %r11					;//%r10 :=         (id1 - id2)
		jp.d		LOT_seek_and_call_L2				;//}
		or		%r7, %r10					;//%r7  := diff |= (id1 - id2)					*delay*
LOT_seek_and_call_L3:
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r7  := diff
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.uh		%r6, [%r12]+					;//%r6  := column_size = *table++
		cmp		%r7, 0						;//if(!diff) { break }
		jreq		LOT_seek_and_call_L4
		sub		%r13, %r5					;//%r13 := pid -=   (    id_size *     sizeof(int)           )
		sla		%r6, 2						;//%r6  :=          (column_size * 2 * sizeof(unsigned short))
		jp.d		LOT_seek_and_call_L1				;//}
		add		%r12, %r6					;//%r12 := table += (column_size * 2 * sizeof(unsigned short))	*delay*
LOT_seek_and_call_L4:
		;//%r6  := column_size
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.w		%r4, [%r13]					;//%r4  := id2 = *pid
		ld.w		%r13, %r6					;//%r13 := column_size					*anti-interlock*
		cmp		%r4, -1						;//if(id2 != -1) { DIE() }		
		jrne		LOT_seek_and_call_DIE				;//					
;//		ld.w		%r13, %r6					;//%r13 := column_size		
		jp		%r15						;//return (*fn)(table, column_size, param)			(jp.d %rb͕s)

	.code
	.align	2
__LC0:
	.ascii	"cliplot.$\000"
; NO_APP
	.code
	.align	1
LOT_seek_and_call_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x8		; 	xld.w	%r13,0x00000225		; 549
	ld.w	%r13,0x25
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP
	
		.align		1
		.global		LOT_draw_table_l
		.global		LOT_draw_table_a
		.global		LOT_draw_table_v
LOT_draw_table_l:
		;//%r12    := table
		;//[%sp+0] := retp
		;//[%sp+4] := rndval
		;//[%sp+8] := ...
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8					;//%r13 := ap = &...
	add	%r13,0x8
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+4]					;//%r14 := rndval
LOT_draw_table_a:		;//AZuvOł́A
LOT_draw_table_v:		;//̓̊֐͓łB
		;//%r12    := table
		;//%r13    := pid = ap
		;//%r14    := rndval
	ext	LOT_draw_column+0x0@h	; 		xld.w		%r15, LOT_draw_column				;//%r15 := LOT_draw_column
	ext	LOT_draw_column+0x0@m
	ld.w	%r15,LOT_draw_column+0x0@l
	jp	LOT_seek_and_call	; 		xjp		LOT_seek_and_call				;//return LOT_seek_and_call(table, pid, rndval, LOT_draw_column)

	
		.align		1
		.global		LOT_get_table_weight_l
		.global		LOT_get_table_weight_a
		.global		LOT_get_table_weight_v
LOT_get_table_weight_l:
		;//%r12    := table
		;//[%sp+0] := retp
		;//[%sp+4] := hitval_sel
		;//[%sp+8] := ...
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8					;//%r13 := ap = &...
	add	%r13,0x8
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+4]					;//%r14 := hitval_sel
LOT_get_table_weight_a:		;//AZuvOł́A
LOT_get_table_weight_v:		;//̓̊֐͓łB
		;//%r12    := table
		;//%r13    := pid = ap
		;//%r14    := hitval_sel
	ext	LOT_get_column_weight+0x0@h	; 		xld.w		%r15, LOT_get_column_weight			;//%r15 := LOT_get_column_weight
	ext	LOT_get_column_weight+0x0@m
	ld.w	%r15,LOT_get_column_weight+0x0@l
	jp	LOT_seek_and_call	; 		xjp		LOT_seek_and_call				;//return LOT_seek_and_call(table, pid, hitval_sel, LOT_get_column_weight)

	
		.code
		.align		1
		.global		LOT_get_table_column_id
LOT_get_table_column_id:
		;//%r12 := table
		;//%r13 := i_column
		;//%r14 := pid
		ld.uh		%r4, [%r12]+					;//%r4  := table_size = *table++
		ld.uh		%r5, [%r12]+					;//%r5  := id_size    = *table++
		cmp		%r4, %r13					;//if(table_size <= i_column) { DIE() }
		jrle		LOT_get_table_column_id_DIE
		sla		%r5, 1						;//%r5  := id_size * sizeof(unsigned short)
LOT_get_table_column_id_L1:							;//for(;;) {
		;//%r5  := id_size * sizeof(unsigned short)
		;//%r12 := table
		;//%r13 := i_column
		;//%r14 := pid
		sub		%r13, 1						;//%r13 := i_column--
		jrlt		LOT_get_table_column_id_L2			;//if(i_column < 0) { break }
		add		%r12, %r5					;//%r12 := table += (    id_size     * sizeof(unsigned short))
		ld.uh		%r6, [%r12]+					;//%r6  :=           column_size = *table++
		sla		%r6, 2						;//%r6  :=          (column_size * 2 * sizeof(unsigned short))
		jp.d		LOT_get_table_column_id_L1			;//}
		add		%r12, %r6					;//%r12 := table += (column_size * 2 * sizeof(unsigned short))	*delay*
LOT_get_table_column_id_L2:							;//for(;;) {
		;//%r5  := id_size * sizeof(unsigned short)
		;//%r12 := table
		;//%r14 := pid
		sub		%r5, 2						;//%r5  := (id_size * sizeof(unsigned short)) -= sizeof(unsigned short)
		jrlt		LOT_get_table_column_id_L3			;//     if((id_size * sizeof(unsigned short)) < 0) { break }
		ld.uh		%r4, [%r12]+					;//%r4  :=  id = *table++
		ld.w		[%r14]+, %r4					;//*pid++ = id
		jp		LOT_get_table_column_id_L2			;//}
LOT_get_table_column_id_L3:
		ld.w		%r4, -1						;//%r4  :=  id = -1
		ld.w		[%r14], %r4					;//*pid   = id
		ret

; NO_APP
	.align	1
LOT_get_table_column_id_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002c6		; 710
	ld.w	%r13,0x6
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP
	
		.code
		.align		1
		.global		LotSym_ConvTo
		.global		LotSym_ConvFrom
LotSym_ConvTo:
	ext	0x3ff		; 		xld.w		%r4, 0xFFFF			;//%r4  := USHRT_MAX
	ld.w	%r4,0x3f
LotSym_ConvTo_LOOP:						;//for(;;) {
		ld.uh		%r5, [%r12]+			;//  %r5  := xValue = *p++
		ld.uh		%r10, [%r12]+			;//  %r10 := yValue = *p++
		cmp		%r5, %r4			;//  if(xValue == USHRT_MAX) { DIE() }
		jreq		LotSym_ConvTo_ConvFrom_DIE	;//
		cmp		%r5, %r13			;//  if(xValue == x) { break }
		jrne		LotSym_ConvTo_LOOP		;//}
		ret						;//return yValue
LotSym_ConvFrom:
	ext	0x3ff		; 		xld.w		%r4, 0xFFFF			;//%r4  := USHRT_MAX
	ld.w	%r4,0x3f
LotSym_ConvFrom_LOOP:						;//for(;;) {
		ld.uh		%r10, [%r12]+			;//  %r10 := xValue = *p++
		ld.uh		%r5, [%r12]+			;//  %r5  := yValue = *p++
		cmp		%r10, %r4			;//  if(xValue == USHRT_MAX) { DIE() }
		jreq		LotSym_ConvTo_ConvFrom_DIE	;//
		cmp		%r5, %r13			;//  if(yValue == y) { break }
		jrne		LotSym_ConvFrom_LOOP		;//}
		ret						;//return xValue

; NO_APP
	.align	1
LotSym_ConvTo_ConvFrom_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002fd		; 765
	ld.w	%r13,0x3d
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
