/*	
 *	clipir.c
 *
 *	ԊOʐM (24/48MHzΉ)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sat Mar 05 15:53:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Nov 27 12:03:36 JST 2007 Naoyuki Sawa
 *	- TxBit()́A[_ƃg[̔p^[ɊւRg܂B
 *	  ԈĂ̂̓RgŁAvO͐̂ŁAύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* - gg߂16rbg^C}5̒萔
 *
 *	vXP[16bit^C}5ւ̏o̓NbN = 24MHz
 *	ԊOʐM̔gg = 37.9KHz (̎dlł)
 *	24MHz / 38KHz = 633.245... -> 633
 */
#define IRCNT	(633)

#define IRBC1	(12)	/* 1()->0()  = (1/37.9K)[sec]~ IRBC1                */
#define IRBC2	(8)	/* 0()->1()  = (1/37.9K)[sec]~(IRBC1+IRBC2~{0..3}) */

typedef struct _IR {
	int stat;		/* 0 = ~, 1 = ʐM */
	//
	unsigned char* data;	/* M: ̑Mf[^ǂݏoʒu */
				/* M: ̎Mf[^݈ʒu */
	int len;		/* M: Mf[^oCg(Œ) */
				/* M: Mf[^oCg(Œ) */
	int pos;		/* M: Mς݃oCg */
				/* M: Mς݃oCg */
	//
	int tcnt;		/* M: 0()<->1() Ԃ̃JEg_E */
				/* M: O16bit^C}5JE^f[^ۑ */
	int bcnt;		/* M: pXJEgAbv */
				/* M: pXJEgAbv */
	int dat;		/* M: M̈ꎞf[^ */
				/* M: M̈ꎞf[^ */
	//
	void (*callback)();	/* ʐMɌĂяoR[obN (NULL: ) */
} IR;
static IR _ir;
static int mode = 1;	/* P/ECE KernelԊOʐMƂ̌݊ (0 = ݊, 1 = ݊) */

/****************************************************************************
 *	
 ****************************************************************************/

static void _irt_isr() __attribute__((unused));
static int  TxBit();
static void _irr_isr() __attribute__((unused));
static void RxBit(unsigned n);

/* - P/ECE Kernel̐ԊOʐḾAMf[^̂܂܃GR[hɁA
 *   ȂACRC32e[u̒lƂXorĂGR[hĂ܂B
 *   邱ƂɂāAǂ̂悤Ȍʂ̂łĂ܂BBB
 * - ݊[h(mode=1)ł́ACRC32e[u̒lƂXorĂGR[h܂B
 *   CRC32e[u̒ĺACRC32e[uɁAvZŋ߂邱Ƃɂ܂B
 * - ݊[h(mode=0)ł́AMf[^̂܂܃GR[h܂B
 */
static int
crctable_entry(unsigned c)
{
#define POLY	((1<<(31-26))|	\
		 (1<<(31-23))|	\
		 (1<<(31-22))|	\
		 (1<<(31-16))|	\
		 (1<<(31-12))|	\
		 (1<<(31-11))|	\
		 (1<<(31-10))|	\
		 (1<<(31- 8))|	\
		 (1<<(31- 7))|	\
		 (1<<(31- 5))|	\
		 (1<<(31- 4))|	\
		 (1<<(31- 2))|	\
		 (1<<(31- 1))|	\
		 (1<<(31- 0)))

	int i = 8;
	do {
		if(c & 1) {
			c = (c >> 1) ^ POLY;
		} else {
			c = (c >> 1);
		}
	} while(--i);
	return c;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
ir_mode(int _mode_)
{
	/* ʐMɐݒύXĂ͂܂B */
	if(ir_stat()) {
		DIE();
	}

	/* ʐMtH[}bgi[܂B */
	mode = _mode_;
}

void
ir_stop()
{
	IR* const ir = &_ir;

ENTER_CS;

	/* IR\̃NAB(Kv!!) */
	memset(ir, 0, sizeof(IR));

	/*** P27ݒ (ԊOo) ***/

	/* P27 I/O = o */
	bP2_IOC2_IOC27 = 1; /* Œ聚 */

	/* P27o͌p|[gf[^ = 1 () */
	bP2_P2D_P27D = 1; /* Œ聚 */

	/* P27@\I = P27 () */
	bP2_CFP2_CFP27 = 0;

	/*** P34ݒ (ԊO̓p[) ***/

	/* P34@\I = P34 */
	bP3_CFP3_CFP34 = 0; /* Œ聚 */

	/* P34 I/O = o */
	bP3_IOC3_IOC34 = 1; /* Œ聚 */

	/* P34o͌p|[gf[^ = 0 (Off) */
	bP3_P3D_P34D = 0;

	/*** 16bit^C}5vXP[ݒ ***/

	/* 16bit^C}5NbN = Off */
	bCLKCTL_T16_5_P16TON5 = 0;

	/*** 16bit^C}5ݒ ***/

	/* 16bit^C}5NbNo͐ = OffAStop */
	pT16_CTL5 = 0;

	/*** 16bit^C}5荞ݐݒ ***/

	/* 16bit^C}5RyAA荞 = ֎~ */
	bINT_E16T45_E16TC5 = 0;

	/*** |[g2荞ݐݒ ***/

	/* |[g2荞 = ֎~ */
	bINT_EK01_EP03_EP2 = 0;

LEAVE_CS;
}

int
ir_stat()
{
	IR* const ir = &_ir;

	return ir->stat;
}

/****************************************************************************
 *	M
 ****************************************************************************/

void
ir_send(const void* data, int len, void (*callback)())
{
	IR* const ir = &_ir;

	/* 1oCg̒ʐM͕słB
	 * (ir->len > 0 ł邱ƂɈˑR[fBOĂ܂B)
	 */
	if(len <= 0) {
		DIE();
	}

ENTER_CS;

	/* ܂Amɒ~܂B */
	ir_stop();

	///* IR\̃NAB */
	//memset(ir, 0, sizeof(IR));
	//ir_stop()ŃNAς݂łB

	ir->stat = 1;
	ir->callback = callback;
	ir->data = (unsigned char*)data;
	ir->len = len;
	ir->pos = -1; /* [_M */
	ir->tcnt = 1; /* ͂ɔJn */

	/*** P27ݒ (ԊOo) ***/

	//
	//dv!!댯!!dv!!댯!!dv!!댯!!dv!!댯!!dv!!댯!!dv!!댯!!dv
	//
	// - P27o = 1 ƂƁAP27@\I = P27 ƂƂɏ܂B         
	// - P27o = 0 ƂƁAP27@\I = P27 ƂƂɓ_܂܂ɂȂA 
	//   dꂷĊ댯ł̂ŁA΂ P27 = 0 ƂĂ͂܂B        
	// - ԊOLED́A^C}ɂu_Łv܂́uv̂ꂩ̏ԂƂA    
	//   _܂܂̏ԂɂĂ͂܂B                                   
	// - ]āAP27 I/OAP27o͌p|[gf[^1ŒŎgp܂B    
	//   ω̂́AP27@\I = P27/TM5 ݂̂łB                         
	// - P27@\I = TM5 ̏ԂŁAWX^ɂ^C}~ƁA 
	//   ԊOLED_܂܂ɂȂAP27 = 0 ƓlɊ댯łB                
	// - ԊOo͒́A΂Ƀ^C}~Ȃ悤A[ɒӂĂB   
	//

	///* P27 I/O = o */
	//bP2_IOC2_IOC27 = 1; /* Œ聚 */
	//ir_stop()ɂĐݒς݂łB

	///* P27o͌p|[gf[^ = 1 () */
	//bP2_P2D_P27D = 1; /* Œ聚 */
	//ir_stop()ɂĐݒς݂łB

	/* P27@\I = P27 () */
	bP2_CFP2_CFP27 = 0;

	/*** 16bit^C}5vXP[ݒ ***/

	/* 16bit^C}5NbNI = /1 or /2 */
	if(bP0_P0D_P07D) { /* P07 = 1 (24MHz) */
		bCLKCTL_T16_5_P16TS5 = 0; /* /1 */
	} else {           /* P07 = 0 (48MHz) */
		bCLKCTL_T16_5_P16TS5 = 1; /* /2 */
	}

	/* 16bit^C}5NbN = On */
	bCLKCTL_T16_5_P16TON5 = 1;

	/*** 16bit^C}5ݒ ***/

	/* 16bit^C}5RyAf[^A */
	pT16_CR5A = IRCNT / 2 - 1;

	/* 16bit^C}5RyAf[^B */
	pT16_CR5B = IRCNT - 1;

	/* 16bit^C}5NbNo͐ = OnAZbgARun */
	pT16_CTL5 = 7;

	/*** 16bit^C}5荞ݐݒ ***/

	/* 16bit^C}5荞݃x = 7 (ō) */
	bINT_P16T45_P16T5 = 7;

	/* 16bit^C}5RyAA荞 =  */
	bINT_E16T45_E16TC5 = 1;

	/* 荞݃T[rX[`CXg[܂B */
	{
		extern void irt_isr();
		pceVectorSetTrap(TRAP_16TC5, irt_isr);
	}

LEAVE_CS;
}

asm("
	.code
	.align	1
irt_isr:
	pushn	%r15
	ld.w	%r0, %alr
	ld.w	%r1, %ahr
	pushn	%r1
	call	_irt_isr
	popn	%r1
	ld.w	%ahr, %r1
	ld.w	%alr, %r0
	popn	%r15
	reti
");

static void
_irt_isr()
{
	IR* const ir = &_ir;

	/* 16bit^C}5RyAA荞ݗvtONAB */
	bINT_F16T45_F16TC5 = 0;

	/* 0()->1() ܂ 1()->0() Ԃ^CAEg... */
	if(!--ir->tcnt) {

		/* Ȃ... */
		if(bP2_CFP2_CFP27) {

			/* P27@\I = P27 () */
			bP2_CFP2_CFP27 = 0;

			/* 0()->1() Ԃ擾B */
			ir->tcnt = TxBit();

		/* Ȃ... */
		} else {

			/* P27@\I = TM5 () */
			bP2_CFP2_CFP27 = 1;

			/* 1()->0() (Œ)B */
			ir->tcnt = IRBC1;
		}
	}
}

static int
TxBit()
{
	IR* const ir = &_ir;
	//
	void (*callback)();
	int retv;

	/* pXJEgAbvB */
	ir->bcnt++;

	/*** [_M ***/

	/* [_MȂ... */
	if(ir->pos < 0) {

		///* ܂16pXĂȂ... */
		// * Tue Nov 27 12:03:36 JST 2007 Naoyuki Sawa
		// - [_16pXł͂ȂA15pX̊ԈႢłB
		//   ir->bcnt0JnāAvCNgA16ƂłB
		//   ԈĂ̂̓RgŁAvO͂̂܂܂ŐłB
		//   P/ECE KerneldlłB
		// - t[擪́A[_p^[́Aȉ̂ƂłB
		//
		//	@@@@@@@@@@@@@@@@@@@@c@@@@@@@@@@@@@@@@@@@@@@@@
		//	@@@@@@@@@@@@@@@@c
		//	℠IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1+IRBC2*4 @@@IRBC1+IRBC2*4 IRBC1 IRBC1+IRBC2*4 IRBC1 @@@@@
		//	~ 1pXڄ 2pXڄ@@@14pXڄ15pXڄ@@@@@@@@@
		//	󄠁[_f[^{̄@c
		//	Ԅt[@c
		//
		/* ܂15pXĂȂ... */
		if(ir->bcnt < 16) {

			/* [_M 0()->1() ԁB */
			retv = IRBC1 + IRBC2 * 4;

			return retv;
		}

		///* 16pXAf[^MֈڍsB */
		// * Tue Nov 27 12:03:36 JST 2007 Naoyuki Sawa
		// - [_16pXł͂ȂA15pX̊ԈႢłB
		//   ̃RgQƂĂB
		/* 15pXAf[^MֈڍsB */
		ir->pos = 0;
		//ir->bcnt = 4;
		// ir->bcnt=16 Ȃ̂ŕsvłB

		/* FALLTHRU */
	}

	/*** f[^M ***/

	/* 4pXMς(܂̓[_M)Ȃ... */
	if(ir->bcnt >= 4) {

		/* ܂Mf[^L... */
		if(ir->pos < ir->len) {

			/* Mf[^ǂݏoB */
			ir->pos++; /* crctable_entry(0)͎gȂdl */
			if(mode) { /* 1: ݊[h */
				ir->dat = *ir->data++ ^ (unsigned char)crctable_entry(ir->pos);
			} else {   /* 0: ݊[h */
				ir->dat = *ir->data++;
			}
			ir->bcnt = 0;

		/* Mf[^... */
		} else {

			/* - Ō̃f[^̌ɁA8pX̃g[𑗐MāAMI܂B
			 *   Mf[^oCgAMvf[^oCgZꍇɁA
			 *   RxBitf[^I[oāAM𒆒f邽߂ɗp܂B
			 *   Mf[^oCgƎMvf[^oCgꍇA܂́A
			 *   Mf[^oCg̕傫ꍇɂ́Ag[͖ӖłB
			 * - ݊[hł́AMoCgKvĂ̂Ɖ肵āA
			 *   g[𑗐MAɑMI܂B
			 */
			if((!mode) ||             /* 0: ݊[h or  */
			   (ir->bcnt >= 4 + 8)) { /* g[M    */
				callback = ir->callback; /* ir_stop()ŃNA邩 */
				ir_stop();
				if(callback) {
					callback();
				}
				return 0;
			}

			///* g[ 0()->1() ԁB
			// * - {́AP/ECE Kernel̐ԊOʐM̃g[́A
			// *	()-[Z]->()-[]->()->[]->()-[]->
			// *   Ƃp^[łB{W[̃g[́A
			// *	()-[Z]->()-[]->()->[Z]->()-[]->
			// *   Ƃp^[łA̓[_ƓłB
			// *   ɂP/ECE KernelƓł͂Ȃ̂łA肠܂B
			// *   P/ECE Kernel̎ḾA锭玟̔܂ł̎ԂƂ
			// *   g[ôŁAZEEẼp^[ɂ͓ɈӖłB
			// */
			// * Tue Nov 27 12:03:36 JST 2007 Naoyuki Sawa
			// - ̃RgɏAg[p^[͌łB
			//   ́AȉɒRĝƂłB
			// - t[́Ag[p^[́Aȉ̂ƂłB
			//
			//	[P/ECE Kernel]
			//	@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
			//	c@@@@@@@@@@@@@@@@@@@@@@@@@@@@
			//	@@@@@@@@@IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1 IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1 IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1 IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1 IRBC1 
			//	@@@@@@@@@ 1pXڄ 2pXځ 3pXڄ 4pXځ 5pXڄ 6pXځ 7pXڄ 8pXځ@@@~
			//	c@f[^{́g[
			//	c@t[
			//	
			//	[{W[]
			//	@@@@@@@@@@@@@@@@@@@@@@@@@@@@c@@@@@@@@@@@@@@@@@@@@
			//	c@@@@@@@@@@@@@@@@
			//	@@@@@@@@@IRBC1 IRBC1+IRBC2*4 IRBC1 IRBC1+IRBC2*4 @@@IRBC1+IRBC2*4 IRBC1 IRBC1+IRBC2*4 IRBC1 
			//	@@@@@@@@@ 1pXڄ 2pXڄ@@@ 7pXڄ 8pXڄ@@@~
			//	c@f[^{́g[
			//	c@t[
			//
			/* g[ 0()->1() ԁB
			 * - {́AP/ECE Kernel̐ԊOʐM̃g[́A
			 *	()-[Z]->()-[]->()->[Z]->()-[Z]->()
			 *   Ƃp^[łB{W[̃g[́A
			 *	()-[Z]->()-[]->()->[Z]->()-[]->()
			 *   Ƃp^[łA̓[_ƓłB
			 *   ɂP/ECE KernelƓł͂Ȃ̂łA肠܂B
			 *   P/ECE Kernel̎ḾAu()-[Z]->()-[]->()v𔭌_ŁAg[ƔfāAMł؂܂B
			 *   ҂Ƃ擪́u()-[Z]->()-[]->()v͋ʂȂ̂ŁAȍ~̔p^[ĂĂełB
			 * - ȂAP/ECE Kernel̃g[́AӖ̖u()->[Z]->()-[Z]->()vƂp^[܂ł̂słB
			 */
			retv = IRBC1 + IRBC2 * 4;

			return retv;
		}
	}

	/* f[^M 0()->1() ԁB */
	retv = IRBC1 + IRBC2 * (ir->dat & 3);
	ir->dat >>= 2;

	return retv;
}

/****************************************************************************
 *	M
 ****************************************************************************/

void
ir_recv(void* data, int len, void (*callback)())
{
	IR* const ir = &_ir;

	/* 1oCg̒ʐM͕słB
	 * (ir->len > 0 ł邱ƂɈˑR[fBOĂ܂B)
	 */
	if(len <= 0) {
		DIE();
	}

ENTER_CS;

	/* ܂Amɒ~܂B */
	ir_stop();

	///* IR\̃NAB */
	//memset(ir, 0, sizeof(IR));
	//ir_stop()ŃNAς݂łB

	ir->stat = 1;
	ir->callback = callback;
	ir->data = (unsigned char*)data;
	ir->len = len;
	ir->pos = -1; /* [_M */
	ir->tcnt = 0; /* 16bit^C}5JEgf[^l */

	/*** P34ݒ (ԊO̓p[) ***/

	///* P34@\I = P34 */
	//bP3_CFP3_CFP34 = 0; /* Œ聚 */
	//ir_stop()ɂĐݒς݂łB

	///* P34 I/O = o */
	//bP3_IOC3_IOC34 = 1; /* Œ聚 */
	//ir_stop()ɂĐݒς݂łB

	/* P34o͌p|[gf[^ = 1 (On) */
	bP3_P3D_P34D = 1;

	/*** 16bit^C}5vXP[ݒ ***/

	/* - 16bit^C}̃vXP[ݒɂ̓/32߂ɁA
	 *   vXP[ݒɂ24MHz/48MHz̍zł܂B
	 * - d̂ŁAJEgf[^ǂݏoɁA
	 *   48MHz̏ꍇ͑1/2āA24MHzɍ킹邱Ƃɂ܂B
	 */

	/* 16bit^C}5NbNI = /16 */
	bCLKCTL_T16_5_P16TS5 = 3;

	/* 16bit^C}5NbN = On */
	bCLKCTL_T16_5_P16TON5 = 1;

	/*** 16bit^C}5ݒ ***/

	/* 16bit^C}5RyAf[^A */
	pT16_CR5A = -1;

	/* 16bit^C}5RyAf[^B */
	pT16_CR5B = -1;

	/* 16bit^C}5NbNo͐ = OffAZbgARun */
	pT16_CTL5 = 3;

	/*** |[g2ݒ ***/

	/* K52@\I = K52 */
	bK5_CFK5_CFK52 = 0;

	/* FPT2荞ݓ̓|[gI = K52 */
	bPINTSEL_SPT03_SPT2 = 1;

	/* FPT2͋ɐI = HighxA܂́AオGbW */
	bPINTPOL_SPPT_SPP2 = 1;

	/* FPT2GbW/xI = GbW */
	bPINTEL_SEPT_SEPT2 = 1;

	/*** |[g2荞ݐݒ ***/

	/* |[g2荞݃x = 7 (ō) */
	bINT_PP23L_PP2L = 7;

	/* |[g2荞 =  */
	bINT_EK01_EP03_EP2 = 1;

	/* 荞݃T[rX[`CXg[܂B */
	{
		extern void irr_isr();
		pceVectorSetTrap(TRAP_P2, irr_isr);
	}

LEAVE_CS;
}

asm("
	.code
	.align	1
irr_isr:
	pushn	%r15
	ld.w	%r0, %alr
	ld.w	%r1, %ahr
	pushn	%r1
	call	_irr_isr
	popn	%r1
	ld.w	%ahr, %r1
	ld.w	%alr, %r0
	popn	%r15
	reti
");

static void
_irr_isr()
{
	IR* const ir = &_ir;
	//
	int a;
	int n;

	/* |[g2荞ݗvtONAB */
	bINT_FK01_FP03_FP2 = 0;

	/* O̔ǒoߎԂ߂܂B */
	a = pT16_TC5;
	n = (unsigned short)(a - ir->tcnt);
	if(!bP0_P0D_P07D) { /* P07 = 0 (48MHz) */
		n >>= 1;
	}
	ir->tcnt = a;

	/* ԊuAMf[^fR[h܂B */
	RxBit(n);
}

static void
RxBit(unsigned n)
{
	IR* const ir = &_ir;
	//
	void (*callback)();

	/* ԊuA2bitMf[^ɕϊ܂B */
	n -= (IRCNT * (IRBC1 * 2 - IRBC2 / 2)) / 16;
	n /= (IRCNT *              IRBC2     ) / 16;

	/* 2bitMf[^Aꎞf[^Ƀ}[W܂B
	 * [_pX̏ꍇ́A_~[ƂȂ܂B
	 */
	ir->dat >>= 2;
	ir->dat |= (n & 3) << 6;

	/* pXJEgAbvB */
	ir->bcnt++;

	/*** [_M ***/

	/* [_MȂ... */
	if(ir->pos < 0) {

		/* [_̃pXԊułȂ... */
		if(n != 4) {

			/* f[^pXƂėLȊԊuŁAA
			 * [_̃pXȂƂ8pXȏMĂ...
			 * (M̓[_16pXM̂ŁA̔ȏ)
			 */
			if((n < 4) && (ir->bcnt >= 8)) {
				/* f[^Mֈڍs܂B */
				ir->pos = 0;
				/* ɂ܁ALȃf[^1pX(=2bit)Mς݂łB */
				ir->bcnt = 1;
			} else {
				/* sȃpXM̂ŁA[_ŏ҂܂B */
				ir->bcnt = 0;
			}
		}

		return;
	}

	/*** f[^M ***/

	/* sȃpXA܂́Ag[MAM𒆒f܂B */
	if(n >= 4) {
		callback = ir->callback; /* ir_stop()ŃNA邩 */
		ir_stop();
		if(callback) {
			callback();
		}
		return;
	}

	/* 4pXMς݂Ȃ... */
	if(ir->bcnt >= 4) {

		/* Mf[^i[܂B */
		ir->pos++; /* crctable_entry(0)͎gȂdl */
		if(mode) { /* 1: ݊[h */
			*ir->data++ = ir->dat ^ (unsigned char)crctable_entry(ir->pos);
		} else {   /* 0: ݊[h */
			*ir->data++ = ir->dat;
		}
		ir->bcnt = 0;

		/* Mobt@ςɂȂAMI܂B */
		if(ir->pos >= ir->len) {
			callback = ir->callback; /* ir_stop()ŃNA邩 */
			ir_stop();
			if(callback) {
				callback();
			}
			return;
		}
	}
}

