/*	
 *	clipintf.h
 *
 *	C^[tFCX
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- C^[tFCX֘A̐錾Aclipmisc.hclipintf.h֕܂B
 *	  C^[tFCX֘A̎͊ɁAclipmisc.cclipintf.c֕Ă̂ŁA񕪗̂͐錾݂̂łB
 *	  錾邱ƂɂŔA錾Ǝ̃t@C̑ΉtAՂ邽߂łB
 */
#ifndef __CLIP_INTF_H__
#define __CLIP_INTF_H__

/*****************************************************************************
 *	[eBeBFȗCOM (Component Object Model)
 *****************************************************************************/

/* QƃJEg̑[ (bŁBTODO:ƂŏڂB)
 *
 *	ȉAĂяo(A)AĂяo鑤(BAC)ƂB
 *
 *	[[1-1]
 *	B̖߂lƂăC^[tFCXԂꍇAÂ߂ɁAQƃJEg+1ĂB
 *	ÁAC^[tFCX̎gpIAQƃJEg-1B
 *
 *		INTERFACE** B() {
 *			safe_addref(g_intf);	// refcnt+1
 *			return g_intf;
 *		}
 *
 *		void A() {
 *			INTERFACE** intf = B();
 *			...
 *			safe_release(intf);	// refcnt-1
 *		}
 *
 *	[[1-2]
 *	BIuWFNg֐łꍇA[[1-1]ɏ]B
 *	܂AB͎QƃJEg1̃IuWFNg쐬ÃC^[tFCXAɕԂB
 *	ÁAԂꂽC^[tFCXAVK쐬ꂽ̂Â̂AfKvB
 *
 *		INTERFACE** B() {
 *			OBJECT** obj = calloc(1, OBJECT);
 *			obj->refcnt = 1;		// refcnt=1
 *			obj->interface = &interface;	// VTBLݒ
 *			...
 *			return &obj->interface;
 *		}
 *
 *		void A() {
 *			INTERFACE** intf = B();
 *			...
 *			safe_release(intf);		// refcnt-1
 *		}
 *
 *	[[2-1]
 *	ABւ͈̓ƂăC^[tFCXnꍇAA͎QƃJEg𑝌ȂB
 *	B́AC^[tFCX̎gp֐݂̂Ȃ΁AQƃJEg𑝌ȂB
 *
 *		void A() {
 *			B(g_intf);
 *		}
 *
 *		void B(INTERFACE** intf) {
 *			...
 *		}
 *
 *	[[2-2]
 *	BAO[oϐɃC^[tFCXێȂ΁AQƃJEg+1B
 *	O[oϐւ̕ێIAQƃJEg-1B
 *
 *		void A() {
 *			B(g_intf);
 *			...
 *			C();
 *		}
 *
 *		void B(INTERFACE** intf) {
 *			g_intf = intf;
 *			safe_addref(g_intf);		// refcnt+1
 *		}
 *
 *		void C(INTERFACE** intf) {
 *			safe_release(g_intf);		// refcnt-1
 *		}
 */

/*---------------------------------------------------------------------------*/

/* C^[tFCX`邽߂̃}NłB
 * * ȈUUIDƂāAW1970/1/1 00:00:00̌oߕb𗘗p܂B
 *   clip/tool/timestmp.exeR}hgāAł܂B
 */
#define DEFINE_INTERFACE(intfname, timestmp, method_list)		\
	enum { intfname##_ID = timestmp };				\
	typedef struct _##intfname intfname;				\
	struct _##intfname {						\
		void* (*query_interface)(intfname** intf, int id);	\
		void  (*addref)(intfname** intf);			\
		void  (*release)(intfname** intf);			\
		method_list						\
	};

/* C^[tFCX(UNKNOWN_INTERFACE)`܂B
 * * method_listł邽߂ɁADEFINE_INTERFACE}Npł܂B
 *   ~ނ𓾂AUNKNOWN_INTERFACÉA}Ng킸ɒ`Ă܂B
 */
enum { UNKNOWN_INTERFACE_ID = 0/*1970/01/01 09:00:00*/ };
typedef struct _UNKNOWN_INTERFACE UNKNOWN_INTERFACE;
struct _UNKNOWN_INTERFACE {
	void* (*query_interface)(UNKNOWN_INTERFACE** intf, int id);
	void  (*addref)(UNKNOWN_INTERFACE** intf);
	void  (*release)(UNKNOWN_INTERFACE** intf);
};

//----------------------------------------------------------------------------
//				
//----------------------------------------------------------------------------
//	
//	/*----- *.ht@CɋLqAJ镔 -----*/
//	
//	DEFINE_INTERFACE(SAMPLE_INTERFACE, 1133444760/*2005/12/01 22:46:00*/,
//		void (*put)(SAMPLE_INTERFACE** intf, int value);
//		int  (*get)(SAMPLE_INTERFACE** intf);
//	);
//	
//	SAMPLE_INTERFACE** sample_create(int initial_value);
//	
//	/*----- *.ct@CɋLqAJ̕ -----*/
//	
//	static void* sample_query_interface(SAMPLE_INTERFACE** intf, int id);
//	static void sample_addref(SAMPLE_INTERFACE** intf);
//	static void sample_release(SAMPLE_INTERFACE** intf);
//	static void sample_put(SAMPLE_INTERFACE** intf, int value);
//	static int sample_get(SAMPLE_INTERFACE** intf);
//	
//	static SAMPLE_INTERFACE sample_interface = {
//		sample_query_interface,
//		sample_addref,
//		sample_release,
//		sample_put,
//		sample_get,
//	};
//	
//	typedef struct _SAMPLE {
//		SAMPLE_INTERFACE* sample_interface;
//		int refcnt;
//		int value;
//	} SAMPLE;
//	
//	SAMPLE_INTERFACE**
//	sample_create(int initial_value)
//	{
//		SAMPLE* this = calloc(1, sizeof(SAMPLE));
//		if(!this) {
//			DIE();
//		}
//		this->sample_interface = &sample_interface;
//		this->refcnt = 1; /* 쐬̎QƃJEg1 */
//		this->value = initial_value;
//		return &this->sample_interface;
//	}
//	
//	static void
//	sample_delete(SAMPLE* this)
//	{
//		free(this);
//		printf("Delete!\n");
//	}
//	
//	static void*
//	sample_query_interface(SAMPLE_INTERFACE** intf, int id)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample_interface);
//		UNKNOWN_INTERFACE** unknown;
//		switch(id) {
//		case UNKNOWN_INTERFACE_ID:
//		case SAMPLE_INTERFACE_ID:
//			unknown = (void*)&this->sample_interface;
//			this->refcnt++; /* query_interface()QƃJEg+1 */
//			break;
//		default:
//			unknown = NULL;
//			break;
//		}
//		return unknown;
//	}
//	
//	static void
//	sample_addref(SAMPLE_INTERFACE** intf)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample_interface);
//		this->refcnt++;
//	}
//	
//	static void
//	sample_release(SAMPLE_INTERFACE** intf)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample_interface);
//		if(!--this->refcnt) {
//			sample_delete(this);
//		}
//	}
//	
//	static void
//	sample_put(SAMPLE_INTERFACE** intf, int value)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample_interface);
//		this->value = value;
//	}
//	
//	static int
//	sample_get(SAMPLE_INTERFACE** intf)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample_interface);
//		return this->value;
//	}
//	
//	/*----- eXgvO -----*/
//	
//	void
//	test_main()
//	{
//		SAMPLE_INTERFACE** sample = sample_create(123);
//		printf("%d\n", (*sample)->get(sample));	/* "123"ƕ\܂ */
//		(*sample)->put(sample, 456);
//		printf("%d\n", (*sample)->get(sample));	/* "456"ƕ\܂ */
//		(*sample)->release(sample);		/* "Delete!"ƕ\܂ */
//	}
//	
//----------------------------------------------------------------------------

/* * IuWFNgƁAquery_interface()̎ȒPɂAwp֐̂߂̍\̂łB
 *   C^[tFCXNXɁA炩INTERFACE_MAP̔z`Ă΁A
 *   IuWFNgquery_interface()̏̑啔Awp֐ɔC܂B
 * * C^[tFCX}bv́AINTERFACE_MAP.id=0̗vfŏI[܂B
 *   C^[tFCXID=0́AۂɂUNKNOWN_INTERFACE_IDɑ̂łA
 *   INTERFACE_MAP̔zɂẮAUNKNOWN_INTERFACE_IDłȂAPȂI[}[NƌȂ܂B
 * * C^[tFCX}bvɂ́AUNKNOWN_INTERFACEɑvf͊܂߂܂B
 *   ̑ɁA擪̃C^[tFCXuÖقUNKNOWN_INTERFACEvƂĈ܂B
 *   UNKNOWN_INTERFACE_IDw肵āAquery_interface_map()ĂяoꍇA
 *   query_interface_map()́AC^[tFCX}bv̐擪̗vf̃C^[tFCXA
 *   uÖقUNKNOWN_INTERFACEvƂāAĂяoɕԂ܂B
 * * q̂悤ɁA擪̃C^[tFCXŒIɁuÖقUNKNOWN_INTERFACEvƂ邽߂ɁA
 *   C^[tFCX}bvɂ́AȂƂȏ̗LȗvfKvłB
 *   Ȃ킿AC^[tFCX}bv̐擪̗vfAid=0łĂ͂܂B
 *   ƁAINTERFACE_MAP𗘗păC^[tFCXǗIuWFNǵA
 *   UNKNOWN_INTERFACEȊOɁAȏ̃C^[tFCXĂKv܂B
 */
typedef struct _INTERFACE_MAP {
	int id;		/* C^[tFCXID (id=0ɂďI[BI[vfoffset,vtbl͖Ӗ) */
	int offset;	/* IuWFNg̐擪AC^[tFCX܂ł̃ItZbgoCg */
	void* vtbl;	/* C^[tFCXVTBL̃|C^ (apply_interface_map()Q) */
} INTERFACE_MAP;

/* IuWFNg쐬ɁAC^[tFCXi[Awp֐łB
 * [in]
 *	this		IuWFNg̐擪AhXB
 *	map		C^[tFCX}bvB
 *			INTERFACE_MAP.id=0̗vfŁAIɔzI[ĂB
 * [note]
 *	* query_interface_map()̃RgƁAq̗pQƂĂB
 */
void apply_interface_map(void* this, const INTERFACE_MAP* map);

/* C^[tFCX}bvAwp֐łB
 * [in]
 *	this		IuWFNg̐擪AhXB
 *	id		C^[tFCXIDB
 *	map		C^[tFCX}bvB
 *			INTERFACE_MAP.id=0̗vfŁAIɔzI[ĂB
 * [out]
 *	߂l		Ȃ΁AQƃJEg+1AC^[tFCXԂ܂B
 *			sȂ΁AQƃJEgύXANULLԂ܂B
 * [note]
 *	* C^[tFCX}bvɁAUNKNOWN_INTERFACEɑΉvf܂߂Ă͂܂B
 *	  id=UNKNOWN_INTERFACE_IDw肳ꂽꍇAŏ̗vf̃C^[tFCXԂ܂B
 *	  Ȃ킿AC^[tFCX}bv̍ŏ̗vfu\UNKNOWN_INTERFACEvɂȂ܂B
 */
void* query_interface_map(void* this, int id, const INTERFACE_MAP* map);

//----------------------------------------------------------------------------
//				p
//----------------------------------------------------------------------------
//	
//	typedef struct _SAMPLE {
//		int refcnt;
//		SAMPLE1_INTERFACE* sample1_interface;
//		SAMPLE2_INTERFACE* sample2_interface;
//		SAMPLE3_INTERFACE* sample3_interface;
//		int value;
//	} SAMPLE;
//	
//	SAMPLE1_INTERFACE sample1_interface = { ... };
//	SAMPLE2_INTERFACE sample2_interface = { ... };
//	SAMPLE3_INTERFACE sample3_interface = { ... };
//	
//	static const INTERFACE_MAP sample_interface_map[] = {
//		{ SAMPLE1_INTERFACE_ID, FIELD_OFFSET(SAMPLE, sample1_interface), &sample1_interface },
//		{ SAMPLE2_INTERFACE_ID, FIELD_OFFSET(SAMPLE, sample2_interface), &sample2_interface },
//		{ SAMPLE3_INTERFACE_ID, FIELD_OFFSET(SAMPLE, sample3_interface), &sample3_interface },
//		{ 0 } /* C^[tFCX}bv̏I[BYȂ!! */
//	};
//	
//	SAMPLE*
//	sample_create()
//	{
//		SAMPLE* this = calloc(1, sizeof(SAMPLE));
//		if(!this) {
//			DIE();
//		}
//		this->refcnt = 1;
//		apply_interface_map(this, sample_interface_map);
//		return this;
//	}
//	
//	static void*
//	sample1_query_interface(SAMPLE1_INTERFACE** intf, int id)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample1_interface);
//		return query_interface_map(this, id, sample_interface_map);
//	}
//	
//	static void*
//	sample2_query_interface(SAMPLE2_INTERFACE** intf, int id)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample2_interface);
//		return query_interface_map(this, id, sample_interface_map);
//	}
//	
//	static void*
//	sample3_query_interface(SAMPLE3_INTERFACE** intf, int id)
//	{
//		SAMPLE* this = CONTAINING_RECORD(intf, SAMPLE, sample3_interface);
//		return query_interface_map(this, id, sample_interface_map);
//	}
//	
//----------------------------------------------------------------------------

/* C^[tFCX|C^̎QƃJEgA܂B
 * C^[tFCX|C^NULLA܂B
 */
//#define safe_addref(ptr) do {		\
//	if(ptr) {			\
//		(*(ptr))->addref(ptr);	\
//	}				\
//} while(0)
//2005/12/10 safe_addref(ptr)AptrԂ悤ɕύX܂B
//̂悤ȎdlƂŔAsafe_addref(ptr)̌AptrԂ֐̂߂łB
//q́AQƃJEg̑[[[1-1]QƂĂB
//܂ł́A
//	safe_addref(ptr);
//	return ptr;
//ƋLqĂÁA
//	return safe_addref(ptr);
//ƋLq邱Ƃł悤ɂȂ܂B
#define safe_addref(ptr) ((ptr) ? ((*(ptr))->addref(ptr), (ptr)) : (ptr))

/* C^[tFCX|C^̎QƃJEgANULLɂ܂B
 * C^[tFCX|C^ƂNULLA܂B
 */
#define safe_release(ptr) do {		\
	if(ptr) {			\
		(*(ptr))->release(ptr);	\
		(ptr) = NULL;		\
	}				\
} while(0)

/* C^[tFCX|C^ɁAVC^[tFCXATC܂B
 * - dstsrcAIuWFNgwĂ\̂ŁA
 *   VATCC^[tFCX̎QƃJEg𑝉A
 *   C^[tFCX̎QƃJEg邱ƂɒӂĂB
 *   ̎菇tɂƁArŃIuWFNg폜Ă܂܂B
 * - <gp>
 *	SAMPLE_INTERFACE** sample1 = sample_create(123); // sample(123)'s refcnt=1
 *	SAMPLE_INTERFACE** sample2 = sample_create(456); // sample(456)'s refcnt=1
 *	safe_assign(sample1, sample2); // sample(123)'s refcnt=0, sample(456)'s refcnt=2
 */
#define safe_assign(dst, src) do {			\
	UNKNOWN_INTERFACE** __tmp__ = (void*)(dst);	\
	(dst) = (src);					\
	safe_addref(dst);				\
	safe_release(__tmp__);				\
} while(0)

/* C^[tFCX|C^ɁAVC^[tFCXA^b`܂B
 * - VATCC^[tFCX𓾂鎮(src)̒ɁA(dst)܂܂Ă\̂ŁA
 *   (src)]ɁA(dst)̎QƃJEg邱ƂɒӂĂB
 *   ̎菇tɂƁArŃIuWFNg폜Ă܂܂B
 *	<> safe_attach(sample, (*sample)->clone(sample));
 * - safe_assign()Ƃ̈Ⴂ́AVC^[tFCX̎QƃJEg𑝉ȂƂłB
 * - <gp>
 *	SAMPLE_INTERFACE** sample = sample_create(123); // sample(123)'s refcnt=1
 *	safe_attach(sample, sample_create(234)); // sample(123)'s refcnt=0, sample(456)'s refcnt=1
 */
#define safe_attach(dst, src) do {			\
	UNKNOWN_INTERFACE** __tmp__ = (void*)(dst);	\
	(dst) = (src);					\
	safe_release(__tmp__);				\
} while(0)

/* C^[tFCXoAC^[tFCX|C^NA܂B
 * - QƃJEg̑A͔܂B
 * - P/ECEł́AGCCg@\𗘗pāA}N݂̂Œ`Ă܂B
 *   Win32ł́AGCCg@\płȂ߁A}NƃCC֐Œ`Ă܂B
 *   Win32ł́Aނ𓾂(void*)ւ̃LXgs߁A^`FbNÂȂ܂B
 * - <gp>
 *	SAMPLE_INTERFACE** sample = sample_create(123); // sample(123)'s refcnt=1
 *	return safe_detach(sample); // sample(123)'s refcnt=1
 *   q̎gṕAsafe_detach()g킸APɁA
 *	return sample_create(123);
 *   ƕύX@łAʂ܂B
 */
#ifdef PIECE
#define safe_detach(ptr) ({			\
	typeof(ptr) __tmp__ = (ptr);		\
	(ptr) = NULL;				\
	__tmp__;				\
})
#else /*PIECE*/
#define safe_detach(ptr) _safe_detach(&(ptr))
static __inline void* _safe_detach(void* _pptr) {
	UNKNOWN_INTERFACE*** pptr = _pptr;
	UNKNOWN_INTERFACE**   ptr = *pptr;
	*pptr = NULL;
	return ptr;
}
#endif /*PIECE*/

/* Squery_interface()Ăяos܂B
 * - C^[tFCX|C^NULLłȂ΁Aquery_interface()ĂяoA߂lK؂ɃLXg܂B
 *   C^[tFCX|C^NULLȂ΁Aquery_interface()ĂяoɁANULLԂ܂B
 * - P/ECEł́AGCCg@\𗘗pAptr𕡐]ȂASȎƂȂĂ܂B
 *   Win32ł́AGCCg@\płȂ߁Aނ𓾂Aptr𕡐]Ă܂B
 *   ptrɁA֐Ăяo܂ގAp̂鎮w肵Ȃ悤AӂĂB
 * - <gp>
 *	SAMPLE_INTERFACE** sample = safe_query_interface(unknown, SAMPLE_INTERFACE);
 */
#ifdef PIECE
#define safe_query_interface(ptr, intfname) ((intfname**)({			\
	typeof(ptr) __tmp__ = (ptr);						\
	(__tmp__) ? (*(__tmp__))->query_interface((__tmp__), intfname##_ID)	\
	      : NULL;								\
}))
#else /*PIECE*/
#define safe_query_interface(ptr, intfname) ((intfname**)(	\
	(ptr) ? (*(ptr))->query_interface((ptr), intfname##_ID)	\
	      : NULL						\
))
#endif /*PIECE*/

/* safe_query_interface()safe_attach()́AɎgP[X̂ŁAȗ\Lpӂ܂B
 * ȉ̃R[h:
 *	SAMPLE1_INTERFACE** sample1 = ...;
 *	SAMPLE2_INTERFACE** sample2 = ...;
 *	safe_attach(sample2, safe_query_interface(sample1, SAMPLE2_INTERFACE));
 * Â悤ɋLqł܂B
 *	SAMPLE1_INTERFACE** sample1 = ...;
 *	SAMPLE2_INTERFACE** sample2 = ...;
 *	safe_assign_interface(sample2, sample1, SAMPLE2);
 * safe_attach_interface()ł͂ȂAsafe_assign_interface()Ƃ}NɂŔA
 * IuWFNg̎QƃJEg̍vAV1邱Ƃ邽߂łB
 */
#define safe_assign_interface(dst_ptr, src_ptr, dst_intfname)			\
	safe_attach((dst_ptr), safe_query_interface((src_ptr), dst_intfname))

/* ̃C^[tFCX|C^AIuWFNgɑ̂ۂAׂ܂B
 * IuWFNgɑ̂Ȃ1AȂ0Ԃ܂B
 * - ȉ̂ꂩɈvꍇAIuWFNgɑƔf܂B
 *	@intf1intf2ANULL̏ꍇB
 *	Aintf1intf2ɑ΂AIUNKNOWN_INTERFACEvA炪vꍇB
 * - P/ECEł́AGCCg@\𗘗pāA}N݂̂Œ`Ă܂B
 *   Win32ł́AGCCg@\płȂ߁A}NƃCC֐Œ`Ă܂B
 *   Win32ł́Aނ𓾂(void*)ւ̃LXgs߁A^`FbNÂȂ܂B
 * - .NET FrameworḱAObject.ReferenceEquals\bhAO؂܂B
 */
#ifdef PIECE
#define reference_equals(intf1, intf2) ({						\
	UNKNOWN_INTERFACE** unk1 = safe_query_interface((intf1), UNKNOWN_INTERFACE);	\
	UNKNOWN_INTERFACE** unk2 = safe_query_interface((intf2), UNKNOWN_INTERFACE);	\
	if(unk1) (*unk1)->release(unk1);						\
	if(unk2) (*unk2)->release(unk2);						\
	unk1 == unk2;									\
})
#else /*PIECE*/
#define reference_equals(intf1, intf2) _reference_equals((void*)(intf1), (void*)(intf2))
static __inline int _reference_equals(UNKNOWN_INTERFACE** intf1, UNKNOWN_INTERFACE** intf2) {
	UNKNOWN_INTERFACE** unk1 = safe_query_interface((intf1), UNKNOWN_INTERFACE);
	UNKNOWN_INTERFACE** unk2 = safe_query_interface((intf2), UNKNOWN_INTERFACE);
	if(unk1) (*unk1)->release(unk1);
	if(unk2) (*unk2)->release(unk2);
	return unk1 == unk2;
}
#endif /*PIECE*/

#endif//__CLIP_INTF_H__
