/*
 *	clipint.c
 *
 *	ZCu
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Sat Sep 12 20:19:17 JST 2009 Naoyuki Sawa
 *	- VK쐬B
 *	- clipflt.hW[݊dl̐łłB
 *	  render_vec2i_alternate_concaves()Kv̂ŁÂ߂̍ŏ̊֐ȊO͂قƂǖłB
 *	* Sun Sep 13 15:47:06 JST 2009 Naoyuki Sawa
 *	- vec2i_is_point_in_concave()AZuA܂B
 */
#include "clip.h"

#ifndef PIECE
#define NOASM	// ̃V|`ƁACłgp܂B */
#endif /*PIECE*/

/****************************************************************************
 *	xNg(2D)
 ****************************************************************************/

#define vec2i_sub(vec1, vec2)	\
	(vec1)->x -= (vec2)->x;	\
	(vec1)->y -= (vec2)->y;

#define vec2i_cross(vec1, vec2)	\
	(((vec1)->x * (vec2)->y) - ((vec1)->y * (vec2)->x))

/*--------------------------------------------------------------------------*/

/* _pƁAv[nv]𒸓_Ƃ鉚p`̓O */
#ifdef NOASM
int vec2i_is_point_in_concave(const vec2i* p, const vec2i* v/*[nv]*/, int nv) {
	int i;
	int j;
	int n;
	const vec2i* vi;
	const vec2i* vj;
	int xmin;
	int xmax;
	int ymin;
	int ymax;
	int prev;
	int f;
	vec2i v0;
	vec2i v1;

	/* ΂̒_ȂAɋE{bNX߁A܂ȓ蔻s܂B */
	i = j = nv;
	vi = vj = v;
	xmin = xmax = vj->x;
	ymin = ymax = vj->y;
	vj++;
	j--;
	do {
		if((vj->x < xmin)) {
			xmin = vj->x;
		} else if(vj->x > xmax) {
			xmax = vj->x;
		}
		if((vj->y < ymin)) {
			ymin = vj->y;
			i = j;
			vi = vj;
		} else if(vj->y > ymax) {
			ymax = vj->y;
		}
		vj++;
	} while(--j);
	if((p->x < xmin) || (p->x > xmax) ||
	   (p->y < ymin) || (p->y > ymax)) {
		return 0;
	}

	/* _n_Ƃ锼ƁAp`̕ӂ̌񐔂AȂΓAȂΊOłB */
	prev = 0;
	n = 0;
	j = nv;
	do {
		v0 = *vi;
		v1 = *vi;
		vi++;
		if(!--i) {
			vi = v;
		}
		vec2i_sub(&v0, p);
		vec2i_sub(&v1, vi);
		f = vec2i_cross(&v0, &v1);
		if(!f) {					/* _pӂ̒ɂꍇ̓ʏ */
			if(v0.x) {				/* _pӂ̎n_łȂA */
				if(v0.x < 0) {			/* _pӂ̎n_EŁA */
					if(v0.x < v1.x) {	/* _pӂ̏I_EȂA */
						goto NOT_ON_LS;	/* _p͕ӂ̐ł͂Ȃ̂ŏp */
					}
				} else/*if(v0.x > 0)*/ {	/* _pӂ̎n_ŁA */
					if(v0.x > v1.x) {	/* _pӂ̏I_ȂA */
						goto NOT_ON_LS;	/* _p͕ӂ̐ł͂Ȃ̂ŏp */
					}
				}
			}
			if(v0.y) {				/* _pӂ̎n_łȂA */
				if(v0.y < 0) {			/* _pӂ̎n_ŁA */
					if(v0.y < v1.y) {	/* _pӂ̏I_ȂA */
						goto NOT_ON_LS;	/* _p͕ӂ̐ł͂Ȃ̂ŏp */
					}
				} else/*if(v0.y > 0)*/ {	/* _pӂ̎n_ŁA */
					if(v0.y > v1.y) {	/* _pӂ̏I_ȂA */
						goto NOT_ON_LS;	/* _p͕ӂ̐ł͂Ȃ̂ŏp */
					}
				}
			}
			return -1;				/* _p͕ӂ̐ł */
NOT_ON_LS:							/* _p͕ӂ̐ł͂Ȃ̂ŏp */
		}
		if(v1.y) {
			if(v1.y < 0) {
				if((f < 0) && (v1.y <= v0.y)) {
					if(prev < 0) {
						if(v0.y < 0) {
							n ^= 1;
						}
					} else {
						if(v0.y <= 0) {
							n ^= 1;
						}
					}
				}
			} else /* if(v1.y > 0) */ {
				if((f > 0) && (v1.y >= v0.y)) {
					if(prev > 0) {
						if(v0.y > 0) {
							n ^= 1;
						}
					} else {
						if(v0.y >= 0) {
							n ^= 1;
						}
					}
				}
			}
			prev = v1.y;
		}
	} while(--j);
	return n; /* 0 or 1 */
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec2i_is_point_in_concave
vec2i_is_point_in_concave:
		pushn		%r3
		;// %r12 := p
		;// %r13 := v
		;// %r14 := nv
		;//-----------------------------------------------------;
		ld.w		%r2, %r14				;// %r2  := j = nv
		ld.w		%r3, %r13				;// %r3  := vj = v
		ld.w		%r4, [%r3]+				;// %r4  := xmin = vj->x
		ld.w		%r5, [%r3]+				;// %r5  := ymin = vj->y, %r3  := vj++
		ld.w		%r6, %r4				;// %r6  := xmax = vj->x
		ld.w		%r7, %r5				;// %r7  := ymax = vj->y
		sub		%r2, 1					;// %r2  := j--
		ld.w		%r0, %r2				;// %r0  :=  i - 1 =  j ( i1lێĂAmɖ߂B)
		ld.w		%r1, %r3				;// %r1  := vi + 1 = vj (vi1i񂾒lێĂAmɖ߂B)
		;// %r0  :=  i - 1
		;// %r1  := vi + 1
		;// %r2  := j
		;// %r3  := vj
		;// %r4  := xmin
		;// %r5  := ymin
		;// %r6  := xmax
		;// %r7  := ymax
		;// %r12 := p
		;// %r13 := v
		;// %r14 := nv
vec2i_is_point_in_concave_LOOP1:					;// do {
		ld.w		%r10, [%r3]+				;//   %r10  := vj->x
		ld.w		%r11, [%r3]+				;//   %r11  := vj->y, %r3  := vj++
		;//
		cmp		%r10, %r4				;//   if(vj->x < xmin)
		jrge.d		3
		cmp		%r10, %r6				;//   <-------------------------+	*delay*
		 ld.w		%r4, %r10				;//     %r4  := xmin = vj->x	|
		;//							;//				|
;//		cmp		%r10, %r6				;//   if(vj->x > xmax) ---------+
		jrle.d		3
		cmp		%r11, %r5				;//   <-------------------------+	*delay*
		 ld.w		%r6, %r10				;//     %r6  := xmax = vj->x	|
		;//							;//				|
;//		cmp		%r11, %r5				;//   if(vj->y < ymin) ---------+
		jrge.d		3
		cmp		%r11, %r7				;//   <-------------------------+	*delay*
		 ld.w		%r5, %r11				;//     %r5  := ymin = vj->y	|
		;//							;//				|
;//		cmp		%r11, %r7				;//   if(vj->y > ymax) ---------+
		jrle.d		5
		sub		%r2, 1					;//   <-------------------------+	*delay*
		 ld.w		%r7, %r11				;//     %r7  := ymax = vj->y	|
		 ld.w		%r0, %r2				;//     %r0  :=  i - 1 =  j	|
		 ld.w		%r1, %r3				;//     %r1  := vi + 1 = vj	|
		;//							;//				|
;//		sub		%r2, 1					;//   %r2  := j-- --------------+
		jrne		vec2i_is_point_in_concave_LOOP1		;// } while(j)
		;//
		ld.w		%r2, [%r12]+				;// %r2  := p->x
		ld.w		%r3, [%r12]				;// %r3  := p->y
		;//
		cmp		%r2, %r4				;// if(p->x < xmin)
		jrlt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r2, %r6				;// if(p->x > xmax)
		jrgt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r3, %r5				;// if(p->y < ymin)
		jrlt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r3, %r7				;// if(p->y > ymax)
		jrgt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		add		%r0, 1					;// %r0  :=  i ( i1lێĂB im肵̂ŁAŖ߂)
		sub		%r1, 8					;// %r1  := vi (vi1i񂾒lێĂBvim肵̂ŁAŖ߂)
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r13 := v
		;// %r14 := nv
		;//-----------------------------------------------------;
		ld.w		%r10, 0					;// %r10 := n = 0
		ld.w		%r11, 0					;// %r11 := prev = 0
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j = nv
vec2i_is_point_in_concave_LOOP2:					;// do {
		ld.w		%r4, [%r1]+				;//   %r4  := v0.x = vi->x
		ld.w		%r5, [%r1]+				;//   %r5  := v0.y = vi->y, %r1  := vi++
		ld.w		%r6, %r4				;//   %r6  := v1.x = vi->x
		ld.w		%r7, %r5				;//   %r7  := v1.y = vi->y
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r4  := v0.x
		;// %r5  := v0.y
		;// %r6  := v1.x
		;// %r7  := v1.y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j
		sub		%r0, 1					;//   %r0  := i--
		jrne.d		3					;//   if(!i)
		sub		%r4, %r2				;//   <-------------------------+	*delay*
		 ld.w		%r1, %r13				;//     %r1  := vi = v		|
		;//							;//				|
;//		sub		%r4, %r2				;//   %r4  := v0.x -= p->x -----+
		sub		%r5, %r3				;//   %r5  := v0.y -= p->y
		;//
		xld.w		%r12, [%r1+0]				;//   %r12 :=         vi->x
		xld.w		%r15, [%r1+4]				;//   %r15 :=         vi->y
		sub		%r6, %r12				;//   %r6  := v1.x -= vi->x
		sub		%r7, %r15				;//   %r7  := v1.y -= vi->y
		;//
		mlt.w		%r4, %r7				;//   %alr :=     v0.x * v1.y
		ld.w		%r12, %alr				;//   %r12 :=     v0.x * v1.y
		mlt.w		%r5, %r6				;//   %alr :=                   v0.y * v1.x
		ld.w		%r15, %alr				;//   %r13 :=                   v0.y * v1.x
		sub		%r12, %r15				;//   %r12 := f = v0.x * v1.y - v0.y * v1.x
		jrne		vec2i_is_point_in_concave_NOT_ON_LS	;//   if(!f)
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
		cmp		%r4, 0					;//     if(v0.x) {
		jreq		vec2i_is_point_in_concave_X_ON_LS
		jrgt		vec2i_is_point_in_concave_V0X_GT_0	;//       if(v0.x < 0)
		cmp		%r4, %r6				;//         if(v0.x < v1.x)
		jrlt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_X_ON_LS
vec2i_is_point_in_concave_V0X_GT_0:					;//       else
		cmp		%r4, %r6				;//         if(v0.x > v1.x)
		jrgt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
vec2i_is_point_in_concave_X_ON_LS:					;//     }
		cmp		%r5, 0					;//     if(v0.y) {
		jreq		vec2i_is_point_in_concave_RET_1
		jrgt		vec2i_is_point_in_concave_V0Y_GT_0	;//       if(v0.y < 0)
		cmp		%r5, %r7				;//         if(v0.y < v1.y)
		jrlt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_RET_1
vec2i_is_point_in_concave_V0Y_GT_0:					;//       else
		cmp		%r5, %r7				;//         if(v0.y > v1.y)
		jrgt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_RET_1
vec2i_is_point_in_concave_NOT_ON_LS:					;//     }
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
		cmp		%r7, 0					;//   if(v1.y)
		jreq		vec2i_is_point_in_concave_NEXT
		jrgt.d		vec2i_is_point_in_concave_V1Y_GT_0	;//     if(v1.y < 0)
		cmp		%r12, 0					;//     %psr := f - 0				*delay*
;//vec2i_is_point_in_concave_V1Y_LT_0:
		jrge		vec2i_is_point_in_concave_PREV_V1Y	;//       if(f < 0)
		cmp		%r7, %r5				;//         if(v1.y <= v0.y)
		jrgt		vec2i_is_point_in_concave_PREV_V1Y
		cmp		%r11, 0					;//           if(prev < 0) {
		jrge.d		4
		 cmp		%r5, 0					;//           %psr := v0.y - 0			*delay*
		 jrge		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y < 0)
		 jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           } else {
		jrgt		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y <= 0)
		jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           }
vec2i_is_point_in_concave_V1Y_GT_0:					;//     } else {
		jrle		vec2i_is_point_in_concave_PREV_V1Y	;//       if(f > 0)
		cmp		%r7, %r5				;//         if(v1.y >= v0.y)
		jrlt		vec2i_is_point_in_concave_PREV_V1Y
		cmp		%r11, 0					;//           if(prev < 0) {
		jrle.d		4
		 cmp		%r5, 0					;//           %psr := v0.y - 0			*delay*
		 jrle		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y > 0)
		 jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           } else {
		jrlt		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y >= 0)
;//		jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           }
vec2i_is_point_in_concave_N_TOGGLE:					;//     }
		xor		%r10, 1					;//   %r10 := n ^= 1
vec2i_is_point_in_concave_PREV_V1Y:
		ld.w		%r11, %r7				;//   %r3  := prev = v1.y
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j
vec2i_is_point_in_concave_NEXT:
		sub		%r14, 1					;//   %r14 := j--
		jrne		vec2i_is_point_in_concave_LOOP2		;// } while(j)
		;//-----------------------------------------------------;
vec2i_is_point_in_concave_RET:
		popn		%r3
		ret
vec2i_is_point_in_concave_RET0:
		jp.d		vec2i_is_point_in_concave_RET
		ld.w		%r10, 0					;// %r10 := n = 0	*delay*
vec2i_is_point_in_concave_RET_1:
		jp.d		vec2i_is_point_in_concave_RET
		ld.w		%r10, -1				;// %r10 := n = -1	*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

int
vec2i_is_point_in_alternate_concaves(const vec2i* p, const vec2i* v/*[sum(nv[0...n-1])]*/, const int* nv/*[n]*/, int n)
{
	int c = 0;
	do {
		int f = vec2i_is_point_in_concave(p, v, *nv);
		if(f) {
			/* ǂꂩ̑p`̕ӏȂ΁A""ƌȂ */
			if(f == -1) {
				return f;
			}
			/* p`̓Ȃ΁A񐔂̋gO */
			c ^= 1;
		}
		v += *nv++;
	} while(--n);
	return c;
}

/*--------------------------------------------------------------------------*/

void
render_vec2i_alternate_concaves(RENDER* render, const vec2i* v/*[sum(nv[0...n-1])]*/, const int* nv/*[n]*/, int n, int c) /* cliprend.h */
{
	int i;
	int j;
	int xmin;
	int xmax;
	int ymin;
	int ymax;
	const vec2i* pv;
	vec2i p;

	/* E`߂ */
	pv = v;
	xmin = xmax = pv->x; /* ȂƂ͍WLƉ */
	ymin = ymax = pv->y; /* ȂƂ͍WLƉ */
	for(i = 0; i < n; i++) {
		for(j = 0; j < nv[i]; j++) {
			if(pv->x < xmin) xmin = pv->x;
			if(pv->x > xmax) xmax = pv->x;
			if(pv->y < ymin) ymin = pv->y;
			if(pv->y > ymax) ymax = pv->y;
			pv++;
		}
	}

	/* E`NbsO */
	if(xmin < render->left      ) xmin = render->left      ;
	if(xmax > render->right  - 1) xmax = render->right  - 1;
	if(ymin < render->top       ) ymin = render->top       ;
	if(ymax > render->bottom - 1) ymax = render->bottom - 1;

	/* E`̃sNZ` */
	for(p.y = ymin; p.y <= ymax; p.y++) {
		for(p.x = xmin; p.x <= xmax; p.x++) {
			if(vec2i_is_point_in_alternate_concaves(&p, v, nv, n)) {
				render_point(render, p.x, p.y, c);
			}
		}
	}
}

