/*
 *	clipihex.h
 *
 *	CeHEX`t@C[_[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Fri Nov 30 18:52:54 JST 2012 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Jul 12 17:07:37 JST 2015 Naoyuki Sawa
 *	- IntelHex_load_r()ǉ܂B
 */
#ifndef __CLIP_IHEX_H__
#define __CLIP_IHEX_H__

/* CeHEX`t@C[h܂B
 * [in]
 *	fname		t@C
 *	callback	AvP[V`̃R[obN֐
 * [out]
 *	
 * [note]
 *	//gp
 *	unsigned char Memory[MEMORY_SIZE];
 *	static void MyCallback(int addr, int data) {
 *		if((unsigned)addr >= MEMORY_SIZE) DIE();
 *		Memory[addr] = data;
 *	}
 *	void MyLoadTest() {
 *		memset(Memory, -1, MEMORY_SIZE);
 *		IntelHex_load("sample.hex", MyCallback);
 *	}
 */
void IntelHex_load(const char* fname, void (*callback)(int addr, int data));

/* CeHEX`t@C[h܂B(XbhZ[t)
 * [in]
 *	fname		t@C
 *	callback	AvP[V`̃R[obN֐
 *	userdata	R[obN֐ɈnCӂ̒l
 * [out]
 *	
 * [note]
 *	//gp
 *	static void MyCallback(int addr, int data, void* userdata) {
 *		unsigned char* Memory = userdata;
 *		if((unsigned)addr >= MEMORY_SIZE) DIE();
 *		Memory[addr] = data;
 *	}
 *	void MyLoadTest() {
 *		unsigned char Memory[MEMORY_SIZE];
 *		memset(Memory, -1, MEMORY_SIZE);
 *		IntelHex_load_r("sample.hex", MyCallback, Memory);
 *	}
 */
void IntelHex_load_r(const char* fname, void (*callback)(int addr, int data, void* userdata), void* userdata);

#endif /*__CLIP_IHEX_H__*/
