/*
 *	cliphmng.c
 *
 *	n~O
 *
 *	* Tue Feb 25 01:17:09 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Mar 01 21:23:55 JST 2014 Naoyuki Sawa
 *	- SECDED_128_120_encode(),SECDED_128_120_decode(),SECDED_72_64_encode(),SECDED_72_64_decode()ASM܂B
 *	  25ɂȂ܂B152byteȃ(640488byte)ɂȂ܂B
 *	* Tue Mar 18 00:14:23 JST 2014 Naoyuki Sawa
 *	- LargeBlockFEC_encode(),LargeBlockFEC_decode()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

//Ql
//EEBLyfBAun~Ov(http://ja.wikipedia.org/wiki/n~O)
//ERs[^A[LeN`̘bu266.đƕэLpĂG[v(http://news.mynavi.jp/column/architecture/266/)
//ERs[^A[LeN`̘bu267.n~OR[hpG[v(http://news.mynavi.jp/column/architecture/267/)
//ERs[^A[LeN`̘bu268.Single-bit Error Correction Double-bit Error Detection(SECDED)R[hv(http://news.mynavi.jp/column/architecture/268/)
//EMBw lbgwK _()u5.n~Ov(http://intuniv.cs.shinshu-u.ac.jp/Lecture/error_correcting_code/Book/Section5.html)
//
//
// D0`D119 f[^rbg
// C0`C6   `FbNrbg
// P        SrbgpeB
// S0`S6   Vh[
// H        s
//
//     SSSSSSS                         PSSSSSSS
//     6543210                         |6543210        
//     |||||||                         ||||||||        
//     |||||||           0 10000011 D0     
//   1 0000001 C0        1 10000101 D1     
//   2 0000010 C1        2 10000110 D2     
//   3 0000011 D0          3 10000111 D3     
//   4 0000100 C2        4 10001001 D4     
//   5 0000101 D1          5 10001010 D5     
//   6 0000110 D2          6 10001011 D6     
//   7 0000111 D3          7 10001100 D7     
//   8 0001000 C3        8 10001101 D8     
//   9 0001001 D4          9 10001110 D9     
//  10 0001010 D5         10 10001111 D10    
//  11 0001011 D6         11 10010001 D11    
//  12 0001100 D7         12 10010010 D12    
//  13 0001101 D8         13 10010011 D13    
//  14 0001110 D9         14 10010100 D14    
//  15 0001111 D10        15 10010101 D15    
//  16 0010000 C4       16 10010110 D16    
//  17 0010001 D11        17 10010111 D17    
//  18 0010010 D12        18 10011000 D18    
//  19 0010011 D13        19 10011001 D19    
//  20 0010100 D14        20 10011010 D20    
//  21 0010101 D15        21 10011011 D21    
//  22 0010110 D16        22 10011100 D22    
//  23 0010111 D17        23 10011101 D23    
//  24 0011000 D18        24 10011110 D24    
//  25 0011001 D19        25 10011111 D25    
//  26 0011010 D20        26 10100001 D26    
//  27 0011011 D21        27 10100010 D27    
//  28 0011100 D22        28 10100011 D28    
//  29 0011101 D23        29 10100100 D29    
//  30 0011110 D24        30 10100101 D30    
//  31 0011111 D25        31 10100110 D31    
//  32 0100000 C5       32 10100111 D32    
//  33 0100001 D26        33 10101000 D33    
//  34 0100010 D27        34 10101001 D34    
//  35 0100011 D28        35 10101010 D35    
//  36 0100100 D29        36 10101011 D36    
//  37 0100101 D30        37 10101100 D37    
//  38 0100110 D31        38 10101101 D38    
//  39 0100111 D32        39 10101110 D39    
//  40 0101000 D33        40 10101111 D40    
//  41 0101001 D34        41 10110000 D41    
//  42 0101010 D35        42 10110001 D42    
//  43 0101011 D36        43 10110010 D43    
//  44 0101100 D37        44 10110011 D44    
//  45 0101101 D38        45 10110100 D45    
//  46 0101110 D39        46 10110101 D46    
//  47 0101111 D40        47 10110110 D47    
//  48 0110000 D41        48 10110111 D48    
//  49 0110001 D42        49 10111000 D49    
//  50 0110010 D43        50 10111001 D50    
//  51 0110011 D44        51 10111010 D51    
//  52 0110100 D45        52 10111011 D52    
//  53 0110101 D46        53 10111100 D53    
//  54 0110110 D47        54 10111101 D54    
//  55 0110111 D48        55 10111110 D55    
//  56 0111000 D49        56 10111111 D56    
//  57 0111001 D50        57 11000001 D57    
//  58 0111010 D51        58 11000010 D58    
//  59 0111011 D52        59 11000011 D59    
//  60 0111100 D53        60 11000100 D60    
//  61 0111101 D54        61 11000101 D61    
//  62 0111110 D55        62 11000110 D62    
//  63 0111111 D56        63 11000111 D63    
//  64 1000000 C6       64 11001000 D64    
//  65 1000001 D57        65 11001001 D65    
//  66 1000010 D58        66 11001010 D66    
//  67 1000011 D59        67 11001011 D67    
//  68 1000100 D60        68 11001100 D68    
//  69 1000101 D61        69 11001101 D69    
//  70 1000110 D62        70 11001110 D70    
//  71 1000111 D63        71 11001111 D71    
//  72 1001000 D64        72 11010000 D72    
//  73 1001001 D65        73 11010001 D73    
//  74 1001010 D66        74 11010010 D74    
//  75 1001011 D67        75 11010011 D75    
//  76 1001100 D68        76 11010100 D76    
//  77 1001101 D69        77 11010101 D77    
//  78 1001110 D70        78 11010110 D78    
//  79 1001111 D71        79 11010111 D79    
//  80 1010000 D72        80 11011000 D80    
//  81 1010001 D73        81 11011001 D81    
//  82 1010010 D74        82 11011010 D82    
//  83 1010011 D75        83 11011011 D83    
//  84 1010100 D76        84 11011100 D84    
//  85 1010101 D77        85 11011101 D85    
//  86 1010110 D78        86 11011110 D86    
//  87 1010111 D79        87 11011111 D87    
//  88 1011000 D80        88 11100000 D88    
//  89 1011001 D81        89 11100001 D89    
//  90 1011010 D82        90 11100010 D90    
//  91 1011011 D83        91 11100011 D91    
//  92 1011100 D84        92 11100100 D92    
//  93 1011101 D85        93 11100101 D93    
//  94 1011110 D86        94 11100110 D94    
//  95 1011111 D87        95 11100111 D95    
//  96 1100000 D88        96 11101000 D96    
//  97 1100001 D89        97 11101001 D97    
//  98 1100010 D90        98 11101010 D98    
//  99 1100011 D91        99 11101011 D99    
// 100 1100100 D92       100 11101100 D100   
// 101 1100101 D93       101 11101101 D101   
// 102 1100110 D94       102 11101110 D102   
// 103 1100111 D95       103 11101111 D103   
// 104 1101000 D96       104 11110000 D104   
// 105 1101001 D97       105 11110001 D105   
// 106 1101010 D98       106 11110010 D106   
// 107 1101011 D99       107 11110011 D107   
// 108 1101100 D100      108 11110100 D108   
// 109 1101101 D101      109 11110101 D109   
// 110 1101110 D102      110 11110110 D110   
// 111 1101111 D103      111 11110111 D111   
// 112 1110000 D104      112 11111000 D112   
// 113 1110001 D105      113 11111001 D113   
// 114 1110010 D106      114 11111010 D114   
// 115 1110011 D107      115 11111011 D115   
// 116 1110100 D108      116 11111100 D116   
// 117 1110101 D109      117 11111101 D117   
// 118 1110110 D110      118 11111110 D118   
// 119 1110111 D111      119 11111111 D119 
// 120 1111000 D112    120 10000001 C0   
// 121 1111001 D113        121 10000010 C1     
// 122 1111010 D114        122 10000100 C2     
// 123 1111011 D115        123 10001000 C3     
// 124 1111100 D116        124 10010000 C4     
// 125 1111101 D117        125 10100000 C5     
// 126 1111110 D118        126 11000000 C6     
// 127 1111111 D119            127 10000000 P    
//                                                                         
// 
//                                                                       
static const unsigned char TBL_H[8][15+1]={//s                      
 {0x5B,0xAD,0xAA,0x56,0x55,0x55,0x55,0xAB,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x01},//C0
 {0x6D,0x36,0x33,0x9B,0x99,0x99,0x99,0xCD,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x02},//C1
 {0x8E,0xC7,0xC3,0xE3,0xE1,0xE1,0xE1,0xF1,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x04},//C2
 {0xF0,0x07,0xFC,0x03,0xFE,0x01,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x08},//C3
 {0x00,0xF8,0xFF,0x03,0x00,0xFE,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x10},//C4
 {0x00,0x00,0x00,0xFC,0xFF,0xFF,0xFF,0x01,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x20},//C5
 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x40},//C6
 {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},//P
};
static const unsigned char TBL_S[128]={//Vh[l˃G[rbg̈ʒu
 127,120,121,  0,122,  1,  2,  3,123,  4,  5,  6,  7,  8,  9, 10,//P   ,C0  ,C1  ,D0  ,C2  ,D1  ,D2  ,D3  ,C3  ,D4  ,D5  ,D6  ,D7  ,D8  ,D9  ,D10 ,
 124, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,//C4  ,D11 ,D12 ,D13 ,D14 ,D15 ,D16 ,D17 ,D18 ,D19 ,D20 ,D21 ,D22 ,D23 ,D24 ,D25 ,
 125, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,//C5  ,D26 ,D27 ,D28 ,D29 ,D30 ,D31 ,D32 ,D33 ,D34 ,D35 ,D36 ,D37 ,D38 ,D39 ,D40 ,
  41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,//D41 ,D42 ,D43 ,D44 ,D45 ,D46 ,D47 ,D48 ,D49 ,D50 ,D51 ,D52 ,D53 ,D54 ,D55 ,D56 ,
 126, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,//C6  ,D57 ,D58 ,D59 ,D60 ,D61 ,D62 ,D63 ,D64 ,D65 ,D66 ,D67 ,D68 ,D69 ,D70 ,D71 ,
  72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,//D72 ,D73 ,D74 ,D75 ,D76 ,D77 ,D78 ,D79 ,D80 ,D81 ,D82 ,D83 ,D84 ,D85 ,D86 ,D87 ,
  88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,100,101,102,103,//D88 ,D89 ,D90 ,D91 ,D92 ,D93 ,D94 ,D95 ,D96 ,D97 ,D98 ,D99 ,D100,D101,D102,D103,
 104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,//D104,D105,D106,D107,D108,D109,D110,D111,D112,D113,D114,D115,D116,D117,D118,D119,
};

/****************************************************************************
 *	(128,120)gn~O
 ****************************************************************************/

#ifndef PIECE
int SECDED_128_120_encode(const void* _data/*[15]*/) {
	const unsigned char* data = _data;
	int i, c = 0;
	/* C0`C6,Pɂāc */
	for(i = 0; i < 8; i++) {
		int j, t = 0, p = 0;
		/* D0`D119ɂāc */
		for(j = 0; j < 15; j++) {
			/* s1łrbǵArI_a߂B(oCgP) */
			t ^= (data[j] & TBL_H[i][j]);
		}
		/* s1łrbǵArI_a߂B(rbgP) */
		do { p ^= t; } while(t >>= 1);
		/* rI_ǎʂAC0`C6,PɊi[B */
		            c ^= ((p & 1) << i);	/* C0`C6,P */
		if(i < 7) { c ^= ((p & 1) << 7); }	/* C0`C6́APɂe */
	}
	/* C0`C6,PԂB */
	return c;
}
#else /*PIECE*/
int SECDED_128_120_encode(const void* _data/*[15]*/);
asm("
		.code
		.align		1
		.global		SECDED_128_120_encode
SECDED_128_120_encode:
		xld.w		%r4, TBL_H			;// %r4  := pH = TBL_H
		ld.w		%r5, 0				;// %r5  := c  =  0
		ld.w		%r6, 7				;// %r6  := i  =  7	 70
SECDED_128_120_encode_LOOP_I:					;// do {
		ld.w		%r7, 0				;//   %r7  := t =  0
		ld.w		%r10, 0				;//   %r10 := p =  0
		ld.w		%r11, 14			;//   %r11 := j = 14	140
SECDED_128_120_encode_LOOP_J:					;//   do {
		ld.ub		%r9, [%r4]+			;//     %r9  :=       x   = *pH++
		ld.ub		%r15, [%r12]+			;//     %r15 :=         y = *data++
		and		%r9, %r15			;//     %r9  :=      (x&y)
	;//	xor		%r7, %r9			;//     %r7  := t ^= (x&y)		
		sub		%r11, 1				;//     %r11 := j--				
		jrge.d		SECDED_128_120_encode_LOOP_J	;//   } while(j >= 0)				
		xor		%r7, %r9			;//     %r7  := t ^= (x&y)			*delay*
		add		%r4, 1				;//   %r4  := pH   +=  1						TBL_H[][15]gpȂ̂Ŕ΂B
		sub		%r12, 15			;//   %r12 := data -= 15						data|C^擪ɖ߂B
		;//
		xor		%r10, %r7			;//   do { %r10 := p  ^= t
		sra		%r7, 1				;//        %r7  := t >>= 1
		jrne		-2				;//   } while(t)
		;//
		xand		%r9, %r10, 1			;//   %r9  :=       (p&1)
		xor		%r5, %r9			;//   %r5  := c ^= ((p&1) << 0)						C0`C6PɂeBPPgɉeȂA[vŔfsĂB	
		sla		%r9, %r6			;//   %r9  :=      ((p&1) << i)																	
	;//	xor		%r5, %r9			;//   %r5  := c ^= ((p&1) << i)					C0`C6,P										
		sub		%r6, 1				;//   %r6  := i--																		
		jrge.d		SECDED_128_120_encode_LOOP_I	;// } while(i >= 0)																		
		xor		%r5, %r9			;//   %r5  := c ^= ((p&1) << i)			*delay*		C0`C6,P										
		xor		%r5, %r9			;// %r5  := c ^= ((p&1) << 0)						PPgւ̉ełB'sla %r9,%r6'%r6=0Ȃ̂ŁA%r9͕ωĂȂB	
		ret.d						;// return  mirror(c)
		mirror		%r10, %r5			;// %r10 := mirror(c)					*delay*
");
#endif/*PIECE*/

#ifndef PIECE
int SECDED_128_120_decode(void* _data/*[15]*/, int c) {
	unsigned char* data = _data;
	int i, s = 0;
	/* S0`S6,Pɂāc */
	for(i = 0; i < 8; i++) {
		int j, t = 0, p = 0;
		/* D0`D119,C0`C6,Pɂāc */
		for(j = 0; j < 15; j++) {
			/* s1łrbǵArI_a߂B(oCgP) */
			t ^= (data[j] & TBL_H[i][j]);	/* D0`D119 */
		}
		t ^= (c & TBL_H[i][j/*=15*/]);		/* C0`C6,P */
		/* s1łrbǵArI_a߂B(rbgP) */
		do { p ^= t; } while(t >>= 1);
		/* rI_ǎʂAS0`S6,PɊi[B */
		s ^= ((p & 1) << i);	/* S0`S6,P */
	}
	/* P=1Ȃ΁A1rbgG[łB */
	if(s & 0x80) {
		/* S0`S6AG[rbg̈ʒuɕϊB */
		s = TBL_S[s & 0x7F];
		/* data[0`14]̒ɃG[rbgLꍇABc̒ɃG[rbgLꍇAȂB */
		if(s < 120) { data[s / 8] ^= (1 << (s & 7)); }
		/* 1rbgG[ƂԂB */
		return 1;
	/* P=0Ȃ΁A2rbgG[,,G[łB */
	} else {
		/* S0`S6=0łȂ΁A2rbgG[łB */
		if(s & 0x7F) {
			/* 2rbgG[́AS0`S6G[rbg̈ʒuĂȂ̂ŁAG[rbg邱Ƃ͂łȂB */
			/** no job **/
			/* 2rbgG[oƂԂB */
			return 2;
		/* S0`S6=0Ȃ΁AG[łB */
		} else {
			/* G[ł邱ƂԂB */
			return 0;
		}
	}
}
#else /*PIECE*/
int SECDED_128_120_decode(void* _data/*[15]*/, int c);
asm("
		.code
		.align		1
		.global		SECDED_128_120_decode
SECDED_128_120_decode:
		xld.w		%r4, TBL_H			;// %r4  := pH = TBL_H
		ld.w		%r5, 0				;// %r5  := s  =  0
		ld.w		%r6, 7				;// %r6  := i  =  7	 70
SECDED_128_120_decode_LOOP_I:					;// do {
		ld.w		%r7, 0				;//   %r7  := t =  0
		ld.w		%r10, 0				;//   %r10 := p =  0
		ld.w		%r11, 14			;//   %r11 := j = 14	140
SECDED_128_120_decode_LOOP_J:					;//   do {
		ld.ub		%r9, [%r4]+			;//     %r9  :=       x   = *pH++
		ld.ub		%r15, [%r12]+			;//     %r15 :=         y = *data++
		and		%r9, %r15			;//     %r9  :=      (x&y)
	;//	xor		%r7, %r9			;//     %r7  := t ^= (x&y)		
		sub		%r11, 1				;//     %r11 := j--				
		jrge.d		SECDED_128_120_decode_LOOP_J	;//   } while(j >= 0)				
		xor		%r7, %r9			;//     %r7  := t ^= (x&y)			*delay*
		ld.ub		%r9, [%r4]+			;//   %r9  :=       x   = *pH++
		and		%r9, %r13			;//   %r9  :=      (x&c)
		xor		%r7, %r9			;//   %r7  := t ^= (x&c)
		sub		%r12, 15			;//   %r12 := data -= 15						data|C^擪ɖ߂B
		;//
		xor		%r10, %r7			;//   do { %r10 := p  ^= t
		sra		%r7, 1				;//        %r7  := t >>= 1
		jrne		-2				;//   } while(t)
		;//
		xand		%r9, %r10, 1			;//   %r9  :=       (p&1)
		sla		%r9, %r6			;//   %r9  :=      ((p&1) << i)
	;//	xor		%r5, %r9			;//   %r5  := s ^= ((p&1) << i)					S0`S6,P
		sub		%r6, 1				;//   %r6  := i--				
		jrge.d		SECDED_128_120_decode_LOOP_I	;// } while(i >= 0)				
		xor		%r5, %r9			;//   %r5  := s ^= ((p&1) << i)			*delay*		S0`S6,P
		rr		%r5, 1				;// %r5[6:0] := S0`S6, %r5[31] := P
		add		%r5, %r5			;// %r5[7:1] := S0`S6, %psr(C) := P, %psr(Z) := S
		jrult.d		SECDED_128_120_decode_ERR1	;// if(!P) {
		mirror		%r10, %r5			;// %r5 := S6`S0					*delay*
		jreq		2				;//   if(!S) { return 0 }
		 ld.w		%r10, 2				;//   if( S) { return 2 }
		ret						;// }
SECDED_128_120_decode_ERR1:
		ext		TBL_S@ah
		ext		TBL_S@al
		ld.ub		%r10, [%r10]			;// %r10 :=  s = TBL_S[s]
		ld.w		%r9, %r10			;// %r9  :=  s						!INTERLOCK!
		sra		%r9, 3				;// %r9  := (s/8)
		cmp		%r9, 15				;// if((s/8) < (120/8)) {
		jrge		SECDED_128_120_decode_RET1	;//   
		add		%r12, %r9			;//   %r12 :=    &data[s/8]
		ld.ub		%r9, [%r12]			;//   %r9  := y = data[s/8]
		and		%r10, 7				;//   %r10 :=                     (s&7)			*anti-interlock*
		rr		%r9, %r10			;//   
		xor		%r9, 1				;//   %r9  := y = data[s/8] ^ (1<<(s&7))
		rl		%r9, %r10			;//   
		ld.b		[%r12], %r9			;//   data[s/8] = data[s/8] ^ (1<<(s&7))
SECDED_128_120_decode_RET1:					;// }
		ret.d						;// return  1
		ld.w		%r10, 1				;// %r10 := 1						*delay*
");
#endif/*PIECE*/

/****************************************************************************
 *	(72,64)gn~O
 ****************************************************************************/

#ifndef PIECE
int SECDED_72_64_encode(const void* _data/*[8]*/) {
	unsigned char data[15];
	memcpy(&data[0], _data, 8);			//f[^rbgRs[
	memset(&data[8],  0, 15-8);			//f[^rbg̎gpȂ0NA
	return SECDED_128_120_encode(data);		//(128,120)gn~O̕s
}
#else /*PIECE*/
int SECDED_72_64_encode(const void* _data/*[15]*/);
asm("
		.code
		.align		1
		.global		SECDED_72_64_encode
SECDED_72_64_encode:
		xsub		%sp, %sp, 16
		ld.w		%r4, %sp			;// %r4  := data
		ld.w		%r5, 8				;// %r5  := i = 8
		 ld.b		%r9, [%r12]+			;// do { %r9  :=   _data[i]	_data̓[hACgĂȂ\̂ŁA1oCgÂ]KvB
		 ld.b		[%r4]+, %r9			;//      data[i] = _data[i]
		 sub		%r5, 1				;//      %r5  := i--
		jrne		-3				;// } while(i)
		ld.w		[%r4]+, %r8			;// data[ 8:11] = 0		data̓[hACgĂ̂ŁA4+2+1oCgÂ]łB
		ld.h		[%r4]+, %r8			;// data[12:13] = 0
		ld.b		[%r4], %r8			;// data[   14] = 0
		ld.w		%r12, %sp			;// %r12 :=                       data
		xcall		SECDED_128_120_encode		;// %r10 := SECDED_128_120_encode(data)
		xadd		%sp, %sp, 16
		ret
");
#endif/*PIECE*/

#ifndef PIECE
int SECDED_72_64_decode(void* _data/*[8]*/, int c) {
	int retval;
	unsigned char data[15];
	memcpy(&data[0], _data, 8);			//f[^rbgRs[
	memset(&data[8],  0, 15-8);			//f[^rbg̎gpȂ0NA
	retval = SECDED_128_120_decode(data, c);	//(128,120)gn~O̕s
	memcpy(_data, &data[0], 8);			//f[^rbg߂
	return retval;
}
#else /*PIECE*/
int SECDED_72_64_encode(const void* _data/*[15]*/);
asm("
		.code
		.align		1
		.global		SECDED_72_64_decode
SECDED_72_64_decode:
		pushn		%r0
		xsub		%sp, %sp, 16
		ld.w		%r0, %r12			;// %r0  := _data
		ld.w		%r4, %sp			;// %r4  := data
		ld.w		%r5, 8				;// %r5  := i = 8
		 ld.b		%r9, [%r12]+			;// do { %r9  :=   _data[i]	_data̓[hACgĂȂ\̂ŁA1oCgÂ]KvB
		 ld.b		[%r4]+, %r9			;//      data[i] = _data[i]
		 sub		%r5, 1				;//      %r5  := i--
		jrne		-3				;// } while(i)
		ld.w		[%r4]+, %r8			;// data[ 8:11] = 0		data̓[hACgĂ̂ŁA4+2+1oCgÂ]łB
		ld.h		[%r4]+, %r8			;// data[12:13] = 0
		ld.b		[%r4], %r8			;// data[   14] = 0
		ld.w		%r12, %sp			;// %r12 :=                       data
		xcall		SECDED_128_120_decode		;// %r10 := SECDED_128_120_decode(data, c)
		ld.w		%r4, %sp			;// %r4  := data
		ld.w		%r5, 8				;// %r5  := i = 8
		 ld.b		%r9, [%r4]+			;// do { %r9  :=    data[i]
		 ld.b		[%r0]+, %r9			;//      _data[i] = data[i]	_data̓[hACgĂȂ\̂ŁA1oCgÂ]KvB
		 sub		%r5, 1				;//      %r5  := i--
		jrne		-3				;// } while(i)
		xadd		%sp, %sp, 16
		popn		%r0
		ret
");
#endif/*PIECE*/

/****************************************************************************
 *	eXgXC[g
 ****************************************************************************/

//	void TestSuite_128_120(int nTry) {
//		unsigned char src[15];
//		unsigned char dst[15];
//		int i, c, iTry, nErr, iBit1, iBit2;
//		printf("(128,120)gn~O\n");
//		printf("EG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 15; i++) {
//				src[i] = rand();
//				c = SECDED_128_120_encode(src);
//				memcpy(dst, src, 15);
//				nErr = SECDED_128_120_decode(dst, c);
//				if((nErr == 0) && (memcmp(src, dst, 15) == 0)) {
//					/* ok */
//				} else {
//					fprintf(stderr, "@oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("E1rbgG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 15; i++) {
//				src[i] = rand();
//				c = SECDED_128_120_encode(src);
//				memcpy(dst, src, 15);
//				iBit1 = rand() % (120+8);
//				if(iBit1 < 120) { dst[iBit1/8] ^= (1<<(iBit1&7)); }
//				           else {            c ^= (1<<(iBit1&7)); }
//				nErr = SECDED_128_120_decode(dst, c);
//				if((nErr == 1) && (memcmp(src, dst, 15) == 0)) {
//					/* ok */
//				} else {
//					fprintf(stderr, "oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("E2rbgG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 15; i++) {
//				src[i] = rand();
//				c = SECDED_128_120_encode(src);
//				memcpy(dst, src, 15);
//				do {
//					iBit1 = rand() % (120+8);
//					iBit2 = rand() % (120+8);
//				} while(iBit1 == iBit2);
//				if(iBit1 < 120) { dst[iBit1/8] ^= (1<<(iBit1&7)); }
//				           else {            c ^= (1<<(iBit1&7)); }
//				if(iBit2 < 120) { dst[iBit2/8] ^= (1<<(iBit2&7)); }
//				           else {            c ^= (1<<(iBit2&7)); }
//				nErr = SECDED_128_120_decode(dst, c);
//				if(nErr == 2) {
//					/* ok */
//				} else {
//					fprintf(stderr, "oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//	}
//	void TestSuite_72_64(int nTry) {
//		unsigned char src[8];
//		unsigned char dst[8];
//		int i, c, iTry, nErr, iBit1, iBit2;
//		printf("(72,64)gn~O\n");
//		printf("EG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 8; i++) {
//				src[i] = rand();
//				c = SECDED_72_64_encode(src);
//				memcpy(dst, src, 8);
//				nErr = SECDED_72_64_decode(dst, c);
//				if((nErr == 0) && (memcmp(src, dst, 8) == 0)) {
//					/* ok */
//				} else {
//					fprintf(stderr, "@oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("E1rbgG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 8; i++) {
//				src[i] = rand();
//				c = SECDED_72_64_encode(src);
//				memcpy(dst, src, 8);
//				iBit1 = rand() % (64+8);
//				if(iBit1 < 64) { dst[iBit1/8] ^= (1<<(iBit1&7)); }
//				          else {            c ^= (1<<(iBit1&7)); }
//				nErr = SECDED_72_64_decode(dst, c);
//				if((nErr == 1) && (memcmp(src, dst, 8) == 0)) {
//					/* ok */
//				} else {
//					fprintf(stderr, "oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("E2rbgG[̃eXg\n");
//		for(iTry = 0; iTry < nTry; iTry++) {
//			for(i = 0; i < 8; i++) {
//				src[i] = rand();
//				c = SECDED_72_64_encode(src);
//				memcpy(dst, src, 8);
//				do {
//					iBit1 = rand() % (64+8);
//					iBit2 = rand() % (64+8);
//				} while(iBit1 == iBit2);
//				if(iBit1 < 64) { dst[iBit1/8] ^= (1<<(iBit1&7)); }
//				          else {            c ^= (1<<(iBit1&7)); }
//				if(iBit2 < 64) { dst[iBit2/8] ^= (1<<(iBit2&7)); }
//				          else {            c ^= (1<<(iBit2&7)); }
//				nErr = SECDED_72_64_decode(dst, c);
//				if(nErr == 2) {
//					/* ok */
//				} else {
//					fprintf(stderr, "oO!!\n");
//					exit(EXIT_FAILURE);
//				}
//			}
//		}
//		fprintf(stderr, "@ok\n");
//	}

/****************************************************************************
 *	傫ȃubNpO
 ****************************************************************************/

/* ϊobt@𕪎UAϊobt@֊i[܂B
 * [in]
 *	dst		ϊobt@
 *	src		ϊobt@
 * [note]
 *	- LargeBlockFEC_encode()LargeBlockFEC_decode()痘p܂B
 *	- ϊƕϊ̃rbgʒȗΉ́AL̒ʂłB
 *	  sƁÄʒu֖߂܂B
 *	    ubN#  0
 *	    dst[   0] bit0  src[   0] bit0
 *	    dst[   0] bit1  src[  16] bit0
 *	                   c               
 *	    dst[   0] bit6  src[  96] bit0
 *	    dst[   0] bit7  src[ 112] bit0
 *	    dst[   1] bit0  src[ 128] bit0
 *	    dst[   1] bit1  src[ 144] bit0
 *	                   c               
 *	    dst[  15] bit6  src[2016] bit0
 *	    dst[  15] bit7  src[2032] bit0
 *	    ubN#  1
 *	    dst[  16] bit0  src[   0] bit1
 *	    dst[  16] bit1  src[  16] bit1
 *	                   c               
 *	    dst[  31] bit6  src[2016] bit1
 *	    dst[  31] bit7  src[2032] bit1
 *	                   E               
 *	                   E               
 *	                   E               
 *	    ubN#  7
 *	    dst[ 112] bit0  src[   0] bit7
 *	    dst[ 112] bit1  src[  16] bit7
 *	                   c               
 *	    dst[ 127] bit6  src[2016] bit7
 *	    dst[ 127] bit7  src[2032] bit7
 *	    ubN#  8
 *	    dst[ 128] bit0  src[   1] bit0
 *	    dst[ 128] bit1  src[  17] bit0
 *	    c               
 *	    dst[ 143] bit6  src[2017] bit0
 *	    dst[ 143] bit7  src[2033] bit0
 *	                   E               
 *	                   E               
 *	                   E               
 *	    ubN#127
 *	    dst[2032] bit0  src[  15] bit7
 *	    dst[2032] bit1  src[  31] bit7
 *	                   c               
 *	    dst[2047] bit6  src[2031] bit7
 *	    dst[2047] bit7  src[2047] bit7
 */
#ifndef PIECE
static void LargeBlockFEC_interleave(unsigned char* dst/*[16*128]*/, const unsigned char* src/*[16*128]*/) {
	int i, j, k, m, x;
	x = 0; /* x}Bۂɂ́AɖrbgǂôŁAsvłB */
	/* ϊ̃oCǵArbgʒuB */
	m = 0x01010101;	/* [31:8]ɂJԂZbgĂ̂́AAZułŌ邽߂̍HvłB */
	/* ΐAeubNɂāc */
	i = 127; /* 127,126,125,c,1,0 */
	do {
		/* ϊ̃ubŃAeoCgɂāc */
		j = 15; /* 15,14,13,c,1,0 */
		do {
			/* ϊ̃oCǵAerbgɂāc */
			k = 7; /* 7,6,5,c,1,0 */
			do {
				/* ϊ̃oCgɁAϊ̃rbgB */
				x <<= 1;
				if(*src & m) { x |= 1; }
				/* ϊ̃oCgʒui߂B */
				src += 16;
			} while(--k >= 0);
			/* ϊ̃oCgi[B */
			*dst++ = mirror(x);
		} while(--j >= 0);
		/* ϊ̃oCgʒu,y,rbgʒui߂B */
		src -= (16*128);
		if(m >= 0) {			//
			m = (m << 1);		//
		} else {			//AZułł́Aaddœ{ăL[Ŕfł܂B
			m = (m << 1) | 1;	//
			src++;			//
		}				//
	} while(--i >= 0);
}
#else /*PIECE*/
/*static*/ void LargeBlockFEC_interleave(unsigned char* dst/*[16*128]*/, const unsigned char* src/*[16*128]*/);
asm("
		.code
		.align		1
LargeBlockFEC_interleave:
		xld.w		%r4, 0x01010101				;// %r4  := m = 0x01010101
		xld.w		%r5, 127				;// %r5  := i = 127
LargeBlockFEC_interleave_LOOP_I:					;// do {
		ld.w		%r6, 15					;//   %r6  := j = 15
LargeBlockFEC_interleave_LOOP_J:					;//   do {
		ld.w		%r7, 7					;//     %r7  := k = 7
LargeBlockFEC_interleave_LOOP_K:					;//     do {
		ld.ub		%r9, [%r13]				;//       %r9  :=     *src
		and		%r9, %r4				;//       %r9  :=    (*src & m)			!INTERLOCK!
		cmp		%r8, %r9				;//       %psr(C) := (*src & m) ? 1 : 0
		adc		%r10, %r10				;//       %r10 := x = (x << 1) | %psr(C)
		sub		%r7, 1					;//       %r7  := k--
		jrge.d		LargeBlockFEC_interleave_LOOP_K		;//     } while(k >= 0)
		add		%r13, 16				;//     %r13 := src += 16		*delay*
		mirror		%r10, %r10				;//     %r10 :=  mirror(x)
		ld.b		[%r12]+, %r10				;//     *dst++ = mirror(x)
		sub		%r6, 1					;//     %r6  := j--
		jrge		LargeBlockFEC_interleave_LOOP_J		;//   } while(j >= 0)
		xsub		%r13, %r13, 2048			;//   %r13 := src -= (16*128)
		add		%r4, %r4				;//   %r4  := m <<= 1, %psr(C) := m[32]
		jruge		3					;//   if(m[32]) {
		 or		%r4, 1					;//     %r4  := m   |= 1
		 add		%r13, 1					;//     %r13 := src += 1 }
		sub		%r5, 1					;//   %r5  := i--
		jrge		LargeBlockFEC_interleave_LOOP_I		;// } while(i >= 0)
		ret
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/
void LargeBlockFEC_encode(void* dst/*[16*128]*/, const void* _src/*[15*128]*/) {
	int i;
	const unsigned char* src = _src;
	      unsigned char* tmp;
	/* ꎞobt@mۂB */
	tmp = malloc(16*128);
	if(!tmp) { DIE(); }
	/* ϊobt@̊eubNɂāc */
	for(i = 0; i < 128; i++) {
		/* ϊobt@̃ubNAꎞobt@փRs[B */
		memcpy(tmp, src, 15);
		/* ꎞobt@̃ubNɁAn~OǉB */
		tmp[15] = SECDED_128_120_encode(tmp);
		/* |C^̃ubN֐i߂B */
		src += 15;
		tmp += 16;
	}
	/* ꎞobt@̃|C^擪֖߂B */
	tmp -= (16*128);
	/* ꎞobt@𕪎UAϊobt@֊i[B */
	LargeBlockFEC_interleave(dst, tmp);
	/* ꎞobt@JB */
	free(tmp);
}

/*--------------------------------------------------------------------------*/
int LargeBlockFEC_decode(void* _dst/*[15*128]*/, const void* src/*[16*128]*/) {
	int i, RetVal, Result = 0;
	unsigned char* dst = _dst;
	unsigned char* tmp;
	/* ꎞobt@mۂB */
	tmp = malloc(16*128);
	if(!tmp) { DIE(); }
	/* ϊobt@̕U𕜌Aꎞobt@֊i[B */
	LargeBlockFEC_interleave(tmp, src);
	/* ꎞobt@̊eubNɂāc */
	for(i = 0; i < 128; i++) {
		/* ꎞobt@̃ubNAG[oEG[B */
		RetVal = SECDED_128_120_decode(tmp, tmp[15]);
		if(RetVal > Result) { Result = RetVal; }
		/* ꎞobt@̃ubNAϊobt@փRs[B */
		memcpy(dst, tmp, 15);
		/* |C^̃ubN֐i߂B */
		dst += 15;
		tmp += 16;
	}
	/* ꎞobt@̃|C^擪֖߂B */
	tmp -= (16*128);
	/* ꎞobt@JB */
	free(tmp);
	return Result;
}

/****************************************************************************
 *	eXgXC[g
 ****************************************************************************/

//	void TestSuite_LargeBlockFEC(int nTry) {
//		static unsigned char src[15*128]; /* f[^ */
//		static unsigned char enc[16*128]; /* GR[h̃f[^ */
//		static unsigned char dec[15*128]; /* fR[h̃f[^ */
//		int i, j;
//		printf("傫ȃubNpO\n");
//		printf("EG[̃eXg\n");
//		for(i = 0; i < nTry; i++) {
//			/* f[^_ɍ쐬B */
//			for(j = 0; j < sizeof src; j++) { src[j] = rand(); }
//			/* GR[hB */
//			LargeBlockFEC_encode(enc, src);
//			/* fR[hAG[f[^ƈv邱ƂmFB */
//			if((LargeBlockFEC_decode(dec, enc) != 0) ||
//			   (memcmp(dec, src, sizeof src))) {
//				fprintf(stderr, "@oO!!\n");
//				exit(EXIT_FAILURE);
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("傫ȃubNpO\n");
//		printf("E16oCgo[XgG[̃eXg\n");
//		/* 16oCgo[XgG[̊eJnʒuɂāc */
//		for(i = 0; i < sizeof enc - 16; i++) {
//			/* f[^_ɍ쐬B */
//			for(j = 0; j < sizeof src; j++) { src[j] = rand(); }
//			/* GR[hB */
//			LargeBlockFEC_encode(enc, src);
//			/* 16oCgo[XgG[ɂB */
//			for(j = 0; j < 16; j++) { enc[i+j] ^= -1; }
//			/* fR[hAG[ꌳf[^ƈv邱ƂmFB */
//			if((LargeBlockFEC_decode(dec, enc) != 1) ||
//			   (memcmp(dec, src, sizeof src))) {
//				fprintf(stderr, "@oO!!\n");
//				exit(EXIT_FAILURE);
//			}
//		}
//		fprintf(stderr, "@ok\n");
//		printf("傫ȃubNpO\n");
//		printf("E32oCgo[XgG[̃eXg\n");
//		/* 32oCgo[XgG[̊eJnʒuɂāc */
//		for(i = 0; i < sizeof enc - 32; i++) {
//			/* f[^_ɍ쐬B */
//			for(j = 0; j < sizeof src; j++) { src[j] = rand(); }
//			/* GR[hB */
//			LargeBlockFEC_encode(enc, src);
//			/* 32oCgo[XgG[ɂB */
//			for(j = 0; j < 32; j++) { enc[i+j] ^= -1; }
//			/* fR[hAG[o邱ƂmFB */
//			if(LargeBlockFEC_decode(dec, enc) != 2) {
//				fprintf(stderr, "@oO!!\n");
//				exit(EXIT_FAILURE);
//			}
//		}
//		fprintf(stderr, "@ok\n");
//	}

