/*
 *	cliphfm.c
 *
 *	Canonical Huffman Code
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Fri Nov 21 20:05:45 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- L̋LQlɂ܂B
 *	  uɕ^sŏ璷uCanonical Huffman Codevv(http://codezine.jp/article/detail/376)
 *	  (_E[hāukeep/ɕ^sŏ璷uCanonical Huffman Codev.7zvɕۑĂ܂B)
 *	  ASY͎Qlɂ܂ATv\[X̎͂悭łȂ̂ŁAقڐVKɎ܂B
 *	  Tv\[XAW[̎̕AfR[_̃tbgvgāAP/ECEɓKĂƎv܂B
 *	  ܂AkɊi[镄\ςނ悤Hv̂ŁATv\[XW[̎̕A͂ɈkłB
 *	  ɁATv\[X͌f[^̃TCYwb_Ɋi[Ă܂AW[͏I[Ŕf_ADĂƎv܂B
 *	* Sat Nov 22 10:24:01 JST 2014 Naoyuki Sawa
 *	- kf[^̍쐬́ADOSR}hCc[utool/dphfmv𗘗pĂB
 *	* Sat Nov 22 14:56:38 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Getc()AZu܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA1.106b˖0.790bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	* Sat Nov 22 16:01:39 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Init()AZu܂B
 *	  R[hTCY12oCgȂ܂Bxɂ͂قƂǉe܂B
 *	* Sat Nov 22 17:24:18 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Decode()AZu܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.790b˖0.759bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	* Sun Nov 23 01:00:09 JST 2014 Naoyuki Sawa
 *	- cliphfm.cAfR[_[framhfm.cɕ܂B
 *	  P/ECEł̓fR[_[gpȂƂ̂ŁAɃGR[_[Nėeʂ邱Ƃh߂łB
 *	  framhfm.cRAMɔzuāA邱Ƃ\łB
 *	  framhfm.cRAMɔzuƁAHuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.759b˖0.419bɍ܂B(Clock=48MHz,Code=FRAM,Stack=FRAM)
 *	* Sun Nov 23 21:49:53 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Getc()ɁAuHvvZvKp܂B(CłƃAZuł̗)
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.759b˖0.756bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 */
#include "clip.h"

//[note]
// - GR[hɂāAzIȏI[l(256)ɁAIȏI[蓖ĂĂ܂B
//   ̂悤ɂKvL闝RA܂B
// - I[́Al(0`255)̕rő傫ȒlȂΉłǂ̂ŁA32bit(-1)Œŗǂ悤Ɏvm܂B
//   Ał͂߂łB
// - Ƃ΁Al'A''B'oƂɁAIȏI[蓖ĂȂ΁A('A'=0,'B'=1,I[=111c111)ƂȂ܂B
//   fR[_ArbgXg[1ǂݍނƁA'B'ƔfĂ܂AI[݂Ȃ̂ƓɂȂĂ܂܂B
// - AIȏI[蓖ĂȂ΁A('A'=00,'B'=01,I[=10),,('A'=00,'B'=10,I[=11)ƂȂ܂B
//   Ȃ΁AfR[_I[𔻒f邱Ƃł܂B
// - ȏオAGR[hɂāAzIȏI[l(256)ɁAIȏI[蓖ĂKvL闝RłB
//   AIȏI[蓖ĂĂ܂΁Aۂɂ́AI[ƂĂ̒li[ĂA32bit(-1)i[Ă\܂B
//   ǂɂĂAl(0`255)̕Arő傫Ȓlł邩łB
//   W[̎ł́AۂɊ蓖ĂI[i[悤ɂ܂B
//   A(2014/11/24)쐬́Aclipdrh.c(k˘Ak˃nt}k)W[ł́A32bit(-1)i[\łB
// - AuۂɊ蓖ĂI[v32bit̕ł܂A32biti[ĂKv܂B
//   ȂȂ΁AfR[_[́Aۂ̕ɂ炸32bit擾邩łB
//   ̓Iɂ́AHuffmanEncoder_Encode()̃RgQƂĂB

/****************************************************************************
 *	nt}GR[_[
 ****************************************************************************/
//nt}؂̃m[h
typedef struct _ST_HuffmanNode {
	int				value;				//l(0`256)					(l=256)͏I[lӖB		qꍇ́Al͈ӖȂB
	int				count;				//o										qꍇ́Aq̏o񐔂̍vB
	struct _ST_HuffmanNode*		left;				//̎qւ̃|C^									NULL=qĂȂƂB
	struct _ST_HuffmanNode*		right;				//E̎qւ̃|C^									NULL=qĂȂƂB
} ST_HuffmanNode;
/*--------------------------------------------------------------------------*/
//nt}GR[_[\
typedef struct _ST_HuffmanEncoder {
	ST_HuffmanNode*			TBL_Node[257];			//eĂȂm[h̃|C^z		(l=256)͏I[lӖB
	unsigned char			TBL_CodeLen[257];		//l̕(0`32)				(l=256)͏I[lӖB		0=o񐔂0łƂB
	unsigned short			TBL_ValueOrder[257];		//l𕄍̏Ƀ\[g邽߂̔z	(l=256)͏I[lӖB		A0(=o񐔂0)łĺAƂB
	unsigned short			TBL_CodeLenCount[32];		//蓖Ăꂽl̐(0`256)		(l=256)͏I[lӖB		[0]=1蓖Ăꂽl̐,[1]=1蓖Ăꂽl̐,c,[31]=32蓖Ăꂽl̐	ydvzI[l͐Ɋ܂߂ȂBI[Œő̕ƂAI[𕄍\Ɋ܂߂ȂBĂƂɂāAfR[_\Ō܂ŌĂvȂ΁AI[ƔfłB
	unsigned			TBL_Code[257];			//l̕					(l=256)͏I[lӖB		A0(=o񐔂0)łĺ̕AӖȂB
} ST_HuffmanEncoder;
/*--------------------------------------------------------------------------*/
//(ST_HuffmanNode*)A(ST_HuffmanNode.count)̏Ƀ\[gAr֐B
//A(ST_HuffmanNode*)NULL|C^łvf́AƂB
static int HuffmanEncoder_CompareNodeCount(const void* _x, const void* _y) {
	ST_HuffmanNode* px = *(ST_HuffmanNode**)_x;
	ST_HuffmanNode* py = *(ST_HuffmanNode**)_y;
	unsigned xCount = (px ? px->count : 0) - 1;	//(ST_HuffmanNode.count=0)̃m[h́AĂяoɂč폜ς݂łB
	unsigned yCount = (py ? py->count : 0) - 1;	//]āA(px=NULL)̂(x=-1)ƂȂB(py=NULL)̂(y=-1)ƂȂB
	if(xCount < yCount) { return -1; }
	if(xCount > yCount) { return  1; }
	return 0;
}
/*--------------------------------------------------------------------------*/
//l𕄍̏Ƀ\[gAr֐B
//A0(=o񐔂0)łĺAƂB
//łꍇ́Al̏ƂB͕̏K{łȂAkɉeȂB
static int HuffmanEncoder_CompareValueOrder(const void* _x, const void* _y, void* _arg) {
	ST_HuffmanEncoder* pHuffmanEncoder = _arg;
	int xValue = *(unsigned short*)_x;
	int yValue = *(unsigned short*)_y;
	int xCodeLen = (unsigned char)(pHuffmanEncoder->TBL_CodeLen[xValue] - 1);
	int yCodeLen = (unsigned char)(pHuffmanEncoder->TBL_CodeLen[yValue] - 1);
	if(xCodeLen < yCodeLen) { return -1; }
	if(xCodeLen > yCodeLen) { return  1; }
	if(xValue < yValue) { return -1; }	//łꍇ́Al̏ƂB
	if(xValue > yValue) { return  1; }	//͕̏K{łȂAkɉeȂB
	return 0;
}
/*--------------------------------------------------------------------------*/
//m[hJȂAl̕肷B
static void HuffmanNode_CodeLen(ST_HuffmanEncoder* pHuffmanEncoder, ST_HuffmanNode* pNode, int codeLen) {
////	codeLen++;								//𑝂₷B									ŕ𑝂₷̂͌ł邱ƂɒӂB
	if(!!pNode->left ^ !!pNode->right) { DIE(); }				//,,EɎqe݂͑Ȃ͂B݂oOłB	̈ꌅ́Am[h'_'Ɋ蓖Ă̂ł͂ȂAE̎qւ'΂ߐ'Ɋ蓖Ă̂ŁA
	if(pNode->left) {							//m[hȂ΁c									ŕ𑝂₷̂łB
/**/		codeLen++;							//𑝂₷B
		HuffmanNode_CodeLen(pHuffmanEncoder, pNode->left,  codeLen);	//̎qɂčċAB
		HuffmanNode_CodeLen(pHuffmanEncoder, pNode->right, codeLen);	//E̎qɂčċAB
	} else {								//tm[hȂ΁c
		if(pHuffmanEncoder->TBL_CodeLen[pNode->value]) { DIE(); }	//l̃m[h݂邱Ƃ͖͂Ȃ̂ŁAɕi[Ă邱Ƃ͖͂Bi[ĂoOłB
		//[note]
		//vÓA32𒴂ƁAł܂B
		//Aۂɂ́A32𒴂P[X́A܂܂B
		//32𒴂̂́Al̏o񐔂2^31ȏƂȂꍇłB
		//vÓAMKoCg̃f[^ɑ΂gp͑z肵Ă܂B
		//]āA32𒴂P[XlKv͂܂B
		//
		//@@@^_@@@@@@@@@
		//@2^31@^_@@@@@@@@ 1
		//@@2^30@^_@@@@@@@ 2
		//@@@2^29@ij@@@@@ 3
		//@@@@@@@^_@@@@@
		//@@@@@2^Q@^_@@@@30
		//@@@@@@2^P@^_@@@31
		//@@@@@@@2^O@@2^O@32
		//@@@@@@@o񐔁@
		if(codeLen > 32) { DIE(); }					//AMKoCg̃f[^ɑ΂ĎgpꍇAŒ~\܂B
		pHuffmanEncoder->TBL_CodeLen[pNode->value] = codeLen;		//i[B
	}
	free(pNode);								//m[hJB
}
/*--------------------------------------------------------------------------*/
//kf[^ŜGR[hAkf[^쐬B
// - dst́A32bitEɐ񂳂ꂽobt@ł邱ƁBsrc̓ACgsvB
// - kf[^dstBytes𒴂ꍇ́Az͊i[ȂB
//   i[̉ۂɊ֌WȂA߂ĺAkf[^̃oCgłB
//   ̐𗘗pāAڂ(dst=NULL,dstBytes=0)ŌĂяoAKvȃobt@TCYmF,mۂAēxĂяo@\łB
//   <>
//   dstBytes=HuffmanEncoder_Encode(src,srcBytes,NULL,0);
//   dst=malloc(dstBytes);
//   HuffmanEncoder_Encode(src,srcBytes,dst,dstBytes);
int HuffmanEncoder_Encode(const void* _src, int srcBytes, void* dst, int dstBytes) {
	ST_HuffmanEncoder stHuffmanEncoder;	//3KB
	const unsigned char* src = _src;
	      unsigned char* hdr;
	unsigned short* pValueOrder;
	ST_HuffmanNode* pNode;
	int i, value, code, codeLen, codeLenDiff, codeLenMask, codeLenCount, dstPos, dstBits;
//{{f[^0oCg̏ꍇ̓Ꮘ
	//f[^0oCg̏ꍇ́AGR[_̂݁AᏈsB
	// - f[^0oCg̏ꍇAʏʂɏ悤ƂƁAI[l(256)畄\쐬ďʂ0ɂȂAI[l(256)̕0ɂȂĂ܂B
	//   A0LȕƂāAʏ̏őΉł悤ɕύXƁApĕGɂȂB
	//   Af[^0oCg̏ꍇᏈɂAK؂ƔfB
	//   f[^0oCg̏ꍇ́A(codeLenMask=0,code=I[)̈kf[^o͂āAGR[hIB
	// - fR[_ł́Af[^0oCg̏ꍇlKv͖AᏈ͕svłB
	//   (codeLenMask=0,code=I[)̈kf[^AfR[_̒ʏ̏ǂɏ΁AŏI[ƌȂ(-1)ԂB
	// - I[͉ł\ȂAՂ̂߂ɁA0Ƃ邱ƂɂB
	//   HuffmanDecoder_Getc()Aۂ̕ɂ炸Ã݂rbgʒu32bit擾邽߂ɒuĂłAɂ0rbg̏I[łB
	//   0rbg̏I[ł邩AHuffmanDecoder_Getc()ǂݍ񂾒lgp邱Ƃ͖B
	if(!srcBytes) {
		if(dstBytes >= 4) { ((int*)dst)[0] = 0; }	//codeLenMask=0
		if(dstBytes >= 8) { ((int*)dst)[1] = 0; }	//code=I[
		return 8;
	}
//}}f[^0oCg̏ꍇ̓Ꮘ
	//\̂NAB
	memset(&stHuffmanEncoder, 0, sizeof stHuffmanEncoder);
	//--- \쐬鏈 ---
	//l̃m[h쐬B
	for(i = 0; i < 257; i++) {
		pNode = calloc(1, sizeof(ST_HuffmanNode));
		if(!pNode) { DIE(); }
		pNode->value = i;
		stHuffmanEncoder.TBL_Node[i] = pNode;
	}
	//l̏o񐔂𐔂B
	for(i = 0; i < srcBytes; i++) {
		value = src[i];
		stHuffmanEncoder.TBL_Node[value]->count++;
	}
	//I[l(256)́A1oƂƂB
	//I[l(256)́Asrc[]̒ɌȂAkf[^o͂鏈̍Ōɏo͂̂ŁA1oƌȂ̂K؂łB
	stHuffmanEncoder.TBL_Node[256]->count++;
	//o񐔂0łl̃m[h폜B
	for(i = 0; i < 257; i++) {
		pNode = stHuffmanEncoder.TBL_Node[i];
		if(!pNode->count) {
			free(pNode);
			stHuffmanEncoder.TBL_Node[i] = NULL;
		}
	}
	//eĂȂm[h1ɂȂ܂ŌJԂB
	for(;;) {
		//(ST_HuffmanNode*)A(ST_HuffmanNode.count)̏Ƀ\[gB
		//A(ST_HuffmanNode*)NULL|C^łvf́AƂB
		qsort(stHuffmanEncoder.TBL_Node, 257, sizeof stHuffmanEncoder.TBL_Node[0], HuffmanEncoder_CompareNodeCount);
		//eĂȂm[h1ɂȂAB
		if(!stHuffmanEncoder.TBL_Node[0]) { DIE(); }	//ŏłA(̒l)(I[l)Aꂼ1ȏoĂ̂ŁAeĂȂm[h0ɂȂ邱Ƃ͖͂BŒ~oOłB
		if(!stHuffmanEncoder.TBL_Node[1]) { break; }
		//o񐔂ŏ̃m[h2qm[hƂāAem[h쐬B
		pNode = calloc(1, sizeof(ST_HuffmanNode));	//em[h쐬B
		if(!pNode) { DIE(); }
		pNode->count = stHuffmanEncoder.TBL_Node[0]->count + stHuffmanEncoder.TBL_Node[1]->count;	//E̎qm[h́Ao񐔂vB
		pNode->left  = stHuffmanEncoder.TBL_Node[0];	//em[hɁA̎qm[hi[B
		pNode->right = stHuffmanEncoder.TBL_Node[1];	//em[hɁAE̎qm[hi[B
		stHuffmanEncoder.TBL_Node[0] = pNode;		//̎qm[hLʒuɁAem[hi[B
		stHuffmanEncoder.TBL_Node[1] = NULL;		//E̎qm[hLʒuAɂB
	}
	//m[hJȂAl̕肷B
	HuffmanNode_CodeLen(&stHuffmanEncoder, stHuffmanEncoder.TBL_Node[0], 0);
	//l𕄍̏Ƀ\[gB
	//A0(=o񐔂0)łĺAƂB
	//łꍇ́Al̏ƂB͕̏K{łȂAkɉeȂB
	for(i = 0; i < 257; i++) { stHuffmanEncoder.TBL_ValueOrder[i] = i; }
	qsort_r(stHuffmanEncoder.TBL_ValueOrder, 257, sizeof stHuffmanEncoder.TBL_ValueOrder[0], HuffmanEncoder_CompareValueOrder, &stHuffmanEncoder);
//{{I[Ōɂ鏈
// - DLłAKvłB
//   ܂ł̏̌ʂŁAI[l(256)ATBL_ValueOrder[]̒ōŌ̒lɂȂĂƂ͌ȂłB
// - ܂ł̏̒ŁA\[g̏HvĂARɁ̕тƂ邱Ƃ͓łB
//   ȂȂ΁Ant}؂̐́Aq̏o񐔂̍ZŔr̂ŁAI[l(256)g̏o񐔂ŏ(=1)łĂÃm[hƂ̍ZɂẮA؂̉E[ɗƂ͌ȂłB
// - GKgȕ@͎vtȂ̂ŁADLł͂܂Ant}؂ɁAI[l(256)ƁATBL_ValueOrder[]̒ōŌ̒lƂA邱Ƃɂ܂B
//   DL͂łAGR[_̑̏AfR[_̏ł́AlȂč\܂B
	{
		int j = -1;	//TBL_ValueOrder[]̒ŁAI[l(256)̃CfNXB
		int k = -1;	//TBL_ValueOrder[]̒ōŌɌA0łȂ(=o񐔂0łȂ)l̃CfNXB
		for(i = 0; i < 257; i++) {
			value = stHuffmanEncoder.TBL_ValueOrder[i];
			if(value == 256) { if(j != -1) { DIE(); } j = i; }	//I[l(256)̃CfNX
			if(stHuffmanEncoder.TBL_CodeLen[value]) { k = i; }	//TBL_ValueOrder[]̒ōŌɌA0łȂ(=o񐔂0łȂ)l̃CfNX
		}
		if((j == -1) || (k == -1)) { DIE(); }	//ȂƂ͖͂BŒ~oOłB
		//uI[l(256)vgɁAuTBL_ValueOrder[]̒ōŌɌA0łȂ(=o񐔂0łȂ)lvƂȂĂꍇc
		if(j != k) {	//̔f͕KvłB|C^zɓϐɑ΂āALXor̃ASYŌsƂƁA0ɂȂĂ܂܂B		TODO:̃W[ɂAL̃oOłȂA܂݂ČsƎvB
			//uI[l(256)vƁAuTBL_ValueOrder[]̒ōŌɌA0łȂ(=o񐔂0łȂ)lvƂ́AB
			value = stHuffmanEncoder.TBL_ValueOrder[k];		//TBL_ValueOrder[]̒ōŌɌA0łȂ(=o񐔂0łȂ)l
			stHuffmanEncoder.TBL_CodeLen[value] ^= stHuffmanEncoder.TBL_CodeLen[256];	//
			stHuffmanEncoder.TBL_CodeLen[256]   ^= stHuffmanEncoder.TBL_CodeLen[value];	//
			stHuffmanEncoder.TBL_CodeLen[value] ^= stHuffmanEncoder.TBL_CodeLen[256];	//
			stHuffmanEncoder.TBL_ValueOrder[j]  ^= stHuffmanEncoder.TBL_ValueOrder[k];	//
			stHuffmanEncoder.TBL_ValueOrder[k]  ^= stHuffmanEncoder.TBL_ValueOrder[j];	//
			stHuffmanEncoder.TBL_ValueOrder[j]  ^= stHuffmanEncoder.TBL_ValueOrder[k];	//
		}
	}
//}}I[Ōɂ鏈
	//l̕蓖ĂB
	code = codeLen = 0;
	pValueOrder = stHuffmanEncoder.TBL_ValueOrder;			//l𕄍̏ɑ|C^
	for(;;) {
		value = *pValueOrder++;					//̏ɁAl擾B
		if((codeLenDiff = stHuffmanEncoder.TBL_CodeLen[value] - codeLen)) {	//ωc
			code   <<= codeLenDiff;				//AVtgB
			codeLen += codeLenDiff;				//XVB
		}
		stHuffmanEncoder.TBL_Code[value] = code++;		//l̕i[B֐i߂B
		if(value == 256) { break; }				//I[lȂΔB				//ydvzI[l͐Ɋ܂߂ȂBI[Œő̕ƂAI[𕄍\Ɋ܂߂ȂBĂƂɂāAfR[_\Ō܂ŌĂvȂ΁AI[ƔfłB
		stHuffmanEncoder.TBL_CodeLenCount[codeLen - 1]++;	//蓖Ăꂽl̐𑝂₷B	//
	}
//{{oOô߂̏łBR[h肵폜č\܂B
	//̃ubÑ[v𔲂ɁApValueOrdeŕAI[l(256)̎̃GgwĂB
	//TBL_ValueOrder[]̒ŁAI[l(256)́Ao񐔂0łȂl̍Ō̃Gĝ͂Ȃ̂ŁA(DLɂĂ̂悤ɂ̂)
	//pValueOrdeŕAo񐔂0̒lwĂ邩(o񐔂0̒lLꍇ),,TBL_ValueOrder[]̍Ō̃Gg+1wĂ͂(o񐔂0̒lꍇ)B
	//ȂĂȂ΁A֐̃oOłB
	       if(pValueOrder < &stHuffmanEncoder.TBL_ValueOrder[257]) {
		if(stHuffmanEncoder.TBL_CodeLen[*pValueOrder]) { DIE(); }	//oO
	} else if(pValueOrder > &stHuffmanEncoder.TBL_ValueOrder[257]) {
		DIE();								//oO
	}
//}}oOô߂̏łBR[h肵폜č\܂B
	//--- \o͂鏈 ---
	//\́̕Abitarray_msb1st_getł͂ȂA(codeLenMask+oCgz)ƌȂăANZXBGR[_ƃfR[_ŃANZX@킹ȂƁAoCgz񕔕̏vȂ̂ŒӂB
	dstPos  =  0;
	dstBits = (dstBytes << 3);
	hdr     =  dst;
	//l蓖ĂĂ镄́Arbg}XN쐬B
	codeLenMask = 0;
	for(i = 0; i < 32; i++) {
		codeLenMask <<= 1;					//bit31=1,bit30=2,c,bit1=31,bit0=32
		codeLenMask  |= !!stHuffmanEncoder.TBL_CodeLenCount[i];	//ʃrbgsƂŔAfR[_asmɁuadd %rX,%rX;jruge `vŏ邽߂łB
	}
	//l蓖ĂĂ镄́Arbg}XNo͂B
	if((dstPos + 32) <= dstBits) {
		*(int*)hdr  = codeLenMask;
		       hdr += 4;
	}
	dstPos += 32;
	//Ɋ蓖ĂĂAlo͂B
	pValueOrder = stHuffmanEncoder.TBL_ValueOrder;			//l𕄍̏ɑ|C^
	for(i = 0; i < 32; i++) {
		codeLenCount = stHuffmanEncoder.TBL_CodeLenCount[i];	//蓖Ăꂽl̐擾B
		if(codeLenCount) {					//蓖Ăꂽl̐A0łȂ΁c
			if((dstPos + 8) <= dstBits) {
				*hdr++ = codeLenCount - 1;		//(蓖Ăꂽl̐-1)o͂B		//GR[_(-1)ƃfR[_(+1)EāA(1`256)ɕB
			}
			dstPos += 8;
			do {
				if((dstPos + 8) <= dstBits) {
					value = *pValueOrder;
					*hdr++ = value;			//Ɋ蓖ĂĂlo͂B
				}
				dstPos += 8;
				pValueOrder++;
			} while(--codeLenCount);
		}
	}
	//kf[^́̕Abitarray_msb1st_getŃANZX̂ŁA32bitE܂Ői߂ĂKvLB
	while(dstPos & 31) {
		if((dstPos + 8) <= dstBits) { *hdr++ = 0; }		//\̕ƁAkf[^̃̕Mbv́Aslł\ȂAՂ̂߂ɁA0Ŗ߂ĂƂɂB
		dstPos += 8;
	}
	//--- kf[^o͂鏈 ---
	//l̕o͂B
	for(i = 0; i < srcBytes; i++) {
		value = src[i];
		codeLen = stHuffmanEncoder.TBL_CodeLen[value];
		if(!codeLen) { DIE(); }		//oO
		if((dstPos + codeLen) <= dstBits) {
			code = stHuffmanEncoder.TBL_Code[value];
			bitarray_msb1st_set(dst, dstPos, codeLen, code);
		}
		dstPos += codeLen;
	}
	//I[o͂B
	codeLen = stHuffmanEncoder.TBL_CodeLen[256];
	if((dstPos + codeLen) <= dstBits) {
		code = stHuffmanEncoder.TBL_Code[256];
		bitarray_msb1st_set(dst, dstPos, codeLen, code);
	}
	dstPos += codeLen;
	//fR[_[́Aۂ̕ɂ炸32bit擾̂ŁAI[32bito͂ĂKvB
	// - ȂƁAI[̕32bitɖȂAkf[^TCY𒴂擾Ă܂ꂪB
	//   ۂɂ́AI[̕32bitɖȂslłʂɉe͖AoCgă[hANZX炢ňʕیG[o邱Ƃ͖낤Aɂ͗L蓾B
	//   ȏ̗RAI[32bito͂ĂׂłB
	if(codeLen & 31) {
		codeLen = 32 - (codeLen & 31);
		if((dstPos + codeLen) <= dstBits) {
			bitarray_msb1st_set(dst, dstPos, codeLen, 0);	//I[̗]̃rbǵAslł\ȂAՂ̂߂ɁA0Ŗ߂ĂƂɂB
		}
		dstPos += codeLen;
	}
	//kf[^́̕Abitarray_msb1st_getŃANZX̂ŁA32bitPʂɐ؏グĂKvLB
	// - ̏ŁAI[32bito͂ƂƂ́Aʂ̖ł邱ƂɒӂB
	//   ̏́AfR[_[̓słB
	//   ̏́Abitarray_msb1st_get̓słB
	// - ̏sȂƁȀŏI[32bito͂āAo̓TCY(4N+1)oCgɂȂƂƁAbitarray_msb1st_getA3oCgf[^˂ăANZX邨ꂪB
	//   ۂɂ́A3oCg˂slłʂɉe͖AoCgă[hANZX炢ňʕیG[o邱Ƃ͖낤Aɂ͗L蓾B
	//   ȏ̗RAkf[^32bitPʂɐ؏グĂׂłB
	if(dstPos & 31) {
		codeLen = 32 - (dstPos & 31);
		if((dstPos + codeLen) <= dstBits) {
			bitarray_msb1st_set(dst, dstPos, codeLen, 0);	//kf[^̗]̃rbǵAslł\ȂAՂ̂߂ɁA0Ŗ߂ĂƂɂB
		}
		dstPos += codeLen;
	}
	//o̓oCgԂB
	return dstPos >> 3;
}

