/*	
 *	cliphash.c
 *
 *	[eBeBFnbV֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sat Apr 18 12:02:38 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- lXȃnbV֐邽߂ɁAW[쐬܂B
 *	  ݂̏One-at-a-Time HashL܂񂪁A㑼̃nbV֐ǉ鎞͓W[Ɋ܂߂\łB
 *	- clipcode.hW[MD5,SHA-1,Aclipcrc.hW[CRC8,CRC16,CRC32AnbV֐ł͂̂łA
 *	  ̌vZ@͌X̋KiŌɌ߂ꂽ̂ł̂ŁAW[ֈړ鎖͂Ȃɂ܂B
 *	  W[Ɋ܂߂nbV֐́A܂茵ɋKiĂȂAWebŌJĂASYɂ\łB
 */
#include "clip.h"
/*****************************************************************************
 *	One-at-a-Time Hash
 *****************************************************************************/
#ifndef PIECE
int one_at_a_time_hash(const void* _key, int len) {
	const unsigned char* key = _key;
	unsigned hash = 0;
	goto L_START;
	do {
		hash += *key++;
		hash += hash << 10;
		hash ^= hash >>  6;
L_START:	;
	} while(--len >= 0);
	hash += hash <<  3;
	hash ^= hash >> 11;
	hash += hash << 15;
	return  hash;
}
#else //PIECE
int one_at_a_time_hash(const void* _key, int len);
asm("
		.code
		.align		1
		.global		one_at_a_time_hash
one_at_a_time_hash:
		jp.d		one_at_a_time_hash_START	;//goto L_START
		ld.w		%r9, %r10			;//%r9  := tmp = %r10		*delay*		́uxor %r10,%r9v(%r10=0)ɂeNjbNłBuld.w %r10,0; ld.w %r9,0v1ߏȂčς݂܂B
one_at_a_time_hash_LOOP:					;//do {						
		ld.ub		%r9, [%r12]+			;//  %r9  := tmp = *key++			
		add		%r10, %r9			;//  %r10 := hash += tmp			
		ld.w		%r9, %r10			;//  %r9  := tmp = hash				
		xsll		%r9, 10				;//  %r9  := tmp <<= 10				
		add		%r10, %r9			;//  %r10 := hash += tmp			
		ld.w		%r9, %r10			;//  %r9  := tmp = hash				
		xsrl		%r9,  6				;//  %r9  := tmp >>=  6				
one_at_a_time_hash_START:					;//L_START:					
		sub		%r13, 1				;//  %r13 := len--				
		jrge.d		one_at_a_time_hash_LOOP		;//} while(len >= 0)				
		xor		%r10, %r9			;//  %r10 := hash ^= tmp	*delay*		(%r10=0)ɂȂ܂B
		ld.w		%r9, %r10			;//%r9  := tmp = hash
		xsll		%r9,  3				;//%r9  := tmp <<=  3
		add		%r10, %r9			;//%r10 := hash += tmp
		ld.w		%r9, %r10			;//%r9  := tmp = hash
		xsrl		%r9, 11				;//%r9  := tmp >>= 11
		xor		%r10, %r9			;//%r10 := hash ^= tmp
		ld.w		%r9, %r10			;//%r9  := tmp = hash
		xsll		%r9, 15				;//%r9  := tmp <<= 15
		ret.d						;//return  hash
		add		%r10, %r9			;//%r10 := hash += tmp		*delay*
");
#endif//PIECE
